/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2014 Peter Caspers

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <https://www.quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file noarbsabrabsprobs.cpp
    \brief Absorbtion probabilities in the SABR model
           This file is to be included from noarbsabr.cpp only
           The numbers are taken from
           http://cid-45980dfcc6f0d6c9.skydrive.live.com/self.aspx/.Public/AbsProbs.csv
           For the paper reference see noarbsabr.hpp
*/

#include <ql/experimental/volatility/noarbsabr.hpp>

namespace QuantLib::detail {

extern "C" const unsigned long sabrabsprob[] = {60342,291274,515252,694004,836701,953289,1050056,1132010,1202241,1263153,1316842,1364717,1407266,1446040,1481425,1513334,1543017,1569884,1594948,1618387,1640339,1660694,1679833,1698081,1715036,1731139,1746327,1760919,1774403,1787353,1799707,1811550,1822987,1833783,1844438,1854379,1864056,1873190,1881907,1890509,1898759,1906719,1914318,1921724,1928712,1935493,1942202,1948706,1954863,1961008,1966966,1972750,1978322,1983821,1989159,1994254,1999267,2004184,2008986,2013673,2018192,2022656,2026921,2031190,2035416,2039428,2043404,2047234,2051046,2054654,2058305,2061857,2065374,2068724,2072001,2075235,2078372,2081504,2084519,2087596,2090499,2093278,2096135,2098886,2101682,2104341,2107048,2109666,2112241,2114724,2117227,2119730,2122058,2124426,2126738,2129006,2131172,2133380,2135533,2137616,2139719,2141745,2143837,2145838,2147753,2149686,2151620,2153473,2155308,2157128,2158920,2160702,2162468,2164193,2165904,2167571,2169198,2170869,2172573,2174176,
12148,123121,282483,433350,565404,679824,778977,864809,941135,1007823,1067365,1121192,1169246,1213066,1253347,1290441,1325052,1357146,1386553,1414135,1439884,1463979,1486817,1508228,1528383,1547532,1565708,1583033,1599357,1615128,1630045,1644293,1658125,1671350,1684005,1696243,1707989,1719243,1729998,1740233,1750096,1759695,1769054,1778238,1786925,1795389,1803711,1811602,1819347,1826779,1834108,1841337,1848345,1855008,1861501,1867935,1874178,1880090,1885913,1891709,1897226,1902669,1908083,1913432,1918523,1923581,1928425,1933262,1937909,1942438,1946850,1951110,1955396,1959670,1963700,1967724,1971639,1975516,1979164,1982979,1986656,1990290,1993793,1997260,2000700,2003970,2007274,2010470,2013684,2016774,2019967,2022914,2025983,2028863,2031699,2034488,2037261,2039993,2042695,2045290,2047838,2050411,2052934,2055360,2057827,2060237,2062556,2064873,2067154,2069455,2071644,2073866,2076053,2078211,2080372,2082510,2084572,2086648,2088634,2090672,
3150,60063,172125,294718,411305,517751,612750,697745,773680,841554,903181,958668,1009579,1056376,1098947,1138642,1175654,1210079,1241769,1271812,1299872,1326284,1351307,1374911,1397235,1418498,1438444,1457494,1475655,1493011,1509629,1525589,1540995,1555532,1569587,1583139,1596221,1608848,1621020,1632609,1643697,1654570,1665264,1675574,1685416,1695145,1704328,1713284,1721912,1730358,1738424,1746538,1754361,1761911,1769074,1776213,1783292,1789966,1796644,1803121,1809331,1815658,1821743,1827620,1833320,1839067,1844660,1850000,1855294,1860571,1865603,1870588,1875433,1880215,1884859,1889315,1893684,1898129,1902469,1906658,1910891,1915148,1919193,1923047,1926989,1930738,1934358,1938085,1941728,1945197,1948658,1952138,1955513,1958826,1962150,1965257,1968440,1971548,1974636,1977625,1980584,1983509,1986276,1989109,1991895,1994650,1997409,2000045,2002696,2005258,2007884,2010418,2013000,2015441,2017900,2020328,2022656,2024957,2027272,2029578,
386,19751,81098,166037,256510,346051,430443,508696,580382,646894,707927,764006,815490,863469,907952,949364,988579,1025044,1059170,1091290,1121602,1150415,1177700,1203636,1228099,1251359,1273770,1294981,1314942,1334204,1352809,1370499,1387378,1403704,1419425,1434513,1449121,1463197,1476847,1490107,1502776,1514960,1526896,1538466,1549682,1560629,1571409,1581629,1591564,1601090,1610369,1619432,1628296,1636790,1645433,1653666,1661643,1669499,1677206,1684582,1691815,1699033,1705869,1712750,1719407,1725843,1732271,1738454,1744528,1750500,1756297,1761943,1767510,1773055,1778512,1783705,1788893,1794068,1798987,1803828,1808607,1813330,1817898,1822478,1826902,1831292,1835626,1839873,1844006,1848098,1852245,1856172,1860034,1863825,1867564,1871386,1875011,1878673,1882226,1885757,1889239,1892656,1895992,1899280,1902489,1905671,1908836,1911989,1915044,1918115,1921066,1923998,1926901,1929778,1932562,1935388,1938159,1940852,1943579,1946254,
14,3249,23441,64212,118321,178884,242280,305100,366118,424350,479521,531962,581540,628148,672467,714210,753109,790179,825739,859358,891093,921340,950218,977591,1003997,1029200,1053301,1076646,1099045,1120374,1140689,1160563,1179343,1197912,1215455,1232322,1248904,1264602,1279863,1294701,1308986,1322938,1336358,1349501,1362206,1374591,1386586,1398427,1409844,1420941,1431781,1442209,1452516,1462511,1472288,1481904,1491176,1500224,1509227,1518015,1526676,1534846,1542949,1550802,1558534,1566314,1573678,1581021,1588109,1595052,1601962,1608641,1615286,1621601,1627946,1634114,1640185,1646025,1651887,1657659,1663314,1668837,1674314,1679714,1684953,1690135,1695289,1700360,1705381,1710252,1714959,1719606,1724252,1728805,1733356,1737761,1742143,1746407,1750685,1754817,1758995,1763056,1767124,1771081,1774859,1778630,1782410,1786183,1789972,1793517,1797088,1800615,1804032,1807448,1810880,1814239,1817558,1820714,1823846,1827009,
2,778,8976,31157,65724,108953,157282,208047,258764,309331,358405,405899,451322,494943,537208,576930,614968,651282,686044,719667,751582,782072,811522,839248,866058,891761,916467,940587,963562,985607,1006792,1027459,1047390,1066517,1084942,1102963,1120241,1137059,1153131,1168905,1184224,1199019,1213259,1227246,1241012,1254360,1267257,1279727,1291926,1303786,1315538,1326752,1337633,1348520,1358941,1369329,1379498,1389269,1398805,1408336,1417547,1426387,1435228,1443721,1452018,1460471,1468330,1476164,1483972,1491663,1499246,1506384,1513544,1520429,1527159,1533942,1540540,1547180,1553626,1559944,1566271,1572393,1578304,1584175,1590010,1595715,1601380,1606846,1612253,1617603,1622884,1628071,1633279,1638274,1643320,1648125,1652951,1657554,1662174,1666902,1671451,1676004,1680306,1684607,1688917,1693233,1697420,1701555,1705648,1709690,1713645,1717558,1721426,1725165,1728852,1732434,1735941,1739555,1743161,1746690,
0,108,2403,11245,28677,54066,85554,121308,159598,198848,238744,278735,317963,356219,393947,430305,465533,499678,532502,564285,594788,624612,653145,680417,707184,733045,758045,781870,805107,827592,849268,870324,890995,910927,929805,948431,966387,983777,1000717,1017198,1033233,1048844,1064098,1078847,1093415,1107647,1121417,1134648,1147760,1160386,1172774,1185065,1196716,1208455,1219836,1230712,1241612,1252156,1262479,1272622,1282690,1292367,1301979,1311181,1320288,1329109,1337843,1346400,1355031,1363165,1371356,1379430,1387201,1395027,1402589,1409920,1417150,1424409,1431472,1438281,1444978,1451689,1458334,1464693,1471020,1477411,1483565,1489639,1495788,1501639,1507511,1513198,1518784,1524306,1529703,1535093,1540360,1545629,1550647,1555634,1560691,1565656,1570555,1575472,1580196,1584875,1589485,1594036,1598447,1602912,1607294,1611670,1616061,1620300,1624334,1628410,1632387,1636442,1640442,1644328,
0,5,291,2395,8413,19337,35000,55078,78712,104911,132830,161880,191835,222186,252387,282726,312529,341996,370855,399170,426487,453650,479810,505465,530504,555328,579268,602194,624769,646576,667719,688539,708676,728325,747487,766234,784285,802112,819508,836393,852857,869082,884733,900131,915134,929695,944009,957868,971515,984898,998023,1010940,1023473,1035899,1047904,1059612,1070974,1082214,1093289,1103913,1114444,1124841,1134904,1144940,1154771,1164331,1173951,1183190,1192258,1201098,1209848,1218462,1227003,1235394,1243778,1251960,1259857,1267566,1275252,1282887,1290265,1297665,1304945,1312076,1319016,1325879,1332740,1339449,1346015,1352383,1358789,1365145,1371346,1377523,1383562,1389599,1395407,1401112,1406902,1412466,1418128,1423649,1428974,1434367,1439547,1444887,1450003,1455058,1460093,1465131,1470130,1474998,1479747,1484391,1489013,1493656,1498201,1502677,1507090,1511554,
0,0,11,215,1213,3823,8770,16169,26157,38604,53299,69615,87480,106812,126869,147514,168718,190213,212120,234070,255797,277487,298870,320152,341557,362229,382848,403289,423386,443215,462290,481329,500226,518452,536442,554036,571390,588609,605110,621491,637739,653482,669005,684256,699013,713660,727998,742085,755896,769425,782840,795880,808698,821191,833597,845504,857332,869088,880643,891816,902935,913780,924419,934976,945455,955681,965651,975506,985173,994668,1003995,1013065,1022085,1030925,1039919,1048669,1057156,1065687,1074028,1082310,1090651,1098612,1106470,1114156,1121684,1129180,1136691,1143832,1151018,1158073,1164993,1171815,1178578,1185408,1192031,1198704,1205209,1211680,1218024,1224237,1230324,1236427,1242304,1248267,1254074,1259881,1265519,1271325,1276928,1282459,1288054,1293539,1298939,1304191,1309261,1314457,1319490,1324523,1329497,1334536,
0,0,1,26,199,844,2454,5232,9522,15488,23052,32340,43019,54869,67740,81803,96760,112257,128535,144940,161534,178742,196071,213383,230561,248003,265175,282558,299722,316820,333679,350456,367295,383853,400174,416277,432159,448118,463724,478807,493613,508321,523053,537663,551941,565950,579857,593571,606926,620025,632978,645682,657977,670386,682453,694395,705987,717744,729081,740315,751458,762414,773121,783761,794218,804590,814776,824727,834604,844216,853662,863058,872292,881488,890503,899289,907981,916904,925502,934006,942324,950503,958737,966714,974528,982262,989990,997653,1005158,1012514,1019932,1027035,1034142,1041290,1048313,1055157,1061754,1068382,1075067,1081589,1088171,1094575,1100827,1107228,1113397,1119512,1125493,1131595,1137469,1143302,1149195,1154992,1160827,1166432,1171960,1177396,1182792,1188152,1193590,1198714,
0,0,0,1,16,93,362,999,2258,4189,7166,11050,15874,21644,28382,35871,44305,53527,63445,73844,84712,96218,108098,120095,132621,145287,158306,171663,184987,198383,211786,225188,238928,252362,265806,278993,292386,305648,318859,332179,345070,358171,370851,383788,396479,409106,421544,433908,446099,458124,470093,481834,493413,504910,516441,527726,538833,549788,560787,571680,582042,592698,603053,613103,623018,633092,642988,652689,662360,671862,681118,690250,699460,708563,717526,726381,735094,743621,752057,760466,768813,777257,785544,793701,801778,809789,817792,825519,833166,840636,848012,855248,862671,869746,876907,883961,891024,898041,904894,911563,918138,924804,931454,937956,944281,950678,956954,963200,969367,975462,981507,987486,993264,999169,1005083,1010786,1016578,1022212,1027755,1033383,
0,0,0,0,0,2,15,75,249,577,1139,2069,3384,5191,7464,10214,13551,17379,21753,26700,32193,38051,44432,51193,58400,65945,73935,82280,90558,99089,107767,116948,126152,135441,144890,154514,164357,174076,183946,193819,203633,213579,223568,233595,243758,253794,263741,273826,283920,294056,304047,314011,323754,333508,343388,353061,362708,372140,381613,391138,400698,410005,419153,428309,437338,446340,455192,464182,473055,481831,490470,499049,507803,516322,524672,533033,541405,549513,557609,565674,573583,581701,589294,597111,604866,612490,620113,627774,635114,642513,649727,656995,663940,671058,678137,685209,691969,698695,705495,712161,718840,725283,731803,738260,744662,750960,757312,763525,769651,775856,781870,787868,793803,799814,805620,811352,817075,822747,828472,834164,
0,0,0,0,0,0,0,1,4,27,74,164,297,532,885,1419,2101,2938,4016,5288,6843,8635,10667,12960,15614,18604,21770,25200,28974,32892,36956,41365,45946,50535,55433,60658,66006,71603,77192,82896,88756,94720,101032,107177,113543,120007,126497,133069,139632,146277,153025,159934,166812,173818,180834,187949,194790,201716,208807,215918,223102,230246,237279,244407,251395,258469,265521,272666,279732,286843,293692,300666,307595,314539,321558,328456,335259,342103,348910,355666,362366,369161,375892,382476,389034,395616,402222,408708,415144,421649,428167,434729,441144,447541,453715,460025,466223,472358,478506,484533,490555,496548,502507,508456,514380,520237,526080,531919,537730,543347,549102,554790,560343,565866,571520,576989,582550,588044,593384,598763,
0,0,0,0,0,0,0,0,0,0,0,0,2,5,14,36,71,120,198,295,440,625,901,1236,1601,2080,2657,3230,4007,4879,5806,6867,7968,9251,10652,12177,13818,15541,17384,19236,21382,23515,25704,28089,30555,33185,35920,38659,41543,44513,47544,50710,54002,57299,60705,64066,67553,71112,74800,78582,82382,86203,90102,94167,98193,102209,106306,110251,114592,118750,122906,127107,131382,135776,140156,144535,148870,153383,157839,162320,166818,171193,175653,180084,184621,189164,193650,198151,202900,207422,212001,216440,220927,225688,230152,234699,239239,243867,248410,252956,257489,262085,266759,271374,276032,280606,285162,289830,294338,298805,303318,307766,312258,316711,321120,325614,329964,334429,338794,343233,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,6,7,14,23,41,55,84,110,157,214,289,368,462,589,727,916,1113,1332,1583,1837,2160,2532,2966,3430,3911,4439,5033,5640,6315,7045,7801,8632,9457,10335,11306,12283,13291,14362,15495,16607,17835,19131,20489,21809,23282,24732,26159,27651,29232,30874,32551,34358,36178,37931,39678,41549,43515,45577,47639,49665,51653,53727,55839,57958,60221,62549,64793,67008,69274,71605,73827,76258,78605,81008,83514,86030,88503,91049,93630,96213,98716,101288,103966,106664,109407,112122,114737,117339,120097,122820,125436,128127,130864,133586,136478,139199,142030,144966,147900,150688,153514,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,7,10,13,22,25,36,42,58,80,100,127,154,185,222,266,318,368,429,493,579,673,749,847,969,1096,1213,1349,1511,1691,1861,2044,2261,2471,2707,2954,3209,3490,3785,4083,4418,4760,5116,5483,5871,6279,6688,7112,7568,8022,8494,8963,9471,9977,10505,11046,11642,12246,12899,13536,14218,14855,15497,16231,16945,17670,18416,19148,19969,20767,21610,22437,23259,24152,25037,25947,26839,27757,28699,29638,30591,31629,32613,33627,34629,35670,36751,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,3,3,4,6,9,10,15,17,24,27,30,34,41,44,50,59,71,77,89,98,110,123,137,150,175,191,217,234,259,287,313,335,368,400,432,482,520,556,599,648,695,748,805,868,937,1011,1079,1146,1226,1320,1391,1466,1566,1655,1737,1839,1939,2039,2144,2251,2393,2537,2666,2786,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,4,4,5,5,7,7,7,8,9,11,11,14,14,15,17,17,17,17,21,21,21,23,25,29,31,
64338,298756,522050,699432,840340,954570,1049385,1129679,1198802,1258905,1310872,1357775,1399433,1436885,1471140,1502725,1531593,1558110,1582608,1605248,1626527,1646399,1664778,1682272,1699013,1714588,1729411,1743352,1756546,1769141,1781341,1792719,1803669,1814265,1824239,1834021,1843311,1852277,1860825,1869069,1877141,1884677,1892109,1899435,1906308,1913086,1919558,1925837,1931973,1937932,1943707,1949365,1954784,1960074,1965319,1970395,1975228,1979955,1984511,1989060,1993445,1997792,2002020,2006175,2010171,2014060,2017859,2021515,2025245,2028900,2032439,2035808,2039170,2042400,2045595,2048642,2051644,2054630,2057584,2060605,2063486,2066311,2069038,2071793,2074508,2077147,2079641,2082226,2084648,2087049,2089434,2091750,2094035,2096258,2098451,2100687,2102819,2104855,2106948,2108956,2110956,2112963,2114946,2116928,2118829,2120710,2122537,2124345,2126052,2127829,2129536,2131246,2133010,2134657,2136316,2137941,2139593,2141168,2142721,2144238,
13756,130075,291959,443041,574677,687918,784897,869858,944092,1009361,1067066,1119770,1166504,1209337,1248775,1284578,1317636,1348296,1376696,1403639,1428707,1452074,1474073,1494682,1514365,1533006,1550527,1567178,1583178,1598197,1612524,1626140,1639573,1652351,1664566,1676297,1687548,1698498,1708834,1718649,1728187,1737462,1746556,1755281,1763677,1772006,1779881,1787469,1794858,1802024,1809089,1815831,1822496,1829144,1835405,1841485,1847375,1853215,1858862,1864333,1869714,1875097,1880207,1885266,1890172,1894939,1899476,1904033,1908594,1913066,1917334,1921597,1925735,1929832,1933708,1937566,1941406,1945064,1948722,1952385,1955903,1959384,1962845,1966171,1969472,1972637,1975784,1978943,1982019,1985053,1987928,1990746,1993560,1996259,1999145,2001909,2004615,2007177,2009831,2012415,2014963,2017389,2019759,2022202,2024521,2026806,2029176,2031369,2033567,2035705,2037867,2040023,2042135,2044183,2046278,2048206,2050151,2052092,2053982,2055930,
3765,66033,182417,307397,424445,530151,624025,707461,781608,847805,907687,962228,1011647,1056985,1098185,1136620,1172121,1205309,1236041,1264868,1291916,1317529,1341497,1364300,1385550,1405848,1425369,1443860,1461170,1477762,1493774,1509049,1523602,1537804,1551315,1564449,1577155,1589169,1600860,1611981,1622808,1633124,1643075,1653080,1662581,1671748,1680526,1689171,1697503,1705500,1713091,1720692,1728204,1735523,1742546,1749444,1756133,1762639,1769066,1775209,1781196,1787225,1793134,1798799,1804332,1809820,1815183,1820217,1825248,1830183,1835060,1839826,1844450,1849089,1853565,1857939,1862212,1866437,1870568,1874576,1878570,1882630,1886484,1890278,1894007,1897689,1901283,1904855,1908238,1911622,1914979,1918170,1921416,1924589,1927722,1930779,1933802,1936780,1939775,1942697,1945466,1948278,1951037,1953845,1956488,1959067,1961697,1964259,1966765,1969231,1971686,1974059,1976441,1978733,1981049,1983290,1985608,1987813,1990008,1992240,
501,23560,89782,177904,270394,360176,444235,521619,593349,658562,718281,773169,823923,870359,913938,954291,991755,1026992,1059581,1090868,1120062,1147565,1173745,1198517,1222178,1244431,1265760,1286209,1305358,1323601,1341391,1358556,1374781,1390455,1405455,1420099,1433998,1447558,1460478,1473095,1485253,1496984,1508270,1519278,1530082,1540462,1550427,1560176,1569534,1578787,1587680,1596370,1604848,1613082,1621124,1629071,1636696,1644086,1651456,1658546,1665550,1672294,1678873,1685249,1691608,1697717,1703822,1709654,1715466,1721041,1726619,1731982,1737299,1742525,1747599,1752617,1757481,1762376,1767067,1771650,1776097,1780585,1785001,1789396,1793600,1797773,1801785,1805846,1809732,1813662,1817585,1821293,1824951,1828666,1832208,1835632,1839110,1842538,1845969,1849339,1852587,1855781,1859035,1862225,1865344,1868302,1871308,1874344,1877309,1880178,1882971,1885685,1888429,1891130,1893811,1896445,1899057,1901689,1904206,1906659,
15,4453,28719,74008,131940,195342,260069,323463,384692,443256,498256,550151,598287,644019,687247,727318,765425,801226,835427,868041,898891,927993,955831,982297,1007582,1031660,1054692,1076953,1098097,1118234,1137676,1156570,1174315,1191734,1208679,1224775,1240535,1255804,1270382,1284619,1298251,1311400,1324028,1336519,1348715,1360656,1372064,1383275,1394127,1404455,1414685,1424700,1434686,1444193,1453388,1462488,1471296,1479939,1488268,1496418,1504304,1512319,1519948,1527409,1534636,1541888,1549019,1555760,1562483,1569107,1575490,1581784,1587985,1593954,1599780,1605702,1611481,1617091,1622611,1628074,1633382,1638515,1643615,1648649,1653740,1658777,1663632,1668454,1672995,1677485,1681916,1686379,1690681,1694928,1699060,1703226,1707298,1711288,1715262,1719205,1723042,1726799,1730506,1734200,1737888,1741558,1745094,1748602,1752129,1755482,1758756,1762026,1765240,1768553,1771741,1774870,1777871,1780827,1783968,1786997,
1,1274,11906,38070,76562,123213,174202,226517,278115,329080,378631,426133,471690,515159,556541,595828,633499,669143,702804,734679,765514,794819,823091,849793,875707,900708,924672,947511,969425,990352,1010546,1030058,1048823,1067122,1084752,1101662,1117988,1134095,1149318,1164203,1178708,1192693,1206398,1219741,1232499,1245028,1257263,1268904,1280638,1291749,1302798,1313325,1323682,1333684,1343486,1353193,1362584,1371870,1380840,1389787,1398398,1406738,1414974,1422891,1430823,1438436,1446107,1453509,1460973,1468137,1475186,1481997,1488740,1495315,1501639,1507884,1513938,1520124,1526072,1531941,1537669,1543217,1548899,1554357,1559878,1565123,1570367,1575524,1580526,1585376,1590450,1595332,1600029,1604738,1609303,1613895,1618369,1622769,1627038,1631339,1635755,1639958,1644034,1648212,1652216,1656118,1659986,1663807,1667571,1671249,1674890,1678556,1682139,1685620,1689090,1692545,1695907,1699264,1702643,1705882,
1,220,3585,15169,36295,65469,100714,139307,179465,220942,262407,303045,342633,381404,418998,455338,490304,523947,556315,587582,617170,646248,673960,700517,726203,750768,774834,797691,820017,841537,862253,882387,901926,920735,938992,956563,973779,990252,1006133,1021697,1036777,1051383,1065742,1079786,1093578,1106702,1119652,1132182,1144517,1156594,1168142,1179405,1190550,1201309,1212125,1222323,1232443,1242127,1251752,1261257,1270405,1279424,1288395,1297042,1305546,1313692,1321890,1330016,1337932,1345611,1353341,1360695,1368009,1375183,1382241,1389169,1396105,1402747,1409322,1415742,1421976,1428131,1434172,1440347,1446282,1452141,1457768,1463468,1469019,1474503,1479901,1485260,1490459,1495484,1500548,1505542,1510401,1515179,1519916,1524585,1529106,1533596,1538130,1542535,1546734,1551132,1555346,1559590,1563824,1567907,1572036,1576067,1580008,1583923,1587797,1591586,1595268,1598989,1602577,1606199,
0,13,626,4008,12202,26425,45474,69153,96094,124937,155239,186346,217801,249228,280230,311019,341377,371050,400114,428631,455968,482287,508281,533423,557789,581576,604745,627005,648721,669808,689997,710049,729331,748142,766660,784784,802286,819332,835903,851881,867652,882836,897624,912038,926012,939778,953138,966169,979110,991781,1003920,1015760,1027512,1039009,1050197,1061141,1072058,1082761,1093051,1103001,1112786,1122492,1131970,1141057,1150028,1158895,1167594,1176234,1184780,1193124,1201212,1209185,1216996,1224799,1232375,1239880,1247229,1254444,1261643,1268697,1275592,1282395,1289052,1295590,1301972,1308342,1314617,1320736,1326728,1332740,1338643,1344403,1350131,1355784,1361305,1366788,1372258,1377625,1382944,1388158,1393094,1398127,1403094,1408117,1412999,1417600,1422446,1427052,1431697,1436339,1440857,1445277,1449748,1454084,1458199,1462422,1466591,1470780,1474896,1478819,
0,0,44,519,2366,6498,13597,23917,37078,52450,70038,89270,109471,130809,152972,175639,198417,221285,244417,267543,290226,312678,334759,356600,377726,398644,419527,439917,459803,479286,498332,516873,535240,553204,570627,587542,604267,620786,636618,652182,667768,682802,697561,712100,726276,740104,753575,767125,779974,792712,805344,817569,829606,841356,852946,864301,875350,886197,897010,907524,917854,927911,937728,947531,957267,966644,975823,984988,993927,1002818,1011530,1019999,1028390,1036642,1044868,1053005,1060687,1068381,1075930,1083487,1090988,1098347,1105614,1112688,1119646,1126569,1133351,1140063,1146565,1153140,1159394,1165692,1172050,1178134,1184235,1190231,1195960,1201797,1207602,1213139,1218788,1224328,1229731,1235087,1240321,1245608,1250743,1256036,1261268,1266257,1271233,1276128,1281058,1285979,1290755,1295345,1300046,1304522,1308989,1313450,
0,0,3,85,545,1875,4630,9215,15846,24503,34821,46799,60081,74787,90580,107085,124279,141649,159508,177905,196187,214689,233077,251098,269094,287334,305192,323343,340650,357840,374939,392023,408761,425647,441659,457654,473365,489016,504290,519176,533870,548400,562580,576555,590167,603617,616628,629912,642487,654943,667096,679244,691100,702779,714218,725323,736375,747424,758246,768796,779299,789614,799543,809442,819205,828844,838163,847265,856424,865394,874263,882924,891385,899907,908187,916579,924624,932636,940473,948262,955850,963283,970810,978035,985217,992384,999576,1006561,1013462,1020140,1026879,1033402,1039924,1046344,1052749,1059003,1065176,1071360,1077250,1083146,1088940,1094830,1100539,1106231,1111731,1117344,1122899,1128302,1133790,1139093,1144389,1149522,1154728,1159719,1164767,1169788,1174747,1179550,1184309,1189087,
0,0,0,8,57,306,1015,2469,4943,8540,13316,19293,26530,34710,44083,54113,65061,76757,88906,101620,114866,128204,142236,156365,170384,184496,199022,213436,227766,242279,256546,270774,284926,299075,312965,326763,340376,354116,367638,380915,394116,407284,420174,432892,445594,458032,470342,482413,494474,506195,517657,529018,540344,551614,562546,573268,584060,594674,604951,615299,625482,635508,645389,654979,664690,674404,683631,692841,701760,710744,719554,728082,736738,745201,753590,761863,769905,777807,785596,793500,801102,808804,816412,823892,831357,838573,845808,853031,859915,866763,873671,880347,886953,893511,900012,906512,913045,919247,925415,931498,937622,943483,949471,955395,961190,966953,972666,978278,984028,989557,994933,1000298,1005610,1010775,1016146,1021268,1026462,1031557,1036614,1041627,
0,0,0,0,1,21,98,348,858,1843,3335,5395,8117,11613,15603,20365,25833,31924,38548,45604,53335,61564,70163,79143,88234,97821,107599,117735,127813,138226,148779,159292,169876,180606,191454,202203,212758,223584,234354,245322,256161,267079,278009,288830,299375,309918,320339,330971,341299,351586,361873,371944,381955,391640,401488,411310,420948,430404,439904,449159,458544,467871,476900,486012,494953,503719,512300,520843,529211,537886,546256,554455,562528,570707,578689,586603,594334,601999,609680,617320,624845,632370,639773,647242,654314,661437,668445,675510,682373,689296,695948,702700,709321,715980,722550,729002,735295,741699,747969,754165,760297,766467,772467,778518,784402,790234,795976,801679,807211,812882,818287,823855,829267,834787,840156,845437,850652,855833,860979,866176,
0,0,0,0,0,2,8,20,57,132,332,707,1304,2084,3154,4542,6254,8329,10708,13549,16774,20302,24223,28463,32890,37670,42780,48328,53911,59677,65673,71947,78416,85147,92010,99089,106202,113594,120760,128167,135636,143127,150619,158331,166067,173706,181503,189113,197027,204858,212740,220490,228369,236255,243922,251752,259486,267170,274890,282539,290121,297668,305210,312744,320198,327533,334889,342326,349734,356895,364079,371319,378533,385625,392738,399790,406710,413548,420594,427373,434027,440653,447342,453929,460594,467250,473740,480252,486524,492993,499245,505480,511547,517749,523781,529786,535827,541652,547398,553103,558916,564588,570330,576179,581764,587403,593024,598568,604016,609464,614846,620075,625423,630624,635871,641027,646127,651149,656130,661209,
0,0,0,0,0,0,0,0,0,3,10,33,75,133,229,393,618,942,1375,1867,2529,3293,4202,5348,6572,7957,9605,11355,13284,15392,17638,20001,22586,25327,28234,31352,34538,37762,41302,44952,48604,52362,56327,60435,64538,68758,73114,77669,82191,86856,91494,96191,100964,105823,110663,115638,120629,125588,130677,135706,140903,146015,151217,156304,161524,166798,171997,177139,182308,187519,192880,198081,203389,208595,213787,219139,224352,229605,234786,240153,245330,250455,255687,260923,266097,271258,276298,281423,286476,291562,296695,301742,306748,311763,316697,321719,326716,331654,336584,341443,346437,351223,356070,360769,365629,370337,375159,379944,384668,389323,393976,398686,403306,407915,412457,417034,421593,426112,430625,435031,
0,0,0,0,0,0,0,0,0,0,0,0,0,3,6,12,28,45,68,119,202,298,416,563,767,1017,1264,1584,1952,2406,2891,3476,4126,4916,5711,6624,7601,8681,9803,10993,12292,13589,15052,16578,18184,19805,21572,23452,25386,27343,29382,31464,33620,35950,38261,40506,42793,45259,47814,50420,53145,55815,58528,61313,64187,66993,69880,72831,75964,78971,81997,84981,88012,91132,94421,97668,100884,104095,107438,110812,114148,117441,120760,124121,127568,130942,134363,137851,141365,144800,148198,151640,154964,158423,162005,165490,168968,172506,175934,179415,182979,186455,189911,193453,196929,200540,203915,207395,210881,214378,217983,221393,224991,228567,232066,235536,239055,242504,246046,249529,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,5,12,14,27,38,65,88,124,177,225,279,345,434,558,686,827,979,1160,1361,1573,1818,2112,2391,2697,3044,3409,3842,4275,4755,5287,5843,6415,7014,7690,8346,9001,9744,10499,11257,12096,12940,13852,14767,15731,16670,17677,18740,19843,20980,22116,23313,24526,25695,26971,28300,29601,30954,32334,33744,35138,36586,38065,39557,41006,42541,44078,45644,47203,48786,50404,52066,53829,55558,57255,58905,60649,62372,64148,66000,67912,69699,71535,73406,75307,77223,79205,81148,83076,85042,86970,88866,90877,92789,94856,96827,98835,100728,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,4,5,8,13,18,20,30,36,50,58,72,91,108,132,161,189,225,258,294,340,388,454,504,565,630,712,798,907,1014,1133,1249,1371,1508,1642,1765,1943,2098,2274,2456,2658,2854,3061,3273,3517,3730,3976,4228,4509,4770,5062,5367,5645,5939,6272,6649,6980,7334,7718,8116,8476,8851,9306,9682,10119,10567,11006,11505,12002,12507,13012,13532,14119,14651,15215,15759,16329,16865,17435,18015,18623,19290,19941,20560,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,5,5,5,7,11,13,18,21,22,25,29,34,37,44,51,62,67,75,84,103,115,126,142,151,166,182,190,213,228,242,262,288,309,334,363,394,417,459,484,509,547,581,615,649,690,732,776,835,870,914,961,1013,1065,
68404,306989,529315,704189,842622,955809,1048857,1127788,1195451,1254168,1305343,1350773,1391780,1428709,1462218,1492668,1520871,1546579,1570492,1592812,1613660,1632894,1651038,1667956,1684187,1699418,1713628,1727210,1740054,1752390,1764179,1775389,1786289,1796584,1806483,1816095,1825100,1833903,1842217,1850121,1857951,1865506,1872763,1879824,1886530,1893096,1899517,1905566,1911392,1917265,1922875,1928442,1933720,1938873,1943987,1948780,1953479,1958011,1962410,1966861,1971141,1975282,1979301,1983293,1987262,1991071,1994766,1998356,2001963,2005468,2008851,2012119,2015391,2018733,2021775,2024802,2027840,2030698,2033590,2036401,2039094,2041874,2044531,2047230,2049847,2052381,2054854,2057281,2059702,2062034,2064316,2066615,2068817,2071063,2073219,2075325,2077401,2079454,2081547,2083663,2085584,2087480,2089398,2091267,2093112,2094858,2096636,2098425,2100158,2101868,2103566,2105244,2106876,2108518,2110109,2111682,2113292,2114846,2116295,2117857,
15514,137846,302269,453393,583523,694691,790094,873045,945988,1009815,1066471,1117385,1163453,1204993,1243188,1278070,1310469,1340294,1368016,1394325,1418461,1441280,1462508,1482693,1501712,1519885,1537009,1553196,1568690,1583266,1597272,1610603,1623313,1635576,1647389,1658554,1669613,1680207,1690273,1699716,1709095,1718139,1726781,1735212,1743565,1751580,1759257,1766618,1773857,1780901,1787586,1794242,1800539,1806946,1813118,1818935,1824664,1830237,1835719,1841002,1846271,1851351,1856392,1861255,1865962,1870596,1875231,1879567,1884043,1888336,1892311,1896342,1900247,1904202,1908005,1911724,1915332,1918982,1922469,1926001,1929457,1932810,1936094,1939297,1942549,1945676,1948694,1951688,1954608,1957448,1960250,1962997,1965742,1968405,1971099,1973709,1976303,1978843,1981372,1983865,1986287,1988701,1991067,1993406,1995742,1997872,2000085,2002259,2004408,2006530,2008510,2010579,2012611,2014643,2016629,2018568,2020475,2022343,2024258,2026059,
4588,71767,192447,319016,435696,540155,632778,715177,788188,853176,911494,964453,1012713,1056681,1097095,1134291,1168857,1201106,1231155,1259311,1285677,1310682,1333956,1355795,1376401,1396132,1414841,1432617,1449279,1465599,1481075,1495822,1509803,1523385,1536550,1549156,1561208,1572848,1584159,1594810,1605179,1615168,1624873,1634333,1643537,1652416,1660882,1669246,1677199,1685012,1692682,1700103,1707265,1714304,1720990,1727546,1734006,1740091,1746240,1752264,1758025,1763796,1769378,1774840,1780131,1785312,1790405,1795274,1800266,1805036,1809639,1814235,1818675,1823056,1827353,1831535,1835730,1839817,1843797,1847743,1851518,1855333,1858945,1862607,1866159,1869735,1873133,1876439,1879763,1883105,1886345,1889490,1892424,1895451,1898378,1901385,1904167,1907005,1909894,1912783,1915570,1918327,1920974,1923625,1926275,1928754,1931280,1933713,1936139,1938564,1940882,1943211,1945484,1947689,1949932,1952089,1954263,1956387,1958524,1960590,
720,27255,98256,189264,283225,373456,457319,534491,604946,669045,727698,781230,830407,875942,918195,957522,994015,1028243,1060442,1090313,1118506,1145158,1170510,1194399,1216733,1238477,1259106,1278718,1297169,1314925,1332190,1348802,1364453,1379665,1394021,1407849,1421507,1434468,1447106,1459108,1471016,1482051,1492771,1503402,1513617,1523557,1533323,1542750,1551739,1560516,1568941,1577316,1585400,1593280,1600958,1608601,1615856,1623060,1630132,1637054,1643701,1650198,1656501,1662700,1668726,1674697,1680531,1686148,1691575,1697018,1702312,1707445,1712420,1717242,1722197,1726920,1731586,1736151,1740701,1745036,1749361,1753564,1757783,1761817,1765853,1769857,1773820,1777627,1781488,1785204,1788822,1792390,1795971,1799411,1802921,1806350,1809722,1812931,1816281,1819517,1822616,1825709,1828838,1831817,1834786,1837710,1840527,1843362,1846234,1848964,1851682,1854364,1856930,1859484,1862003,1864540,1867032,1869533,1872052,1874463,
32,5758,33658,83076,144104,209908,276342,340409,401761,459665,513967,564899,612480,657309,699509,738828,776027,811038,844304,875622,905317,933835,960667,986299,1010840,1033923,1056255,1077574,1097995,1117356,1136069,1153990,1171319,1188063,1204164,1219726,1234639,1249202,1262958,1276458,1289524,1302126,1314411,1326201,1337810,1349138,1360129,1370847,1381397,1391175,1400986,1410420,1419746,1428891,1437688,1446313,1454577,1462723,1470608,1478461,1486011,1493493,1500746,1507811,1514843,1521643,1528381,1534865,1541314,1547715,1553838,1559843,1565717,1571369,1577087,1582495,1587791,1593163,1598430,1603627,1608793,1613826,1618700,1623392,1628029,1632554,1637163,1641741,1646303,1650631,1654988,1659175,1663321,1667519,1671439,1675408,1679187,1682995,1686763,1690326,1694057,1697740,1701126,1704639,1708058,1711479,1714804,1718107,1721312,1724637,1727790,1730924,1733986,1737062,1740060,1742956,1745946,1748830,1751636,1754465,
6,1807,15167,44996,87769,137318,190448,244125,297350,348914,398625,445904,490795,533875,574459,613153,649624,684028,717070,748371,778158,806671,834029,860254,885313,909191,932017,954030,974932,995260,1014511,1033126,1051288,1068680,1085511,1101782,1117569,1132559,1147158,1161547,1175244,1188640,1201562,1214192,1226308,1238223,1249868,1261097,1272209,1282813,1293230,1303305,1313311,1322898,1332214,1341264,1350150,1358926,1367434,1375864,1383989,1392043,1399853,1407551,1414869,1422034,1429138,1435988,1443083,1449673,1456370,1462804,1469120,1475381,1481415,1487338,1493323,1499138,1504797,1510348,1515791,1521236,1526530,1531817,1536898,1541853,1546690,1551583,1556377,1561191,1565839,1570434,1574831,1579250,1583616,1587902,1592191,1596259,1600413,1604446,1608243,1612209,1616040,1619843,1623653,1627482,1631214,1634826,1638315,1641832,1645352,1648826,1652265,1655635,1658858,1662061,1665345,1668437,1671535,1674646,
0,363,4998,19458,44390,77159,115624,156870,199016,241637,284023,325273,365208,403814,441182,476729,511380,544522,576171,606422,635694,663941,690817,716685,741652,765630,788657,810913,832389,853055,873079,892277,911158,929135,946528,963371,979610,995416,1010618,1025596,1039993,1053847,1067614,1081037,1094058,1106576,1118903,1130842,1142486,1153856,1164950,1175705,1186145,1196447,1206328,1215859,1225552,1234692,1243766,1252727,1261357,1270080,1278371,1286446,1294472,1302173,1309884,1317492,1324952,1332078,1339125,1346222,1353105,1359886,1366454,1372948,1379444,1385718,1391880,1397911,1403890,1409733,1415439,1421152,1426678,1432122,1437499,1442890,1448080,1453228,1458294,1463297,1468136,1472949,1477524,1482277,1486931,1491443,1495920,1500355,1504674,1508963,1513192,1517399,1521394,1525481,1529538,1533496,1537435,1541285,1545026,1548775,1552427,1556076,1559752,1563305,1566764,1570261,1573659,1577131,
0,35,1037,5835,16496,33723,56182,82733,111973,143096,175319,207982,240320,272742,304553,335615,366657,396449,425662,453378,480424,506768,532146,556942,581039,604321,626919,648640,669708,690037,709719,728956,747490,765752,783405,800569,817218,833501,848973,864463,879312,893759,907709,921528,935031,948145,961024,973506,985368,997253,1008881,1020262,1031040,1041822,1052469,1062908,1073125,1083115,1092684,1102265,1111530,1120679,1129565,1138103,1146773,1155238,1163579,1171735,1179551,1187316,1194885,1202441,1209892,1217167,1224306,1231330,1238240,1244951,1251519,1258123,1264691,1271056,1277428,1283524,1289606,1295542,1301364,1307156,1312845,1318419,1323836,1329261,1334666,1340160,1345297,1350460,1355470,1360536,1365512,1370365,1375011,1379647,1384194,1388751,1393263,1397717,1402129,1406491,1410755,1415016,1419348,1423490,1427565,1431579,1435555,1439436,1443332,1447156,1450996,1454759,
0,0,102,965,3791,9839,19501,32369,48270,66541,86765,108120,130631,154043,177726,201883,225805,249912,273900,297629,320709,343352,365672,387322,408632,429348,449773,469818,489319,508555,527064,545140,563020,580390,597337,614009,630419,646210,661771,676844,691520,705922,720051,733836,747341,760650,773523,786094,798442,810457,822414,834008,845524,856749,867895,878658,888921,899359,909392,919325,928910,938436,947731,956806,965918,974698,983374,991967,1000323,1008450,1016709,1024751,1032631,1040269,1047975,1055539,1062719,1070006,1077136,1084097,1091061,1098154,1104850,1111430,1117928,1124407,1130903,1137188,1143438,1149589,1155457,1161240,1167084,1172867,1178433,1183818,1189193,1194616,1199937,1205221,1210431,1215614,1220654,1225755,1230693,1235454,1240298,1245114,1249841,1254519,1259180,1263730,1268121,1272492,1277013,1281525,1285768,1290042,1294184,1298212,
0,0,12,200,1054,3306,7595,14103,22866,33908,46833,61259,76908,93547,111331,129662,148469,167453,186717,206116,225733,245146,264425,283212,302056,320603,338810,356977,374738,392298,409651,426484,443178,459424,475446,491367,506709,521969,536796,551279,565588,579571,593333,607104,620221,633129,645994,658381,670543,682577,694459,705975,717293,728444,739400,749919,760287,770726,780757,790799,800561,810269,820030,829416,838597,847527,856386,864914,873574,882021,890116,898344,906472,914509,922341,930015,937630,945084,952430,959696,966829,973909,980875,987697,994458,1001115,1007647,1014246,1020702,1026986,1033191,1039250,1045278,1051137,1056996,1062781,1068542,1074120,1079652,1085136,1090532,1095919,1101246,1106497,1111681,1116784,1121915,1126908,1131954,1136803,1141629,1146550,1151262,1156068,1160664,1165332,1169890,1174350,1178742,1183073,
0,0,1,25,185,781,2157,4569,8455,13805,20543,28587,37870,48092,59569,71890,84902,98598,112798,127192,141832,156910,172203,187411,202600,217935,233403,248429,263511,278410,293294,308018,322668,337224,351514,365468,379459,393277,406881,420116,433246,446249,458938,471419,483956,496190,508258,519932,531749,543154,554367,565529,576608,587556,598101,608506,618716,628805,638702,648449,658282,667918,677230,686540,695793,704918,713800,722603,731169,739634,748111,756251,764386,772293,780247,788193,795749,803174,810556,817925,825190,832339,839420,846396,853370,860247,867128,873690,880334,886763,893030,899270,905630,911735,917764,923651,929612,935360,941209,946922,952528,958037,963533,969014,974438,979672,984877,990076,995379,1000407,1005451,1010397,1015209,1020038,1024900,1029708,1034468,1039184,1043784,1048395,
0,0,0,0,15,92,351,912,2021,3800,6346,9778,14203,19283,25187,31828,39104,46907,55368,64546,74122,84218,94541,105078,115986,126843,137968,149282,160751,172402,184033,195634,207211,218733,230258,241870,253458,264659,276263,287506,298939,310081,321028,332023,342889,353712,364368,375029,385635,395971,406159,416253,426285,436271,446042,455686,465287,474591,483989,493260,502363,511389,520176,529016,537703,546308,554745,563082,571333,579540,587623,595632,603471,611073,618847,626463,633859,641357,648557,655799,662938,670042,676916,683984,690902,697646,704167,710681,717301,723640,729910,736287,742562,748782,754917,761044,766945,772941,778797,784502,790061,795686,801344,806895,812436,817869,823238,828701,833839,838900,844107,849281,854347,859364,864229,869090,874083,878767,883542,888111,
0,0,0,0,1,7,30,101,260,589,1141,1997,3171,4799,6855,9460,12391,15707,19705,24109,28906,34010,39568,45426,51714,58244,65087,72036,79144,86537,94179,102028,109928,118034,126118,134395,142739,151141,159378,167686,176106,184790,193186,201684,210300,218848,227305,235726,244065,252335,260825,269172,277543,285746,293873,301983,310139,318274,326163,334110,342040,349848,357642,365469,372877,380554,388015,395379,402783,410164,417402,424655,431858,438981,446044,452929,459735,466556,473514,480135,486738,493141,499614,506058,512580,518918,525275,531462,537501,543530,549621,555647,561507,567413,573210,579030,584783,590434,596024,601560,607158,612668,618045,623521,628992,634435,639815,644967,649999,655125,660226,665264,670275,675155,680043,684824,689575,694294,699044,703714,
0,0,0,0,0,0,0,0,8,28,77,166,316,544,912,1388,2074,2865,3829,5039,6480,8168,10060,12167,14463,17043,19802,22880,26240,29603,33250,37194,41193,45315,49580,53991,58600,63330,68116,72926,77982,83187,88346,93733,99065,104427,109956,115592,121189,126892,132639,138207,143873,149677,155583,161317,167031,172764,178586,184485,190417,196307,202139,207994,213820,219840,225797,231490,237262,243028,248811,254612,260430,266207,271787,277385,283104,288691,294251,299911,305635,310986,316344,321760,327244,332555,338047,343380,348718,353755,358998,364398,369632,374773,379886,384942,389922,394951,399919,404810,409797,414680,419540,424193,429055,433896,438710,443376,448101,452772,457304,461868,466404,470948,475358,479780,484212,488600,492950,497322,
0,0,0,0,0,0,0,0,0,0,0,8,13,37,62,103,177,274,428,650,912,1261,1687,2156,2773,3429,4195,5131,6115,7176,8396,9695,11156,12708,14384,16154,18164,20048,22117,24312,26574,28991,31427,34045,36789,39545,42348,45300,48326,51362,54438,57604,60810,64035,67423,70803,74343,77942,81482,85172,88932,92653,96356,100086,103863,107588,111456,115452,119327,123212,127207,131117,135133,139118,143037,147000,150925,154900,158802,162865,166963,170932,175007,178946,183093,187100,191105,195108,199069,202982,206966,210906,214891,218769,222732,226728,230646,234670,238636,242667,246718,250545,254393,258371,262269,266100,269954,273834,277674,281502,285250,289071,292692,296339,300059,303885,307672,311349,315075,318854,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,16,24,40,62,86,138,190,253,319,423,565,699,887,1093,1343,1595,1900,2252,2650,3094,3611,4123,4677,5324,5974,6699,7435,8233,9086,10016,10964,12009,13054,14151,15335,16494,17709,18894,20218,21606,23075,24577,26074,27663,29288,30897,32485,34235,35983,37832,39679,41476,43298,45255,47162,49104,51133,53218,55267,57401,59505,61591,63762,65915,68224,70455,72742,75140,77343,79689,82005,84361,86724,89160,91590,93923,96260,98600,101041,103485,105935,108386,110868,113387,115849,118323,120816,123329,125810,128316,130821,133330,135771,138292,140851,143305,145832,148503,151100,153777,156397,158994,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,3,3,3,6,7,14,22,33,44,57,68,84,115,145,184,215,252,299,357,416,494,565,652,776,888,1032,1177,1341,1518,1723,1911,2094,2300,2549,2811,3089,3400,3703,4019,4369,4749,5095,5454,5879,6317,6751,7200,7693,8166,8662,9216,9746,10315,10903,11493,12132,12725,13403,14096,14745,15450,16164,16887,17631,18390,19154,19945,20802,21642,22465,23294,24237,25217,26154,27105,28020,29016,29977,30939,31876,32876,33873,34877,35927,37004,38080,39121,40227,41375,42520,43629,44775,45958,47081,48211,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,4,4,8,9,9,11,12,12,16,22,28,33,38,44,56,64,74,85,97,108,120,136,154,176,200,223,245,270,301,330,362,403,439,475,520,556,599,648,688,742,798,859,937,999,1086,1167,1242,1329,1405,1492,1581,1679,1792,1904,2014,2123,2241,2374,2491,2627,2766,2902,3071,3213,3373,3533,3691,3850,4029,4196,4387,4589,4767,4938,
72508,314223,536524,709744,846903,957927,1049752,1127172,1193472,1250933,1301082,1345679,1385457,1421296,1454187,1484007,1511676,1536871,1560069,1581733,1602047,1621028,1638675,1655527,1671423,1686398,1700352,1713765,1726238,1738252,1749750,1760507,1770810,1780973,1790615,1799827,1808718,1817238,1825479,1833303,1840768,1848030,1855169,1862008,1868454,1874934,1881234,1887090,1892942,1898397,1903818,1909211,1914436,1919517,1924357,1929143,1933805,1938204,1942605,1946850,1951057,1955211,1959196,1963050,1966915,1970634,1974119,1977644,1981166,1984548,1987786,1990989,1994271,1997370,2000490,2003403,2006285,2009218,2011921,2014741,2017404,2020087,2022803,2025464,2028024,2030566,2032941,2035217,2037502,2039842,2042099,2044278,2046442,2048560,2050710,2052784,2054869,2056907,2058910,2060906,2062871,2064670,2066553,2068402,2070246,2071934,2073670,2075351,2077067,2078807,2080474,2082065,2083734,2085303,2086875,2088434,2089976,2091472,2092961,2094394,
17565,145475,311841,462980,592050,701982,796151,877673,949059,1011629,1066495,1116201,1161418,1202099,1239045,1273026,1304505,1333701,1360851,1386188,1409905,1431820,1452595,1472003,1490518,1508051,1524632,1540536,1555355,1569494,1583123,1595987,1608357,1620293,1631743,1642766,1653517,1663826,1673656,1682956,1691859,1700629,1709064,1717262,1725349,1733203,1740538,1747738,1754718,1761488,1768035,1774485,1780751,1786774,1792765,1798521,1804110,1809520,1814766,1820019,1825164,1830046,1834835,1839693,1844229,1848637,1853036,1857329,1861499,1865718,1869709,1873668,1877394,1881175,1884896,1888539,1892049,1895533,1898961,1902266,1905628,1908894,1912139,1915292,1918415,1921396,1924415,1927243,1930049,1932812,1935656,1938380,1941080,1943674,1946296,1948861,1951407,1953894,1956267,1958729,1961115,1963466,1965743,1967963,1970240,1972350,1974452,1976621,1978697,1980751,1982734,1984763,1986806,1988704,1990591,1992499,1994434,1996292,1998139,1999994,
5521,77927,202166,330200,446657,550621,641998,723068,795256,859153,915987,967806,1014870,1057803,1096929,1133138,1166616,1197754,1226836,1254280,1279850,1304043,1326756,1348192,1368385,1387453,1405627,1422854,1439087,1454613,1469645,1484196,1497819,1510882,1523540,1535720,1547445,1558647,1569651,1580109,1590145,1599827,1609094,1618211,1626956,1635483,1643865,1651871,1659547,1667117,1674375,1681502,1688446,1695307,1701885,1708320,1714615,1720582,1726559,1732193,1737817,1743234,1748664,1753900,1759068,1764186,1769154,1773952,1778610,1783199,1787731,1792091,1796407,1800526,1804647,1808715,1812722,1816677,1820606,1824385,1828058,1831614,1835226,1838777,1842259,1845637,1849010,1852351,1855484,1858575,1861716,1864761,1867738,1870714,1873572,1876445,1879331,1882037,1884788,1887513,1890185,1892852,1895420,1897970,1900474,1902913,1905319,1907706,1910027,1912399,1914653,1916903,1919129,1921327,1923512,1925614,1927774,1929867,1931928,1933899,
966,30958,106702,201020,295850,386446,469686,545617,615095,678039,735826,788127,836530,881261,922589,960765,996106,1029106,1060176,1089501,1116790,1142870,1167082,1190468,1212224,1232982,1252899,1272032,1290035,1307149,1323721,1339678,1354852,1369266,1383338,1396990,1409858,1422506,1434483,1446074,1457385,1468146,1478499,1488529,1498273,1507997,1517384,1526385,1535131,1543559,1551690,1559640,1567554,1575297,1582657,1590139,1597135,1603949,1610776,1617385,1623925,1630125,1636123,1642036,1647829,1653642,1659077,1664518,1669809,1674979,1680077,1685073,1689894,1694720,1699396,1704010,1708655,1713051,1717426,1721727,1725887,1729955,1734128,1738079,1741946,1745723,1749468,1753281,1756889,1760516,1764057,1767537,1771019,1774325,1777685,1780902,1784141,1787372,1790479,1793544,1796568,1799501,1802387,1805335,1808211,1811052,1813770,1816574,1819276,1821947,1824578,1827198,1829708,1832162,1834623,1837090,1839478,1841909,1844269,1846629,
52,7332,38989,92560,156918,224298,291639,356099,417527,475205,528709,578962,625684,669800,711148,749426,785675,819911,852167,882586,911416,938857,964661,989509,1013048,1035573,1057019,1077473,1097178,1115834,1133849,1151320,1168154,1184322,1199714,1214543,1228958,1242869,1256309,1269200,1281798,1294130,1305779,1317216,1328219,1339090,1349458,1359568,1369433,1378964,1388241,1397508,1406367,1414946,1423296,1431570,1439625,1447365,1454926,1462383,1469561,1476670,1483668,1490543,1497352,1503809,1510096,1516229,1522418,1528323,1534196,1539977,1545620,1551213,1556568,1561928,1567073,1572132,1577177,1582158,1587054,1591852,1596432,1601078,1605520,1610025,1614442,1618729,1622970,1626976,1631126,1635236,1639271,1643112,1646950,1650708,1654486,1658110,1661664,1665310,1668886,1672329,1675683,1679116,1682426,1685761,1689017,1692304,1695371,1698509,1701538,1704552,1707471,1710429,1713332,1716284,1719051,1721880,1724627,1727301,
8,2539,18773,52174,98184,150292,205757,260853,314661,366390,415882,463035,507745,550191,589918,627968,663773,697494,729510,760124,789390,817093,843474,868683,892651,915758,937877,958977,979535,998897,1017515,1035350,1052761,1069583,1085789,1101479,1116677,1131094,1145072,1158599,1171681,1184816,1197364,1209404,1221218,1232519,1243631,1254495,1264960,1275021,1284996,1294749,1304210,1313553,1322340,1331082,1339784,1348296,1356497,1364514,1372356,1379744,1387011,1394322,1401427,1408293,1415195,1421669,1428376,1434786,1441150,1447411,1453332,1459247,1465200,1470804,1476488,1482100,1487431,1492745,1497921,1503106,1508150,1513115,1517884,1522584,1527297,1531952,1536556,1541098,1545539,1549875,1554174,1558343,1562585,1566581,1570552,1574611,1578558,1582349,1585931,1589682,1593423,1597036,1600701,1604264,1607812,1611324,1614708,1618053,1621366,1624690,1627842,1631117,1634261,1637340,1640454,1643366,1646352,1649255,
0,597,6869,24273,52393,88410,129170,172263,216214,260150,303410,345108,385172,423974,461197,496693,530945,563408,594457,624246,653068,680607,706701,731636,756040,779278,801491,822881,843529,863291,882428,900854,918988,936107,952963,969128,984777,999918,1014556,1028733,1042443,1055880,1068871,1081557,1094037,1106034,1117744,1129102,1140297,1151404,1161941,1172207,1182312,1192051,1201483,1210794,1219950,1228728,1237311,1245769,1253960,1261975,1269942,1277803,1285537,1292859,1300185,1307500,1314503,1321467,1328239,1334847,1341476,1347795,1354091,1360312,1366343,1372251,1378017,1383804,1389425,1394990,1400463,1405902,1411159,1416276,1421276,1426502,1431307,1436250,1441015,1445777,1450466,1455037,1459543,1464066,1468431,1472744,1477017,1481218,1485199,1489271,1493322,1497178,1500976,1504849,1508595,1512354,1516021,1519625,1523333,1527015,1530416,1533825,1537215,1540740,1544079,1547383,1550670,1553924,
0,69,1668,8089,21418,41361,66728,95818,127328,160401,194094,228043,261854,294765,327212,358832,389378,419212,448132,476206,502902,528648,553589,577520,601092,623551,645502,666524,687127,707066,725906,744397,762302,779987,797099,813312,829435,845080,860139,874856,889211,903181,916749,930087,942811,955256,967386,979393,990863,1002176,1013240,1024007,1034470,1044907,1055230,1065085,1074827,1084305,1093486,1102559,1111285,1120083,1128510,1136866,1144864,1152735,1160535,1168133,1175645,1183182,1190446,1197535,1204635,1211590,1218392,1225035,1231592,1238024,1244468,1250671,1256831,1262840,1268744,1274528,1280237,1285934,1291376,1296821,1302079,1307506,1312688,1317819,1322882,1327934,1332893,1337744,1342502,1347149,1351815,1356439,1360876,1365279,1369713,1374014,1378234,1382479,1386575,1390688,1394721,1398730,1402763,1406739,1410646,1414355,1418193,1421981,1425676,1429312,1432791,1436401,
0,7,183,1612,5748,13703,25593,41084,59391,80036,102296,125870,150221,175015,200196,225184,250071,274758,299093,323343,346730,369305,391646,413439,434890,455697,476078,496166,515407,534107,552265,570098,587639,604569,620956,637162,652923,668412,683358,697878,712138,725873,739470,752959,766054,778611,790920,803148,814946,826421,837782,848944,859797,870286,881036,891252,901255,911064,920577,929992,939150,948240,957190,966132,974580,983073,991404,999412,1007329,1015254,1022928,1030460,1037809,1045153,1052312,1059469,1066370,1073311,1080067,1086683,1093293,1099739,1106166,1112463,1118632,1124582,1130642,1136626,1142318,1148143,1153790,1159197,1164695,1170066,1175366,1180638,1185807,1190855,1195860,1200782,1205625,1210426,1215085,1219738,1224538,1229111,1233624,1237936,1242313,1246757,1251223,1255487,1259758,1263873,1267977,1272208,1276152,1280105,1284063,1287902,
0,0,34,396,1845,5206,11140,19832,30745,44156,59277,75862,93686,112470,131970,151804,171707,192201,212440,232581,252563,272744,292348,311637,330651,349493,368013,385990,403797,421372,438211,455084,471720,488067,503734,519373,534440,549546,564151,578123,592061,605825,619344,632633,645277,657874,670072,682044,693764,705582,717004,728121,738932,749543,760134,770443,780385,790136,799921,809336,818868,827996,837064,845956,854559,863101,871581,879825,888049,896051,903759,911377,918906,926421,933767,941156,948380,955272,962180,969055,975790,982654,989347,995785,1002012,1008311,1014544,1020706,1026733,1032554,1038544,1044422,1049951,1055447,1061032,1066486,1071836,1077148,1082299,1087576,1092520,1097697,1102715,1107662,1112548,1117362,1122129,1126815,1131383,1136029,1140470,1144928,1149419,1153793,1158261,1162421,1166607,1170800,1175009,1179070,
0,0,4,56,366,1461,3618,7367,12725,20043,28647,38642,49990,62553,75711,90062,104647,120043,135499,151065,166928,183117,199520,215675,231543,247532,263477,279183,294593,309935,325139,340197,355000,369511,383747,397763,411568,425418,438858,452107,465243,477963,490464,502942,515327,527309,539014,550696,562018,573015,583862,594639,605177,615722,625908,636178,646148,655987,665717,675250,684526,693588,702611,711576,720224,728694,737114,745430,753745,761805,769805,777618,785368,793067,800472,807947,815168,822293,829475,836363,843138,849965,856480,863245,869693,876119,882585,888781,894942,900908,906988,912803,918782,924471,930121,935928,941558,947099,952578,957944,963218,968442,973751,978897,983980,989053,993904,998739,1003715,1008562,1013284,1017908,1022501,1026947,1031602,1036074,1040519,1044849,1049221,1053598,
0,0,0,4,42,229,786,1853,3756,6518,10246,15017,20751,27574,35333,43701,52918,62668,72874,83663,94709,106117,117806,129524,141507,153649,165972,178478,190735,203160,215506,227768,240071,252341,264577,276717,288520,300366,311954,323561,334908,346185,357527,368486,379329,390248,400954,411605,422079,432513,442718,452566,462516,472331,481933,491458,501002,510306,519391,528457,537439,546353,555056,563638,572274,580587,588775,596853,604772,612647,620394,628136,635737,643314,650766,658150,665348,672510,679351,686232,693052,699837,706480,713153,719673,726165,732515,738760,745034,751089,757042,763118,768910,774806,780593,786298,791806,797381,802934,808371,813808,819141,824323,829447,834654,839818,844920,849791,854674,859484,864335,869156,873848,878625,883380,888097,892622,897101,901677,906107,
0,0,0,0,0,18,82,234,591,1264,2344,3946,5922,8639,11707,15410,19669,24539,29873,35631,41710,48273,55177,62532,70138,78052,86215,94402,102882,111418,120202,128984,138007,147118,156314,165435,174587,183582,192758,201779,210932,220281,229542,238617,247665,256626,265606,274379,283285,292046,300689,309423,318005,326576,335111,343475,351765,359915,367977,376082,384123,391977,399695,407368,415022,422627,429953,437341,444627,451728,458978,466258,473396,480184,487152,493835,500600,507202,514018,520516,527026,533453,539790,546111,552354,558525,564595,570745,576684,582641,588623,594381,600154,605853,611417,616920,622428,627946,633215,638595,643887,649237,654467,659576,664720,669879,674984,680072,684916,689828,694580,699334,704140,708785,713416,718043,722477,727046,731475,735840,
0,0,0,0,0,0,3,10,40,103,231,473,874,1451,2210,3214,4447,5958,7682,9810,12192,14880,17807,20957,24525,28334,32274,36448,40850,45369,50050,54960,60168,65459,71027,76753,82364,88227,93947,99996,106065,112059,118311,124485,130805,137121,143428,149859,156113,162379,168739,174967,181488,187971,194387,200718,207015,213558,219864,226321,232622,238969,245238,251434,257539,263593,269665,275657,281728,287810,293802,299806,305675,311551,317358,323242,329147,335022,340771,346463,352145,357735,363366,368912,374352,379785,385095,390375,395784,401075,406431,411748,416981,421997,427067,432140,437229,442234,447373,452223,457056,461839,466545,471314,476049,480723,485412,489874,494489,499037,503541,508031,512526,517033,521406,525902,530254,534609,538807,543063,
0,0,0,0,0,0,0,0,2,5,10,32,79,136,249,423,650,988,1384,1911,2541,3304,4112,5103,6259,7560,8951,10559,12227,14141,16194,18401,20642,23025,25649,28345,31200,34216,37232,40332,43628,47014,50490,54040,57652,61424,65166,69000,72940,76846,80896,84967,88953,93070,97254,101568,105925,110149,114469,118847,123158,127582,132140,136453,140808,145124,149670,154101,158677,163106,167558,171901,176337,180826,185361,189903,194453,198852,203342,207860,212257,216739,221199,225593,229960,234347,238730,243052,247389,251703,255983,260181,264426,268627,272818,277006,281170,285213,289477,293629,297657,301750,305888,309900,314041,318078,322078,326074,330062,333839,337827,341752,345584,349617,353427,357405,361304,365115,368781,372412,
0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,9,25,50,75,125,186,266,378,519,682,902,1174,1479,1817,2229,2662,3216,3835,4451,5166,5945,6748,7717,8651,9668,10781,11921,13161,14456,15817,17251,18780,20344,21984,23678,25351,27069,28929,30794,32758,34789,36815,38901,41057,43222,45452,47708,50042,52390,54770,57111,59605,62101,64540,67001,69539,72046,74677,77309,80002,82678,85379,88101,90809,93615,96385,99196,102005,104709,107554,110364,113353,116217,119068,121830,124715,127549,130367,133194,136081,138948,141813,144655,147549,150421,153209,156089,159021,161914,164787,167655,170579,173464,176272,179143,181907,184800,187745,190674,193520,196375,199177,202012,204869,207771,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,6,10,19,29,41,63,83,105,139,175,218,267,339,416,501,608,732,863,1020,1187,1385,1624,1832,2095,2352,2682,3004,3369,3742,4117,4566,4992,5454,5955,6460,7064,7617,8200,8829,9515,10217,10955,11687,12423,13174,13982,14792,15618,16477,17377,18246,19207,20145,21076,22053,23034,24050,25138,26242,27326,28438,29552,30751,31870,33066,34223,35458,36761,38051,39277,40577,41875,43181,44536,45937,47299,48636,50067,51489,52933,54402,55833,57285,58769,60238,61732,63213,64734,66295,67776,69291,70874,72405,73968,75545,77117,78700,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,5,6,8,8,11,13,19,25,30,39,46,53,66,76,85,97,113,131,160,186,219,248,269,302,345,400,448,494,530,584,656,738,819,907,993,1079,1175,1291,1408,1518,1646,1806,1935,2096,2221,2395,2542,2716,2887,3096,3292,3488,3674,3892,4105,4295,4524,4764,4999,5271,5508,5777,6037,6280,6533,6825,7106,7414,7723,8042,8350,8710,9070,9375,9728,10092,10471,10862,11219,11606,11997,12396,
76274,321302,542494,714187,849446,958268,1048476,1124357,1189704,1246207,1295095,1339127,1378307,1413709,1445834,1475024,1502169,1527034,1549809,1571055,1590969,1609591,1626996,1643364,1658884,1673350,1687046,1700022,1712365,1724108,1735381,1746021,1756372,1766157,1775564,1784560,1793264,1801562,1809640,1817309,1824799,1831970,1838867,1845545,1852003,1858261,1864246,1870067,1875820,1881232,1886609,1891765,1896953,1901896,1906673,1911314,1915891,1920353,1924585,1928719,1932766,1936854,1940722,1944555,1948220,1951816,1955264,1958664,1962074,1965374,1968559,1971775,1974826,1977871,1980849,1983743,1986554,1989356,1992144,1994968,1997634,2000275,2002883,2005418,2007835,2010337,2012729,2015075,2017363,2019591,2021837,2024052,2026213,2028257,2030346,2032333,2034366,2036366,2038332,2040352,2042280,2044199,2046020,2047821,2049658,2051378,2053124,2054795,2056501,2058137,2059743,2061303,2062928,2064471,2066029,2067528,2069006,2070555,2072051,2073490,
19428,151940,320132,470925,598524,706909,799871,880528,950623,1012067,1066098,1114966,1158914,1198751,1234850,1268019,1298577,1327245,1353780,1378390,1401400,1422918,1443057,1462333,1480429,1497346,1513770,1529043,1543580,1557364,1570658,1583254,1595335,1606983,1618164,1628893,1639275,1649165,1658791,1667834,1676812,1685360,1693685,1701681,1709336,1716824,1723978,1731036,1737891,1744491,1750839,1757118,1763210,1769221,1774974,1780663,1786053,1791301,1796418,1801471,1806336,1811211,1815963,1820555,1825110,1829384,1833720,1837921,1842006,1846030,1849958,1853839,1857497,1861144,1864814,1868369,1871798,1875224,1878633,1881867,1885198,1888304,1891413,1894473,1897491,1900517,1903483,1906303,1909133,1911847,1914573,1917270,1919962,1922515,1925024,1927532,1930016,1932401,1934794,1937134,1939434,1941758,1943953,1946107,1948312,1950487,1952636,1954620,1956702,1958659,1960665,1962608,1964594,1966479,1968367,1970189,1971996,1973776,1975529,1977319,
6407,84121,210915,339776,455996,559482,649970,729988,800476,863261,919202,969807,1015959,1057883,1096327,1131849,1164231,1194734,1223146,1249961,1274899,1298151,1320206,1341105,1360652,1379278,1396934,1413684,1429622,1444811,1459223,1473218,1486343,1499019,1511305,1522935,1534343,1545106,1555757,1566124,1575873,1585171,1594289,1603097,1611781,1620065,1628122,1636045,1643575,1650972,1658028,1665069,1671780,1678427,1684799,1691173,1697195,1702985,1708777,1714321,1719812,1724994,1730146,1735259,1740390,1745366,1750119,1754812,1759321,1763772,1768203,1772451,1776484,1780513,1784610,1788436,1792370,1796287,1800011,1803697,1807302,1810811,1814262,1817707,1821126,1824387,1827610,1830901,1833986,1837005,1839959,1842900,1845818,1848729,1851527,1854423,1857196,1859900,1862523,1865166,1867781,1870370,1872850,1875283,1877703,1880117,1882419,1884746,1887025,1889373,1891615,1893844,1896002,1898169,1900237,1902241,1904327,1906313,1908305,1910337,
1200,35068,114934,211359,307362,398199,480916,557096,626007,688016,744450,795797,842972,886215,926449,963703,998185,1030255,1060687,1089145,1115906,1141259,1164864,1187466,1208774,1229020,1248206,1266697,1284232,1301013,1317135,1332414,1347018,1361040,1374666,1387722,1400214,1412268,1423992,1435331,1446312,1456686,1466783,1476609,1486079,1495249,1504280,1513053,1521524,1529755,1537719,1545441,1553054,1560350,1567425,1574483,1581332,1587914,1594468,1600748,1606914,1612802,1618621,1624341,1630073,1635604,1641059,1646356,1651475,1656526,1661516,1666298,1671122,1675766,1680265,1684776,1689094,1693382,1697556,1701742,1705829,1709706,1713563,1717403,1721103,1724785,1728518,1732275,1735827,1739291,1742709,1746109,1749422,1752694,1755877,1758960,1762104,1765105,1768183,1771201,1774148,1777128,1779955,1782708,1785497,1788346,1790986,1793634,1796261,1798865,1801409,1803951,1806396,1808847,1811309,1813641,1816050,1818363,1820657,1822841,
77,8842,44341,101656,168292,237829,305896,370919,432126,489482,542407,591815,637773,680762,721058,758944,794421,827736,859135,888778,916886,943415,968790,992845,1015636,1037396,1058265,1077981,1097239,1115441,1132621,1149459,1165668,1181201,1196125,1210478,1224423,1237769,1250506,1263181,1275282,1287054,1298353,1309410,1320103,1330517,1340687,1350436,1360020,1369245,1378249,1387164,1395731,1404071,1412146,1420136,1427729,1435215,1442512,1449727,1456634,1463471,1470182,1476772,1483143,1489398,1495422,1501405,1507358,1513111,1518842,1524351,1529797,1535054,1540272,1545415,1550520,1555382,1560245,1564991,1569529,1574142,1578616,1583065,1587402,1591645,1595942,1600140,1604133,1608165,1612057,1615876,1619745,1623604,1627249,1630897,1634395,1637981,1641465,1644974,1648334,1651689,1654939,1658186,1661288,1664543,1667641,1670745,1673709,1676639,1679599,1682452,1685342,1688144,1690917,1693733,1696471,1699119,1701779,1704370,
13,3342,22261,59623,108940,163530,220370,276238,330671,382428,431945,479187,523214,564819,604171,641227,676228,709078,740355,770087,798460,825530,851093,875473,898900,921646,942943,963539,983282,1002045,1019907,1037385,1054211,1070469,1086051,1101253,1115764,1129719,1143281,1156444,1169310,1181714,1193918,1205586,1216921,1227851,1238505,1248930,1258936,1268748,1278340,1287519,1296458,1305431,1313997,1322273,1330644,1338964,1346691,1354385,1361731,1368894,1376041,1383036,1389735,1396338,1402845,1409262,1415621,1421792,1427927,1434017,1439759,1445348,1450987,1456528,1461901,1467268,1472393,1477520,1482529,1487451,1492354,1497180,1501915,1506507,1510988,1515496,1519809,1524049,1528209,1532409,1536589,1540702,1544550,1548351,1552318,1556099,1559944,1563553,1567010,1570560,1574106,1577533,1580965,1584345,1587726,1590996,1594233,1597401,1600639,1603778,1606875,1609905,1612942,1615932,1618881,1621764,1624673,1627499,
2,824,8876,29089,60405,99235,142226,187293,232247,277065,320814,362840,402884,441574,478704,513762,547489,579608,610276,639576,667617,694367,719920,744197,767819,790712,812419,833127,853283,872580,891100,909040,926568,943183,959397,975224,990446,1005120,1018978,1032782,1045938,1058681,1071286,1083459,1095386,1106778,1117961,1128915,1139470,1149998,1160090,1169987,1179540,1188856,1198151,1207185,1215945,1224363,1232670,1240793,1248890,1256631,1264235,1271649,1278970,1286141,1293089,1299860,1306617,1313415,1319756,1326306,1332536,1338659,1344688,1350568,1356400,1362060,1367550,1372992,1378423,1383723,1388958,1394003,1398987,1403853,1408648,1413542,1418199,1422839,1427420,1432038,1436467,1440798,1445156,1449415,1453589,1457787,1461891,1465915,1469774,1473721,1477584,1481330,1485071,1488643,1492210,1495765,1499279,1502678,1506140,1509488,1512844,1516117,1519420,1522619,1525817,1528981,1532034,1535131,
0,118,2278,10446,26291,48970,76862,108745,142574,177102,212069,246764,281295,314660,347306,378949,409689,439260,467937,495480,521870,547321,571902,595773,618684,640723,661988,682629,702722,721990,740530,758589,776115,793099,809504,825440,841017,855850,870305,884513,898266,911695,924927,937636,950171,962094,973803,985336,996443,1007346,1018124,1028476,1038734,1048611,1058207,1067709,1077028,1086039,1095020,1103789,1112065,1120407,1128514,1136312,1144102,1151673,1159148,1166487,1173770,1180768,1187754,1194519,1201201,1207784,1214205,1220598,1226825,1232795,1238785,1244718,1250610,1256285,1261925,1267549,1273063,1278350,1283644,1288827,1293863,1298847,1303784,1308644,1313522,1318280,1322917,1327573,1332127,1336624,1341117,1345412,1349663,1353944,1358065,1362081,1366167,1370204,1374156,1378177,1381980,1385743,1389548,1393227,1396953,1400573,1404174,1407673,1411247,1414705,1418071,1421411,
0,5,337,2426,8023,18042,32213,50179,70926,93551,117826,142975,168552,194349,220265,246273,271652,296861,321444,345505,369098,392043,414415,435863,457003,477312,497384,517191,536144,554564,572627,590215,607346,623980,640339,656158,671373,686317,700967,715198,728817,742210,755549,768377,780986,793276,805058,816741,828196,839400,850484,861241,871569,881899,892090,901913,911474,920858,930087,939059,947854,956401,964908,973266,981460,989412,997290,1004912,1012437,1020057,1027381,1034673,1041645,1048736,1055550,1062359,1068914,1075494,1081918,1088212,1094546,1100700,1106711,1112619,1118481,1124100,1129797,1135407,1140960,1146451,1151739,1157024,1162147,1167277,1172399,1177448,1182410,1187225,1191975,1196723,1201262,1205755,1210281,1214780,1219232,1223575,1227948,1232135,1236377,1240563,1244777,1248963,1252993,1256898,1260740,1264666,1268517,1272249,1275992,1279601,
0,1,64,681,2875,7742,15455,26069,39342,54783,71965,90701,110294,130513,151310,172335,193568,214828,235803,256849,277363,297614,317711,337238,356516,375421,394114,412336,430100,447586,464502,481255,497668,513532,528707,543777,558547,573072,587121,600939,614348,627665,640713,653436,665784,677865,689816,701528,713006,723985,735065,745860,756439,766690,776807,786688,796228,805720,815088,824232,833333,842070,850916,859365,867811,875917,883998,891899,899893,907515,914932,922422,929568,936784,943704,950739,957616,964465,971084,977655,984069,990521,996864,1002996,1009134,1015140,1020988,1026770,1032459,1038134,1043621,1049065,1054310,1059583,1064780,1070005,1075158,1080148,1085025,1089838,1094660,1099369,1104139,1108832,1113452,1118023,1122549,1127003,1131377,1135721,1139930,1144274,1148518,1152806,1156944,1160959,1164967,1168975,1172942,1176754,
0,0,4,112,705,2437,5697,10858,17982,26954,37619,49646,62753,76946,91997,107679,123893,140546,157188,174144,190959,207822,224547,241359,257713,274031,290321,306441,322193,337637,352865,368100,382994,397390,411578,425572,439438,453160,466385,479510,492294,504687,517082,529305,541387,553136,564642,575936,587128,597957,608728,619174,629392,639533,649318,659279,668850,678393,687670,696674,705682,714579,723123,731822,740189,748406,756527,764521,772392,780280,787943,795325,802721,809968,817238,824426,831424,838078,844598,851252,857674,864206,870656,876993,883287,889337,895482,901639,907601,913434,919252,924868,930581,935953,941427,946826,952128,957310,962530,967572,972707,977615,982685,987660,992361,997115,1001765,1006281,1010889,1015384,1020021,1024504,1028882,1033119,1037338,1041602,1045722,1049982,1054090,1058201,
0,0,0,9,96,487,1411,3178,6000,10030,15080,21446,28859,37295,46542,56358,66967,78175,89781,102028,114616,127177,139930,152725,165900,178963,192067,205165,218105,230932,243771,256641,269343,282105,294566,306883,319019,330914,342690,354451,365907,377381,388798,399694,410656,421545,432061,442433,452879,463016,473109,483120,492564,502275,511692,520990,530608,539500,548461,557322,565967,574518,583063,591353,599416,607563,615611,623369,631209,638810,646432,653914,661117,668509,675683,682724,689712,696492,703278,709995,716589,723133,729523,735948,742201,748419,754453,760517,766404,772209,777888,783642,789212,794811,800316,805652,810973,816255,821562,826797,831781,836840,841895,846877,851833,856746,861527,866359,871051,875622,880241,884775,889287,893762,898135,902677,906984,911240,915487,919523,
0,0,0,0,5,46,174,549,1266,2472,4239,6535,9550,13255,17571,22672,28293,34483,41166,48458,56075,64163,72499,80981,89904,98867,108046,117270,126571,136033,145762,155634,165237,174770,184415,194321,203986,213526,223145,232863,242616,252274,261757,271104,280368,289739,298808,307871,317026,325989,334987,343623,352225,360920,369421,377920,386043,394175,402385,410459,418470,426380,434207,441795,449461,456804,464124,471494,478794,485936,493090,500179,507171,514041,520820,527349,533978,540586,547096,553535,559812,566024,572116,578195,584401,590389,596255,602032,607823,613575,619248,624798,630416,635887,641368,646746,651997,657194,662266,667428,672560,677690,682549,687518,692409,697227,701934,706781,711448,716120,720634,725212,729706,734276,738821,743243,747730,752004,756162,760425,
0,0,0,0,0,1,7,40,109,277,587,1090,1796,2794,4138,5699,7715,10002,12592,15667,19217,22838,26874,31170,35658,40549,45616,50902,56306,62012,67789,73789,80012,86169,92519,98857,105509,112207,118770,125433,132134,139077,146024,152862,159890,166785,173731,180623,187345,194184,201051,207771,214741,221650,228485,235191,241777,248546,255116,261796,268297,274730,281286,287651,294006,300446,306739,312938,319196,325322,331387,337472,343491,349530,355526,361497,367455,373210,378876,384673,390349,396073,401619,407152,412440,417806,423244,428596,433839,439145,444332,449558,454719,459676,464767,469730,474796,479719,484645,489502,494168,498873,503593,508413,513087,517776,522316,526819,531293,535797,540222,544590,548873,553196,557489,561681,565939,570113,574401,578564,
0,0,0,0,0,0,0,0,0,23,61,124,226,375,619,983,1450,2076,2767,3676,4788,6010,7491,9089,10856,12841,15035,17384,19920,22579,25397,28429,31656,34887,38354,41874,45646,49429,53384,57498,61562,65752,70107,74437,78788,83240,87835,92468,97030,101800,106483,111249,116006,120784,125618,130431,135293,140155,145112,149936,154800,159674,164498,169401,174236,179058,183979,188797,193675,198485,203280,208093,212828,217604,222353,227224,231905,236621,241301,245940,250582,255295,259931,264502,269024,273641,278177,282711,287179,291669,296056,300473,304889,309226,313626,317958,322367,326622,330872,335137,339299,343448,347546,351687,355975,360028,363986,368012,372055,375955,380070,384028,387923,391678,395424,399112,402980,406716,410511,414245,
0,0,0,0,0,0,0,0,0,0,1,2,6,12,27,52,86,155,248,398,577,786,1032,1369,1756,2225,2742,3312,3993,4778,5600,6545,7544,8660,9845,11104,12456,13957,15473,17132,18773,20529,22350,24276,26253,28243,30354,32576,34755,37022,39329,41777,44271,46782,49328,51958,54595,57306,60092,63008,65792,68655,71550,74559,77463,80320,83319,86396,89479,92613,95670,98774,101860,104991,108207,111395,114516,117785,121014,124175,127374,130517,133784,136992,140063,143341,146528,149803,153058,156228,159344,162607,165776,168998,172157,175435,178649,181734,185026,188201,191357,194554,197758,200907,203965,207199,210226,213376,216480,219675,222865,226050,229057,232149,235231,238288,241358,244359,247507,250539,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,7,13,19,28,50,75,100,132,174,230,288,365,446,571,706,866,1051,1273,1529,1793,2079,2392,2729,3111,3548,3980,4442,4971,5485,6096,6719,7370,8055,8770,9501,10321,11161,12025,12853,13742,14657,15651,16647,17694,18751,19774,20825,21924,23127,24321,25521,26802,28146,29386,30687,32022,33379,34768,36160,37634,39086,40563,42064,43631,45163,46745,48277,49908,51509,53075,54755,56389,58041,59703,61521,63194,64928,66678,68442,70196,71886,73759,75539,77428,79265,81010,82789,84592,86449,88328,90101,91949,93710,95541,97441,99257,101182,103101,105038,106883,108715,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,7,9,11,14,20,27,31,35,47,60,77,97,116,138,175,201,244,276,316,369,403,469,527,596,662,738,838,915,1020,1116,1248,1377,1498,1676,1812,1965,2141,2307,2476,2673,2872,3109,3315,3545,3768,4038,4289,4552,4812,5079,5418,5718,6019,6336,6681,7039,7399,7763,8158,8553,8935,9322,9752,10140,10589,11009,11397,11881,12306,12795,13285,13773,14266,14813,15344,15914,16423,16993,17545,18135,18718,19299,19896,20460,21095,21695,22349,
80410,328518,548796,718775,852250,959791,1048561,1123193,1187443,1242735,1291212,1334269,1372785,1407363,1438674,1467384,1493814,1518065,1540480,1561353,1580892,1599129,1616155,1632203,1647404,1661788,1675241,1688140,1700180,1711558,1722575,1732996,1743038,1752738,1761880,1770720,1779253,1787476,1795404,1802965,1810074,1817092,1823761,1830202,1836509,1842674,1848571,1854354,1859839,1865208,1870499,1875678,1880610,1885395,1890164,1894737,1899159,1903449,1907559,1911684,1915706,1919683,1923543,1927302,1930909,1934479,1937992,1941396,1944808,1948008,1951174,1954285,1957348,1960363,1963332,1966176,1969001,1971760,1974526,1977073,1979646,1982266,1984823,1987369,1989885,1992284,1994615,1996935,1999243,2001396,2003629,2005773,2007932,2009965,2012066,2014074,2016076,2018052,2019935,2021853,2023711,2025583,2027405,2029162,2030932,2032676,2034351,2035992,2037617,2039169,2040798,2042341,2043923,2045454,2047052,2048605,2050102,2051574,2053023,2054460,
21514,159337,328752,478800,606102,713550,805214,884273,952843,1013323,1066466,1114530,1157260,1196347,1231897,1264286,1294230,1322157,1348117,1372227,1394623,1415882,1435690,1454167,1471711,1488448,1504489,1519326,1533327,1546903,1559910,1572356,1584063,1595263,1606128,1616503,1626629,1636346,1645693,1654604,1663124,1671482,1679457,1687328,1694892,1702372,1709470,1716387,1723128,1729665,1735716,1741862,1747785,1753703,1759357,1764820,1770102,1775239,1780256,1785073,1789856,1794492,1799111,1803664,1808047,1812397,1816711,1820786,1824802,1828674,1832440,1836217,1839948,1843419,1846993,1850441,1853798,1857169,1860502,1863634,1866829,1869801,1872840,1875758,1878705,1881625,1884513,1887251,1890000,1892634,1895229,1897952,1900623,1903088,1905552,1907915,1910353,1912815,1915131,1917416,1919747,1921932,1924164,1926384,1928487,1930642,1932754,1934791,1936760,1938806,1940728,1942698,1944534,1946420,1948193,1950013,1951784,1953537,1955296,1957032,
7386,89385,220037,349791,465782,567682,656761,735514,805212,867148,921910,971721,1017317,1058228,1095675,1130166,1161997,1191652,1219464,1245603,1269882,1292941,1314407,1334652,1354139,1372380,1389683,1405920,1421414,1436020,1450392,1463857,1476643,1488919,1500717,1512342,1523273,1533942,1544319,1554106,1563618,1572684,1581342,1590044,1598488,1606528,1614352,1622037,1629410,1636541,1643353,1650096,1656665,1663064,1669275,1675401,1681153,1686872,1692303,1697685,1702999,1708195,1713269,1718279,1723235,1728027,1732727,1737346,1741739,1746069,1750397,1754566,1758688,1762728,1766614,1770526,1774277,1777933,1781569,1785143,1788576,1791979,1795407,1798841,1802084,1805361,1808457,1811663,1814716,1817662,1820651,1823561,1826421,1829149,1831908,1834631,1837273,1839921,1842569,1845146,1847620,1850095,1852460,1854881,1857200,1859596,1861843,1864136,1866349,1868590,1870760,1872949,1875094,1877175,1879168,1881235,1883230,1885309,1887301,1889309,
1520,38844,122589,221622,318847,409903,492841,567687,635072,696133,751455,801964,848033,890479,930084,966273,1000109,1031685,1061352,1088845,1114879,1139449,1162664,1184611,1205441,1224968,1243587,1261510,1278515,1294942,1310503,1325319,1339570,1353197,1366409,1379205,1391287,1402992,1414282,1425285,1436079,1446221,1455880,1465346,1474612,1483638,1492245,1500783,1509118,1517040,1524778,1532314,1539594,1546728,1553599,1560553,1567149,1573609,1579855,1586123,1591929,1597806,1603595,1609166,1614720,1620225,1625609,1630682,1635660,1640646,1645560,1650187,1654801,1659263,1663484,1667919,1672072,1676226,1680340,1684353,1688178,1691962,1695722,1699435,1703117,1706656,1710196,1713772,1717209,1720531,1723891,1727199,1730388,1733526,1736623,1739678,1742795,1745740,1748747,1751556,1754450,1757329,1760049,1762755,1765412,1768131,1770792,1773367,1775930,1778435,1780896,1783341,1785722,1788172,1790518,1792807,1795048,1797263,1799524,1801704,
139,10844,50184,110257,179525,250380,318830,383666,444753,501570,554008,602426,648015,690372,729943,767173,801968,834381,865209,894198,921484,947259,971911,995517,1018049,1039236,1059375,1078560,1097059,1114857,1131729,1148173,1163770,1178867,1193313,1207263,1220613,1233699,1246180,1258221,1270007,1281568,1292496,1303133,1313457,1323597,1333379,1342881,1352048,1360908,1369567,1378120,1386419,1394477,1402213,1409948,1417218,1424541,1431604,1438504,1445154,1451826,1458198,1464593,1470744,1476659,1482541,1488436,1494178,1499735,1505135,1510404,1515581,1520653,1525758,1530698,1535681,1540456,1545219,1549731,1554325,1558779,1563196,1567410,1571630,1575801,1579867,1583974,1587956,1591770,1595618,1599357,1603091,1606791,1610244,1613647,1617056,1620371,1623818,1627208,1630426,1633650,1636944,1640093,1643174,1646205,1649256,1652215,1655081,1657878,1660739,1663607,1666290,1668979,1671628,1674289,1677005,1679513,1682053,1684573,
20,4138,25827,66467,118781,175601,233918,290690,345318,397272,446121,492637,536400,577559,616256,652869,687194,719628,750205,779393,806976,833468,858589,882524,905521,927397,948267,968180,987417,1005652,1023080,1039841,1056057,1071746,1086853,1101409,1115334,1129015,1142082,1154683,1167047,1178845,1190543,1201673,1212773,1223357,1233558,1243521,1253467,1263057,1272224,1281140,1289979,1298515,1306780,1314852,1322749,1330569,1338135,1345468,1352600,1359721,1366739,1373584,1380087,1386432,1392632,1398789,1404877,1410920,1416755,1422717,1428235,1433659,1438968,1444270,1449592,1454790,1459880,1464829,1469612,1474328,1478911,1483413,1487888,1492316,1496675,1500944,1505195,1509297,1513370,1517381,1521252,1525164,1528940,1532724,1536424,1540148,1543753,1547297,1550767,1554117,1557388,1560698,1564052,1567388,1570622,1573878,1577025,1580119,1583204,1586241,1589197,1592200,1595137,1598037,1600840,1603655,1606367,1609140,
4,1116,10722,33834,67874,109501,154309,200923,247404,292792,336653,378712,419085,457165,493937,528582,561496,593174,623356,652107,679376,705493,730667,754502,777335,799481,820662,840902,860692,879312,897318,914478,931495,947897,963503,978606,993276,1007464,1021228,1034380,1047239,1059507,1071608,1083382,1094965,1106287,1117302,1127770,1138204,1148212,1158090,1167636,1176928,1186197,1194866,1203404,1211746,1219854,1227809,1235595,1243348,1250847,1258160,1265186,1272252,1279081,1285932,1292530,1298907,1305210,1311556,1317715,1323812,1329588,1335314,1340932,1346419,1351897,1357305,1362690,1367911,1373018,1377990,1382926,1387725,1392428,1397123,1401704,1406162,1410581,1415000,1419382,1423685,1427907,1432014,1436148,1440210,1444164,1447938,1451826,1455625,1459335,1463075,1466683,1470208,1473780,1477289,1480775,1484182,1487606,1490868,1494146,1497450,1500661,1503796,1506821,1509792,1512806,1515820,1518779,
0,186,3187,13058,31345,56973,87328,120740,156131,191766,227689,263528,298626,332260,364756,396369,427196,456873,485246,512572,538890,563832,588211,611461,633960,655557,676272,696376,716030,734795,752836,770309,787237,803808,819635,835074,850191,864661,878663,892363,905899,918829,931416,943625,955570,967072,978561,989621,1000224,1010598,1020827,1030995,1040778,1050409,1059834,1068724,1077650,1086330,1094806,1103225,1111460,1119509,1127230,1134954,1142366,1149709,1156921,1163950,1170733,1177497,1184194,1190881,1197324,1203700,1209767,1215898,1221850,1227799,1233655,1239357,1245080,1250496,1255846,1261217,1266580,1271757,1276820,1281811,1286609,1291402,1296202,1300876,1305467,1309978,1314480,1318945,1323231,1327543,1331831,1335952,1340090,1344227,1348208,1352085,1355961,1359837,1363651,1367389,1371146,1374765,1378396,1382017,1385587,1389059,1392582,1395977,1399236,1402553,1405855,1409007,
0,12,528,3506,10460,22486,38779,58915,81668,106315,132127,158813,185637,212581,239657,265823,291740,317170,342242,366282,389922,412645,435107,456957,477795,498316,518120,537548,556140,574171,591655,608726,625269,641547,657249,672567,687495,702124,716271,730052,743254,756286,769331,781812,793806,805701,816969,828449,839531,850472,861017,871234,881386,891162,900863,910286,919419,928616,937472,946083,954582,962835,970900,978910,986750,994440,1002021,1009470,1016597,1023881,1030985,1038146,1044896,1051679,1058251,1064730,1070889,1077114,1083510,1089691,1095597,1101344,1107196,1112770,1118424,1123880,1129309,1134742,1139980,1145146,1150367,1155306,1160192,1164952,1169800,1174647,1179346,1184003,1188559,1193125,1197448,1201769,1206200,1210413,1214516,1218675,1222895,1226956,1230987,1234947,1238872,1242830,1246694,1250621,1254220,1257954,1261622,1265332,1268885,1272336,
0,0,110,1038,4145,10406,19889,32488,47887,65275,84452,104729,125747,147527,169100,191092,213415,235440,256992,278200,299051,319547,339840,359509,378865,397810,416293,434481,452221,469590,486163,502659,518622,534071,549487,564313,578794,593298,607047,620551,633777,646620,659187,671761,683862,695720,707316,718647,729778,740469,751129,761590,771613,781564,791495,801015,810135,819247,828309,837107,845792,854403,862849,871049,879232,887132,894743,902214,909838,917127,924394,931530,938427,945404,952120,958878,965381,971826,978091,984301,990512,996611,1002651,1008642,1014465,1020285,1025982,1031591,1036993,1042286,1047573,1052951,1058115,1063153,1068072,1073020,1077946,1082624,1087445,1092075,1096732,1101268,1105855,1110387,1114789,1119147,1123386,1127679,1131842,1135991,1140063,1144082,1148127,1152161,1156077,1159977,1163796,1167468,1171264,1174884,
0,0,11,251,1251,3742,8093,14630,23278,33936,46272,59877,74596,90246,106763,123762,141133,158923,176593,194099,211697,229199,246540,263942,280668,297339,313946,330049,345795,361287,376670,391543,406523,421048,435487,449441,463097,476580,489843,502615,515283,527683,539956,552173,563882,575420,586440,597472,608330,618944,629267,639469,649595,659372,669037,678571,687970,697152,706277,715079,723797,732302,740633,748877,757017,765061,772875,780611,788272,795854,803163,810348,817557,824631,831513,838336,845126,851552,857991,864267,870616,876785,882826,888889,894896,900874,906700,912357,917932,923492,929043,934489,939951,945154,950375,955575,960680,965718,970601,975313,980162,984814,989540,994213,998729,1003327,1007814,1012106,1016494,1020930,1025334,1029472,1033646,1037747,1041771,1045803,1049827,1053862,1057678,1061568,
0,0,0,18,193,848,2306,4910,8788,14066,20654,28406,37120,47090,57673,69025,81031,93603,106441,119647,133266,146798,160526,174226,187843,201774,215391,228884,242452,255818,269118,282172,295212,308045,320803,333251,345697,357824,369805,381472,392967,404299,415564,426618,437389,448222,458734,469246,479434,489559,499450,509371,518784,528291,537650,546950,556025,565002,573855,582449,590969,599174,607467,615691,623684,631562,639325,646993,654456,661812,669217,676374,683421,690320,697099,703924,710408,716870,723328,729767,736060,742372,748691,754824,760772,766690,772517,778378,784177,789735,795202,800657,806009,811492,816835,822056,827082,832113,837244,842165,847013,851825,856695,861468,866201,870891,875559,880132,884610,888962,893480,897840,902113,906394,910582,914797,918970,923045,927058,930993,
0,0,0,0,15,107,387,1017,2166,3999,6550,9813,13913,18747,24271,30550,37495,44799,52793,61262,69985,79084,88416,98065,107769,117482,127457,137583,147828,158273,168567,178834,189205,199407,209556,219783,229815,239745,249770,259705,269518,279464,289180,298786,308289,317686,326934,336266,345398,354437,363314,372268,381145,389695,398149,406612,414937,423013,431140,439288,447239,455043,462744,470210,477707,485063,492296,499533,506644,513657,520529,527435,534112,540954,547566,554045,560490,566951,573295,579598,585698,591784,597855,603774,609675,615431,621148,626988,632634,638214,643779,649063,654648,659796,665162,670312,675472,680447,685534,690574,695569,700408,705232,709943,714770,719422,724103,728692,733176,737544,742079,746447,750875,755186,759591,763838,767955,771999,776159,780130,
0,0,0,0,0,6,21,92,254,572,1119,1957,3151,4717,6740,9106,11924,15066,18670,22579,26971,31702,36618,41992,47544,53369,59369,65732,72273,78859,85572,92332,99365,106292,113401,120665,127910,135147,142378,149583,156832,164315,171673,178867,186229,193463,200765,208035,215154,222540,229659,236892,244051,251152,258321,265341,272234,279117,285883,292634,299324,305846,312585,319126,325540,332027,338488,344812,351108,357268,363445,369562,375705,381644,387563,393430,399298,405177,410961,416692,422354,427878,433395,438968,444287,449654,455067,460327,465481,470728,475722,480880,485925,490915,495955,500861,505702,510554,515397,520167,524883,529450,533999,538562,543226,547764,552270,556731,561083,565275,569523,573692,577948,582044,586282,590437,594603,598567,602587,606565,
0,0,0,0,0,0,0,3,22,56,121,255,496,821,1283,1948,2733,3692,4909,6392,8054,9952,12120,14439,16998,19702,22530,25744,29116,32711,36387,40195,44138,48301,52450,56842,61365,65801,70532,75252,80065,84971,89992,94936,99885,104945,110157,115397,120802,126118,131250,136412,141636,146814,152027,157206,162498,167798,173026,178278,183396,188694,193880,199129,204350,209595,214748,219944,225051,230119,235186,240135,245174,250161,255247,260132,265184,270125,275015,279933,284611,289373,294232,298823,303496,308138,312863,317551,322120,326614,331146,335550,339993,344311,348632,353120,357476,361785,366027,370228,374300,378470,382710,386770,390853,394971,399046,402981,407116,411085,415116,418953,422839,426759,430628,434354,438086,441803,445528,449223,
0,0,0,0,0,0,0,0,0,0,3,9,25,47,95,174,277,418,623,893,1184,1618,2091,2694,3350,4119,4950,5956,7026,8219,9470,10798,12290,13926,15642,17520,19437,21379,23399,25588,27797,30129,32612,35024,37565,40228,42949,45734,48593,51403,54298,57152,60157,63271,66348,69428,72663,76009,79300,82555,85832,89143,92467,95879,99380,102669,106068,109472,113001,116486,120006,123550,127072,130541,134069,137607,141119,144573,148093,151608,155224,158709,162181,165654,169203,172720,176189,179744,183185,186504,189949,193345,196714,200139,203590,207064,210393,213769,217079,220488,223931,227389,230697,234055,237447,240850,244096,247330,250597,253818,257073,260313,263508,266711,269901,273058,276238,279326,282453,285551,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,9,15,31,46,66,101,146,200,274,371,471,621,774,938,1139,1389,1656,1990,2340,2749,3161,3631,4121,4688,5273,5935,6605,7332,8053,8848,9710,10637,11580,12531,13576,14623,15720,16882,18067,19299,20489,21820,23156,24496,25886,27265,28694,30198,31708,33199,34759,36359,37930,39539,41161,42860,44595,46292,48056,49841,51683,53471,55281,57045,58866,60725,62554,64499,66448,68372,70432,72417,74306,76368,78403,80385,82347,84386,86393,88399,90414,92509,94571,96638,98772,100833,102989,105022,107104,109234,111416,113552,115683,117738,119812,122006,124170,126232,128311,130448,132596,134681,136790,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,5,11,14,17,21,28,44,61,79,103,123,148,181,217,264,311,357,413,487,555,621,717,800,894,992,1107,1244,1376,1523,1682,1876,2057,2272,2507,2699,2948,3173,3400,3673,3972,4280,4603,4921,5277,5585,5938,6300,6643,7034,7478,7893,8357,8791,9236,9714,10234,10677,11198,11724,12238,12777,13314,13925,14495,15057,15660,16269,16914,17566,18182,18783,19410,20100,20771,21443,22164,22864,23588,24300,25069,25814,26548,27294,28083,28920,29737,30566,31359,32200,32991,33815,
83841,334536,554326,722792,854578,960823,1048501,1122045,1185193,1239402,1286798,1329001,1366821,1400761,1431605,1460027,1486162,1509880,1531953,1552358,1571467,1589390,1605859,1621647,1636691,1650732,1663839,1676362,1688193,1699379,1710300,1720441,1730371,1739895,1748812,1757385,1765940,1774035,1781786,1789174,1796120,1803048,1809675,1816174,1822439,1828578,1834493,1840129,1845643,1850910,1856137,1861161,1866103,1870867,1875415,1879866,1884223,1888473,1892649,1896649,1900639,1904515,1908357,1912060,1915635,1919111,1922473,1925730,1928989,1932152,1935278,1938447,1941403,1944352,1947169,1949930,1952672,1955366,1958113,1960703,1963349,1965855,1968338,1970756,1973155,1975553,1977900,1980173,1982323,1984497,1986631,1988818,1990868,1992872,1994925,1996883,1998820,2000742,2002679,2004564,2006400,2008242,2010010,2011757,2013535,2015262,2016974,2018631,2020273,2021899,2023455,2025034,2026602,2028164,2029698,2031213,2032662,2034118,2035565,2036999,
23403,165505,336908,486857,613105,719177,809649,887590,955345,1014225,1066467,1113601,1155468,1193880,1228641,1260564,1290011,1317343,1342650,1366323,1388332,1409030,1428384,1446422,1463828,1480201,1495605,1510216,1524118,1537489,1550009,1562099,1573508,1584573,1595246,1605427,1615245,1624750,1633803,1642571,1651005,1659106,1666892,1674527,1681899,1689191,1696121,1702907,1709420,1715798,1721846,1727924,1733724,1739501,1745024,1750488,1755549,1760593,1765632,1770351,1775092,1779607,1784160,1788559,1792783,1797001,1801118,1805091,1808901,1812769,1816535,1820324,1823959,1827472,1830927,1834350,1837676,1840920,1844192,1847320,1850406,1853433,1856413,1859283,1862106,1864907,1867684,1870458,1873127,1875809,1878338,1880899,1883401,1885771,1888256,1890705,1893083,1895352,1897619,1899793,1902120,1904336,1906459,1908641,1910728,1912834,1914823,1916864,1918806,1920746,1922562,1924463,1926348,1928191,1930013,1931918,1933623,1935351,1937076,1938796,
8405,95357,228444,358685,474763,576082,664442,741975,810465,870916,924937,973665,1018148,1058482,1095487,1129419,1160645,1190021,1217106,1242450,1266050,1288384,1309479,1329509,1348125,1365682,1382422,1398279,1413689,1428192,1441956,1455234,1467911,1479894,1491534,1502714,1513490,1523750,1533596,1543260,1552607,1561457,1570183,1578528,1586692,1594671,1602144,1609580,1616697,1623770,1630535,1637103,1643574,1649709,1655764,1661813,1667625,1673178,1678773,1684005,1689213,1694262,1699345,1704229,1708959,1713561,1718214,1722594,1726844,1731108,1735289,1739277,1743302,1747268,1751069,1754914,1758557,1762223,1765853,1769295,1772699,1775925,1779213,1782420,1785660,1788789,1791899,1794951,1798009,1800914,1803871,1806693,1809575,1812306,1814907,1817494,1820143,1822688,1825256,1827727,1830165,1832561,1834932,1837344,1839709,1842007,1844214,1846495,1848756,1850865,1853027,1855123,1857142,1859290,1861289,1863277,1865279,1867166,1869091,1870968,
1834,42872,130232,231468,329222,419933,502015,576339,643600,704055,758322,807839,852863,894718,933163,969106,1002189,1032871,1061844,1088865,1114238,1138269,1161078,1182532,1202600,1221774,1239961,1257507,1274150,1289911,1304851,1319366,1333275,1346432,1359336,1371620,1383405,1394808,1405689,1416330,1426714,1436777,1446210,1455494,1464578,1473245,1482002,1490302,1498431,1506203,1513761,1521091,1528278,1535302,1542196,1548867,1555215,1561406,1567487,1573467,1579185,1584842,1590419,1595891,1601265,1606515,1611589,1616562,1621505,1626265,1630854,1635435,1639824,1644168,1648504,1652699,1656866,1661045,1665091,1668972,1672769,1676512,1680158,1683743,1687350,1690830,1694232,1697688,1701018,1704320,1707617,1710889,1714092,1717132,1720234,1723172,1726194,1729015,1731912,1734666,1737422,1740126,1742756,1745412,1748060,1750718,1753204,1755836,1758292,1760733,1763041,1765380,1767688,1770089,1772394,1774642,1776914,1779131,1781329,1783530,
194,12554,55531,118898,190216,262219,331398,396274,456810,513311,565604,613927,658629,700315,739230,775640,809392,841211,871355,899753,926489,951649,975613,998475,1019890,1040732,1060480,1079353,1097205,1114618,1131029,1146810,1162103,1176539,1190554,1204185,1217242,1229845,1241933,1253788,1265239,1276208,1286865,1297102,1307226,1316915,1326450,1335694,1344649,1353243,1361879,1370165,1378068,1385812,1393403,1400769,1408031,1415004,1421825,1428487,1435062,1441538,1447858,1454026,1460073,1465910,1471706,1477373,1482872,1488118,1493372,1498484,1503590,1508553,1513524,1518315,1523067,1527779,1532246,1536732,1541161,1545341,1549652,1553753,1557809,1561822,1565773,1569692,1573525,1577186,1580827,1584501,1588128,1591590,1595073,1598469,1601778,1605041,1608317,1611571,1614580,1617752,1620892,1623947,1626901,1629887,1632731,1635530,1638416,1641196,1643940,1646763,1649460,1652109,1654770,1657264,1659866,1662394,1664800,1667296,
32,5091,29821,73785,128443,187204,246675,303927,358934,411016,459927,506565,549805,590319,628067,664165,697819,729680,759622,788160,815176,840929,865215,888502,910752,932196,952344,971674,990359,1008229,1025210,1041524,1057312,1072620,1087269,1101527,1115014,1128185,1140915,1153249,1165119,1176716,1187954,1199069,1209679,1219750,1229675,1239390,1248891,1258215,1267190,1275968,1284421,1292617,1300688,1308720,1316414,1323974,1331307,1338444,1345347,1352116,1358711,1365144,1371531,1377749,1383940,1389864,1395795,1401516,1407200,1412685,1418150,1423391,1428512,1433638,1438738,1443854,1448690,1453454,1458058,1462685,1467111,1471477,1475840,1480158,1484290,1488569,1492552,1496525,1500438,1504319,1508133,1511934,1515645,1519355,1522931,1526526,1529978,1533469,1536836,1540131,1543342,1546685,1549817,1552954,1556220,1559273,1562317,1565347,1568272,1571133,1574117,1576944,1579734,1582486,1585210,1587958,1590673,1593360,
6,1556,12978,38749,75980,119770,166560,214430,261671,307105,351388,393334,433503,471519,507760,542483,574935,606199,636053,664132,690906,716543,741037,764527,786852,808398,829047,848749,867633,885761,903543,920337,936735,952554,967825,982421,996621,1010366,1023655,1036515,1048909,1060954,1072645,1084101,1095248,1106008,1116517,1126711,1136773,1146552,1155939,1165170,1174141,1183038,1191619,1199930,1208124,1216024,1223877,1231411,1238828,1246066,1253027,1259750,1266580,1273293,1279897,1286311,1292494,1298677,1304849,1310765,1316602,1322288,1327784,1333296,1338605,1343955,1349276,1354416,1359440,1364384,1369217,1373954,1378625,1383239,1387772,1392174,1396569,1400802,1404910,1409138,1413277,1417327,1421318,1425242,1429185,1433008,1436781,1440464,1444071,1447646,1451272,1454764,1458227,1461741,1465092,1468532,1471811,1475003,1478132,1481323,1484466,1487586,1490591,1493575,1496502,1499373,1502330,1505181,
0,285,4202,16251,37070,65175,97669,133155,169906,206839,243749,279985,315028,348559,381623,413443,443788,473059,500957,527836,553556,578104,602165,624957,646963,668173,688866,708624,727788,746165,763878,780968,797545,813494,829138,844121,858890,873045,886849,900116,913117,925652,937836,949697,961279,972521,983281,994049,1004556,1014786,1024531,1034226,1043698,1052809,1061853,1070524,1079226,1087461,1095699,1103677,1111620,1119475,1127048,1134312,1141425,1148686,1155465,1162182,1168847,1175413,1181848,1188025,1194337,1200493,1206504,1212385,1218003,1223655,1229318,1234982,1240217,1245529,1250686,1255808,1260907,1265931,1270765,1275655,1280377,1285035,1289670,1294252,1298819,1303322,1307595,1311815,1315937,1320086,1324180,1328192,1332120,1335979,1339775,1343549,1347345,1351014,1354623,1358346,1361912,1365489,1368945,1372351,1375755,1379065,1382413,1385807,1388932,1392116,1395325,1398396,
0,36,785,4633,13268,27369,45819,67979,92713,118955,146139,174101,202244,229925,257367,284041,310195,335867,360897,385012,408589,431360,453652,474819,495311,515436,535080,553868,572248,590016,607558,624380,640774,656450,672063,686985,701563,715948,729609,743036,756113,768769,781481,793545,805316,816684,827805,838902,849727,860276,870394,880337,890264,899798,909322,918418,927371,936208,944728,953048,961332,969394,977264,985054,992603,999833,1007098,1014100,1021124,1027976,1034733,1041440,1047938,1054432,1060722,1067023,1073096,1079269,1085215,1091026,1096747,1102432,1107972,1113372,1118774,1124118,1129194,1134384,1139553,1144560,1149526,1154412,1159046,1163745,1168290,1172886,1177466,1181928,1186254,1190548,1194744,1198879,1203138,1207162,1211204,1215269,1219222,1223163,1226865,1230760,1234570,1238159,1241938,1245621,1249235,1252784,1256333,1259941,1263312,1266667,
0,3,199,1644,5770,13315,24647,39068,56241,75382,96129,117880,140132,162922,185877,208818,231425,253811,275751,297336,318567,339242,359624,379636,399042,417921,436371,454667,472050,489001,505523,521845,537589,552992,567842,582117,596379,610349,623729,637072,649847,662350,674829,686884,698813,710232,721344,732353,743210,753528,763851,773968,783955,793594,803180,812493,821649,830492,839200,847618,856037,864249,872572,880484,888370,896087,903485,910656,917902,925082,931939,938763,945596,952227,958800,965176,971473,977623,983629,989703,995606,1001501,1007206,1012986,1018530,1024120,1029670,1035077,1040361,1045532,1050611,1055683,1060575,1065413,1070305,1075073,1079806,1084422,1089007,1093439,1097961,1102294,1106598,1110927,1115101,1119414,1123460,1127559,1131593,1135611,1139526,1143380,1147318,1151144,1154922,1158674,1162399,1165991,1169495,1173080,
0,0,25,410,1837,5177,10779,18739,29066,41433,55487,70998,87300,104299,122234,140336,158564,177046,195237,213704,231934,249934,267468,284928,302067,319138,335788,351982,368053,383681,399013,414022,428778,443328,457381,471411,485082,498577,511524,524282,536820,549019,560860,572691,584311,595557,606690,617587,628174,638490,648518,658423,668235,677705,687248,696508,705490,714509,723390,731991,740336,748669,756669,764651,772552,780249,787872,795201,802527,809782,816869,823804,830670,837442,844168,850819,857314,863507,869742,875775,881796,887709,893587,899460,905206,910873,916404,921843,927225,932612,937872,943042,948197,953172,958084,963020,967908,972808,977591,982140,986758,991179,995799,1000308,1004764,1009167,1013563,1017710,1021913,1026020,1030120,1034196,1038189,1042115,1046040,1050058,1053987,1057855,1061608,1065304,
0,0,3,50,363,1316,3421,6933,11855,18405,26348,35602,45892,57231,69068,81781,95001,108670,122555,136754,151014,165289,179632,194111,208282,222613,236909,250941,264757,278358,291796,305085,318124,331195,344016,356724,369125,381278,393364,405142,416570,428137,439383,450458,461246,471923,482568,492844,502902,512775,522543,532082,541389,550649,559745,568917,577737,586500,595119,603579,611932,620280,628225,636206,643844,651503,658957,666490,673662,680757,687917,694862,701679,708496,715193,721663,728093,734436,740740,746859,753006,759114,765191,771102,776970,782709,788517,794126,799662,804993,810293,815594,820788,825827,830909,836033,840983,845875,850657,855532,860343,865017,869658,874320,878895,883517,887879,892358,896525,900878,905009,909131,913217,917328,921417,925442,929330,933337,937146,940953,
0,0,0,3,48,220,679,1627,3296,5863,9299,13617,18747,24785,31331,38766,46861,55354,64393,73931,83548,93601,103959,114389,124847,135476,146191,157059,168000,178916,189680,200558,211480,222204,232874,243314,253655,263893,274141,284214,294374,304372,314191,323993,333661,342991,352310,361574,370818,379937,388883,397936,406639,415284,423643,432061,440368,448479,456422,464423,472334,480155,487843,495186,502701,509986,517017,524128,531178,538174,544936,551700,558331,564931,571330,577838,584127,590479,596525,602659,608591,614457,620288,626094,631873,637533,643140,648687,654219,659645,665008,670374,675667,680672,685852,690854,695929,700837,705666,710606,715367,720115,724737,729378,734062,738659,743268,747584,751906,756189,760493,764514,768763,772952,777130,781200,785199,789158,793056,796941,
0,0,0,1,1,14,69,204,508,1063,2007,3278,5011,7196,9882,12963,16578,20576,25038,29873,35071,40702,46703,53062,59466,66112,73064,80182,87317,94720,102227,109852,117396,125037,132681,140522,148424,156262,163889,171729,179448,187233,195031,202753,210443,218041,225673,233032,240557,248090,255621,263025,270312,277533,284654,291919,298954,306081,313119,320020,326936,333804,340491,347169,353692,360290,366705,373082,379389,385688,391825,397955,404001,410091,416008,421999,427730,433623,439432,445087,450704,456271,461744,467154,472559,477875,483142,488409,493627,498794,503854,508875,513850,518681,523731,528569,533346,538210,542895,547562,552150,556700,561127,565560,570033,574412,578736,582919,587118,591346,595591,599821,603986,608036,612051,615995,619999,623824,627802,631658,
0,0,0,0,0,0,3,11,52,125,276,533,982,1516,2299,3328,4569,6028,7838,9836,12065,14523,17279,20331,23587,27126,30677,34512,38673,42884,47295,51904,56683,61560,66512,71585,76650,81790,87139,92522,97936,103378,108882,114342,119809,125242,130882,136520,142186,147719,153425,159012,164636,170152,175846,181553,187020,192549,198116,203594,209117,214666,220206,225723,231128,236474,241795,247174,252532,257732,262996,268243,273451,278609,283748,288761,293866,298985,304072,308852,313767,318524,323304,328107,333025,337538,342203,346903,351432,356002,360527,365228,369639,374079,378535,382929,387237,391621,395854,400165,404367,408573,412663,416773,420889,424874,428963,433032,437035,440986,444831,448660,452591,456342,460135,463891,467606,471329,474947,478431,
0,0,0,0,0,0,0,0,0,1,14,32,55,120,214,364,588,871,1212,1672,2183,2831,3602,4488,5481,6638,7881,9297,10850,12477,14283,16134,18225,20349,22640,24954,27449,30017,32587,35287,38061,40922,43832,46868,49990,53211,56480,59726,63120,66517,69930,73303,76825,80322,83971,87420,91101,94830,98569,102304,106160,109853,113666,117340,121186,124822,128608,132422,136156,139891,143773,147607,151351,155155,158984,162790,166606,170412,174214,177926,181797,185411,189091,192889,196651,200390,204057,207623,211225,214918,218486,222095,225706,229366,232951,236543,240039,243575,247040,250520,253987,257555,261088,264551,267991,271332,274733,278003,281404,284718,288081,291351,294684,297899,301135,304420,307633,310812,314008,317135,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,10,18,30,52,86,120,176,265,354,490,636,798,1009,1247,1542,1854,2204,2630,3112,3641,4200,4809,5483,6272,7022,7830,8706,9602,10606,11630,12751,13888,15125,16319,17606,18938,20302,21710,23232,24641,26189,27680,29245,30881,32548,34298,36059,37863,39657,41452,43324,45229,47140,49133,51059,53024,55084,57104,59205,61233,63377,65460,67527,69692,71848,74019,76150,78447,80663,82898,85107,87403,89683,91877,94163,96453,98756,101011,103306,105563,107746,110046,112329,114706,116904,119273,121558,123922,126178,128390,130713,133021,135419,137725,139951,142184,144437,146723,149037,151286,153582,155908,158191,160460,162745,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,3,5,10,16,22,32,39,53,66,91,112,139,178,227,280,333,398,466,558,648,767,886,1004,1146,1314,1474,1645,1852,2055,2270,2483,2719,2955,3226,3535,3835,4170,4479,4820,5211,5587,5995,6422,6857,7323,7762,8289,8820,9335,9859,10390,10977,11578,12168,12761,13367,14000,14665,15279,15931,16598,17274,17977,18684,19420,20169,20957,21735,22491,23244,23981,24839,25701,26572,27429,28294,29202,30118,31068,31992,32919,33825,34734,35666,36689,37712,38724,39741,40757,41785,42864,43898,44890,45911,46917,
49630,267928,491714,673620,820434,941335,1041946,1127139,1200449,1264494,1320543,1370313,1414858,1454890,1491844,1525272,1556413,1584659,1610562,1634633,1657547,1678693,1698502,1717094,1734596,1751043,1766492,1781261,1795116,1808459,1821092,1833022,1844524,1855648,1866311,1876346,1886050,1895241,1903984,1912551,1920938,1928821,1936452,1943925,1950994,1957868,1964512,1970954,1977308,1983427,1989313,1995000,2000391,2005691,2010920,2015932,2020854,2025637,2030239,2034808,2039276,2043627,2047884,2052000,2056051,2059913,2063646,2067455,2070999,2074464,2077884,2081326,2084637,2087809,2090913,2094030,2096990,2099830,2102642,2105451,2108309,2110927,2113545,2116036,2118594,2121075,2123494,2125898,2128310,2130608,2132813,2135007,2137215,2139244,2141309,2143380,2145370,2147436,2149400,2151244,2153190,2155078,2156940,2158703,2160443,2162183,2163899,2165628,2167268,2168831,2170408,2171987,2173493,2175078,2176587,2178060,2179471,2180863,2182280,2183610,
8135,102275,252553,400551,533822,650919,752192,841554,920316,990121,1052457,1108568,1159405,1205357,1247518,1286246,1322520,1355791,1386517,1415376,1442389,1467684,1491720,1514078,1535025,1555029,1573794,1591670,1608676,1624986,1640412,1655276,1669385,1683024,1695879,1708528,1720465,1731879,1742856,1753221,1763370,1773080,1782704,1792038,1800852,1809371,1817677,1825654,1833451,1840995,1848324,1855479,1862346,1869056,1875624,1882015,1888196,1894029,1899824,1905556,1911137,1916548,1921771,1927003,1932037,1936873,1941509,1946249,1950735,1955231,1959496,1963771,1967885,1971983,1975899,1979739,1983495,1987181,1990794,1994418,1998007,2001434,2004777,2008022,2011287,2014294,2017463,2020444,2023318,2026255,2029143,2031972,2034760,2037444,2040008,2042589,2045063,2047577,2050100,2052469,2054852,2057192,2059508,2061755,2064047,2066249,2068360,2070396,2072482,2074530,2076540,2078550,2080483,2082404,2084238,2086117,2088003,2089764,2091595,2093396,
1698,45024,143423,259526,373405,479149,575521,662189,740476,811186,875361,933726,986890,1035648,1079906,1121544,1160060,1195881,1229362,1260955,1290506,1318397,1344478,1369322,1392330,1414420,1435523,1455565,1474460,1492705,1509768,1526086,1541843,1557085,1571714,1585689,1599221,1612203,1624756,1636570,1648200,1659307,1670187,1680619,1690647,1700413,1709743,1718808,1727743,1736200,1744501,1752595,1760415,1768069,1775557,1782611,1789702,1796432,1803073,1809454,1815816,1822089,1828016,1833899,1839696,1845277,1850875,1856134,1861280,1866430,1871406,1876240,1880958,1885662,1890283,1894565,1898907,1903286,1907362,1911487,1915603,1919557,1923361,1927069,1930799,1934306,1937792,1941264,1944754,1948093,1951379,1954582,1957816,1960870,1963887,1966965,1969836,1972733,1975678,1978442,1981034,1983748,1986395,1989019,1991621,1994252,1996806,1999260,2001684,2004082,2006383,2008656,2011016,2013240,2015455,2017573,2019845,2021883,2023956,2026097,
156,12517,59665,132387,215285,300428,382563,459904,532461,599605,662062,719906,773780,823570,869972,913322,953910,991247,1027499,1061608,1093334,1123601,1152101,1179356,1205155,1229470,1252827,1275283,1296134,1316250,1335609,1354270,1371882,1389087,1405600,1421266,1436669,1451192,1465583,1479288,1492494,1505288,1517617,1529424,1540899,1552078,1562939,1573669,1583821,1593590,1603020,1612264,1621457,1630338,1638906,1647127,1655272,1663129,1670823,1678394,1685577,1692726,1699559,1706466,1713224,1719783,1726085,1732324,1738526,1744491,1750307,1755981,1761631,1767053,1772344,1777468,1782604,1787554,1792453,1797202,1801858,1806407,1810855,1815298,1819546,1823774,1827892,1831954,1835950,1839874,1843724,1847424,1851168,1854771,1858433,1862047,1865642,1869100,1872440,1875817,1879078,1882214,1885461,1888544,1891548,1894462,1897513,1900398,1903192,1906040,1908739,1911502,1914174,1916780,1919349,1921921,1924314,1926783,1929244,1931647,
0,1341,13292,42305,85677,137587,193927,251809,309097,365145,419047,471064,520582,568152,612968,655358,695300,733574,769933,805177,838288,869712,899776,928618,956284,982501,1007787,1031683,1054872,1077300,1098605,1119078,1139058,1158118,1176378,1194375,1211303,1227945,1243957,1259298,1274286,1288769,1302750,1316286,1329582,1342309,1355069,1367396,1379047,1390515,1401740,1412561,1423149,1433495,1443344,1453125,1462744,1471845,1481007,1489685,1498250,1506621,1514841,1522875,1530670,1538239,1545835,1553071,1560242,1567211,1574029,1580674,1587356,1593801,1599989,1606203,1612119,1617943,1623806,1629539,1635193,1640745,1646156,1651370,1656633,1661679,1666693,1671509,1676315,1681186,1685787,1690319,1694752,1698996,1703371,1707685,1711836,1715928,1720026,1724035,1727989,1731968,1735805,1739583,1743267,1746890,1750514,1754077,1757519,1760877,1764137,1767437,1770653,1773898,1777081,1780150,1783178,1786204,1789092,1791975,
0,239,4164,17333,41349,74494,113884,157331,202392,248237,294300,339586,383833,426527,467765,507437,545483,582411,617618,651660,683982,715132,745474,773981,801488,828285,853636,878486,902240,924849,946839,968010,988547,1008476,1027626,1046138,1064039,1081308,1098012,1114487,1130258,1145669,1160749,1175436,1189658,1203408,1216780,1229522,1242313,1254444,1266443,1278084,1289240,1300447,1311255,1321774,1331936,1341925,1351749,1361096,1370455,1379634,1388501,1397205,1405714,1414057,1422058,1429989,1437797,1445259,1452740,1459965,1467126,1474282,1481094,1487932,1494427,1500933,1507484,1513760,1519886,1525959,1531832,1537522,1543200,1548769,1554121,1559417,1564820,1569998,1575160,1580158,1585080,1589996,1594846,1599582,1604306,1608808,1613195,1617629,1622016,1626285,1630444,1634599,1638702,1642786,1646700,1650671,1654548,1658314,1661960,1665700,1669344,1673022,1676451,1679938,1683275,1686660,1690053,1693318,
0,15,754,4805,14597,31024,53574,80720,111164,144107,178347,213670,249391,284812,319513,353927,387337,420289,452836,484046,514176,543307,571905,599560,625934,651885,676905,700950,724736,747573,769749,791314,812256,832214,851648,870721,889380,906996,924380,941246,957653,973580,989128,1004513,1019248,1033568,1047524,1061274,1074886,1087705,1100381,1113015,1125172,1137064,1148736,1159791,1170928,1181574,1192191,1202318,1212390,1222097,1231721,1241152,1250218,1259202,1267991,1276520,1285218,1293395,1301460,1309355,1317216,1324906,1332576,1340035,1347271,1354350,1361241,1368100,1374728,1381396,1388011,1394448,1400662,1406757,1412761,1418771,1424525,1430278,1436010,1441542,1447053,1452490,1457716,1462977,1468151,1473339,1478308,1483181,1487995,1492626,1497373,1501995,1506547,1510937,1515439,1519670,1523947,1528202,1532334,1536450,1540380,1544450,1548252,1552087,1555936,1559798,1563499,1567015,
0,0,47,674,3029,8270,17227,29744,45381,63905,84727,107230,131194,156050,181773,207877,233777,260162,286109,312012,337593,362734,387374,411497,435229,458584,481570,503829,525680,547116,567639,588027,608081,627569,646424,664761,682985,700719,717867,734545,750998,766784,782605,798072,812977,827789,842087,856251,869823,883153,896347,909470,921853,934157,946177,958080,969488,980736,991713,1002571,1013017,1023336,1033536,1043522,1053246,1062835,1072288,1081559,1090575,1099515,1108241,1116733,1125190,1133597,1141703,1149655,1157491,1165196,1172671,1180123,1187386,1194600,1201611,1208527,1215422,1222187,1228781,1235313,1241819,1248205,1254426,1260661,1266733,1272594,1278499,1284222,1289830,1295387,1300905,1306271,1311672,1316921,1322192,1327286,1332399,1337333,1342296,1347205,1352053,1356826,1361558,1366013,1370525,1375000,1379385,1383682,1387984,1392217,1396355,1400472,
0,0,1,34,250,1016,2804,5952,10696,17408,25713,35880,47330,60245,74144,89021,105001,121368,138672,156075,173904,191764,209673,227853,245785,264040,282033,300106,317813,335086,352566,369867,386716,403461,420148,436615,452619,468554,484440,499858,514941,529803,544368,558781,572898,586747,600532,614000,627033,639938,652648,664991,677273,689490,701272,712836,724401,735628,746734,757470,768142,778648,789047,799291,809308,819042,828749,838266,847751,856728,865628,874750,883329,892021,900626,909029,917222,925276,933284,941042,948709,956357,963808,971144,978549,985720,993026,999896,1006559,1013359,1020032,1026619,1032996,1039392,1045717,1051922,1058077,1064191,1070104,1075957,1081780,1087588,1093256,1098840,1104244,1109661,1114922,1120190,1125448,1130568,1135687,1140731,1145778,1150760,1155610,1160409,1165136,1169842,1174431,1178853,
0,0,0,3,28,155,523,1378,2995,5498,8989,13566,19082,25804,33394,41914,51427,61747,72799,84452,96650,109165,122138,135215,148683,162365,176149,189884,204016,217949,232212,246257,260159,274113,288002,301896,315485,328936,342440,355583,368856,381948,394805,407721,420397,432928,445288,457465,469645,481318,493030,504605,515952,527174,538459,549349,560211,570928,581414,591781,602166,612409,622419,632304,642039,651638,660932,670248,679389,688394,697139,705832,714425,722909,731186,739452,747587,755479,763300,771025,778688,786352,793751,801183,808442,815665,822826,829967,836813,843511,850287,856953,863500,870090,876489,882751,889062,895238,901397,907345,913249,919125,924860,930564,936271,941868,947291,952635,958100,963386,968549,973715,978793,983893,989004,994027,998959,1003943,1008762,1013524,
0,0,0,0,0,11,51,177,472,1046,1952,3422,5308,7816,10975,14704,19066,24071,29742,35819,42483,49611,57403,65343,73697,82353,91317,100469,109859,119533,129355,139386,149682,159883,170162,180534,190889,201127,211568,222110,232541,243095,253710,264166,274543,284873,295084,305235,315289,325400,335420,345165,355016,364910,374686,384225,393717,403051,412494,421634,430750,439772,448661,457391,466237,474836,483275,491668,500095,508319,516511,524565,532476,540349,548104,555726,563331,570954,578473,585795,593140,600324,607358,614397,621366,628260,635162,641834,648592,655300,661774,668337,674517,680871,687141,693331,699398,705370,711261,717185,723018,728739,734430,740005,745568,751060,756540,761964,767387,772644,777801,782961,788107,793119,797990,802925,807786,812690,817594,822321,
0,0,0,0,0,0,1,11,38,92,206,459,845,1417,2187,3264,4576,6192,8087,10447,13146,16055,19226,22891,26857,31280,35821,40699,45782,51098,56459,62256,68256,74422,80763,87239,93736,100424,107259,114042,120961,128133,135325,142648,149733,157202,164616,171947,179107,186708,194246,201595,209198,216703,224129,231566,238859,246187,253370,260740,267933,275176,282355,289515,296485,303613,310430,317596,324571,331594,338552,345442,352223,358887,365525,372252,378888,385453,391855,398284,404640,410848,417212,423382,429591,435646,441782,447741,453779,459742,465571,471372,477074,482710,488395,494077,499717,505150,510629,516117,521460,526655,531897,537126,542248,547357,552480,557452,562554,567439,572373,577301,582142,586940,591660,596434,601199,605795,610335,614908,
0,0,0,0,0,0,0,0,1,3,9,33,71,119,212,369,600,907,1298,1821,2390,3159,4018,5041,6253,7705,9265,10888,12792,14893,17069,19399,21951,24613,27423,30559,33754,37006,40476,44097,47677,51497,55315,59314,63467,67620,71802,76179,80476,84847,89361,93943,98538,103238,107894,112666,117451,122200,127070,131934,136715,141708,146697,151442,156433,161314,166128,171229,176132,181221,186227,191083,196054,200923,205882,210889,215933,220931,225990,230791,235708,240561,245384,250210,255019,259736,264369,269140,273715,278412,283080,287705,292330,296977,301597,306127,310599,315116,319636,324135,328414,332818,337183,341563,345917,350133,354452,358674,362918,367207,371418,375590,379675,383752,387802,391947,395943,399972,403865,407809,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,31,53,83,149,222,318,463,595,812,1081,1354,1728,2149,2595,3158,3798,4523,5248,6085,7014,8008,9107,10248,11448,12755,14113,15573,17087,18636,20366,22134,23888,25821,27766,29732,31836,33959,36130,38359,40604,42855,45176,47513,50047,52579,55081,57587,60279,62924,65569,68299,71096,74032,76831,79685,82579,85481,88442,91490,94529,97451,100408,103455,106557,109675,112711,115772,118821,121967,125070,128120,131275,134357,137534,140694,143857,146902,150068,153208,156210,159402,162504,165644,168641,171595,174680,177763,180908,183983,187070,190096,193184,196198,199189,202226,205267,208261,211237,214240,217245,220199,223142,226089,229071,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,9,14,20,36,62,83,122,161,214,273,350,440,556,717,864,1052,1272,1503,1776,2054,2402,2750,3142,3584,4066,4581,5111,5680,6315,6995,7676,8450,9200,10015,10868,11738,12680,13595,14553,15563,16669,17798,18938,20080,21269,22504,23823,25069,26408,27798,29204,30629,32134,33590,35079,36593,38139,39700,41294,42806,44391,46094,47749,49436,51158,52896,54656,56325,58087,59917,61753,63624,65449,67258,69098,71078,72948,74791,76726,78606,80468,82451,84329,86310,88232,90171,92206,94129,96114,98064,100089,102078,104081,106142,108155,110193,112164,114171,116196,118192,120188,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,9,14,19,26,35,50,69,88,120,154,190,233,275,341,413,485,570,674,798,927,1057,1222,1388,1563,1732,1924,2167,2376,2636,2927,3209,3524,3868,4198,4551,4916,5271,5680,6112,6584,7032,7495,7998,8470,8995,9585,10182,10773,11342,11926,12608,13319,13993,14725,15417,16112,16829,17558,18280,19068,19872,20703,21499,22351,23199,24066,24937,25826,26730,27633,28586,29531,30471,31473,32420,33442,34435,35422,36397,37440,38464,39488,40517,41605,42700,43817,44860,45959,47025,48129,49240,50366,51453,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,3,6,8,9,13,20,25,28,35,48,59,74,94,108,136,161,185,215,243,278,303,340,382,436,495,561,622,697,783,877,970,1067,1159,1272,1362,1493,1628,1763,1884,2022,2168,2315,2480,2657,2835,3040,3252,3473,3673,3916,4147,4367,4607,4865,5133,5391,5652,5877,6135,6423,6733,7040,7352,7717,8051,8392,8751,9103,9477,9843,10235,10614,10988,11437,11861,12278,12651,13070,13496,13955,14389,14832,15311,15790,16285,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,5,5,5,6,8,8,9,11,14,15,18,19,24,32,40,46,51,58,64,73,83,90,101,113,129,137,162,179,199,214,246,276,297,328,350,375,402,433,475,513,553,594,635,665,708,753,828,889,955,1007,1078,1136,1198,1270,1327,1396,1471,1560,1656,1737,1832,1911,2011,2109,2196,2296,2381,2494,2608,2721,2836,2954,
58129,285484,508181,686456,828540,944810,1040634,1122542,1192486,1253205,1306146,1353343,1395400,1433466,1468341,1499949,1529404,1555846,1580349,1603233,1624604,1644379,1662964,1680418,1697068,1712468,1727001,1740716,1753637,1766140,1778114,1789354,1800024,1810503,1820339,1829804,1838897,1847462,1855786,1863674,1871446,1878802,1885924,1893008,1899611,1906211,1912409,1918392,1924121,1929824,1935317,1940568,1945780,1950722,1955534,1960345,1964960,1969321,1973628,1977879,1981983,1985934,1989794,1993644,1997372,2001031,2004490,2007856,2011249,2014572,2017737,2020846,2023884,2026942,2029865,2032756,2035487,2038194,2040927,2043570,2046083,2048613,2051140,2053633,2056006,2058399,2060651,2062873,2065067,2067177,2069336,2071335,2073343,2075229,2077292,2079223,2081130,2082950,2084724,2086620,2088381,2090064,2091816,2093413,2095012,2096686,2098298,2099818,2101309,2102837,2104334,2105749,2107166,2108594,2109940,2111278,2112522,2113942,2115276,2116597,
11049,118224,274379,424156,555842,669472,767196,852451,927671,993688,1052340,1105546,1153001,1196496,1235751,1272023,1305432,1336525,1365271,1392228,1417101,1440723,1462653,1483646,1503194,1521442,1539083,1555596,1571270,1586129,1600476,1614064,1627026,1639630,1651476,1662928,1673997,1684589,1694599,1704302,1713618,1722692,1731400,1739829,1748093,1755996,1763537,1770926,1777948,1784803,1791426,1797928,1804178,1810438,1816510,1822246,1827961,1833487,1838855,1844016,1849184,1854087,1858805,1863497,1868136,1872656,1876999,1881216,1885406,1889410,1893329,1897233,1901038,1904721,1908336,1911843,1915230,1918628,1921957,1925199,1928338,1931450,1934378,1937322,1940314,1943164,1945977,1948748,1951470,1954158,1956830,1959433,1961959,1964428,1966866,1969212,1971593,1973876,1976113,1978345,1980563,1982772,1984925,1987042,1989089,1991119,1993133,1995073,1996971,1998847,2000664,2002431,2004246,2006028,2007810,2009542,2011221,2012890,2014529,2016213,
2840,56884,166215,287048,401894,506744,600594,684083,759602,826823,887264,941953,991954,1037608,1079606,1118286,1154441,1187833,1218689,1247810,1274985,1300734,1324922,1347489,1368873,1389185,1408422,1426621,1444098,1460619,1476267,1491464,1505852,1519473,1532776,1545580,1557852,1569837,1581098,1591990,1602364,1612468,1622196,1631648,1640834,1649563,1658013,1666519,1674440,1682186,1689703,1696961,1704130,1711001,1717558,1724085,1730396,1736592,1742554,1748416,1754172,1759870,1765279,1770624,1775717,1780781,1785558,1790294,1794935,1799465,1803900,1808295,1812558,1816685,1820808,1824800,1828797,1832662,1836372,1840073,1843725,1847301,1850780,1854281,1857720,1860904,1864114,1867339,1870358,1873349,1876268,1879133,1882012,1884781,1887549,1890249,1892890,1895551,1898109,1900756,1903273,1905735,1908194,1910538,1912909,1915167,1917404,1919668,1921884,1924095,1926209,1928279,1930286,1932275,1934258,1936265,1938243,1940119,1942007,1943782,
354,18813,77628,159045,247624,334617,417073,493842,565195,630325,689951,744937,795766,842935,886392,926782,964348,999710,1032795,1063782,1093298,1120860,1146948,1171899,1195189,1217487,1238646,1258892,1277964,1296205,1313919,1330674,1346633,1361869,1376624,1391015,1404719,1417675,1430398,1442607,1454498,1465960,1476839,1487541,1497962,1507853,1517625,1526973,1535965,1544725,1553206,1561504,1569491,1577429,1585000,1592503,1599708,1606759,1613653,1620272,1626731,1632937,1639292,1645309,1651241,1657101,1662780,1668193,1673669,1678927,1684089,1688995,1694019,1698802,1703560,1708144,1712672,1717161,1721528,1725738,1729868,1733958,1737974,1741941,1745675,1749389,1753064,1756677,1760183,1763610,1767059,1770447,1773770,1776884,1780006,1783188,1786301,1789274,1792289,1795246,1798019,1800926,1803788,1806551,1809203,1811953,1814512,1817136,1819623,1822189,1824716,1827116,1829564,1831946,1834210,1836484,1838755,1841056,1843326,1845427,
8,3049,22571,61667,113746,172820,234206,294797,353672,410660,464224,514736,562310,607775,650556,690684,728673,764180,797971,830150,860698,889700,917196,943453,968798,992992,1015758,1037700,1058724,1078797,1097759,1116215,1134019,1151128,1167538,1183363,1198490,1213226,1227514,1241189,1254561,1267485,1279908,1291798,1303501,1314792,1325872,1336585,1347038,1356978,1366714,1376177,1385483,1394283,1403033,1411445,1419877,1427897,1435784,1443510,1450951,1458187,1465426,1472433,1479284,1485870,1492367,1498788,1505159,1511277,1517259,1523067,1528724,1534299,1539696,1545047,1550256,1555359,1560419,1565304,1570185,1575017,1579808,1584474,1588983,1593392,1597574,1601776,1605939,1610036,1614025,1617931,1621902,1625667,1629335,1633026,1636589,1640122,1643621,1647025,1650399,1653691,1656946,1660232,1663555,1666786,1669858,1672956,1675972,1678957,1681808,1684711,1687616,1690470,1693221,1695894,1698555,1701137,1703746,1706245,
1,742,8611,29885,63278,104930,151518,200649,250070,298583,346100,391824,436163,478256,518600,556997,593283,628028,661095,692897,723183,752317,780025,806533,831734,855884,879143,901705,922845,943534,963516,982466,1000963,1018524,1035733,1052083,1068033,1083667,1098418,1112998,1127086,1140531,1153707,1166448,1178818,1190799,1202472,1213652,1224786,1235427,1245943,1255972,1265834,1275442,1284868,1293850,1302741,1311359,1319842,1328207,1336211,1344083,1351673,1359185,1366400,1373545,1380515,1387247,1394071,1400786,1407307,1413736,1419914,1426009,1431799,1437634,1443401,1448978,1454391,1459713,1465093,1470278,1475280,1480320,1485198,1490026,1494671,1499348,1503863,1508245,1512662,1517004,1521242,1525500,1529549,1533538,1537512,1541499,1545367,1549230,1552919,1556563,1560143,1563680,1567169,1570615,1573963,1577354,1580603,1583812,1586860,1589920,1593038,1596198,1599191,1602170,1605092,1607936,1610809,1613623,
0,129,2358,10924,28094,52899,83618,118548,155460,193692,232230,270764,308350,344750,380462,414936,448543,480829,512334,542571,571283,599050,625808,651698,676585,700550,723450,745443,767247,787936,807906,827090,845829,863968,881626,898553,915110,930953,946185,961026,975678,989566,1003229,1016448,1029403,1042034,1054423,1066363,1077944,1089157,1100174,1111024,1121558,1131748,1141638,1151255,1160725,1169919,1178919,1187693,1196295,1204628,1212907,1220912,1228751,1236624,1244119,1251501,1258706,1265740,1272670,1279600,1286336,1292715,1299028,1305370,1311585,1317569,1323479,1329335,1335012,1340627,1346159,1351633,1356960,1362264,1367283,1372315,1377325,1382132,1386912,1391694,1396452,1400992,1405390,1409750,1414050,1418418,1422645,1426841,1430963,1434932,1438824,1442739,1446580,1450370,1454076,1457791,1461469,1465046,1468503,1471977,1475404,1478802,1482091,1485319,1488508,1491766,1494872,1498018,
0,8,360,2672,8835,19929,35831,56031,79326,104694,131635,159620,188481,217355,246322,274645,303039,330809,358271,384627,410512,435417,459986,483882,506835,529487,551330,572513,593163,613160,632734,651535,669884,687703,705053,721994,738256,754118,769633,784641,799314,813442,827576,841100,854148,866957,879433,891961,903878,915662,927043,938245,949315,960044,970613,980686,990749,1000510,1009842,1019113,1028196,1037070,1045815,1054286,1062633,1070834,1078808,1086750,1094456,1101882,1109158,1116450,1123461,1130465,1137400,1144147,1150748,1157055,1163449,1169846,1176039,1182146,1188086,1193836,1199575,1205270,1210757,1216227,1221562,1226891,1232086,1237145,1242196,1247277,1252058,1256813,1261592,1266154,1270900,1275399,1279830,1284163,1288487,1292571,1296744,1300720,1304713,1308645,1312621,1316571,1320416,1324184,1327921,1331630,1335236,1338879,1342477,1345912,1349326,1352743,
0,0,18,306,1556,4641,10181,18144,28728,41700,56541,73040,90883,109888,129574,149713,170130,190818,211496,232225,252618,273111,293139,312818,332676,351805,370959,389516,407690,425540,443057,460075,476738,493259,509369,525292,540715,555857,570701,585137,599221,613105,626599,640051,653123,665747,678033,690154,702015,713692,725048,736231,747066,757802,768223,778595,788811,798447,808260,817619,826990,836180,845095,853841,862558,870998,879154,887170,895363,903132,910896,918513,925898,933305,940522,947493,954401,961284,968217,974713,981215,987627,994010,1000152,1006225,1012083,1018148,1023949,1029629,1035200,1040832,1046354,1051641,1056925,1062072,1067265,1072265,1077339,1082289,1087082,1091828,1096494,1101095,1105793,1110312,1114808,1119100,1123474,1127805,1131978,1136161,1140213,1144181,1148390,1152495,1156386,1160238,1164041,1167887,1171502,
0,0,1,53,336,1242,3373,6921,12065,18952,27615,37627,49211,61846,75279,89539,104473,119989,135720,151820,168252,184658,201277,218005,234253,250713,266841,283052,298922,314464,329843,345180,360120,374940,389599,403841,418107,431959,445534,459066,472183,485224,498087,510558,522668,534658,546440,558053,569623,580724,591714,602444,613014,623432,633677,643626,653652,663318,672981,682289,691496,700619,709529,718161,726761,735127,743486,751568,759534,767324,775119,782590,790141,797662,804889,812001,818898,825691,832579,839250,845654,852217,858758,865135,871213,877415,883464,889339,895028,900772,906553,912136,917557,922911,928333,933573,938861,943975,949128,954139,959025,963712,968474,973318,978087,982693,987205,991700,996153,1000401,1004812,1009064,1013204,1017288,1021490,1025643,1029660,1033514,1037446,1041239,
0,0,0,1,46,243,795,1862,3763,6597,10564,15513,21637,28667,36521,45074,54550,64561,75046,86049,97690,109703,121718,134260,146730,159382,172057,184675,197374,210023,222739,235399,248102,260521,272928,285191,297077,309210,321097,332768,344198,355567,366863,378103,389152,400050,410576,421164,431468,441849,452242,462397,472189,481972,491628,500965,510451,519512,528663,537451,546292,555031,563446,571853,580093,588241,596152,604009,611684,619258,626927,634392,641723,649103,656381,663319,670151,676948,683583,690094,696445,702930,709234,715361,721475,727551,733683,739655,745536,751204,756753,762376,767984,773380,778791,784128,789414,794512,799636,804542,809533,814369,819259,824054,828797,833527,838187,842847,847361,851901,856141,860479,864804,869051,873262,877371,881374,885357,889443,893511,
0,0,0,0,2,17,98,324,768,1564,2799,4607,6943,9942,13515,17707,22439,27846,33787,40162,46922,54079,61656,69508,77802,86377,95056,103890,112894,122054,131360,140750,150201,159792,169294,178843,188232,197621,206849,216297,225853,235206,244488,253822,262986,272187,281243,289961,298764,307632,316244,324801,333249,341711,350213,358608,366798,374923,382905,390814,398718,406377,413986,421492,429007,436387,443637,450739,457787,464928,472000,478906,485738,492422,499106,505816,512275,518726,524914,531077,537218,543229,549155,555077,560971,566767,572427,578090,583699,589213,594719,600069,605404,610677,615980,621120,626112,631079,636063,640986,645914,650744,655496,660172,664784,669380,673883,678429,682882,687254,691479,695695,699904,703945,708179,712293,716399,720377,724309,728170,
0,0,0,0,0,1,5,35,101,227,431,810,1371,2230,3370,4755,6578,8664,11142,13953,17042,20440,24116,28191,32650,37264,42090,47195,52466,57959,63317,69204,75016,80940,87194,93553,99975,106401,112874,119417,126024,132666,139513,146090,152886,159701,166331,173102,179806,186437,193226,199829,206661,213331,220051,226721,233272,239996,246501,252946,259439,265840,272055,278294,284495,290763,296878,303051,309111,315022,320721,326708,332559,338349,344104,349720,355310,361062,366576,372132,377607,383015,388385,393672,398873,404214,409356,414356,419338,424288,429269,434191,439017,443705,448446,453293,458017,462589,467196,471712,476371,480754,485088,489453,493824,498009,502289,506457,510611,514750,518885,522923,526948,530934,534862,538799,542573,546399,550097,553890,
0,0,0,0,0,0,0,1,1,7,28,80,171,289,457,729,1096,1639,2234,2995,3906,4931,6204,7622,9214,10962,12984,15089,17326,19748,22330,25077,28056,31082,34299,37636,40987,44498,48149,51899,55751,59628,63611,67773,71800,75854,80102,84498,88843,93121,97506,101948,106305,110795,115221,119727,124279,128872,133415,138034,142564,147207,151685,156261,160693,165192,169698,174243,178813,183154,187617,192093,196618,200907,205170,209561,213832,218242,222674,227074,231434,235793,240047,244294,248486,252664,256853,260800,265005,269094,273127,277145,281254,285305,289273,293156,297034,300869,304689,308579,312295,316023,319716,323451,327232,330894,334494,338104,341648,345101,348493,351923,355322,358731,362128,365656,369062,372354,375653,378918,
0,0,0,0,0,0,0,0,0,0,0,2,13,22,40,87,134,225,340,515,722,989,1307,1685,2129,2687,3284,3985,4803,5715,6665,7735,8943,10232,11531,12950,14449,16052,17779,19624,21446,23437,25496,27519,29621,31887,34215,36577,38930,41336,43824,46443,49019,51639,54269,57057,59773,62599,65372,68249,71195,74178,77121,80088,83052,86045,88999,92015,95001,98078,101091,104169,107304,110400,113459,116589,119533,122701,125821,128913,132060,135094,138073,141120,144113,147275,150372,153573,156629,159660,162686,165744,168721,171730,174783,177806,180826,183908,186931,189938,192828,195706,198677,201695,204597,207553,210411,213228,216089,218912,221815,224626,227461,230269,233052,235742,238520,241343,244043,246748,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,8,12,21,28,45,72,105,155,209,278,373,493,638,814,995,1209,1468,1735,2049,2433,2826,3276,3767,4274,4866,5504,6189,6893,7592,8405,9242,10222,11183,12087,13142,14188,15350,16456,17690,18924,20095,21311,22620,23987,25352,26802,28287,29734,31287,32806,34373,35996,37590,39207,40900,42589,44291,45997,47697,49413,51124,52941,54810,56621,58424,60251,62203,64102,66000,67952,69805,71691,73635,75602,77583,79519,81500,83462,85425,87327,89259,91195,93109,95114,97079,99111,101104,103044,105022,106905,108922,110849,112851,114797,116821,118788,120736,122634,124660,126720,128670,130670,132648,134599,136557,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,12,18,32,42,57,79,100,129,159,206,263,320,416,500,601,712,844,987,1153,1340,1541,1779,2014,2274,2531,2827,3129,3446,3765,4109,4504,4887,5285,5721,6140,6584,7069,7600,8113,8662,9235,9806,10406,11028,11626,12262,12932,13641,14389,15086,15813,16606,17329,18094,18916,19747,20564,21451,22271,23164,24118,24933,25841,26736,27689,28595,29545,30519,31441,32429,33406,34423,35426,36417,37454,38516,39572,40653,41702,42761,43841,44851,45942,47046,48142,49200,50291,51425,52567,53672,54781,55907,57031,58229,59376,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,6,6,7,10,12,15,23,35,38,46,60,73,97,114,130,148,172,201,232,256,293,341,386,437,483,545,602,681,746,826,918,1019,1118,1223,1337,1454,1586,1717,1860,1995,2139,2288,2465,2639,2828,2998,3194,3409,3620,3820,4035,4262,4500,4732,5004,5259,5493,5793,6087,6372,6655,6926,7212,7484,7782,8100,8431,8769,9083,9428,9754,10081,10422,10781,11158,11551,11954,12348,12721,13151,13532,13911,14326,14713,15118,15539,15980,
65925,301247,522584,697240,835882,948601,1041365,1119594,1187000,1245300,1295839,1340997,1381259,1417605,1450409,1480363,1507909,1533135,1556412,1578350,1598642,1617455,1635090,1651601,1667389,1682077,1695760,1708854,1721031,1732956,1744268,1754954,1765154,1775008,1784258,1793345,1801953,1810033,1817965,1825489,1832730,1839754,1846538,1853189,1859430,1865539,1871382,1877058,1882547,1887831,1892976,1898015,1902926,1907637,1912241,1916794,1921205,1925442,1929436,1933441,1937267,1941173,1944879,1948448,1951911,1955380,1958709,1961816,1965033,1968143,1971151,1974157,1976999,1979837,1982704,1985455,1988073,1990687,1993181,1995640,1998115,2000617,2003021,2005328,2007534,2009811,2012031,2014257,2016402,2018434,2020384,2022376,2024302,2026185,2028047,2029855,2031664,2033433,2035197,2036953,2038607,2040303,2041957,2043569,2045098,2046648,2048050,2049526,2051041,2052520,2053985,2055379,2056778,2058169,2059520,2060835,2062148,2063500,2064742,2066017,
14622,133052,294971,444533,573783,684486,779126,861221,933191,996758,1052174,1102717,1147835,1189002,1226371,1260616,1292315,1321641,1348660,1373850,1397511,1419717,1440563,1460064,1478512,1495921,1512420,1527883,1542508,1556605,1569999,1582869,1594898,1606459,1617662,1628381,1638846,1648716,1658254,1667331,1676102,1684469,1692620,1700569,1708371,1715747,1722870,1729748,1736425,1742951,1749173,1755347,1761312,1767095,1772588,1777984,1783120,1788203,1793311,1798098,1802842,1807436,1811954,1816367,1820570,1824818,1828938,1832836,1836797,1840514,1844200,1847734,1851333,1854760,1858154,1861504,1864761,1867990,1871187,1874223,1877253,1880273,1883053,1885853,1888642,1891402,1894106,1896820,1899391,1901934,1904412,1906829,1909206,1911553,1913831,1916145,1918330,1920495,1922667,1924818,1926932,1928963,1931019,1932955,1934944,1936881,1938753,1940658,1942497,1944306,1946033,1947753,1949478,1951167,1952872,1954511,1956133,1957777,1959412,1960992,
4252,68958,186754,311312,426209,529215,620986,702377,775067,839178,896706,948887,996422,1039774,1079149,1115766,1149251,1180768,1209908,1237216,1262702,1286696,1309411,1330523,1350501,1369494,1387538,1404705,1420869,1436194,1450972,1465084,1478391,1491221,1503649,1515379,1526753,1537638,1548260,1558471,1568102,1577304,1586272,1595075,1603602,1611756,1619838,1627652,1635146,1642303,1649282,1655968,1662699,1669199,1675546,1681579,1687594,1693193,1698775,1704150,1709381,1714432,1719509,1724519,1729344,1734054,1738664,1743020,1747374,1751601,1755797,1759910,1763863,1767776,1771486,1775213,1778849,1782515,1786069,1789541,1792835,1796101,1799349,1802545,1805643,1808738,1811737,1814809,1817679,1820509,1823290,1826090,1828744,1831328,1833893,1836402,1838894,1841274,1843676,1846091,1848461,1850783,1853106,1855360,1857548,1859692,1861774,1863869,1866021,1868078,1870045,1872033,1873903,1875905,1877778,1879524,1881350,1883089,1884899,1886582,
662,26097,94903,183967,275934,364930,447103,522671,591796,655083,711938,764245,812610,857089,898463,936371,972057,1004945,1035854,1064606,1091870,1117855,1142177,1165423,1187153,1207909,1227431,1246260,1264064,1281005,1297230,1312919,1327795,1341995,1355634,1368784,1381247,1393478,1405109,1416284,1427304,1437894,1448105,1457934,1467383,1476609,1485709,1494353,1502699,1510562,1518447,1526147,1533536,1540796,1547706,1554648,1561213,1567678,1573940,1580145,1586025,1591848,1597549,1603153,1608633,1613872,1619078,1624151,1629203,1633984,1638668,1643281,1647751,1652133,1656479,1660759,1664870,1668862,1672853,1676713,1680520,1684260,1687941,1691590,1695056,1698468,1701903,1705334,1708651,1711788,1714942,1718136,1721213,1724217,1727202,1730172,1733056,1735818,1738613,1741247,1743961,1746611,1749213,1751768,1754189,1756727,1759149,1761541,1763811,1766232,1768475,1770730,1772940,1775118,1777364,1779508,1781543,1783581,1785641,1787653,
37,5506,32479,80348,139819,203726,268116,330345,390123,446486,499363,549007,595271,638685,679578,717773,753722,787472,819636,850141,878520,905488,931294,955787,979046,1001212,1022180,1042457,1061819,1080241,1097923,1114959,1131118,1146927,1161876,1176568,1190669,1204325,1217106,1229722,1241720,1253517,1264970,1275871,1286427,1296807,1306853,1316636,1326097,1335178,1344046,1352666,1361054,1369201,1376836,1384707,1392346,1399899,1406995,1414085,1420961,1427572,1434110,1440419,1446546,1452418,1458324,1464174,1469879,1475445,1480832,1486163,1491295,1496257,1501208,1506036,1510880,1515514,1520162,1524670,1529098,1533311,1537510,1541692,1545825,1549756,1553643,1557455,1561184,1564909,1568517,1572165,1575789,1579248,1582678,1586005,1589330,1592620,1595799,1599055,1602146,1605183,1608148,1611116,1614110,1617000,1619858,1622664,1625407,1628078,1630683,1633316,1635874,1638467,1641005,1643466,1645931,1648310,1650614,1652982,
7,1719,14655,43829,85051,133349,184809,237118,289035,339594,387478,433667,476947,518282,557575,594491,629193,662221,693670,723513,752540,779748,805649,830530,854095,876649,898056,918638,938366,957458,975469,992769,1009697,1025916,1041593,1056577,1071112,1085243,1098799,1111979,1124801,1137059,1149075,1160630,1171976,1182881,1193491,1203900,1213986,1223734,1233025,1242006,1250977,1259727,1268068,1276317,1284396,1292108,1299691,1307222,1314554,1321679,1328754,1335602,1342181,1348641,1354840,1361016,1367092,1373019,1378733,1384402,1390010,1395390,1400630,1405800,1410831,1416025,1420872,1425797,1430581,1435327,1439939,1444424,1448848,1453228,1457383,1461491,1465617,1469563,1473562,1477396,1481282,1485131,1488843,1492529,1496042,1499543,1502902,1506390,1509726,1513107,1516338,1519500,1522654,1525762,1528748,1531789,1534839,1537813,1540562,1543369,1546168,1548957,1551663,1554355,1556946,1559534,1562186,1564726,
0,348,4989,19142,43551,75617,112719,152351,193484,234746,275396,315459,354016,391448,427451,462235,495255,526587,556424,585445,613328,639836,665307,689916,713126,735379,757079,777825,797851,817084,835876,853598,871023,887819,903751,919635,934807,949384,963402,977116,990343,1003095,1015703,1027774,1039379,1050817,1061850,1072554,1083084,1093306,1103243,1112935,1122408,1131574,1140404,1148996,1157494,1165703,1173776,1181726,1189357,1196856,1204105,1211198,1218279,1225175,1231921,1238643,1245134,1251595,1257904,1263929,1269950,1275735,1281397,1287090,1292513,1297976,1303340,1308612,1313840,1318912,1323927,1328744,1333570,1338311,1342837,1347253,1351511,1355879,1360099,1364280,1368482,1372650,1376693,1380575,1384334,1388144,1392055,1395691,1399319,1402888,1406328,1409812,1413169,1416451,1419789,1423117,1426217,1429416,1432591,1435739,1438828,1441866,1444866,1447755,1450575,1453378,1456149,1459009,
0,39,1112,6138,17010,34059,56135,82263,111072,141308,172524,204168,235352,266715,296888,326390,355570,383563,411210,437629,463315,488081,512129,535248,557592,579171,600259,620328,639765,658636,676994,694869,712050,728716,744937,760656,776025,790784,805289,818883,832312,845397,858270,870761,882830,894552,905989,917184,927970,938635,949036,959108,968914,978595,987960,997186,1006256,1014958,1023433,1031699,1039790,1047801,1055593,1063130,1070770,1078157,1085305,1092340,1099247,1105829,1112319,1118852,1125340,1131536,1137638,1143696,1149463,1155206,1160828,1166452,1171968,1177274,1182738,1187922,1193016,1198098,1203041,1208021,1212824,1217411,1221957,1226511,1230988,1235463,1239742,1243971,1248069,1252137,1256184,1260114,1263984,1267845,1271623,1275401,1279091,1282711,1286170,1289778,1293387,1296776,1300220,1303501,1306896,1310172,1313339,1316594,1319781,1322883,1325939,1328974,
0,1,118,1079,4232,10672,20667,33610,49683,67836,87896,109218,131122,153855,176765,199645,222746,245336,268020,290237,311914,333189,354296,374795,394649,414123,432943,451485,469374,486913,504216,520727,536952,552822,568240,583303,597990,612471,626430,640065,653309,666351,678958,691469,703464,715221,726689,737997,748864,759525,769968,780289,790472,800028,809640,818985,828079,836919,845812,854431,862981,871065,879188,886941,894738,902387,909877,917109,924245,931300,938203,944925,951586,958249,964510,970861,977049,983138,989184,994948,1000645,1006361,1012025,1017550,1022968,1028421,1033805,1039006,1044088,1048976,1053892,1058752,1063428,1067970,1072600,1077130,1081713,1086010,1090382,1094574,1098837,1102966,1106992,1111171,1115206,1119200,1123100,1126885,1130708,1134461,1138066,1141736,1145204,1148740,1152258,1155769,1159226,1162593,1165998,1169289,
0,0,15,263,1297,3975,8753,15792,25244,36878,50247,65164,81044,97857,115388,133470,151715,170309,188870,207328,225602,243869,261950,279692,297050,314480,331528,348366,364896,381193,397044,412394,427425,442195,456735,471040,484880,498422,511900,524982,537710,550354,562599,574473,586264,597751,608982,619990,630783,641226,651550,661603,671469,681102,690570,699883,709101,717947,726947,735414,743829,751994,760060,768065,775926,783540,791056,798397,805629,812702,819693,826550,833277,839894,846389,852922,859239,865168,871282,877238,883070,888933,894685,900370,906003,911387,916698,921928,927255,932378,937420,942429,947214,952013,956630,961326,965858,970398,974997,979442,983776,988040,992256,996365,1000449,1004602,1008557,1012651,1016512,1020226,1024068,1027836,1031456,1035090,1038659,1042211,1045777,1049250,1052653,1056060,
0,0,1,33,289,1056,2838,5959,10559,16616,24089,32857,42819,54132,65983,78590,91637,105543,119671,133821,148127,162639,177258,191741,206317,220741,235189,249397,263619,277736,291424,305106,318492,331712,344851,357520,370094,382448,394573,406563,418353,430041,441331,452470,463433,474115,484674,494974,505222,515154,524977,534657,543832,553173,562210,571202,580098,588894,597458,605998,614218,622512,630355,638070,645791,653379,660751,668042,675218,682273,689228,695922,702647,709330,715831,722163,728422,734522,740576,746371,752328,758155,763872,769519,775065,780483,785988,791345,796587,801876,807027,812081,817133,822021,826671,831388,836024,840589,845259,849865,854165,858591,862887,867350,871550,875858,879942,883922,887929,891937,895814,899607,903328,907196,910705,914423,918092,921664,925222,928769,
0,0,0,2,44,198,636,1582,3291,5658,9048,13474,18615,24658,31308,38731,46923,55679,64881,74655,84614,94955,105509,116319,127308,138230,149313,160246,171459,182576,193966,205005,216138,227041,237975,248598,259186,269630,280012,290438,300663,310808,320780,330600,340298,349917,359267,368629,377998,386978,396189,405023,413701,422344,430688,439051,447320,455254,463221,471037,478812,486398,493947,501264,508684,515744,522760,529738,536640,543511,550234,556913,563329,569722,576153,582447,588442,594560,600482,606299,611918,617565,623090,628682,634038,639249,644669,649965,655163,660035,665045,670060,675030,679810,684565,689278,693976,698698,703191,707736,712172,716543,720830,725092,729233,733276,737408,741491,745494,749469,753425,757305,761131,764884,768602,772371,776133,779760,783376,786865,
0,0,0,0,0,14,80,222,595,1292,2366,3857,5788,8354,11438,14997,19037,23621,28654,34007,39924,45956,52514,59367,66436,73682,81245,88879,96435,104370,112276,120192,128181,136203,144462,152734,160844,168883,176889,184998,193164,201221,209116,217117,225030,232966,240925,248589,256325,263895,271470,278864,286267,293726,301035,308318,315439,322457,329333,336218,342941,349619,356290,362802,369137,375524,381960,388304,394452,400530,406672,412823,418649,424630,430523,436231,441870,447628,453098,458522,463803,469073,474289,479446,484490,489571,494514,499481,504295,509164,513961,518775,523382,528074,532671,537184,541608,545920,550463,554834,559151,563435,567597,571796,575803,579870,583897,587857,591701,595666,599491,603212,606898,610609,614328,617931,621513,625124,628587,632031,
0,0,0,0,0,0,4,15,60,155,340,648,1145,1792,2692,3796,5206,6792,8737,10993,13500,16302,19316,22576,26168,29936,33860,38114,42399,46941,51459,56367,61224,66188,71352,76658,82075,87416,92897,98547,104237,109734,115359,120964,126530,132271,138125,143833,149483,155057,160840,166539,172131,177713,183356,189032,194565,200085,205575,211024,216479,221859,227423,232729,238065,243320,248542,253763,258802,264053,269137,274165,279155,284094,288937,293901,298773,303660,308275,312913,317545,322215,326725,331223,335781,340236,344592,348939,353349,357653,361879,366013,370267,374417,378533,382583,386573,390565,394445,398275,402150,405950,409648,413469,417154,420785,424452,428049,431672,435227,438804,442376,445862,449289,452652,456143,459418,462757,465909,469083,
0,0,0,0,0,0,0,0,1,13,30,72,145,256,443,707,1079,1586,2183,2881,3713,4716,5956,7253,8714,10343,12111,13997,16097,18309,20627,23032,25710,28452,31293,34194,37204,40302,43627,46992,50345,53835,57344,60965,64680,68365,72144,75921,79790,83589,87418,91322,95170,99125,103041,106949,110870,114882,118945,122917,126826,130744,134686,138687,142802,146717,150731,154715,158710,162643,166578,170510,174323,178126,182024,185917,189753,193508,197331,201093,204872,208646,212447,216087,219838,223470,227110,230594,234206,237747,241277,244744,248284,251724,255233,258655,262036,265397,268736,272021,275377,278538,281820,285058,288165,291396,294597,297823,300984,304203,307236,310155,313191,316129,319079,322022,324865,327759,330667,333528,
0,0,0,0,0,0,0,0,0,0,0,1,6,17,30,62,119,188,276,388,581,806,1072,1393,1766,2233,2758,3351,3987,4752,5512,6435,7419,8463,9596,10805,12053,13411,14818,16323,17773,19375,21060,22702,24498,26357,28292,30313,32388,34438,36566,38739,40907,43081,45338,47556,49851,52194,54550,56913,59300,61700,64114,66627,69171,71793,74406,76989,79597,82195,84764,87404,90037,92754,95406,98055,100692,103298,105898,108518,111143,113750,116431,119030,121615,124204,126842,129476,132099,134762,137447,140158,142673,145178,147712,150300,152830,155367,157958,160346,162812,165196,167664,170107,172586,174973,177425,179858,182293,184619,187076,189474,191881,194307,196705,199083,201417,203701,206039,208299,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,8,19,28,40,61,80,112,158,210,298,380,503,633,788,937,1157,1386,1625,1889,2232,2559,2946,3343,3797,4261,4760,5284,5883,6481,7092,7786,8541,9313,10106,10960,11771,12622,13579,14562,15461,16422,17417,18486,19603,20663,21779,22937,24101,25260,26475,27708,28933,30279,31588,32941,34194,35487,36872,38224,39556,40908,42278,43712,45111,46533,48017,49532,51046,52475,53970,55461,56939,58393,59920,61435,62967,64551,66095,67695,69289,70825,72300,73867,75430,77045,78671,80180,81794,83335,84880,86426,88053,89648,91235,92768,94357,95960,97578,99114,100704,102302,103822,105308,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,8,12,15,20,30,40,54,68,81,105,121,155,199,225,276,324,395,464,531,619,721,816,929,1043,1174,1318,1458,1634,1799,1981,2173,2378,2615,2851,3109,3357,3655,3937,4202,4495,4818,5155,5476,5825,6205,6539,6937,7370,7763,8184,8658,9133,9592,10048,10531,11014,11468,11970,12482,13019,13549,14118,14681,15286,15856,16395,16972,17576,18147,18770,19383,20013,20643,21310,21919,22597,23238,23901,24560,25259,25950,26620,27242,27916,28633,29366,30104,30797,31565,32294,33021,33727,34485,35297,
73795,316180,536654,707795,842805,951591,1041136,1116835,1181907,1237634,1286554,1329619,1368262,1403154,1434601,1463317,1489674,1513990,1536184,1556992,1576263,1594392,1611138,1626982,1641978,1656032,1669316,1681896,1693753,1704971,1715896,1725848,1735691,1745021,1753791,1762400,1770761,1778689,1786180,1793335,1800244,1807018,1813386,1819750,1825780,1831697,1837410,1842888,1848148,1853211,1858197,1863106,1867699,1872271,1876720,1881011,1885054,1889144,1892948,1896695,1900499,1904144,1907744,1911363,1914717,1917978,1921188,1924275,1927301,1930302,1933238,1936086,1938974,1941651,1944339,1946960,1949582,1952041,1954558,1956879,1959330,1961638,1963904,1966166,1968326,1970474,1972588,1974738,1976685,1978622,1980596,1982529,1984441,1986245,1988073,1989857,1991581,1993320,1995008,1996698,1998329,1999986,2001594,2003156,2004704,2006238,2007707,2009189,2010640,2012023,2013431,2014855,2016262,2017584,2018934,2020286,2021564,2022819,2024087,2025321,
18303,147938,313826,463975,590999,698601,790759,869805,939369,1000151,1053463,1101483,1144834,1184011,1219767,1252128,1282399,1310256,1336217,1360246,1382628,1403797,1423266,1441601,1459010,1475585,1491166,1506017,1519943,1533141,1545577,1557821,1569353,1580372,1590988,1601107,1610742,1620133,1629198,1637848,1646127,1654221,1662071,1669544,1676860,1683924,1690682,1697271,1703644,1709737,1715526,1721252,1726840,1732371,1737802,1742985,1748026,1752875,1757596,1762194,1766603,1770988,1775195,1779426,1783536,1787434,1791335,1795126,1798878,1802517,1806054,1809547,1812962,1816252,1819430,1822717,1825847,1828783,1831828,1834756,1837560,1840326,1843004,1845693,1848305,1850857,1853469,1856088,1858480,1860972,1863386,1865686,1868038,1870260,1872521,1874677,1876825,1878872,1880916,1882902,1884820,1886795,1888747,1890645,1892566,1894509,1896269,1898036,1899833,1901531,1903212,1904871,1906494,1908098,1909689,1911258,1912830,1914330,1915862,1917422,
5903,80856,205727,332646,447984,549847,639647,718649,788932,850608,905546,955264,1000688,1041983,1079711,1114170,1146328,1175750,1203283,1229103,1253268,1275803,1297390,1317315,1336331,1354215,1371064,1387243,1402660,1417237,1431265,1444564,1457251,1469292,1480870,1492053,1502840,1513073,1522994,1532608,1541868,1550571,1558991,1567307,1575323,1583131,1590606,1597996,1605195,1611869,1618525,1624900,1631187,1637202,1642879,1648698,1654170,1659578,1664846,1669921,1674792,1679667,1684456,1689079,1693552,1697957,1702462,1706660,1710866,1714935,1718808,1722691,1726416,1730023,1733561,1737125,1740588,1743912,1747143,1750410,1753601,1756656,1759698,1762668,1765614,1768479,1771283,1774194,1776829,1779558,1782195,1784726,1787296,1789831,1792176,1794599,1796993,1799338,1801657,1803927,1806176,1808409,1810573,1812681,1814777,1816825,1818880,1820854,1822810,1824666,1826644,1828511,1830346,1832168,1833994,1835806,1837582,1839281,1841039,1842687,
1113,33523,111528,206001,300469,389682,471296,545071,612878,674087,729427,779704,825889,868652,907848,944122,977851,1009226,1038499,1066021,1091923,1116235,1139233,1160688,1181143,1200788,1219088,1236937,1253711,1269763,1285098,1299772,1313497,1326847,1339823,1352062,1363923,1375312,1386222,1396886,1406923,1416863,1426292,1435591,1444339,1453012,1461437,1469559,1477388,1485006,1492266,1499509,1506313,1513214,1519736,1526119,1532237,1538246,1544096,1549781,1555400,1560887,1566253,1571467,1576586,1581659,1586475,1591371,1595944,1600487,1604823,1609068,1613313,1617441,1621501,1625450,1629486,1633349,1637055,1640755,1644426,1648028,1651491,1654741,1658000,1661289,1664450,1667546,1670607,1673650,1676670,1679606,1682458,1685286,1688074,1690850,1693505,1696163,1698789,1701390,1703830,1706334,1708811,1711185,1713556,1715961,1718239,1720484,1722745,1724914,1727018,1729158,1731250,1733331,1735358,1737427,1739405,1741357,1743275,1745169,
93,8440,42940,98160,163307,231501,297947,361103,420888,476633,528167,576662,621622,663190,702415,738926,773305,805167,835629,864321,891205,916744,940983,963904,985989,1006736,1026226,1045219,1063356,1080697,1097251,1113233,1128289,1142883,1156765,1170442,1183570,1196364,1208465,1220261,1231383,1242424,1253123,1263323,1273165,1282626,1291970,1301050,1309822,1318319,1326596,1334786,1342575,1350240,1357489,1364657,1371762,1378656,1385309,1391782,1398011,1404174,1410174,1416104,1421711,1427234,1432639,1438043,1443163,1448415,1453370,1458258,1463133,1467801,1472402,1476978,1481498,1485830,1490124,1494400,1498558,1502557,1506525,1510321,1514147,1518010,1521613,1525208,1528758,1532161,1535478,1538817,1542143,1545385,1548561,1551662,1554630,1557635,1560637,1563672,1566596,1569390,1572199,1575079,1577676,1580346,1582911,1585510,1588061,1590523,1593020,1595532,1597993,1600477,1602864,1605169,1607451,1609742,1611897,1614155,
10,3157,21485,57679,105683,159057,214093,268541,321449,372287,420274,465626,508462,548839,586962,622735,656431,688100,718287,746848,773898,799706,824075,847400,869730,891127,911580,931007,949465,967292,984338,1000534,1016348,1031743,1046221,1060499,1073986,1087121,1099686,1111926,1123658,1135332,1146353,1157080,1167473,1177318,1187141,1196851,1206241,1215319,1224023,1232509,1240811,1248946,1256644,1264244,1271758,1278958,1286078,1292957,1299610,1306057,1312328,1318604,1324657,1330554,1336484,1342253,1347831,1353327,1358714,1363895,1369055,1374074,1378990,1383805,1388476,1393065,1397686,1402194,1406591,1410953,1415256,1419338,1423444,1427484,1431368,1435223,1438982,1442672,1446303,1449851,1453489,1456985,1460440,1463718,1467066,1470334,1473501,1476620,1479728,1482791,1485866,1488771,1491632,1494460,1497377,1500143,1502917,1505653,1508375,1511039,1513561,1516179,1518733,1521270,1523663,1526059,1528549,1530893,
1,818,8525,28398,59381,97388,139458,183097,227027,270444,312180,352876,391896,429046,464715,498613,530843,561084,590172,618120,644948,670404,694525,717861,739949,761065,781560,800954,819936,838034,855663,872550,888949,904709,919784,934591,948720,962237,975186,987929,1000432,1012173,1023709,1034900,1045835,1056502,1066868,1076724,1086340,1095744,1104896,1113840,1122568,1131078,1139224,1147115,1154985,1162587,1170060,1177290,1184419,1191430,1198168,1204884,1211177,1217526,1223705,1229775,1235596,1241462,1247104,1252771,1258245,1263625,1268755,1273914,1278988,1283966,1288884,1293640,1298399,1302979,1307492,1311967,1316458,1320869,1325049,1329290,1333322,1337289,1341170,1345070,1348885,1352573,1356275,1359896,1363478,1366967,1370375,1373758,1377217,1380634,1383852,1387105,1390184,1393245,1396374,1399377,1402407,1405300,1408202,1411020,1413860,1416632,1419400,1422133,1424802,1427392,1429893,1432382,
0,117,2431,10660,26451,49028,76503,107492,140281,173931,207655,241090,274123,306242,337553,367742,396939,424981,452452,478669,503786,528090,551464,573861,595483,616190,636372,655462,673910,692009,709416,726333,742548,758126,773368,788074,802495,816416,829810,843021,855671,867908,879974,891557,902807,913692,924292,934700,944617,954471,964148,973443,982677,991767,1000558,1009026,1017273,1025308,1033008,1040650,1048223,1055635,1062708,1069664,1076590,1083359,1089929,1096234,1102592,1108808,1114872,1120799,1126519,1132227,1137848,1143372,1148812,1154005,1159199,1164438,1169458,1174327,1179125,1183895,1188364,1192964,1197466,1201856,1206286,1210519,1214777,1218898,1223027,1227037,1231081,1234928,1238817,1242551,1246304,1249878,1253528,1256976,1260456,1263968,1267437,1270691,1273931,1277158,1280401,1283600,1286734,1289790,1292755,1295855,1298756,1301670,1304498,1307400,1310168,1312888,
0,8,356,2590,8395,18646,33033,50695,71286,93692,117525,142358,167442,192540,217506,242077,266552,290681,314199,336830,359027,380493,401570,421813,441669,461058,479858,497918,515338,532291,548933,565059,580484,595780,610532,624890,638882,652564,665747,678802,691327,703575,715508,727070,738399,749385,760317,770824,781097,790981,800691,810102,819487,828564,837561,846443,854891,863413,871540,879310,887248,894902,902407,909622,916806,923789,930685,937430,944004,950340,956601,962809,968927,974996,980783,986551,992236,997806,1003248,1008627,1014072,1019312,1024529,1029566,1034552,1039472,1044244,1048952,1053676,1058150,1062628,1067115,1071383,1075537,1079748,1083919,1087983,1092075,1096086,1099897,1103753,1107476,1111142,1114986,1118651,1122279,1125717,1129252,1132675,1136043,1139332,1142681,1145993,1149213,1152438,1155622,1158797,1161909,1164919,1167899,
0,1,82,831,3241,8372,16619,27452,41017,56794,73997,92486,111752,131795,151841,172341,192663,212925,232961,252700,272334,291673,310510,328861,346838,364373,381653,398403,414792,430980,446430,461814,476775,491184,505283,519173,532918,546087,558928,571394,583546,595476,607155,618558,629821,640756,651367,661809,671880,681769,691463,700969,710259,719416,728454,737291,745828,754071,762270,770290,778147,785748,793444,800741,808013,815154,822141,829148,835858,842556,849114,855409,861628,867648,873646,879625,885545,891113,896636,902100,907377,912582,917940,923189,928421,933434,938478,943285,948170,952836,957412,962017,966393,970701,975065,979513,983649,987871,991897,995892,999894,1003815,1007624,1011471,1015330,1019146,1022872,1026463,1030043,1033535,1037024,1040482,1043825,1047042,1050323,1053638,1056822,1060025,1063177,1066262,
0,0,12,159,919,2977,6628,12443,20060,29570,40638,53033,66398,80614,95580,111025,127018,143289,159392,175665,191907,208257,224283,239983,255541,270923,286088,301154,315786,330291,344343,358009,371803,385210,398305,411308,423760,436301,448451,460312,471900,483342,494341,505102,515964,526475,536645,546565,556388,565952,575484,584674,593635,602556,611239,619911,628196,636488,644400,652507,660080,667693,675236,682656,689919,697111,704116,711043,717620,724321,730767,737069,743322,749479,755597,761578,767419,773015,778681,784343,789717,795179,800569,805908,811060,815991,821111,826116,830990,835767,840519,845221,849794,854216,858689,863056,867453,871709,875738,879945,883839,887887,891897,895877,899798,903736,907603,911341,914933,918548,922057,925508,928972,932343,935870,939194,942501,945769,948912,952096,
0,0,1,29,164,715,1970,4188,7589,12303,18238,25383,33502,42456,52290,62559,73550,85083,96898,109003,121413,133799,146337,159079,171822,184257,196742,209171,221537,233636,245535,257663,269776,281274,292750,304219,315280,326182,336940,347586,358057,368247,378367,388378,398211,407814,417323,426687,435949,444855,453671,462257,470653,478931,487168,495246,503303,511183,519070,526660,534113,541337,548768,555821,562903,569886,576672,583321,589828,596255,602716,608968,615099,621206,627128,633030,638756,644416,650045,655513,660995,666263,671563,676833,681985,687064,692064,697107,701889,706684,711339,715991,720538,725035,729652,734021,738325,742560,746786,750971,755117,759093,763030,766968,770893,774727,778584,782323,785969,789777,793348,796909,800540,804099,807538,811020,814389,817678,820897,824128,
0,0,0,1,20,102,365,917,2041,3759,6146,9290,13147,17619,22868,28873,35171,41924,49163,57021,65066,73504,82253,91177,100183,109300,118590,127855,137119,146640,156142,165573,174866,184133,193399,202590,211624,220688,229732,238620,247483,256152,264940,273740,282099,290361,298515,306667,314800,322776,330846,338433,346008,353498,360819,368272,375498,382608,389609,396552,403260,409953,416549,423164,429608,436064,442308,448545,454752,460791,466884,472833,478722,484320,489931,495421,501050,506520,511969,517269,522424,527554,532543,537663,542697,547515,552237,556995,561788,566460,571115,575645,580081,584297,588692,593099,597281,601428,605603,609638,613701,617767,621618,625422,629257,633133,636925,640568,644336,647930,651487,655012,658622,662039,665412,668815,672322,675635,678856,682114,
0,0,0,0,0,3,24,108,298,684,1295,2197,3424,5067,7030,9428,12319,15417,18939,22834,27124,31728,36481,41742,47083,52559,58440,64233,70363,76458,82818,89212,95556,102043,108495,115149,121721,128405,135147,141845,148494,155203,161806,168386,175171,181822,188365,194818,201255,207644,214157,220531,226859,233023,239188,245387,251369,257342,263255,269104,274859,280729,286380,292021,297524,303117,308564,314080,319379,324625,329848,335106,340382,345448,350487,355509,360337,365223,370222,374985,379746,384345,388858,393534,398129,402605,407050,411445,415874,420024,424232,428419,432606,436666,440677,444801,448852,452881,456889,460653,464459,468251,471912,475585,479229,482930,486428,489839,493355,496803,500271,503646,506983,510262,513507,516764,520029,523163,526233,529379,
0,0,0,0,0,0,6,17,42,107,235,454,766,1200,1802,2599,3549,4709,6122,7798,9647,11670,13970,16447,19114,22013,25001,28315,31758,35335,39076,42922,46863,50905,55106,59378,63780,68263,72760,77324,82064,86680,91352,96044,100783,105511,110193,115110,119946,124754,129499,134258,138967,143687,148357,153211,157886,162531,167223,171836,176447,181187,185862,190481,194966,199412,203872,208418,212847,217185,221508,225848,230109,234359,238602,242947,246997,251240,255390,259416,263298,267391,271395,275389,279273,283068,286970,290861,294640,298359,302056,305697,309384,313010,316519,320001,323510,327027,330511,334037,337383,340735,344098,347340,350600,353875,357081,360335,363474,366664,369740,372891,375973,379010,382014,384871,387868,390751,393493,396358,
0,0,0,0,0,0,0,0,0,2,12,30,53,109,209,355,582,847,1189,1622,2176,2819,3570,4445,5408,6473,7650,8977,10425,11890,13532,15349,17104,19105,21244,23410,25656,27941,30306,32789,35324,37887,40524,43246,46025,48830,51677,54566,57416,60370,63334,66306,69389,72432,75635,78759,81816,84988,88108,91276,94441,97563,100789,103927,107133,110369,113497,116667,119911,123062,126230,129373,132498,135629,138799,141934,145138,148283,151381,154536,157675,160629,163642,166730,169706,172738,175770,178785,181799,184787,187626,190474,193490,196412,199331,202154,205027,207866,210711,213586,216383,219128,221933,224549,227255,229992,232722,235393,238071,240680,243310,245965,248536,251188,253822,256255,258704,261261,263793,266149,
0,0,0,0,0,0,0,0,0,0,0,1,1,3,7,17,35,65,98,138,216,323,443,598,777,992,1249,1525,1865,2255,2682,3156,3679,4291,4872,5544,6257,7101,7909,8810,9713,10683,11647,12712,13824,15016,16183,17476,18724,20077,21439,22832,24295,25744,27275,28763,30251,31819,33368,35004,36654,38346,40080,41823,43539,45263,47018,48788,50567,52375,54236,56065,57863,59822,61730,63662,65563,67514,69480,71366,73328,75206,77135,79043,80982,82876,84796,86738,88724,90638,92646,94581,96554,98458,100386,102352,104287,106254,108153,110038,112002,113862,115753,117783,119654,121615,123553,125375,127276,129235,131121,132982,134925,136808,138684,140512,142287,144089,145915,147716,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,4,6,10,18,29,39,55,79,109,145,189,244,309,370,454,556,669,766,902,1038,1197,1365,1553,1768,2022,2298,2590,2867,3131,3441,3780,4143,4540,4926,5318,5762,6232,6665,7122,7641,8145,8670,9188,9753,10342,10957,11527,12163,12778,13402,14074,14774,15484,16237,16935,17695,18404,19141,19896,20700,21453,22296,23059,23911,24711,25546,26385,27217,28072,28951,29807,30712,31635,32543,33422,34337,35271,36238,37157,38093,39036,39988,40993,41988,42922,43849,44828,45798,46815,47811,48845,49852,50802,51796,52796,53852,54872,55820,56774,
81881,329312,548667,716149,847739,953724,1040575,1113646,1176316,1230549,1277498,1319122,1356468,1389912,1420430,1448280,1473821,1497019,1518372,1538466,1557196,1574579,1590606,1605885,1620316,1633988,1646654,1658595,1670161,1680991,1691291,1701137,1710520,1719497,1728132,1736413,1744371,1751957,1759349,1766280,1772919,1779363,1785627,1791710,1797528,1803195,1808690,1814059,1819162,1824171,1828985,1833743,1838303,1842732,1847116,1851248,1855139,1859170,1862886,1866491,1870168,1873673,1877074,1880443,1883735,1886927,1889986,1893014,1895922,1898829,1901664,1904473,1907093,1909764,1912411,1914977,1917474,1919864,1922297,1924564,1926878,1929104,1931306,1933481,1935681,1937740,1939827,1941956,1943903,1945787,1947743,1949540,1951414,1953179,1954900,1956674,1958480,1960125,1961709,1963345,1964864,1966465,1968065,1969535,1971080,1972551,1973983,1975420,1976775,1978182,1979564,1980956,1982356,1983725,1985084,1986370,1987677,1988881,1990118,1991342,
22357,161816,330659,479522,604634,709558,799874,876954,943688,1002077,1053874,1100053,1141803,1179488,1213530,1245251,1274010,1300703,1325556,1348659,1369755,1389979,1408858,1426424,1443224,1459062,1473952,1488188,1501647,1514305,1526364,1537850,1548764,1559240,1569324,1578994,1588328,1597273,1605928,1614264,1622282,1629876,1637122,1644107,1651142,1657841,1664398,1670827,1676905,1682656,1688312,1693938,1699433,1704715,1709806,1714829,1719540,1724320,1728956,1733366,1737590,1741828,1745986,1750056,1753932,1757699,1761586,1765257,1768813,1772293,1775744,1779117,1782280,1785451,1788471,1791545,1794527,1797535,1800379,1803235,1805972,1808641,1811199,1813831,1816334,1818800,1821179,1823653,1826002,1828341,1830632,1832901,1835107,1837253,1839284,1841367,1843434,1845460,1847454,1849347,1851261,1853142,1855003,1856869,1858630,1860477,1862284,1863927,1865568,1867227,1868805,1870471,1872056,1873607,1875113,1876608,1878101,1879569,1881047,1882558,
8099,92586,223890,352207,467254,567776,655135,731727,799777,859140,912470,960515,1003870,1043361,1079319,1112475,1143125,1171622,1197704,1222306,1245182,1266803,1287265,1306511,1324612,1341667,1357723,1373276,1387693,1401723,1414902,1427749,1439749,1451134,1462139,1472742,1482895,1492606,1502030,1511213,1520085,1528673,1536745,1544555,1552126,1559508,1566672,1573646,1580334,1586790,1593092,1599168,1605052,1610962,1616612,1622055,1627384,1632550,1637549,1642356,1647034,1651758,1656246,1660712,1665052,1669301,1673507,1677481,1681422,1685288,1689102,1692763,1696361,1699859,1703290,1706760,1710029,1713248,1716403,1719448,1722446,1725489,1728462,1731378,1734154,1736851,1739487,1742192,1744830,1747399,1749883,1752413,1754894,1757326,1759616,1761910,1764235,1766514,1768689,1770896,1772976,1775026,1777065,1779109,1781135,1783079,1785084,1786954,1788883,1790670,1792467,1794266,1796025,1797789,1799523,1801244,1802929,1804580,1806135,1807755,
1778,41240,127548,226475,322994,412387,493061,565811,631841,691071,744449,793071,837515,878063,915860,950530,982401,1012196,1040088,1066213,1090817,1113998,1135910,1156671,1176307,1194916,1212405,1229118,1245011,1260025,1274295,1288287,1301564,1314278,1326414,1338113,1349263,1359983,1370383,1380444,1390141,1399421,1408387,1417068,1425449,1433505,1441522,1449317,1456805,1464047,1471068,1477828,1484393,1490670,1496941,1503050,1508902,1514711,1520379,1525830,1531218,1536534,1541479,1546443,1551317,1556038,1560480,1564970,1569333,1573667,1577703,1581915,1586026,1589898,1593722,1597598,1601296,1605041,1608618,1612113,1615506,1618907,1622230,1625445,1628568,1631716,1634738,1637766,1640778,1643662,1646485,1649322,1652100,1654775,1657343,1659996,1662634,1665172,1667641,1670113,1672456,1674839,1677141,1679417,1681622,1683804,1685978,1688175,1690364,1692458,1694483,1696481,1698486,1700417,1702332,1704280,1706110,1708015,1709863,1711720,
166,11947,53618,115477,185137,255573,323652,387328,446890,502114,553004,600156,643553,684053,721802,757261,789896,820607,849826,877069,902825,926994,950030,972175,992891,1012563,1031223,1049367,1066326,1082716,1098433,1113448,1127921,1142060,1155288,1167979,1180451,1192227,1203427,1214424,1224852,1235157,1245152,1254797,1264167,1273158,1281996,1290609,1298935,1306932,1314570,1322248,1329571,1336742,1343667,1350447,1357074,1363514,1369817,1375883,1381828,1387763,1393555,1398973,1404345,1409618,1414699,1419666,1424683,1429582,1434393,1439069,1443626,1448074,1452460,1456643,1460777,1464855,1468927,1472873,1476713,1480604,1484400,1488038,1491624,1495165,1498524,1501970,1505359,1508598,1511851,1514996,1518055,1521110,1524096,1527069,1529997,1532821,1535587,1538408,1541086,1543746,1546356,1548864,1551427,1553990,1556511,1558938,1561372,1563744,1566195,1568498,1570715,1572917,1575152,1577403,1579582,1581718,1583837,1585876,
33,5009,28984,71801,125477,182578,240363,296627,350505,401658,449036,494130,536240,575489,612568,647171,679420,710002,738877,766319,792251,816956,840248,862516,883492,903834,922925,941412,958893,975911,991818,1007104,1022160,1036690,1050281,1063537,1076416,1088869,1100806,1112300,1123510,1134302,1144703,1154872,1164791,1174120,1183277,1192308,1201033,1209568,1217741,1225776,1233498,1241190,1248616,1255694,1262728,1269688,1276280,1282721,1289030,1295169,1301219,1307088,1312756,1318453,1323926,1329237,1334552,1339668,1344758,1349773,1354557,1359208,1363774,1368243,1372690,1376977,1381307,1385490,1389645,1393778,1397736,1401623,1405486,1409280,1412921,1416546,1420076,1423516,1427028,1430452,1433706,1436914,1440111,1443264,1446275,1449317,1452393,1455364,1458325,1461310,1464048,1466874,1469626,1472318,1475097,1477780,1480220,1482774,1485201,1487675,1490125,1492532,1494949,1497305,1499628,1501981,1504213,1506396,
8,1520,12898,38326,74682,117436,163032,209752,255466,299945,342881,384340,423047,459794,495026,528102,559697,589445,617631,644493,669967,694500,717761,740059,761475,781754,801329,820014,837927,855004,871832,887801,903121,917956,932157,945869,959338,972258,984574,996423,1007971,1019235,1030163,1040720,1050795,1060797,1070397,1079823,1088921,1097717,1106403,1114789,1123092,1130958,1138796,1146199,1153566,1160697,1167662,1174512,1181176,1187589,1193993,1200163,1206143,1211956,1217798,1223628,1229030,1234459,1239923,1245234,1250340,1255408,1260333,1265102,1269780,1274389,1278943,1283392,1287704,1292040,1296305,1300593,1304645,1308861,1312778,1316662,1320383,1324085,1327782,1331427,1334940,1338406,1341926,1345352,1348611,1351845,1355083,1358285,1361432,1364462,1367486,1370442,1373436,1376297,1379124,1381951,1384651,1387328,1389989,1392665,1395269,1397897,1400517,1403083,1405575,1408037,1410468,1412787,
0,303,4197,16209,37036,64766,96931,131451,167607,203769,239699,274374,308019,340792,372258,402515,431463,459404,486243,511754,536260,559890,582255,603997,625033,645207,664364,682814,700924,718012,734580,750707,766154,780963,795310,809388,823011,836183,849100,861426,873215,884841,896148,907001,917696,927895,937827,947594,957169,966398,975327,984190,992598,1001059,1009275,1017074,1024693,1032284,1039542,1046740,1053816,1060656,1067245,1073753,1080303,1086608,1092623,1098657,1104711,1110444,1116124,1121642,1126986,1132541,1137683,1142723,1147800,1152643,1157646,1162417,1167028,1171701,1176328,1180683,1184964,1189348,1193630,1197747,1201863,1205793,1209638,1213574,1217340,1220978,1224617,1228308,1231916,1235438,1238834,1242256,1245562,1248849,1252051,1255235,1258358,1261386,1264478,1267618,1270546,1273512,1276321,1279192,1281975,1284888,1287670,1290366,1293036,1295587,1298144,1300737,
0,25,834,4784,13689,27714,46570,68396,92638,118420,145177,172139,199258,225932,252165,277627,302681,327175,351122,374168,396714,418301,439080,459294,478970,497750,516190,534045,551054,567451,583380,599214,614310,628994,643129,657016,670319,683531,696156,708424,720483,731990,743377,754432,765088,775566,785727,795578,805252,814641,823867,832822,841585,850141,858429,866777,874711,882529,890376,897797,905154,912296,919254,925965,932600,939062,945568,951943,958206,964211,970261,976155,981986,987501,993088,998342,1003638,1008800,1013894,1019024,1023946,1028915,1033742,1038373,1043059,1047578,1052092,1056550,1060902,1065129,1069241,1073342,1077342,1081329,1085256,1089131,1092897,1096708,1100274,1103998,1107494,1111072,1114668,1118156,1121484,1124822,1128115,1131367,1134684,1137912,1141053,1144126,1147214,1150258,1153196,1156080,1159056,1161884,1164702,1167466,
0,7,228,1817,6138,14009,25612,40283,57559,76662,97101,118207,140146,162305,184289,206196,227858,249352,270350,290865,310919,330634,349884,368680,386665,404182,421419,438363,454789,470705,486009,500975,515656,529880,543841,557230,570317,583121,595522,607564,619207,630622,641897,652756,663321,673902,683924,693864,703688,713023,722198,731212,740052,748586,756999,765443,773357,781149,788880,796473,803850,811035,818095,825054,832014,838652,845191,851626,858076,864294,870408,876413,882244,887966,893585,899268,904674,909910,915128,920315,925445,930464,935452,940253,944996,949636,954361,958908,963476,967884,972105,976327,980451,984447,988419,992424,996387,1000188,1004083,1007796,1011571,1015215,1018809,1022410,1025932,1029493,1032874,1036173,1039472,1042685,1045879,1049048,1052230,1055369,1058397,1061470,1064483,1067450,1070388,1073176,
0,1,53,471,2114,5770,11891,20581,31174,43796,57917,73230,89741,106495,123904,141604,159432,177210,194808,212044,229511,246642,263344,279907,296093,312214,327778,343218,358004,372557,386800,400583,414283,427526,440349,453013,465547,477772,489798,501257,512382,523587,534395,544875,555401,565495,575431,585354,595026,604256,613177,622061,630694,639328,647633,655852,663754,671593,679473,687063,694383,701641,708726,715669,722442,729223,735834,742379,748571,754781,760919,766874,772837,778600,784349,789944,795480,800938,806315,811605,816747,821768,826766,831772,836563,841301,846001,850602,855218,859687,863976,868291,872672,876899,880925,885063,889196,893142,897122,901016,904869,908584,912320,915936,919538,923099,926629,930082,933426,936733,940111,943413,946581,949811,952966,956022,959137,962225,965367,968351,
0,0,3,84,544,1798,4313,8300,13885,20874,29370,39144,49685,61347,73603,86397,99533,113162,126979,140799,154769,168677,182515,196235,209773,223312,236612,249733,262893,275599,288263,300730,312977,324906,336408,347951,359111,370074,381015,391798,402340,412548,422547,432520,442127,451707,461049,470134,479150,488231,496855,505465,513767,521858,529946,537707,545452,553037,560613,568079,575117,582302,589134,595969,602737,609257,615698,622324,628622,634886,640964,647050,652925,658642,664336,669878,675224,680651,686120,691294,696415,701494,706435,711327,716261,721057,725767,730410,735135,739656,743985,748369,752716,756978,761250,765307,769450,773547,777472,781411,785381,789212,792921,796589,800329,804021,807572,811083,814459,817911,821335,824594,827865,831220,834481,837639,840900,844074,847178,850222,
0,0,1,9,72,348,1052,2347,4521,7598,11728,16661,22583,29241,36643,44571,53180,62087,71537,81289,91248,101281,111631,122100,132366,142802,153231,163565,174000,184276,194609,204977,215066,225265,235429,245153,254745,264278,273662,283149,292243,301364,310294,319042,327562,336098,344520,352741,360969,369085,377002,384755,392356,399855,407330,414847,421928,429116,436094,443047,449849,456552,463096,469552,475875,482106,488187,494295,500242,506238,511993,517677,523231,528807,534306,539560,544903,550331,555462,560608,565619,570441,575175,579891,584662,589420,594033,598736,603291,607807,612305,616468,620736,624926,629164,633317,637343,641331,645278,649180,653130,656908,660669,664343,668077,671793,675432,678971,682575,686023,689437,692792,696224,699494,702783,706039,709251,712413,715537,718545,
0,0,0,1,7,35,148,427,957,1876,3279,5095,7474,10386,13703,17595,21980,26707,31940,37400,43386,49488,55914,62516,69372,76462,83575,90810,98072,105506,113018,120510,128008,135688,143152,150654,158156,165636,173055,180379,187868,195356,202495,209758,216929,224101,231068,237973,244692,251538,258412,265171,271849,278399,284844,291312,297716,303883,310004,316166,322136,328154,333942,339712,345485,351042,356728,362121,367503,372811,378173,383550,388681,393807,398790,403821,408677,413517,418280,422979,427636,432203,436733,441317,445916,450281,454623,458852,463083,467372,471546,475617,479677,483610,487689,491590,495458,499374,503115,506830,510529,514118,517685,521336,524811,528314,531863,535332,538690,541972,545281,548549,551684,554827,558069,561159,564222,567410,570457,573468,
0,0,0,0,0,3,17,45,139,322,657,1174,1851,2838,4131,5710,7534,9610,12107,14807,17751,20958,24426,28276,32310,36468,40769,45224,49951,54738,59610,64658,69809,74835,80115,85556,90999,96342,101684,107109,112607,118172,123677,129083,134601,140115,145634,151074,156407,161795,167034,172341,177598,182889,188104,193396,198593,203573,208685,213695,218830,223807,228835,233811,238607,243510,248300,253209,257828,262410,267014,271527,276108,280605,285057,289407,293817,298172,302411,306708,310772,314990,319088,323112,327163,331178,335103,338947,342706,346440,350173,353900,357709,361370,365077,368594,372137,375805,379170,382582,386071,389446,392746,396071,399321,402610,405823,408943,412029,415081,418211,421321,424377,427444,430384,433314,436234,439109,441986,444734,
0,0,0,0,0,0,0,0,2,18,61,129,247,448,728,1108,1633,2254,3014,3928,4977,6193,7647,9203,10935,12766,14760,16849,19160,21568,24105,26777,29489,32352,35325,38407,41444,44524,47851,51226,54639,57979,61497,65073,68535,72175,75764,79445,83086,86742,90394,94039,97728,101349,105024,108790,112511,116349,120098,123891,127608,131195,134819,138521,142144,145778,149348,152940,156649,160205,163781,167340,170925,174402,177971,181514,185058,188496,191933,195262,198567,201781,205166,208349,211701,215002,218239,221424,224627,227694,230922,233910,236990,240021,243071,246113,249150,252191,255145,258133,261063,263939,266843,269722,272601,275446,278238,281078,283891,286664,289410,292139,294742,297363,299908,302448,304985,307509,310071,312615,
0,0,0,0,0,0,0,0,0,0,2,4,11,31,47,93,157,229,341,517,709,964,1267,1632,2026,2480,2981,3588,4273,4992,5766,6671,7640,8621,9730,10871,12085,13368,14721,16150,17601,19166,20747,22339,24012,25734,27508,29288,31149,33008,34892,36942,38961,40912,42956,45075,47169,49247,51358,53546,55685,57876,60012,62229,64444,66625,68944,71231,73492,75753,77975,80338,82695,85135,87443,89785,92033,94414,96680,99026,101339,103652,105897,108208,110424,112748,115063,117433,119723,122061,124304,126575,128818,130959,133099,135288,137459,139654,141787,143929,146088,148188,150314,152465,154503,156596,158658,160770,162876,165023,167139,169233,171332,173369,175330,177394,179373,181357,183289,185256,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,14,23,31,48,77,112,136,180,238,310,389,480,608,749,895,1090,1274,1501,1706,1967,2210,2556,2903,3277,3658,4026,4450,4850,5320,5842,6396,7001,7585,8195,8873,9513,10227,10923,11600,12305,13099,13846,14658,15421,16179,16996,17817,18653,19543,20456,21404,22338,23294,24254,25257,26235,27250,28313,29354,30403,31449,32509,33590,34676,35757,36856,37929,39050,40161,41294,42456,43652,44872,46022,47251,48462,49597,50756,51898,53086,54271,55459,56689,57922,59217,60373,61542,62755,63956,65197,66404,67605,68834,70076,71261,72443,73625,74762,75984,77192,78399,
89592,342196,559586,724323,852763,956122,1040441,1111572,1172112,1224519,1270005,1310622,1346569,1378678,1408113,1434499,1459088,1481668,1502436,1521784,1539827,1556772,1572338,1587098,1601144,1614376,1626686,1638282,1649349,1659846,1669966,1679500,1688526,1697358,1705563,1713610,1721379,1728602,1735741,1742536,1748964,1755323,1761308,1767108,1772737,1778139,1783466,1788706,1793675,1798452,1803250,1807823,1812276,1816604,1820821,1824935,1828788,1832591,1836338,1839856,1843292,1846765,1850015,1853320,1856503,1859552,1862590,1865591,1868544,1871406,1874212,1876939,1879587,1882126,1884626,1887170,1889633,1892033,1894336,1896633,1898935,1901166,1903399,1905505,1907562,1909572,1911542,1913603,1915511,1917407,1919289,1921098,1922955,1924710,1926441,1928161,1929827,1931563,1933158,1934736,1936349,1937886,1939406,1940939,1942423,1943813,1945206,1946564,1947874,1949230,1950650,1952016,1953404,1954659,1955917,1957223,1958514,1959705,1960902,1962080,
26166,174081,345461,494171,617042,720069,807335,882228,946833,1003528,1053329,1097701,1138115,1174110,1206976,1237237,1265176,1290795,1314771,1337188,1357690,1377030,1395058,1412083,1428270,1443370,1457691,1471304,1484304,1496568,1508140,1519387,1529930,1540094,1549798,1559068,1568124,1576824,1584975,1592912,1600664,1608037,1615152,1622072,1628722,1635009,1641356,1647408,1653401,1659004,1664533,1669869,1675186,1680164,1684971,1689848,1694521,1698929,1703390,1707582,1711772,1715804,1719740,1723618,1727365,1731027,1734626,1738150,1741653,1745083,1748348,1751577,1754666,1757651,1760680,1763583,1766462,1769360,1772184,1774985,1777651,1780239,1782826,1785372,1787779,1790111,1792526,1794860,1797189,1799391,1801634,1803802,1805984,1808099,1810101,1812064,1814068,1816103,1818030,1819962,1821836,1823564,1825389,1827155,1828903,1830667,1832354,1834051,1835622,1837275,1838863,1840386,1842003,1843478,1845031,1846593,1848080,1849532,1850920,1852410,
10221,103579,239070,368736,482457,581471,667251,741897,807574,865272,917000,963049,1005102,1043070,1077616,1109435,1138766,1166199,1191461,1215359,1237538,1258389,1277696,1296218,1313652,1330173,1345769,1360561,1374504,1388034,1400667,1412873,1424400,1435459,1445976,1456280,1466004,1475336,1484340,1493074,1501596,1509936,1517528,1525022,1532397,1539460,1546348,1552965,1559428,1565629,1571760,1577604,1583364,1589056,1594403,1599553,1604618,1609626,1614354,1619048,1623577,1627984,1632312,1636654,1640845,1644965,1649022,1652915,1656810,1660502,1664145,1667662,1671052,1674466,1677705,1680878,1684125,1687265,1690336,1693341,1696221,1699157,1701983,1704741,1707340,1709968,1712541,1715164,1717776,1720142,1722588,1725039,1727398,1729720,1731977,1734261,1736445,1738672,1740755,1742844,1744861,1746904,1748811,1750836,1752757,1754627,1756512,1758391,1760207,1761979,1763724,1765457,1767193,1768911,1770558,1772237,1773847,1775429,1776977,1778525,
2587,49400,142315,244778,342311,432039,512084,583693,648024,705703,757375,804415,847242,886414,922899,956167,986891,1015774,1042786,1067840,1091428,1113673,1134630,1154308,1172893,1190567,1207207,1223163,1238519,1252929,1266576,1279906,1292360,1304369,1316137,1327211,1337820,1348128,1357880,1367574,1376840,1385721,1394310,1402488,1410486,1418262,1425929,1433215,1440460,1447382,1454107,1460628,1466842,1472989,1478969,1484838,1490466,1495997,1501320,1506556,1511790,1516722,1521567,1526197,1530794,1535273,1539689,1544065,1548220,1552342,1556350,1560296,1564185,1567962,1571634,1575302,1578922,1582459,1585848,1589217,1592478,1595823,1598988,1602060,1605102,1608094,1610858,1613740,1616531,1619248,1622018,1624679,1627259,1629882,1632403,1634948,1637429,1639891,1642227,1644552,1646862,1649276,1651484,1653693,1655847,1658019,1660195,1662194,1664245,1666191,1668160,1670119,1672075,1673929,1675823,1677658,1679468,1681247,1683025,1684783,
314,15922,64296,131969,205395,277585,346669,410359,469358,523569,573409,619575,661903,701297,737572,771682,803430,832922,860757,887195,912117,935398,957451,978413,998175,1017242,1035203,1052502,1068885,1084548,1099345,1113472,1127196,1140439,1153057,1165311,1176988,1188260,1199086,1209626,1219798,1229556,1239131,1248237,1257105,1265669,1273945,1282109,1289795,1297364,1304736,1311832,1318912,1325771,1332332,1338727,1345051,1351118,1357111,1362883,1368575,1374203,1379581,1384911,1390014,1394998,1399864,1404621,1409201,1413694,1418249,1422674,1427006,1431146,1435223,1439339,1443266,1447189,1451159,1454994,1458739,1462426,1465893,1469347,1472784,1476090,1479302,1482526,1485704,1488818,1491949,1494899,1497862,1500698,1503495,1506290,1509144,1511919,1514513,1517165,1519809,1522299,1524835,1527299,1529733,1532171,1534501,1536813,1539114,1541416,1543635,1545838,1548046,1550235,1552373,1554539,1556629,1558622,1560603,1562598,
77,7198,36736,85480,143329,203639,263193,320043,374399,425272,472227,516600,558089,596368,632393,666139,697280,726714,754597,781261,806482,830116,852518,874054,894316,913702,932031,949933,966749,982634,997938,1012542,1026862,1040510,1053716,1066462,1078753,1090494,1101775,1112799,1123374,1133603,1143469,1152992,1162350,1171240,1179987,1188489,1196737,1204707,1212529,1219974,1227523,1234704,1241738,1248355,1255105,1261461,1267779,1273887,1279956,1285753,1291474,1297004,1302475,1307783,1312965,1318108,1323090,1327979,1332781,1337527,1342149,1346713,1351059,1355210,1359533,1363688,1367688,1371686,1375621,1379522,1383335,1386986,1390633,1394158,1397704,1401147,1404612,1407979,1411212,1414424,1417406,1420584,1423614,1426676,1429618,1432503,1435329,1438154,1440945,1443664,1446400,1448988,1451622,1454180,1456751,1459230,1461714,1464111,1466516,1468895,1471285,1473627,1475901,1478141,1480359,1482571,1484692,1486742,
10,2485,17702,48548,90135,137077,185795,234116,281627,326726,369940,411073,449803,486430,520775,553139,583736,612465,640054,665948,690660,714317,736795,758256,778503,798203,816953,834874,852098,868476,884293,899757,914326,928411,941954,955135,967730,979931,991741,1003075,1014014,1024492,1034849,1044850,1054476,1063864,1073060,1082080,1090709,1099183,1107182,1115117,1122996,1130456,1137837,1144902,1151891,1158596,1165192,1171612,1177980,1184204,1190177,1196094,1201893,1207571,1213006,1218353,1223523,1228701,1233770,1238715,1243639,1248529,1253053,1257556,1262066,1266425,1270748,1274910,1278964,1283045,1287056,1290983,1294803,1298605,1302333,1305974,1309550,1313037,1316632,1320040,1323477,1326827,1330066,1333358,1336504,1339659,1342799,1345804,1348773,1351753,1354514,1357437,1360258,1362936,1365578,1368238,1370915,1373518,1376098,1378678,1381191,1383610,1386096,1388440,1390786,1393098,1395426,1397676,
2,568,6567,22470,47623,79540,115445,153452,191980,229922,266873,302164,336724,369620,401201,431381,460143,487673,513858,538982,562925,585704,607642,628564,648709,668311,686923,704640,721951,738269,754043,769426,784426,798886,812619,825952,838951,851286,863374,875082,886487,897418,908179,918579,928653,938416,947917,957051,966080,974902,983415,991667,999858,1007796,1015568,1023112,1030453,1037521,1044398,1051257,1057946,1064455,1070765,1077024,1083042,1089034,1094893,1100656,1106112,1111592,1116927,1122256,1127385,1132384,1137331,1142006,1146762,1151418,1155997,1160590,1165013,1169394,1173898,1178052,1182123,1186209,1190295,1194195,1198018,1201826,1205479,1209115,1212681,1216229,1219778,1223287,1226711,1230079,1233286,1236469,1239672,1242823,1245946,1248967,1252013,1254881,1257624,1260513,1263334,1266145,1268913,1271628,1274201,1276878,1279523,1281979,1284491,1287013,1289493,1291877,
0,80,1607,7643,19948,37639,60092,85587,112867,141446,170383,199086,227345,255165,282070,308422,333950,358879,382679,405631,427786,449000,469723,489677,509040,527482,545601,562840,579359,595232,610911,626040,640650,654883,668560,682307,695247,707779,719860,731695,743113,754136,765001,775584,785793,795780,805362,814887,824086,833054,841956,850505,858832,866944,874943,882716,890387,897822,905028,912084,919008,925928,932526,938867,945208,951307,957429,963381,969148,974833,980560,986109,991514,996874,1002120,1007191,1012182,1017133,1021832,1026490,1031084,1035761,1040370,1044732,1049143,1053380,1057703,1061855,1066040,1070025,1073870,1077745,1081520,1085199,1088827,1092496,1096058,1099584,1103084,1106499,1109894,1113192,1116486,1119836,1122934,1126090,1129202,1132230,1135275,1138273,1141148,1143941,1146779,1149597,1152408,1155264,1158056,1160697,1163368,1165990,
0,11,528,3266,9825,20822,35855,53700,74046,96060,118854,142258,165913,189599,213105,236373,259033,281232,302730,323796,344411,364204,383573,402396,420361,438022,454976,471633,487718,503227,518304,533117,547358,561322,574669,587636,600304,612664,624701,636304,647559,658622,669364,679930,690108,700094,709794,719259,728577,737465,746316,754924,763335,771352,779131,787156,794850,802386,809767,816894,823993,830742,837482,844054,850505,857064,863178,869155,875230,881004,886806,892388,897888,903311,908572,913798,918979,923975,928890,933758,938543,943241,947864,952441,956877,961275,965687,970086,974291,978493,982582,986581,990517,994403,998143,1001953,1005676,1009329,1012994,1016442,1020020,1023486,1026829,1030258,1033557,1036800,1039996,1043187,1046238,1049291,1052330,1055339,1058288,1061175,1064026,1066913,1069696,1072494,1075208,1077868,
0,4,142,1053,3934,9462,17932,29427,43105,58603,75318,93166,111521,130518,149716,168972,187937,206982,225683,244075,262111,279805,297141,314119,330604,346741,362363,377676,392641,407219,421541,435303,448748,461863,474767,487305,499439,511470,522839,534303,545257,556087,566723,577009,587152,597141,606603,616004,625004,633958,642710,651272,659598,667901,675879,683911,691414,698815,706288,713511,720629,727609,734405,741064,747465,753819,760189,766352,772286,778093,783999,789849,795562,801031,806504,811857,817163,822258,827393,832330,837019,841746,846492,851107,855729,860230,864751,869159,873576,877796,881997,886185,890147,894142,897994,901850,905599,909305,913034,916716,920292,923823,927272,930781,934160,937429,940826,944191,947360,950536,953583,956648,959672,962719,965702,968663,971547,974432,977268,980072,
0,0,23,237,1161,3449,7515,13359,21194,30817,41757,53754,66878,80577,94516,109159,124176,139221,154559,169491,184547,199519,214296,228737,243070,257181,271403,284871,298182,311155,323837,336420,348735,360936,372709,384279,395789,406830,417702,428536,438892,449125,459106,468880,478271,487758,496931,505807,514673,523484,531999,540327,548584,556508,564303,571861,579190,586538,593631,600726,607639,614530,621192,627809,634342,640783,647107,653201,659279,665157,671104,676880,682587,688247,693786,699098,704261,709494,714591,719574,724299,729140,733928,738520,743147,747693,752175,756733,761063,765365,769636,773847,777944,781972,786004,789817,793635,797454,801207,804927,808538,812200,815784,819306,822805,826208,829669,833049,836414,839694,842889,845938,849052,852089,855140,858149,861155,864121,867043,869952,
0,0,0,34,214,832,2229,4657,8314,13096,18952,25632,33391,42038,51356,61097,71519,82067,92975,104173,115460,126984,138377,150020,161608,173049,184247,195548,206716,217866,228764,239517,250280,260728,271064,281210,291221,300952,310500,319986,329470,338749,347720,356743,365390,373991,382337,390609,398806,407017,414915,422796,430532,438060,445451,452794,459923,466883,473928,480731,487264,493832,500264,506442,512552,518571,524531,530474,536402,542203,547787,553544,559185,564527,569945,575215,580261,585436,590529,595435,600242,605055,609699,614199,618820,623416,627920,632228,636575,640834,644997,649215,653390,657424,661339,665250,669123,672969,676763,680502,684121,687841,691462,694923,698503,701922,705334,708664,711946,715256,718509,721739,724802,727891,731007,734159,737192,740189,743144,745991,
0,0,1,2,27,123,402,1012,2108,3697,6060,9016,12688,16922,21789,27167,32965,39261,45840,52823,60254,67832,75500,83497,91645,99903,108179,116564,124853,133265,141766,150078,158493,166779,175034,183332,191437,199409,207423,215261,223161,230877,238568,246122,253513,260929,268307,275495,282597,289627,296692,303531,310269,316895,323282,329835,336277,342540,348763,355068,361153,367125,373079,378737,384363,390033,395715,401180,406632,411945,417271,422503,427666,432768,437681,442599,447493,452291,457159,461714,466332,470894,475379,479906,484203,488668,492881,497094,501204,505302,509335,513343,517330,521318,525204,529036,532800,536473,540006,543722,547293,550891,554377,557931,561358,564760,568115,571442,574781,578016,581277,584384,587431,590509,593472,596431,599423,602368,605308,608106,
0,0,0,0,0,11,47,151,407,854,1583,2511,3894,5632,7730,10176,13065,16278,19881,23750,27963,32412,37083,42054,47250,52560,58019,63597,69415,75257,81100,87016,92977,98951,104927,111138,117324,123542,129720,135800,141963,148008,154127,160209,166373,172318,178237,184177,189898,195774,201513,207283,213060,218666,224136,229573,234975,240247,245644,250996,256068,261306,266482,271509,276518,281434,286320,291179,295921,300638,305336,310107,314748,319287,323786,328296,332744,337069,341394,345605,349857,354070,358131,362177,366273,370137,373987,377902,381691,385458,389270,393006,396749,400333,403969,407618,411109,414541,417978,421400,424784,428055,431342,434703,437931,441087,444210,447350,450410,453534,456627,459687,462634,465591,468491,471409,474239,477034,479853,482591,
0,0,0,0,0,0,3,13,41,101,206,429,703,1135,1711,2466,3427,4583,5869,7391,9161,11115,13252,15549,18116,20751,23552,26468,29642,32872,36241,39685,43259,46909,50648,54484,58363,62343,66237,70410,74468,78547,82815,86983,91051,95317,99460,103794,108012,112279,116381,120625,124903,129030,133215,137452,141578,145746,149959,154060,158186,162301,166396,170407,174402,178319,182251,186097,190034,193936,197717,201474,205303,208968,212770,216502,220118,223764,227424,231011,234535,238109,241694,245117,248506,251879,255300,258558,261858,265036,268278,271439,274674,277920,281031,284136,287186,290254,293357,296368,299374,302271,305210,308001,310854,313673,316550,319335,322122,324811,327521,330237,332959,335564,338241,340840,343375,345957,348442,350970,
0,0,0,0,0,0,0,1,1,4,9,16,44,82,151,254,403,598,891,1240,1636,2138,2683,3329,4075,4875,5831,6826,7924,9164,10417,11783,13244,14820,16459,18096,19891,21711,23575,25509,27398,29440,31581,33701,35848,38127,40393,42700,45018,47437,49822,52316,54769,57249,59732,62212,64678,67283,69859,72488,75059,77717,80331,82931,85503,88181,90854,93516,96187,98882,101451,104123,106710,109414,111979,114585,117189,119847,122502,125041,127644,130182,132714,135183,137734,140296,142812,145371,147792,150293,152765,155202,157673,160050,162426,164912,167305,169639,171944,174217,176515,178813,181095,183465,185779,188002,190305,192584,194762,197030,199141,201290,203406,205533,207717,209853,212029,214095,216257,218348,
0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,4,6,16,31,43,70,106,142,224,289,391,507,629,754,944,1140,1348,1594,1874,2185,2552,2919,3330,3769,4216,4718,5266,5857,6441,7096,7754,8421,9165,9955,10770,11630,12454,13354,14271,15191,16162,17144,18151,19232,20268,21284,22434,23584,24707,25841,26983,28143,29363,30538,31746,33009,34284,35481,36736,38038,39293,40559,41873,43239,44483,45812,47132,48498,49866,51233,52586,53939,55315,56654,58019,59381,60698,62047,63456,64856,66273,67649,69005,70420,71794,73184,74602,76000,77386,78755,80116,81486,82892,84329,85687,87062,88409,89859,91242,92588,93974,95323,96727,98103,99440,
96653,352802,568849,731191,856588,957202,1039618,1108957,1168031,1218859,1263213,1302495,1337128,1368762,1397406,1423486,1447429,1469356,1489534,1508113,1525669,1542121,1557318,1571667,1585340,1597922,1609843,1621187,1631926,1642216,1652046,1661256,1669908,1678265,1686402,1694272,1701857,1708925,1715875,1722547,1728808,1734931,1740831,1746476,1751929,1757336,1762496,1767643,1772570,1777301,1781880,1786297,1790669,1794762,1798722,1802600,1806385,1810189,1813806,1817354,1820769,1824171,1827404,1830698,1833808,1836807,1839839,1842717,1845637,1848372,1851035,1853720,1856258,1858763,1861173,1863595,1866037,1868362,1870681,1872946,1875196,1877321,1879435,1881541,1883525,1885519,1887426,1889392,1891342,1893182,1895024,1896862,1898663,1900406,1902179,1903828,1905484,1907167,1908723,1910298,1911778,1913319,1914744,1916224,1917712,1919156,1920584,1921967,1923299,1924621,1925913,1927228,1928487,1929719,1930987,1932278,1933484,1934725,1935927,1937103,
30487,186164,359761,507012,628011,728968,814185,886914,949928,1005064,1053095,1096191,1135111,1170355,1202329,1231465,1258193,1283045,1305833,1327307,1347265,1365799,1383271,1399482,1415323,1430015,1444056,1457230,1469602,1481505,1492923,1503680,1513953,1523882,1533251,1542197,1550966,1559306,1567278,1575109,1582500,1589615,1596547,1603211,1609610,1615931,1622143,1627974,1633598,1639066,1644502,1649790,1654711,1659628,1664494,1669163,1673516,1677893,1682195,1686316,1690322,1694266,1698073,1701852,1705617,1709152,1712630,1715995,1719288,1722552,1725781,1728919,1731950,1734904,1737837,1740688,1743594,1746310,1749079,1751853,1754437,1756986,1759432,1761883,1764233,1766530,1768856,1771136,1773396,1775561,1777730,1779799,1781835,1783975,1785968,1787988,1789938,1791881,1793750,1795631,1797433,1799217,1800905,1802673,1804397,1806094,1807821,1809470,1810993,1812615,1814139,1815684,1817215,1818707,1820173,1821628,1823132,1824611,1826023,1827367,
12713,114586,254581,385179,498362,595744,679288,752214,815919,871917,921945,966916,1007412,1043940,1077543,1108368,1136969,1163160,1187288,1210102,1231467,1251360,1270233,1287973,1304787,1320829,1335641,1349845,1363352,1376275,1388452,1400309,1411322,1422068,1432208,1441950,1451209,1460374,1469067,1477579,1485682,1493623,1501304,1508478,1515458,1522117,1528774,1535195,1541501,1547455,1553296,1559030,1564554,1569868,1575084,1580094,1585024,1589931,1594603,1599131,1603572,1607911,1612109,1616259,1620336,1624252,1627994,1631734,1635450,1639084,1642614,1646065,1649381,1652615,1655844,1658992,1662132,1665323,1668281,1671142,1674071,1676768,1679482,1682096,1684694,1687185,1689697,1692220,1694733,1697079,1699426,1701827,1704146,1706372,1708619,1710718,1712823,1714931,1717007,1719059,1721090,1723073,1725027,1726928,1728843,1730722,1732556,1734351,1736133,1737913,1739706,1741358,1742981,1744625,1746279,1747891,1749548,1751080,1752618,1754179,
3573,57193,156279,261973,360642,449614,528637,599096,661867,718048,768554,814467,856136,893959,929266,961351,990975,1018645,1044627,1068915,1091549,1112837,1132832,1151672,1169622,1186468,1202581,1217954,1232724,1246604,1259670,1272363,1284575,1296226,1307364,1318212,1328348,1338360,1347788,1357004,1365815,1374326,1382689,1390576,1398273,1405863,1413071,1420122,1426914,1433524,1440018,1446313,1452400,1458328,1464107,1469658,1474940,1480198,1485373,1490370,1495314,1500128,1504740,1509208,1513699,1517938,1522089,1526310,1530251,1534190,1538159,1542047,1545655,1549207,1552837,1556375,1559747,1563187,1566489,1569804,1572999,1576080,1579114,1582066,1584954,1587873,1590637,1593436,1596147,1598862,1601535,1604137,1606703,1609185,1611661,1614065,1616494,1618832,1621077,1623326,1625525,1627748,1629878,1631989,1634049,1636081,1638102,1640145,1642074,1644044,1645985,1647822,1649650,1651496,1653215,1655110,1656928,1658678,1660432,1662099,
475,20369,75591,148080,224410,298248,367290,431144,489552,543146,591888,636921,678325,716633,751964,785083,815865,844300,871088,896579,920537,942795,964073,984177,1003026,1021265,1038419,1054939,1070628,1085768,1099918,1113684,1126870,1139372,1151454,1163172,1174469,1185226,1195482,1205604,1215237,1224634,1233758,1242474,1250968,1259061,1266964,1274637,1282290,1289396,1296470,1303311,1310006,1316575,1322814,1328981,1335104,1341028,1346787,1352314,1357835,1363219,1368415,1373492,1378374,1383197,1387817,1392333,1396829,1401222,1405513,1409791,1413992,1417985,1421953,1425785,1429650,1433399,1437142,1440736,1444258,1447698,1451177,1454504,1457765,1460958,1464113,1467147,1470339,1473311,1476199,1479046,1481930,1484691,1487433,1490106,1492816,1495455,1498007,1500580,1503116,1505564,1507974,1510378,1512605,1514881,1517220,1519535,1521637,1523884,1526051,1528195,1530398,1532457,1534447,1536514,1538543,1540477,1542365,1544328,
127,9674,44806,98931,160592,223668,284816,342529,396741,447331,493998,537525,578400,615849,650923,683715,714284,742945,769766,795416,819700,842437,863854,884683,904130,922757,940355,957223,973231,988658,1003248,1017140,1030871,1043911,1056549,1068592,1080309,1091598,1102254,1112864,1123097,1132788,1142317,1151534,1160350,1168963,1177346,1185530,1193543,1201321,1208800,1215929,1223112,1229902,1236633,1243011,1249424,1255524,1261542,1267346,1273104,1278698,1284223,1289645,1294753,1299807,1304757,1309681,1314354,1318953,1323482,1327954,1332309,1336605,1340880,1344967,1348947,1352847,1356782,1360525,1364312,1368027,1371614,1375154,1378634,1382035,1385474,1388737,1392001,1395204,1398348,1401449,1404503,1407545,1410483,1413471,1416293,1419101,1421836,1424454,1427035,1429599,1432201,1434705,1437104,1439578,1442134,1444554,1446907,1449198,1451466,1453715,1455988,1458160,1460349,1462491,1464621,1466665,1468690,1470668,
20,3782,23333,59108,104678,154768,205637,255929,303860,349521,392342,432632,471166,507047,541244,573120,603111,631209,658134,683524,707209,730133,751875,772529,792401,811112,829160,846504,863035,878767,893932,908369,922723,935992,948878,961475,973612,985418,996538,1007440,1018115,1028320,1038326,1047814,1057009,1065906,1074722,1083245,1091701,1099698,1107604,1115122,1122539,1129836,1136838,1143594,1150267,1156724,1163066,1169199,1175251,1181174,1186946,1192594,1198175,1203424,1208612,1213900,1218975,1223813,1228609,1233415,1238092,1242732,1247141,1251392,1255684,1259862,1263935,1268001,1271888,1275760,1279532,1283289,1287052,1290825,1294419,1297912,1301339,1304751,1307986,1311307,1314563,1317843,1320951,1324105,1327076,1330067,1332965,1335901,1338689,1341407,1344182,1346909,1349506,1352190,1354754,1357330,1359922,1362420,1364876,1367304,1369536,1371871,1374271,1376546,1378869,1380989,1383208,1385406,
4,1068,9414,29173,59051,94886,134007,174312,214429,253396,291159,327314,362081,394872,426382,456205,484825,511904,537849,562447,585946,608412,629785,649992,669640,688203,706389,723519,740185,756208,771588,786478,800652,814550,827894,840576,853135,865082,876391,887670,898568,909135,919266,929072,938667,948003,957115,965969,974500,982844,991017,998949,1006768,1014373,1021737,1028819,1035775,1042517,1049227,1055776,1062035,1068057,1074101,1079956,1085690,1091441,1097037,1102506,1107808,1113079,1118192,1123278,1128158,1132998,1137556,1142254,1146722,1151232,1155617,1159888,1164044,1168192,1172266,1176302,1180236,1184129,1188006,1191636,1195167,1198812,1202336,1205792,1209226,1212618,1215969,1219274,1222474,1225777,1228743,1231822,1234960,1237934,1240866,1243758,1246656,1249466,1252134,1254833,1257512,1260175,1262816,1265432,1267867,1270439,1272991,1275451,1277799,1280207,1282573,1284889,
0,158,2635,11116,26631,48202,74069,102543,132653,163367,193973,223803,253364,281804,308906,335519,360989,385907,409739,432685,454448,475228,495623,515222,533939,552124,569808,586656,602767,618367,633614,648325,662585,676303,689499,702415,714706,727018,738626,749930,761029,771750,782270,792528,802250,811869,821117,830130,839005,847586,856029,864488,872388,880092,887740,895380,902666,909694,916803,923315,929870,936484,942716,948789,954908,960825,966642,972369,977956,983392,988817,994149,999253,1004313,1009255,1013993,1018846,1023561,1028119,1032733,1037181,1041623,1045984,1050157,1054250,1058279,1062358,1066356,1070207,1074095,1077791,1081586,1085307,1088835,1092277,1095750,1099153,1102584,1105876,1109106,1112244,1115408,1118604,1121698,1124696,1127607,1130465,1133362,1136170,1138990,1141786,1144528,1147161,1149940,1152539,1155211,1157753,1160257,1162791,1165353,
0,33,969,5245,14183,28176,46122,67310,90271,114521,139324,164410,190012,214772,239205,263112,286250,308850,330838,352062,372688,392486,411797,430621,448469,465723,482487,498812,514560,529989,544528,558816,572751,586188,599206,611857,624136,636222,647789,658991,669925,680603,690937,701220,711073,720799,730129,739229,748199,756854,765292,773592,781763,789655,797342,804990,812390,819513,826506,833265,840007,846540,853073,859414,865647,871648,877607,883440,889192,894655,900069,905416,910714,915834,920800,925782,930651,935407,940142,944802,949416,953911,958386,962660,966844,971016,975212,979315,983379,987331,991193,995101,998811,1002535,1006172,1009804,1013410,1016916,1020265,1023570,1026873,1030257,1033484,1036660,1039736,1042846,1045881,1048951,1051818,1054773,1057689,1060566,1063429,1066288,1069001,1071716,1074377,1077042,1079580,1082116,
0,11,296,1947,6388,14166,25421,39457,55771,73792,93120,112834,133015,153362,173743,194079,214111,233998,253371,272364,290757,308816,326088,343308,360006,376245,391886,407230,422278,436648,450850,464708,477953,490881,503545,515790,527675,539650,550988,561976,572624,583082,593500,603393,613382,622926,632135,641267,650263,658743,667109,675345,683509,691496,699119,706662,714043,721346,728607,735508,742314,748898,755334,761873,768096,774193,780106,786025,791737,797392,802961,808465,813941,819203,824324,829425,834466,839369,844245,848989,853629,858158,862717,867141,871471,875804,880052,884274,888385,892506,896439,900334,904071,907839,911550,915255,918932,922449,926009,929423,932798,936189,939407,942722,945927,949002,952189,955358,958424,961331,964273,967179,970072,972960,975794,978601,981515,984203,986978,989691,
0,0,49,543,2220,5666,11500,19454,29384,41116,54198,68599,83556,98819,114550,130806,147114,163446,179589,195781,211883,227613,243020,257925,272790,287429,301383,315301,328737,342096,355076,367827,380232,392484,404222,415939,427169,438247,448861,459302,469401,479558,489332,498866,508231,517482,526437,535398,543899,552477,560726,568896,576738,584403,592101,599515,606732,613902,621040,627856,634518,641098,647430,653703,660051,666089,672176,678173,684092,689818,695504,701000,706380,711700,716977,722098,727142,732010,736965,741785,746442,751001,755655,760108,764522,768935,773246,777457,781619,785671,789607,793688,797632,801462,805415,809158,812903,816531,820165,823680,827096,830479,833982,837240,840602,843900,847206,850332,853451,856509,859433,862325,865184,868137,871086,873975,876873,879806,882513,885342,
0,0,5,87,481,1599,3825,7521,12765,19119,26817,35463,45030,55493,66566,78019,89668,101748,114069,126404,139185,151500,163892,176228,188537,200778,212503,224422,236111,247486,258677,269622,280582,291395,301950,312361,322443,332439,342048,351583,361148,370250,379256,388187,396828,405426,413889,422098,430350,438340,446203,453948,461437,468694,476128,483338,490339,497204,503982,510633,517136,523594,529858,536022,542045,547970,553812,559613,565318,570967,576457,581876,587114,592302,597375,602393,607392,612343,617319,622052,626755,631349,635891,640402,644840,649296,653558,657715,661873,666033,670003,674050,677982,681825,685649,689355,693012,696815,700532,704063,707592,711132,714507,717909,721319,724815,728106,731195,734475,737638,740802,743930,746951,749939,752948,755934,758858,761655,764467,767272,
0,0,1,11,67,301,838,1975,3878,6511,9828,14174,19158,24635,30921,37755,45232,52933,61006,69155,77869,86491,95298,104183,113272,122442,131535,140759,149960,159064,168102,177133,185978,194805,203419,211985,220451,228788,236991,245336,253415,261423,269406,277239,284945,292365,299763,307151,314321,321587,328647,335530,342405,349065,355596,362122,368547,374786,380937,387120,393245,399179,405129,410859,416512,422136,427609,433019,438495,443860,449191,454366,459399,464322,469306,474101,478931,483686,488337,492868,497480,501872,506236,510542,514746,519006,523104,527309,531383,535288,539275,543187,547015,550793,554513,558233,561863,565488,569010,572597,576090,579616,582836,586204,589599,593073,596417,599695,602880,605940,609061,612110,615065,618012,620958,623798,626633,629447,632241,635064,
0,0,0,0,1,28,123,398,918,1673,2879,4482,6604,9237,12238,15840,19828,24207,28699,33649,38954,44422,50272,56129,62362,68729,75082,81672,88353,95045,101841,108495,115173,121996,128805,135450,142243,149048,155724,162320,168769,175415,181968,188416,194689,200922,207136,213387,219546,225505,231644,237435,243344,249139,254883,260516,266157,271724,277276,282692,288036,293244,298553,303692,308771,313776,318770,323655,328453,333307,338192,342929,347508,352038,356460,361054,365426,369735,374054,378199,382434,386539,390654,394770,398761,402757,406766,410640,414396,418119,421793,425521,429234,432854,436458,440083,443512,446983,450350,453551,456862,460072,463344,466504,469674,472862,475965,479106,482147,485202,488189,491107,494028,496896,499620,502440,505199,507998,510687,513374,
0,0,0,0,0,1,4,25,103,240,499,931,1474,2223,3198,4434,5968,7704,9615,11884,14310,17037,19911,23041,26378,29939,33590,37303,41260,45170,49288,53539,57800,62231,66725,71264,75903,80344,85013,89683,94388,99002,103649,108272,112967,117676,122404,127055,131662,136267,140843,145376,149999,154508,159046,163594,167916,172341,176942,181306,185593,189961,194276,198573,202798,207028,211078,215203,219253,223242,227250,231221,235016,238890,242733,246503,250296,254135,257828,261492,265151,268794,272417,275923,279345,282710,286107,289594,293036,296403,299689,302983,306265,309436,312563,315638,318735,321808,324918,327982,330963,333944,336796,339763,342639,345531,348413,351208,354034,356791,359518,362233,364912,367619,370247,372913,375541,378200,380772,383204,
0,0,0,0,0,0,0,0,1,13,25,64,122,229,402,576,858,1287,1764,2352,3047,3861,4759,5759,6942,8175,9549,11015,12548,14227,16071,18040,19963,22037,24231,26383,28620,30897,33298,35788,38374,40915,43470,46081,48756,51499,54163,56873,59609,62511,65385,68159,71141,74049,77035,79943,82900,85795,88716,91650,94640,97632,100668,103617,106544,109434,112445,115285,118205,121059,124006,126837,129721,132522,135356,138162,140978,143787,146628,149461,152196,154826,157503,160232,162972,165715,168536,171219,173901,176424,178983,181503,184068,186636,189189,191740,194277,196758,199272,201764,204259,206679,209028,211475,213809,216146,218444,220810,223194,225450,227729,230006,232201,234412,236702,238947,241147,243339,245508,247649,
0,0,0,0,0,0,0,0,0,0,0,0,1,4,6,10,18,41,73,118,187,260,366,484,629,793,1001,1253,1530,1821,2181,2554,2956,3407,3913,4460,5052,5707,6374,7084,7809,8567,9370,10248,11191,12123,13124,14147,15185,16295,17422,18557,19691,20886,22069,23282,24532,25781,27132,28459,29788,31194,32520,33941,35360,36785,38221,39667,41133,42638,44082,45593,47039,48588,50099,51658,53167,54667,56222,57798,59319,60878,62391,63987,65628,67216,68776,70417,72022,73637,75271,76923,78531,80093,81721,83340,84865,86358,87913,89424,90959,92474,93966,95510,97037,98546,100109,101602,103177,104723,106228,107777,109254,110849,112405,113908,115349,116830,118267,119691,
40212,243841,464292,647989,797549,921614,1025148,1113374,1188579,1254387,1311553,1362556,1408305,1449453,1487016,1521254,1552831,1581378,1607716,1632296,1655296,1676170,1696169,1714804,1732312,1748641,1764129,1778614,1792235,1805083,1817623,1829303,1840494,1851245,1861608,1871397,1880671,1889594,1898143,1906381,1914334,1922062,1929285,1936279,1942785,1949329,1955574,1961593,1967282,1972847,1978267,1983501,1988461,1993446,1998272,2002816,2007293,2011532,2015718,2019657,2023649,2027520,2031351,2035021,2038518,2041919,2045121,2048322,2051508,2054597,2057565,2060425,2063239,2065997,2068576,2071238,2073839,2076421,2078802,2081248,2083610,2085910,2088174,2090321,2092445,2094610,2096647,2098607,2100512,2102506,2104409,2106201,2107941,2109717,2111400,2113072,2114728,2116324,2117891,2119413,2120945,2122475,2123913,2125339,2126810,2128227,2129567,2130872,2132206,2133458,2134718,2135985,2137200,2138437,2139611,2140752,2141857,2142964,2144074,2145221,
5192,82856,220941,364756,497128,614272,716969,807868,888795,960325,1024051,1081359,1133552,1180965,1224316,1264038,1300603,1334782,1366261,1395681,1422968,1448697,1472634,1495331,1516701,1536817,1555649,1573488,1590359,1606383,1621530,1636122,1649957,1663194,1675839,1687997,1699708,1710884,1721397,1731454,1741245,1750782,1760088,1768926,1777279,1785417,1793286,1800881,1808151,1815207,1822052,1828562,1835129,1841292,1847241,1853030,1858620,1864044,1869249,1874420,1879393,1884241,1888864,1893443,1898008,1902382,1906599,1910739,1914720,1918660,1922515,1926204,1929822,1933333,1936824,1940215,1943434,1946693,1949826,1952867,1955882,1958879,1961784,1964626,1967373,1970034,1972622,1975109,1977546,1980001,1982330,1984689,1987005,1989229,1991521,1993708,1995821,1997858,1999948,2001890,2003847,2005731,2007592,2009443,2011194,2012860,2014643,2016342,2017980,2019656,2021262,2022897,2024517,2026061,2027514,2028972,2030383,2031807,2033195,2034563,
828,32333,116572,223031,331854,434929,530366,617508,696512,767667,832547,891750,945696,995160,1041013,1083566,1123191,1159755,1193683,1225742,1255592,1283692,1310166,1335257,1358733,1380829,1402033,1421832,1440631,1458627,1475903,1492058,1507463,1522675,1536876,1550761,1564025,1576705,1588820,1600387,1611337,1622085,1632462,1642438,1652091,1661309,1670302,1678979,1687212,1695314,1703138,1710606,1717978,1725094,1731972,1738748,1745388,1751601,1757708,1763565,1769391,1774976,1780500,1785883,1790951,1795979,1800830,1805585,1810223,1814827,1819318,1823511,1827549,1831662,1835680,1839664,1843435,1847174,1850906,1854402,1857814,1861246,1864450,1867683,1870981,1874045,1877113,1880105,1883049,1885876,1888461,1891208,1893845,1896375,1898940,1901454,1903840,1906249,1908663,1911073,1913313,1915492,1917663,1919845,1922002,1923986,1926066,1928036,1929965,1931871,1933772,1935632,1937427,1939194,1940965,1942664,1944328,1945989,1947570,1949192,
48,7326,42315,102913,176350,254378,332164,406910,477585,543757,605701,663078,716604,766760,813354,857072,898005,936434,972462,1006452,1038626,1068965,1097553,1124632,1150247,1174933,1198095,1220228,1241187,1261333,1280611,1299154,1316766,1333327,1349464,1365013,1379926,1394062,1407766,1421110,1433812,1446092,1457886,1469140,1480247,1491017,1501528,1511448,1521123,1530559,1539449,1548007,1556578,1564845,1572921,1580672,1588199,1595430,1602658,1609405,1615987,1622444,1628802,1634883,1640951,1646763,1652539,1658166,1663500,1668805,1674036,1679000,1683908,1688746,1693303,1697980,1702489,1706876,1711178,1715376,1719498,1723483,1727421,1731191,1735023,1738672,1742193,1745729,1749119,1752389,1755720,1758957,1762134,1765260,1768286,1771283,1774198,1777072,1779776,1782537,1785177,1787755,1790403,1792983,1795435,1797925,1800327,1802722,1804994,1807292,1809564,1811742,1813806,1815959,1818014,1820037,1822128,1824081,1826042,1827997,
1,553,7487,27300,60300,102688,150697,201571,253448,304972,355561,404747,451678,496748,539753,580709,619899,657227,692540,726437,759073,789729,819226,847251,874361,900332,924981,948450,971118,992705,1013413,1033265,1052701,1071283,1089109,1106276,1123022,1138923,1154124,1168972,1183061,1196837,1210134,1223142,1235842,1248072,1260002,1271330,1282461,1293185,1303666,1313756,1323593,1333096,1342450,1351384,1360307,1368781,1377127,1385248,1393162,1400722,1408145,1415437,1422504,1429389,1436101,1442669,1449094,1455233,1461326,1467330,1473329,1479011,1484512,1489889,1495265,1500442,1505622,1510599,1515494,1520179,1524780,1529364,1533841,1538243,1542545,1546702,1550802,1554906,1558707,1562529,1566290,1569959,1573536,1577053,1580641,1584181,1587583,1590979,1594302,1597533,1600678,1603630,1606568,1609410,1612327,1615300,1618111,1620886,1623654,1626391,1629065,1631628,1634098,1636550,1639031,1641449,1643805,1646168,
0,70,1854,9698,25910,50067,81185,116460,154560,194366,234895,275303,314950,353810,391746,428723,464530,498786,532155,564214,595256,625243,653538,680728,707082,732270,756757,780449,803292,825164,846366,866613,886355,905123,923289,941044,958205,974513,990381,1005671,1020489,1034874,1048744,1062452,1075669,1088401,1100849,1112837,1124532,1135850,1146939,1157651,1168016,1178340,1188154,1197671,1207200,1216390,1225202,1233847,1242329,1250488,1258548,1266333,1273933,1281246,1288447,1295603,1302615,1309409,1316044,1322571,1328842,1334941,1340959,1346903,1352773,1358435,1363993,1369420,1374883,1380105,1385251,1390174,1395083,1399844,1404463,1409103,1413630,1418043,1422349,1426604,1430901,1434846,1439009,1442937,1447007,1450886,1454470,1458142,1461755,1465333,1468821,1472240,1475577,1478833,1482041,1485205,1488290,1491391,1494432,1497473,1500392,1503279,1506038,1508858,1511581,1514280,1516913,1519570,
0,4,229,2096,7699,18122,33524,53262,76452,102620,130708,159916,189718,220204,250557,280590,310372,339693,368486,396477,423890,450503,476257,501623,526356,550330,573591,595753,617354,638427,658872,678661,697816,716552,734553,752186,769292,785898,801866,817396,832441,847075,861506,875235,888619,901543,914319,926870,939009,950945,962616,973764,984419,995243,1005536,1015714,1025660,1035376,1044693,1053823,1062566,1071378,1079881,1088040,1095992,1103944,1111648,1119102,1126475,1133556,1140595,1147396,1154156,1160816,1167279,1173714,1179894,1186043,1191913,1197689,1203332,1208829,1214327,1219649,1224859,1230109,1235235,1240413,1245374,1250293,1255034,1259551,1264133,1268556,1272982,1277204,1281304,1285505,1289628,1293574,1297510,1301333,1305073,1308737,1312379,1315971,1319471,1323002,1326377,1329842,1333139,1336443,1339740,1342912,1346087,1349206,1352208,1355227,1358055,1360821,
0,0,18,237,1257,4085,9282,17210,27786,40927,56218,73112,91478,111117,131285,152368,173758,195412,217110,238705,260088,281326,302715,323566,343954,364059,383919,403283,422093,440904,459021,476832,494220,511182,527951,544222,560079,575501,590566,605121,619407,633484,647329,660798,673891,686652,699124,711292,723146,734862,746111,757368,768150,778630,788977,799106,809116,818838,828352,837798,846980,855729,864411,872749,881043,889171,897108,904957,912658,920174,927523,934755,941835,948794,955690,962223,968496,974943,981208,987340,993363,999395,1005150,1010832,1016395,1022011,1027447,1032724,1037916,1043002,1048100,1053091,1057855,1062636,1067251,1071907,1076377,1080853,1085250,1089500,1093751,1098010,1102059,1106010,1109950,1113921,1117663,1121403,1125193,1128858,1132544,1136127,1139638,1143133,1146610,1149972,1153316,1156755,1159987,1163154,
0,0,0,7,92,445,1344,3192,6117,10340,15963,22864,30954,40244,50497,61621,73724,86404,99723,113461,127344,141685,156065,170546,185041,199607,214379,228691,243064,257436,271714,285879,299620,313291,326827,340142,353345,366362,379128,391622,403856,416129,428226,439919,451516,462815,474026,485069,495840,506366,516669,526801,536836,546639,556321,565866,575208,584357,593281,602044,610743,619237,627592,635761,643824,651636,659285,666959,674501,681753,688819,695822,702717,709396,716007,722567,729087,735444,741834,748024,753880,759941,765642,771536,777262,782869,788305,793682,799005,804020,809125,814003,818900,823746,828585,833208,837857,842358,846843,851225,855554,859821,864075,868195,872207,876197,880128,884134,887873,891583,895471,899197,902824,906432,909981,913424,916885,920397,923761,926949,
0,0,0,0,16,65,272,767,1711,3186,5393,8575,12455,17353,22955,29222,36301,44075,52321,61179,70387,79995,90034,100193,110722,121352,132224,143041,154080,165287,176640,187944,198992,210032,221204,232112,242953,253527,264186,274821,285226,295366,305716,315842,325630,335525,345161,354694,364165,373575,382753,391814,400927,409746,418542,427275,435795,443980,452212,460258,468174,476043,483761,491348,498779,506098,513128,520127,527244,534096,540916,547591,554166,560600,566958,573297,579435,585366,591309,597155,602872,608566,614077,619543,624862,630228,635499,640733,645767,650779,655891,660808,665569,670218,674877,679436,684029,688421,692843,697389,701668,705913,710069,714217,718193,722025,725878,729734,733526,737335,740952,744611,748226,751860,755402,758738,762020,765432,768725,771915,
0,0,0,0,1,6,40,128,356,781,1518,2614,4149,6179,8622,11449,14850,18795,23206,28077,33266,38976,44900,51183,57872,64783,71975,79567,87058,94765,102676,110491,118558,126733,134898,143023,151239,159494,167588,175817,184012,192204,200216,208416,216444,224469,232317,240133,248003,255687,263543,271218,278669,286213,293531,300797,308064,315165,322294,329352,336330,343210,349866,356460,363001,369507,375997,382259,388265,394468,400510,406467,412431,418435,424180,429820,435403,440958,446394,451708,456946,462141,467343,472337,477273,482193,487097,491938,496703,501473,506046,510660,515127,519426,523831,528109,532318,536552,540741,544804,548803,552779,556652,560526,564338,568117,571875,575567,579157,582753,586294,589675,593045,596458,599797,603136,606440,609675,612915,616078,
0,0,0,0,0,2,8,19,53,128,301,552,945,1533,2363,3478,4819,6479,8461,10703,13212,16024,19217,22495,26129,29985,34019,38269,42811,47444,52225,57311,62560,67693,73095,78439,83987,89576,95237,100933,106720,112425,118389,124099,129886,135772,141682,147556,153327,159308,165231,171091,176785,182662,188376,194138,199771,205473,211080,216786,222278,227843,233243,238689,244177,249395,254689,259830,264981,270155,275261,280271,285242,290113,295127,300063,304730,309362,314128,318759,323310,327702,332259,336748,341077,345605,349893,354185,358313,362389,366466,370484,374556,378520,382479,386304,390087,393863,397552,401174,404732,408249,411845,415479,418893,422343,425641,428907,432309,435619,438874,442094,445208,448374,451491,454527,457492,460544,463487,466389,
0,0,0,0,0,0,0,0,1,12,37,85,157,283,482,769,1137,1646,2302,3066,3987,5120,6401,7796,9426,11147,13050,15089,17390,19768,22247,24985,27897,30698,33813,36916,40159,43476,46868,50376,53919,57599,61339,65244,68982,73003,76916,80841,84856,88939,93015,97050,101048,105146,109195,113433,117550,121699,125745,129933,133960,137957,141986,146015,150121,154171,158062,162091,166017,169967,173928,177820,181686,185522,189328,193273,197043,200853,204513,208252,211966,215573,219183,222817,226425,229986,233475,236947,240328,243758,247114,250357,253649,256827,260006,263288,266465,269582,272720,275873,278973,282063,285026,288012,290906,293890,296731,299606,302350,305230,308120,310938,313633,316424,319144,321774,324260,326882,329541,332094,
0,0,0,0,0,0,0,0,0,1,2,8,19,30,64,112,189,309,481,705,971,1288,1632,2122,2660,3281,3959,4748,5640,6642,7725,8902,10138,11502,12879,14387,15957,17531,19250,21041,22935,24870,26965,29035,31116,33336,35592,37847,40084,42384,44800,47257,49762,52218,54697,57257,59895,62514,65209,67844,70592,73278,76052,78821,81573,84284,87030,89742,92614,95412,98133,100884,103655,106343,108966,111630,114388,117073,119771,122454,125074,127756,130458,133144,135786,138398,140999,143552,146155,148745,151403,153907,156415,158846,161301,163831,166327,168836,171330,173848,176209,178620,180933,183279,185569,187905,190203,192434,194731,197010,199310,201529,203632,205815,207971,210133,212295,214398,216468,218559,
0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,10,26,53,82,125,197,306,425,563,741,933,1164,1425,1732,2081,2493,2981,3539,4090,4707,5396,6110,6894,7714,8591,9479,10488,11473,12537,13662,14853,16013,17265,18568,19961,21344,22770,24224,25669,27114,28638,30210,31819,33470,35139,36854,38585,40328,42104,43763,45556,47323,49042,50874,52682,54422,56190,58002,59787,61749,63627,65461,67412,69283,71224,73042,74947,76818,78725,80663,82536,84388,86283,88145,90022,91904,93827,95741,97613,99455,101355,103109,104901,106680,108514,110376,112087,113949,115708,117534,119336,121050,122799,124549,126353,128136,129797,131530,133300,135041,136751,138427,140082,141764,143395,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,6,13,25,42,78,119,154,206,266,346,451,572,707,879,1074,1282,1513,1762,2066,2367,2660,2999,3406,3893,4295,4798,5277,5829,6386,6983,7624,8303,8993,9697,10405,11133,11919,12705,13501,14327,15214,16076,16950,17893,18836,19785,20769,21761,22773,23818,24844,25905,26959,28062,29178,30283,31400,32517,33657,34801,35981,37145,38352,39525,40726,41961,43191,44378,45537,46771,47983,49171,50421,51694,52880,54039,55275,56509,57741,58969,60241,61506,62739,63954,65162,66412,67704,68920,70206,71466,72636,73969,75192,76455,77658,78897,80075,81322,82521,83715,84872,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,25,36,47,64,82,110,149,187,227,273,335,404,491,572,676,785,903,1040,1193,1338,1518,1701,1926,2136,2351,2571,2822,3090,3387,3683,3998,4343,4687,5014,5390,5782,6177,6599,7001,7461,7934,8426,8908,9380,9859,10368,10865,11434,11992,12569,13137,13708,14291,14860,15446,16034,16624,17244,17883,18530,19142,19826,20466,21194,21865,22555,23238,23926,24592,25302,26015,26753,27429,28174,28872,29643,30387,31134,31808,32501,33251,33999,34746,35466,36232,36977,37733,38508,39311,40081,40878,41663,42392,43193,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,4,7,9,10,14,20,24,32,42,51,71,93,110,129,155,181,210,236,275,318,370,418,476,546,612,701,775,850,931,1025,1122,1218,1321,1446,1554,1677,1811,1958,2079,2245,2400,2573,2763,2931,3110,3290,3489,3687,3886,4101,4321,4563,4784,5007,5266,5538,5813,6066,6321,6591,6852,7131,7390,7685,7978,8261,8555,8855,9160,9483,9774,10058,10360,10719,11058,11417,11733,12087,12453,12815,13180,13507,13898,14302,14700,15105,15493,15876,16256,16640,
52085,271672,492155,670381,812678,929106,1025753,1107395,1177199,1237978,1290857,1337717,1379570,1417387,1451444,1482303,1510912,1537057,1561075,1583321,1604184,1623437,1641327,1658100,1673702,1688454,1702193,1715186,1727366,1738974,1750186,1760677,1770789,1780410,1789650,1798483,1806956,1814894,1822525,1829858,1836801,1843519,1850110,1856464,1862431,1868235,1873835,1879131,1884411,1889370,1894211,1899036,1903556,1907934,1912192,1916318,1920341,1924239,1928010,1931752,1935230,1938743,1942188,1945422,1948570,1951676,1954633,1957544,1960440,1963204,1965912,1968513,1971091,1973499,1975966,1978380,1980744,1983033,1985198,1987404,1989491,1991638,1993676,1995757,1997740,1999641,2001555,2003491,2005235,2007045,2008706,2010376,2011997,2013550,2015191,2016716,2018248,2019746,2021233,2022664,2024057,2025433,2026783,2028111,2029461,2030702,2031888,2033193,2034371,2035563,2036714,2037791,2038938,2040071,2041211,2042290,2043378,2044391,2045452,2046438,
9461,108133,258904,404826,534015,646144,743566,828337,903028,968635,1026556,1078756,1125691,1168429,1207361,1242853,1275630,1305956,1333935,1359844,1384183,1406886,1428110,1447808,1466575,1484237,1501194,1517043,1532046,1545978,1559609,1572427,1584393,1595979,1607089,1617715,1627822,1637686,1646960,1655975,1664450,1672686,1680468,1688063,1695570,1702820,1709695,1716314,1722813,1728919,1734854,1740675,1746376,1751830,1757068,1762174,1767098,1771930,1776680,1781071,1785375,1789634,1793666,1797839,1801760,1805608,1809362,1813034,1816586,1820058,1823424,1826687,1829804,1833005,1836036,1839003,1841934,1844765,1847537,1850381,1853036,1855602,1858153,1860651,1863060,1865411,1867820,1870104,1872374,1874524,1876672,1878814,1880936,1882957,1884939,1886897,1888785,1890638,1892463,1894259,1896042,1897751,1899429,1901092,1902686,1904307,1905793,1907229,1908731,1910259,1911755,1913217,1914633,1915987,1917400,1918735,1920093,1921344,1922609,1923867,
2158,50217,152671,268590,380609,482791,575360,658040,732281,798438,858036,911853,960526,1005079,1045924,1083661,1118518,1151222,1181239,1209279,1235457,1260033,1283062,1304770,1325157,1344300,1362505,1379799,1396267,1411780,1426616,1440715,1453983,1466963,1479391,1491090,1502333,1513201,1523763,1533867,1543525,1552863,1561602,1570102,1578346,1586318,1594009,1601589,1608709,1615688,1622334,1628868,1635145,1641176,1647090,1652912,1658409,1663760,1669061,1674106,1678908,1683568,1688232,1692775,1697388,1701706,1706001,1710043,1714023,1717952,1721722,1725405,1728962,1732566,1735973,1739281,1742467,1745782,1748966,1752110,1755234,1758125,1761083,1763946,1766695,1769388,1771994,1774593,1777180,1779635,1782020,1784392,1786649,1789001,1791276,1793512,1795704,1797789,1799792,1801795,1803800,1805864,1807700,1809551,1811362,1813122,1814847,1816590,1818319,1820026,1821682,1823358,1824959,1826568,1828157,1829719,1831223,1832712,1834167,1835613,
243,15870,69321,145345,229242,313026,392428,466761,535717,598349,656350,710056,759160,804687,846580,885862,922369,956271,987905,1017484,1045925,1072362,1097003,1120532,1142729,1163819,1183836,1202907,1220858,1238026,1254284,1269941,1284935,1299237,1312867,1325846,1338252,1350476,1362209,1373413,1384210,1394564,1404623,1414152,1423509,1432565,1441352,1449787,1457888,1465628,1473199,1480502,1487541,1494537,1501299,1507751,1514094,1520208,1526048,1531924,1537496,1542905,1548071,1553203,1558246,1563097,1567937,1572641,1577246,1581636,1586002,1590295,1594459,1598448,1602373,1606199,1610028,1613702,1617259,1620848,1624239,1627626,1630962,1634125,1637354,1640456,1643484,1646498,1649393,1652228,1654832,1657517,1660290,1662921,1665412,1667995,1670538,1672987,1675448,1677816,1680059,1682364,1684527,1686782,1688937,1691078,1693106,1695135,1697100,1699067,1701015,1702946,1704831,1706600,1708351,1710125,1711851,1713534,1715174,1716916,
4,2429,19149,54213,102135,157111,214996,272342,327981,381614,432727,481096,526408,569269,609703,647573,683327,717160,748906,779437,808369,835597,861748,886200,909687,932036,953359,973683,993001,1011602,1029193,1046128,1062390,1077834,1092789,1107136,1121162,1134634,1147352,1159686,1171650,1183167,1194368,1205220,1215755,1225758,1235549,1244837,1254018,1262844,1271418,1279643,1287820,1295748,1303322,1310638,1317758,1324732,1331555,1338215,1344701,1351025,1357142,1363008,1368678,1374475,1379880,1385370,1390634,1395811,1400789,1405663,1410411,1415070,1419631,1424090,1428509,1432755,1436948,1440927,1444954,1449013,1452829,1456531,1460238,1463867,1467412,1470788,1474166,1477504,1480667,1483870,1487006,1490004,1493011,1495895,1498778,1501686,1504431,1507146,1509856,1512436,1515050,1517655,1520157,1522660,1525054,1527431,1529749,1532095,1534340,1536536,1538644,1540849,1542979,1545054,1546978,1548993,1550995,1552940,
1,604,7481,26072,56308,95065,138268,183710,229841,275677,319788,362673,403762,443156,481177,516970,551140,583607,614626,644153,671917,698703,724120,748749,772221,794411,815912,836404,855908,874764,893132,910527,927238,943366,958885,973788,988132,1002033,1015223,1028177,1040658,1052474,1064073,1075586,1086531,1097095,1107382,1117170,1126673,1136006,1145022,1153678,1162265,1170603,1178693,1186604,1194069,1201659,1208797,1215877,1222566,1229315,1235683,1242026,1248158,1254008,1259829,1265567,1271136,1276590,1281967,1287229,1292489,1297562,1302386,1307218,1311837,1316499,1320885,1325164,1329481,1333676,1337705,1341703,1345701,1349690,1353497,1357134,1360743,1364370,1367760,1371236,1374656,1378016,1381271,1384399,1387573,1390647,1393678,1396665,1399539,1402362,1405185,1407864,1410591,1413251,1415801,1418393,1420990,1423430,1425901,1428309,1430654,1432982,1435332,1437686,1439876,1442079,1444196,1446351,
0,105,1966,9581,25145,47983,75763,107638,141829,176918,212598,247978,283045,317194,350553,382484,413278,442988,471722,499319,525853,551473,575889,599270,621888,643785,664697,684716,704172,722572,740488,757872,774532,790809,806430,821575,836107,850270,863807,876933,889696,901956,913894,925583,936867,947739,958176,968419,978444,988299,997663,1006770,1015541,1024084,1032452,1040697,1048704,1056606,1064177,1071566,1078850,1086035,1092888,1099495,1106064,1112465,1118761,1124887,1130689,1136404,1142149,1147667,1152994,1158326,1163456,1168626,1173691,1178472,1183291,1187924,1192401,1196823,1201234,1205486,1209636,1213822,1217940,1221913,1225745,1229480,1233324,1236985,1240580,1244108,1247691,1251118,1254578,1257891,1261061,1264233,1267374,1270399,1273545,1276523,1279489,1282292,1285182,1287925,1290632,1293370,1295989,1298577,1301122,1303743,1306183,1308713,1311084,1313405,1315726,1318080,
0,13,357,2441,8182,18463,33264,51803,73260,96859,122365,148619,175115,201527,228183,254123,280075,305522,330458,354409,377751,400361,422625,443820,464694,484627,504271,523183,541361,559111,576333,592970,609282,624904,639744,654455,668536,682665,696139,709073,721591,733822,745904,757577,768990,779879,790444,800797,810923,820587,830268,839550,848706,857592,866326,874775,882956,890980,898820,906362,913858,921069,928257,935105,941735,948490,954898,961295,967448,973442,979467,985381,991121,996705,1002094,1007436,1012630,1017767,1022749,1027604,1032405,1037286,1041944,1046546,1051118,1055633,1059921,1064149,1068344,1072313,1076274,1080280,1084137,1087844,1091503,1095083,1098545,1102064,1105553,1108912,1112276,1115521,1118607,1121840,1125007,1128044,1131038,1133996,1136975,1139846,1142664,1145386,1148105,1150909,1153552,1156101,1158602,1161198,1163661,1166174,
0,0,33,348,1662,4820,10481,18533,29008,41651,55988,71726,88575,106088,124158,142765,161589,180664,199516,218460,237176,255705,273800,291487,308971,326322,343237,359611,375561,391204,406555,421278,435978,450350,464351,477958,491069,503823,516348,528558,540513,552092,563342,574521,585414,596034,606366,616544,626375,635896,645286,654527,663324,671977,680634,688975,697089,705131,713023,720650,728133,735319,742466,749462,756362,763219,769814,776058,782336,788374,794525,800481,806211,811823,817284,822881,828266,833544,838675,843723,848700,853547,858347,863084,867713,872206,876665,881109,885357,889555,893776,897934,902113,906011,909860,913576,917333,920956,924570,928189,931730,935228,938726,941964,945304,948560,951746,954868,957983,961061,963942,966785,969659,972478,975259,978058,980742,983421,986116,988791,
0,0,3,70,438,1591,3988,8047,13698,21082,29867,40084,51409,64017,76990,90858,105195,119718,134749,149855,164921,180118,195023,210029,224725,239301,253527,267786,281611,295188,308814,322207,335392,348239,360786,373104,384999,396976,408368,419704,430642,441558,452295,462549,472727,482802,492558,502218,511349,520422,529469,538183,546642,554906,563271,571376,579247,586956,594302,601983,609238,616295,623303,630073,636680,643171,649564,656019,662175,668233,674207,680205,685897,691679,697292,702798,708149,713379,718486,723608,728532,733558,738314,743012,747642,752175,756581,760803,765181,769496,773676,777817,781715,785654,789489,793320,797184,800831,804414,808024,811528,814956,818451,821852,825158,828389,831592,834773,837988,840987,844048,847062,850027,853028,855828,858636,861416,864085,866770,869384,
0,0,1,10,94,431,1189,2726,5182,8725,13439,19175,26030,33496,42015,50987,60722,70910,81435,92562,103561,114931,126525,138235,149877,161691,173274,184850,196541,207915,219398,230864,241855,252667,263670,274350,284680,294832,305046,314882,324635,334360,343821,353070,362313,371258,380125,388773,397297,405793,413996,422253,430146,438034,445818,453441,460886,468054,475084,482081,488998,495773,502492,508857,515197,521462,527567,533655,539560,545443,551198,556755,562278,567767,572993,578225,583358,588438,593485,598427,603259,608091,612845,617435,622029,626564,630970,635268,639616,643834,647825,651818,655882,659787,663551,667371,671099,674729,678366,681897,685447,688869,692336,695727,699051,702361,705555,708774,711883,715019,718076,721058,723991,726851,729700,732439,735340,738095,740808,743497,
0,0,0,0,11,72,268,720,1542,2924,4885,7561,10865,14754,19486,24711,30233,36493,43352,50485,57890,65528,73529,81862,90194,98702,107451,116086,124719,133434,142356,151218,160163,168828,177440,186094,194737,203201,211555,219898,228248,236504,244584,252624,260424,268178,275916,283349,290778,298111,305311,312312,319241,326195,333017,339740,346265,352744,359145,365463,371699,377845,383934,389928,395714,401522,407268,412766,418219,423632,428976,434151,439274,444415,449443,454441,459403,464064,468790,473450,477968,482513,486936,491250,495524,499825,503909,507999,512148,516186,520128,524068,527895,531642,535422,539004,542521,546125,549555,553050,556500,559843,563183,566330,569580,572832,575939,578946,581928,584931,587759,590661,593553,596331,599093,601885,604630,607263,609950,612475,
0,0,0,0,0,3,37,116,309,660,1257,2180,3417,5021,7079,9433,12195,15339,18895,22787,26947,31437,36262,41297,46641,52326,58011,63795,69756,75770,81820,87891,94128,100561,106839,113194,119586,126024,132387,138778,145157,151588,157965,164209,170408,176606,182757,188852,194846,200902,206822,212653,218516,224410,229986,235451,240994,246553,251989,257453,262706,267980,273233,278337,283427,288601,293513,298445,303183,307922,312570,317128,321782,326264,330762,335083,339555,343788,347957,352155,356265,360198,364167,368099,372002,375820,379656,383288,387060,390785,394461,398061,401567,405062,408533,411992,415257,418545,421871,425020,428115,431183,434266,437329,440393,443354,446157,448974,451844,454514,457328,460044,462709,465503,468116,470750,473371,475932,478420,480901,
0,0,0,0,0,0,0,11,37,101,221,408,722,1178,1816,2660,3709,4984,6423,8120,10004,12175,14514,17034,19662,22584,25702,28894,32330,35849,39533,43403,47271,51221,55370,59465,63772,68113,72375,76837,81171,85501,89953,94416,98948,103491,108029,112535,117021,121407,125813,130192,134559,138875,143237,147623,151986,156378,160664,164928,169192,173278,177394,181480,185462,189481,193561,197502,201514,205382,209204,212904,216833,220541,224239,227898,231528,235143,238670,242241,245601,249043,252472,255926,259142,262542,265719,268971,272092,275098,278187,281360,284273,287278,290279,293256,296171,298947,301773,304684,307475,310147,312838,315432,318115,320749,323345,325867,328412,330931,333489,335933,338344,340874,343212,345611,347961,350260,352589,354887,
0,0,0,0,0,0,0,0,4,11,28,66,137,269,455,676,1000,1470,2017,2667,3480,4364,5396,6513,7793,9238,10774,12467,14232,16114,18109,20172,22374,24664,27084,29558,32004,34565,37219,40104,42971,45825,48714,51703,54716,57670,60695,63817,66788,69838,72922,76010,79139,82303,85448,88675,91778,95034,98172,101362,104427,107432,110615,113760,116873,120017,123098,126133,129218,132212,135239,138234,141200,144081,146941,149840,152690,155507,158334,161132,163947,166744,169508,172257,175052,177755,180392,183026,185694,188271,190878,193423,196000,198509,201122,203606,206101,208611,211041,213497,215819,218156,220545,222749,225069,227393,229545,231730,233968,236138,238262,240340,242450,244594,246673,248826,250855,252884,254885,256860,
0,0,0,0,0,0,0,0,0,0,1,8,17,31,61,111,181,269,407,583,805,1097,1453,1829,2282,2810,3350,4020,4752,5539,6441,7388,8400,9472,10597,11827,13101,14422,15863,17300,18815,20336,21936,23564,25222,26991,28756,30591,32337,34159,35981,37906,39845,41735,43714,45643,47623,49658,51632,53671,55703,57851,59944,62121,64274,66457,68532,70599,72671,74831,77006,79142,81220,83240,85345,87492,89583,91635,93715,95821,97932,100052,102102,104027,106038,108131,110152,112114,114088,116104,118109,120094,122072,124023,125962,127844,129737,131638,133536,135368,137198,139112,140996,142785,144566,146398,148152,149925,151702,153491,155210,156934,158700,160351,162023,163712,165345,166984,168615,170203,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,10,22,41,59,97,133,216,287,383,511,646,802,1001,1220,1446,1726,2052,2392,2781,3199,3641,4125,4672,5240,5830,6483,7104,7872,8625,9373,10177,11005,11869,12728,13649,14576,15519,16491,17542,18509,19492,20511,21661,22758,23882,25040,26183,27322,28475,29681,30888,32085,33338,34554,35807,37059,38282,39556,40841,42223,43472,44738,46010,47249,48544,49843,51156,52461,53769,55051,56402,57682,58997,60296,61662,63020,64283,65550,66904,68205,69477,70769,72040,73301,74603,75843,77141,78463,79758,81006,82265,83498,84777,86024,87316,88500,89774,91005,92233,93395,94530,95695,96861,98064,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,8,12,19,33,50,74,106,130,161,213,276,349,402,479,559,679,791,901,1030,1181,1347,1534,1705,1921,2165,2402,2636,2866,3122,3413,3696,4007,4357,4664,5028,5390,5774,6175,6570,6958,7380,7819,8300,8787,9281,9755,10274,10782,11291,11800,12343,12909,13484,14059,14613,15163,15712,16296,16892,17488,18085,18737,19354,19976,20620,21246,21882,22557,23215,23877,24575,25256,25904,26630,27323,28032,28715,29413,30176,30850,31537,32245,32910,33634,34343,35048,35662,36411,37107,37850,38571,39297,39971,40644,41366,42037,42795,43495,
63811,295703,514617,687398,823413,933806,1025408,1102346,1167853,1224508,1273946,1317885,1356525,1391555,1423112,1452139,1478542,1502813,1525043,1545606,1564756,1582753,1599107,1614611,1629265,1642782,1655773,1667906,1679568,1690551,1700896,1710614,1719907,1728761,1737218,1745440,1753326,1760754,1767880,1774685,1781265,1787574,1793517,1799324,1804996,1810491,1815632,1820690,1825634,1830381,1834915,1839367,1843634,1847854,1851933,1855789,1859593,1863281,1866828,1870184,1873418,1876587,1879890,1882927,1885939,1888837,1891673,1894456,1897093,1899728,1902221,1904708,1907131,1909461,1911730,1914047,1916301,1918527,1920702,1922731,1924746,1926686,1928653,1930517,1932305,1934133,1935884,1937598,1939275,1940995,1942727,1944341,1945931,1947490,1948948,1950477,1951875,1953331,1954692,1956038,1957393,1958689,1960000,1961243,1962464,1963715,1964908,1966161,1967259,1968378,1969570,1970711,1971846,1972897,1973945,1975040,1976019,1977068,1978053,1979019,
14057,131042,289875,436930,564043,671761,764127,844259,914317,975400,1029476,1077827,1121563,1160920,1196547,1229182,1259430,1287196,1312927,1336680,1358851,1379809,1399247,1417451,1434567,1450796,1465982,1480405,1494079,1506685,1519009,1530850,1541785,1552409,1562483,1572200,1581463,1590364,1598838,1607040,1615099,1622673,1629901,1637018,1643773,1650190,1656329,1662628,1668625,1674239,1679565,1684843,1689972,1695007,1699920,1704593,1709191,1713533,1717884,1722070,1725990,1729915,1733695,1737473,1741060,1744613,1748082,1751302,1754616,1757747,1760807,1763893,1766723,1769593,1772353,1775109,1777821,1780412,1782989,1785568,1788079,1790418,1792750,1795127,1797405,1799620,1801837,1803927,1806034,1808080,1810084,1811970,1813861,1815664,1817463,1819299,1821047,1822812,1824542,1826232,1827854,1829467,1831030,1832566,1834032,1835521,1837023,1838493,1839881,1841295,1842601,1843883,1845228,1846518,1847871,1849209,1850458,1851737,1852968,1854133,
4046,67991,184411,305705,418565,519007,608015,686689,756443,818228,873849,923583,969005,1009885,1047523,1082052,1114058,1143533,1170917,1196668,1220718,1243270,1264270,1283804,1302438,1320063,1336539,1352194,1367208,1381346,1394775,1407745,1419768,1431377,1442578,1453228,1463497,1473403,1482722,1491637,1500360,1508699,1516745,1524518,1531906,1539047,1545998,1552794,1559366,1565673,1571632,1577462,1583182,1588731,1593957,1599167,1604343,1609308,1614166,1618736,1623184,1627539,1631729,1635834,1639869,1643790,1647682,1651400,1654980,1658549,1661970,1665467,1668785,1672043,1675124,1678187,1681336,1684310,1687240,1690037,1692846,1695496,1698125,1700741,1703300,1705780,1708192,1710565,1712881,1715079,1717350,1719477,1721603,1723656,1725664,1727651,1729647,1731607,1733472,1735341,1737257,1739106,1740849,1742647,1744370,1746049,1747721,1749426,1751035,1752598,1754111,1755634,1757119,1758619,1760022,1761497,1762951,1764364,1765745,1767120,
633,26030,94122,181423,271424,357544,437441,510450,577356,638460,693061,743156,788638,830871,869765,905604,938764,969668,998674,1025873,1051395,1075336,1097815,1118770,1138691,1157734,1175666,1192743,1208860,1224210,1238776,1252691,1266048,1278943,1291183,1302824,1314163,1324923,1335169,1345275,1354895,1364145,1373105,1381767,1390001,1398006,1405709,1413210,1420435,1427533,1434325,1440938,1447311,1453589,1459494,1465416,1470980,1476454,1481820,1486931,1492157,1497064,1501866,1506420,1511009,1515353,1519463,1523756,1527969,1531882,1535775,1539538,1543370,1546943,1550454,1553948,1557393,1560682,1563903,1567119,1570288,1573338,1576378,1579266,1582111,1584936,1587670,1590301,1592937,1595525,1598101,1600564,1603044,1605326,1607693,1609938,1612232,1614350,1616522,1618567,1620657,1622688,1624722,1626676,1628633,1630550,1632377,1634190,1635972,1637737,1639459,1641193,1642869,1644565,1646166,1647802,1649420,1651010,1652594,1654128,
51,5879,33248,81479,140557,203095,265609,325780,382940,436915,486946,534244,578341,619115,657435,693007,726496,757620,786840,814873,841233,866211,889585,911949,933144,953089,972145,990303,1007496,1024000,1039803,1054944,1069671,1083472,1096919,1109782,1122204,1133993,1145505,1156386,1167014,1177339,1187126,1196725,1205914,1214767,1223467,1231621,1239777,1247538,1255025,1262343,1269566,1276564,1283274,1289809,1296071,1302253,1308116,1313927,1319686,1325250,1330731,1335984,1340974,1346048,1350954,1355611,1360172,1364701,1369002,1373334,1377638,1381671,1385708,1389544,1393405,1397135,1400779,1404389,1407917,1411434,1414757,1417953,1421221,1424401,1427507,1430680,1433668,1436649,1439491,1442292,1445059,1447859,1450497,1453122,1455657,1458146,1460619,1463039,1465438,1467694,1470041,1472301,1474531,1476686,1478853,1480932,1483066,1485068,1487027,1488940,1490912,1492889,1494817,1496667,1498493,1500336,1502135,1503813,
6,1935,15668,45564,87414,135721,186077,237001,286981,334813,380518,423703,464871,503212,539825,574398,606647,637090,666045,693481,719838,744485,768064,790535,812163,832297,851729,870457,888220,904963,921189,936677,951658,966083,979837,993018,1005940,1017995,1029823,1041114,1052172,1062743,1072970,1082777,1092440,1101729,1110874,1119698,1128209,1136349,1144383,1152031,1159324,1166668,1173926,1180706,1187323,1193786,1200078,1206162,1212075,1217886,1223494,1228975,1234507,1239800,1244946,1250063,1254892,1259747,1264498,1269216,1273661,1278097,1282393,1286482,1290525,1294594,1298603,1302514,1306203,1309963,1313487,1317067,1320491,1323931,1327210,1330476,1333588,1336642,1339751,1342744,1345668,1348638,1351517,1354307,1357044,1359808,1362420,1364983,1367495,1370007,1372543,1374945,1377397,1379760,1382007,1384174,1386380,1388545,1390657,1392816,1394935,1397067,1399113,1401114,1403076,1404988,1406839,1408777,
0,480,5995,21339,46711,79378,116150,155732,195736,235571,274393,312069,348650,383464,416864,448954,479375,508437,536115,562593,587709,611928,634873,656776,677753,698026,717088,735596,753311,770104,786563,802182,817361,832160,846186,859800,872919,885614,897524,909186,920491,931555,942229,952527,962526,972239,981529,990556,999450,1008067,1016504,1024561,1032429,1039978,1047326,1054411,1061473,1068398,1075038,1081482,1087861,1094068,1100157,1105942,1111545,1117092,1122659,1128013,1133173,1138181,1143146,1148011,1152675,1157364,1161905,1166323,1170714,1174972,1179151,1183255,1187277,1191283,1195163,1198900,1202550,1206291,1209862,1213351,1216735,1220025,1223179,1226467,1229690,1232801,1235890,1238829,1241908,1244796,1247782,1250546,1253283,1255945,1258661,1261245,1263827,1266328,1268783,1271203,1273568,1275917,1278214,1280543,1282724,1284915,1287180,1289368,1291466,1293541,1295559,1297644,
0,69,1543,7667,19972,38625,61990,88923,117962,148047,178738,209360,239646,269332,297765,325649,352738,378756,404029,428411,451818,474075,495553,516310,536101,555232,573927,591719,608783,625331,641228,656640,671651,685843,699599,713394,726777,739602,751890,763873,775372,786425,797285,807908,818073,828031,837363,846632,855670,864285,872831,881023,889199,896970,904547,912195,919441,926560,933292,940012,946653,953072,959485,965550,971460,977298,983026,988626,994190,999424,1004668,1009680,1014605,1019556,1024303,1029009,1033550,1037928,1042274,1046532,1050754,1054905,1059032,1062954,1066871,1070724,1074457,1078166,1081796,1085347,1088773,1092204,1095603,1098769,1102019,1105204,1108282,1111377,1114394,1117309,1120237,1123118,1125885,1128754,1131535,1134255,1136848,1139450,1142019,1144476,1146870,1149250,1151653,1154046,1156346,1158565,1160793,1163014,1165214,1167380,
0,4,263,1846,6205,14218,26067,41116,58683,78166,99283,120615,142815,165123,187324,209765,231921,253577,274722,295381,315658,335295,354268,372952,390725,408042,424920,441175,457186,472636,487710,502239,516320,530015,543293,556292,568870,581182,593263,604723,615871,626709,637378,647634,657615,667354,676933,685995,694875,703601,712207,720535,728758,736717,744472,752133,759479,766552,773467,780195,786962,793610,800018,806262,812300,818242,824059,829725,835311,840697,845978,851334,856565,861610,866414,871370,875990,880623,885104,889512,893882,898218,902428,906604,910606,914578,918637,922493,926220,929890,933566,937131,940671,944051,947428,950828,954083,957341,960516,963634,966571,969567,972427,975378,978284,981080,983842,986558,989162,991793,994409,996882,999436,1001917,1004378,1006818,1009112,1011432,1013773,1016114,
0,2,55,516,2342,6378,12976,22109,33477,46776,61811,77750,94566,111843,129659,147880,165909,184319,202200,219999,237344,254636,271436,287900,304027,319846,335073,350183,364784,379049,393058,406662,420177,432951,445438,457652,469494,481180,492570,503460,514301,524936,535088,544889,554765,564238,573438,582543,591351,600026,608556,616602,624644,632316,639802,647161,654441,661537,668615,675593,682146,688672,695089,701420,707503,713520,719343,725105,730644,736051,741513,746925,752013,757124,762128,766939,771571,776177,780842,785257,789631,793894,798113,802308,806385,810390,814439,818292,822066,825787,829485,833190,836786,840310,843820,847241,850579,853824,856991,860320,863465,866556,869541,872495,875537,878478,881259,884034,886815,889516,892187,894851,897433,900014,902533,904987,907409,909805,912163,914476,
0,0,5,110,686,2321,5314,10029,16545,24712,34160,44982,56825,69179,82358,96086,110172,124477,138930,153485,167869,181953,196275,210304,224051,237721,251243,264506,277446,290138,302422,314684,326528,338464,350001,361116,372238,382894,393409,403690,413577,423416,432809,442151,451190,460130,468951,477568,485918,494092,502031,509929,517458,524989,532291,539399,546384,553325,560002,566645,573106,579348,585540,591533,597417,603231,608924,614529,620059,625389,630620,635868,640990,646038,650947,655915,660631,665320,669993,674505,678945,683257,687488,691705,695803,699843,703611,707493,711296,715010,718849,722534,726199,729739,733263,736589,739963,743232,746417,749691,752845,755936,759072,762028,764861,767740,770671,773487,776319,779131,781783,784368,786968,789558,792148,794699,797165,799686,802066,804450,
0,0,1,21,159,626,1703,3615,6580,10692,16038,22340,29509,37304,46051,55309,64961,75212,85641,96455,107377,118450,129513,140459,151746,162946,173675,184720,195603,206263,216773,227120,237232,247408,257291,267023,276649,285940,295104,304093,312815,321649,330201,338660,347044,355215,363231,371032,378789,386195,393657,400968,408222,415238,422108,428807,435477,441957,448200,454457,460599,466551,472443,478290,483866,489407,494960,500486,505555,510805,516057,521092,526019,531030,535779,540349,544947,549329,553727,558103,562440,566630,570873,574956,578986,582898,586730,590551,594234,597933,601500,605101,608687,612135,615617,618923,622207,625354,628611,631779,634936,637947,640932,643866,646863,649819,652706,655482,658249,661025,663768,666448,669029,671556,674086,676627,679104,681517,683875,686223,
0,0,1,3,24,123,386,968,2028,3701,5988,8978,12584,16823,21649,27101,32896,39172,45952,52924,60188,67774,75721,83612,91658,99695,108025,116318,124436,132713,141155,149315,157463,165651,173682,181748,189599,197282,204923,212570,220128,227646,234980,242366,249380,256346,263182,269943,276652,283379,289949,296442,302700,308894,314939,320789,326700,332449,338147,343847,349432,354986,360465,365779,371020,376117,381204,386016,390899,395687,400363,405139,409790,414330,418768,423076,427368,431701,435873,439962,443971,447911,451796,455756,459579,463384,467027,470680,474324,477804,481207,484620,488003,491340,494726,498029,501272,504420,507530,510624,513596,516581,519466,522382,525221,528020,530773,533504,536214,538900,541483,544073,546632,549081,551622,554098,556494,558950,561287,563588,
0,0,0,0,1,11,50,165,406,869,1589,2627,4015,5753,7941,10415,13318,16552,20030,23950,28157,32589,37229,42153,47272,52572,57914,63326,68914,74541,80283,86158,91911,97711,103575,109415,115207,121224,126873,132750,138633,144444,150207,155944,161593,167337,172897,178427,183864,189342,194711,200006,205288,210439,215572,220622,225553,230441,235355,240118,244757,249401,253970,258514,263103,267568,271902,276248,280502,284702,288961,293063,297141,301175,305239,309215,313226,317016,320755,324349,327951,331550,335168,338639,342041,345435,348890,352205,355469,358678,361898,365062,368099,371184,374079,377087,380002,382914,385784,388646,391455,394219,396919,399560,402226,404808,407397,409888,412414,414945,417425,419748,422169,424687,427061,429383,431699,433929,436283,438552,
0,0,0,0,0,1,2,21,72,175,367,626,1073,1697,2533,3553,4763,6180,7924,9901,12043,14307,16826,19512,22374,25463,28731,32075,35630,39211,42891,46681,50518,54507,58583,62732,66987,71165,75299,79420,83720,87841,92075,96360,100572,104810,109220,113454,117690,121879,126040,130149,134218,138378,142396,146422,150444,154498,158463,162397,166338,170139,173898,177745,181477,185173,188906,192497,196092,199614,203188,206631,209983,213317,216732,219998,223278,226547,229842,233043,236288,239458,242490,245574,248599,251513,254450,257424,260380,263217,265959,268704,271547,274336,276969,279514,282147,284778,287412,289877,292417,294958,297455,299792,302130,304564,306807,309208,311493,313795,316071,318262,320362,322572,324637,326746,328823,330893,332975,334998,
0,0,0,0,0,0,0,0,4,21,53,112,197,347,542,812,1173,1649,2212,2924,3799,4758,5809,6957,8265,9672,11210,12782,14572,16472,18429,20510,22644,24943,27238,29631,32115,34537,37078,39633,42242,44879,47554,50348,53075,55877,58603,61518,64210,66995,69874,72737,75577,78441,81393,84276,87143,90023,92867,95716,98520,101278,104163,107117,109981,112763,115637,118465,121218,123857,126585,129265,131958,134709,137297,139914,142465,145004,147602,150070,152618,155117,157565,160088,162473,164871,167316,169754,172149,174527,176805,179068,181370,183543,185849,188097,190270,192473,194648,196717,198810,200933,203080,205088,207075,209138,211156,213105,215029,216921,218844,220708,222593,224522,226373,228128,229895,231711,233502,235247,
0,0,0,0,0,0,0,0,0,0,2,6,10,25,51,98,178,264,392,560,755,990,1254,1601,1990,2448,2904,3417,4026,4755,5462,6277,7113,8027,9046,10081,11173,12294,13482,14775,16107,17349,18757,20116,21545,22901,24425,26000,27588,29117,30798,32468,34183,35896,37642,39346,41058,42780,44596,46460,48230,50042,51854,53642,55387,57165,58949,60707,62579,64356,66189,67951,69789,71666,73477,75264,77057,78851,80681,82414,84244,85973,87716,89388,91178,92978,94629,96278,97988,99693,101436,103131,104813,106448,108135,109778,111470,113065,114648,116198,117818,119390,120940,122534,124143,125674,127156,128708,130139,131590,133096,134665,136111,137609,139147,140600,142033,143421,144781,146196,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,7,11,16,23,40,65,96,131,182,245,333,430,531,659,826,1002,1177,1381,1617,1850,2141,2450,2780,3168,3569,3960,4398,4855,5309,5824,6354,6906,7464,8061,8676,9281,9953,10613,11325,12021,12737,13478,14289,15059,15833,16621,17414,18209,19033,19877,20744,21591,22514,23356,24302,25241,26120,26997,27937,28851,29786,30694,31617,32505,33478,34492,35462,36428,37407,38342,39302,40295,41254,42234,43191,44154,45193,46170,47154,48130,49150,50172,51192,52140,53118,54112,55126,56117,57085,58014,58952,59932,60813,61770,62660,63605,64514,65471,66370,67332,68235,69104,69993,70952,
75827,318064,535048,703014,834578,940578,1027312,1100420,1162309,1215665,1262168,1303716,1340545,1373541,1403126,1430193,1454863,1477562,1498402,1517827,1535856,1552442,1568049,1582788,1596619,1609553,1621823,1633160,1643984,1654162,1663936,1673172,1682003,1690478,1698431,1706047,1713458,1720346,1727100,1733696,1739911,1745976,1751700,1757180,1762457,1767566,1772543,1777521,1782162,1786640,1790894,1795103,1799283,1803174,1807039,1810764,1814354,1817772,1821190,1824451,1827678,1830735,1833635,1836610,1839438,1842197,1844868,1847519,1850127,1852614,1855116,1857513,1859876,1862174,1864334,1866531,1868651,1870723,1872714,1874696,1876694,1878610,1880444,1882282,1884021,1885786,1887461,1889093,1890750,1892360,1893869,1895499,1896982,1898493,1899956,1901396,1902796,1904166,1905512,1906844,1908118,1909400,1910618,1911795,1913055,1914203,1915450,1916572,1917682,1918765,1919874,1920930,1922067,1923057,1924105,1925135,1926148,1927084,1928034,1929001,
19945,152320,317117,464350,588016,692592,781088,857388,923887,981478,1032305,1078182,1119094,1155760,1189215,1219747,1247612,1273425,1297363,1319756,1340542,1359821,1377976,1394887,1410941,1425937,1440160,1453391,1466217,1478352,1489703,1500508,1510843,1520821,1530145,1539250,1547877,1556199,1564145,1571856,1579208,1586274,1593075,1599782,1606142,1612164,1617989,1623571,1629124,1634353,1639579,1644522,1649332,1654046,1658634,1663062,1667320,1671454,1675476,1679359,1683166,1686883,1690437,1693958,1697251,1700611,1703871,1707069,1710082,1713117,1716014,1718843,1721584,1724356,1727014,1729677,1732243,1734777,1737299,1739695,1742005,1744214,1746425,1748520,1750667,1752781,1754813,1756814,1758771,1760643,1762519,1764344,1766276,1768063,1769805,1771567,1773260,1774876,1776526,1778102,1779681,1781227,1782719,1784205,1785652,1787013,1788475,1789896,1791301,1792563,1793839,1795077,1796362,1797604,1798864,1800085,1801236,1802446,1803578,1804691,
6725,85188,210947,336284,448726,547492,633660,709432,776286,835130,887258,934377,976379,1014916,1050267,1082625,1112496,1139810,1165222,1189152,1211334,1232145,1251614,1269834,1287058,1303299,1318507,1333139,1346972,1360099,1372299,1384131,1395512,1406350,1416606,1426487,1436216,1445364,1454104,1462456,1470431,1478206,1485702,1492804,1499632,1506243,1512749,1519021,1525154,1531049,1536759,1542282,1547722,1552840,1557840,1562626,1567388,1571929,1576366,1580704,1584887,1588893,1592878,1596733,1600450,1604215,1607776,1611281,1614717,1618042,1621260,1624482,1627683,1630693,1633659,1636542,1639359,1642225,1644971,1647576,1650103,1652625,1655015,1657389,1659745,1662125,1664391,1666666,1668816,1670977,1672978,1675129,1677168,1679186,1681156,1683027,1684872,1686681,1688452,1690186,1691873,1693578,1695213,1696851,1698482,1700081,1701637,1703225,1704730,1706168,1707640,1709030,1710421,1711774,1713163,1714591,1715880,1717206,1718511,1719829,
1442,37317,117997,213209,306735,393977,472821,544208,608669,667087,719238,766290,809325,848919,885582,919183,950088,978867,1005956,1031053,1054403,1076355,1097199,1116816,1135351,1153142,1169587,1185402,1200348,1214481,1228101,1240954,1253223,1264918,1276314,1287109,1297479,1307352,1316759,1325937,1334800,1343323,1351492,1359344,1366914,1374281,1381530,1388460,1395232,1401816,1408004,1414051,1420036,1425791,1431468,1436860,1442138,1447350,1452185,1457023,1461582,1466161,1470551,1474768,1479016,1483047,1486965,1490818,1494629,1498301,1501912,1505328,1508841,1512243,1515457,1518612,1521856,1524903,1527917,1530794,1533739,1536563,1539313,1542013,1544614,1547157,1549714,1552288,1554756,1557128,1559491,1561832,1564053,1566242,1568393,1570556,1572678,1574688,1576745,1578652,1580573,1582500,1584459,1586243,1588083,1589879,1591571,1593320,1595063,1596671,1598283,1599857,1601421,1603002,1604500,1605994,1607515,1608948,1610451,1611879,
117,10559,48865,107214,173468,240760,306307,367785,424831,478057,526912,572668,614437,653072,689710,723501,754947,784340,811867,837920,862388,885561,907462,927832,947386,966027,983444,1000213,1016297,1031519,1046075,1059973,1073615,1086291,1098488,1110299,1121538,1132588,1143098,1153339,1162866,1172075,1181013,1189867,1198288,1206403,1214478,1222083,1229412,1236560,1243463,1250175,1256734,1263086,1269185,1275097,1280942,1286508,1291978,1297382,1302604,1307608,1312556,1317332,1322092,1326598,1330976,1335376,1339510,1343586,1347586,1351599,1355552,1359373,1363126,1366733,1370236,1373657,1377012,1380357,1383570,1386755,1389886,1392986,1395881,1398900,1401841,1404725,1407453,1410122,1412736,1415266,1417750,1420208,1422609,1425086,1427462,1429794,1432044,1434313,1436466,1438542,1440715,1442857,1444897,1446905,1448852,1450766,1452726,1454636,1456424,1458276,1460065,1461825,1463556,1465268,1466957,1468532,1470056,1471685,
19,4332,26257,65948,116314,170764,226213,279923,331251,380072,425907,468790,508573,545975,581054,614381,645137,674091,701424,727410,751654,775085,797306,818221,838088,856895,874918,892121,908576,924226,939275,953395,967394,980584,993268,1005397,1017154,1028235,1038997,1049329,1059360,1069119,1078512,1087613,1096345,1104688,1113001,1121093,1128881,1136296,1143519,1150528,1157536,1164175,1170679,1176871,1182883,1188750,1194501,1200091,1205476,1210843,1215998,1221004,1225927,1230696,1235409,1239971,1244455,1248828,1253088,1257284,1261414,1265390,1269359,1273179,1276864,1280527,1284131,1287702,1291135,1294504,1297807,1301014,1304180,1307380,1310522,1313379,1316302,1319175,1321993,1324798,1327453,1330067,1332726,1335406,1337948,1340392,1342830,1345200,1347526,1349829,1352142,1354374,1356632,1358744,1360805,1362903,1364947,1366986,1368975,1370927,1372797,1374697,1376579,1378374,1380119,1381839,1383534,1385231,
0,1298,11604,35097,69054,109598,152937,196858,240351,282779,323337,362211,399319,434039,467244,498540,527857,555675,582115,607566,631782,654500,676084,696886,716944,735996,753964,771299,787904,803652,818948,833578,847662,860886,873931,886497,898567,910200,921191,931885,942476,952471,962222,971563,980658,989498,997883,1006067,1014242,1022156,1029866,1037154,1044321,1051210,1058036,1064762,1071149,1077338,1083318,1089119,1094862,1100502,1106052,1111280,1116421,1121393,1126371,1131121,1135771,1140423,1144784,1149229,1153672,1157906,1162078,1166109,1170161,1173990,1177755,1181407,1185026,1188738,1192183,1195622,1199008,1202378,1205601,1208783,1211930,1215119,1218035,1220934,1223900,1226589,1229327,1232075,1234753,1237453,1240057,1242601,1245064,1247505,1249828,1252231,1254556,1256830,1259076,1261312,1263445,1265587,1267655,1269704,1271761,1273753,1275761,1277626,1279530,1281375,1283209,1285024,
0,268,3830,14996,34630,60950,91259,123974,158051,192096,225979,259412,291094,321794,351162,379294,406480,432356,457420,481451,504173,525763,546800,566634,585698,603989,621741,638835,655257,670809,685952,700431,714431,727723,740899,753366,765566,777490,788892,799776,810392,820541,830507,840125,849488,858355,867070,875612,883794,891852,899823,907464,914755,921993,929095,935867,942558,948939,955435,961464,967449,973292,979059,984551,989984,995174,1000411,1005532,1010445,1015186,1019864,1024499,1029110,1033436,1037803,1041988,1046185,1050229,1054210,1058181,1062061,1065755,1069503,1073113,1076657,1080118,1083552,1086958,1090286,1093496,1096671,1099681,1102706,1105657,1108530,1111476,1114344,1117130,1119797,1122476,1125061,1127595,1130194,1132780,1135262,1137648,1140091,1142406,1144716,1146996,1149281,1151467,1153595,1155797,1157881,1159974,1162098,1164073,1166107,1167990,
0,29,837,4712,13208,26842,44822,65554,88799,113252,138480,163983,189208,214211,239014,262980,286369,309231,331371,352538,373170,392845,411920,430273,448178,465240,482139,498159,513616,528700,543146,557077,570547,583474,596111,608385,620327,632025,643425,654106,664553,674664,684615,694176,703542,712713,721459,730028,738564,746576,754434,762128,769667,777044,784200,791160,798010,804504,811012,817260,823334,829448,835364,841045,846625,852066,857586,862737,867870,872838,877654,882378,887020,891644,896180,900569,904859,909051,913127,917184,921068,925034,928893,932674,936425,940014,943655,947208,950726,954171,957512,960791,963944,967095,970107,973126,976202,979116,982013,984820,987524,990203,992866,995581,998155,1000769,1003280,1005803,1008217,1010649,1013041,1015305,1017577,1019836,1022078,1024264,1026298,1028428,1030510,1032716,
0,4,276,1854,6218,14061,25481,39652,56300,74592,94321,114366,134890,155847,176386,197012,217151,237016,256529,275439,294176,312061,329657,346662,363220,379167,394748,410048,424827,439043,452698,465932,478937,491482,503676,515624,527192,538314,549289,559758,570094,580153,589819,599189,608545,617561,626154,634735,643061,651210,658991,666747,674141,681343,688365,695297,702104,708777,715241,721621,727683,733820,739886,745591,751301,756875,762253,767586,772807,777849,782789,787671,792302,796973,801543,806017,810363,814720,818916,823067,826951,830946,834902,838718,842545,846195,849864,853424,856842,860232,863591,866916,870071,873333,876497,879588,882681,885675,888619,891558,894347,897057,899789,902503,905163,907815,910453,912974,915529,918117,920524,922918,925302,927563,929950,932169,934268,936461,938626,940724,
0,1,53,602,2428,6228,12547,21273,31967,44607,58573,73485,89035,105073,121319,138025,154939,171648,188038,204341,220379,236301,251894,267130,281582,296005,310213,323967,337203,350292,363113,375676,387780,399706,411149,422269,433115,443706,454050,464322,474004,483665,493083,501996,510781,519533,527997,536162,544215,552086,559860,567438,574783,581792,588634,595401,602219,608833,615083,621277,627440,633364,639131,644787,650410,655841,661276,666490,671728,676797,681879,686829,691608,696295,700918,705407,709802,714024,718185,722238,726319,730301,734261,738105,741868,745681,749312,752854,756366,759820,763285,766680,769884,773119,776372,779534,782562,785579,788609,791570,794505,797327,800194,802990,805696,808377,811021,813600,816226,818722,821204,823684,826086,828461,830893,833141,835356,837632,839788,841944,
0,0,4,132,699,2206,5033,9464,15471,22856,31611,41351,51929,63248,75177,87626,100426,113338,126288,139328,152336,165308,178219,190810,203478,215759,227771,239785,251556,263052,274303,285382,296161,306838,317256,327043,336988,346695,356150,365522,374377,383296,392033,400615,408913,416996,425016,432755,440398,447930,455276,462340,469482,476237,482948,489630,496102,502231,508461,514578,520539,526402,532303,537908,543335,548537,553789,559004,564283,569279,574181,578975,583578,588155,592731,597156,601457,605759,610028,614210,618245,622225,626079,629899,633729,637416,641081,644617,648224,651686,655060,658442,661752,665046,668081,671159,674257,677247,680229,683229,686149,688986,691752,694556,697382,700075,702724,705230,707855,710424,712921,715302,717799,720154,722479,724831,727029,729288,731531,733728,
0,0,1,24,116,510,1450,3125,5825,9431,13948,19511,26033,33037,40725,48902,57552,66670,75931,85480,95180,104883,114577,124300,134145,143957,153766,163283,172784,182256,191455,200649,209779,218769,227671,236545,245149,253465,261770,269851,277916,285734,293514,301187,308588,315986,323135,330032,336931,343720,350535,357093,363484,369838,375994,382225,388265,394157,400018,405689,411283,416808,422174,427437,432522,437586,442653,447566,452342,457132,461864,466424,470905,475396,479688,483923,488122,492328,496332,500314,504273,508043,511822,515511,519116,522704,526226,529787,533281,536622,539966,543297,546504,549658,552786,555918,558896,561880,564812,567749,570678,573375,576234,578995,581765,584424,587035,589577,592141,594641,597163,599624,601969,604402,606730,608946,611148,613432,615585,617736,
0,0,0,0,16,98,327,780,1577,2864,4784,7159,10070,13623,17658,22178,27113,32297,37943,43918,50178,56585,63333,70194,77108,84096,91166,98425,105494,112768,119955,127198,134243,141379,148376,155353,162207,169021,175815,182716,189323,195901,202384,208813,215158,221387,227499,233466,239309,245150,251024,256664,262297,267799,273233,278601,283826,288930,294031,299122,303916,308902,313722,318312,323034,327628,332090,336576,340842,345040,349310,353457,357530,361568,365457,369440,373338,377173,380850,384544,388121,391660,395169,398652,402048,405459,408590,411961,415195,418443,421515,424600,427709,430665,433545,436456,439248,441985,444712,447472,450209,452942,455567,458263,460879,463366,465935,468448,470839,473343,475742,478099,480413,482665,484903,487109,489279,491485,493634,495752,
0,0,0,0,2,10,53,145,384,754,1314,2290,3476,5064,6965,9181,11720,14676,17766,21123,24801,28678,32758,37089,41629,46154,50886,55880,60729,65569,70527,75709,80877,86072,91286,96614,101786,106981,112194,117383,122595,127783,132757,137843,142803,147837,152878,157716,162523,167257,172008,176710,181305,185905,190552,195154,199672,203992,208308,212506,216827,221109,225222,229279,233291,237379,241329,245251,249069,252825,256604,260209,263827,267441,271008,274510,278030,281438,284948,288385,291699,294938,298204,301402,304430,307429,310502,313526,316480,319291,322065,324907,327676,330420,333184,335904,338473,341152,343767,346346,348761,351300,353852,356322,358812,361094,363352,365697,367989,370218,372578,374777,376965,379132,381249,383331,385473,387475,389493,391501,
0,0,0,0,0,1,4,14,46,122,243,452,800,1265,1887,2670,3688,4787,6138,7663,9411,11282,13398,15600,17955,20405,22941,25619,28499,31422,34429,37517,40847,44103,47456,50850,54296,57806,61336,64926,68491,72099,75592,79242,82753,86307,89870,93601,97086,100579,104105,107623,111121,114610,118071,121547,124964,128433,131873,135238,138651,141936,145175,148522,151785,154984,158176,161157,164332,167399,170465,173546,176488,179435,182398,185264,188149,191129,193990,196685,199373,202043,204851,207598,210284,212885,215509,218066,220542,223046,225482,227873,230297,232683,234985,237322,239532,241868,244125,246415,248580,250861,253063,255148,257253,259344,261463,263573,265582,267625,269682,271625,273632,275574,277507,279357,281252,283028,284823,286623,
0,0,0,0,0,0,0,2,2,9,18,47,99,188,301,471,696,972,1342,1786,2314,2932,3616,4398,5252,6193,7265,8424,9624,10902,12287,13759,15382,17018,18661,20405,22307,24086,25881,27790,29743,31732,33797,35905,38021,40205,42321,44500,46718,48960,51229,53457,55622,57883,60138,62338,64592,66927,69150,71409,73690,75958,78276,80536,82725,84896,87188,89428,91600,93778,96002,98163,100378,102631,104764,106976,109102,111203,113235,115319,117376,119438,121438,123511,125520,127628,129668,131680,133605,135611,137514,139427,141392,143218,145083,146961,148812,150679,152423,154183,155944,157662,159471,161186,162868,164484,166162,167845,169544,171189,172851,174448,176091,177704,179267,180815,182352,183863,185342,186786,
0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,11,33,56,90,137,208,295,385,533,679,885,1082,1317,1569,1910,2269,2658,3096,3553,4082,4621,5148,5756,6370,7032,7725,8470,9273,10068,10871,11741,12587,13509,14429,15408,16379,17385,18422,19499,20528,21546,22575,23589,24709,25832,27005,28147,29356,30538,31672,32830,34056,35218,36475,37663,38905,40126,41316,42505,43710,44925,46166,47384,48583,49783,51026,52272,53548,54803,56054,57237,58455,59662,60870,62112,63331,64562,65784,66984,68186,69305,70456,71612,72773,73935,75097,76193,77382,78598,79749,80909,81959,83085,84211,85347,86492,87593,88665,89726,90850,91947,92982,94116,95193,96265,
87332,337324,552034,715934,842963,944475,1027802,1097905,1157218,1208414,1252689,1292378,1326992,1358302,1386367,1411933,1435627,1457290,1477227,1495742,1512826,1528867,1543830,1557797,1570725,1582907,1594438,1605348,1615540,1625346,1634585,1643679,1652014,1659920,1667588,1674890,1682052,1688755,1695312,1701567,1707411,1713100,1718580,1723840,1728978,1733881,1738555,1743101,1747564,1751831,1755934,1760063,1763977,1767764,1771431,1774963,1778388,1781813,1785024,1788145,1791213,1794221,1797032,1799740,1802489,1805186,1807778,1810330,1812827,1815282,1817621,1819911,1822119,1824317,1826467,1828523,1830586,1832637,1834598,1836492,1838352,1840216,1842011,1843709,1845481,1847175,1848825,1850426,1852021,1853544,1855095,1856627,1858080,1859581,1860957,1862386,1863718,1865084,1866403,1867643,1868967,1870181,1871446,1872682,1873866,1875019,1876096,1877165,1878308,1879360,1880409,1881421,1882460,1883495,1884539,1885514,1886485,1887390,1888346,1889235,
26057,171510,340430,486639,607867,708810,794190,867433,930701,985605,1034125,1077492,1116008,1151113,1182504,1211596,1238086,1262478,1285239,1306172,1325710,1344098,1361036,1377082,1392198,1406177,1419564,1432320,1444400,1455844,1466594,1476886,1486720,1496141,1504903,1513381,1521619,1529582,1537097,1544444,1551504,1558138,1564596,1570625,1576715,1582576,1588157,1593464,1598688,1603845,1608676,1613395,1617912,1622418,1626747,1630885,1634960,1638931,1642693,1646407,1650008,1653466,1656927,1660281,1663558,1666775,1669777,1672764,1675791,1678639,1681462,1684195,1686856,1689529,1691968,1694480,1696904,1699299,1701700,1704068,1706239,1708410,1710507,1712484,1714466,1716439,1718401,1720271,1722215,1724038,1725860,1727683,1729395,1731092,1732780,1734431,1736049,1737612,1739131,1740626,1742114,1743577,1745011,1746437,1747843,1749234,1750558,1751919,1753233,1754523,1755833,1757048,1758253,1759520,1760683,1761882,1763062,1764243,1765371,1766484,
10114,102143,235928,363917,475534,572347,656492,728888,793040,849026,898992,943745,983741,1020250,1053377,1083877,1112175,1137900,1162003,1184443,1205012,1224749,1242980,1260139,1276491,1291696,1305979,1319761,1333024,1345366,1356920,1368123,1378734,1388738,1398433,1407687,1416553,1425138,1433190,1441097,1448655,1455907,1462945,1469540,1476114,1482391,1488455,1494312,1500089,1505671,1511154,1516270,1521352,1526193,1530795,1535460,1539831,1544135,1548403,1552512,1556429,1560361,1564036,1567692,1571243,1574670,1578142,1581389,1584569,1587736,1590794,1593793,1596777,1599702,1602453,1605116,1607740,1610453,1613000,1615592,1618063,1620537,1622913,1625092,1627297,1629507,1631664,1633724,1635760,1637802,1639846,1641740,1643652,1645569,1647470,1649281,1651032,1652750,1654440,1656063,1657700,1659264,1660887,1662501,1664031,1665540,1666989,1668441,1669952,1671361,1672762,1674101,1675409,1676795,1678071,1679301,1680591,1681837,1683065,1684296,
2597,48577,139699,240368,336461,423928,502311,571824,634069,689871,739974,785231,826601,864042,898171,929823,958984,986297,1011644,1035418,1057596,1078308,1097966,1116541,1133991,1150469,1165990,1180659,1194809,1208271,1220888,1232913,1244672,1255771,1266241,1276465,1286278,1295555,1304297,1312914,1321272,1329268,1336802,1344186,1351246,1357963,1364705,1371295,1377682,1383828,1389593,1395204,1400814,1406248,1411486,1416465,1421327,1425968,1430517,1434999,1439408,1443757,1447851,1451846,1455846,1459634,1463372,1466977,1470474,1473808,1477247,1480502,1483811,1487019,1490120,1493142,1496050,1498898,1501813,1504536,1507229,1509957,1512588,1515114,1517576,1520009,1522425,1524726,1527101,1529290,1531486,1533676,1535730,1537793,1539815,1541869,1543867,1545881,1547701,1549536,1551353,1553110,1554936,1556784,1558454,1560182,1561815,1563478,1565121,1566723,1568264,1569742,1571229,1572757,1574214,1575638,1577101,1578492,1579851,1581190,
294,16297,64797,131595,203380,273987,341201,402783,459195,511555,559568,603456,643770,681364,716284,748386,778315,806078,831972,856673,879583,901504,922024,941335,959658,977019,993690,1009485,1024530,1038767,1052204,1065099,1077724,1089682,1101057,1112083,1122674,1132896,1142560,1151884,1160799,1169655,1178083,1186165,1194063,1201565,1209000,1216140,1222868,1229477,1235908,1242167,1248280,1254276,1259973,1265509,1270824,1276000,1281180,1286208,1291025,1295782,1300430,1304985,1309461,1313705,1317724,1321876,1325816,1329491,1333320,1337052,1340611,1344169,1347544,1350801,1354091,1357313,1360437,1363544,1366537,1369495,1372419,1375178,1377996,1380834,1383552,1386121,1388647,1391167,1393556,1395988,1398386,1400605,1402912,1405115,1407355,1409515,1411581,1413715,1415762,1417697,1419690,1421614,1423488,1425398,1427265,1429088,1430849,1432628,1434337,1436068,1437765,1439430,1441065,1442642,1444280,1445800,1447364,1448834,
91,7579,37694,86547,143682,203063,261058,316543,368414,417130,462184,504450,543408,579630,613850,645753,675330,703022,728999,753666,776886,798748,819608,839196,858010,875643,892387,908298,923777,938508,952451,965882,978581,990899,1002608,1014128,1025182,1035662,1045748,1055673,1065107,1074122,1082815,1091195,1099439,1107313,1114904,1122304,1129591,1136456,1143257,1149750,1156346,1162631,1168671,1174522,1180195,1185636,1190994,1196095,1201163,1206091,1210941,1215574,1220265,1224679,1229006,1233330,1237518,1241643,1245671,1249574,1253460,1257136,1260730,1264196,1267620,1271040,1274474,1277676,1280856,1283941,1287030,1290042,1292932,1295957,1298846,1301597,1304305,1307002,1309578,1312177,1314674,1317094,1319569,1321918,1324314,1326729,1329048,1331391,1333479,1335677,1337748,1339894,1341951,1343977,1345901,1347876,1349749,1351526,1353292,1355108,1356863,1358678,1360436,1362072,1363717,1365440,1367032,1368579,
11,2716,18550,49531,90949,137344,184959,232078,277694,321125,362255,401521,438298,472885,505513,536141,564706,591738,617897,642024,665018,686860,707693,727263,745967,763900,780842,796912,812518,827373,841656,855165,868320,881016,893183,904809,915951,926720,937137,947155,956866,966207,975337,983978,992435,1000691,1008495,1016190,1023691,1030960,1038241,1045034,1051690,1058078,1064588,1070693,1076656,1082348,1088022,1093372,1098707,1103950,1109072,1113975,1118720,1123303,1127821,1132305,1136692,1140949,1145073,1149121,1153219,1157076,1160841,1164633,1168412,1172049,1175601,1179020,1182369,1185677,1188953,1192139,1195224,1198400,1201528,1204539,1207365,1210275,1212940,1215660,1218315,1220884,1223398,1225940,1228498,1230909,1233317,1235686,1237951,1240231,1242518,1244684,1246832,1248987,1251073,1253132,1255141,1257082,1259112,1260984,1262892,1264777,1266586,1268452,1270270,1272017,1273701,1275373,
1,725,7478,24359,50426,82824,118592,155453,192812,229287,264860,298975,331824,363142,392684,421125,448367,473888,498549,521800,543747,564569,584863,604154,622539,640146,657172,673268,688755,703766,717914,731678,744961,757695,769909,781839,793270,804114,814733,824940,834887,844380,853815,862760,871472,879918,888139,896276,904023,911466,918940,926029,932886,939685,946180,952635,958741,964791,970794,976446,981918,987272,992707,997823,1002856,1007676,1012495,1017183,1021841,1026269,1030644,1035010,1039267,1043365,1047328,1051282,1055173,1058803,1062536,1066115,1069618,1073166,1076669,1080072,1083478,1086690,1089823,1092944,1095959,1098941,1101938,1104752,1107622,1110345,1113046,1115740,1118424,1120902,1123478,1126018,1128473,1130900,1133287,1135521,1137786,1139931,1142108,1144314,1146379,1148459,1150581,1152667,1154638,1156659,1158627,1160502,1162414,1164259,1166108,1167851,
0,120,1992,9037,22452,41341,64524,90453,117627,145809,173868,201692,228819,255432,281380,306128,330244,353383,375371,396509,417066,436770,455644,473918,491322,508284,524707,540059,555049,569468,583447,596814,609743,622382,634419,646196,657677,668565,679198,689373,699152,708911,718369,727699,736552,745147,753670,761747,769544,777187,784568,791751,798973,805752,812423,819037,825369,831498,837763,843589,849345,854889,860277,865618,870844,875901,880976,885794,890524,895063,899433,903853,908219,912517,916724,920778,924847,928741,932552,936297,939948,943618,947171,950750,954269,957679,961052,964341,967659,970855,973889,976984,979909,982882,985736,988487,991229,993914,996561,999182,1001667,1004183,1006767,1009216,1011609,1013996,1016383,1018701,1020987,1023215,1025413,1027582,1029722,1031866,1033931,1036047,1038122,1040085,1041992,1043902,
0,34,760,4237,11953,24108,40085,58916,79987,102208,125022,148243,171344,194548,216732,238702,260231,281187,301404,320934,339926,358119,375878,392779,409311,425168,440508,455420,469932,483818,497240,510407,523111,535195,546862,558315,569563,580579,590973,601274,610900,620547,629941,639133,647821,656376,664657,672739,680620,688185,695622,702886,710038,716847,723433,729868,736346,742644,748790,754656,760365,765919,771506,776870,782104,787291,792310,797327,802159,806845,811488,816019,820402,824683,828961,833090,837205,841130,844995,848888,852639,856358,860000,863529,867045,870507,873881,877163,880462,883568,886708,889831,892926,895880,898863,901640,904474,907323,910151,912808,915456,918100,920694,923221,925756,928207,930580,932995,935409,937758,940088,942336,944530,946697,948860,950911,952942,954930,957003,959012,
0,3,224,1561,5294,12306,22186,34915,49570,65903,83157,101275,119689,138089,156786,175447,193844,212187,229943,247276,264067,280510,296572,312007,327119,341750,356023,370027,383656,396717,409549,422038,434193,445751,457125,468126,478760,488911,499065,508895,518409,527898,536880,545667,554250,562625,570809,578786,586607,594025,601551,608701,615784,622696,629246,635718,642034,648348,654365,660467,666319,671973,677582,683059,688367,693482,698558,703489,708361,713155,717874,722456,726845,731196,735541,739845,743881,747984,751958,755844,759682,763341,767001,770588,774252,777681,781045,784451,787654,790782,794025,797146,800260,803372,806385,809381,812245,815052,817824,820575,823247,825888,828525,831072,833597,836033,838494,840976,843335,845716,848034,850308,852543,854709,856925,859143,861152,863236,865228,867298,
0,0,38,453,1856,4983,10035,17168,26473,37156,48930,62111,75766,89887,104549,119488,134348,149036,163683,178050,192557,206892,220848,234627,248014,261240,274093,286457,298783,310599,322182,333305,344237,354918,365487,375740,385635,395271,404621,413837,423024,431827,440390,448792,456845,464833,472532,480157,487502,494654,501804,508875,515568,522229,528717,535107,541216,547229,553244,559061,564869,570399,575809,581111,586350,591474,596373,601377,606379,611049,615720,620309,624742,629224,633480,637770,641938,645989,649946,653896,657851,661505,665200,668840,672429,675861,679316,682603,685905,689121,692302,695398,698567,701534,704679,707707,710645,713575,716383,719158,721903,724741,727357,729977,732578,735136,737627,740025,742418,744782,747094,749365,751656,753929,756109,758287,760430,762494,764525,766574,
0,0,5,94,468,1566,3788,7227,11931,17831,24859,33084,41947,51747,61809,72271,83168,94191,105220,116546,127997,139024,150302,161686,172624,183546,194450,205002,215467,225673,235623,245536,255230,264583,273821,282907,291735,300374,308775,317079,325351,333415,341240,348853,356330,363769,371097,378230,385228,391964,398593,405057,411488,417780,423960,429998,435918,441723,447520,453111,458625,463956,469314,474365,479495,484507,489234,493934,498591,503099,507636,512091,516350,520580,524678,528765,532825,536752,540711,544579,548375,551995,555560,559116,562610,566115,569543,572904,576195,579427,582636,585844,588919,591929,594944,597928,600816,603700,606505,609341,612089,614897,617427,619901,622523,625036,627544,630114,632544,634920,637274,639604,641911,644120,646256,648411,650555,652650,654705,656740,
0,0,1,9,79,317,907,2046,3943,6463,9833,14078,18965,24315,30302,36726,43653,50762,58404,66236,74144,82274,90545,98716,106905,115357,123660,131886,140059,148269,156421,164545,172468,180254,187880,195611,202998,210301,217543,224744,231830,238729,245517,252331,259104,265582,271725,278050,284059,290123,296091,301820,307566,313089,318471,323912,329283,334403,339509,344538,349599,354485,359339,364141,368829,373502,378025,382422,386777,391134,395309,399539,403537,407552,411504,415239,419045,422778,426488,430103,433697,437172,440588,444017,447441,450783,453996,457227,460380,463560,466620,469609,472583,475527,478343,481167,483953,486767,489536,492227,494897,497482,499996,502542,504997,507513,509939,512327,514663,516983,519340,521555,523825,526020,528286,530427,532576,534630,536737,538702,
0,0,0,0,11,43,174,514,1096,2037,3401,5247,7565,10373,13568,17228,21220,25574,30171,35060,40342,45709,51189,56799,62590,68583,74580,80693,86701,92753,98837,104926,111192,117220,123278,129203,135137,141060,146860,152665,158354,164101,169837,175384,180962,186553,191952,197174,202431,207632,212785,217748,222686,227533,232378,237143,241831,246382,251027,255479,259980,264172,268465,272772,276952,281056,285144,289051,292919,296783,300542,304412,308064,311763,315318,318903,322329,325834,329133,332482,335764,339001,342268,345438,348542,351638,354653,357650,360560,363501,366378,369163,371942,374707,377407,380107,382650,385339,387902,390476,392998,395480,397907,400333,402723,405046,407339,409656,411913,414067,416326,418432,420571,422718,424842,426870,428948,430883,432903,434912,
0,0,0,0,0,6,25,69,181,391,741,1275,1993,2997,4261,5800,7648,9599,11796,14280,16863,19701,22799,26082,29479,33162,36791,40596,44452,48385,52338,56395,60544,64713,68994,73201,77421,81697,86077,90368,94674,98942,103292,107496,111705,115855,119985,124097,128181,132226,136139,140178,144043,147988,151911,155896,159705,163468,167227,170979,174592,178155,181745,185356,188812,192226,195566,198968,202363,205730,208933,212187,215365,218457,221605,224681,227764,230699,233732,236736,239594,242418,245145,247890,250649,253359,255928,258530,261162,263672,266210,268673,271121,273629,276052,278415,280757,283076,285432,287683,289920,292196,294393,296547,298630,300710,302935,304999,307003,308995,310983,313005,315020,316931,318856,320814,322665,324464,326236,328056,
0,0,0,0,0,0,2,5,14,33,72,165,304,518,811,1222,1724,2299,3046,3908,4900,5953,7098,8423,9885,11406,13145,14863,16737,18704,20741,22855,25055,27308,29609,31912,34363,36854,39275,41778,44357,46972,49652,52315,54894,57637,60213,62936,65625,68289,71096,73736,76427,79073,81745,84494,87159,89791,92473,95098,97761,100415,102945,105494,108059,110651,113165,115698,118231,120690,123146,125652,128125,130561,133055,135404,137778,140134,142397,144658,146981,149247,151435,153598,155826,158063,160206,162432,164571,166684,168736,170785,172823,174824,176848,178802,180700,182571,184439,186380,188135,189922,191761,193676,195567,197341,199057,200760,202486,204223,205910,207666,209310,210945,212583,214214,215879,217425,218997,220500,
0,0,0,0,0,0,0,0,0,0,0,3,11,22,44,78,130,193,296,413,576,772,995,1303,1637,1985,2399,2836,3349,3917,4559,5225,5930,6737,7542,8439,9288,10252,11202,12223,13288,14359,15452,16567,17712,18895,20105,21301,22550,23904,25241,26538,27871,29260,30561,31956,33390,34828,36211,37650,39116,40601,42113,43591,45097,46573,48040,49515,50996,52522,54003,55496,56952,58410,59889,61396,62851,64240,65669,67171,68568,70034,71449,72914,74346,75730,77144,78563,79989,81464,82834,84278,85653,87047,88400,89706,91106,92427,93745,95084,96402,97673,98994,100246,101576,102835,104115,105333,106608,107890,109133,110400,111612,112793,114054,115298,116441,117603,118789,119924,
99065,354605,566680,726435,849396,947391,1027932,1094876,1151822,1200641,1243077,1280938,1314820,1344721,1371533,1395911,1418448,1439213,1458274,1475864,1492325,1507917,1522236,1535420,1548020,1559813,1570804,1581449,1591313,1600868,1609745,1618286,1626451,1634089,1641537,1648589,1655328,1661878,1668034,1674038,1679832,1685333,1690659,1695934,1700879,1705681,1710088,1714455,1718670,1722802,1726826,1730802,1734516,1738162,1741639,1745267,1748667,1751935,1755008,1758061,1761033,1763944,1766678,1769419,1772128,1774715,1777183,1779705,1782078,1784370,1786706,1788968,1791191,1793351,1795416,1797451,1799497,1801489,1803431,1805389,1807181,1808991,1810707,1812394,1814049,1815732,1817365,1818928,1820496,1822008,1823531,1824960,1826413,1827823,1829246,1830600,1831886,1833198,1834433,1835690,1836912,1838099,1839348,1840471,1841601,1842715,1843821,1844947,1846047,1847121,1848165,1849200,1850169,1851166,1852163,1853164,1854103,1855053,1855994,1856894,
32326,189938,361516,506317,625165,723311,805974,876327,936781,989599,1035666,1077072,1113951,1147292,1177124,1204509,1229913,1253282,1274880,1295109,1313570,1330735,1347179,1362569,1376816,1390428,1403188,1415251,1426727,1437572,1447624,1457433,1466643,1475705,1484357,1492610,1500560,1507939,1515038,1522143,1528705,1535128,1541264,1547172,1552920,1558390,1563704,1568844,1573818,1578660,1583269,1587845,1592185,1596513,1600570,1604577,1608433,1612199,1615817,1619427,1622878,1626309,1629567,1632843,1635929,1639018,1641902,1644961,1647789,1650569,1653244,1655896,1658511,1660957,1663430,1665837,1668189,1670559,1672840,1675099,1677163,1679285,1681288,1683251,1685220,1687158,1688981,1690784,1692604,1694346,1696110,1697827,1699533,1701252,1702832,1704456,1706000,1707541,1709044,1710513,1711982,1713374,1714782,1716160,1717498,1718828,1720177,1721443,1722734,1723974,1725224,1726379,1727573,1728775,1729937,1731070,1732189,1733269,1734362,1735432,
13594,118258,257883,386767,497986,592801,673587,743867,805446,859167,907179,950014,988222,1022804,1054498,1083613,1109960,1134341,1157263,1178785,1198244,1216854,1234329,1250819,1266115,1280744,1294263,1307231,1319681,1331259,1342278,1352911,1363010,1372443,1381612,1390544,1398938,1407082,1414958,1422343,1429563,1436460,1443162,1449614,1455863,1461933,1467702,1473317,1478761,1484138,1489184,1494160,1499123,1503657,1508075,1512372,1516665,1520774,1524857,1528773,1532563,1536265,1539798,1543308,1546709,1550015,1553312,1556540,1559657,1562677,1565739,1568696,1571443,1574285,1576926,1579597,1582207,1584694,1587231,1589654,1591992,1594328,1596674,1598758,1600871,1602982,1605054,1607015,1609030,1610936,1612870,1614724,1616511,1618325,1620135,1621875,1623610,1625308,1626922,1628546,1630196,1631655,1633232,1634787,1636251,1637686,1639098,1640501,1641897,1643272,1644657,1645998,1647276,1648563,1649809,1651042,1652241,1653447,1654660,1655858,
4024,60509,160867,265834,363962,450326,527253,595204,655450,709571,757818,801208,840368,876275,909178,939404,967361,992902,1016969,1039344,1060499,1080101,1098833,1116283,1132697,1148475,1163135,1176955,1190039,1202596,1214617,1225952,1237035,1247555,1257448,1267162,1276354,1285221,1293628,1301710,1309523,1316983,1324400,1331453,1338330,1344706,1351052,1357251,1363291,1369081,1374574,1380004,1385257,1390472,1395370,1400133,1404751,1409192,1413670,1417770,1421971,1425993,1429919,1433687,1437381,1441080,1444615,1448167,1451551,1454816,1458066,1461183,1464209,1467149,1470193,1473061,1475859,1478549,1481303,1483939,1486542,1489046,1491553,1493916,1496317,1498684,1500918,1503098,1505292,1507426,1509511,1511663,1513697,1515651,1517641,1519561,1521423,1523334,1525134,1526933,1528637,1530397,1532108,1533771,1535397,1536940,1538507,1540111,1541667,1543161,1544667,1546051,1547510,1548867,1550330,1551722,1553084,1554380,1555723,1557050,
645,22803,80309,153761,229541,302230,369222,430720,486839,538027,584740,627891,666937,702827,736330,767074,795598,821967,846777,870334,892079,912833,932347,950685,968384,984979,1000621,1015692,1029726,1043129,1055671,1067922,1079855,1090981,1101755,1112174,1122194,1131705,1141025,1149990,1158508,1166689,1174742,1182342,1189639,1196713,1203722,1210397,1216951,1223163,1229294,1235213,1240935,1246649,1252032,1257258,1262405,1267339,1272224,1276950,1281428,1285878,1290186,1294365,1298530,1302606,1306529,1310460,1314174,1317889,1321379,1324858,1328223,1331610,1334901,1338083,1341263,1344254,1347343,1350159,1353048,1355882,1358656,1361350,1363955,1366574,1369241,1371713,1374122,1376445,1378839,1381141,1383402,1385595,1387826,1389917,1392065,1394206,1396194,1398141,1400049,1402027,1403930,1405874,1407693,1409488,1411231,1412908,1414588,1416217,1417869,1419525,1421111,1422635,1424196,1425754,1427193,1428741,1430241,1431681,
191,11364,49606,105629,167966,230475,290674,346929,399080,447577,492289,533476,571298,606607,639586,670249,698554,725240,750210,773345,795547,816275,836126,854903,872912,889937,905785,920990,935658,949467,962680,975399,987499,999208,1010463,1021192,1031648,1041748,1051278,1060436,1069295,1077559,1085840,1093786,1101395,1108917,1116046,1122994,1129841,1136430,1142781,1149026,1155153,1161048,1166817,1172295,1177745,1183008,1188176,1192963,1197646,1202359,1206910,1211299,1215628,1219803,1223855,1227959,1231931,1235817,1239548,1243274,1246821,1250369,1253777,1257176,1260378,1263496,1266683,1269686,1272771,1275772,1278673,1281452,1284288,1287062,1289734,1292381,1295015,1297527,1300016,1302401,1304748,1307054,1309358,1311522,1313757,1315942,1318174,1320262,1322369,1324410,1326403,1328502,1330467,1332346,1334176,1336018,1337784,1339488,1341191,1342899,1344579,1346258,1347889,1349485,1351039,1352572,1354161,1355683,
35,4737,26812,64859,112324,163152,213998,263060,310497,354639,395707,434342,470416,504261,535994,565535,593223,619228,643974,667404,689625,710656,730360,749103,767115,784088,800337,815871,830698,844815,858246,871361,883826,895586,907147,918258,928818,939260,949236,958691,967608,976435,984944,993222,1001141,1008812,1016306,1023490,1030693,1037555,1044202,1050723,1057012,1063095,1069192,1074991,1080579,1085999,1091367,1096576,1101585,1106564,1111293,1115783,1120361,1124791,1129007,1133316,1137468,1141529,1145430,1149320,1153064,1156688,1160274,1163795,1167206,1170627,1173946,1177167,1180355,1183478,1186614,1189672,1192540,1195424,1198266,1200979,1203649,1206362,1208942,1211527,1214033,1216456,1218919,1221307,1223661,1225953,1228258,1230517,1232628,1234724,1236792,1238894,1240915,1243021,1245036,1247004,1248854,1250729,1252563,1254416,1256248,1258048,1259800,1261555,1263211,1264893,1266570,1268129,
5,1515,11836,34395,66475,104021,143823,183771,223055,261520,298312,333050,366246,397378,426884,454856,481207,506598,530706,553386,574716,595109,614603,633221,650987,667860,684184,699650,714468,728463,742224,755240,767909,779822,791374,802607,813561,824204,834367,844018,853382,862380,871289,879697,888203,896227,903721,911218,918591,925721,932605,939203,945701,952046,958248,964347,970191,975854,981417,986862,992081,997182,1002189,1007070,1011698,1016444,1021084,1025486,1029804,1033965,1038122,1042153,1046115,1049953,1053669,1057373,1060948,1064460,1067858,1071273,1074595,1077844,1081092,1084275,1087325,1090405,1093442,1096360,1099308,1102132,1104968,1107734,1110354,1112969,1115504,1118084,1120562,1123012,1125433,1127775,1130074,1132394,1134560,1136747,1138935,1141029,1143114,1145194,1147223,1149223,1151202,1153021,1154913,1156827,1158702,1160529,1162276,1164048,1165787,1167471,
0,298,3942,14793,33016,57072,84443,114347,144621,175073,205313,234595,262693,289970,316102,341215,365665,388728,411141,432264,452786,472123,490807,508523,525410,541727,557569,572683,587182,601160,614628,627429,639864,651747,663489,674868,685773,696390,706668,716445,726103,735238,743962,752632,761025,769301,777161,784892,792407,799717,806813,813609,820243,826663,832964,839100,845294,851157,856763,862323,867741,873021,878156,883137,888021,892852,897530,902129,906596,910926,915206,919378,923536,927531,931450,935260,939074,942627,946401,949983,953431,956740,960138,963501,966694,969989,973174,976222,979427,982399,985241,988109,990940,993656,996344,998959,1001556,1004074,1006582,1009123,1011469,1013860,1016232,1018507,1020802,1023018,1025268,1027522,1029598,1031709,1033736,1035874,1037877,1039900,1041817,1043754,1045643,1047486,1049402,1051282,
0,88,1596,7404,18946,35406,55914,78745,103065,128219,153748,178986,203727,228039,251657,274379,296581,318073,338821,358485,377616,395601,413281,430378,446579,462314,477646,492234,506178,519727,532708,545358,557544,569387,580601,591805,602719,613123,623228,633032,642374,651736,660624,669418,677923,686159,694067,701879,709338,716576,723627,730498,737213,743890,750301,756484,762572,768511,774344,780054,785487,790832,796030,801158,806186,811149,815867,820523,825001,829341,833697,837983,842102,846309,850351,854178,858125,861962,865640,869336,872851,876269,879760,883137,886442,889658,892789,895885,898912,901895,904808,907765,910632,913424,916230,918909,921695,924375,926995,929523,932083,934567,937082,939456,941816,944083,946377,948593,950793,953044,955122,957218,959310,961325,963340,965314,967218,969175,971095,972923,
0,16,545,3234,9445,19650,33143,49335,67401,86973,107356,128061,148713,169138,189653,209723,228956,248158,266638,284645,301987,318913,335124,350896,366037,380834,395146,408912,422297,435177,447874,460189,471762,483064,494010,504703,515112,525225,535291,544938,554168,563233,571960,580369,588693,596678,604723,612318,619707,626847,633964,640820,647497,654014,660333,666515,672493,678545,684351,690113,695638,700926,706065,711092,716159,721160,725903,730576,735195,739730,744234,748600,752814,757093,761303,765339,769239,773009,776851,780577,784028,787466,790884,794358,797767,801133,804509,807677,810733,813822,816860,819823,822679,825588,828318,831124,833883,836616,839331,841939,844462,846928,849446,851838,854168,856538,858913,861230,863470,865716,867859,869932,872087,874189,876190,878263,880166,882114,884056,886011,
0,1,133,1054,3827,9130,17036,27392,39384,53029,67853,83485,99651,115895,132433,149020,165523,181666,197308,212863,228138,242908,257588,271725,285684,299162,312202,325019,337321,349494,361158,372415,383367,394147,404533,414753,424526,434145,443485,452622,461369,470000,478505,486832,494748,502401,509856,517290,524423,531525,538463,545282,551760,558228,564431,570554,576548,582386,588059,593708,599118,604531,609844,614939,619894,624706,629446,634119,638709,643294,647762,652361,656681,660887,664876,668976,672916,676904,680761,684422,688006,691586,695111,698564,702023,705248,708517,711708,714861,717909,721041,723976,726952,729771,732626,735426,738255,740976,743678,746325,748950,751477,753965,756472,758913,761357,763726,766028,768270,770565,772824,775042,777184,779318,781391,783420,785403,787346,789298,791279,
0,0,22,261,1207,3288,7070,12500,19483,27824,37509,47831,59060,70959,83200,95663,108353,120977,133616,146112,158455,170802,182760,194708,206471,218196,229526,240672,251521,262091,272402,282526,292485,302249,311668,321064,330109,338862,347258,355650,363798,371829,379883,387472,394976,402277,409623,416614,423678,430303,436795,443252,449600,455774,461796,467636,473488,479265,484817,490204,495463,500602,505708,510773,515695,520501,525180,529782,534287,538603,542943,547199,551339,555559,559592,563657,567549,571373,575067,578676,582430,586090,589585,593085,596418,599764,602929,606123,609273,612393,615405,618523,621520,624413,627304,630084,632907,635613,638270,640920,643413,645989,648502,651007,653422,655784,658200,660536,662802,665117,667424,669605,671767,673876,676037,678093,680125,682076,683990,685943,
0,0,2,30,223,798,2037,4213,7363,11522,16762,22616,29370,36672,44589,52801,61292,70070,79138,88379,97744,107049,116261,125510,134835,144103,153166,162207,170973,179916,188636,197069,205674,214106,222322,230484,238255,245901,253450,260869,268221,275399,282353,289151,295866,302359,308800,315088,321334,327452,333593,339587,345250,350985,356524,361968,367263,372480,377678,382810,387833,392596,397465,402165,406722,411355,415864,420213,424543,428751,432875,437131,441273,445149,449000,452738,456490,460016,463621,467223,470676,474059,477534,480912,484103,487355,490541,493615,496711,499744,502655,505657,508646,511518,514331,517047,519746,522348,525001,527582,530224,532761,535189,537643,540110,542477,544791,547142,549396,551669,553820,556028,558198,560246,562282,564324,566403,568409,570334,572394,
0,0,1,4,27,178,552,1245,2452,4181,6497,9509,12977,17044,21629,26590,31960,37614,43632,49874,56356,62960,69791,76590,83508,90476,97446,104499,111351,118352,125292,132191,139044,145726,152327,158971,165535,171988,178452,184703,190956,196951,202946,208784,214597,220266,225943,231455,236648,242024,247453,252690,257819,262871,267831,272766,277635,282353,287015,291525,296105,300527,304893,309170,313412,317603,321685,325727,329734,333483,337294,341048,344652,348303,351981,355556,358985,362414,365829,369076,372333,375626,378880,381980,385114,388212,391021,393982,396973,399979,402840,405576,408335,411093,413683,416248,418872,421389,423925,426384,428886,431289,433681,436076,438387,440661,442965,445237,447513,449748,451945,454086,456130,458131,460187,462211,464272,466229,468253,470205,
0,0,0,0,4,22,81,225,498,995,1730,2800,4155,5857,7885,10262,12876,15797,18968,22406,26124,30123,34175,38429,42768,47284,51760,56448,61063,65929,70713,75663,80539,85469,90407,95225,100080,104989,109882,114765,119470,124306,128986,133532,138115,142700,147242,151767,156352,160634,164918,169064,173206,177429,181563,185751,189759,193765,197866,201763,205719,209473,213223,216917,220454,224086,227602,231214,234728,238204,241600,244943,248192,251380,254615,257717,260786,263799,266789,269764,272752,275685,278587,281469,284237,286911,289662,292344,294929,297581,300188,302649,305208,307584,310031,312530,314916,317217,319591,321740,324032,326360,328652,330773,332874,335030,337178,339192,341256,343202,345204,347257,349224,351176,353052,354948,356899,358717,360525,362335,
0,0,0,0,0,0,4,17,55,110,224,417,715,1152,1753,2513,3374,4396,5558,6939,8488,10097,11911,13818,15955,18150,20488,22880,25519,28145,30829,33580,36453,39331,42318,45269,48246,51191,54269,57415,60537,63542,66649,69797,72784,75970,79120,82212,85259,88425,91489,94483,97555,100583,103467,106523,109522,112431,115424,118338,121249,124080,126955,129815,132624,135405,138240,141047,143761,146467,149122,151786,154366,156908,159397,161860,164385,166898,169368,171761,174248,176561,178885,181208,183529,185876,188112,190412,192660,194838,196981,199012,201122,203124,205270,207268,209268,211303,213286,215337,217185,219103,221064,222926,224766,226570,228394,230207,232034,233784,235494,237265,238952,240637,242323,243975,245621,247269,248839,250414,
0,0,0,0,0,0,0,1,1,4,6,17,36,66,111,200,326,483,672,913,1199,1562,2016,2500,2993,3615,4255,4971,5864,6700,7596,8572,9645,10738,11849,12993,14216,15498,16820,18129,19568,20943,22444,23917,25408,26891,28463,30074,31719,33419,35003,36632,38278,39889,41592,43224,44901,46668,48328,50014,51682,53369,55066,56720,58451,60236,62012,63752,65453,67169,68889,70518,72156,73775,75417,77115,78738,80407,81990,83619,85301,86939,88582,90108,91661,93316,94874,96405,97917,99445,101005,102476,104014,105493,106965,108393,109800,111264,112700,114059,115474,116867,118225,119612,120992,122318,123692,125059,126397,127746,129076,130413,131744,133092,134365,135603,136855,138110,139398,140574,
109760,370272,580630,736201,855937,950794,1028400,1093186,1148083,1195413,1236239,1272494,1304538,1333496,1359558,1383140,1404825,1424826,1443198,1460283,1476165,1490987,1504828,1517686,1529722,1541092,1551836,1561939,1571505,1580673,1589255,1597624,1605293,1612880,1620158,1627023,1633480,1639668,1645671,1651400,1656850,1662237,1667407,1672292,1677214,1681793,1686213,1690465,1694624,1698671,1702585,1706329,1709988,1713601,1717054,1720434,1723717,1726961,1730012,1732971,1735910,1738696,1741411,1744089,1746610,1749182,1751631,1754082,1756418,1758766,1761037,1763272,1765344,1767451,1769464,1771471,1773428,1775341,1777251,1779145,1780954,1782684,1784312,1785966,1787591,1789215,1790784,1792250,1793820,1795279,1796786,1798219,1799633,1801101,1802441,1803770,1805064,1806323,1807501,1808740,1809956,1811117,1812282,1813425,1814526,1815596,1816682,1817771,1818796,1819851,1820847,1821848,1822852,1823847,1824758,1825679,1826640,1827607,1828502,1829433,
38938,207354,381048,524532,640731,736211,815934,884129,942661,993466,1037886,1077453,1112714,1144628,1173339,1199758,1224032,1246360,1266980,1285978,1303885,1320717,1336132,1350741,1364451,1377375,1389606,1401512,1412432,1422939,1432664,1442147,1451146,1459680,1467907,1475823,1483567,1490727,1497628,1504138,1510446,1516573,1522485,1528212,1533805,1539186,1544265,1549264,1554112,1558752,1563127,1567449,1571637,1575810,1579829,1583592,1587434,1591086,1594567,1598091,1601475,1604710,1607892,1610920,1613954,1616849,1619794,1622592,1625253,1627977,1630576,1633097,1635624,1638127,1640486,1642790,1645089,1647371,1649600,1651706,1653800,1655848,1657786,1659775,1661669,1663529,1665387,1667073,1668849,1670560,1672304,1673971,1675557,1677149,1678803,1680341,1681906,1683426,1684868,1686288,1687766,1689120,1690412,1691770,1693019,1694285,1695582,1696878,1698166,1699358,1700588,1701770,1702943,1704081,1705253,1706319,1707472,1708607,1709690,1710773,
17766,133331,278034,407522,517446,610379,689399,757317,816439,868570,914726,955804,992369,1025891,1055814,1083699,1109326,1132728,1154705,1175125,1193898,1211707,1228298,1243913,1258452,1272421,1285571,1298305,1310190,1321306,1331985,1342136,1351842,1360860,1369699,1378152,1386222,1394079,1401337,1408487,1415402,1422108,1428519,1434741,1440675,1446488,1452143,1457552,1462724,1467797,1472644,1477428,1482064,1486591,1490976,1495126,1499307,1503350,1507160,1510859,1514503,1518001,1521439,1524877,1528107,1531231,1534311,1537446,1540377,1543241,1546066,1548806,1551522,1554243,1556776,1559209,1561728,1564181,1566598,1568906,1571167,1573463,1575611,1577747,1579691,1581802,1583795,1585643,1587609,1589534,1591393,1593180,1594900,1596632,1598312,1599988,1601674,1603300,1604904,1606481,1608038,1609550,1611029,1612498,1613950,1615363,1616753,1618080,1619470,1620777,1622121,1623404,1624686,1625951,1627197,1628407,1629597,1630690,1631875,1633045,
5800,72601,180071,288490,386104,472539,548326,614340,672947,724942,771425,813320,851524,886224,917871,946686,973588,998199,1021148,1042417,1062620,1081301,1098847,1115560,1131158,1146191,1160081,1173519,1186002,1198082,1209703,1220470,1230959,1240798,1250331,1259428,1268384,1276821,1284797,1292588,1300160,1307306,1314113,1320863,1327372,1333584,1339577,1345416,1351128,1356610,1361947,1367036,1372042,1377078,1381790,1386293,1390680,1395066,1399361,1403426,1407495,1411336,1415189,1418880,1422499,1426002,1429286,1432631,1435927,1439074,1442162,1445167,1448083,1450893,1453802,1456513,1459117,1461824,1464458,1466972,1469397,1471902,1474294,1476657,1478861,1481179,1483397,1485501,1487639,1489726,1491774,1493782,1495694,1497529,1499390,1501295,1503130,1504999,1506747,1508495,1510169,1511836,1513468,1515067,1516680,1518164,1519675,1521164,1522661,1524074,1525577,1526969,1528394,1529720,1531086,1532395,1533720,1535042,1536269,1537526,
1134,29678,95406,174404,253468,328047,395275,455711,511220,561507,607124,648712,686475,720929,753201,782783,810204,835650,859368,881841,903083,922967,941486,959044,975782,991667,1006683,1020891,1034289,1047034,1059101,1070773,1082115,1092659,1102941,1112934,1122490,1131487,1140215,1148658,1156762,1164468,1171889,1179318,1186211,1193066,1199740,1206067,1212360,1218304,1224123,1229696,1235182,1240565,1245772,1250734,1255513,1260207,1264615,1269134,1273524,1277826,1281932,1285946,1290005,1293937,1297625,1301253,1304808,1308315,1311810,1315088,1318373,1321610,1324653,1327642,1330625,1333529,1336314,1339007,1341731,1344405,1347094,1349677,1352275,1354723,1357304,1359671,1362029,1364326,1366647,1368823,1370995,1373124,1375287,1377301,1379333,1381380,1383263,1385166,1387026,1388889,1390714,1392533,1394353,1396085,1397720,1399442,1401051,1402652,1404225,1405741,1407289,1408824,1410286,1411748,1413230,1414633,1416062,1417482,
349,15937,61763,124121,190587,255570,316982,373356,425468,473579,517265,557593,594843,628831,660804,690573,717920,743464,767249,789780,811071,831140,850227,868207,885258,901333,916628,931075,945101,958252,970823,983102,994623,1005647,1016260,1026432,1036306,1045915,1055069,1063880,1072228,1080272,1088087,1095582,1102909,1110146,1116914,1123571,1130000,1136147,1142328,1148142,1153922,1159456,1164882,1170257,1175384,1180343,1185258,1189862,1194431,1198969,1203250,1207358,1211580,1215600,1219532,1223421,1227126,1230787,1234363,1237897,1241256,1244626,1247908,1251150,1254259,1257326,1260312,1263231,1266032,1268898,1271677,1274301,1276986,1279573,1282197,1284712,1287119,1289517,1291903,1294219,1296426,1298682,1300882,1303027,1305174,1307310,1309447,1311446,1313421,1315358,1317231,1319126,1320914,1322712,1324514,1326298,1328022,1329708,1331353,1332924,1334550,1336201,1337784,1339284,1340830,1342400,1343907,1345346,
69,7546,35639,80292,132696,186816,240001,290455,337763,382151,423261,461186,497145,530357,561586,590290,617136,642499,666423,689034,710365,730438,749362,767361,784351,800890,816501,831177,845314,858996,871873,884370,896314,907761,918745,929174,939372,949156,958668,967669,976357,984777,992994,1000758,1008470,1015667,1022715,1029670,1036428,1042959,1049327,1055430,1061526,1067230,1072958,1078476,1083854,1089014,1094022,1098957,1103711,1108400,1112867,1117348,1121736,1125901,1129935,1134000,1137910,1141801,1145608,1149235,1152886,1156378,1159750,1163150,1166513,1169732,1172940,1176011,1179024,1182005,1184891,1187745,1190463,1193233,1196016,1198720,1201313,1203872,1206305,1208691,1211058,1213402,1215670,1217943,1220094,1222290,1224490,1226590,1228742,1230791,1232815,1234839,1236774,1238696,1240594,1242458,1244275,1246044,1247837,1249537,1251237,1252975,1254622,1256289,1257930,1259562,1261115,1262640,
14,2615,17467,45667,82874,124603,167531,209923,251234,290805,327947,362919,395984,426979,456128,484053,510070,534696,558104,580140,600652,620515,639282,657095,674169,690368,706050,720758,734964,748733,761976,774239,786364,797786,808942,819766,830180,840207,849901,859187,868173,876857,885448,893461,901362,908931,916350,923419,930435,937165,943790,950186,956309,962342,968202,973966,979638,984979,990238,995350,1000306,1005210,1010020,1014577,1019152,1023557,1027836,1032077,1036129,1040184,1044129,1048062,1051812,1055470,1059047,1062552,1065965,1069317,1072661,1075818,1079040,1082082,1085184,1088159,1091114,1094090,1096972,1099848,1102609,1105303,1107959,1110524,1113013,1115513,1117925,1120438,1122766,1125089,1127392,1129636,1131844,1134018,1136130,1138205,1140332,1142388,1144395,1146368,1148291,1150158,1151969,1153780,1155601,1157331,1159106,1160835,1162533,1164257,1165832,1167442,
0,623,6479,21079,44048,72494,103661,136282,169157,201579,232877,263404,292201,319943,346404,371887,396163,419270,441222,462298,482172,501293,519449,536783,553378,569266,584514,599202,613367,626806,639895,652193,664399,676016,687178,697995,708553,718644,728330,737646,746770,755539,764121,772408,780438,788366,795920,803212,810479,817417,824166,830634,837176,843241,849254,855140,860946,866640,872057,877244,882382,887433,892405,897321,901936,906491,910995,915346,919524,923648,927728,931669,935614,939479,943198,946885,950436,954016,957538,960982,964369,967674,970847,973997,977071,980109,983094,986032,988968,991804,994590,997261,999949,1002507,1005070,1007586,1010057,1012567,1014957,1017372,1019597,1021800,1023994,1026154,1028304,1030378,1032559,1034597,1036674,1038728,1040635,1042581,1044501,1046454,1048295,1050079,1051862,1053681,1055445,1057201,
0,205,2997,11703,26973,47210,71346,97511,124745,152377,179543,206532,232414,257507,281759,305112,327521,349281,369895,389603,408373,426498,443986,460477,476413,491682,506626,520816,534646,547818,560558,572850,584886,596404,607488,618059,628430,638527,648307,657657,666523,675425,684125,692442,700484,708225,715946,723233,730528,737510,744286,750848,757351,763576,769808,775822,781636,787168,792695,798170,803483,808630,813600,818461,823194,827874,832532,836914,841289,845517,849628,853845,857907,861826,865621,869372,873090,876773,880266,883646,887065,890390,893658,896832,900041,903135,906221,909226,912213,915136,918070,920811,923480,926202,928815,931376,933894,936544,939002,941428,943777,946128,948489,950787,953065,955239,957384,959495,961602,963742,965664,967721,969709,971646,973623,975575,977463,979308,981107,982803,
0,58,1128,5471,14385,27749,44861,64443,85570,107492,130058,152495,174729,196678,217960,238744,258728,278315,297364,315735,333484,350339,366747,382465,397664,412457,426757,440447,453691,466468,478708,490634,502333,513441,524358,534688,544770,554817,564424,573640,582402,591100,599583,607844,615840,623650,631197,638695,645862,652665,659467,666100,672584,678915,685160,691117,696878,702658,708181,713722,718926,724110,729233,734172,738905,743581,748180,752766,757129,761399,765674,769789,773863,777806,781764,785635,789392,793047,796698,800260,803720,807115,810372,813565,816787,820036,823327,826378,829351,832196,835082,837958,840734,843501,846196,848849,851423,854038,856513,858990,861438,863805,866141,868438,870720,872961,875153,877315,879554,881689,883793,885861,887841,889750,891698,893646,895551,897428,899213,901069,
0,16,360,2109,6622,14219,24897,38046,52859,69038,86534,104093,121857,139893,157715,175534,192752,209789,226573,242933,258758,274147,288943,303430,317552,330901,344077,357068,369380,381226,392850,404124,415242,425903,436208,446314,456042,465445,474565,483609,492392,500847,509181,517325,525025,532563,539929,547176,554175,561024,567651,574194,580584,586750,592812,598729,604477,610037,615523,621011,626317,631484,636563,641603,646401,651068,655741,660220,664711,669057,673439,677692,681794,685797,689676,693553,697343,701137,704795,708368,711847,715291,718594,721873,725184,728394,731450,734524,737643,740610,743675,746539,749358,752011,754700,757367,760011,762566,765161,767658,770192,772612,775022,777309,779652,782032,784345,786622,788893,791039,793289,795309,797384,799427,801460,803407,805363,807206,809145,810983,
0,0,66,578,2272,5759,11246,18869,28102,38748,50423,63136,76224,89805,103576,117391,131288,145042,158862,172522,185734,198813,211553,224040,236397,248532,260387,271912,282916,293697,304290,314696,324795,334677,344300,353614,362706,371599,380155,388507,396685,404812,412678,420450,427791,435016,442193,449098,455818,462383,468686,474966,481129,487113,492997,498845,504513,510006,515371,520591,525812,531016,536134,540953,545708,550283,554779,559183,563577,567924,572123,576340,580446,584525,588395,592233,596015,599682,603388,606966,610329,613827,617237,620523,623745,626862,629973,633074,636123,639029,641929,644802,647695,650596,653448,656089,658766,661363,663934,666485,669060,671592,674066,676471,678857,681140,683369,685559,687782,689994,692135,694370,696455,698534,700540,702604,704629,706533,708471,710293,
0,0,4,92,534,1662,3841,7222,11838,17508,24364,32211,40518,49590,59078,68933,78891,89080,99190,109525,119967,130159,140390,150409,160528,170555,180253,189957,199318,208637,217707,226567,235265,243906,252266,260658,268619,276404,284141,291665,299103,306429,313434,320471,327255,333877,340367,346758,353119,359312,365298,371177,376971,382668,388236,393625,398952,404312,409289,414310,419147,423788,428531,433183,437711,442197,446567,450946,455106,459299,463302,467333,471408,475265,478973,482738,486361,489918,493436,496953,500348,503733,506887,510140,513422,516475,519597,522732,525787,528616,531484,534317,537045,539814,542575,545180,547727,550367,552914,555427,557928,560325,562762,565082,567386,569673,571982,574171,576357,578498,580653,582863,584969,586875,588855,590867,592829,594767,596697,598580,
0,0,1,7,88,422,1103,2402,4408,7154,10681,15054,19874,25220,31158,37308,43951,50986,58227,65672,73268,80900,88464,96135,103885,111688,119530,127061,134577,142170,149661,156839,164110,171397,178350,185404,192278,199087,205683,212118,218592,224924,231165,237502,243708,249700,255464,261148,266732,272268,277785,283065,288299,293495,298508,303566,308364,313162,317773,322440,327083,331459,335915,340156,344316,348467,352575,356495,360366,364223,368017,371779,375586,379246,382931,386420,389863,393347,396582,399867,403146,406419,409542,412536,415636,418599,421487,424479,427329,430095,432754,435370,438083,440829,443517,445976,448481,451033,453546,455992,458382,460780,463182,465523,467827,470096,472279,474513,476680,478797,480916,482900,484956,486924,488938,490881,492890,494808,496722,498662,
0,0,0,1,7,50,185,506,1085,1958,3277,4962,7106,9580,12493,15763,19367,23258,27356,31734,36270,41086,46141,51276,56491,61783,67171,72499,77950,83354,88690,94218,99549,105070,110458,115883,121261,126485,131748,137004,142181,147214,152300,157372,162260,167129,172093,176713,181410,185967,190541,194910,199231,203708,208024,212374,216606,220723,224808,228887,232800,236736,240584,244460,248374,252059,255711,259278,262863,266285,269720,273001,276300,279597,282873,286034,289228,292303,295383,298431,301508,304472,307375,310112,313014,315749,318409,321033,323624,326331,328937,331328,333890,336332,338807,341190,343621,345976,348268,350456,352693,354852,357129,359268,361371,363488,365544,367618,369703,371714,373730,375722,377575,379536,381460,383348,385187,386988,388787,390566,
0,0,0,0,1,2,11,45,119,284,569,954,1521,2281,3251,4362,5712,7282,9047,10941,13093,15387,17748,20242,22998,25835,28670,31743,34830,38009,41334,44616,48029,51497,54920,58382,61944,65503,69081,72638,76175,79660,83225,86751,90212,93678,97254,100748,104156,107532,110911,114304,117624,120960,124161,127377,130730,133907,137029,140226,143354,146412,149524,152526,155455,158485,161429,164343,167208,170017,172827,175608,178281,180970,183683,186456,189129,191733,194249,196716,199202,201597,203992,206369,208735,211038,213367,215658,217905,220064,222308,224442,226645,228756,230869,233025,235060,237131,239281,241228,243222,245136,247095,248941,250822,252706,254555,256386,258133,259900,261661,263409,265149,266919,268575,270227,271886,273509,275069,276685,
0,0,0,0,0,0,0,0,5,10,23,45,100,176,303,460,679,958,1309,1754,2256,2839,3451,4223,4996,5819,6827,7834,8973,10186,11446,12788,14197,15614,17127,18705,20288,21859,23473,25172,26954,28779,30501,32310,34088,35982,37856,39765,41713,43636,45468,47373,49308,51194,53066,55016,56900,58867,60688,62588,64458,66505,68396,70335,72198,74133,76069,77960,79921,81776,83649,85449,87283,89129,90932,92694,94471,96324,98092,99772,101606,103388,105067,106722,108396,110137,111788,113564,115181,116763,118389,120061,121647,123236,124829,126437,128017,129562,131087,132624,134183,135692,137213,138714,140115,141538,142922,144301,145665,147028,148426,149810,151198,152481,153804,155143,156433,157737,158998,160285,
31754,219574,433887,617085,768336,894012,998404,1088111,1164368,1230875,1288882,1340378,1386515,1428036,1465160,1499114,1530332,1558772,1585052,1609260,1631634,1652052,1671183,1689298,1705937,1721527,1736081,1749898,1762852,1775027,1786809,1797795,1808074,1817787,1827273,1836289,1844852,1853012,1860805,1868113,1875188,1881948,1888564,1894742,1900725,1906594,1912055,1917350,1922389,1927253,1931969,1936494,1940925,1945154,1949248,1953161,1956917,1960536,1964200,1967748,1971019,1974216,1977339,1980393,1983308,1986207,1988949,1991724,1994279,1996811,1999235,2001534,2003781,2006015,2008220,2010338,2012431,2014505,2016441,2018384,2020239,2022171,2023890,2025632,2027327,2029011,2030639,2032138,2033651,2035136,2036531,2037954,2039280,2040577,2041941,2043286,2044506,2045725,2046924,2048094,2049275,2050404,2051465,2052524,2053564,2054609,2055585,2056511,2057435,2058390,2059345,2060259,2061152,2061999,2062866,2063693,2064529,2065326,2066123,2066929,
3268,66476,191766,328132,456269,571683,674272,764532,844645,915996,979992,1037310,1088998,1136060,1178862,1218523,1255158,1288473,1319374,1348004,1374959,1399853,1423065,1444807,1465203,1484448,1502681,1519662,1535567,1550840,1565275,1578855,1591723,1604090,1615917,1627153,1638032,1648343,1658112,1667484,1676373,1684933,1693039,1700851,1708341,1715713,1722748,1729651,1736134,1742165,1748321,1754110,1759699,1765064,1770239,1775165,1779823,1784505,1789001,1793405,1797597,1801647,1805739,1809735,1813593,1817176,1820787,1824233,1827594,1830720,1833851,1836909,1839930,1842773,1845603,1848373,1851048,1853641,1856140,1858594,1861008,1863341,1865689,1867921,1870012,1872160,1874276,1876289,1878298,1880263,1882143,1883975,1885693,1887333,1889029,1890772,1892406,1893959,1895594,1897025,1898506,1899941,1901381,1902776,1904164,1905504,1906804,1908008,1909257,1910438,1911620,1912773,1913923,1915068,1916219,1917329,1918453,1919505,1920535,1921505,
434,23454,93505,188805,289968,388436,480732,565361,642384,712543,776570,834798,888054,936934,982014,1023850,1062150,1097757,1131409,1162574,1191587,1218916,1244158,1268356,1290975,1312262,1332287,1351249,1369178,1386219,1402350,1417793,1432189,1445894,1459036,1471743,1483847,1495391,1506569,1517147,1527426,1537074,1546267,1555190,1563730,1572153,1580264,1587904,1595161,1602246,1609000,1615547,1621849,1628087,1634017,1639947,1645510,1650983,1656171,1661256,1666040,1670808,1675434,1680006,1684387,1688505,1692545,1696467,1700384,1704159,1707768,1711320,1714713,1718053,1721343,1724461,1727463,1730531,1733408,1736235,1739007,1741632,1744372,1746907,1749409,1751845,1754213,1756607,1758990,1761215,1763372,1765586,1767683,1769608,1771615,1773486,1775443,1777284,1779153,1780992,1782788,1784518,1786187,1787767,1789300,1790788,1792346,1793877,1795370,1796793,1798168,1799474,1800828,1802109,1803416,1804611,1805841,1807095,1808332,1809548,
14,4374,30436,79789,143003,212786,283781,353138,419514,482573,541442,595908,647325,695459,740191,781911,821048,857774,892398,924878,955448,984360,1011692,1037412,1061517,1084509,1106271,1127035,1146682,1165271,1182911,1199906,1216055,1231662,1246365,1260517,1274137,1287046,1299570,1311361,1322768,1333899,1344540,1354707,1364654,1374147,1383286,1392117,1400646,1408695,1416605,1424306,1431624,1438630,1445629,1452233,1458772,1464922,1471012,1476864,1482616,1488237,1493459,1498690,1503660,1508506,1513202,1517833,1522256,1526566,1530775,1534979,1538921,1542892,1546661,1550374,1553925,1557451,1560959,1564339,1567634,1570883,1573984,1577034,1580013,1582852,1585667,1588369,1591033,1593576,1596084,1598599,1601084,1603544,1605937,1608258,1610485,1612668,1614858,1616992,1619137,1621094,1623082,1625032,1626958,1628825,1630644,1632429,1634190,1635912,1637572,1639190,1640818,1642384,1643917,1645470,1646993,1648444,1649873,1651316,
0,262,4554,18374,43600,77980,117903,161708,207078,252736,297414,341494,384385,425601,464899,502219,537961,572357,604668,635640,665174,693435,720110,745430,770071,793245,815831,837184,857770,877429,896191,914080,931176,947516,963526,978749,993417,1007522,1020994,1034106,1046492,1058559,1070318,1081765,1092738,1103169,1113402,1123293,1132689,1141854,1150667,1159148,1167491,1175468,1183348,1190852,1198063,1205017,1211958,1218717,1225233,1231516,1237524,1243466,1249252,1254831,1260269,1265631,1270913,1275931,1280796,1285577,1290195,1294694,1299177,1303544,1307644,1311677,1315530,1319385,1323179,1326920,1330639,1334164,1337632,1340973,1344311,1347622,1350766,1353913,1357043,1359999,1362895,1365798,1368569,1371177,1373821,1376437,1379054,1381537,1383963,1386393,1388641,1391005,1393298,1395571,1397717,1399786,1401870,1403887,1405829,1407779,1409665,1411609,1413442,1415304,1417119,1418881,1420581,1422258,
0,34,1039,6126,17574,36124,60451,89325,121107,154802,189474,224557,259147,293068,326883,359499,391134,421568,451139,479743,506754,533090,558115,582272,605528,628167,649595,670010,689797,708797,727201,744974,761972,778338,794125,809740,824527,838667,852190,865369,878221,890473,902241,913757,924782,935352,945692,955827,965575,975041,984339,993143,1001755,1010222,1018362,1026252,1033851,1041270,1048688,1055630,1062430,1068920,1075365,1081539,1087769,1093798,1099572,1105233,1110708,1116008,1121157,1126195,1131063,1135970,1140629,1145117,1149595,1153974,1158354,1162410,1166419,1170302,1174211,1178074,1181692,1185445,1188994,1192561,1196085,1199264,1202556,1205750,1208897,1211931,1214956,1217855,1220657,1223519,1226214,1228823,1231455,1233981,1236465,1239026,1241493,1243840,1246205,1248414,1250662,1252859,1255051,1257177,1259198,1261202,1263248,1265187,1267222,1269128,1270957,1272760,
0,2,152,1360,5136,12782,24675,40353,59230,80452,103565,128026,153384,179054,204676,230290,255819,281233,305814,329829,353022,375848,397952,419445,440419,460981,480561,499608,517921,535694,552822,569396,585564,601152,616259,630787,645185,659118,672350,685140,697555,709799,721467,732896,744000,754868,765307,775419,785028,794268,803632,812515,821265,829768,837929,845872,853635,861018,868338,875388,882562,889239,895917,902451,908703,914837,920748,926540,932152,937627,942994,948442,953648,958618,963411,968333,972925,977573,981965,986364,990669,994798,998758,1002745,1006543,1010421,1014218,1017992,1021548,1024964,1028375,1031719,1034956,1038172,1041350,1044495,1047426,1050370,1053286,1056151,1058990,1061719,1064477,1067124,1069711,1072337,1074813,1077325,1079671,1081983,1084277,1086458,1088701,1090880,1093070,1095068,1097094,1099112,1101120,1103056,
0,0,9,187,992,3231,7455,14006,22772,33816,46486,60754,76229,92333,109161,126788,144936,163092,181514,199749,217800,235487,253026,270364,287456,304270,320809,336838,352530,367838,382815,397565,411857,425746,439327,452472,465249,477670,489618,501447,512967,524119,535156,545895,556287,566575,576179,585765,595038,604017,612933,621409,629743,637965,645962,653740,661190,668537,675737,682778,689674,696294,702863,709351,715590,721736,727676,733456,739033,744545,749963,755378,760631,765773,770690,775460,780039,784549,789180,793576,797808,801893,805979,810066,813990,817822,821653,825553,829223,832777,836119,839691,843072,846362,849651,852843,855899,858887,862007,865003,867857,870582,873338,876041,878673,881341,883840,886412,888910,891333,893684,895990,898240,900404,902585,904744,906941,909016,911129,913186,
0,0,0,7,99,493,1416,3221,6076,10124,15452,21901,29393,37750,47151,57206,67968,79101,90529,102413,114604,126820,139242,151710,164200,176582,188656,200837,213102,224989,236700,248408,259735,270945,282058,292828,303246,313652,323715,333447,343148,352694,362120,371184,380092,388977,397493,405985,414242,422280,430131,437802,445406,452924,460183,467153,474080,480969,487654,494083,500410,506612,512666,518571,524336,530047,535579,540948,546217,551410,556548,561477,566319,571160,575992,580677,585237,589619,593992,598217,602415,606506,610570,614474,618359,622166,625829,629454,632947,636424,639817,643259,646593,649897,653122,656235,659166,662153,665091,668006,670816,673573,676288,679002,681651,684134,686707,689243,691541,693958,696383,698769,701062,703321,705481,707707,709827,711925,714047,716129,
0,0,0,0,18,114,412,1064,2322,4220,6930,10438,14615,19622,25331,31687,38677,46162,54037,62331,71014,80119,89225,98609,107942,117445,127131,136744,146576,155872,165366,174800,184134,193398,202642,211476,220548,229315,238078,246641,254976,263222,271219,279216,287012,294623,302180,309588,317041,324195,331239,338104,344854,351576,358196,364622,370820,376889,383023,388938,394729,400527,406075,411487,416867,422036,427328,432300,437195,442106,446855,451550,456127,460714,465095,469469,473707,477810,482020,486016,489979,493765,497671,501378,505107,508638,512139,515552,518926,522235,525541,528742,531921,534996,538005,540994,543901,546799,549580,552321,555028,557748,560521,563234,565760,568320,570783,573295,575630,578005,580285,582506,584819,586969,589168,591351,593470,595516,597580,599551,
0,0,0,0,1,20,93,279,693,1407,2528,4189,6359,8970,12064,15717,19810,24249,29257,34625,40261,46454,52625,59161,65802,72689,79559,86602,93660,100742,107905,115072,122344,129553,136704,143816,150857,157887,164766,171646,178499,185309,192097,198876,205431,211867,218423,224843,231139,237250,243296,249407,255310,261039,266614,272229,277671,283120,288380,293580,298889,304002,308962,313858,318593,323352,327809,332483,336993,341301,345669,349885,354099,358286,362402,366394,370331,374191,377933,381586,385224,388723,392142,395504,398847,402204,405434,408589,411815,414908,417961,420946,423963,426895,429793,432675,435509,438189,440820,443444,446049,448574,451138,453604,456072,458426,460794,463116,465379,467668,469927,472088,474258,476383,478501,480564,482547,484533,486435,488339,
0,0,0,0,0,3,11,62,174,402,795,1375,2257,3407,4905,6756,8867,11323,14128,17134,20496,24112,27986,32250,36455,40939,45698,50548,55401,60457,65613,70796,76173,81334,86697,92092,97451,102869,108321,113629,119012,124306,129551,134916,140157,145499,150793,155866,160817,165869,170784,175669,180440,185234,189877,194541,199237,203816,208150,212681,217079,221445,225567,229751,233933,237926,241934,245754,249539,253426,257281,261008,264691,268221,271802,275367,278860,282288,285620,288903,292112,295375,298551,301607,304652,307654,310631,313543,316451,319296,321989,324753,327379,329987,332534,335099,337619,340041,342510,345031,347354,349706,351913,354220,356387,358571,360805,362959,365008,367104,369213,371174,373144,375103,377011,378958,380888,382763,384543,386356,
0,0,0,0,0,0,0,5,26,82,196,390,701,1128,1697,2458,3392,4512,5834,7429,9288,11221,13346,15743,18254,20811,23667,26618,29768,33062,36265,39703,43251,46774,50462,54216,58108,62032,65911,69829,73748,77619,81431,85343,89258,93124,96931,100870,104754,108704,112609,116369,120141,123806,127554,131286,134940,138599,142213,145731,149226,152686,156188,159699,163129,166454,169823,173110,176372,179443,182650,185787,188832,191955,194950,197844,200694,203534,206409,209189,211889,214679,217396,220079,222792,225378,227820,230351,232829,235226,237552,239926,242257,244636,246910,249133,251363,253548,255721,257888,260016,262052,264079,266127,268109,270068,272054,274000,275872,277701,279518,281407,283166,284897,286610,288300,289977,291632,293231,294918,
0,0,0,0,0,0,0,1,1,9,31,77,150,252,460,699,1030,1481,1982,2654,3393,4286,5327,6445,7631,8909,10371,11958,13682,15462,17383,19396,21520,23698,26009,28341,30656,33046,35570,38021,40556,43141,45707,48392,51073,53751,56476,59179,61984,64756,67350,70099,72842,75675,78402,81184,83854,86586,89252,91952,94611,97263,99979,102647,105289,107926,110443,112921,115468,117964,120402,122812,125258,127612,129958,132287,134601,136975,139287,141521,143716,145919,148178,150356,152460,154627,156685,158809,160889,162929,164963,166891,168921,170866,172739,174674,176514,178382,180182,181956,183699,185492,187315,189035,190727,192381,194078,195752,197276,198862,200418,201953,203529,205065,206647,208140,209727,211228,212620,214069,
0,0,0,0,0,0,0,0,0,1,6,14,34,60,121,207,296,472,692,973,1297,1669,2145,2641,3225,3900,4664,5485,6427,7433,8480,9609,10835,12116,13422,14799,16319,17789,19321,20861,22539,24204,25882,27617,29337,31135,32901,34757,36676,38591,40516,42436,44333,46248,48195,50331,52278,54209,56246,58203,60203,62123,64175,66116,68053,70025,71972,73887,75714,77708,79572,81451,83368,85197,87052,88850,90634,92461,94334,96159,98021,99795,101570,103322,105067,106768,108511,110222,111848,113510,115125,116766,118331,119899,121507,123037,124508,126077,127611,129077,130580,132024,133446,134915,136365,137688,139037,140354,141730,143045,144321,145632,146924,148202,149578,150814,152034,153227,154465,155642,
0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,36,70,103,165,243,362,507,678,888,1105,1395,1701,2060,2495,2920,3413,3995,4587,5208,5866,6576,7332,8127,8956,9832,10737,11664,12623,13660,14705,15779,16904,18065,19241,20449,21652,22917,24148,25362,26601,27867,29122,30425,31760,33102,34448,35764,37120,38495,39839,41149,42509,43880,45270,46608,47938,49296,50662,51966,53396,54768,56108,57466,58780,60122,61367,62730,64076,65436,66706,67936,69244,70542,71799,73100,74301,75523,76737,77945,79163,80392,81587,82833,84001,85133,86236,87356,88523,89659,90826,92000,93109,94180,95292,96465,97489,98488,99524,100585,101572,102577,103576,104564,105571,106559,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,6,18,34,57,91,123,156,209,280,368,473,581,715,848,1046,1253,1455,1688,1990,2300,2602,2969,3342,3727,4146,4615,5051,5566,6105,6655,7174,7686,8280,8905,9523,10172,10843,11534,12246,12954,13689,14402,15177,15947,16710,17502,18304,19066,19877,20717,21550,22348,23247,24132,24971,25812,26637,27448,28328,29112,29984,30875,31792,32658,33459,34299,35134,36057,36944,37823,38699,39546,40410,41246,42099,42953,43781,44580,45381,46241,47117,47952,48820,49654,50474,51234,52066,52856,53727,54548,55291,56036,56850,57594,58379,59135,59872,60600,61357,62117,62857,63589,64335,65038,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,4,5,6,10,14,21,30,36,50,69,93,137,179,220,276,343,404,482,557,645,747,848,970,1089,1246,1415,1580,1743,1962,2162,2395,2627,2843,3082,3352,3597,3853,4123,4438,4755,5069,5393,5768,6135,6513,6872,7226,7608,8022,8401,8801,9200,9627,10049,10485,10932,11341,11764,12220,12646,13133,13559,14013,14485,14929,15386,15862,16360,16831,17283,17810,18274,18747,19247,19684,20137,20573,21032,21522,22044,22535,23007,23469,23943,24430,24911,25401,25872,26325,26809,27272,27754,28226,28742,29220,29683,30138,30620,31145,31615,32070,32525,
47544,259258,474949,651727,793418,908563,1003977,1084541,1153135,1211888,1263174,1309212,1349553,1385931,1418733,1447868,1475066,1499526,1522226,1543476,1562940,1580929,1597494,1612896,1627652,1641285,1654074,1665877,1677188,1687882,1697880,1707371,1716468,1725087,1733236,1741037,1748717,1755834,1762765,1769260,1775416,1781409,1786919,1792387,1797529,1802503,1807372,1812043,1816513,1820899,1825002,1828962,1832811,1836607,1840198,1843677,1847044,1850389,1853615,1856623,1859618,1862436,1865149,1867815,1870429,1873066,1875577,1877901,1880219,1882498,1884597,1886738,1888874,1890814,1892769,1894735,1896591,1898450,1900171,1901946,1903590,1905196,1906788,1908423,1909901,1911362,1912817,1914231,1915614,1916952,1918236,1919620,1920792,1922025,1923198,1924375,1925477,1926556,1927689,1928776,1929814,1930843,1931817,1932828,1933856,1934778,1935652,1936602,1937487,1938354,1939207,1940083,1940855,1941719,1942513,1943312,1944094,1944903,1945633,1946347,
8042,99987,244236,385937,512008,622167,717207,799925,872309,936012,992333,1042665,1087991,1128672,1165463,1199330,1230453,1258988,1285256,1309767,1332296,1353594,1373512,1391905,1409129,1425446,1440713,1455148,1468744,1481554,1493695,1505236,1516168,1526525,1536406,1545742,1554717,1563202,1571455,1579449,1586991,1594107,1601034,1607593,1613912,1619953,1625964,1631609,1637103,1642319,1647411,1652291,1656926,1661574,1666058,1670281,1674373,1678486,1682405,1686067,1689683,1693298,1696793,1700135,1703345,1706462,1709533,1712390,1715221,1718005,1720692,1723356,1725893,1728374,1730765,1733053,1735353,1737583,1739776,1741937,1744032,1746119,1748063,1750001,1751857,1753725,1755463,1757205,1758900,1760531,1762147,1763768,1765356,1766845,1768324,1769826,1771255,1772653,1774072,1775377,1776690,1778018,1779254,1780514,1781711,1782838,1784019,1785187,1786273,1787348,1788421,1789431,1790460,1791517,1792498,1793424,1794345,1795268,1796185,1797087,
1873,46169,142047,252818,361190,460269,549021,628260,699459,762800,819657,870758,917340,960125,998820,1034605,1067427,1097719,1125861,1151931,1176409,1199337,1220670,1240568,1259355,1277004,1293530,1309358,1324381,1338261,1351463,1364304,1376252,1387700,1398605,1409087,1418917,1428426,1437481,1446329,1454606,1462779,1470462,1477852,1484991,1491766,1498392,1504714,1510867,1516672,1522427,1527800,1533116,1538140,1543001,1547732,1552339,1556851,1561245,1565506,1569520,1573359,1577235,1580935,1584521,1588004,1591432,1594724,1598000,1601032,1604045,1606892,1609813,1612644,1615343,1617976,1620608,1623178,1625654,1628055,1630386,1632708,1634983,1637140,1639207,1641224,1643242,1645267,1647204,1649158,1651083,1652849,1654583,1656391,1658103,1659767,1661467,1663089,1664558,1666094,1667553,1668979,1670426,1671815,1673095,1674387,1675703,1676986,1678189,1679502,1680751,1681916,1683115,1684294,1685449,1686550,1687638,1688726,1689813,1690829,
203,14243,63616,135707,215129,294886,371039,441298,506495,566627,621852,671996,718238,760825,799993,836180,869935,901522,930709,958030,983582,1007548,1030314,1051833,1072217,1091188,1109034,1125954,1142078,1157400,1171898,1185760,1198941,1211453,1223382,1234794,1245755,1256239,1266219,1275858,1285041,1293918,1302682,1311030,1318852,1326451,1333786,1340867,1347835,1354484,1360892,1367065,1373028,1378717,1384190,1389633,1394733,1399764,1404677,1409264,1413927,1418415,1422759,1427000,1431059,1434884,1438726,1442346,1445886,1449435,1452868,1456219,1459465,1462665,1465810,1468857,1471752,1474672,1477508,1480317,1483005,1485570,1488100,1490611,1493084,1495389,1497670,1499817,1501993,1504151,1506234,1508213,1510283,1512250,1514184,1516130,1517887,1519730,1521526,1523264,1524943,1526592,1528191,1529808,1531325,1532922,1534385,1535823,1537310,1538674,1540129,1541502,1542822,1544148,1545468,1546751,1548026,1549265,1550508,1551640,
4,2414,18254,51298,96873,148827,202783,256916,309479,359303,406829,452017,494407,533954,571332,606210,638492,669153,698123,725527,751582,776051,799436,821124,841935,861561,880275,898123,914973,931096,946579,961270,975270,988638,1001664,1014121,1025972,1037338,1048244,1058645,1068594,1078190,1087463,1096428,1105249,1113622,1121617,1129406,1136918,1144168,1151259,1158003,1164501,1171032,1177054,1182969,1188800,1194399,1199843,1205107,1210320,1215393,1220282,1225028,1229570,1234013,1238388,1242613,1246793,1250764,1254688,1258429,1262155,1265755,1269237,1272484,1275904,1279165,1282204,1285365,1288422,1291388,1294298,1296984,1299808,1302492,1305140,1307731,1310202,1312661,1314991,1317439,1319792,1321988,1324251,1326404,1328521,1330603,1332677,1334665,1336567,1338550,1340474,1342341,1344186,1345919,1347630,1349256,1350929,1352567,1354234,1355828,1357351,1358832,1360258,1361738,1363194,1364579,1365909,1367224,
1,592,7337,25622,54762,91521,132407,175548,218827,261576,302864,342666,380737,416607,450867,483472,514430,543518,571354,597551,622968,646714,669156,690519,710924,730498,749250,766973,783983,800178,815873,830813,845092,858912,872152,884765,896914,908394,919374,930230,940550,950450,960106,969315,978291,987054,995500,1003688,1011546,1019134,1026541,1033684,1040529,1047271,1053826,1060229,1066292,1072236,1077815,1083279,1088766,1093976,1099092,1104012,1108828,1113488,1118000,1122545,1126866,1130990,1134950,1139061,1142790,1146579,1150361,1153928,1157453,1160793,1164091,1167257,1170382,1173489,1176553,1179602,1182530,1185429,1188326,1191137,1193914,1196559,1199058,1201520,1203970,1206335,1208646,1210879,1213127,1215315,1217460,1219578,1221755,1223783,1225734,1227713,1229585,1231485,1233242,1235065,1236830,1238545,1240216,1241910,1243585,1245223,1246793,1248316,1249746,1251257,1252724,1254139,
0,112,2146,10152,25963,48651,76136,106787,139204,172621,205854,238668,270974,302452,332688,361518,389569,416060,441651,466259,489855,512224,533681,554281,573692,592400,610710,628010,644565,660459,675865,690486,704641,718217,731204,743798,755910,767783,778976,789878,800573,810650,820486,830015,839167,848065,856501,864702,872904,880524,888014,895496,902549,909357,915925,922433,928754,934854,940939,946594,952164,957637,962976,968179,973089,977860,982543,987248,991685,996177,1000365,1004683,1008685,1012561,1016367,1020048,1023726,1027260,1030752,1034136,1037444,1040700,1043968,1047131,1050183,1053268,1056192,1059075,1061894,1064678,1067429,1069997,1072555,1075085,1077539,1079969,1082328,1084695,1086967,1089154,1091343,1093457,1095587,1097724,1099826,1101735,1103748,1105680,1107588,1109456,1111219,1112975,1114715,1116364,1118047,1119663,1121317,1122921,1124485,1126033,
0,19,470,3017,9699,20995,36557,55482,77168,100172,124464,149212,174152,199222,223702,247912,271445,294160,316140,337822,358444,378385,397763,416525,434361,451679,468383,484585,500217,515396,529780,543812,557343,570448,582970,594953,606712,618064,629090,639648,649893,659817,669343,678759,687961,696651,705175,713245,721255,729118,736785,744020,751142,757969,764761,771391,777663,783679,789705,795500,801470,806990,812391,817627,822805,827863,832678,837450,842046,846502,850914,855126,859295,863439,867398,871245,874976,878724,882345,885792,889258,892707,896060,899313,902483,905499,908600,911583,914502,917319,920114,922880,925521,928077,930671,933210,935722,938119,940609,943002,945221,947477,949659,951853,954030,956174,958200,960151,962193,964093,966015,967866,969679,971482,973261,975010,976777,978421,980046,981663,
0,0,67,646,2591,6769,13525,23062,34891,48678,64018,80138,97116,114651,132246,150184,168194,186139,203761,221102,237977,254353,270710,286672,302126,317213,331666,345808,359600,372963,386167,398696,410916,422825,434413,445721,456559,467116,477415,487251,497168,506628,515828,524719,533133,541621,549580,557439,565166,572639,580014,586959,593828,600537,607087,613368,619588,625636,631613,637284,642790,648300,653596,658744,663764,668716,673495,678170,682742,687176,691697,695972,700196,704207,708311,712341,716215,719943,723602,727211,730734,734121,737348,740628,743942,747029,750178,753172,756102,759097,761953,764753,767633,770318,773029,775539,778169,780737,783168,785517,787846,790137,792419,794647,796803,798981,801064,803146,805172,807093,809033,810957,812860,814690,816515,818275,820064,821865,823576,825267,
0,0,11,175,930,2842,6356,11921,19201,28155,38438,49856,62310,75575,89271,103165,117433,131652,145983,160269,174651,188687,202597,216172,229592,242639,255519,268011,280180,292148,303810,315377,326464,337279,347918,358259,368277,377972,387375,396441,405511,414533,423157,431516,439673,447623,455339,462809,470084,477165,484188,491097,497699,504049,510384,516517,522422,528262,533920,539545,545139,550464,555600,560662,565576,570417,575040,579614,584034,588383,592748,596975,601092,605024,608971,612922,616746,620397,623996,627545,630955,634382,637727,640932,644235,647327,650359,653374,656372,659353,662234,664983,667747,670385,672987,675584,678163,680711,683196,685554,687942,690318,692646,694791,696974,699031,701178,703235,705216,707295,709359,711334,713294,715142,716917,718682,720446,722095,723798,725460,
0,0,0,25,237,923,2414,5042,8840,13901,20133,27482,35722,44586,54173,64411,75191,85981,97022,108278,119657,130940,142349,153681,164812,175836,186830,197400,207909,218297,228523,238561,248419,257922,267188,276511,285342,293927,302395,310789,319116,326995,334963,342501,349995,357308,364395,371188,378036,384741,391064,397257,403401,409343,415283,421094,426802,432391,437722,443023,448221,453319,458272,463077,467739,472288,476858,481244,485593,489764,494062,498108,502095,506126,510009,513724,517377,521096,524565,527948,531318,534729,537922,541049,544096,547247,550149,553044,555990,558781,561617,564480,567230,569789,572379,574942,577530,579904,582254,584574,586836,589115,591335,593569,595612,597724,599815,601864,603882,605849,607847,609782,611665,613505,615324,617133,618871,620618,622297,624079,
0,0,0,5,61,247,799,1890,3725,6204,9652,13791,18562,23943,30137,36768,44058,51691,59724,67760,76214,84662,93345,101885,110533,119194,127888,136444,144913,153352,161833,169996,178194,186359,194361,202151,209821,217347,224685,231953,239118,246118,253063,259868,266538,272971,279170,285254,291177,297304,303303,308953,314604,320231,325549,330768,336025,341083,346151,351123,355902,360499,365001,369456,373726,378115,382354,386544,390586,394601,398364,402265,406043,409693,413322,416911,420421,423935,427216,430489,433656,436699,439764,442886,445767,448683,451527,454347,457200,459879,462580,465275,467893,470375,472900,475365,477767,480111,482369,484687,486960,489134,491278,493383,495409,497527,499545,501577,503495,505389,507297,509140,510943,512716,514431,516141,517899,519578,521293,522965,
0,0,0,0,10,56,198,491,1090,2148,3582,5494,7977,10893,14291,18303,22669,27353,32326,37670,43157,49007,54905,61133,67454,73892,80262,86684,93066,99481,105970,112298,118637,125015,131366,137656,143656,149798,155894,161897,167679,173457,179313,184843,190533,196196,201400,206711,211868,216951,221994,227035,231934,236671,241396,245999,250608,255048,259503,263808,267969,272263,276379,280378,284236,288152,292061,295815,299420,302999,306474,309883,313320,316775,320064,323336,326412,329607,332761,335714,338604,341497,344370,347205,349983,352731,355393,357926,360426,362960,365473,367978,370353,372662,374965,377257,379538,381646,383839,385955,388078,390062,392086,394124,396141,398076,399988,401847,403722,405508,407314,409102,410804,412491,414201,415815,417435,419063,420622,422250,
0,0,0,1,2,10,29,110,280,586,1054,1837,2867,4141,5778,7658,9861,12395,15181,18097,21377,24875,28410,32318,36261,40339,44432,48700,53145,57571,62036,66569,71166,75833,80503,85123,89644,94257,98891,103504,108028,112530,116981,121310,125730,130161,134354,138677,142927,147146,151182,155250,159244,163226,167066,170941,174678,178462,182143,185806,189404,192848,196299,199666,203039,206526,209820,213041,216289,219505,222535,225601,228455,231365,234305,237135,239922,242629,245299,248017,250683,253193,255797,258164,260604,262987,265363,267671,269994,272254,274518,276745,278908,281056,283089,285194,287171,289225,291176,293168,295082,296964,298839,300728,302532,304314,306088,307894,309553,311191,312859,314548,316177,317771,319349,320927,322497,323948,325379,326764,
0,0,0,0,0,0,2,13,50,127,303,553,930,1449,2155,2991,4099,5369,6784,8402,10222,12164,14261,16518,18922,21380,24042,26793,29716,32762,35766,38857,41965,45185,48415,51697,54921,58228,61581,64909,68302,71657,75024,78439,81748,85024,88311,91654,94985,98197,101343,104472,107657,110818,113995,117182,120191,123255,126278,129249,132264,135158,138025,140868,143713,146528,149187,151890,154529,157108,159734,162316,164787,167353,169748,172282,174660,177027,179379,181625,183914,186174,188334,190489,192610,194749,196825,198926,201019,203055,204971,206872,208765,210572,212372,214201,215969,217723,219447,221142,222893,224588,226286,227919,229530,231077,232656,234209,235706,237191,238731,240262,241700,243151,244611,246019,247391,248726,250032,251417,
0,0,0,0,0,0,0,2,8,20,49,100,206,368,568,863,1215,1711,2294,2962,3750,4623,5630,6693,7982,9296,10682,12173,13695,15398,17136,18952,20818,22836,24866,26924,29006,31146,33272,35462,37654,39877,42305,44593,46846,49190,51466,53775,56081,58397,60716,63058,65395,67714,70051,72281,74537,76798,79034,81241,83467,85727,87900,90145,92343,94407,96471,98563,100758,102819,104898,106967,108966,110907,112842,114748,116693,118589,120441,122346,124217,125963,127741,129486,131315,133109,134895,136586,138319,139957,141634,143187,144738,146226,147808,149385,150873,152362,153873,155313,156782,158214,159643,161033,162331,163742,165071,166424,167699,169013,170301,171559,172759,174022,175272,176554,177752,178954,180220,181368,
0,0,0,0,0,0,0,0,0,1,3,11,31,53,95,163,251,381,542,756,1030,1362,1712,2110,2549,3076,3619,4242,4928,5661,6431,7279,8183,9164,10140,11203,12306,13443,14577,15871,17172,18372,19633,20915,22277,23659,25059,26450,27891,29352,30776,32198,33619,35078,36547,38008,39448,40949,42480,44040,45521,46933,48423,49872,51299,52758,54248,55648,57171,58569,60008,61442,62925,64376,65729,67136,68551,69944,71313,72696,74063,75373,76763,78101,79382,80719,82023,83255,84539,85751,86935,88211,89450,90745,91914,93118,94321,95481,96678,97805,98948,100022,101140,102245,103327,104356,105372,106445,107465,108506,109542,110546,111539,112536,113538,114520,115522,116464,117420,118323,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,7,13,27,46,83,126,187,257,340,437,574,696,858,1042,1259,1506,1783,2066,2370,2682,3015,3414,3805,4209,4661,5193,5708,6221,6759,7285,7876,8496,9124,9747,10402,11132,11837,12562,13261,13963,14700,15448,16240,17047,17836,18668,19411,20203,20992,21801,22601,23416,24246,25062,25938,26782,27622,28390,29198,29983,30772,31647,32409,33187,34005,34828,35660,36506,37320,38193,39024,39871,40645,41460,42238,43025,43830,44587,45383,46171,46918,47666,48433,49165,49986,50729,51458,52157,52882,53631,54339,55096,55815,56549,57275,58001,58690,59368,60051,60752,61418,62102,62780,63459,64117,
63459,293047,508111,677475,810838,918093,1006797,1081011,1144093,1198616,1245461,1287116,1324009,1357014,1386738,1413603,1438144,1460894,1481415,1500450,1518104,1534428,1549647,1563749,1576945,1589387,1601103,1612081,1622491,1632093,1641315,1649920,1658190,1666096,1673613,1680736,1687619,1694079,1700196,1706177,1711875,1717402,1722598,1727500,1732315,1736997,1741459,1745738,1749793,1753709,1757674,1761465,1764963,1768461,1771697,1775008,1778121,1781170,1784044,1786783,1789484,1792265,1794841,1797442,1799805,1802100,1804327,1806545,1808654,1810788,1812826,1814809,1816752,1818615,1820409,1822178,1823920,1825660,1827378,1829046,1830639,1832175,1833671,1835128,1836632,1838051,1839438,1840784,1842138,1843419,1844732,1845977,1847177,1848305,1849513,1850684,1851755,1852817,1853845,1854877,1855887,1856877,1857820,1858728,1859644,1860587,1861510,1862392,1863226,1864128,1864942,1865727,1866514,1867272,1868051,1868793,1869574,1870279,1870964,1871678,
14582,130613,286781,430776,553816,658793,747794,824690,891213,949507,1000743,1046637,1087306,1124134,1157407,1187816,1215665,1241248,1264923,1286735,1307067,1325944,1343372,1359842,1375317,1389754,1403348,1416250,1428400,1439944,1450744,1461203,1470761,1480196,1489177,1497583,1505571,1513306,1520698,1527777,1534452,1540982,1547098,1553106,1558978,1564418,1569710,1574872,1579912,1584783,1589374,1593822,1598122,1602356,1606298,1610240,1613903,1617562,1620943,1624329,1627583,1630807,1633976,1637039,1639877,1642773,1645476,1648132,1650723,1653255,1655725,1658194,1660494,1662812,1664957,1667128,1669230,1671291,1673295,1675278,1677190,1679023,1680821,1682563,1684232,1686030,1687654,1689286,1690867,1692394,1693951,1695329,1696778,1698207,1699555,1700980,1702296,1703638,1704852,1706099,1707290,1708472,1709652,1710816,1711914,1713028,1714129,1715196,1716237,1717263,1718301,1719291,1720210,1721187,1722132,1723088,1723937,1724829,1725663,1726501,
4390,69451,183624,302729,412342,509436,594647,669544,736220,795235,847352,894448,936656,974815,1009666,1041630,1070782,1098114,1123486,1146757,1168366,1188451,1207508,1225410,1241851,1257495,1272288,1286107,1299275,1311724,1323348,1334453,1345182,1355354,1365079,1374459,1383171,1391635,1399609,1407319,1414620,1421719,1428546,1435101,1441319,1447386,1453347,1458880,1464414,1469787,1474869,1479808,1484452,1489035,1493443,1497679,1501820,1505790,1509549,1513243,1517031,1520653,1524217,1527491,1530744,1533825,1536745,1539792,1542670,1545451,1548284,1550887,1553421,1556002,1558352,1560744,1563093,1565369,1567669,1569842,1572027,1574070,1576137,1577992,1579945,1581878,1583688,1585432,1587191,1588882,1590547,1592199,1593832,1595376,1596979,1598483,1600001,1601478,1602924,1604271,1605683,1607028,1608367,1609667,1610896,1612117,1613242,1614408,1615592,1616691,1617828,1618969,1620051,1621101,1622137,1623146,1624174,1625149,1626076,1626991,
776,27676,96325,182645,270764,354537,431177,500371,563054,619634,670942,717439,759919,798893,834890,867855,898331,926619,953066,977570,1000532,1021729,1041710,1060591,1078452,1095351,1111412,1126422,1140497,1153905,1166843,1178979,1190526,1201621,1212177,1222365,1231901,1241152,1249800,1258300,1266455,1274219,1281704,1289010,1295931,1302694,1309145,1315333,1321330,1327078,1332685,1338057,1343186,1348303,1353297,1357888,1362353,1366818,1370970,1375147,1379157,1383163,1386952,1390589,1394205,1397735,1401201,1404582,1407841,1411047,1413980,1416931,1419853,1422622,1425329,1428007,1430620,1433209,1435658,1438038,1440357,1442640,1444909,1447050,1449171,1451324,1453533,1455532,1457512,1459433,1461337,1463127,1464892,1466635,1468399,1470098,1471785,1473409,1475015,1476635,1478169,1479677,1481154,1482608,1483984,1485388,1486676,1488037,1489381,1490605,1491808,1492988,1494222,1495446,1496646,1497743,1498854,1499966,1501022,1502105,
56,6901,36661,85820,144439,205677,265721,323586,377637,428357,475641,519530,560161,597593,632623,664997,695198,723651,750092,775021,798530,820411,841136,860462,879141,896559,912929,928852,943973,958216,971843,984689,997272,1009336,1020586,1031423,1041673,1051519,1061358,1070626,1079437,1087741,1095803,1103687,1111355,1118657,1125646,1132552,1139233,1145679,1151660,1157640,1163473,1169080,1174602,1179834,1184923,1189842,1194534,1199278,1203766,1207990,1212181,1216355,1220350,1224269,1228098,1231827,1235457,1238985,1242450,1245669,1248809,1251937,1254989,1258012,1260936,1263749,1266539,1269213,1271892,1274543,1277088,1279606,1281973,1284308,1286547,1288791,1291050,1293186,1295369,1297466,1299522,1301542,1303497,1305304,1307156,1309022,1310785,1312517,1314177,1315950,1317553,1319204,1320771,1322271,1323773,1325292,1326733,1328156,1329579,1330956,1332295,1333641,1334945,1336233,1337497,1338817,1340047,1341159,
6,2616,18611,50721,93094,141180,190778,240336,287958,333596,376894,417376,455411,490906,524516,555811,584645,612004,638010,662382,685557,707500,728237,747798,766504,784043,800783,816706,832012,846587,860377,873547,886258,898323,910000,921344,932358,942592,952370,961912,971119,979712,987987,996140,1003969,1011532,1018769,1025902,1032776,1039351,1045655,1051803,1057696,1063523,1069123,1074560,1079877,1085127,1090179,1094967,1099624,1104177,1108600,1112849,1117095,1121069,1125013,1128981,1132741,1136324,1139867,1143424,1146783,1150146,1153260,1156464,1159498,1162409,1165405,1168246,1171043,1173754,1176494,1179055,1181575,1184037,1186541,1188960,1191392,1193705,1196035,1198223,1200366,1202502,1204545,1206584,1208538,1210421,1212280,1214134,1215902,1217694,1219440,1221108,1222744,1224455,1226034,1227616,1229140,1230687,1232213,1233673,1235150,1236515,1237944,1239356,1240691,1241999,1243266,1244495,
0,672,7651,25435,53552,87897,125744,165018,204514,242895,280190,316021,349889,382050,412879,441731,469410,495539,520569,544166,566359,587692,607701,626820,645092,662366,679013,694940,710275,724756,738805,752081,764951,777099,788669,799942,810669,821191,831182,840796,849985,858688,867559,875918,884011,891820,899281,906504,913561,920377,926985,933242,939353,945341,951137,956903,962292,967543,972713,977736,982735,987455,992212,996631,1001073,1005303,1009342,1013445,1017312,1021187,1025065,1028677,1032235,1035739,1039166,1042529,1045819,1048982,1052057,1055099,1057994,1060891,1063687,1066489,1069091,1071613,1074222,1076787,1079268,1081710,1084110,1086419,1088713,1090860,1093076,1095187,1097267,1099305,1101298,1103229,1105154,1107022,1108849,1110642,1112394,1114111,1115834,1117525,1119179,1120737,1122326,1123891,1125421,1126895,1128363,1129793,1131193,1132578,1133915,1135263,
0,118,2411,10661,25687,46909,72459,100811,130596,160739,190389,219940,248559,276295,303323,329305,354299,377968,400732,422514,443213,463235,482068,500039,517309,533913,549919,565381,580022,594165,607721,620797,633184,645161,656699,667723,678453,688957,698889,708489,717795,726822,735455,743884,752001,759882,767738,775024,782179,789178,795885,802410,808645,814780,820721,826471,832063,837466,842693,847977,853174,858080,862830,867520,872033,876447,880760,884907,888875,892787,896703,900536,904131,907775,911223,914565,917927,921227,924447,927547,930604,933565,936449,939350,942052,944781,947478,950132,952671,955198,957603,960030,962377,964686,967001,969237,971413,973481,975612,977724,979768,981760,983656,985540,987402,989266,991031,992810,994564,996286,997952,999558,1001159,1002739,1004276,1005794,1007319,1008745,1010151,1011585,
0,20,564,3268,9659,20220,34722,52086,71589,92619,114765,136845,159100,181277,203121,224239,244960,265183,284867,303821,322269,339817,356684,373041,388911,404013,418762,432899,446664,459859,472649,484917,496883,508261,519274,530211,540556,550599,560272,569692,578700,587411,595774,604045,612082,619854,627423,634918,641923,648834,655512,662137,668410,674493,680334,686191,691946,697390,702736,707993,713048,717938,722677,727327,731861,736305,740597,744880,749001,753085,757020,760977,764842,768491,772097,775640,778985,782346,785685,788869,791926,794901,797874,800773,803685,806450,809195,811878,814612,817207,819741,822207,824676,827053,829306,831517,833693,835876,838084,840194,842363,844390,846389,848367,850312,852218,854117,855905,857644,859392,861053,862720,864444,866091,867641,869296,870820,872344,873830,875241,
0,3,175,1255,4456,10605,19878,31665,45513,61019,77939,95162,113225,131482,149597,167691,185701,203180,220246,237085,253608,269371,284815,299774,314169,328293,341960,355156,367900,380211,392118,403698,415031,425823,436398,446642,456421,465990,475072,484074,492871,501286,509589,517577,525379,532851,540187,547275,554342,560952,567478,573951,580208,586414,592137,597954,603384,608743,614126,619265,624386,629241,634029,638562,642956,647293,651609,655853,659948,664004,667882,671825,675599,679239,682850,686303,689744,693225,696485,699674,702819,705861,708934,711813,714597,717325,720169,722819,725500,728178,730733,733334,735770,738209,740555,742845,745208,747406,749553,751706,753788,755857,757850,759845,761749,763647,765592,767457,769310,771141,772916,774661,776396,778009,779570,781174,782720,784252,785759,787254,
0,0,43,433,1798,4846,9989,16966,25903,36614,48446,61274,74872,88971,103344,117811,132438,146901,161302,175299,189301,202757,216162,229276,242013,254556,266782,278831,290455,301644,312508,323066,333228,343280,353171,362669,371678,380617,389226,397634,405797,414066,421829,429534,436743,443930,450908,457736,464467,470892,477200,483351,489466,495268,500841,506354,511837,517095,522346,527215,532215,536899,541598,546158,550527,554892,559104,563269,567368,571357,575247,579055,582786,586444,590027,593581,597045,600295,603517,606694,609696,612664,615702,618587,621398,624171,626872,629515,632203,634689,637241,639753,642174,644565,646970,649342,651577,653931,656060,658196,660247,662255,664320,666263,668214,670114,672004,673869,675671,677527,679223,680953,682595,684312,685951,687548,689096,690621,692141,693646,
0,0,3,84,531,1777,4177,7957,13103,19578,27147,35800,45205,55188,65628,76312,87342,98550,109936,121375,132804,143917,154985,166013,176820,187367,197918,208105,218234,228085,237549,246995,256063,265043,273828,282472,290771,298785,306696,314334,321879,329223,336217,343089,350071,356700,363216,369617,375770,381822,387597,393408,399000,404547,409928,415151,420433,425379,430180,434925,439604,444227,448603,453008,457265,461467,465529,469551,473346,477176,480923,484643,488281,491805,495110,498527,501850,505054,508222,511328,514425,517369,520248,523217,526092,528912,531629,534289,536859,539416,541811,544313,546764,549116,551406,553755,556006,558218,560383,562430,564504,566558,568550,570470,572395,574289,576131,578026,579886,581637,583377,585047,586758,588364,590002,591588,593167,594651,596223,597704,
0,0,0,19,134,517,1390,2931,5330,8694,12957,17861,23586,29855,36779,43958,51810,59746,67979,76225,84658,93200,101801,110573,119110,127619,136224,144448,152535,160708,168712,176567,184151,191797,199238,206586,213848,221006,227877,234540,241152,247775,254150,260519,266716,272584,278371,284095,289836,295208,300683,305927,311099,316161,321005,325780,330435,334995,339599,343951,348391,352655,356727,360829,364849,368695,372521,376269,379888,383404,386877,390379,393720,396964,400274,403571,406638,409743,412686,415676,418544,421331,424145,426874,429602,432283,434875,437371,439786,442176,444580,446910,449262,451585,453830,456021,458195,460251,462267,464405,466392,468384,470297,472144,474088,475914,477693,479545,481297,482968,484662,486366,488074,489707,491318,492924,494435,495902,497419,498867,
0,0,0,2,16,105,325,810,1649,2969,4807,7213,10131,13528,17417,21644,26295,31334,36657,42190,47972,53692,59816,65821,71935,78170,84415,90551,96820,103088,109151,115264,121386,127325,133171,139209,144963,150845,156516,162050,167509,172960,178227,183401,188574,193664,198799,203617,208404,213071,217616,222196,226744,231123,235391,239601,243908,247951,251977,255924,259729,263519,267286,271024,274537,278066,281550,284833,288138,291415,294609,297793,300847,303978,306907,309823,312649,315501,318326,321043,323641,326285,328886,331489,333991,336507,338869,341127,343372,345760,347983,350176,352427,354614,356706,358724,360783,362819,364778,366650,368554,370503,372351,374130,375900,377653,379399,381148,382806,384472,386099,387679,389260,390814,392279,393787,395268,396716,398146,399535,
0,0,0,0,4,21,67,187,441,891,1645,2705,3993,5662,7715,10033,12677,15668,18815,22242,25837,29684,33584,37702,41940,46294,50585,55034,59600,64072,68555,73221,77864,82428,87064,91496,96038,100591,105153,109708,113996,118405,122694,126890,131088,135249,139413,143428,147325,151247,155121,159023,162688,166476,170094,173773,177337,180795,184339,187674,191015,194280,197487,200607,203689,206805,209792,212728,215736,218600,221552,224342,227003,229723,232303,234992,237486,240029,242542,245024,247501,249853,252179,254458,256682,258781,261030,263148,265288,267343,269361,271481,273446,275410,277366,279335,281199,283065,284842,286604,288309,290051,291742,293447,295066,296708,298339,299887,301416,302928,304455,305978,307494,308892,310333,311758,313151,314482,315823,317130,
0,0,0,0,0,3,9,31,89,210,444,766,1215,1867,2695,3690,4860,6223,7857,9593,11505,13531,15759,17986,20487,23061,25869,28672,31464,34410,37387,40409,43429,46619,49704,52811,56059,59265,62470,65644,68729,71968,75101,78283,81418,84522,87653,90671,93770,96834,99878,102835,105799,108776,111619,114420,117236,120082,122904,125710,128509,131290,133851,136504,139108,141616,144215,146653,149085,151488,153761,156118,158335,160607,162896,165077,167305,169502,171693,173866,175869,177837,179865,181809,183787,185699,187621,189475,191240,192999,194822,196558,198254,199978,201691,203381,205075,206714,208292,209890,211478,212991,214503,215946,217443,218921,220290,221725,223031,224388,225790,227065,228403,229722,231022,232243,233475,234693,235925,237089,
0,0,0,0,0,0,0,4,9,29,59,124,243,397,613,874,1266,1756,2336,2973,3695,4499,5457,6505,7604,8784,10162,11553,12998,14542,16152,17883,19622,21371,23113,24931,26823,28754,30748,32662,34625,36631,38648,40639,42692,44711,46773,48795,50883,52995,54974,56991,59051,60982,62985,65044,66984,68920,70910,72836,74758,76803,78680,80686,82604,84457,86369,88256,90040,91892,93671,95458,97213,98979,100699,102389,104034,105743,107376,109052,110679,112302,113939,115484,116939,118474,119940,121510,123011,124454,125855,127266,128754,130110,131514,132846,134214,135499,136796,138063,139299,140552,141726,142969,144193,145389,146583,147791,148927,150088,151218,152364,153409,154569,155663,156722,157795,158806,159785,160775,
0,0,0,0,0,0,0,0,0,1,4,12,20,28,54,94,154,219,311,458,631,849,1089,1401,1715,2081,2496,2918,3400,3909,4461,5082,5700,6367,7095,7852,8631,9452,10293,11131,12015,12873,13799,14776,15808,16786,17813,18862,19938,21047,22152,23255,24374,25465,26565,27707,28878,29977,31118,32230,33370,34530,35716,36830,38038,39186,40277,41428,42599,43763,44907,46029,47124,48235,49277,50395,51477,52579,53615,54690,55768,56854,57884,58897,59899,60931,61952,62925,63928,64918,65939,66903,67900,68877,69830,70805,71709,72663,73601,74482,75411,76304,77177,78024,78909,79807,80675,81546,82361,83249,84021,84800,85619,86413,87172,87957,88741,89561,90334,91108,
79195,321316,534318,697368,824754,926506,1009926,1079370,1138158,1188734,1232654,1271714,1305874,1336663,1364069,1388974,1411749,1432410,1451626,1469337,1485790,1501146,1515247,1528312,1540597,1552139,1562991,1573350,1583061,1592317,1600834,1609090,1616826,1624252,1631202,1637883,1644321,1650390,1656229,1661850,1667242,1672296,1677170,1681858,1686374,1690710,1694825,1698882,1702824,1706757,1710371,1713856,1717217,1720550,1723769,1726824,1729737,1732648,1735471,1738161,1740763,1743246,1745655,1748115,1750430,1752631,1754786,1756922,1758906,1760896,1762880,1764862,1766640,1768457,1770210,1771993,1773683,1775334,1776914,1778452,1780008,1781517,1782940,1784282,1785587,1786974,1788316,1789527,1790832,1792068,1793256,1794476,1795601,1796723,1797838,1798928,1799984,1801061,1802032,1803043,1804032,1804935,1805803,1806679,1807607,1808483,1809288,1810207,1811036,1811835,1812650,1813450,1814220,1814964,1815735,1816475,1817130,1817829,1818524,1819206,
21777,157849,321930,465205,585211,685747,770467,842498,905142,959033,1006589,1048717,1086253,1120412,1151150,1179320,1205043,1228446,1250321,1270554,1289236,1306723,1323035,1338207,1352416,1365837,1378378,1390235,1401478,1412180,1422203,1431694,1440527,1449258,1457320,1465102,1472518,1479730,1486481,1493055,1499192,1505207,1511052,1516560,1521912,1527025,1531859,1536536,1541276,1545702,1549976,1553949,1557907,1561788,1565479,1569140,1572574,1576090,1579325,1582514,1585599,1588599,1591459,1594277,1596980,1599669,1602320,1604681,1607053,1609447,1611730,1613995,1616170,1618343,1620283,1622305,1624252,1626248,1628192,1630090,1631919,1633682,1635430,1637074,1638723,1640353,1641943,1643449,1644936,1646368,1647834,1649273,1650601,1651879,1653152,1654421,1655695,1656914,1658131,1659332,1660511,1661629,1662751,1663829,1664905,1665940,1666965,1668028,1669015,1669940,1670925,1671859,1672764,1673712,1674590,1675444,1676366,1677187,1678037,1678853,
7999,91318,218485,342037,451812,546333,628213,699479,762023,817384,866303,909816,949279,984619,1016740,1046161,1073138,1098114,1121121,1142345,1162072,1180738,1198004,1213973,1229276,1243609,1257246,1270088,1282282,1293572,1304510,1314738,1324619,1333824,1342799,1351179,1359229,1366928,1374182,1381263,1388072,1394576,1400881,1406919,1412766,1418385,1423658,1428872,1434028,1438888,1443602,1448106,1452368,1456644,1460720,1464591,1468426,1472044,1475703,1479099,1482466,1485737,1488936,1492072,1495198,1498200,1500969,1503705,1506294,1509000,1511560,1514135,1516540,1518879,1521250,1523463,1525637,1527769,1529882,1531897,1533881,1535797,1537748,1539598,1541415,1543134,1544896,1546621,1548252,1549866,1551415,1552922,1554446,1555902,1557343,1558784,1560145,1561502,1562853,1564174,1565401,1566649,1567832,1569074,1570263,1571366,1572541,1573667,1574741,1575792,1576852,1577916,1578932,1579921,1580931,1581852,1582734,1583624,1584545,1585372,
1934,42480,126699,222662,314370,398677,474435,541929,602341,656696,705618,749313,788881,825250,858310,888950,917093,943191,967107,989709,1010769,1030196,1048526,1065806,1082355,1097413,1111857,1125666,1138514,1150891,1162378,1173494,1184182,1194165,1203789,1213143,1221927,1230424,1238616,1246333,1253719,1260947,1267813,1274353,1280673,1286774,1292572,1298266,1303866,1309227,1314268,1319283,1324039,1328694,1333231,1337533,1341603,1345648,1349657,1353517,1357164,1360786,1364337,1367679,1371114,1374336,1377504,1380576,1383514,1386477,1389320,1392051,1394677,1397243,1399741,1402275,1404607,1406907,1409316,1411538,1413667,1415822,1417975,1419974,1421956,1423920,1425787,1427718,1429506,1431329,1433082,1434799,1436513,1438132,1439843,1441404,1442971,1444446,1445908,1447355,1448768,1450165,1451526,1452815,1454171,1455456,1456691,1457875,1459099,1460268,1461400,1462544,1463704,1464806,1465954,1467036,1468048,1469016,1469993,1470994,
212,13684,57060,118570,185994,252849,316581,375269,429704,479706,525623,567786,606596,642074,675115,705741,733923,760227,784612,807711,829260,849544,868526,886554,903722,919661,934780,949081,962949,975920,988353,1000205,1011591,1022357,1032472,1042378,1051945,1061097,1069883,1078310,1086218,1093981,1101306,1108472,1115393,1121968,1128324,1134470,1140579,1146313,1151861,1157370,1162553,1167660,1172534,1177369,1181944,1186369,1190629,1194804,1198860,1202973,1206826,1210618,1214360,1217895,1221406,1224792,1228062,1231166,1234292,1237305,1240229,1243090,1245965,1248653,1251270,1253829,1256431,1258854,1261254,1263627,1265958,1268213,1270431,1272525,1274675,1276742,1278803,1280760,1282670,1284592,1286470,1288333,1290191,1291907,1293666,1295264,1296880,1298496,1300054,1301598,1303085,1304633,1306068,1307554,1308935,1310333,1311609,1312940,1314218,1315442,1316740,1317897,1319088,1320276,1321405,1322555,1323693,1324799,
45,6183,32813,76866,129783,185350,240294,292910,342469,388408,431138,471001,508275,542379,574812,604480,632147,657894,682273,705101,726649,746907,766319,784747,801755,818028,833519,848341,862295,875455,888197,900316,911962,923079,933631,943883,953640,962946,971824,980360,988697,996720,1004424,1011699,1018830,1025598,1032192,1038728,1044958,1050991,1056777,1062432,1067802,1072999,1078237,1083242,1088040,1092677,1097239,1101544,1105877,1109976,1114077,1117974,1121829,1125492,1129010,1132512,1135973,1139319,1142578,1145653,1148780,1151762,1154713,1157653,1160319,1163115,1165807,1168397,1171008,1173490,1175991,1178407,1180673,1182938,1185125,1187259,1189512,1191529,1193560,1195550,1197527,1199497,1201373,1203174,1204887,1206618,1208393,1210029,1211722,1213319,1214913,1216415,1217958,1219497,1220973,1222411,1223885,1225264,1226675,1227972,1229258,1230505,1231742,1233049,1234219,1235384,1236542,1237702,
6,2177,16041,44257,82047,124768,169219,213078,256216,297255,335884,372243,406684,439077,469317,497660,524348,549460,573287,595704,616862,637064,655963,673910,690992,707241,722735,737330,751285,764694,777750,789935,801799,813002,823739,834155,844247,853978,863198,872090,880635,888871,896812,904380,911747,918824,925570,932197,938568,944648,950664,956396,962191,967541,972820,978025,983076,988064,992733,997266,1001683,1006049,1010236,1014293,1018244,1022152,1025979,1029704,1033259,1036646,1040048,1043437,1046624,1049838,1052916,1055922,1058874,1061664,1064416,1067109,1069750,1072304,1074864,1077293,1079665,1082051,1084436,1086705,1088915,1091075,1093219,1095367,1097407,1099436,1101497,1103388,1105241,1107133,1108960,1110722,1112558,1114302,1115979,1117630,1119282,1120843,1122401,1123872,1125370,1126770,1128218,1129592,1131000,1132394,1133768,1135105,1136434,1137731,1138946,1140158,
1,558,6547,21516,45272,74924,107984,142561,177414,211065,244458,276080,306576,335348,362866,388984,413653,437197,459744,481012,501480,520827,539132,556561,572877,588813,604015,618551,632461,645816,658556,670681,682394,693590,704350,714745,724556,734419,743712,752544,761083,769365,777462,785128,792687,800014,807100,813865,820466,826820,832897,838916,844629,850214,855667,860983,866192,871152,876221,880831,885438,889911,894178,898448,902464,906421,910392,914138,917737,921333,924823,928268,931589,934892,938086,941306,944377,947339,950233,953109,955820,958497,961095,963656,966208,968657,971052,973443,975890,978198,980445,982659,984853,986984,988995,990934,992944,994900,996772,998724,1000594,1002391,1004126,1005830,1007555,1009302,1010918,1012485,1014083,1015600,1017060,1018464,1019841,1021279,1022734,1024113,1025456,1026739,1028104,1029397,
0,126,1854,8338,20730,38072,59415,83143,108289,134451,160277,185765,210825,235130,258933,281568,303628,324884,345465,364673,383294,400935,417833,434299,450014,465185,479711,493312,506400,519198,531358,543255,554633,565486,575889,586063,595820,605225,614426,623231,631723,640076,648104,655808,663446,670692,677698,684629,691240,697548,703761,709800,715673,721398,726868,732320,737427,742465,747434,752250,756928,761540,765929,770245,774395,778495,782490,786407,790129,793870,797474,801034,804529,807798,811022,814260,817399,820582,823618,826536,829297,832083,834763,837407,840028,842647,845062,847614,850012,852418,854730,857068,859400,861591,863665,865733,867780,869753,871711,873640,875540,877516,879334,881151,882874,884579,886221,887889,889533,891162,892726,894288,895804,897271,898659,900117,901465,902865,904201,905500,
0,32,748,3945,11202,22630,37643,55282,74794,95609,116939,138434,159687,180938,201614,221730,241340,260658,278905,296459,313664,330200,346089,361049,375663,389664,403232,416467,429121,441509,453298,464692,475837,486406,496654,506556,515962,525276,534061,542842,551138,559326,567000,574641,581878,588978,595846,602542,609239,615457,621614,627626,633458,638987,644492,649760,655015,659996,664868,669603,674294,678745,683233,687525,691713,695848,699862,703704,707632,711505,715054,718700,722181,725603,728895,732224,735266,738415,741435,744247,747082,749998,752845,755519,758243,760808,763367,765910,768300,770761,773180,775539,777854,780081,782256,784322,786423,788474,790496,792520,794481,796416,798298,800180,801973,803670,805454,807155,808737,810385,812086,813713,815336,816868,818379,819803,821301,822733,824079,825462,
0,3,224,1597,5294,11990,21493,33741,47513,62874,79215,96238,113470,130719,148141,165202,182052,198477,214442,230287,245632,260282,274691,288522,301850,314850,327306,339494,351246,362691,373692,384729,395079,405361,415064,424480,433637,442366,450875,459250,467322,475177,482803,490185,497120,504140,510926,517443,523689,529927,535994,541790,547523,552996,558435,563643,568842,573996,578866,583577,588287,592698,597008,601196,605479,609449,613513,617364,620963,624627,628316,631814,635302,638665,642147,645468,648598,651684,654715,657643,660662,663570,666380,669057,671733,674331,676924,679402,681855,684332,686747,689070,691340,693529,695784,697922,700068,702157,704175,706150,708200,710045,711910,713791,715665,717412,719134,720859,722568,724217,725760,727379,728849,730403,731955,733408,734894,736297,737734,739151,
0,0,53,532,2127,5376,10463,17708,26691,37292,48594,60908,73992,87439,101058,114852,128578,142280,155682,169012,182072,194720,207291,219358,231161,242786,254050,264928,275450,285642,295845,305624,315297,324453,333360,341965,350376,358681,366656,374259,381831,389251,396485,403557,410305,416773,423232,429390,435604,441579,447314,452971,458388,463590,468814,473918,479030,483848,488621,493290,497792,502122,506445,510677,514787,518786,522602,526455,530199,533891,537400,540915,544357,547573,550800,554207,557357,560401,563351,566221,569042,571893,574675,577390,580017,582602,585107,587654,590095,592461,594793,597137,599415,601677,603816,605916,608004,610074,612197,614265,616256,618153,620095,621970,623721,625509,627220,628886,630467,632071,633750,635362,636931,638468,640089,641598,643063,644572,645943,647327,
0,0,3,106,580,1798,4182,7921,12995,19064,26341,34642,43369,52574,62346,72374,82530,92793,103275,113637,124057,134275,144490,154677,164653,174356,183930,193405,202696,211677,220561,229240,237644,245753,253823,261633,269192,276473,283660,290790,297618,304325,310973,317341,323563,329548,335422,341255,346888,352449,357873,363131,368395,373400,378235,382991,387639,392233,396768,401184,405458,409704,413766,417809,421769,425473,429169,432766,436326,439872,443272,446711,449981,453248,456450,459570,462721,465699,468532,471482,474255,476995,479692,482319,484896,487422,489823,492275,494658,497010,499274,501483,503840,506021,508244,510335,512416,514419,516466,518369,520345,522246,524127,525959,527733,529539,531260,532986,534671,536349,537960,539527,541050,542591,544044,545570,547012,548423,549790,551232,
0,0,0,7,107,484,1299,2770,5041,8038,11827,16443,21582,27253,33486,39977,46967,54109,61607,69057,76623,84404,92132,99831,107598,115006,122790,130308,137552,144843,152010,159029,165946,172942,179606,186435,192934,199408,205605,211663,217435,223400,229044,234727,240181,245510,250862,255903,260888,265698,270501,275113,279719,284299,288741,293110,297241,301447,305537,309519,313518,317500,321225,324853,328429,331885,335407,338670,342054,345254,348375,351501,354602,357704,360676,363550,366390,369298,372173,374779,377425,380050,382639,385189,387758,390198,392528,394862,397177,399341,401519,403726,405871,407952,409976,412024,414009,416000,417870,419735,421520,423433,425248,426968,428692,430467,432112,433744,435376,436913,438479,440116,441624,443112,444557,445998,447410,448794,450168,451538,
0,0,0,2,19,98,326,830,1697,2981,4785,7061,9747,12930,16641,20628,24985,29636,34470,39466,44654,49939,55440,61155,66811,72609,78372,84028,89635,95326,100887,106579,112135,117667,123054,128390,133657,138889,144105,149244,154341,159207,164267,169021,173720,178352,182861,187328,191572,195810,199912,204043,208081,212070,215995,219878,223707,227449,231113,234682,238067,241535,244852,248169,251464,254697,257900,261019,264040,267006,270013,272884,275680,278444,281207,283838,286464,289016,291532,294008,296393,298855,301128,303366,305646,307921,310115,312260,314419,316459,318460,320514,322501,324496,326440,328387,330300,332157,333889,335655,337280,339060,340692,342388,344012,345573,347169,348789,350307,351830,353282,354785,356327,357765,359144,360537,361891,363168,364462,365745,
0,0,0,0,1,11,48,168,423,804,1428,2327,3413,4827,6557,8534,10743,13273,16032,19006,22105,25297,28727,32370,35988,39806,43667,47529,51485,55329,59288,63297,67340,71314,75327,79327,83248,87250,91204,95212,98941,102755,106422,110206,113881,117531,121124,124751,128296,131644,135059,138445,141840,145124,148361,151624,154731,157866,160974,164076,167030,169991,172796,175585,178338,181080,183847,186452,189061,191671,194216,196763,199248,201623,203967,206252,208582,210951,213230,215420,217585,219715,221797,223859,225893,227865,229840,231820,233753,235658,237505,239285,241042,242710,244445,246204,247914,249651,251303,252934,254530,256064,257624,259155,260724,262175,263619,265073,266512,267989,269370,270708,272074,273349,274679,275987,277241,278467,279657,280874,
0,0,0,0,0,0,3,13,48,116,234,460,766,1202,1779,2487,3348,4342,5476,6676,8096,9590,11250,12995,14827,16779,18871,21032,23310,25568,27900,30383,32961,35509,38030,40563,43125,45717,48349,50973,53582,56158,58694,61256,63728,66306,68873,71399,74005,76450,78964,81359,83784,86187,88619,90928,93317,95758,98030,100356,102586,104807,106951,109201,111369,113473,115621,117718,119828,121853,123839,125803,127748,129673,131591,133496,135400,137266,139066,140850,142644,144428,146120,147824,149571,151174,152841,154470,156001,157558,159123,160678,162151,163628,165107,166539,167913,169380,170795,172131,173409,174808,176149,177453,178761,179971,181204,182414,183647,184848,186064,187256,188391,189529,190619,191714,192827,193942,194998,196017,
0,0,0,0,0,0,0,0,2,6,15,33,71,132,205,318,472,705,1001,1316,1720,2144,2656,3139,3750,4427,5142,5968,6798,7741,8660,9763,10785,11902,13004,14144,15371,16632,17913,19209,20522,21812,23211,24587,25950,27257,28688,30120,31564,32985,34454,35807,37239,38724,40114,41594,43042,44529,45918,47406,48908,50290,51684,53068,54429,55817,57215,58581,59895,61283,62598,63963,65305,66635,68000,69203,70426,71698,72986,74285,75479,76700,77927,79179,80395,81636,82767,83892,85053,86202,87378,88527,89643,90725,91838,92886,93922,94948,95979,96955,97964,98929,99887,100905,101887,102809,103701,104640,105546,106458,107392,108339,109163,110008,110901,111769,112610,113450,114353,115178,
94334,345352,555260,713883,835609,932559,1011962,1077684,1133673,1181317,1222299,1258955,1291204,1320260,1346078,1369525,1390911,1410579,1428707,1445312,1460739,1475121,1488480,1501046,1512586,1523454,1533779,1543562,1552762,1561495,1569497,1577305,1584683,1591837,1598486,1604799,1610899,1616692,1622143,1627388,1632508,1637413,1642120,1646611,1650864,1655040,1658995,1662883,1666711,1670338,1673783,1677143,1680331,1683443,1686551,1689511,1692339,1695204,1697879,1700461,1702924,1705443,1707865,1710107,1712278,1714517,1716601,1718666,1720646,1722577,1724421,1726225,1727974,1729775,1731449,1733138,1734805,1736360,1737875,1739348,1740798,1742237,1743616,1745035,1746361,1747696,1749014,1750211,1751381,1752631,1753756,1754961,1756049,1757138,1758197,1759250,1760293,1761276,1762234,1763196,1764171,1765112,1766029,1766900,1767798,1768663,1769486,1770326,1771140,1771948,1772735,1773545,1774295,1774994,1775774,1776462,1777108,1777781,1778423,1779078,
30200,182224,350642,493100,609696,706317,787076,855546,914647,965881,1010955,1050731,1086131,1118130,1146750,1172979,1197083,1219168,1239802,1258681,1276292,1292667,1307916,1322102,1335256,1347763,1359567,1370579,1381093,1391219,1400563,1409682,1418043,1425905,1433507,1441000,1447940,1454751,1461057,1467227,1472989,1478661,1484072,1489308,1494460,1499181,1503924,1508403,1512680,1516948,1520957,1524781,1528627,1532265,1535760,1539188,1542498,1545766,1548911,1551833,1554738,1557608,1560460,1563111,1565753,1568208,1570627,1573097,1575433,1577677,1579900,1582019,1584109,1586144,1588082,1589996,1591885,1593732,1595608,1597298,1599002,1600663,1602319,1603875,1605438,1607064,1608573,1610033,1611413,1612835,1614228,1615621,1616936,1618221,1619439,1620633,1621831,1623013,1624119,1625228,1626357,1627428,1628511,1629563,1630614,1631615,1632588,1633550,1634513,1635421,1636324,1637218,1638092,1638925,1639748,1640545,1641432,1642211,1642979,1643745,
12721,112835,248381,374388,483091,575252,654420,723183,782772,834926,880985,922029,959067,992415,1022318,1049820,1075186,1098483,1120027,1140029,1158445,1175784,1191997,1207210,1221265,1234808,1247478,1259383,1270571,1281166,1291275,1300807,1310103,1318754,1327047,1334997,1342478,1349777,1356522,1362955,1369405,1375464,1381493,1387142,1392587,1397816,1402860,1407832,1412645,1417092,1421492,1425757,1429919,1433883,1437742,1441466,1445029,1448562,1451795,1455143,1458280,1461359,1464367,1467179,1470104,1472879,1475507,1478098,1480658,1483238,1485583,1487969,1490304,1492456,1494586,1496734,1498774,1500797,1502843,1504749,1506638,1508410,1510240,1511964,1513619,1515273,1516904,1518550,1520032,1521556,1523028,1524527,1525944,1527329,1528710,1530006,1531339,1532593,1533930,1535169,1536323,1537506,1538654,1539792,1540996,1542076,1543040,1544081,1545192,1546218,1547184,1548169,1549203,1550185,1551123,1552078,1553002,1553882,1554759,1555556,
3605,57382,154078,256098,350851,435497,509334,575055,633080,685380,731609,773130,810874,845078,876182,904748,931025,955465,977802,998687,1018329,1036513,1053649,1069704,1084880,1099102,1112673,1125401,1137406,1148775,1159621,1169819,1179876,1189278,1198128,1206751,1215009,1222786,1230391,1237511,1244361,1250967,1257351,1263549,1269567,1275327,1280748,1286114,1291173,1296236,1301032,1305573,1309956,1314247,1318533,1322633,1326593,1330415,1334000,1337583,1341016,1344313,1347667,1350815,1353993,1356991,1359884,1362688,1365430,1368189,1370768,1373413,1375997,1378357,1380708,1382958,1385227,1387397,1389625,1391791,1393855,1395833,1397808,1399713,1401540,1403333,1405097,1406888,1408634,1410253,1411874,1413513,1415125,1416720,1418262,1419650,1421104,1422535,1423909,1425311,1426671,1427950,1429264,1430521,1431758,1432978,1434104,1435282,1436412,1437555,1438692,1439716,1440820,1441870,1442839,1443855,1444830,1445811,1446782,1447661,
576,21626,77485,148427,221612,291784,356658,415767,469490,518615,563268,603492,640590,674172,705532,734609,761233,785750,808801,830488,850670,869672,887584,904380,920337,935300,949574,962915,975649,987579,999173,1010187,1020764,1030706,1040146,1049368,1058196,1066627,1074724,1082576,1089835,1096800,1103798,1110447,1116926,1122979,1128982,1134828,1140350,1145663,1150891,1155975,1160772,1165501,1170063,1174548,1178754,1182933,1187097,1191076,1194825,1198433,1201985,1205500,1208861,1212097,1215273,1218455,1221477,1224396,1227279,1230119,1232799,1235481,1238164,1240643,1243100,1245556,1247929,1250285,1252477,1254676,1256818,1258959,1260981,1262964,1264923,1266990,1268891,1270693,1272543,1274300,1276022,1277769,1279517,1281094,1282748,1284240,1285775,1287284,1288788,1290193,1291665,1293057,1294410,1295788,1297096,1298377,1299662,1300808,1301975,1303147,1304325,1305516,1306643,1307766,1308852,1309960,1311027,1312066,
170,11135,48340,102279,162294,222503,280227,334194,383393,429488,472063,511192,547115,579863,610734,639039,665436,690029,713382,734988,755471,774583,792351,809524,825543,840780,855231,868931,881906,894276,906031,917337,928288,938728,948447,958226,967481,976201,984393,992259,1000096,1007327,1014399,1021211,1027857,1034190,1040257,1046218,1052094,1057552,1062807,1068076,1073091,1078048,1082814,1087483,1091979,1096345,1100630,1104614,1108581,1112575,1116350,1120021,1123563,1126962,1130367,1133633,1136769,1139919,1142931,1145868,1148736,1151606,1154359,1156982,1159641,1162223,1164701,1167118,1169463,1171735,1174002,1176190,1178387,1180556,1182648,1184682,1186625,1188537,1190498,1192326,1194101,1195921,1197740,1199414,1201094,1202771,1204400,1205897,1207471,1208989,1210457,1211939,1213320,1214643,1216037,1217365,1218690,1219993,1221262,1222556,1223805,1225044,1226232,1227426,1228548,1229666,1230743,1231825,
47,4756,26476,63535,109460,158396,207085,254357,299017,340944,379917,416397,450566,482240,511738,539018,564689,588872,611669,633119,653402,672494,690544,707561,723722,738977,753462,767216,780470,792996,805008,816302,827382,838059,848236,857896,867332,876302,884836,893144,901228,908767,916096,923213,929952,936591,943004,949133,955085,960793,966325,971698,977005,981983,986834,991679,996340,1000815,1005128,1009434,1013490,1017485,1021378,1025230,1028867,1032494,1036049,1039498,1042824,1045964,1049173,1052189,1055230,1058174,1061029,1063812,1066501,1069199,1071779,1074410,1076850,1079171,1081497,1083841,1086148,1088287,1090566,1092646,1094674,1096727,1098743,1100819,1102729,1104576,1106426,1108152,1109779,1111533,1113283,1115018,1116567,1118184,1119724,1121285,1122823,1124301,1125777,1127270,1128676,1130052,1131364,1132617,1133966,1135275,1136546,1137778,1138969,1140122,1141293,1142454,
3,1516,12140,34679,65863,102147,140460,178950,216807,253134,287592,320251,351163,380406,407933,434028,458830,481755,503619,524292,543754,562370,579826,596730,612627,627689,641895,655759,668887,681368,693473,704819,715724,726366,736623,746465,756090,765356,774156,782586,790552,798292,805777,813032,819996,826807,833373,839614,845811,851563,857472,863045,868509,873686,878859,883965,888770,893314,897899,902289,906396,910688,914762,918655,922481,926182,929831,933377,936875,940283,943458,946676,949772,952824,955877,958753,961566,964387,967122,969768,972461,974919,977399,979785,982064,984384,986664,988902,991144,993321,995402,997432,999444,1001377,1003351,1005140,1007010,1008814,1010632,1012380,1014093,1015780,1017394,1018976,1020579,1022113,1023637,1025109,1026580,1028005,1029393,1030792,1032160,1033521,1034833,1036099,1037350,1038606,1039830,1041001,
0,337,4246,15421,33913,57558,84929,113710,143167,172340,201367,229067,255718,280916,305401,328770,351010,372543,392800,412315,430539,448080,464715,480656,495813,510421,524495,537827,550558,562823,574548,585984,597039,607453,617517,627133,636482,645437,654099,662638,670812,678586,686110,693428,700505,707280,713819,720142,726357,732279,738208,744047,749614,754879,759974,765027,769989,774777,779419,783978,788474,792679,796914,801065,804895,808761,812474,816095,819635,823058,826559,829917,833179,836223,839289,842294,845140,848079,850890,853623,856232,858782,861324,863791,866226,868661,870988,873247,875428,877639,879766,881912,883903,885954,887947,889916,891826,893670,895524,897333,899159,900856,902551,904232,905896,907492,909099,910649,912128,913620,915061,916527,917938,919405,920783,922107,923478,924800,926055,927298,
0,115,1948,8335,20266,36980,57269,79604,103411,127967,152155,176346,199741,222493,244333,265465,285787,305602,324605,342995,360422,376837,392633,407794,422293,436300,449649,462684,475113,487012,498390,509511,520234,530579,540267,549833,559008,567839,576420,584753,592733,600441,607971,615115,622023,628897,635509,641969,648237,654268,660121,665651,671254,676627,681938,686972,691829,696572,701246,705808,710254,714530,718660,722774,726779,730573,734325,738060,741646,745078,748416,751778,755012,758328,761517,764583,767443,770402,773255,776050,778630,781331,783998,786558,788980,791392,793794,796162,798432,800647,802938,805145,807302,809363,811431,813325,815218,817141,819045,820974,822838,824719,826417,828140,829855,831500,833100,834651,836205,837730,839228,840699,842140,843558,844892,846293,847612,848897,850234,851518,
0,33,757,3858,10752,21519,35766,52263,70358,89427,109428,129398,149326,168852,187966,206765,224900,242498,259299,275681,291310,306504,321191,335317,349090,362129,374719,386821,398592,409867,420788,431371,441597,451635,461090,470247,479127,487734,496147,504152,512079,519680,527042,534060,540865,547447,554039,560293,566431,572257,577957,583614,588957,594303,599441,604481,609356,614045,618667,623110,627450,631691,635859,639909,643904,647791,651535,655233,658900,662373,665881,669229,672552,675774,679012,682052,685009,687965,690818,693686,696474,699198,701798,704326,706766,709173,711500,713837,716107,718389,720726,722937,725152,727150,729102,731119,733089,735034,737036,738977,740790,742695,744425,746105,747943,749642,751279,752858,754430,756036,757560,759039,760542,761997,763327,764646,766095,767446,768824,770189,
0,5,218,1491,4827,10811,19520,30510,42998,56969,71930,87506,103411,119358,135208,150854,166354,181561,196293,210554,224654,238229,251440,264244,276602,288541,300142,311559,322574,332961,343220,353173,362656,372032,380853,389550,397926,405991,413773,421522,428839,436272,443236,450124,456657,463140,469430,475480,481445,487058,492559,497866,503063,508066,513088,518009,522803,527473,532108,536491,540857,545192,549291,553278,557238,561065,564718,568395,571850,575266,578635,581899,585114,588514,591650,594641,597668,600576,603363,606098,608877,611487,614215,616757,619303,621768,624119,626533,628868,631116,633390,635609,637721,639842,641937,643941,645876,647804,649747,651637,653448,655338,657155,658918,660682,662463,664154,665747,667263,668852,670347,671891,673392,674793,676255,677634,679074,680453,681790,683092,
0,1,51,436,1744,4378,8925,15351,23033,31950,42246,53199,64661,76598,88468,100378,112532,124708,136866,148806,160514,171887,183173,194042,204730,215392,225645,235586,245286,254551,263695,272528,281180,289711,297953,306064,313734,321158,328563,335536,342564,349390,355966,362455,368719,374665,380426,386136,391866,397216,402579,407772,412876,417747,422568,427265,431843,436293,440792,445066,449336,453370,457329,461299,465136,468818,472367,475938,479498,482909,486254,489647,492819,495938,499018,502086,504955,507819,510515,513258,515936,518590,521264,523774,526309,528804,531124,533428,535685,537930,539992,542120,544228,546413,548445,550421,552372,554300,556116,557985,559871,561734,563519,565335,567020,568769,570400,572090,573626,575157,576784,578325,579801,581238,582623,584059,585448,586860,588196,589458,
0,0,5,79,427,1393,3246,6139,10108,15084,21036,27720,35168,43047,51397,59929,68962,77994,87021,96008,104966,113956,122933,131845,140645,149236,157731,165991,174162,182277,190227,197775,205121,212377,219477,226396,233139,239795,246341,252571,258684,264768,270737,276455,282232,287693,293109,298272,303202,308163,313161,317895,322538,327169,331631,336083,340441,344693,348847,352885,356898,360821,364505,368154,371814,375321,378686,382130,385501,388644,391730,394788,397855,400854,403890,406691,409496,412197,414807,417332,419952,422562,425093,427559,429892,432281,434495,436768,438974,441178,443319,445371,447445,449402,451377,453309,455206,457113,458932,460773,462586,464415,466167,467867,469575,471238,472883,474529,476170,477678,479120,480557,482032,483514,484926,486334,487693,488982,490367,491743,
0,0,0,7,72,334,995,2201,4025,6482,9582,13463,17730,22708,27952,33601,39518,45776,52065,58618,65179,71959,78616,85457,92220,98883,105681,112306,118900,125377,131794,138171,144419,150478,156440,162443,168252,173967,179476,184982,190390,195620,200684,205759,210855,215773,220393,224899,229421,233971,238366,242801,246983,251173,255185,259186,263154,266929,270680,274296,277944,281422,284841,288187,291466,294706,297862,300993,303961,306879,309847,312691,315566,318346,321091,323817,326408,328970,331540,334095,336578,338944,341294,343625,345901,348181,350305,352441,354595,356636,358652,360668,362511,364521,366464,368336,370153,371978,373791,375578,377292,379009,380679,382339,383953,385445,387008,388528,390006,391487,392951,394442,395876,397372,398717,400100,401397,402729,404038,405298,
0,0,0,0,6,52,195,551,1145,2109,3431,5156,7185,9623,12428,15584,18901,22537,26392,30386,34764,39190,43757,48392,52972,57632,62314,67078,71918,76765,81455,86274,90950,95689,100350,105039,109711,114122,118519,122968,127301,131524,135736,139869,144068,148079,151981,155720,159563,163311,166991,170757,174326,177918,181475,184917,188216,191486,194714,197855,201039,204098,207130,210114,213071,215896,218752,221525,224300,226955,229516,232159,234644,237144,239531,241980,244345,246702,248956,251143,253392,255570,257764,259789,261902,263934,265902,267816,269719,271563,273413,275236,276974,278781,280532,282163,283952,285648,287218,288844,290433,291919,293466,294987,296447,297908,299390,300863,302224,303622,304942,306280,307604,308885,310200,311451,312714,313984,315218,316391,
0,0,0,0,0,2,19,69,179,391,729,1194,1910,2799,3823,5076,6492,8228,10087,12070,14177,16520,18864,21411,23980,26719,29468,32339,35326,38248,41267,44285,47399,50514,53643,56772,59890,62852,65982,69120,72197,75231,78264,81341,84259,87156,90082,92989,95792,98671,101464,104266,106993,109652,112297,114954,117600,120134,122650,125248,127814,130321,132658,135111,137450,139783,142106,144408,146696,148873,151050,153149,155264,157357,159446,161524,163442,165358,167311,169180,171036,172915,174772,176460,178238,179970,181716,183443,185033,186659,188248,189842,191414,192955,194433,195890,197284,198783,200247,201645,203004,204353,205769,207110,208425,209738,211050,212276,213517,214732,215967,217164,218302,219507,220684,221871,223013,224115,225156,226241,
0,0,0,0,0,0,1,6,15,31,54,106,206,350,537,813,1099,1507,1989,2549,3201,3935,4722,5598,6566,7590,8721,9891,11164,12432,13825,15225,16677,18153,19671,21252,22880,24474,26119,27766,29479,31171,32838,34568,36210,37872,39646,41457,43229,44962,46659,48370,50050,51684,53352,55024,56770,58476,60178,61885,63469,65113,66742,68352,69884,71433,73041,74632,76128,77622,79089,80663,82102,83657,85101,86513,87905,89299,90689,92146,93541,94900,96247,97610,98898,100249,101523,102799,104045,105346,106573,107737,108944,110118,111235,112387,113526,114629,115712,116827,117897,118911,119986,121054,122079,123069,124057,125039,126023,126960,127855,128810,129724,130714,131647,132509,133409,134336,135218,136127,
108810,365930,573474,726796,844182,937456,1013185,1076213,1129377,1174906,1214045,1248773,1279341,1306939,1331430,1354003,1374363,1393072,1410174,1425961,1440780,1454525,1467366,1479147,1490384,1500926,1510779,1520255,1529046,1537451,1545211,1552635,1559612,1566391,1572706,1578770,1584566,1590182,1595437,1600504,1605431,1610194,1614737,1619020,1623259,1627291,1631188,1634931,1638463,1641990,1645378,1648561,1651799,1654807,1657727,1660612,1663420,1666050,1668623,1671057,1673518,1675857,1678111,1680314,1682517,1684672,1686667,1688635,1690534,1692452,1694263,1696060,1697812,1699502,1701193,1702859,1704440,1705997,1707458,1708906,1710330,1711736,1713122,1714381,1715687,1716997,1718165,1719347,1720534,1721650,1722804,1723968,1725046,1726028,1727013,1728002,1729008,1730020,1731001,1731971,1732884,1733763,1734666,1735573,1736465,1737331,1738177,1738949,1739729,1740488,1741281,1742050,1742791,1743506,1744215,1744886,1745602,1746224,1746840,1747496,
39081,205254,376362,516706,630161,723225,800728,866014,922099,970997,1013664,1051394,1085233,1115733,1143003,1167995,1190732,1211659,1231003,1248905,1265413,1280790,1295036,1308265,1320907,1332742,1343749,1354191,1364174,1373797,1382697,1391150,1399245,1406880,1414114,1420914,1427618,1433986,1440030,1445912,1451483,1456968,1462024,1467082,1471965,1476497,1480995,1485340,1489560,1493523,1497374,1501241,1504930,1508332,1511695,1515026,1518310,1521504,1524398,1527293,1530112,1532803,1535491,1538094,1540614,1542965,1545344,1547660,1549947,1552118,1554262,1556320,1558361,1560309,1562225,1564048,1565818,1567572,1569262,1570934,1572516,1574157,1575781,1577356,1578827,1580298,1581796,1583222,1584604,1585841,1587167,1588459,1589734,1590958,1592196,1593414,1594587,1595676,1596866,1597969,1599031,1600071,1601115,1602105,1603117,1604127,1605066,1605985,1606856,1607795,1608629,1609510,1610406,1611199,1612071,1612936,1613717,1614500,1615277,1615962,
17838,133059,274560,401622,508641,598609,675198,740992,798192,848237,892023,930797,965633,997345,1026176,1052350,1076148,1097849,1118007,1136907,1154519,1170631,1185931,1200609,1214126,1226871,1238587,1249909,1260442,1270568,1280283,1289353,1298109,1306317,1314129,1321621,1328844,1335734,1342222,1348527,1354624,1360485,1366161,1371640,1376702,1381736,1386473,1391117,1395620,1399922,1404074,1408191,1412106,1415820,1419578,1423128,1426646,1429961,1433251,1436321,1439333,1442277,1445085,1447906,1450583,1453270,1455812,1458247,1460662,1463041,1465325,1467561,1469762,1471832,1473859,1475912,1477869,1479792,1481712,1483519,1485300,1486985,1488743,1490400,1492036,1493601,1495158,1496683,1498191,1499639,1501119,1502554,1503950,1505278,1506531,1507823,1509106,1510323,1511608,1512772,1513935,1515027,1516125,1517238,1518348,1519402,1520439,1521454,1522439,1523400,1524370,1525325,1526240,1527202,1528075,1528996,1529855,1530658,1531493,1532268,
5956,73264,178923,285231,380959,464560,537417,601392,657595,707244,751517,790901,826709,859245,888857,915745,940586,963637,984959,1005035,1023558,1040585,1056738,1072000,1086284,1099727,1112420,1124556,1136082,1146713,1156699,1166490,1175795,1184540,1192853,1200911,1208730,1216209,1223357,1230133,1236656,1242846,1248885,1254748,1260266,1265717,1270852,1275883,1280614,1285315,1289927,1294293,1298461,1302498,1306469,1310354,1314082,1317741,1321290,1324694,1327912,1331079,1334200,1337152,1340148,1343011,1345735,1348480,1351123,1353719,1356201,1358622,1360985,1363277,1365475,1367734,1369832,1371917,1373906,1375927,1377845,1379793,1381681,1383505,1385316,1387081,1388839,1390545,1392236,1393770,1395313,1396817,1398309,1399824,1401266,1402644,1404010,1405350,1406692,1408051,1409348,1410619,1411791,1413009,1414195,1415368,1416493,1417639,1418707,1419809,1420860,1421862,1422905,1423895,1424882,1425839,1426745,1427671,1428577,1429465,
1229,30892,96935,175371,252685,324563,390139,448546,501061,548467,591354,630429,665683,697905,727845,755519,781092,804785,826902,847343,866276,884354,901224,917102,932241,946528,959925,972467,984500,995977,1006905,1017319,1027294,1036598,1045558,1054251,1062685,1070609,1078130,1085551,1092530,1099097,1105741,1111937,1117861,1123697,1129200,1134754,1139995,1145035,1149840,1154531,1159124,1163590,1167869,1172048,1176188,1180243,1184040,1187726,1191368,1194879,1198198,1201491,1204715,1207821,1210863,1213812,1216708,1219503,1222278,1224973,1227544,1230206,1232716,1235134,1237467,1239742,1242049,1244263,1246387,1248317,1250375,1252349,1254315,1256319,1258241,1260076,1261866,1263692,1265500,1267187,1268809,1270431,1272077,1273611,1275175,1276586,1278027,1279451,1280800,1282166,1283498,1284877,1286138,1287370,1288600,1289813,1290994,1292173,1293318,1294461,1295570,1296695,1297814,1298851,1299898,1300917,1301885,1302875,
445,17278,64038,125758,191276,254809,314221,368497,418289,463623,504875,542917,577648,609697,639480,666657,691857,715244,737335,757875,777262,795466,812474,828506,843838,858246,871907,884792,897069,909017,920154,930798,941065,951049,960339,969559,978111,986316,994175,1001703,1009043,1016076,1022804,1029283,1035512,1041534,1047258,1052804,1058249,1063556,1068571,1073393,1078040,1082692,1087170,1091669,1095929,1100002,1104066,1107904,1111646,1115382,1118866,1122389,1125649,1128833,1131942,1134981,1137928,1140854,1143604,1146425,1149099,1151868,1154456,1157031,1159437,1161953,1164296,1166663,1168848,1170990,1173033,1175141,1177266,1179291,1181311,1183277,1185141,1186948,1188743,1190528,1192273,1193975,1195694,1197329,1198926,1200489,1202069,1203487,1204979,1206393,1207816,1209222,1210551,1211974,1213230,1214468,1215749,1217028,1218246,1219453,1220617,1221745,1222860,1223944,1225014,1226118,1227200,1228212,
126,8283,37995,83473,135476,188685,239879,288838,334166,376110,414916,451074,484281,515165,544098,570753,595648,618922,640832,661446,680553,698922,716079,732325,747838,762333,776048,789099,801694,813624,824922,835824,846156,856235,865536,874884,883843,892304,900441,908199,915733,922906,929727,936376,942805,949049,955050,960837,966388,971754,976922,982099,987134,991990,996620,1001254,1005526,1009806,1013943,1017942,1021862,1025747,1029410,1032998,1036559,1039856,1043137,1046408,1049508,1052475,1055398,1058268,1061042,1063836,1066595,1069260,1071782,1074307,1076710,1079162,1081517,1083831,1086076,1088193,1090367,1092448,1094552,1096571,1098515,1100403,1102239,1104158,1106059,1107755,1109522,1111212,1112897,1114559,1116189,1117830,1119388,1120904,1122379,1123907,1125316,1126753,1128158,1129506,1130843,1132147,1133459,1134642,1135903,1137059,1138260,1139423,1140485,1141599,1142696,1143722,
20,3080,19133,48880,86851,128582,171007,212315,252074,290103,325348,358439,389271,418330,445357,470663,495022,517344,538960,558726,577731,595699,612782,628698,643884,658241,672054,685356,697864,709799,721252,732236,742758,752591,762216,771417,780373,789010,797312,805239,812892,820173,827179,834000,840489,846927,853057,859017,864811,870418,875899,881218,886353,891398,896247,900920,905462,909847,914175,918363,922332,926285,930215,933951,937629,941074,944439,947738,950926,954014,957155,960178,963077,965900,968781,971470,974252,976859,979418,981898,984387,986764,989064,991312,993448,995675,997830,999946,1001970,1003996,1005989,1007903,1009824,1011719,1013593,1015415,1017212,1018895,1020575,1022240,1023819,1025501,1027033,1028523,1030023,1031512,1032917,1034304,1035689,1037027,1038396,1039689,1040980,1042250,1043522,1044737,1045933,1047100,1048236,1049383,
2,899,7874,24133,48272,77513,109221,141459,173458,204916,235173,264251,291773,317952,342678,366215,388497,409507,429580,448769,466991,484001,500211,515769,530439,544501,558055,571114,583469,595342,606849,617637,628079,638121,647645,656759,665699,674297,682403,690450,698024,705487,712561,719502,726359,732868,739214,745268,751279,757044,762660,768082,773211,778385,783288,788180,792700,797132,801571,805930,809997,814085,818090,821898,825693,829424,832917,836288,839620,842861,846010,849212,852327,855210,858062,860923,863752,866549,869262,871877,874305,876850,879245,881586,883814,886048,888210,890292,892405,894495,896508,898607,900608,902492,904329,906178,907979,909736,911475,913155,914840,916497,918131,919790,921356,922847,924302,925800,927199,928604,930007,931346,932611,933919,935189,936458,937705,938960,940193,941383,
0,295,3790,13981,30609,52339,77203,103514,130468,157770,184331,209899,234630,258446,281515,303254,324028,343940,362956,381226,398472,414762,430225,445295,459591,473319,486348,498949,511062,522699,533839,544638,554824,564658,574138,583212,592062,600670,609012,616833,624594,632152,639242,646210,652859,659396,665723,671890,677819,683662,689233,694713,699935,705023,710024,714883,719524,724047,728466,732731,737018,741126,745194,749018,752797,756510,760106,763495,766925,770218,773543,776685,779870,782848,785753,788669,791428,794232,797014,799702,802172,804654,807122,809528,811756,814092,816354,818557,820723,822880,825068,827064,829123,831119,833073,834949,836779,838546,840287,842049,843790,845406,847059,848634,850225,851760,853331,854815,856320,857722,859270,860670,862045,863422,864707,866013,867279,868526,869790,870987,
0,93,1621,7088,17514,32633,50961,71426,93159,115288,137423,159655,181066,201962,222195,241812,260766,279063,296500,313301,329260,344585,359230,373367,386988,400038,412492,424773,436475,447674,458402,468857,479033,488694,497861,506838,515465,523826,532105,539873,547361,554726,561871,568742,575397,581686,587878,593886,599753,605466,610927,616206,621423,626500,631539,636382,640907,645443,649875,654126,658358,662430,666424,670221,674007,677710,681450,684924,688373,691828,695082,698240,701355,704426,707288,710210,713052,715884,718578,721295,723865,726488,728870,731271,733661,735959,738193,740410,742706,744878,746990,749008,751064,753034,755026,756990,758857,760736,762499,764249,765953,767656,769384,771008,772657,774229,775815,777364,778873,780340,781820,783263,784675,786117,787433,788720,790044,791355,792632,793847,
0,25,566,3075,8862,18087,29959,44401,60349,77197,94841,112782,130673,148402,165725,182638,199246,215201,230510,245396,259804,273781,287351,300432,313104,325203,336777,348427,359359,369939,380263,390049,399532,408761,417657,426166,434483,442385,450233,457715,465029,472172,479033,485830,492216,498445,504675,510704,516287,521957,527362,532642,537733,542786,547652,552358,556871,561404,565807,570146,574393,578490,582452,586347,590185,593794,597356,600910,604362,607706,610952,614186,617312,620412,623418,626439,629342,632101,634809,637496,640142,642792,645304,647768,650268,652641,654989,657255,659445,661522,663619,665776,667857,669794,671867,673829,675656,677507,679316,681188,682955,684742,686473,688073,689694,691307,692806,694435,695960,697470,698972,700483,701887,703227,704590,705911,707203,708499,709798,711017,
0,3,142,1039,3650,8330,15206,24276,34867,46776,59586,72937,86734,100548,114277,127967,141614,154858,167916,180715,193536,205758,217612,229023,240083,251055,261619,271867,281702,291219,300584,309732,318499,327100,335274,343314,351187,358670,366000,373008,379790,386589,393106,399588,405763,411788,417655,423266,428803,434191,439311,444498,449361,454300,458999,463686,468148,472510,476827,480905,484972,488879,492751,496521,500252,503896,507435,510975,514320,517617,520769,523960,526951,530011,533042,535931,538748,541538,544196,546829,549454,552067,554556,557034,559489,561865,564099,566330,568589,570782,572952,575043,577132,579213,581240,583084,585005,586783,588643,590440,592166,593905,595631,597341,598978,600594,602193,603770,605235,606707,608256,609754,611118,612545,613876,615247,616614,617963,619249,620492,
0,0,26,263,1038,2960,6119,10676,16686,23793,31962,40701,49934,59684,69704,79875,90003,100203,110290,120570,130750,140789,150427,160009,169358,178627,187682,196503,205083,213522,221805,229796,237627,245269,252613,259714,266699,273508,280086,286393,292698,298903,304960,310860,316501,321993,327516,332712,337869,342824,347782,352620,357385,361901,366333,370653,374906,379108,383175,387161,391118,394952,398682,402297,405715,409152,412601,415866,419160,422401,425447,428442,431416,434397,437313,440103,442880,445616,448211,450765,453356,455905,458321,460744,463084,465391,467591,469782,471910,474048,476112,478163,480175,482115,484030,485930,487847,489647,491425,493207,495028,496775,498423,500037,501672,503195,504743,506307,507777,509272,510707,512207,513617,514950,516280,517626,518980,520279,521616,522916,
0,0,4,49,276,890,2213,4300,7355,11169,15878,21222,27146,33510,40327,47552,54984,62542,70364,78143,85857,93653,101479,109205,116854,124424,131907,139217,146306,153380,160315,167118,173763,180245,186594,192960,199214,205090,210963,216614,222361,227992,233394,238664,243923,248830,253715,258423,262974,267526,272076,276494,280651,284765,288712,292674,296513,300364,304126,307796,311335,314927,318356,321753,325157,328435,331617,334696,337683,340606,343399,346294,349083,351872,354602,357376,360029,362507,364993,367497,369957,372344,374700,376965,379208,381322,383528,385641,387692,389811,391834,393792,395789,397678,399547,401376,403148,404916,406697,408407,410067,411761,413377,415013,416555,418134,419659,421133,422589,424011,425480,426907,428271,429600,430976,432301,433550,434823,436104,437366,
0,0,0,3,39,187,558,1235,2280,3850,5862,8521,11720,15268,19257,23469,28052,32930,37886,43139,48278,53587,59134,64668,70218,75868,81459,86882,92316,97620,102971,108274,113462,118730,123705,128709,133606,138597,143514,148259,152806,157319,161817,166276,170591,174884,179120,183224,187246,191112,195045,198870,202699,206443,209964,213446,216879,220189,223562,226841,230059,233244,236314,239346,242316,245225,248117,251016,253797,256508,259219,261823,264372,266959,269464,271857,274256,276509,278825,281111,283353,285577,287697,289905,291974,293977,295996,297998,299958,301843,303728,305491,307291,309085,310841,312584,314282,315965,317620,319222,320757,322287,323777,325178,326705,328175,329620,331048,332399,333739,335137,336563,337855,339178,340429,341605,342850,344053,345219,346352,
0,0,0,0,1,23,77,181,443,864,1518,2365,3519,4931,6601,8435,10587,12992,15504,18258,21063,24107,27275,30447,33757,37132,40527,44065,47691,51168,54618,58286,61864,65377,68871,72577,76144,79747,83230,86745,90120,93533,96904,100345,103643,106919,110241,113314,116419,119572,122586,125643,128648,131630,134378,137181,139988,142793,145489,148105,150793,153253,155862,158382,160935,163396,165871,168203,170559,172854,175137,177377,179533,181646,183765,185781,187789,189795,191815,193757,195676,197550,199427,201178,202935,204697,206537,208285,209997,211673,213264,214904,216485,218116,219605,221135,222634,224052,225455,226866,228274,229645,231023,232353,233658,234938,236226,237561,238811,240109,241309,242571,243837,245037,246169,247326,248469,249565,250684,251787,
0,0,0,0,0,2,4,12,35,82,144,277,494,775,1133,1590,2163,2844,3628,4539,5544,6606,7731,9001,10386,11800,13258,14830,16502,18320,20021,21784,23610,25488,27483,29429,31368,33345,35284,37299,39354,41419,43380,45446,47455,49443,51461,53467,55486,57434,59413,61420,63332,65240,67227,69199,71117,73036,74899,76709,78525,80365,82093,83948,85713,87506,89246,90945,92554,94208,95873,97500,99135,100743,102292,103889,105436,106990,108452,109869,111371,112723,114114,115489,116894,118192,119502,120779,122110,123446,124689,125935,127181,128455,129666,130900,132123,133324,134454,135575,136733,137828,138924,140025,141103,142183,143240,144279,145337,146315,147370,148365,149300,150265,151219,152120,153068,153962,154863,155767,
122310,384767,589294,738603,851864,941089,1013605,1073987,1124865,1168331,1206067,1239587,1268913,1295052,1318812,1340177,1359687,1377507,1394060,1409168,1423408,1436696,1448959,1460335,1471049,1481265,1490722,1499651,1508092,1516046,1523691,1530776,1537641,1544171,1550337,1556201,1561870,1567197,1572382,1577368,1582083,1586675,1591047,1595217,1599256,1603153,1606855,1610483,1613920,1617402,1620735,1623892,1626799,1629774,1632577,1635391,1638061,1640632,1643102,1645511,1647798,1650100,1652364,1654562,1656647,1658640,1660600,1662502,1664446,1666320,1668140,1669894,1671571,1673260,1674837,1676420,1677931,1679428,1680920,1682302,1683714,1685039,1686433,1687743,1688988,1690178,1691448,1692642,1693776,1694903,1696012,1697057,1698130,1699240,1700292,1701266,1702206,1703161,1704101,1705032,1705868,1706739,1707649,1708498,1709347,1710191,1710983,1711790,1712588,1713310,1714088,1714836,1715535,1716291,1717024,1717685,1718379,1719024,1719655,1720300,
48022,225356,398084,536533,647181,737319,811742,874508,928303,975002,1015677,1051878,1084279,1113353,1139325,1162946,1184783,1204725,1223069,1240024,1255921,1270556,1284530,1297428,1309526,1321204,1331630,1341635,1351126,1360175,1368778,1376778,1384768,1392131,1399245,1405902,1412220,1418270,1424091,1429757,1435182,1440219,1445217,1449962,1454600,1458902,1463143,1467264,1471206,1475070,1478791,1482378,1485878,1489297,1492405,1495593,1498639,1501621,1504551,1507344,1509955,1512687,1515193,1517679,1520164,1522483,1524745,1526974,1529199,1531297,1533378,1535412,1537332,1539214,1541043,1542856,1544634,1546362,1547969,1549624,1551196,1552737,1554296,1555842,1557314,1558716,1560146,1561532,1562923,1564192,1565439,1566709,1567992,1569201,1570404,1571529,1572703,1573762,1574901,1575949,1577007,1578033,1578959,1579980,1580942,1581904,1582877,1583801,1584703,1585615,1586490,1587316,1588163,1588996,1589824,1590621,1591392,1592134,1592881,1593596,
23791,152318,298650,425753,531281,619311,693184,756811,811366,859203,901378,938490,971847,1002099,1029398,1054081,1076906,1097884,1117076,1134992,1151744,1167179,1181711,1195300,1207952,1220181,1231544,1242217,1252302,1261926,1271184,1279783,1288163,1295827,1303253,1310552,1317524,1324205,1330515,1336602,1342340,1347766,1353171,1358266,1363172,1367904,1372366,1376887,1381145,1385275,1389256,1393036,1396770,1400385,1403931,1407334,1410636,1413879,1417014,1419977,1422921,1425710,1428454,1431212,1433747,1436246,1438691,1441150,1443498,1445855,1448054,1450308,1452377,1454348,1456322,1458296,1460180,1462044,1463836,1465607,1467297,1468949,1470623,1472270,1473790,1475308,1476848,1478357,1479842,1481239,1482583,1484027,1485341,1486594,1487909,1489076,1490302,1491432,1492661,1493799,1494922,1496069,1497150,1498240,1499281,1500326,1501328,1502315,1503266,1504257,1505152,1506041,1506970,1507886,1508757,1509652,1510503,1511370,1512202,1512988,
9124,88638,202230,311120,406858,489592,560832,622548,676943,724999,767398,805529,839528,870810,899086,924924,948637,970567,990943,1009880,1027364,1043483,1059010,1073619,1087237,1099973,1112096,1123561,1134283,1144486,1154311,1163673,1172458,1180856,1188816,1196434,1203856,1210994,1217808,1224297,1230462,1236288,1242072,1247674,1253006,1258139,1263005,1267857,1272477,1276936,1281218,1285414,1289425,1293290,1297082,1300798,1304461,1307892,1311411,1314643,1317749,1320785,1323787,1326647,1329515,1332190,1334834,1337443,1339944,1342450,1344855,1347237,1349525,1351690,1353848,1355996,1358026,1359997,1361899,1363874,1365761,1367590,1369367,1371183,1372907,1374551,1376235,1377795,1379359,1380899,1382381,1383888,1385350,1386739,1388173,1389569,1390917,1392218,1393449,1394774,1396044,1397213,1398360,1399492,1400646,1401765,1402829,1403901,1404955,1405967,1406964,1407983,1408926,1409852,1410828,1411758,1412690,1413617,1414476,1415376,
2139,40542,116189,199600,279221,352012,416947,475144,526788,573281,614933,652625,686854,717516,746394,772969,797328,819717,840844,860275,878556,895788,911790,926924,941344,954940,967654,979707,991201,1002185,1012454,1022263,1031641,1040629,1049208,1057535,1065457,1073187,1080476,1087490,1094079,1100412,1106498,1112546,1118303,1123703,1129055,1134163,1139104,1143945,1148672,1153168,1157497,1161739,1165923,1169882,1173644,1177477,1181172,1184735,1188076,1191472,1194667,1197819,1200914,1203805,1206702,1209581,1212411,1215131,1217816,1220374,1222845,1225280,1227573,1229877,1232152,1234325,1236517,1238657,1240664,1242607,1244498,1246367,1248290,1250074,1251858,1253628,1255311,1256971,1258684,1260328,1261953,1263460,1265027,1266527,1268028,1269377,1270738,1272057,1273449,1274766,1276078,1277409,1278575,1279884,1281075,1282234,1283388,1284546,1285668,1286743,1287738,1288808,1289819,1290831,1291797,1292778,1293771,1294683,
855,24035,79685,148209,217212,282327,342904,397364,446886,491455,532100,569363,603291,634312,662777,689151,713356,735840,756883,776431,795021,812317,828453,843934,858395,872067,885132,897554,909385,920582,931112,941268,950986,960261,968980,977522,985795,993685,1001118,1008364,1015223,1021845,1028202,1034562,1040519,1046342,1051878,1057179,1062271,1067277,1072148,1076883,1081374,1085773,1089943,1094147,1098136,1102034,1105957,1109626,1113116,1116543,1119930,1123228,1126478,1129576,1132633,1135634,1138604,1141374,1144096,1146698,1149237,1151740,1154188,1156561,1158848,1161183,1163486,1165765,1167807,1169880,1171920,1173903,1175913,1177835,1179669,1181537,1183299,1185023,1186748,1188445,1190179,1191837,1193437,1194983,1196486,1197943,1199385,1200771,1202195,1203536,1204871,1206185,1207530,1208835,1210061,1211261,1212455,1213638,1214823,1215969,1217100,1218201,1219259,1220307,1221275,1222331,1223333,1224334,
231,12518,50180,102568,159499,215830,269170,319376,365456,407295,445684,480911,513681,543992,572357,598064,622150,644657,665848,685475,704032,721320,737643,752990,767839,781784,795032,807487,819436,830723,841561,851915,861830,871249,880228,888897,897388,905419,913089,920539,927590,934424,941094,947413,953525,959538,965188,970678,976048,981279,986259,991194,995842,1000315,1004754,1009121,1013392,1017345,1021224,1025129,1028776,1032471,1035991,1039376,1042731,1045803,1048924,1051966,1054897,1057775,1060538,1063284,1065993,1068569,1071169,1073741,1076160,1078556,1080859,1083136,1085331,1087463,1089568,1091633,1093639,1095645,1097614,1099643,1101480,1103327,1105041,1106815,1108581,1110314,1112031,1113662,1115268,1116886,1118448,1119940,1121427,1122880,1124269,1125608,1126967,1128240,1129537,1130874,1132180,1133472,1134654,1135834,1137011,1138145,1139240,1140347,1141376,1142380,1143427,1144471,
53,5354,27682,63433,106875,152579,197679,240868,281598,319740,355558,388615,419220,448127,474987,500009,523762,545338,566083,585617,604082,621366,637569,652831,667544,681456,694591,707140,719240,730611,741639,752033,761981,771568,780757,789710,798193,806550,814547,822212,829442,836477,843250,849728,855960,862046,867986,873594,879119,884675,889817,894911,899814,904601,909122,913607,917954,922210,926302,930244,934100,937798,941433,945022,948501,951787,955045,958236,961311,964301,967217,969986,972749,975442,978157,980821,983403,985899,988330,990753,993066,995263,997467,999627,1001803,1003824,1005862,1007813,1009719,1011677,1013562,1015337,1017199,1018957,1020737,1022456,1024165,1025793,1027373,1028963,1030534,1032046,1033581,1034984,1036432,1037797,1039158,1040584,1041889,1043202,1044506,1045803,1046978,1048239,1049410,1050597,1051715,1052816,1053890,1054990,
9,1784,12443,33901,63008,96615,131690,166857,200919,233963,265600,295029,322707,348814,373571,397100,419419,440364,460286,479037,496470,513291,529330,544341,558731,572487,585546,598005,609900,621420,632281,642741,652929,662570,671811,680611,689241,697527,705508,713160,720440,727641,734427,741080,747452,753811,759775,765600,771429,776919,782314,787611,792642,797463,802037,806577,810976,815309,819470,823534,827489,831302,835056,838751,842352,845851,849308,852595,855692,858783,861939,864936,867855,870555,873432,876206,878880,881467,884002,886546,888956,891242,893518,895759,897877,900040,902180,904171,906170,908194,910086,912073,913985,915832,917664,919373,921139,922811,924517,926237,927886,929482,930981,932552,934118,935566,936988,938436,939778,941103,942376,943650,944831,946072,947317,948569,949793,951006,952158,953271,
1,738,6768,21083,42507,68666,97142,126669,156238,185098,213004,239847,265402,289484,312658,334659,355670,375538,394780,412477,429370,445649,461006,476077,490200,503621,516505,528782,540479,551751,562603,573047,583014,592407,601582,610315,618861,627085,635134,642754,650104,657320,664091,670748,677302,683473,689551,695458,701203,706754,711928,717157,722180,727080,731828,736494,740999,745323,749642,753666,757741,761693,765475,769227,772789,776276,779739,783108,786312,789489,792631,795662,798696,801614,804339,807127,809903,812517,815151,817633,820103,822514,824899,827150,829388,831609,833768,835915,837981,840020,841997,843988,845892,847793,849647,851351,853039,854748,856453,858203,859842,861443,863063,864592,866138,867547,868921,870353,871775,873184,874574,875908,877224,878478,879732,881004,882225,883437,884609,885776,
0,236,3099,11478,25798,44678,66448,89881,114093,138366,162887,186302,208986,230873,251969,272150,291263,309940,327639,344434,360687,376033,390463,404508,417998,431002,443543,455382,466767,477699,488275,498543,508347,517869,526828,535686,543992,552258,560035,567492,574772,581871,588658,595355,601664,607780,613928,619790,625471,631104,636414,641693,646624,651420,656230,660830,665214,669561,673850,678004,682036,685998,689969,693593,697262,700879,704306,707650,710919,714195,717352,720380,723448,726318,729140,731950,734630,737284,739926,742511,745034,747499,749937,752287,754499,756806,758974,761189,763256,765308,767362,769403,771401,773330,775145,776989,778791,780542,782267,784047,785796,787503,789092,790656,792149,793640,795154,796631,798080,799456,800812,802253,803603,804871,806190,807457,808714,809949,811179,812346,
0,67,1130,5347,13628,25935,41382,58749,77429,96675,116239,135995,155044,173936,192314,210302,227405,244177,259963,275399,290343,304595,318194,331482,344107,356470,368184,379525,390272,400719,410828,420561,429934,439209,447923,456400,464601,472495,480296,487689,494848,501675,508130,514704,520951,527128,533124,538834,544521,549813,555176,560276,565205,570157,574894,579484,583882,588191,592395,596572,600608,604570,608455,612163,615811,619366,622726,626129,629328,632588,635826,638792,641809,644794,647733,650537,653161,655826,658502,661120,663579,666125,668540,670881,673220,675505,677742,679925,682121,684133,686157,688104,690072,692020,693821,695750,697561,699376,701121,702858,704588,706271,707876,709524,711157,712735,714256,715742,717206,718631,720069,721586,722976,724282,725574,726872,728157,729418,730607,731836,
0,11,315,1968,6102,13079,22631,34352,47321,61598,76723,91937,107371,122486,137592,152717,167317,181706,195581,208997,222115,234777,247013,258893,270185,281389,292146,302608,312613,322274,331518,340683,349509,357895,366135,374101,381794,389415,396601,403622,410545,417099,423509,429915,435967,441797,447682,453332,458801,464123,469277,474390,479296,483949,488526,493076,497374,501720,505856,509934,513827,517700,521431,525039,528550,532027,535395,538832,542135,545364,548509,551472,554514,557462,560255,563074,565881,568542,571123,573745,576217,578672,581150,583507,585831,588119,590288,592449,594588,596715,598774,600867,602804,604726,606579,608464,610294,612045,613762,615552,617282,618973,620638,622275,623828,625383,626845,628312,629750,631202,632691,634127,635488,636805,638148,639449,640698,641942,643185,644420,
0,1,61,529,2074,5187,9979,16574,24692,33644,43708,54260,65341,76618,88026,99523,110843,122356,133586,144551,155336,165981,176467,186515,196341,206088,215340,224492,233423,242072,250470,258736,266659,274356,281879,289242,296289,303278,309878,316312,322551,328855,334777,340643,346388,351786,357268,362542,367558,372520,377439,382221,386987,391545,395942,400233,404345,408419,412309,416237,420137,423876,427471,431062,434508,437855,441139,444387,447596,450776,453806,456756,459650,462545,465298,468078,470823,473536,476080,478579,481122,483577,485930,488266,490552,492790,494887,496995,499125,501220,503299,505312,507272,509166,511089,512974,514713,516530,518208,519919,521643,523335,524948,526582,528170,529688,531185,532590,534058,535468,536864,538292,539627,540947,542287,543565,544889,546113,547396,548663,
0,0,10,127,629,1799,4002,7222,11467,16897,23185,30056,37502,45247,53524,62124,70780,79528,88095,96873,105586,114245,122699,131004,139225,147368,155361,163022,170698,178148,185280,192423,199358,206154,212698,219089,225375,231451,237528,243226,248995,254691,260169,265598,270816,275898,280860,285700,290321,294989,299428,303854,308167,312434,316604,320716,324595,328420,332189,335824,339438,342984,346426,349760,353048,356325,359367,362469,365622,368584,371522,374393,377076,379749,382454,385120,387769,390305,392817,395291,397648,399987,402296,404628,406848,408982,411040,413159,415181,417147,419115,421099,422988,424871,426733,428509,430320,432039,433695,435475,437092,438715,440309,441765,443246,444826,446302,447698,449149,450573,451902,453269,454583,455864,457229,458544,459820,461073,462247,463526,
0,0,1,13,87,408,1076,2366,4188,6608,9716,13485,17700,22314,27399,32679,38291,44122,50181,56241,62190,68402,74597,80745,87085,93419,99607,105757,111613,117446,123363,128991,134715,140314,145650,151061,156313,161516,166651,171663,176570,181289,186068,190584,195160,199547,203777,207985,212093,216010,220006,223882,227757,231614,235221,238824,242331,245789,249189,252508,255810,259040,262136,265088,268061,271029,273851,276650,279485,282182,284877,287537,290093,292607,295069,297542,299936,302317,304682,306956,309225,311388,313500,315662,317696,319676,321594,323512,325436,327318,329223,331082,332852,334622,336331,338007,339693,341383,343033,344636,346192,347760,349306,350757,352192,353674,355049,356441,357788,359134,360504,361831,363175,364503,365717,366944,368131,369296,370449,371592,
0,0,0,1,7,45,172,424,870,1593,2651,4033,5638,7722,10027,12572,15358,18370,21590,25031,28601,32284,36164,40095,43956,48072,52043,56073,60119,64229,68429,72420,76381,80502,84465,88514,92462,96392,100290,104041,107792,111431,115056,118626,122158,125644,129174,132531,135786,139090,142387,145634,148778,151798,154779,157767,160742,163612,166412,169205,171923,174543,177194,179743,182275,184762,187153,189647,191995,194316,196580,198800,201023,203158,205210,207328,209427,211560,213572,215533,217542,219569,221532,223401,225179,227031,228770,230482,232202,233950,235631,237286,238892,240442,241943,243517,245030,246520,247970,249457,250800,252281,253684,255040,256425,257677,258936,260234,261465,262679,263895,265101,266333,267475,268656,269813,270947,272051,273143,274146,
0,0,0,0,0,0,7,23,68,173,328,584,923,1356,1943,2665,3544,4553,5637,6847,8198,9620,11262,12890,14678,16513,18408,20318,22333,24481,26611,28810,31053,33218,35451,37757,39937,42274,44577,46866,49230,51519,53909,56199,58519,60802,62973,65233,67409,69555,71739,73751,75779,77925,80048,82121,84209,86295,88234,90174,92154,94143,96006,97897,99770,101612,103491,105221,107044,108827,110537,112235,114016,115713,117395,119011,120584,122158,123694,125212,126735,128239,129767,131183,132619,134032,135443,136807,138218,139544,140891,142198,143602,144847,146085,147364,148595,149802,151000,152160,153327,154449,155601,156745,157883,158957,160050,161106,162132,163170,164215,165255,166217,167272,168236,169197,170137,171033,172007,172941,
25113,195943,402850,583415,734099,859017,963662,1052694,1128531,1195030,1252773,1303361,1348613,1388871,1424983,1457969,1488042,1515326,1540150,1562935,1584028,1603529,1621521,1638263,1653818,1668240,1681592,1694367,1706256,1717324,1727758,1737511,1746896,1755762,1763903,1771834,1779658,1786739,1793601,1800039,1806164,1812014,1817480,1822843,1828039,1833003,1837713,1842160,1846451,1850655,1854605,1858243,1861864,1865341,1868707,1871983,1875156,1878120,1881015,1883776,1886469,1889050,1891490,1893861,1896265,1898449,1900546,1902600,1904663,1906722,1908594,1910405,1912176,1913877,1915592,1917142,1918776,1920316,1921823,1923284,1924704,1926114,1927415,1928783,1930079,1931310,1932513,1933622,1934721,1935840,1936860,1937935,1938966,1939948,1940885,1941844,1942783,1943666,1944535,1945357,1946167,1946959,1947733,1948486,1949242,1949960,1950701,1951357,1952020,1952715,1953350,1953994,1954619,1955224,1955777,1956332,1956889,1957425,1957975,1958501,
2128,53512,164734,291292,413121,524749,623842,711830,790555,860440,922718,978501,1028448,1073725,1114693,1152196,1186598,1218466,1247782,1274962,1300165,1323488,1345106,1365344,1384299,1402080,1418855,1434662,1449329,1462918,1476038,1488294,1499968,1511057,1521354,1531213,1540571,1549483,1558042,1566169,1573898,1581091,1588147,1594957,1601412,1607421,1613395,1618967,1624330,1629729,1634821,1639659,1644267,1648675,1652925,1657071,1661065,1664927,1668661,1672186,1675591,1678969,1682107,1685192,1688188,1691069,1693927,1696628,1699269,1701811,1704272,1706692,1709006,1711262,1713482,1715582,1717645,1719688,1721595,1723423,1725263,1727029,1728748,1730384,1731986,1733548,1735109,1736617,1738053,1739409,1740804,1742113,1743461,1744745,1745915,1747145,1748332,1749422,1750535,1751660,1752746,1753788,1754824,1755818,1756814,1757782,1758702,1759555,1760428,1761252,1762064,1762924,1763698,1764486,1765261,1765991,1766737,1767469,1768182,1768870,
232,17069,75386,159782,252547,343913,430504,510515,584050,650714,711430,766845,817478,864379,907082,946279,982403,1015810,1046596,1075786,1102394,1127593,1150829,1172987,1193313,1212800,1230861,1248136,1264268,1279489,1293858,1307369,1320273,1332433,1344043,1355054,1365554,1375494,1385054,1394233,1402872,1411343,1419338,1427010,1434383,1441469,1448247,1454727,1460850,1466741,1472370,1477977,1483240,1488295,1493143,1497837,1502363,1506783,1510914,1514892,1518777,1522565,1526158,1529642,1532966,1536374,1539572,1542774,1545776,1548683,1551447,1554205,1556859,1559429,1562029,1564453,1566813,1569058,1571244,1573407,1575527,1577603,1579637,1581514,1583332,1585138,1586856,1588549,1590257,1591857,1593476,1595070,1596582,1598095,1599530,1600952,1602338,1603640,1604940,1606251,1607430,1608713,1609893,1611066,1612199,1613300,1614408,1615461,1616529,1617503,1618437,1619430,1620340,1621197,1622078,1622944,1623811,1624638,1625498,1626299,
5,2966,22591,63302,118311,179671,243687,306695,367469,424718,478719,529116,576066,620383,661724,699824,735272,768467,799965,828967,856471,882600,907222,930288,951964,972076,991067,1009448,1026742,1042873,1058338,1072838,1086632,1099935,1112845,1125117,1136762,1147852,1158305,1168427,1178143,1187339,1196181,1204668,1212697,1220520,1228140,1235311,1242228,1249045,1255575,1261632,1267644,1273362,1278756,1284091,1289234,1294289,1299043,1303748,1308180,1312549,1316591,1320591,1324594,1328371,1331949,1335496,1338961,1342353,1345564,1348703,1351815,1354826,1357760,1360468,1363152,1365829,1368454,1370940,1373363,1375722,1378085,1380309,1382557,1384658,1386689,1388718,1390692,1392575,1394459,1396254,1397927,1399669,1401310,1402952,1404600,1406237,1407753,1409197,1410681,1412047,1413378,1414766,1416049,1417318,1418589,1419759,1420947,1422129,1423257,1424379,1425469,1426537,1427531,1428539,1429529,1430481,1431450,1432350,
0,178,3199,14402,35205,64121,99338,137589,177127,217029,256467,295158,332663,368871,403165,436167,467612,497396,525543,552511,578016,602392,625645,647729,668494,688646,707695,725806,743125,759670,775509,790479,804782,818500,831813,844307,856497,868062,878923,889419,899732,909530,918851,928044,936762,945089,953104,960837,968268,975295,982263,988974,995465,1001636,1007559,1013455,1019009,1024499,1029769,1034907,1039820,1044621,1049264,1053781,1058066,1062155,1066217,1070055,1073933,1077648,1081232,1084819,1088293,1091522,1094744,1097801,1100856,1103803,1106662,1109508,1112210,1114876,1117438,1119926,1122283,1124721,1126978,1129255,1131451,1133719,1135832,1137877,1139887,1141760,1143775,1145694,1147504,1149328,1151015,1152705,1154373,1155944,1157527,1159039,1160546,1162023,1163452,1164975,1166329,1167650,1168968,1170250,1171490,1172718,1173978,1175134,1176260,1177416,1178580,1179651,
0,23,810,5136,15286,31095,52419,77805,105722,135337,165893,196598,226931,256391,285450,313690,340895,367015,391933,416244,439524,461674,483101,503544,523347,541945,559741,576746,593104,608990,623906,638542,652469,665869,678589,690806,702428,713554,724618,735248,745348,755140,764559,773584,782198,790574,798713,806542,814189,821547,828702,835436,841983,848362,854530,860552,866345,871915,877280,882533,887581,892543,897275,901786,906333,910694,914834,919013,922987,926797,930480,934132,937656,941208,944527,947717,950851,953976,957008,959924,962806,965676,968380,970954,973535,976005,978452,980821,983140,985400,987555,989625,991713,993805,995761,997764,999680,1001551,1003374,1005132,1006962,1008687,1010331,1011934,1013535,1015100,1016612,1018102,1019561,1021044,1022399,1023769,1025060,1026294,1027553,1028723,1029895,1031087,1032228,1033327,
0,4,165,1398,5154,12457,23493,37894,55127,74522,95290,117306,139482,161817,184287,206600,228668,250062,271007,291200,311173,330446,349001,367070,384613,401188,417318,432834,447566,462115,476129,489659,502629,515093,527219,538745,549935,560754,571184,581259,590804,600153,609272,617783,626164,634497,642375,650200,657586,664730,671674,678316,684872,691093,697192,703025,708683,714248,719560,724690,729851,734686,739427,744013,748569,752914,757047,761174,765278,769151,772934,776645,780320,783824,787118,790412,793696,796853,799930,802957,805826,808558,811341,813996,816564,819015,821532,824018,826409,828576,830834,833081,835163,837339,839297,841315,843299,845209,847097,848857,850692,852422,854081,855879,857531,859147,860768,862283,863735,865142,866566,867915,869292,870610,871932,873175,874464,875739,876984,878120,
0,0,16,248,1284,3875,8467,15381,24304,34993,47272,61054,75676,90957,106720,122910,139167,155551,171705,187630,203367,218759,233700,248540,262969,277206,290905,304195,317115,329682,341905,353672,365135,376156,387000,397266,407414,417302,426928,435881,444881,453365,461754,469721,477505,484987,492238,499312,506262,513073,519583,525943,531982,538013,543851,549399,554774,560118,565267,570309,575131,579853,584479,588850,593287,597484,601694,605598,609594,613374,617091,620729,624226,627695,630991,634335,637506,640582,643556,646577,649493,652421,655207,657839,660525,663050,665535,667895,670228,672546,674920,677088,679236,681270,683289,685342,687256,689232,691181,693015,694867,696608,698309,699916,701594,703225,704801,706375,707914,709354,710806,712241,713668,715072,716417,717776,719033,720271,721464,722661,
0,0,0,33,240,903,2391,4999,8783,13858,20125,27583,35849,44843,54667,64958,75561,86361,97423,108775,120064,131527,142784,153996,164971,175826,186574,197079,207306,217396,227307,237001,246540,255683,264767,273399,281829,290147,298108,306068,313867,321287,328567,335702,342495,349246,355740,362037,368206,374239,380068,385847,391337,396675,401936,407005,412052,417035,421808,426364,430823,435216,439496,443673,447714,451654,455488,459184,462864,466522,470094,473474,476804,480084,483280,486446,489492,492432,495300,498112,500829,503512,506161,508704,511277,513714,516055,518459,520733,523015,525212,527349,529435,531554,533578,535500,537442,539301,541145,542994,544731,546422,548130,549804,551441,553028,554642,556120,557582,559057,560516,561911,563295,564692,565933,567214,568446,569670,570941,572110,
0,0,0,7,69,313,977,2200,4231,7122,10890,15567,20868,26884,33479,40684,48326,56360,64676,73251,81944,90809,99711,108688,117546,126433,135466,144209,152819,161548,169742,177860,186009,193874,201645,209397,216824,223850,231040,238023,244810,251545,258133,264339,270444,276464,282456,288096,293645,299073,304494,309695,314662,319648,324414,329037,333611,338138,342445,346771,350910,354936,358896,362756,366566,370364,373952,377484,380984,384400,387723,390916,394080,397118,400096,403007,405913,408816,411519,414159,416755,419258,421762,424210,426651,428912,431147,433403,435599,437665,439749,441810,443752,445686,447598,449396,451209,453004,454698,456496,458220,459893,461534,463219,464761,466296,467802,469282,470683,472113,473468,474874,476184,477462,478751,480014,481210,482440,483572,484693,
0,0,0,0,11,101,322,837,1742,3178,5192,7784,10955,14647,18998,23839,29035,34625,40388,46743,53187,59678,66526,73321,80180,87140,94015,100959,107716,114613,121310,128074,134749,141269,147797,154190,160566,166906,172912,178856,184794,190540,196263,201774,207154,212365,217544,222676,227652,232536,237267,241946,246621,251036,255304,259551,263671,267679,271636,275594,279449,283215,286782,290385,293871,297231,300598,303815,306930,310036,313018,315997,318898,321759,324525,327299,330000,332566,335131,337627,340092,342421,344732,346941,349215,351432,353685,355752,357781,359821,361747,363659,365586,367381,369250,371070,372789,374428,376147,377757,379382,380923,382438,384001,385466,386943,388351,389772,391138,392512,393792,395053,396344,397616,398892,400109,401289,402405,403526,404719,
0,0,0,1,5,20,82,250,634,1287,2206,3562,5306,7391,9981,13006,16292,19883,23851,27914,32284,36975,41805,46768,51827,56882,62158,67414,72812,78098,83413,88659,93915,99256,104423,109601,114756,119878,124852,129770,134495,139253,144033,148708,153160,157634,162098,166445,170664,174847,178930,182873,186740,190673,194379,198141,201831,205379,209039,212360,215731,218947,222247,225484,228573,231572,234536,237483,240340,243144,245867,248559,251225,253698,256235,258830,261254,263604,265941,268238,270440,272584,274754,276869,279011,280984,283026,285031,286989,288833,290637,292485,294256,295931,297601,299245,300927,302563,304153,305666,307124,308566,309979,311423,312759,314126,315474,316786,318096,319360,320669,321882,323031,324228,325358,326526,327642,328679,329738,330805,
0,0,0,0,0,3,26,78,204,424,817,1434,2272,3367,4690,6242,8068,10212,12684,15330,18138,21216,24380,27707,31116,34699,38303,42015,45839,49708,53557,57450,61325,65197,69145,73044,77073,81061,85038,88871,92738,96569,100327,104180,107894,111505,115047,118621,122031,125387,128680,131966,135232,138418,141620,144676,147797,150803,153727,156605,159479,162321,165059,167761,170440,173040,175631,178106,180635,183139,185557,187920,190224,192509,194735,196878,198969,201088,203185,205203,207219,209180,211034,212949,214805,216565,218320,219987,221744,223374,224938,226574,228151,229693,231199,232688,234095,235594,237026,238430,239819,241227,242515,243811,245046,246302,247502,248652,249895,251042,252169,253319,254444,255553,256669,257701,258673,259722,260704,261697,
0,0,0,0,0,0,1,11,45,118,255,464,780,1211,1841,2561,3449,4488,5707,7141,8738,10495,12348,14331,16491,18670,21035,23367,25955,28484,31180,33905,36592,39358,42182,45029,47890,50767,53623,56526,59412,62180,64921,67826,70754,73590,76364,79090,81764,84459,87236,89868,92453,95128,97686,100201,102706,105144,107536,109910,112271,114587,116868,119167,121387,123585,125679,127754,129847,131975,134012,136036,137998,139923,141861,143671,145472,147266,148995,150721,152444,154114,155750,157333,158947,160563,162034,163545,165038,166495,167942,169331,170734,172095,173406,174648,176006,177280,178516,179724,180926,182067,183279,184409,185476,186662,187786,188849,189885,190874,191878,192876,193842,194829,195767,196734,197713,198635,199553,200476,
0,0,0,0,0,0,0,4,7,28,66,124,249,412,678,985,1404,1949,2622,3360,4210,5162,6215,7412,8749,10117,11609,13093,14745,16470,18309,20135,22010,23864,25799,27853,29961,32012,34014,36143,38252,40396,42486,44668,46788,48900,51033,53138,55250,57327,59424,61534,63596,65643,67646,69655,71590,73585,75484,77380,79294,81194,83056,84868,86650,88454,90216,91934,93598,95386,96974,98575,100157,101759,103355,104873,106461,107923,109499,110999,112457,113829,115216,116563,117893,119188,120459,121760,123040,124277,125496,126761,127968,129124,130264,131432,132549,133677,134751,135826,136931,137959,139010,140039,141058,142001,142909,143876,144797,145711,146617,147485,148409,149245,150091,150913,151708,152509,153271,154030,
0,0,0,0,0,0,0,1,2,9,22,47,85,144,246,378,549,782,1046,1410,1840,2333,2864,3438,4021,4799,5621,6463,7457,8534,9584,10668,11770,12922,14134,15452,16780,18116,19461,20849,22217,23609,25038,26452,27921,29398,30878,32336,33851,35392,36906,38409,39911,41358,42819,44301,45811,47238,48671,50193,51607,53055,54468,55871,57249,58601,60017,61320,62686,63952,65215,66514,67817,69101,70339,71562,72761,73979,75197,76424,77642,78797,79966,81101,82183,83273,84401,85464,86489,87487,88528,89511,90520,91487,92435,93355,94279,95218,96119,96987,97878,98753,99641,100500,101358,102149,102952,103736,104526,105357,106201,106907,107606,108392,109109,109806,110504,111185,111863,112571,
0,0,0,0,0,0,0,0,0,0,2,5,14,26,43,79,130,193,283,407,551,695,913,1182,1476,1788,2185,2588,3011,3485,3988,4586,5113,5733,6406,7055,7797,8527,9288,10146,10922,11747,12630,13550,14424,15314,16280,17204,18162,19157,20115,21096,22074,23052,24042,25019,25966,26912,27856,28801,29726,30689,31614,32597,33582,34556,35477,36409,37379,38305,39229,40190,41102,42003,42860,43802,44663,45534,46453,47325,48205,49089,49948,50781,51567,52343,53150,53901,54688,55458,56237,57016,57772,58506,59240,59953,60648,61365,62088,62780,63475,64189,64853,65514,66165,66800,67466,68077,68675,69288,69941,70549,71093,71689,72284,72847,73383,73924,74475,74976,
0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,9,18,26,39,63,93,138,192,257,328,421,526,642,780,936,1119,1314,1505,1716,1942,2229,2537,2832,3147,3460,3840,4238,4630,5018,5423,5839,6292,6769,7240,7706,8170,8668,9183,9684,10254,10739,11278,11803,12324,12809,13381,13906,14482,15039,15568,16077,16643,17168,17721,18272,18821,19360,19910,20447,21009,21554,22102,22676,23234,23789,24354,24893,25433,25983,26523,27000,27595,28132,28677,29174,29693,30179,30671,31185,31673,32133,32599,33082,33545,34046,34526,34984,35427,35866,36292,36725,37136,37550,37989,38385,38798,39250,39704,40124,40509,40908,41370,41791,42184,42531,
44044,248143,459363,631349,769412,881460,974324,1052690,1119184,1176165,1225536,1268913,1307103,1340894,1371446,1399071,1424399,1447149,1468084,1487211,1505266,1521729,1537006,1551344,1564549,1576680,1588215,1598878,1609194,1618627,1627520,1636011,1643979,1651353,1658471,1665233,1671630,1677664,1683514,1689130,1694465,1699568,1704371,1708982,1713343,1717450,1721497,1725391,1729152,1732800,1736342,1739569,1742736,1745773,1748670,1751484,1754188,1756786,1759318,1761812,1764081,1766430,1768639,1770794,1772917,1774960,1776918,1778750,1780505,1782196,1783895,1785522,1787078,1788641,1790066,1791519,1792916,1794332,1795640,1796925,1798209,1799439,1800624,1801744,1802811,1803939,1805013,1806030,1807024,1808018,1808980,1809877,1810783,1811705,1812549,1813438,1814272,1815130,1815904,1816725,1817503,1818208,1818894,1819541,1820281,1820958,1821589,1822211,1822850,1823462,1824087,1824672,1825263,1825823,1826370,1826905,1827458,1827993,1828504,1828975,
7229,94313,232983,369985,491433,597638,688843,768010,836815,897421,950495,997580,1039775,1077768,1112073,1143489,1172112,1198148,1222201,1244311,1264924,1283941,1301553,1318118,1333446,1347729,1361232,1373996,1385908,1397130,1407677,1417744,1427327,1436292,1444829,1452975,1460707,1468078,1475107,1481723,1488186,1494299,1500111,1505596,1510928,1515993,1520829,1525494,1530041,1534451,1538600,1542595,1546478,1550188,1553743,1557295,1560698,1563790,1566802,1569827,1572657,1575462,1578163,1580740,1583190,1585651,1587970,1590180,1592456,1594520,1596599,1598642,1600571,1602456,1604273,1606109,1607850,1609573,1611253,1612859,1614449,1615960,1617398,1618778,1620150,1621507,1622834,1624113,1625335,1626541,1627773,1628872,1629972,1631037,1632104,1633119,1634130,1635099,1636050,1636970,1637902,1638821,1639666,1640567,1641440,1642272,1643072,1643899,1644674,1645431,1646165,1646891,1647627,1648256,1648925,1649594,1650259,1650889,1651516,1652125,
1729,43284,135206,241402,344553,438581,523165,598218,665315,724862,778146,825942,869509,908745,944587,977283,1007150,1034697,1060093,1083336,1105096,1125372,1144489,1162334,1178672,1194342,1208841,1222684,1235541,1247815,1259291,1270072,1280399,1290180,1299422,1308288,1316597,1324793,1332297,1339616,1346605,1353354,1359789,1365832,1371652,1377253,1382519,1387723,1392626,1397417,1402057,1406517,1410833,1414852,1418855,1422759,1426437,1430013,1433424,1436735,1439899,1443075,1446074,1448923,1451759,1454397,1457094,1459612,1462105,1464475,1466785,1468994,1471212,1473297,1475321,1477303,1479207,1481077,1482942,1484764,1486463,1488147,1489839,1491437,1493031,1494502,1495994,1497409,1498799,1500148,1501544,1502818,1504114,1505325,1506527,1507731,1508899,1509993,1511177,1512235,1513299,1514358,1515363,1516327,1517271,1518189,1519120,1520015,1520852,1521670,1522511,1523321,1524157,1524907,1525711,1526442,1527163,1527896,1528596,1529270,
218,14167,61685,130915,206883,282883,354335,420828,481601,537379,588201,634546,676858,715779,751390,784123,814192,842313,868587,893302,915944,937175,957016,975562,993175,1009732,1025388,1040046,1053849,1066806,1079210,1091032,1102146,1112808,1122881,1132511,1141782,1150507,1158934,1166920,1174677,1181960,1189023,1195790,1202165,1208305,1214283,1220080,1225443,1230751,1235729,1240630,1245362,1249882,1254267,1258292,1262453,1266482,1270244,1273906,1277488,1280934,1284255,1287418,1290618,1293629,1296492,1299389,1302167,1304778,1307242,1309749,1312216,1314617,1316935,1319178,1321374,1323514,1325555,1327630,1329562,1331460,1333253,1335047,1336810,1338443,1340133,1341760,1343338,1344825,1346363,1347875,1349354,1350710,1352023,1353410,1354735,1356003,1357232,1358432,1359627,1360777,1361980,1363081,1364114,1365178,1366228,1367197,1368182,1369149,1370136,1371018,1371968,1372840,1373650,1374485,1375288,1376102,1376825,1377556,
8,2673,19191,52385,96902,146874,198480,249624,298956,345424,389041,430242,468455,504187,537776,568939,597881,625122,650686,674493,696973,718073,738166,757209,775022,791758,807583,822606,836792,850156,863197,875496,887264,898331,908892,919117,928915,938094,946930,955441,963480,971377,978934,986113,993063,999688,1006033,1012310,1018117,1023801,1029140,1034395,1039558,1044587,1049431,1054065,1058498,1062917,1067004,1071019,1074897,1078710,1082329,1085796,1089141,1092413,1095669,1098790,1101820,1104625,1107473,1110311,1113080,1115687,1118293,1120718,1123066,1125363,1127651,1129934,1132120,1134281,1136349,1138334,1140255,1142071,1143919,1145730,1147394,1149112,1150803,1152414,1154000,1155568,1157061,1158539,1159987,1161389,1162759,1164136,1165515,1166723,1167957,1169206,1170445,1171609,1172780,1173896,1174947,1176065,1177105,1178067,1179048,1180007,1181010,1181916,1182819,1183689,1184555,1185403,
1,761,8495,27968,57543,93739,133733,174793,215816,255757,293990,330292,364813,397698,428439,457431,484854,510758,535330,558384,579948,600551,620124,638488,655841,672370,688188,703192,717490,731302,744330,756613,768297,779392,790044,800304,810148,819577,828461,836980,845160,853207,860806,868157,875418,882206,888719,894911,901125,907025,912597,918085,923367,928464,933408,938244,942776,947141,951486,955636,959615,963470,967361,970990,974521,978016,981333,984623,987718,990777,993713,996615,999461,1002359,1005016,1007567,1009995,1012461,1014800,1017112,1019372,1021529,1023633,1025719,1027859,1029982,1031822,1033676,1035612,1037371,1039070,1040803,1042527,1044148,1045738,1047243,1048754,1050235,1051677,1053114,1054528,1055872,1057195,1058482,1059762,1060999,1062226,1063385,1064553,1065732,1066868,1067894,1068964,1069958,1070955,1071934,1072891,1073862,1074788,1075627,
0,195,3026,12662,29914,53648,81489,112024,143742,175621,207226,237922,267589,296230,323709,349659,374628,398380,420962,442408,462876,482258,500660,518243,535008,550707,565893,580595,594400,607534,620231,632227,643778,654887,665531,675506,685145,694440,703433,711925,720159,728017,735702,743120,750196,757167,763782,770116,776176,782118,787801,793367,798727,803850,808824,813796,818356,822949,827280,831603,835698,839779,843617,847324,850985,854469,857881,861138,864319,867387,870403,873434,876296,879065,881905,884493,887068,889540,892014,894413,896689,898992,901225,903276,905411,907465,909507,911494,913413,915327,917176,918964,920710,922425,924048,925646,927236,928788,930220,931667,933140,934551,935949,937309,938646,939940,941216,942394,943537,944729,945921,947038,948155,949233,950320,951391,952390,953333,954303,955249,
0,26,821,4415,12918,26053,43541,63506,85701,109028,133074,157203,181166,204389,227231,249593,270711,291313,311153,329970,348093,365691,382353,398333,413483,428094,442088,455615,468654,481279,493201,504780,515939,526525,536652,546538,555887,565023,573709,582334,590257,598047,605624,612975,620021,626802,633429,639852,645900,651795,657388,662953,668163,673201,678198,683041,687665,692177,696587,700799,704877,708825,712699,716473,720105,723725,727230,730619,734020,737211,740326,743303,746259,749158,751967,754653,757254,759845,762410,764839,767165,769499,771798,773919,776033,778121,780277,782207,784157,786103,788026,789909,791601,793296,794979,796613,798239,799851,801357,802862,804357,805876,807313,808688,810010,811265,812598,813833,815090,816345,817563,818619,819810,820934,822007,823014,824077,825056,826097,827029,
0,3,162,1201,4324,10356,19099,30644,44276,59312,75590,92661,109965,127626,145193,162464,179450,196215,212361,228280,243718,258604,272979,287076,300623,313821,326283,338442,349943,361248,372100,382585,392533,402392,411785,420988,429618,438015,446221,454069,461653,468991,476130,483010,489532,496031,502384,508358,514293,519959,525380,530668,535901,540909,545683,550405,554837,559180,563558,567783,571898,575889,579739,583338,586923,590423,593898,597291,600576,603785,606913,609831,612682,615448,618263,620972,623581,626126,628586,630988,633331,635661,637908,640091,642231,644389,646470,648470,650371,652293,654114,655918,657726,659482,661219,662810,664503,666096,667626,669181,670704,672118,673565,674950,676263,677575,678873,680111,681337,682452,683677,684805,685903,687022,688106,689214,690264,691320,692290,693347,
0,0,42,471,2032,5290,10677,17996,27255,38072,50205,63115,76474,90423,104483,118620,132646,146678,160419,173972,187338,200198,212915,225190,237117,248869,260228,271258,281949,292177,302101,311770,321021,329938,338804,347455,355596,363542,371127,378500,385735,392728,399546,405941,412268,418498,424343,430116,435597,440904,446049,451166,456258,460971,465598,470102,474503,478785,482928,487033,491076,494777,498626,502314,505954,509310,512683,515852,519155,522216,525303,528204,531143,534002,536781,539438,542042,544483,546924,549359,551748,554018,556265,558527,560648,562735,564757,566701,568645,570550,572448,574247,576064,577884,579557,581283,582914,584550,586059,587624,589066,590548,591942,593310,594647,595956,597228,598523,599747,600952,602171,603349,604537,605671,606762,607840,608941,609962,611034,612014,
0,0,10,140,736,2233,5187,9504,15421,22608,30816,39903,49710,60171,70949,81910,93204,104483,115919,127109,138287,149108,159853,170455,180899,190903,200783,210349,219866,228997,237892,246641,254940,263090,271055,278788,286370,293705,300721,307473,314079,320442,326690,332764,338630,344305,349843,355140,360485,365594,370713,375481,380060,384661,389146,393418,397724,401906,405888,409701,413447,417189,420740,424282,427759,431067,434269,437414,440514,443485,446349,449152,451921,454615,457287,459844,462322,464770,467176,469497,471782,474050,476200,478273,480342,482391,484412,486320,488204,489981,491770,493542,495271,496968,498607,500261,501909,503417,504917,506378,507867,509280,510646,512007,513314,514606,515876,517133,518361,519473,520659,521857,523013,524139,525272,526339,527385,528454,529401,530390,
0,0,1,34,235,858,2178,4363,7662,11788,16905,22873,29612,36856,44708,52664,61068,69696,78390,87208,95925,104732,113548,122219,130815,139100,147363,155619,163605,171430,179173,186633,193955,201035,208099,214939,221586,227937,234094,240345,246354,252149,257810,263231,268603,273825,278862,283746,288451,293144,297766,302135,306507,310833,314923,318948,322927,326757,330537,334169,337718,341236,344622,347892,351007,354134,357189,360139,362984,365927,368686,371370,373906,376567,379014,381506,383894,386180,388469,390760,392931,395056,397164,399105,401093,403149,405053,406936,408723,410549,412360,414127,415827,417423,418961,420553,422173,423729,425214,426606,427982,429322,430593,431872,433240,434485,435748,437008,438186,439349,440519,441697,442785,443888,445013,446045,447045,448071,449081,450030,
0,0,1,10,65,255,783,1737,3249,5359,8117,11681,15815,20445,25608,31110,37019,43042,49443,55833,62298,68988,75548,82219,88874,95659,102111,108509,115054,121350,127465,133626,139737,145758,151575,157186,162895,168342,173777,179054,184167,189265,194224,198950,203673,208277,212763,217071,221304,225440,229460,233421,237299,241060,244751,248251,251869,255329,258720,261877,265040,268316,271503,274474,277402,280237,283097,285886,288518,291151,293764,296273,298705,301076,303420,305699,307917,310169,312322,314405,316438,318441,320427,322424,324366,326154,327973,329769,331531,333219,334834,336477,338097,339646,341165,342629,344137,345578,347008,348377,349642,350928,352195,353469,354694,355856,357078,358261,359430,360569,361663,362706,363788,364814,365822,366836,367798,368748,369672,370615,
0,0,0,0,9,50,181,494,1099,2051,3302,5077,7280,9867,12769,16075,19644,23352,27392,31726,36196,40819,45522,50171,54973,59840,64703,69465,74333,79217,84106,88864,93660,98360,103045,107762,112322,116812,121206,125527,129754,133894,137949,141967,145997,149852,153744,157473,161104,164686,168141,171485,174823,178144,181286,184329,187382,190392,193374,196288,199137,201877,204546,207207,209838,212399,214866,217380,219790,222155,224377,226630,228759,230869,232941,235024,237019,238962,240959,242831,244701,246510,248343,250071,251758,253347,255056,256608,258124,259726,261220,262717,264169,265611,267089,268512,269840,271179,272503,273814,275020,276248,277476,278670,279798,280944,282055,283135,284230,285227,286224,287225,288187,289207,290197,291129,292048,292972,293838,294736,
0,0,0,0,1,9,36,140,361,741,1335,2138,3218,4547,6082,7935,9996,12353,14814,17549,20367,23251,26465,29714,33078,36614,40056,43643,47201,50915,54620,58296,61851,65471,68956,72688,76180,79634,83241,86656,90092,93561,96869,100163,103470,106533,109601,112725,115776,118793,121809,124721,127491,130220,132954,135706,138299,140839,143362,145744,148109,150548,152928,155271,157550,159646,161821,164036,166204,168279,170264,172199,174167,176118,177930,179794,181600,183368,185108,186772,188484,190183,191745,193218,194700,196135,197637,199110,200546,201989,203332,204696,206025,207275,208601,209884,211084,212253,213446,214587,215748,216871,217991,219005,220096,221132,222199,223167,224151,225125,226078,227076,227977,228865,229782,230699,231570,232394,233237,234073,
0,0,0,0,0,0,4,21,75,176,374,662,1095,1659,2386,3217,4238,5444,6783,8255,9809,11617,13486,15491,17589,19772,22069,24380,26875,29360,31751,34238,36844,39395,41864,44402,46942,49463,52009,54564,57121,59701,62242,64706,67151,69658,71986,74467,76836,79157,81468,83743,85999,88215,90393,92511,94591,96744,98741,100677,102693,104692,106624,108552,110483,112288,114086,115916,117634,119429,121116,122788,124419,125968,127557,129092,130638,132107,133612,135004,136465,137927,139300,140590,141867,143173,144447,145760,147030,148198,149401,150607,151737,152823,153986,155042,156144,157238,158264,159302,160315,161314,162278,163261,164238,165164,166101,166967,167769,168635,169472,170336,171173,171994,172760,173535,174270,175007,175753,176487,
0,0,0,0,0,0,0,5,12,30,72,149,269,432,643,936,1354,1795,2322,2980,3748,4620,5552,6482,7553,8669,9876,11130,12463,13768,15165,16691,18135,19692,21241,22853,24501,26130,27754,29390,30975,32694,34349,35993,37630,39305,40920,42556,44256,45929,47533,49104,50653,52265,53811,55300,56776,58398,59925,61472,63020,64488,65938,67338,68767,70188,71528,72933,74305,75663,76998,78325,79640,80931,82158,83389,84567,85753,86883,88060,89167,90304,91457,92571,93645,94725,95813,96858,97863,98850,99819,100793,101727,102706,103634,104517,105404,106276,107136,107935,108747,109538,110342,111203,111960,112726,113496,114264,114999,115676,116396,117096,117825,118515,119196,119834,120502,121149,121821,122439,
0,0,0,0,0,0,0,0,0,1,4,14,28,55,90,157,247,355,494,663,877,1131,1428,1772,2132,2541,2994,3459,3996,4537,5122,5790,6471,7198,7910,8690,9522,10305,11141,11984,12841,13732,14594,15506,16387,17343,18237,19174,20084,21052,22015,22963,24021,24926,25844,26807,27790,28706,29623,30561,31476,32391,33334,34204,35111,35963,36812,37710,38648,39496,40348,41173,42026,42879,43682,44512,45299,46126,46902,47702,48458,49229,49994,50745,51500,52231,52982,53732,54423,55116,55825,56519,57203,57859,58538,59194,59845,60451,61055,61661,62292,62909,63530,64128,64725,65273,65849,66400,66959,67545,68056,68636,69154,69664,70152,70661,71150,71615,72137,72630,
63710,289693,500415,665087,794065,897763,982357,1053186,1113060,1164400,1208736,1247488,1281944,1312748,1340046,1364665,1387323,1407564,1426313,1443548,1459304,1473934,1487684,1500481,1512354,1523412,1533544,1543273,1552377,1560962,1568931,1576504,1583720,1590484,1596902,1603010,1608732,1614291,1619515,1624645,1629498,1634020,1638402,1642652,1646580,1650318,1653982,1657561,1660989,1664381,1667571,1670568,1673373,1676121,1678811,1681493,1684009,1686433,1688810,1691086,1693284,1695397,1697416,1699410,1701345,1703154,1704948,1706703,1708371,1710006,1711449,1713026,1714556,1716060,1717488,1718832,1720193,1721461,1722747,1723917,1725101,1726214,1727335,1728479,1729571,1730644,1731659,1732632,1733577,1734472,1735406,1736275,1737120,1737892,1738711,1739511,1740327,1741081,1741828,1742566,1743272,1743968,1744672,1745302,1745987,1746614,1747254,1747870,1748473,1749051,1749608,1750212,1750812,1751379,1751918,1752452,1752943,1753443,1753889,1754357,
15100,131680,285173,425216,544159,644235,728778,801313,863831,918460,966421,1008785,1046127,1080136,1110584,1138404,1163763,1186874,1207902,1227744,1245904,1262680,1278291,1292786,1306519,1319392,1331212,1342546,1353093,1363112,1372442,1381319,1389818,1397761,1405185,1412317,1419085,1425532,1431685,1437569,1443220,1448659,1453783,1458688,1463471,1467976,1472294,1476618,1480574,1484477,1488212,1491846,1495141,1498541,1501779,1504862,1507821,1510718,1513497,1516141,1518788,1521334,1523817,1526126,1528336,1530502,1532615,1534708,1536730,1538656,1540540,1542418,1544217,1546038,1547697,1549336,1550865,1552359,1553854,1555296,1556719,1558095,1559459,1560730,1561991,1563219,1564457,1565669,1566857,1567959,1569055,1570118,1571162,1572212,1573217,1574185,1575136,1576002,1576909,1577779,1578656,1579507,1580284,1581088,1581884,1582613,1583352,1584084,1584819,1585511,1586184,1586840,1587430,1588045,1588687,1589322,1589967,1590591,1591162,1591764,
4919,71752,185226,301996,407541,500382,581550,651840,713945,768403,817330,860518,899247,934333,965962,994860,1021259,1045583,1067984,1088733,1107936,1125825,1142399,1157846,1172288,1185770,1198596,1210723,1221974,1232695,1242770,1252236,1261283,1269806,1278010,1285801,1293193,1300250,1306953,1313448,1319594,1325513,1331051,1336443,1341513,1346472,1351203,1355759,1360163,1364435,1368562,1372524,1376374,1379927,1383437,1386883,1390151,1393369,1396387,1399303,1402182,1404977,1407630,1410240,1412689,1415172,1417531,1419735,1421901,1424085,1426174,1428178,1430147,1432019,1433897,1435763,1437490,1439105,1440818,1442417,1444027,1445495,1446947,1448355,1449718,1451122,1452577,1453918,1455169,1456390,1457631,1458826,1459971,1461062,1462151,1463196,1464265,1465304,1466244,1467206,1468125,1469080,1469979,1470890,1471719,1472631,1473466,1474296,1475099,1475850,1476601,1477319,1478060,1478771,1479433,1480094,1480737,1481373,1481966,1482619,
1024,30634,101171,187462,273113,353112,425647,490873,549409,602057,649500,692274,731197,766485,798893,828522,855620,880479,903925,925406,945493,964111,981419,997936,1013347,1027925,1041516,1054419,1066630,1077912,1088771,1099100,1108817,1118001,1126808,1135435,1143554,1151089,1158409,1165491,1172110,1178485,1184684,1190617,1196237,1201563,1206774,1211691,1216479,1221143,1225594,1230005,1234018,1238023,1241891,1245518,1249129,1252658,1255975,1259129,1262138,1265224,1268137,1271011,1273869,1276460,1279024,1281513,1283839,1286265,1288439,1290751,1292894,1294931,1296890,1298847,1300754,1302644,1304464,1306242,1307930,1309540,1311216,1312813,1314349,1315896,1317380,1318801,1320191,1321564,1322882,1324232,1325520,1326700,1327918,1329062,1330206,1331303,1332407,1333496,1334639,1335706,1336692,1337681,1338620,1339531,1340407,1341322,1342191,1343008,1343868,1344706,1345481,1346239,1346983,1347759,1348505,1349201,1349885,1350543,
96,8588,41569,93201,152483,212903,271407,326345,377351,424504,468001,508096,544794,578879,610280,639223,666025,690926,714255,735894,756116,775104,792892,809628,825384,840148,854108,867517,880164,892215,903599,914490,924854,934668,944037,953059,961683,969675,977328,984701,991749,998587,1005286,1011593,1017632,1023462,1029052,1034427,1039648,1044659,1049459,1054113,1058458,1062710,1066979,1071056,1074961,1078723,1082418,1085861,1089275,1092608,1095922,1099138,1102144,1104942,1107826,1110552,1113170,1115777,1118242,1120535,1122811,1125097,1127375,1129566,1131689,1133716,1135702,1137727,1139500,1141341,1143154,1144871,1146630,1148247,1149893,1151489,1153101,1154596,1156063,1157609,1159073,1160419,1161755,1162989,1164312,1165644,1166834,1168018,1169140,1170285,1171434,1172503,1173530,1174542,1175613,1176553,1177553,1178504,1179423,1180335,1181202,1182032,1182867,1183750,1184583,1185414,1186154,1186858,
21,3790,22799,57717,102687,151556,200884,248202,293502,336046,375985,413328,447992,480481,510449,538298,564411,588846,611636,633138,653297,672128,689861,706623,722404,737268,751419,764683,777263,789276,800763,811789,822189,832106,841460,850647,859437,867775,875840,883575,890737,897871,904495,910934,917153,923165,928985,934470,939738,944861,949625,954328,958906,963415,967653,971811,975922,979733,983492,987152,990754,994229,997547,1000760,1003815,1006813,1009752,1012527,1015217,1017787,1020370,1022946,1025431,1027884,1030235,1032583,1034745,1036899,1038922,1041014,1042996,1044857,1046804,1048662,1050433,1052216,1053928,1055573,1057198,1058718,1060214,1061697,1063215,1064690,1066115,1067471,1068788,1070117,1071405,1072657,1073847,1075093,1076222,1077313,1078431,1079479,1080610,1081631,1082700,1083674,1084695,1085634,1086584,1087457,1088311,1089169,1089991,1090821,1091677,1092494,
4,1247,10666,32044,62738,99046,137687,176835,214919,251753,286960,320120,351620,381302,409165,435355,460074,483087,505132,525624,544933,563286,580531,597018,612603,627132,640981,654238,666688,678809,690326,701142,711581,721555,731091,740099,748810,757274,765270,772890,780292,787460,794254,800734,807044,813236,819064,824692,830223,835532,840556,845469,850086,854640,859038,863461,867614,871702,875659,879377,882977,886350,889787,893134,896304,899383,902447,905383,908203,911004,913725,916399,918948,921445,923820,926249,928532,930692,932815,934975,937097,939062,941105,942963,944774,946626,948362,950010,951716,953305,954984,956522,958077,959593,961011,962410,963751,965102,966424,967752,969037,970290,971486,972625,973791,974945,976054,977238,978314,979398,980352,981372,982340,983305,984202,985121,986028,986859,987758,988622,
0,306,3923,15145,33651,57865,85646,115017,145311,175458,204794,233294,260776,286660,311147,334703,357032,378436,398753,417997,436139,453506,469876,485378,500114,514079,527456,540360,552703,564478,575624,586327,596633,606456,615858,624971,633687,642030,650007,657686,665016,672084,678802,685304,691754,697954,703821,709462,715084,720286,725472,730430,735251,739923,744517,748719,752933,757022,760988,764807,768562,771983,775507,778865,782112,785319,788286,791405,794357,797107,799934,802608,805210,807781,810200,812573,814959,817139,819497,821663,823766,825826,827921,829884,831795,833635,835462,837264,838947,840561,842188,843800,845455,846955,848468,849951,851414,852839,854185,855568,856879,858132,859403,860583,861778,862982,864094,865196,866247,867304,868367,869349,870338,871286,872244,873149,874096,875048,875916,876812,
0,60,1129,5669,14848,28758,46282,66355,87742,109994,132683,155232,177099,198611,219705,239692,259062,277691,295577,312541,328736,344451,359346,373638,387290,400361,412978,424954,436391,447487,458085,468211,478014,487398,496267,504885,513186,521292,529179,536580,543838,550758,557340,563743,569794,575770,581618,587239,592846,597910,603061,608015,612675,617213,621619,626051,630231,634295,638242,642109,645760,649241,652726,656130,659445,662653,665787,668731,671629,674534,677319,680021,682799,685350,687825,690261,692579,694881,697067,699229,701423,703461,705512,707513,709461,711326,713148,714995,716759,718525,720157,721838,723523,725101,726660,728195,729702,731123,732529,733905,735254,736609,737915,739171,740426,741702,742932,744077,745178,746260,747292,748356,749393,750419,751466,752375,753329,754280,755176,756080,
0,20,471,2661,7993,16964,29049,43537,60057,77506,95930,114537,133064,151334,169491,187092,204020,220556,236597,251956,266823,281111,295015,308301,321124,333401,345212,356535,367589,378117,388238,397856,406939,416029,424684,432843,440984,448905,456313,463603,470769,477291,483755,490036,496016,501784,507569,513088,518532,523485,528384,533154,537951,542521,546740,550963,555149,559207,563062,566753,570450,573985,577418,580669,583944,587183,590298,593261,596114,598901,601736,604458,607138,609729,612287,614712,617122,619403,621597,623752,625936,628009,630034,632049,634075,636021,637832,639699,641495,643246,644849,646564,648186,649828,651414,652878,654330,655749,657124,658458,659843,661090,662334,663626,664852,666054,667263,668381,669502,670626,671706,672755,673834,674798,675801,676808,677772,678676,679605,680530,
0,2,153,1072,3982,9218,16914,26814,38226,51283,65277,79628,94808,109856,124648,139419,153867,168126,181979,195312,208357,221235,233632,245604,257116,268086,278834,289490,299490,309217,318420,327322,336039,344514,352629,360469,368027,375242,382243,389018,395690,402040,408383,414393,420189,425820,431241,436536,441699,446791,451566,456254,460737,465118,469413,473462,477410,481415,485274,489005,492653,496160,499643,502960,506174,509356,512489,515411,518416,521116,523960,526604,529197,531672,534130,536582,538932,541237,543504,545697,547777,549853,551900,553851,555800,557703,559564,561423,563149,564846,566503,568151,569784,571392,572950,574438,575841,577294,578696,580042,581384,582729,583969,585246,586496,587709,588884,590003,591111,592189,593229,594282,595339,596425,597406,598334,599327,600259,601138,602025,
0,0,38,384,1580,4159,8506,14640,22077,30749,40727,51472,62564,73948,85426,97126,108877,120635,132181,143467,154598,165472,176148,186582,196583,206428,216030,225255,234283,242991,251436,259751,267767,275351,282815,290075,296953,303760,310175,316519,322604,328535,334221,339802,345172,350590,355787,360697,365579,370263,374912,379340,383733,387951,392076,396050,399875,403628,407293,410879,414371,417672,420949,424116,427274,430309,433264,436128,438977,441702,444339,446940,449434,451907,454335,456751,459009,461318,463592,465746,467787,469837,471835,473831,475692,477496,479289,481005,482679,484366,486003,487645,489204,490700,492295,493752,495129,496467,497836,499181,500490,501758,502977,504190,505428,506584,507826,508985,510120,511190,512233,513235,514270,515278,516256,517291,518204,519138,520056,520982,
0,0,6,102,498,1595,3697,6966,11296,16545,22915,29871,37375,45464,53899,62727,71781,80711,89613,98750,107677,116418,125332,133986,142470,150777,158801,166834,174578,182234,189523,196661,203731,210575,217191,223660,229810,235861,241817,247509,253156,258537,263639,268790,273672,278365,283003,287558,291950,296201,300404,304605,308585,312486,316286,319951,323557,327093,330430,333643,336953,340123,343226,346291,349269,352174,354994,357650,360356,362961,365484,367899,370321,372677,375019,377323,379508,381741,383787,385783,387811,389836,391695,393572,395437,397223,398928,400615,402254,403827,405429,406962,408542,410027,411430,412874,414313,415664,416998,418290,419574,420769,421924,423165,424395,425459,426647,427723,428758,429870,430960,432021,433037,434020,435022,435991,436919,437824,438713,439607,
0,0,0,15,131,509,1268,2668,4746,7385,10858,14976,19599,24633,30108,36101,42204,48531,55104,61760,68349,75007,81696,88338,95027,101572,107949,114239,120491,126622,132651,138476,144190,149836,155304,160777,166185,171257,176250,181088,185748,190405,195014,199442,203757,207979,212170,216209,220236,224029,227809,231563,235210,238712,242079,245383,248659,251850,254937,257941,260843,263788,266597,269311,272075,274701,277324,279747,282201,284586,286942,289261,291450,293625,295768,297855,299970,301984,303974,305925,307861,309639,311384,313173,314837,316597,318164,319787,321373,322927,324458,325968,327454,328812,330178,331557,332961,334254,335514,336760,337987,339238,340326,341535,342610,343688,344835,345905,346935,347965,348961,349982,350967,351959,352865,353776,354688,355577,356455,357337,
0,0,0,5,27,117,396,945,1876,3188,4938,7253,10034,13097,16472,20304,24450,28681,33179,37792,42494,47316,52295,57385,62360,67342,72201,77147,82006,86697,91522,96361,101033,105689,110192,114757,119024,123394,127778,132002,136144,140074,143860,147729,151499,155212,158833,162302,165772,169179,172431,175700,178860,181942,184931,187856,190816,193507,196296,199027,201679,204202,206768,209224,211607,213972,216323,218601,220768,223028,225132,227142,229190,231139,233098,235008,236831,238691,240576,242356,244050,245765,247441,249093,250701,252236,253817,255348,256830,258263,259628,261014,262386,263731,265074,266369,267572,268841,270063,271200,272404,273504,274537,275606,276673,277720,278766,279747,280781,281776,282705,283627,284512,285393,286268,287102,287874,288746,289536,290393,
0,0,0,0,4,26,83,251,556,1054,1829,2800,4105,5652,7480,9642,11934,14464,17087,19954,22948,26042,29226,32628,36059,39518,43099,46595,50007,53568,57182,60718,64255,67689,71093,74594,78147,81564,84956,88255,91534,94692,97850,100919,103944,106858,109876,112803,115590,118397,121161,123838,126483,129054,131526,133927,136338,138699,140927,143192,145411,147573,149753,151906,153913,156001,158024,159932,161880,163721,165497,167299,169103,170950,172662,174296,175967,177585,179220,180787,182346,183807,185288,186768,188251,189661,191032,192340,193645,194954,196202,197431,198612,199765,200954,202119,203209,204300,205409,206463,207528,208554,209568,210516,211449,212396,213314,214224,215057,215944,216832,217726,218583,219419,220255,221086,221853,222593,223351,224061,
0,0,0,0,0,2,9,30,94,206,381,702,1156,1752,2494,3357,4356,5475,6774,8181,9695,11269,12974,14845,16789,18759,20845,22919,25104,27369,29588,31846,34159,36415,38623,40942,43323,45676,47996,50317,52479,54727,56967,59122,61393,63572,65742,67946,70105,72154,74215,76265,78253,80185,82122,84033,85916,87740,89527,91269,93034,94798,96449,98178,99888,101522,103071,104631,106191,107670,109167,110678,112181,113621,114977,116295,117655,119013,120332,121597,122861,124098,125279,126488,127619,128740,129849,130987,132091,133189,134254,135248,136316,137364,138366,139355,140362,141279,142170,143127,144081,144919,145742,146583,147482,148286,149129,149902,150724,151519,152270,153048,153737,154462,155190,155887,156601,157264,157988,158613,
0,0,0,0,0,0,0,4,8,25,46,84,166,278,415,614,876,1241,1653,2158,2684,3265,3902,4615,5378,6173,7078,7950,8947,9973,11021,12174,13287,14457,15676,16907,18171,19418,20672,21965,23223,24496,25799,27057,28340,29635,30916,32295,33573,34873,36179,37497,38682,39916,41175,42380,43626,44825,46031,47215,48365,49527,50718,51910,53098,54220,55302,56371,57515,58632,59640,60669,61704,62710,63747,64808,65793,66741,67692,68609,69486,70430,71329,72257,73146,73974,74857,75705,76484,77255,78064,78852,79584,80368,81188,81968,82706,83426,84135,84793,85476,86140,86850,87515,88185,88799,89438,90057,90639,91240,91848,92441,93032,93604,94176,94732,95232,95769,96307,96834,
82598,324138,531770,689548,811193,908780,987878,1053350,1108951,1156361,1196983,1232669,1264115,1292369,1317521,1340538,1361390,1380289,1397436,1413163,1427978,1441530,1454210,1465905,1476961,1487319,1496953,1505829,1514265,1522091,1529651,1536636,1543426,1549599,1555631,1561243,1566684,1571882,1576731,1581445,1585973,1590280,1594332,1598154,1602037,1605601,1609069,1612492,1615617,1618773,1621751,1624628,1627369,1629998,1632514,1634966,1637406,1639663,1641889,1643982,1646016,1647981,1650003,1651879,1653701,1655475,1657228,1658909,1660523,1662006,1663543,1664990,1666460,1667862,1669198,1670510,1671730,1672910,1674133,1675360,1676412,1677529,1678590,1679638,1680647,1681594,1682565,1683514,1684438,1685384,1686271,1687159,1688054,1688864,1689655,1690442,1691214,1691928,1692649,1693317,1693986,1694680,1695355,1696000,1696635,1697228,1697805,1698399,1698913,1699474,1700049,1700579,1701122,1701652,1702184,1702688,1703197,1703685,1704137,1704626,
24590,164323,326815,466224,581475,676761,756557,823861,882178,932525,976483,1015460,1050299,1081469,1109524,1134641,1157881,1178996,1198316,1216006,1232457,1247881,1262109,1275428,1287801,1299613,1310516,1320598,1330156,1339243,1347914,1356030,1363723,1371076,1378052,1384669,1390968,1396918,1402659,1408073,1413184,1418173,1422918,1427470,1431727,1435990,1440057,1443993,1447760,1451311,1454748,1457979,1461323,1464365,1467289,1470179,1472954,1475631,1478238,1480767,1483108,1485467,1487697,1489880,1492014,1494043,1495977,1497995,1499892,1501719,1503523,1505256,1506975,1508622,1510195,1511741,1513202,1514629,1516034,1517436,1518725,1519937,1521205,1522502,1523662,1524771,1525931,1527041,1528106,1529154,1530200,1531214,1532226,1533163,1534131,1535079,1536000,1536865,1537668,1538467,1539292,1540090,1540852,1541579,1542366,1543114,1543820,1544523,1545233,1545849,1546497,1547120,1547688,1548287,1548872,1549451,1549979,1550553,1551103,1551650,
9734,98704,226351,347189,452381,542660,620447,687112,745696,796668,841778,881760,917950,950070,978934,1005366,1029442,1051666,1071911,1090998,1108506,1124609,1139535,1153606,1166799,1179169,1191023,1202082,1212569,1222302,1231417,1240013,1248444,1256087,1263678,1270752,1277515,1283892,1290071,1295842,1301571,1306884,1312055,1317038,1321781,1326340,1330577,1334835,1338765,1342691,1346494,1350069,1353488,1356919,1360088,1363254,1366258,1369174,1372020,1374749,1377286,1379795,1382312,1384756,1387059,1389368,1391556,1393700,1395800,1397811,1399724,1401578,1403389,1405154,1406866,1408560,1410204,1411748,1413268,1414717,1416108,1417506,1418913,1420276,1421571,1422846,1424148,1425379,1426558,1427701,1428850,1429972,1431036,1432084,1433126,1434132,1435105,1436042,1436951,1437893,1438745,1439657,1440464,1441285,1442064,1442869,1443651,1444410,1445130,1445863,1446533,1447204,1447864,1448516,1449145,1449798,1450420,1451063,1451624,1452168,
2604,48554,136158,231930,322279,403382,475042,538634,595169,645251,689870,729529,765502,797975,827634,854916,879722,902843,923941,943864,962266,979043,994829,1009709,1023987,1037176,1049663,1061311,1072393,1082799,1092554,1102066,1110925,1119300,1127268,1135054,1142375,1149277,1155794,1162064,1168153,1173912,1179492,1184986,1190104,1195065,1199681,1204244,1208517,1212727,1216705,1220634,1224461,1228058,1231557,1234954,1238251,1241439,1244483,1247455,1250271,1253004,1255658,1258246,1260746,1263261,1265565,1267859,1270080,1272171,1274273,1276356,1278322,1280231,1282112,1283881,1285638,1287404,1289100,1290682,1292224,1293742,1295267,1296763,1298149,1299534,1300918,1302284,1303574,1304854,1306079,1307322,1308554,1309723,1310735,1311798,1312878,1313981,1315009,1315966,1317019,1317939,1318805,1319707,1320530,1321384,1322244,1323110,1323910,1324710,1325530,1326296,1327034,1327759,1328443,1329154,1329843,1330473,1331110,1331748,
419,17689,66966,131713,200127,266462,327884,383778,434682,480854,522891,561326,596418,628602,658090,685259,710075,733371,754629,774850,793432,810897,827422,842747,857297,870851,883977,895986,907487,918573,928946,938835,948082,957017,965622,973759,981744,989176,996285,1003099,1009563,1015621,1021576,1027294,1032819,1038111,1043200,1048097,1052803,1057258,1061492,1065559,1069555,1073435,1077290,1081027,1084569,1087982,1091176,1094405,1097469,1100521,1103438,1106317,1109140,1111874,1114440,1116939,1119315,1121658,1123956,1126197,1128341,1130376,1132454,1134433,1136311,1138215,1140085,1141866,1143530,1145208,1146813,1148409,1150006,1151519,1152988,1154406,1155815,1157154,1158458,1159787,1161135,1162407,1163620,1164797,1165997,1167088,1168249,1169380,1170475,1171519,1172474,1173516,1174485,1175426,1176417,1177297,1178176,1179058,1179914,1180763,1181589,1182353,1183138,1183874,1184654,1185422,1186118,1186763,
129,8805,40553,89067,144394,200650,254243,305067,351914,395225,434913,471333,505120,536395,564969,591481,616014,638645,660074,680020,698646,716244,732981,748518,763065,776851,789745,801962,813651,824707,835262,845256,854753,863866,872510,880757,888712,896299,903524,910353,917021,923381,929415,935218,941001,946541,951754,956760,961602,966332,970733,974949,979184,983157,987181,990977,994682,998355,1001845,1005130,1008396,1011484,1014535,1017472,1020333,1023063,1025669,1028213,1030689,1033102,1035418,1037704,1040050,1042171,1044360,1046465,1048445,1050393,1052242,1054072,1055870,1057682,1059389,1061118,1062712,1064335,1065837,1067317,1068835,1070260,1071634,1073013,1074465,1075728,1077011,1078260,1079494,1080690,1081858,1083016,1084153,1085182,1086266,1087284,1088278,1089326,1090295,1091290,1092220,1093125,1094017,1094895,1095770,1096628,1097469,1098276,1099030,1099779,1100525,1101283,
19,3720,21747,54344,96026,140808,185892,229275,270749,309930,346341,379962,411562,440719,468272,493960,517627,539920,560675,580033,598457,615866,632245,647516,661991,675740,688758,701034,712840,723879,734599,744860,754434,763510,772499,780753,788857,796559,803909,810865,817697,824194,830405,836534,842297,848067,853384,858511,863539,868381,872997,877549,881978,886107,890217,894253,898031,901733,905167,908651,911945,915176,918310,921374,924377,927215,929948,932685,935249,937777,940260,942648,945059,947292,949433,951588,953620,955595,957587,959516,961437,963241,965073,966821,968491,970152,971751,973312,974901,976353,977734,979202,980540,981858,983237,984596,985822,987037,988207,989412,990588,991774,992860,993924,994931,995982,996969,997956,998929,999882,1000773,1001683,1002578,1003415,1004254,1005097,1005912,1006740,1007526,1008344,
2,1226,10124,29784,58084,91115,126050,161123,196098,229798,261708,291949,320273,347116,372322,396185,418714,439970,459713,478425,495986,512641,528252,543221,557613,570965,583638,595870,607575,618575,629139,639208,648809,657929,666652,674869,682851,690576,698208,705307,712254,718890,725103,731159,736975,742735,748142,753413,758475,763381,768096,772606,776942,781225,785419,789423,793246,796975,800591,804099,807537,810783,813996,817165,820205,823156,826081,828821,831492,834194,836728,839153,841558,843890,846204,848398,850663,852802,854857,856860,858795,860644,862548,864292,866091,867764,869455,871050,872664,874266,875737,877198,878632,880047,881446,882802,884128,885406,886648,887902,889097,890202,891455,892580,893665,894773,895801,896859,897833,898802,899779,900741,901603,902517,903349,904215,905049,905892,906749,907541,
0,288,3657,13437,29927,51317,76047,102126,128948,155868,182210,207530,231984,255235,277452,298570,318813,338019,356252,373382,389922,405537,420273,434302,447735,460569,472654,484250,495376,506090,516402,526173,535569,544473,553049,561242,569211,576934,584220,591299,597957,604512,610877,616855,622615,628204,633603,638909,643965,648863,653651,658226,662739,666940,671039,675045,678922,682692,686301,689810,693272,696701,699893,703009,706036,709020,711902,714671,717460,720091,722766,725290,727755,730193,732459,734637,736776,738936,740953,743007,744983,746916,748750,750533,752337,754066,755763,757398,758990,760581,762155,763714,765226,766641,768066,769407,770828,772129,773452,774798,776077,777256,778429,779601,780696,781821,782884,783940,784956,785999,786979,787954,788921,789825,790760,791681,792559,793419,794250,795079,
0,100,1681,7447,18156,33565,52074,72633,94429,116753,139067,160865,182226,203053,223139,242049,260322,278000,294697,310726,326223,340790,354638,368127,380968,393144,404848,415975,426689,436888,446590,456056,465206,473836,482032,490203,497900,505433,512509,519356,525997,532426,538682,544478,550153,555614,560987,566172,571242,576098,580720,585280,589606,593941,598081,602049,605907,609686,613438,616869,620387,623726,626935,630057,633196,636115,639047,641865,644712,647306,649873,652363,654868,657240,659530,661840,664019,666196,668245,670265,672295,674189,676091,677919,679762,681540,683239,684965,686632,688193,689776,691370,692811,694248,695660,697054,698458,699857,701179,702470,703644,704906,706106,707335,708471,709587,710656,711744,712766,713830,714862,715849,716793,717736,718683,719588,720478,721355,722223,723103,
0,23,653,3577,9981,19897,32890,48099,64723,82191,100404,118573,136512,154058,171319,188125,204380,220147,235105,249690,263625,277052,289992,302202,314170,325705,336690,347202,357341,367041,376364,385349,394103,402408,410371,418172,425649,432757,439528,446134,452633,458832,464862,470795,476533,481826,487074,492113,497082,501763,506319,510798,515226,519388,523251,527200,531159,534821,538370,541783,545247,548489,551621,554784,557831,560779,563660,566406,569149,571856,574427,576894,579357,581681,583956,586251,588539,590689,592758,594854,596856,598817,600713,602593,604400,606210,607933,609548,611174,612832,614355,615884,617391,618899,620272,621667,623034,624394,625742,626984,628253,629523,630767,631938,633102,634261,635378,636390,637405,638447,639473,640439,641425,642286,643202,644129,645061,645935,646778,647656,
0,10,186,1420,4722,10384,18458,28870,40618,53588,67318,81496,96019,110413,124846,138899,152751,166321,179519,192194,204492,216415,228199,239386,249970,260243,270337,279781,289186,298160,306789,315089,323135,330950,338632,345940,352958,359674,366332,372503,378678,384533,390305,395904,401206,406341,411443,416301,421113,425746,430381,434729,438955,443073,447019,450869,454535,458113,461681,465083,468412,471679,474752,477852,480807,483676,486506,489297,491986,494632,497226,499750,502139,504493,506747,508979,511157,513309,515361,517357,519359,521291,523143,524976,526800,528541,530310,531989,533661,535190,536790,538361,539848,541345,542759,544120,545575,546881,548146,549518,550763,551982,553195,554333,555457,556574,557730,558803,559850,560902,561877,562827,563763,564796,565688,566578,567472,568332,569175,570043,
0,0,50,469,1900,4742,9211,15504,23121,32037,41736,52211,62886,73958,85022,96048,107096,117983,128922,139548,149901,159988,169976,179572,188811,197892,206553,215082,223404,231459,239233,246844,254172,261246,268159,275035,281466,287644,293561,299449,305157,310743,316030,321262,326204,331078,335742,340461,344905,349242,353489,357539,361509,365305,369058,372631,376149,379589,382976,386265,389484,392568,395573,398479,401310,404034,406771,409426,412073,414557,416988,419372,421773,424106,426375,428600,430743,432720,434616,436530,438549,440426,442282,444008,445756,447460,449149,450776,452353,453933,455443,457007,458442,459903,461302,462683,463993,465249,466505,467737,468963,470191,471367,472543,473632,474759,475826,476880,477876,478875,479879,480860,481843,482756,483701,484625,485504,486387,487275,488081,
0,0,6,104,568,1693,3798,6907,11090,16147,22341,28901,36044,43474,51298,59417,67600,75991,84109,92472,100738,108775,116893,124737,132490,139973,147419,154581,161680,168622,175378,181824,188141,194371,200290,206146,211856,217351,222606,227818,232792,237643,242391,246933,251497,255972,260168,264384,268451,272431,276223,280101,283747,287366,290816,294233,297466,300577,303608,306587,309615,312522,315328,318059,320843,323463,326021,328507,331054,333473,335818,338091,340335,342451,344608,346712,348764,350697,352699,354576,356365,358156,359957,361710,363370,365066,366683,368230,369781,371277,372727,374145,375530,376926,378251,379550,380831,382103,383340,384533,385754,386905,387997,389078,390135,391227,392260,393286,394276,395250,396242,397226,398139,399070,399978,400890,401741,402551,403387,404212,
0,0,0,19,159,569,1372,2788,4905,7668,11068,15104,19733,24635,29992,35632,41406,47240,53361,59625,65859,72024,78291,84440,90608,96662,102773,108456,114176,119932,125545,130960,136300,141464,146534,151475,156346,161090,165741,170355,174853,179196,183432,187477,191541,195527,199265,202886,206470,209955,213474,216818,220073,223230,226375,229503,232508,235378,238197,241054,243856,246581,249152,251625,254088,256431,258830,261165,263431,265625,267816,269956,271941,273917,275922,277840,279843,281741,283627,285440,287231,288819,290368,291988,293550,295127,296658,298157,299583,301063,302426,303842,305170,306452,307757,309002,310240,311388,312599,313741,314907,315975,317098,318176,319205,320242,321262,322244,323187,324182,325108,326005,326903,327766,328625,329424,330263,331125,331913,332699,
0,0,0,3,22,115,367,892,1686,2888,4564,6595,8985,11700,14911,18245,21848,25680,29562,33724,37927,42286,46639,51008,55347,59829,64223,68736,73013,77254,81715,85986,90232,94309,98351,102394,106339,110284,114137,117900,121563,125112,128643,132064,135410,138733,141930,145111,148321,151342,154235,157062,159864,162562,165282,167977,170621,173180,175655,178093,180521,182986,185232,187459,189625,191729,193833,195818,197839,199884,201798,203725,205542,207351,209076,210842,212515,214135,215850,217434,219013,220526,222049,223523,224967,226395,227807,229164,230479,231847,233138,234366,235621,236816,238001,239163,240314,241384,242487,243544,244591,245606,246599,247590,248595,249534,250473,251414,252332,253264,254124,255006,255838,256676,257498,258333,259124,259882,260624,261343,
0,0,0,0,1,8,44,150,348,716,1231,2034,2989,4179,5531,7156,8955,11004,13072,15370,17721,20238,22786,25466,28195,31019,33920,36769,39689,42606,45480,48370,51246,54062,56945,59907,62732,65544,68373,71157,73870,76495,79129,81680,84323,86817,89315,91781,94174,96561,98842,101094,103318,105552,107647,109789,111910,113952,115960,117912,119910,121822,123658,125537,127325,129074,130847,132573,134247,135945,137569,139197,140765,142322,143779,145222,146698,148105,149530,150913,152263,153616,154888,156174,157394,158663,159820,161032,162210,163352,164397,165458,166590,167619,168674,169743,170745,171730,172624,173570,174537,175452,176312,177221,178089,178953,179775,180571,181319,182123,182894,183644,184369,185124,185889,186609,187345,188060,188743,189410,
0,0,0,0,0,1,2,9,32,77,152,275,478,773,1136,1595,2154,2785,3559,4401,5274,6296,7434,8637,9908,11139,12479,13882,15392,16850,18374,19961,21504,23154,24771,26393,28050,29669,31323,32952,34673,36325,37955,39580,41209,42813,44351,45971,47529,49169,50654,52218,53752,55277,56793,58243,59737,61126,62510,63885,65256,66553,67928,69227,70532,71836,73114,74361,75601,76777,77973,79148,80294,81448,82552,83646,84689,85714,86785,87764,88815,89841,90835,91871,92830,93754,94651,95595,96516,97406,98337,99177,100036,100893,101713,102527,103301,104020,104739,105469,106248,106976,107700,108385,109066,109732,110390,111103,111739,112405,113026,113604,114189,114790,115370,115982,116559,117116,117660,118216,
100883,352618,558161,709845,825564,917231,991776,1053518,1105262,1149471,1187777,1221402,1251001,1277273,1301068,1322440,1341758,1359516,1375730,1390504,1404406,1417229,1428972,1439879,1450051,1459797,1468832,1477333,1485272,1492748,1499858,1506617,1512937,1519021,1524745,1530146,1535309,1540250,1544848,1549309,1553463,1557589,1561448,1565284,1568944,1572372,1575545,1578708,1581737,1584752,1587598,1590313,1592910,1595395,1597813,1600195,1602558,1604842,1607023,1609094,1611033,1612977,1614814,1616609,1618399,1620063,1621755,1623330,1624880,1626441,1627905,1629411,1630800,1632108,1633392,1634651,1635842,1636981,1638112,1639259,1640427,1641461,1642484,1643479,1644439,1645426,1646326,1647224,1648088,1648962,1649815,1650632,1651487,1652261,1653061,1653809,1654555,1655270,1655980,1656622,1657250,1657927,1658570,1659180,1659781,1660376,1660981,1661531,1662056,1662592,1663159,1663669,1664157,1664690,1665200,1665701,1666169,1666650,1667111,1667553,
35073,193648,360081,497594,609213,700317,776365,840201,895023,942423,983396,1019768,1052237,1081188,1107135,1130735,1152121,1171885,1189825,1206541,1221836,1236062,1249536,1262066,1273579,1284602,1294808,1304402,1313350,1321852,1329932,1337615,1344750,1351654,1358144,1364449,1370530,1376087,1381473,1386740,1391432,1396022,1400403,1404736,1408753,1412820,1416552,1420212,1423729,1427035,1430246,1433397,1436384,1439280,1442077,1444808,1447348,1449815,1452251,1454673,1457009,1459236,1461319,1463329,1465401,1467419,1469305,1471268,1473092,1474865,1476587,1478248,1479762,1481284,1482741,1484232,1485649,1486989,1488370,1489623,1490859,1492138,1493307,1494443,1495603,1496712,1497812,1498912,1499878,1500832,1501864,1502864,1503856,1504754,1505647,1506569,1507418,1508251,1509055,1509882,1510664,1511395,1512140,1512861,1513535,1514256,1514930,1515591,1516276,1516949,1517535,1518165,1518722,1519298,1519863,1520442,1520989,1521505,1522049,1522537,
15886,124474,261728,384487,488906,576705,650980,714782,769902,817876,859912,897165,930527,960614,987774,1012287,1034508,1055209,1074078,1091595,1107825,1122884,1136979,1150144,1162441,1173982,1184938,1195167,1204774,1213952,1222611,1230678,1238475,1245685,1252628,1259146,1265442,1271666,1277495,1282978,1288253,1293228,1298049,1302648,1307115,1311343,1315445,1319494,1323298,1326975,1330544,1333899,1337197,1340403,1343464,1346409,1349210,1351947,1354569,1357052,1359470,1361838,1364115,1366462,1368685,1370842,1372926,1374926,1376816,1378729,1380575,1382402,1384119,1385800,1387337,1388886,1390372,1391826,1393290,1394713,1396070,1397360,1398610,1399908,1401162,1402317,1403492,1404634,1405726,1406821,1407907,1408976,1409985,1410981,1411963,1412916,1413872,1414811,1415705,1416584,1417384,1418245,1419066,1419795,1420586,1421315,1422026,1422727,1423496,1424164,1424806,1425455,1426094,1426730,1427342,1427939,1428492,1429091,1429649,1430180,
5430,67919,168933,270984,363156,444050,514529,575580,629335,676993,719518,757093,791149,821801,849737,875069,898306,919562,939454,957634,974833,990462,1005212,1019207,1032002,1044330,1055850,1066526,1076892,1086480,1095385,1104162,1112464,1120226,1127685,1134845,1141699,1148094,1154227,1160092,1165728,1171101,1176316,1181341,1186049,1190709,1195063,1199315,1203365,1207156,1210946,1214620,1218152,1221504,1224755,1227973,1231192,1234168,1237046,1239794,1242487,1245041,1247583,1250066,1252441,1254746,1256953,1259099,1261146,1263175,1265059,1266962,1268762,1270579,1272410,1274121,1275780,1277435,1278994,1280555,1282106,1283488,1284885,1286193,1287506,1288811,1290046,1291336,1292587,1293798,1294969,1296134,1297250,1298333,1299366,1300384,1301376,1302344,1303319,1304307,1305253,1306149,1307005,1307879,1308734,1309529,1310407,1311218,1311946,1312674,1313402,1314093,1314746,1315425,1316048,1316713,1317402,1318019,1318625,1319175,
1059,28370,90605,165031,239074,308074,370330,426352,476793,521621,562418,599342,632705,662950,691025,716722,740129,762037,782275,800941,818422,834811,850116,864620,878009,890644,902667,914082,924891,935025,944603,953781,962430,970737,978670,986141,993498,1000407,1006868,1013139,1019255,1024941,1030514,1035787,1040986,1045825,1050639,1055109,1059455,1063570,1067634,1071549,1075273,1078953,1082447,1085917,1089199,1092424,1095494,1098440,1101390,1104184,1107008,1109620,1112199,1114659,1117087,1119430,1121730,1123906,1125998,1128028,1130028,1131917,1133875,1135770,1137503,1139354,1141067,1142728,1144342,1145897,1147433,1148889,1150306,1151740,1153127,1154476,1155864,1157153,1158415,1159588,1160840,1162040,1163252,1164343,1165451,1166471,1167468,1168514,1169556,1170549,1171480,1172371,1173286,1174157,1174979,1175848,1176721,1177570,1178365,1179192,1179946,1180684,1181421,1182083,1182723,1183413,1184108,1184812,
374,15988,60077,118999,181200,241486,297631,349623,397111,439955,478716,514295,546832,576546,604146,629387,652673,674123,694387,713127,731036,747719,762820,777286,791011,804022,816033,827492,838371,848755,858705,868024,876827,885285,893281,900994,908388,915725,922478,928957,935133,941072,946831,952491,957759,962817,967710,972356,976865,981189,985441,989419,993364,997049,1000703,1004314,1007717,1010956,1014085,1017238,1020161,1023124,1025932,1028692,1031428,1033971,1036421,1038828,1041151,1043443,1045713,1047843,1049859,1051842,1053841,1055806,1057651,1059520,1061285,1063064,1064684,1066308,1067901,1069462,1070976,1072477,1073909,1075271,1076633,1077983,1079341,1080651,1081960,1083275,1084483,1085685,1086766,1087891,1088970,1090059,1091143,1092186,1093178,1094117,1095067,1096012,1096924,1097808,1098680,1099546,1100408,1101245,1102046,1102783,1103565,1104241,1104941,1105670,1106359,1107020,
91,7717,35593,78380,127796,178734,227604,273388,316519,356070,392749,426007,456908,485475,511921,536449,559533,580608,600577,619240,636975,653255,668781,683132,696905,709868,722248,733855,744979,755364,765315,774656,783706,792404,800672,808534,815966,823276,830384,836843,843220,849263,855127,860770,866088,871351,876295,881120,885889,890355,894779,898927,903004,906821,910642,914248,917806,921154,924511,927700,930848,933882,936765,939685,942414,945079,947594,949995,952334,954713,957035,959277,961517,963593,965585,967626,969548,971490,973358,975154,976872,978615,980296,981868,983499,985062,986552,987988,989355,990723,992045,993364,994732,996018,997307,998556,999756,1000912,1002035,1003126,1004189,1005259,1006267,1007255,1008200,1009125,1010055,1010971,1011839,1012717,1013633,1014552,1015407,1016218,1017015,1017855,1018626,1019366,1020128,1020918,
14,2947,18261,46656,82609,122359,162293,201394,238685,273817,307050,337834,366688,393545,418610,442360,464240,484665,503794,521551,538660,554676,569738,584075,597644,610421,622470,634014,645170,655530,665607,675130,684043,692633,700860,708551,716197,723491,730455,737182,743682,749902,755780,761547,767002,772319,777393,782406,787172,791617,796212,800636,804806,808782,812645,816351,819882,823346,826677,829993,833203,836285,839284,842196,845070,847849,850548,853157,855652,858118,860459,862724,864992,867200,869311,871418,873516,875474,877443,879235,881081,882885,884591,886229,887848,889435,890992,892529,894037,895449,896879,898218,899546,900885,902160,903381,904617,905812,907043,908150,909333,910408,911520,912614,913636,914697,915675,916650,917549,918498,919437,920322,921187,921984,922830,923647,924492,925283,926054,926812,
2,909,7897,23875,47170,75275,105414,135816,166199,195615,224004,250790,276185,300092,322825,344438,364593,383920,402036,419281,435454,450771,465381,479253,492374,504922,516709,528072,538521,548751,558695,568070,577077,585555,593731,601506,609104,616420,623366,630095,636650,642968,648826,654570,660004,665291,670457,675434,680380,685021,689565,693901,698082,702031,706012,709871,713494,716959,720384,723712,726918,730078,733094,736047,738902,741652,744330,747119,749644,752163,754603,756999,759250,761696,763788,765883,767909,770004,771953,773903,775717,777394,779157,780929,782552,784151,785755,787300,788921,790327,791830,793248,794634,795997,797311,798585,799903,801141,802316,803521,804691,805794,806922,807983,809044,810186,811178,812213,813151,814074,815005,815925,816868,817717,818576,819417,820204,821000,821804,822628,
0,354,4018,14082,30670,51963,75794,100827,126456,151989,177005,200922,223945,245788,266552,286451,305350,323438,340564,356741,371926,386641,400234,413303,425796,437990,449246,460330,470954,480982,490675,499842,508614,516944,524930,532767,540093,547254,554110,560583,567059,573180,579021,584695,590173,595537,600632,605515,610317,614934,619354,623784,628033,632050,635967,639802,643577,647014,650438,653733,657011,660120,663197,666253,669181,671932,674680,677416,680009,682572,684997,687362,689723,691943,694096,696183,698326,700273,702168,704114,706075,707924,709748,711544,713222,714911,716575,718107,719652,721188,722605,724020,725485,726897,728222,729552,730820,732123,733339,734562,735761,736970,738085,739192,740229,741299,742367,743380,744361,745336,746263,747204,748072,748965,749867,750757,751560,752384,753187,754003,
0,117,1836,7657,18349,33262,50925,70502,91400,112281,133369,153767,173756,193234,211835,229775,246928,263392,279001,293901,308128,321814,334743,347150,359191,370497,381443,392033,402080,411697,421011,429919,438037,446233,454031,461583,468732,475800,482624,489050,495331,501312,507084,512770,518134,523317,528273,533170,537950,542489,546848,551164,555367,559330,563319,567080,570872,574475,577874,581177,584428,587567,590668,593624,596546,599373,602065,604724,607343,609905,612398,614794,617147,619387,621607,623670,625735,627744,629702,631609,633493,635381,637150,638847,640576,642289,643951,645574,647137,648588,650096,651557,653033,654398,655688,657048,658357,659621,660890,662098,663327,664524,665712,666816,667974,669014,670049,671119,672098,673093,674028,674966,675863,676758,677678,678545,679397,680208,681057,681816,
0,25,697,3470,9572,19020,31198,45480,60912,77473,94463,111554,128022,144551,160652,176260,191322,205862,219605,233220,246222,258520,270474,281971,292958,303559,313743,323536,333014,342081,350850,359220,367366,375065,382589,389733,396717,403293,409713,415909,421909,427657,433184,438508,443731,448645,453526,458223,462928,467323,471607,475739,479785,483672,487449,491119,494594,498143,501646,504903,508129,511271,514362,517271,520164,522971,525652,528345,530856,533455,535935,538261,540611,542863,545081,547249,549286,551285,553281,555179,557130,558941,560663,562464,564186,565841,567457,569058,570625,572170,573656,575122,576564,578003,579317,580678,581988,583276,584520,585721,586899,588077,589239,590358,591458,592520,593591,594612,595603,596600,597568,598516,599456,600300,601193,602054,602896,603781,604618,605449,
0,4,205,1322,4357,9637,16981,26489,37060,48941,61555,74564,87791,101033,113933,126790,139231,151591,163649,175073,186540,197453,208060,218524,228364,238004,247293,256093,264772,273199,281183,288786,296171,303289,310440,317245,323685,329821,335988,341961,347584,352965,358403,363582,368565,373297,377859,382353,386741,391024,395188,399245,403169,406875,410534,414079,417505,420897,424127,427322,430427,433556,436499,439368,442226,444928,447546,450145,452684,455114,457505,459839,462108,464224,466335,468422,470501,472494,474419,476281,478259,480090,481899,483629,485306,486939,488565,490188,491726,493221,494725,496163,497637,499053,500421,501722,503040,504280,505508,506730,507853,508960,510070,511216,512305,513360,514425,515400,516415,517380,518303,519174,520106,521032,521919,522754,523591,524404,525183,525947,
0,1,41,354,1502,3875,7677,12946,19397,26995,35348,44261,53555,63145,72897,82594,92317,102026,111789,121204,130360,139512,148512,157350,165846,174027,181961,189591,197100,204307,211400,218120,224887,231414,237704,243762,249649,255371,260847,266011,271151,276209,281152,285963,290559,294996,299401,303539,307544,311474,315391,319100,322761,326351,329851,333262,336518,339708,342775,345809,348833,351761,354528,357214,359893,362499,365014,367524,369934,372271,374593,376803,378995,381141,383163,385167,387144,389008,390881,392679,394513,396213,397970,399671,401349,402956,404487,406049,407539,409000,410440,411879,413270,414622,415894,417169,418375,419608,420789,421956,423100,424240,425322,426424,427482,428504,429545,430525,431535,432433,433373,434275,435192,436090,436942,437738,438573,439421,440198,440969,
0,0,5,94,477,1399,3141,5812,9284,13788,18926,24739,31021,37698,44759,52065,59350,66759,74253,81632,89125,96377,103656,110652,117617,124311,131094,137618,144075,150287,156328,162288,168122,173753,179148,184497,189725,194979,199844,204617,209289,213819,218219,222276,226517,230611,234506,238269,241951,245666,249129,252617,255952,259188,262354,265500,268561,271491,274350,277173,279858,282571,285118,287673,290288,292674,295136,297522,299733,301910,304047,306117,308200,310211,312234,314149,315926,317790,319670,321469,323164,324833,326412,328018,329567,331147,332617,334125,335586,336986,338382,339752,341033,342360,343603,344782,346035,347210,348377,349464,350554,351663,352692,353705,354656,355644,356658,357657,358599,359532,360462,361391,362237,363111,363950,364817,365573,366336,367115,367910,
0,0,0,15,94,357,972,2030,3600,5792,8387,11580,15290,19264,23667,28289,33135,38040,43100,48387,53485,58789,64192,69496,74653,79832,85010,90101,95142,100026,104957,109812,114598,119236,123592,127849,132216,136483,140562,144690,148638,152488,156233,159913,163550,167054,170483,173690,176898,180145,183286,186405,189392,192360,195214,197909,200678,203287,205861,208444,210958,213377,215692,218026,220272,222407,224524,226590,228672,230616,232584,234400,236280,238073,239771,241497,243313,244985,246638,248241,249773,251326,252783,254266,255763,257169,258556,259986,261309,262633,263862,265121,266377,267595,268785,269904,271091,272209,273264,274361,275382,276395,277389,278316,279220,280168,281096,282038,282911,283819,284674,285539,286411,287254,288047,288824,289572,290350,291081,291839,
0,0,0,1,9,51,184,428,881,1647,2730,4053,5733,7579,9764,12125,14742,17502,20334,23400,26593,29910,33213,36703,40184,43680,47186,50691,54186,57688,61213,64760,68077,71444,74730,77986,81259,84440,87549,90751,93747,96732,99650,102484,105304,108074,110741,113465,116127,118732,121229,123628,126014,128422,130727,133052,135251,137408,139549,141637,143667,145621,147581,149554,151455,153280,155139,156996,158705,160462,162128,163724,165311,166882,168483,170008,171504,172987,174423,175818,177232,178628,179951,181242,182521,183736,184935,186205,187363,188526,189650,190784,191908,192953,193993,195009,196041,197022,197973,198905,199848,200806,201724,202581,203505,204360,205240,206057,206863,207663,208441,209244,209912,210708,211460,212193,212927,213642,214318,214943,
0,0,0,0,0,2,9,44,114,224,420,751,1144,1692,2362,3158,4076,5096,6240,7553,8868,10359,11910,13540,15263,16995,18769,20636,22528,24454,26349,28350,30271,32250,34245,36190,38190,40122,42206,44162,46136,48024,50024,51984,53828,55709,57513,59334,61075,62856,64617,66298,68000,69648,71215,72859,74498,76037,77555,79143,80647,82138,83606,85071,86545,87934,89328,90633,91950,93271,94608,95929,97123,98385,99625,100794,101974,103067,104238,105363,106426,107541,108597,109576,110636,111607,112577,113561,114516,115507,116446,117361,118254,119165,120027,120860,121667,122490,123309,124051,124812,125579,126349,127075,127762,128466,129160,129843,130560,131185,131837,132454,133058,133676,134273,134878,135522,136128,136755,137330,
118318,377140,579200,726326,837818,924966,995792,1054107,1103198,1145124,1181145,1212783,1240772,1265563,1287850,1308214,1326757,1343391,1358568,1372676,1385608,1397676,1408872,1419493,1429304,1438503,1447033,1455135,1462823,1470138,1477061,1483343,1489562,1495373,1500815,1506018,1510850,1515557,1520075,1524398,1528517,1532257,1536002,1539595,1543003,1546218,1549331,1552359,1555371,1558130,1560913,1563519,1566060,1568506,1570787,1573082,1575315,1577522,1579567,1581512,1583418,1585236,1587001,1588756,1590507,1592125,1593742,1595324,1596846,1598294,1599661,1601042,1602403,1603726,1604972,1606171,1607332,1608492,1609620,1610719,1611811,1612805,1613808,1614807,1615743,1616684,1617600,1618460,1619350,1620227,1621053,1621870,1622665,1623448,1624207,1624937,1625708,1626425,1627087,1627770,1628413,1629068,1629693,1630322,1630928,1631505,1632051,1632611,1633210,1633765,1634248,1634764,1635253,1635750,1636224,1636693,1637147,1637574,1638026,1638462,
45969,219485,388430,524040,632283,719874,791898,852815,904843,949799,988889,1023219,1053992,1081281,1105913,1128052,1148361,1166990,1183987,1199671,1214212,1227746,1240332,1252046,1262907,1273281,1282793,1291879,1300390,1308430,1316072,1323095,1329868,1336403,1342635,1348477,1354122,1359464,1364558,1369502,1374101,1378532,1382813,1386969,1390930,1394685,1398241,1401746,1405130,1408379,1411422,1414347,1417221,1420017,1422734,1425440,1427851,1430253,1432612,1434926,1437078,1439149,1441122,1443135,1445127,1446897,1448746,1450520,1452275,1453939,1455536,1457127,1458645,1460183,1461627,1462976,1464354,1465652,1466922,1468158,1469373,1470534,1471714,1472820,1473933,1475020,1476078,1477100,1478093,1479096,1480046,1480990,1481907,1482779,1483587,1484441,1485273,1486150,1486945,1487727,1488501,1489238,1489961,1490678,1491341,1492012,1492696,1493328,1493980,1494596,1495208,1495807,1496385,1496943,1497447,1498000,1498533,1499038,1499544,1500046,
22865,148278,291807,416121,518468,603356,675172,735798,788305,833967,873863,908814,940443,968836,994186,1017540,1038909,1058598,1076328,1092953,1108126,1122174,1135374,1147535,1159276,1170203,1180587,1190254,1199202,1207681,1215731,1223404,1230759,1237510,1244150,1250448,1256475,1262234,1267611,1272827,1277973,1282590,1287110,1291423,1295591,1299639,1303547,1307315,1310822,1314300,1317619,1320810,1323929,1326946,1329766,1332491,1335207,1337896,1340464,1342841,1345182,1347390,1349649,1351810,1353897,1355904,1357845,1359723,1361596,1363399,1365193,1366895,1368552,1370146,1371689,1373176,1374577,1375998,1377413,1378773,1380115,1381384,1382622,1383799,1384972,1386079,1387239,1388303,1389336,1390376,1391422,1392428,1393458,1394415,1395314,1396261,1397154,1398052,1398981,1399809,1400588,1401365,1402163,1402898,1403668,1404348,1405104,1405743,1406413,1407093,1407732,1408366,1408990,1409591,1410148,1410706,1411251,1411790,1412336,1412872,
8765,86605,197557,303649,396555,476403,544961,604083,655568,701160,741280,777111,809384,838588,865199,889015,911049,931200,949919,967086,983211,998096,1011981,1025045,1037466,1048865,1059765,1069941,1079490,1088624,1097122,1105412,1113182,1120437,1127481,1134109,1140423,1146608,1152407,1157947,1163288,1168346,1173204,1177959,1182446,1186791,1190881,1194910,1198821,1202608,1206212,1209625,1213028,1216152,1219179,1222195,1225153,1227883,1230642,1233321,1235866,1238245,1240662,1242906,1245101,1247327,1249407,1251453,1253379,1255250,1257059,1258880,1260612,1262310,1264044,1265711,1267294,1268797,1270298,1271774,1273207,1274641,1276015,1277244,1278492,1279739,1280940,1282151,1283371,1284534,1285585,1286684,1287755,1288785,1289756,1290716,1291711,1292620,1293583,1294519,1295410,1296260,1297081,1297879,1298709,1299482,1300258,1301046,1301797,1302505,1303197,1303883,1304526,1305144,1305776,1306413,1307004,1307631,1308233,1308785,
2172,40264,114155,196110,272954,343084,405543,460884,509886,554070,593377,628458,660376,689586,716395,740700,763073,783905,803281,820944,837509,853076,867368,880935,893656,905666,917037,927552,937642,947264,956503,965112,973068,980788,988257,995345,1002215,1008803,1014950,1021049,1026779,1032267,1037420,1042444,1047331,1052057,1056543,1060877,1065000,1068855,1072726,1076385,1079780,1083290,1086572,1089717,1092885,1095895,1098813,1101670,1104352,1106991,1109643,1112196,1114537,1116894,1119182,1121427,1123500,1125541,1127628,1129570,1131458,1133253,1135095,1136928,1138699,1140437,1142109,1143678,1145242,1146794,1148233,1149661,1151051,1152504,1153783,1155028,1156295,1157585,1158759,1159956,1161133,1162262,1163358,1164371,1165411,1166490,1167449,1168421,1169342,1170270,1171132,1171983,1172902,1173739,1174554,1175423,1176279,1177026,1177788,1178531,1179252,1179957,1180691,1181376,1182016,1182643,1183294,1183912,
897,24443,79416,146344,213405,276289,333524,385634,432282,474110,512342,547283,578805,607621,634058,658150,680334,701063,720327,738086,754926,770457,784938,798658,811648,823659,835141,845983,856304,866179,875570,884410,892779,900796,908433,915670,922689,929477,935985,942086,947916,953535,958841,963959,968890,973605,978185,982630,986861,990987,994980,998771,1002384,1005946,1009404,1012719,1015960,1019070,1022097,1025059,1027806,1030619,1033292,1035918,1038236,1040699,1043002,1045353,1047531,1049755,1051825,1053924,1055940,1057773,1059639,1061437,1063244,1065031,1066727,1068454,1070064,1071658,1073216,1074662,1076169,1077578,1078905,1080239,1081473,1082825,1084061,1085300,1086523,1087716,1088921,1090022,1091079,1092153,1093187,1094190,1095189,1096092,1097069,1097999,1098883,1099762,1100620,1101460,1102246,1103062,1103893,1104724,1105483,1106249,1107010,1107749,1108405,1109056,1109687,1110348,
250,12837,50420,101691,157223,211578,262777,309988,353535,393099,429316,461914,492466,520345,545923,569698,591649,612079,631183,648841,665624,681382,696095,709902,723201,735476,747294,758325,768595,778451,788136,796860,805242,813415,821220,828647,835617,842447,849121,855413,861396,867041,872428,877850,882943,887823,892614,897240,901600,905902,909995,913946,917739,921338,924869,928416,931640,934966,938016,941196,944133,946944,949760,952462,955120,957636,960041,962351,964650,966951,969242,971359,973391,975305,977244,979149,980971,982841,984594,986385,987998,989636,991183,992791,994306,995789,997183,998511,999876,1001256,1002571,1003733,1004968,1006176,1007412,1008583,1009709,1010835,1011947,1013063,1014068,1015106,1016093,1017018,1017931,1018867,1019721,1020596,1021467,1022283,1023123,1023889,1024716,1025515,1026226,1026984,1027703,1028418,1029124,1029820,
74,5856,28544,64430,107092,151417,194812,236242,274997,310760,344324,375147,403753,430225,455034,478055,499408,519184,538232,555499,571914,587353,601959,615616,628470,640826,652644,663594,674269,684175,693765,702926,711332,719612,727444,734920,742063,748834,755552,762002,768067,773839,779447,784880,790067,795086,799903,804532,809079,813464,817749,821793,825677,829421,833161,836753,840090,843324,846564,849629,852741,855732,858593,861303,864004,866609,869142,871658,874068,876363,878504,880701,882831,884859,886910,888787,890717,892599,894480,896224,897952,899696,901301,902883,904391,905885,907357,908845,910243,911584,912979,914291,915609,916898,918174,919411,920569,921659,922769,923854,924916,926013,927093,928041,929064,930046,930953,931824,932684,933583,934503,935346,936212,937019,937798,938573,939334,940043,940754,941453,
9,2024,13202,35391,64962,98473,132625,166638,199376,230406,259892,287813,313668,337892,360802,382324,402352,421247,439104,455861,471633,486600,500819,514313,527040,539096,550652,561508,571917,581654,591205,600401,608989,616915,624819,632317,639569,646576,653185,659649,665715,671705,677331,682787,688006,693149,698063,702915,707431,711713,715992,720132,724156,727938,731617,735178,738598,742081,745261,748560,751604,754531,757366,760178,762899,765582,768185,770739,773146,775448,777755,779988,782131,784246,786358,788291,790387,792309,794180,795944,797694,799438,801034,802704,804191,805739,807306,808812,810270,811703,813090,814454,815817,817192,818427,819617,820863,822079,823193,824368,825501,826541,827590,828609,829613,830566,831569,832591,833510,834403,835253,836154,837014,837887,838718,839529,840323,841082,841820,842545,
2,901,7577,22695,44646,70902,99162,128102,156439,184156,210584,235823,259959,282261,303720,323921,343004,361035,378037,394085,409386,423873,437554,450478,462911,474620,485609,496273,506446,516259,525625,534405,542883,550990,558697,566110,573276,580181,586802,593214,599413,605386,610945,616320,621627,626717,631561,636277,640926,645362,649559,653766,657726,661614,665327,668942,672477,675812,679126,682294,685405,688362,691258,694044,696803,699461,702062,704658,707164,709597,711911,714228,716410,718625,720657,722749,724731,726662,728480,730317,732197,733939,735675,737344,738960,740552,742112,743580,745027,746466,747916,749286,750601,751946,753232,754538,755834,757015,758137,759317,760426,761502,762612,763691,764686,765701,766710,767658,768630,769543,770407,771219,772086,772923,773772,774620,775416,776188,776985,777790,
0,331,3762,13125,28313,47969,69918,93112,116860,140320,163152,185359,206574,227114,246777,265264,282680,299557,315464,330661,345031,358852,371841,384139,396108,407380,418271,428678,438447,447902,456924,465458,473690,481660,489350,496779,503748,510560,517037,523240,529253,535074,540515,545972,551078,556130,561125,565803,570345,574699,578857,583013,587005,590893,594679,598244,601880,605340,608658,611921,614983,617965,620899,623700,626530,629244,631790,634368,636911,639320,641669,643942,646223,648347,650457,652578,654575,656495,658280,660161,662031,663801,665491,667180,668860,670462,672050,673585,675064,676501,677966,679337,680638,681988,683296,684548,685809,686986,688224,689378,690508,691620,692707,693799,694856,695890,696867,697922,698858,699801,700759,701681,702571,703411,704242,705039,705795,706593,707418,708220,
0,108,1604,6573,15874,29184,45135,62747,81351,100168,119299,138055,156394,174208,191306,207844,223648,238840,253231,267327,280684,293377,305569,317369,328645,339225,349444,359150,368522,377607,386214,394514,402666,410150,417561,424702,431394,437867,444155,450178,456106,461792,467312,472569,477440,482439,487241,491806,496273,500568,504674,508681,512599,516392,520052,523703,527209,530624,533966,537181,540292,543242,546179,548991,551720,554367,557008,559581,562090,564583,566844,569184,571365,573493,575582,577626,579608,581611,583475,585305,587077,588940,590695,592449,594088,595701,597269,598778,600194,601616,603065,604461,605852,607168,608442,609760,611039,612254,613461,614643,615773,616884,617973,619045,619982,621015,622029,623012,623974,624934,625889,626769,627665,628544,629404,630247,631064,631816,632612,633374,
0,20,619,2892,7995,15927,26445,38786,52262,66598,81894,97014,111872,126488,140819,154872,168516,181651,194463,206744,218531,229683,240724,251097,261128,270902,280400,289480,298258,306666,314670,322512,330186,337318,344243,350847,357343,363563,369527,375435,381013,386517,391804,396853,401772,406522,411113,415577,419998,424147,428204,432037,435809,439491,443171,446629,449964,453204,456380,459575,462690,465635,468475,471359,474019,476569,479105,481666,484068,486464,488806,491008,493144,495236,497326,499422,501392,503387,505271,507072,508859,510636,512327,514045,515657,517318,518842,520403,521877,523287,524777,526158,527522,528909,530171,531425,532679,533878,535080,536347,537489,538603,539669,540766,541760,542745,543784,544767,545671,546590,547539,548471,549371,550201,551012,551882,552683,553502,554278,555034,
0,5,133,865,3086,7066,12863,20308,29142,38773,49591,60592,71754,83109,94335,105472,116505,127262,137769,147924,157995,167708,177157,186557,195401,204111,212076,220114,227993,235454,242706,249815,256609,263191,269491,275617,281470,287198,292719,298060,303164,308403,313370,318217,322713,327154,331437,335698,339585,343575,347347,351134,354841,358391,361769,365105,368294,371402,374521,377510,380381,383298,386132,388776,391345,393926,396428,398823,401135,403404,405670,407815,409986,412043,414124,416115,418041,419882,421706,423505,425259,426949,428686,430327,431972,433491,435036,436428,437848,439319,440716,442093,443446,444742,446065,447308,448568,449773,450957,452064,453186,454279,455356,456415,457426,458464,459481,460462,461413,462331,463248,464160,465078,465942,466775,467590,468390,469192,469988,470719,
0,0,26,235,1100,2857,5839,9974,15269,21509,28586,36133,44079,52107,60648,69080,77519,86024,94582,102863,111090,119162,126970,134660,142402,149722,156935,163928,170656,177152,183342,189500,195475,201490,207266,212887,218159,223342,228357,233320,237965,242650,247038,251304,255636,259738,263685,267608,271449,275101,278612,282095,285502,288860,292012,295143,298195,301117,304015,306820,309559,312181,314815,317421,319970,322368,324719,327112,329404,331617,333823,335899,337874,339897,341856,343708,345531,347377,349158,350913,352595,354291,355866,357438,359006,360487,362000,363453,364857,366212,367562,368864,370148,371436,372611,373809,374994,376163,377321,378433,379501,380541,381587,382632,383614,384580,385592,386535,387415,388348,389244,390103,390960,391823,392698,393508,394270,395062,395812,396557,
0,0,2,42,266,816,1958,3757,6357,9669,13544,17983,23012,28264,33777,39559,45558,51553,57672,63886,69925,75990,82113,88104,94098,99880,105613,111214,116693,122041,127367,132405,137409,142304,146979,151630,156187,160676,165083,169182,173324,177349,181281,185015,188769,192358,195983,199339,202615,205887,209091,212159,215308,218388,221314,224117,226962,229617,232205,234759,237213,239693,242052,244327,246606,248807,251009,253114,255145,257102,259130,261015,262885,264742,266559,268380,270146,271762,273447,275134,276823,278299,279724,281219,282639,284104,285482,286839,288173,289551,290860,292139,293349,294504,295691,296841,297965,299070,300176,301147,302182,303202,304171,305156,306087,307023,307951,308843,309716,310598,311432,312266,313087,313848,314628,315415,316186,316971,317687,318432,
0,0,0,1,23,133,417,950,1774,3011,4649,6646,9057,11606,14504,17701,21066,24652,28271,32116,35898,40065,44134,48312,52376,56426,60447,64382,68404,72189,76269,80149,83902,87601,91286,94878,98435,102036,105435,108700,111974,115180,118243,121274,124263,127191,130115,132973,135739,138365,141074,143577,146169,148673,151105,153442,155811,158127,160293,162502,164634,166702,168776,170723,172712,174628,176561,178431,180262,181973,183726,185442,187124,188759,190383,191899,193426,194919,196345,197763,199193,200582,201951,203273,204513,205769,206970,208222,209410,210554,211757,212956,214097,215149,216204,217283,218293,219272,220215,221226,222222,223133,224060,224954,225796,226691,227508,228326,229105,229885,230741,231554,232298,233016,233786,234526,235240,235921,236608,237277,
0,0,0,0,1,11,38,108,233,479,844,1349,2033,2859,3923,5052,6341,7820,9410,11157,12843,14660,16691,18706,20875,22999,25227,27457,29752,31966,34265,36593,38910,41092,43427,45723,47960,50247,52526,54755,57015,59101,61177,63273,65298,67356,69392,71507,73351,75277,77150,78999,80844,82683,84461,86231,87898,89564,91206,92851,94509,96056,97622,99159,100672,102236,103699,105154,106602,107936,109292,110619,111921,113182,114488,115732,116984,118135,119362,120492,121646,122786,123851,124908,125962,127018,128043,129043,130022,130986,131984,132989,133946,134922,135849,136714,137576,138388,139164,139985,140788,141576,142363,143143,143882,144624,145294,146038,146703,147358,147968,148643,149277,149925,150589,151189,151812,152388,153019,153564,
135412,399097,596961,739244,846096,929743,997392,1053225,1099907,1140111,1174593,1205038,1231717,1255739,1276940,1296083,1313763,1329697,1344398,1357899,1370346,1381765,1392456,1402508,1411981,1420876,1429135,1436948,1444116,1451037,1457544,1463720,1469601,1475270,1480502,1485450,1490111,1494686,1499044,1503148,1507093,1510823,1514423,1517850,1521144,1524351,1527246,1530239,1533092,1535856,1538481,1541059,1543489,1545838,1548099,1550318,1552431,1554443,1556492,1558430,1560340,1562124,1563815,1565581,1567329,1568905,1570465,1571987,1573470,1574949,1576340,1577652,1578947,1580259,1581502,1582664,1583787,1584931,1586001,1587056,1588071,1589066,1590023,1590968,1591909,1592855,1593759,1594648,1595476,1596284,1597108,1597906,1598685,1599437,1600159,1600901,1601622,1602332,1603033,1603715,1604370,1605014,1605595,1606202,1606807,1607404,1607954,1608498,1609021,1609572,1610070,1610580,1611094,1611552,1612004,1612456,1612911,1613356,1613771,1614173,
56936,242407,413186,546379,652211,736345,805518,863922,913667,956179,993179,1025905,1055075,1081090,1104294,1125341,1144621,1162520,1178617,1193586,1207467,1220275,1232213,1243477,1253836,1263631,1272911,1281590,1289684,1297354,1304568,1311433,1318072,1324260,1329968,1335608,1341021,1346184,1350981,1355696,1360097,1364284,1368308,1372295,1376154,1379835,1383294,1386612,1389970,1393089,1396067,1398978,1401649,1404245,1406826,1409364,1411800,1414222,1416516,1418710,1420850,1422819,1424810,1426724,1428616,1430343,1432139,1433835,1435507,1437081,1438678,1440232,1441782,1443177,1444570,1445962,1447292,1448591,1449855,1451072,1452274,1453456,1454539,1455616,1456729,1457742,1458755,1459762,1460731,1461682,1462609,1463528,1464381,1465221,1466067,1466925,1467714,1468485,1469271,1470032,1470735,1471458,1472159,1472851,1473515,1474153,1474798,1475419,1476043,1476669,1477309,1477879,1478448,1479010,1479553,1480056,1480564,1481091,1481555,1482016,
30836,169706,317833,441687,542304,625266,694153,752405,802592,846438,884635,918048,948001,975286,999600,1021662,1042062,1060454,1077381,1093087,1107470,1121080,1133717,1145432,1156420,1166835,1176585,1185819,1194551,1202702,1210356,1217792,1224691,1231094,1237272,1243305,1249098,1254560,1259828,1264718,1269495,1273993,1278326,1282548,1286626,1290518,1294282,1297899,1301351,1304727,1307957,1311003,1314095,1316938,1319632,1322313,1324944,1327464,1329812,1332082,1334356,1336592,1338712,1340767,1342743,1344597,1346442,1348363,1350066,1351783,1353461,1355062,1356656,1358191,1359718,1361181,1362543,1363938,1365225,1366511,1367780,1369027,1370178,1371369,1372478,1373571,1374685,1375770,1376822,1377868,1378832,1379800,1380801,1381771,1382643,1383514,1384336,1385246,1386057,1386854,1387644,1388425,1389197,1389936,1390682,1391382,1392120,1392801,1393476,1394094,1394718,1395315,1395918,1396459,1397068,1397571,1398137,1398705,1399230,1399715,
12980,104144,223065,330732,423088,501746,568449,626124,675975,719673,758256,792467,823155,851206,876358,899256,920117,939477,957115,973742,988875,1003200,1016378,1028723,1040353,1051361,1061775,1071331,1080624,1089270,1097452,1105082,1112572,1119623,1126284,1132670,1138890,1144763,1150193,1155498,1160591,1165431,1170010,1174573,1178953,1183035,1187117,1190872,1194676,1198165,1201657,1204962,1208238,1211214,1214118,1217077,1219866,1222546,1225155,1227659,1230089,1232398,1234713,1236836,1239031,1241051,1243104,1245052,1246851,1248655,1250380,1252082,1253804,1255368,1257039,1258651,1260188,1261643,1263029,1264482,1265775,1267137,1268482,1269774,1270885,1272064,1273184,1274287,1275529,1276628,1277664,1278719,1279790,1280791,1281747,1282684,1283610,1284453,1285396,1286259,1287156,1288068,1288870,1289664,1290416,1291180,1291908,1292660,1293388,1294108,1294792,1295432,1296080,1296650,1297263,1297844,1298419,1299006,1299597,1300129,
3765,52757,135873,222730,301606,372047,434146,488686,537004,579628,617875,652108,682844,710830,736252,759621,781008,800760,819012,836090,851740,866649,880386,893434,905542,917052,927684,937891,947494,956603,965246,973348,981035,988361,995512,1002203,1008602,1014788,1020782,1026565,1032074,1037141,1042113,1047050,1051689,1056240,1060498,1064416,1068390,1072148,1075832,1079347,1082701,1086006,1089169,1092205,1095260,1098212,1100993,1103724,1106383,1108837,1111405,1113799,1116012,1118316,1120510,1122548,1124625,1126600,1128539,1130339,1132152,1133807,1135520,1137234,1138912,1140458,1141991,1143486,1144920,1146400,1147760,1149112,1150461,1151723,1153017,1154260,1155501,1156748,1157883,1159017,1160149,1161274,1162350,1163345,1164328,1165280,1166242,1167221,1168107,1168973,1169834,1170696,1171516,1172301,1173079,1173865,1174659,1175410,1176143,1176861,1177593,1178263,1178997,1179644,1180253,1180836,1181491,1182102,
1750,33540,98251,171415,241654,306063,363970,415740,461856,503497,540780,574238,604675,632606,658149,681283,702588,722552,741117,758362,774220,789275,803031,816193,828455,840198,851088,861524,871463,880646,889527,897969,905851,913464,920726,927704,934275,940519,946614,952332,957884,963297,968395,973401,978206,982785,987222,991425,995549,999562,1003341,1006920,1010407,1013722,1016920,1020124,1023225,1026238,1029191,1032012,1034591,1037176,1039725,1042197,1044528,1046940,1049178,1051370,1053440,1055528,1057513,1059422,1061326,1063112,1064916,1066653,1068351,1070021,1071679,1073283,1074770,1076264,1077756,1079132,1080493,1081765,1083091,1084330,1085623,1086865,1088099,1089306,1090477,1091602,1092720,1093731,1094752,1095787,1096784,1097743,1098693,1099561,1100536,1101422,1102333,1103158,1104009,1104823,1105606,1106412,1107168,1107959,1108673,1109370,1110071,1110760,1111392,1112044,1112717,1113323,
601,19206,65449,123653,183916,240754,293140,341604,385285,424504,460250,492977,522641,550010,574841,597900,619213,639103,657706,674722,690814,705694,719821,732995,745482,757307,768369,778960,788820,798185,807223,815623,823791,831648,838908,845964,852805,859226,865548,871510,877105,882690,887998,893057,897852,902537,907090,911431,915593,919713,923583,927370,930911,934366,937757,940931,944135,947200,950148,953101,955872,958510,961125,963723,966244,968651,971051,973280,975487,977590,979762,981757,983779,985541,987399,989207,990939,992683,994368,996037,997668,999191,1000679,1002155,1003561,1004951,1006283,1007569,1008864,1010137,1011405,1012619,1013843,1015017,1016139,1017290,1018355,1019431,1020428,1021434,1022485,1023455,1024382,1025294,1026150,1027066,1027903,1028734,1029567,1030422,1031240,1031985,1032737,1033471,1034230,1034973,1035721,1036384,1037017,1037662,
168,9251,39043,81790,129564,177754,223326,266186,305619,342202,375701,406179,434525,460498,484821,507320,528198,547591,565861,582775,598592,613574,627758,640871,653359,665119,676230,686703,696706,706319,715492,724132,732239,740191,747621,754796,761691,768175,774536,780620,786444,792017,797349,802512,807385,812155,816797,821259,825539,829832,833886,837765,841479,845026,848482,851853,855078,858205,861274,864199,867126,869933,872665,875392,877944,880490,882933,885294,887546,889801,892000,894106,896043,897965,899889,901822,903651,905427,907125,908847,910466,912077,913677,915244,916773,918207,919606,921017,922400,923816,925113,926387,927700,928942,930078,931236,932355,933438,934515,935571,936611,937624,938634,939519,940458,941326,942193,943072,943943,944780,945626,946442,947254,948021,948800,949559,950281,951019,951646,952348,
33,3677,19739,48000,82720,120157,157536,193795,227974,260575,291010,319210,345528,369943,392852,414222,434088,452741,470288,486738,502218,516750,530370,543335,555621,567462,578215,588929,598931,608436,617456,626055,634519,642309,649932,657153,664126,670792,677174,683308,689274,694961,700442,705712,710792,715745,720371,724870,729288,733369,737545,741498,745320,749034,752583,756076,759477,762755,765809,768918,771873,774688,777439,780202,782849,785364,787791,790152,792467,794638,796809,798932,800945,803033,805050,806986,808864,810721,812489,814264,815949,817620,819271,820809,822360,823877,825329,826799,828124,829445,830810,832093,833359,834561,835731,836918,838046,839200,840269,841360,842424,843372,844343,845365,846325,847238,848169,849075,849991,850842,851686,852536,853318,854117,854915,855666,856445,857177,857894,858634,
11,1804,12006,32269,59580,90137,121644,152656,183122,212162,239831,265832,290191,313355,334959,355089,374240,392099,409046,424900,439889,454070,467472,480105,492330,503827,514638,525051,534879,544297,553304,561975,570322,578258,585708,592857,599743,606465,612920,619021,624933,630766,636186,641379,646405,651201,655911,660526,664921,669171,673221,677158,681032,684697,688341,691879,695203,698425,701552,704653,707628,710582,713373,716054,718663,721281,723839,726244,728549,730897,733105,735285,737429,739474,741421,743403,745252,747071,748892,750726,752419,754120,755756,757377,758922,760468,761921,763382,764803,766168,767589,768879,770194,771503,772753,773935,775115,776205,777339,778496,779596,780644,781622,782616,783615,784544,785524,786442,787333,788275,789098,789948,790718,791524,792340,793122,793921,794647,795367,796135,
0,766,6627,19816,39196,62800,88454,114628,140517,166270,190651,214180,236410,257549,277217,296118,313811,330721,346721,361868,376556,390026,402853,415105,426822,437904,448419,458754,468331,477625,486419,494789,502819,510606,518082,525289,532032,538642,544958,551087,556931,562558,567861,573198,578079,582862,587465,591976,596453,600829,604956,608826,612741,616541,620276,623798,627156,630426,633584,636692,639777,642620,645377,648129,650879,653453,655939,658380,660801,663092,665425,667583,669820,671916,673896,675889,677889,679721,681515,683217,684962,686691,688285,689894,691476,693008,694535,696068,697541,698964,700321,701658,702979,704247,705474,706646,707927,709058,710216,711295,712379,713471,714513,715551,716521,717492,718416,719339,720261,721171,722096,722966,723793,724585,725419,726223,726983,727743,728484,729253,
0,224,3027,10798,23663,40655,59949,80524,101791,123014,144233,164505,183990,202749,220913,238041,254208,269913,284590,298730,312197,324971,337284,348993,360192,370794,380852,390432,399516,408286,416914,425085,432788,440330,447498,454455,461201,467532,473652,479540,485346,490909,496171,501281,506208,510956,515606,520027,524324,528505,532482,536485,540308,543948,547490,550971,554293,557552,560726,563795,566844,569814,572608,575397,578077,580684,583208,585678,588130,590487,592837,595124,597294,599385,601393,603327,605254,607049,608848,610637,612370,614102,615802,617352,618969,620546,622026,623503,624941,626360,627754,629034,630330,631631,632796,634102,635340,636562,637705,638827,639895,640985,642121,643135,644121,645166,646119,647083,648031,648890,649800,650677,651537,652369,653169,653986,654773,655519,656318,657060,
0,61,1125,4933,12320,23136,36348,51234,67204,83802,100629,117506,133872,149630,165266,180279,194489,208344,221539,234142,246292,257922,269083,279784,290035,299983,309453,318552,327163,335622,343730,351571,359167,366259,373252,379956,386365,392556,398553,404367,409821,415144,420375,425418,430179,434802,439368,443697,447915,451997,456022,459787,463551,467150,470585,474001,477211,480457,483631,486737,489715,492629,495345,498118,500729,503308,505854,508300,510709,513001,515271,517512,519612,521689,523687,525683,527616,529457,531281,533083,534803,536506,538103,539737,541330,542904,544451,545906,547362,548755,550131,551486,552823,554102,555324,556585,557823,558987,560153,561341,562443,563521,564534,565632,566678,567663,568605,569477,570355,571278,572223,573086,573981,574812,575565,576362,577152,577896,578651,579419,
0,11,306,1763,5329,11159,19096,28930,39846,51848,64332,76924,89491,101983,114382,126454,138234,149863,161201,172139,182727,192815,202766,212276,221444,230390,238571,246870,254669,262287,269634,276764,283718,290355,296737,302967,308817,314490,320018,325445,330646,335754,340758,345448,350075,354486,358618,362757,366752,370665,374607,378335,382032,385556,388836,392126,395339,398475,401621,404560,407434,410238,413015,415626,418194,420758,423195,425549,427945,430185,432361,434466,436450,438442,440463,442398,444294,446149,447925,449638,451413,453105,454783,456446,458033,459551,461033,462441,463821,465255,466611,467988,469284,470537,471709,472930,474099,475283,476414,477502,478585,479696,480754,481795,482860,483831,484812,485708,486624,487543,488450,489313,490182,491022,491856,492642,493409,494176,494908,495668,
0,1,76,577,2000,4859,9137,14951,21976,29903,38514,47567,57029,66585,76374,86015,95506,104965,114245,123336,132155,140785,149203,157484,165512,173230,180727,188057,194982,201750,208329,214720,220980,226961,232824,238531,243948,249113,254294,259171,263961,268655,273040,277462,281800,285939,289981,293803,297686,301385,304973,308507,311825,315044,318229,321326,324361,327265,330150,332906,335631,338242,340866,343427,345879,348315,350626,352953,355242,357443,359594,361569,363587,365465,367377,369256,371173,372827,374653,376309,377969,379566,381154,382746,384321,385834,387232,388655,390016,391398,392693,393948,395245,396482,397731,398913,400075,401241,402397,403513,404542,405543,406575,407566,408560,409454,410421,411339,412281,413198,414114,414907,415792,416622,417379,418194,418998,419759,420487,421240,
0,0,7,108,527,1590,3412,6143,9852,14216,19367,25056,31061,37460,44185,50981,57974,64789,71580,78453,85241,91956,98527,105155,111576,117773,123864,129959,135804,141476,147115,152524,157660,162890,167812,172756,177465,182117,186592,190962,195118,199233,203216,207096,210959,214733,218348,221911,225256,228582,231757,234911,237972,241026,243914,246750,249550,252274,254900,257438,259957,262418,264887,267167,269421,271729,273911,275993,278081,280046,282068,284007,285866,287693,289586,291411,293174,294833,296495,298156,299806,301394,302861,304312,305738,307146,308511,309831,311152,312527,313840,315067,316264,317425,318575,319734,320957,322055,323177,324199,325193,326182,327152,328107,329031,329969,330890,331733,332608,333461,334349,335152,335942,336690,337487,338248,339026,339757,340468,341193,
0,0,0,14,76,291,791,1672,3057,4840,7190,9908,13040,16576,20242,24150,28308,32553,37107,41508,46163,50782,55336,59991,64527,69145,73580,78004,82507,86727,90979,95168,99243,103312,107301,111107,114939,118659,122347,125818,129245,132669,135946,139196,142431,145555,148519,151541,154392,157196,159988,162825,165433,167927,170392,172749,175165,177488,179799,182014,184144,186321,188499,190525,192540,194500,196403,198251,200067,201926,203652,205375,207131,208656,210328,211901,213437,214961,216476,217922,219353,220674,222017,223385,224674,225939,227165,228445,229665,230899,232038,233164,234348,235435,236501,237508,238547,239542,240552,241477,242462,243431,244330,245250,246100,246966,247778,248595,249415,250186,250991,251720,252470,253233,253946,254669,255371,256029,256716,257400,
0,0,0,0,2,17,80,221,482,887,1495,2334,3295,4535,5894,7461,9137,11026,13009,15211,17397,19673,22062,24558,27055,29623,32162,34743,37360,39920,42522,45091,47633,50241,52816,55391,57927,60343,62699,65210,67565,70005,72432,74688,76907,79146,81340,83444,85574,87632,89714,91721,93643,95561,97436,99294,101138,102950,104737,106457,108167,109863,111415,113022,114642,116182,117716,119157,120671,122077,123403,124712,126074,127456,128757,130044,131310,132603,133806,135002,136155,137287,138370,139460,140566,141624,142643,143657,144628,145619,146587,147568,148517,149420,150338,151240,152090,152957,153772,154650,155476,156278,157100,157910,158722,159468,160201,160917,161549,162214,162915,163546,164190,164868,165518,166169,166785,167405,168018,168582,
19838,173333,370219,545334,692306,815176,918037,1005068,1079605,1143765,1199541,1248793,1291863,1330266,1364507,1395324,1423176,1448351,1471262,1492575,1511952,1529787,1546142,1561280,1575298,1588353,1600567,1611887,1622462,1632341,1641585,1650378,1658565,1666332,1673681,1680598,1686999,1693060,1698844,1704232,1709461,1714263,1718979,1723473,1727721,1731806,1735743,1739275,1742714,1746065,1749321,1752367,1755248,1758023,1760593,1763164,1765702,1767968,1770220,1772352,1774477,1776497,1778369,1780230,1782034,1783820,1785484,1787088,1788559,1790042,1791435,1792881,1794237,1795536,1796811,1798031,1799146,1800233,1801366,1802359,1803378,1804381,1805359,1806305,1807195,1808139,1808975,1809849,1810668,1811437,1812162,1812836,1813541,1814221,1814861,1815491,1816113,1816727,1817312,1817867,1818448,1818950,1819536,1820040,1820532,1821040,1821524,1821987,1822441,1822889,1823284,1823673,1824083,1824507,1824889,1825298,1825667,1826020,1826363,1826715,
1319,42983,141594,258574,372923,477879,571513,655570,729766,795440,853930,906378,953430,995946,1034607,1069485,1101324,1130602,1157313,1181777,1204527,1225616,1244913,1262867,1279577,1295190,1309868,1323710,1336689,1348780,1360028,1370643,1380555,1389902,1398779,1407173,1415078,1422665,1429785,1436604,1443168,1449272,1455066,1460722,1465958,1471038,1475806,1480481,1484925,1489157,1493155,1497003,1500681,1504281,1507689,1510832,1513929,1516960,1519891,1522679,1525316,1527879,1530331,1532602,1534927,1537207,1539291,1541312,1543321,1545252,1547145,1549018,1550757,1552395,1553928,1555501,1557033,1558586,1559965,1561316,1562590,1563846,1565078,1566194,1567356,1568466,1569517,1570591,1571577,1572605,1573554,1574522,1575464,1576359,1577152,1577985,1578778,1579634,1580393,1581082,1581803,1582523,1583204,1583855,1584501,1585084,1585714,1586331,1586895,1587439,1587993,1588512,1588993,1589469,1589932,1590402,1590910,1591385,1591864,1592327,
146,13175,63035,138011,221576,305510,384932,458380,525955,587543,643813,695125,741226,783594,822432,858101,890474,920471,948127,973800,997693,1020000,1040767,1060182,1077943,1094650,1110304,1125038,1138839,1151849,1164312,1175808,1186627,1197015,1206730,1216010,1224792,1233163,1240899,1248313,1255650,1262547,1269075,1275349,1281209,1286874,1292274,1297331,1302242,1306980,1311543,1315850,1320041,1323978,1327820,1331456,1335024,1338456,1341594,1344680,1347679,1350576,1353394,1356049,1358675,1361131,1363528,1365798,1368038,1370191,1372276,1374244,1376226,1378126,1379916,1381713,1383461,1385164,1386823,1388283,1389713,1391250,1392678,1394031,1395411,1396663,1397878,1399097,1400283,1401432,1402560,1403661,1404716,1405758,1406732,1407701,1408626,1409559,1410492,1411322,1412144,1412968,1413780,1414527,1415288,1415998,1416698,1417410,1418089,1418709,1419329,1419920,1420510,1421084,1421647,1422172,1422711,1423215,1423771,1424292,
3,2390,19062,54296,102445,157423,214536,271062,325276,376595,424905,469937,511888,550950,587223,621045,652615,681964,709368,734981,758822,781086,801754,821228,839570,856882,873182,888633,902841,916488,929325,941677,953227,963883,974196,984194,993427,1002255,1010897,1019005,1026711,1034129,1041128,1047738,1054109,1060132,1066024,1071700,1077151,1082293,1087382,1092103,1096653,1101006,1105296,1109482,1113387,1117120,1120603,1124041,1127360,1130630,1133790,1136760,1139644,1142452,1145141,1147708,1150192,1152629,1155030,1157293,1159437,1161482,1163441,1165349,1167323,1169126,1170890,1172607,1174371,1176044,1177679,1179256,1180742,1182180,1183594,1184934,1186270,1187508,1188727,1189962,1191173,1192327,1193412,1194505,1195544,1196579,1197614,1198635,1199564,1200497,1201402,1202307,1203113,1203982,1204780,1205546,1206313,1207026,1207766,1208443,1209150,1209779,1210442,1211059,1211665,1212280,1212902,1213489,
0,168,3351,13971,33531,60232,91823,126031,161489,197357,232605,266610,299714,331179,361196,389691,416553,442020,465980,488732,510496,531028,550373,568509,586043,602398,617925,632756,646888,659881,672549,684432,696014,706940,717135,727000,736429,745535,754246,762450,770266,777742,784922,791825,798360,804573,810501,816320,822161,827457,832624,837473,842261,846844,851375,855615,859691,863726,867652,871389,874906,878283,881578,884735,887715,890734,893688,896441,899099,901634,904036,906332,908674,911012,913218,915300,917474,919551,921503,923394,925233,926993,928659,930350,931968,933577,935080,936571,937986,939424,940866,942181,943420,944686,945920,947022,948150,949224,950279,951390,952468,953497,954520,955451,956349,957236,958131,958999,959844,960673,961481,962253,962971,963757,964515,965212,965868,966510,967147,967807,
0,31,1007,5653,15527,31477,52143,76113,102082,129246,156926,184418,211534,237958,263488,287976,311159,333717,355141,375485,395035,413662,431464,448189,464197,479678,494130,507928,521090,533610,545669,557269,568382,578836,588826,598623,607842,616549,624826,632982,640791,648143,655138,661926,668403,674699,680728,686541,692195,697437,702572,707542,712217,716746,721069,725448,729469,733431,737246,740930,744409,747957,751290,754479,757573,760607,763398,766227,768848,771567,774111,776682,779102,781406,783655,785870,787970,790048,791947,793912,795771,797547,799377,801010,802719,804382,805920,807448,808865,810329,811748,813182,814465,815771,817039,818262,819508,820649,821816,822911,823963,825009,826004,826966,827936,828868,829791,830667,831541,832392,833193,834075,834847,835607,836392,837066,837745,838449,839129,839784,
0,5,229,1841,6294,14334,26201,41133,58354,76992,96846,117418,138054,158694,179009,198700,218283,237100,255237,272788,289967,306363,321804,336657,351105,364822,377981,390599,402551,414054,425144,435834,446059,455744,465242,474278,482907,491191,499159,506730,513908,520956,527511,533966,540333,546318,552188,557708,563045,568157,573213,577981,582644,587095,591417,595617,599688,603654,607461,611015,614534,617886,621232,624421,627520,630407,633246,635945,638790,641439,643972,646442,648882,651153,653441,655656,657894,659933,661877,663811,665589,667365,669137,670860,672532,674115,675738,677267,678787,680311,681760,683118,684493,685805,687110,688367,689544,690772,691929,693070,694095,695147,696189,697189,698140,699070,700017,700904,701772,702620,703472,704299,705085,705855,706583,707288,708018,708742,709438,710081,
0,0,48,527,2126,5688,11600,19862,29920,41636,54813,68947,83415,98449,113384,128639,143645,158432,173086,187243,201121,214408,227433,240219,252328,264039,275427,286656,297257,307331,317169,326733,335837,344662,353106,361280,369034,376609,383813,390816,397598,404032,410407,416544,422318,427842,433256,438338,443336,448370,453133,457744,462248,466585,470653,474617,478510,482238,485893,489419,492749,496042,499328,502303,505239,508060,510811,513518,516197,518729,521249,523575,525883,528162,530334,532433,534475,536487,538457,540379,542176,543994,545797,547520,549136,550731,552390,553818,555286,556680,558026,559380,560757,562005,563300,564479,565753,566936,567959,569046,570110,571216,572203,573314,574297,575249,576201,577093,577920,578764,579578,580372,581147,581902,582690,583423,584140,584878,585568,586210,
0,0,3,93,582,1854,4298,8075,13251,19864,27434,36103,45274,55068,65328,75809,86657,97673,108583,119347,129810,140168,150364,160335,170190,179926,189422,198538,207389,215809,224010,231981,239762,247368,254842,261906,268767,275462,281836,287927,293790,299535,305114,310568,315862,320941,325841,330612,335098,339491,343779,347945,351905,355758,359513,363131,366622,370120,373337,376592,379767,382873,385799,388706,391458,394170,396785,399386,401760,404126,406447,408696,410873,413022,415152,417188,419120,421029,422962,424744,426504,428199,429832,431366,432905,434500,435969,437435,438912,440354,441736,443034,444271,445423,446604,447788,448864,449922,450982,452047,453099,454105,455062,456039,456968,457839,458730,459610,460474,461347,462129,462929,463660,464377,465082,465753,466497,467158,467834,468505,
0,0,1,27,205,835,2093,4303,7550,11681,16853,22974,29625,36928,44667,52829,61247,69733,78514,87186,95928,104518,113103,121469,129783,138080,146157,153930,161482,168925,176200,183205,190099,196865,203429,209773,215827,221715,227380,233036,238436,243759,248840,253828,258669,263320,267754,272230,276483,280672,284585,288431,292222,295769,299409,302892,306065,309293,312388,315424,318307,321176,323868,326547,329202,331763,334263,336723,339022,341442,343620,345693,347786,349802,351720,353673,355535,357429,359289,360983,362627,364291,365925,367454,368970,370457,371872,373245,374641,375947,377236,378448,379687,380851,381987,383140,384201,385289,386365,387453,388493,389465,390396,391328,392233,393084,393945,394817,395605,396376,397170,397953,398719,399424,400129,400832,401550,402218,402884,403495,
0,0,1,13,78,318,934,2026,3849,6424,9705,13611,18214,23268,28958,35020,41329,47807,54485,61282,68149,75023,82033,88959,95887,102771,109381,116010,122545,128941,135149,141178,146958,152680,158376,163931,169287,174545,179688,184695,189516,194308,198964,203388,207628,211953,216074,219968,223793,227582,231199,234770,238156,241481,244754,247835,250877,253784,256641,259448,262210,264888,267422,269906,272341,274727,277058,279326,281593,283716,285836,287894,289836,291707,293509,295347,297118,298830,300513,302098,303725,305304,306759,308229,309659,311073,312459,313717,314996,316302,317559,318839,319997,321160,322266,323366,324425,325468,326459,327481,328481,329431,330384,331260,332152,332994,333834,334623,335396,336195,336932,337669,338406,339115,339808,340495,341162,341816,342446,343053,
0,0,0,4,23,131,394,949,1830,3231,5133,7559,10389,13693,17535,21598,25999,30772,35637,40700,45959,51252,56566,61976,67440,72762,78109,83451,88747,93953,99187,104203,109166,114156,118938,123722,128349,132912,137259,141471,145668,149656,153643,157575,161392,165240,168820,172346,175771,179118,182314,185443,188540,191553,194369,197179,199828,202462,205125,207682,210101,212533,214864,217159,219387,221535,223591,225659,227614,229586,231517,233340,235183,236946,238627,240285,241885,243500,245003,246537,248018,249519,250896,252265,253554,254811,256072,257346,258597,259812,260967,262098,263194,264222,265318,266379,267393,268346,269301,270214,271085,271974,272826,273638,274471,275266,276028,276758,277519,278285,279010,279645,280341,281035,281704,282321,282915,283522,284172,284730,
0,0,0,1,6,24,125,357,781,1469,2410,3764,5475,7454,9764,12304,15224,18428,21932,25534,29190,33010,36937,40955,45058,49143,53366,57486,61529,65670,69690,73649,77575,81596,85501,89259,93074,96798,100573,104180,107651,111050,114468,117680,120864,124003,127017,130055,132957,135878,138607,141338,143956,146553,149208,151621,154029,156409,158663,160952,163090,165260,167336,169362,171279,173292,175218,177037,178865,180607,182311,184018,185656,187261,188824,190352,191846,193254,194693,196081,197477,198783,200040,201338,202529,203722,204879,205989,207098,208213,209328,210354,211375,212377,213374,214296,215179,216114,216997,217869,218748,219568,220367,221110,221820,222570,223298,224040,224670,225341,225991,226653,227323,227941,228509,229089,229692,230291,230826,231337,
0,0,0,0,1,5,24,98,245,521,1012,1653,2524,3578,4871,6394,8128,10079,12193,14457,16861,19331,22120,24914,27803,30803,33746,36747,39798,42860,45930,49051,52018,55111,58103,61029,63978,66836,69716,72648,75471,78260,80986,83660,86261,88839,91353,93796,96317,98574,100916,103209,105463,107690,109805,111835,113913,115924,117813,119755,121644,123418,125135,126897,128568,130206,131877,133489,135064,136606,138151,139541,140930,142326,143682,144978,146267,147564,148807,150039,151221,152427,153547,154698,155803,156871,157888,158880,159900,160909,161877,162768,163650,164549,165427,166279,167156,167975,168770,169562,170303,171103,171810,172514,173194,173839,174477,175095,175719,176328,176916,177501,178095,178656,179203,179781,180319,180863,181375,181858,
0,0,0,0,0,2,10,26,82,197,390,649,1100,1681,2380,3194,4228,5389,6746,8226,9853,11568,13377,15303,17289,19273,21326,23429,25630,27817,30065,32299,34590,36876,39213,41510,43831,46145,48330,50687,52841,54989,57206,59310,61488,63557,65596,67630,69611,71573,73540,75437,77248,79022,80807,82548,84354,86026,87659,89301,90943,92505,94011,95439,96914,98421,99832,101217,102565,103893,105191,106486,107707,109000,110189,111255,112390,113518,114589,115622,116618,117710,118732,119664,120647,121546,122458,123390,124247,125120,125957,126755,127554,128332,129136,129926,130712,131432,132154,132860,133568,134276,134935,135539,136129,136755,137355,137964,138606,139203,139783,140325,140842,141352,141822,142289,142786,143227,143718,144195,
0,0,0,0,0,0,3,9,22,49,120,235,420,657,993,1398,1886,2522,3235,4015,4953,5883,6977,8164,9391,10620,11953,13359,14831,16383,17899,19391,20988,22573,24204,25855,27500,29204,30818,32479,34136,35760,37375,39041,40614,42225,43801,45340,46881,48411,49832,51357,52787,54195,55581,56951,58285,59647,60947,62271,63561,64822,66055,67275,68441,69603,70697,71849,72982,74032,75178,76198,77197,78248,79250,80240,81147,82079,82946,83812,84646,85503,86386,87239,88048,88822,89644,90394,91165,91909,92652,93342,94040,94727,95407,96096,96685,97331,97985,98572,99173,99760,100297,100869,101434,101969,102516,103055,103567,104049,104540,105031,105496,105932,106409,106868,107262,107699,108092,108513,
0,0,0,0,0,0,1,2,5,12,29,56,116,189,284,453,641,883,1225,1608,2019,2495,3004,3572,4226,4936,5695,6435,7253,8121,9012,9944,10918,11937,12924,13988,15038,16076,17089,18178,19236,20357,21468,22568,23609,24720,25815,26886,27937,29033,30101,31177,32193,33218,34220,35233,36258,37282,38250,39200,40192,41171,42094,43025,43922,44877,45776,46660,47534,48397,49247,50068,50910,51696,52474,53222,53922,54631,55365,56083,56777,57476,58139,58805,59474,60124,60783,61365,61996,62579,63177,63777,64323,64894,65428,65950,66463,66983,67482,67979,68447,68910,69349,69789,70230,70655,71065,71506,71938,72339,72725,73120,73533,73939,74311,74661,75044,75424,75786,76132,
0,0,0,0,0,0,0,0,0,1,1,4,13,29,51,91,147,199,290,412,546,711,904,1132,1376,1637,1950,2262,2599,2987,3398,3835,4244,4779,5278,5780,6306,6828,7370,7941,8507,9132,9712,10361,10950,11640,12286,12960,13598,14247,14886,15529,16148,16791,17365,17976,18567,19171,19845,20456,21010,21633,22256,22832,23447,24018,24598,25198,25747,26283,26861,27425,27978,28499,29033,29547,30039,30538,31033,31510,32031,32549,33037,33484,33926,34373,34817,35238,35670,36075,36533,36946,37316,37702,38144,38541,38938,39326,39689,40060,40433,40749,41106,41416,41733,42078,42379,42656,42962,43262,43569,43844,44125,44416,44692,44994,45305,45577,45839,46105,
41595,238491,443507,611298,745115,853208,941835,1016344,1079188,1132666,1179194,1219673,1254871,1286396,1314592,1339985,1362748,1383577,1402439,1419490,1435643,1450278,1463784,1476317,1487820,1498805,1508756,1518116,1526721,1534967,1542515,1549756,1556644,1563160,1569166,1574963,1580388,1585539,1590278,1594862,1599198,1603427,1607348,1611070,1614657,1618138,1621331,1624426,1627371,1630245,1632988,1635627,1638196,1640532,1642765,1644989,1647192,1649245,1651232,1653101,1655010,1656844,1658516,1660101,1661681,1663206,1664643,1666058,1667424,1668769,1670066,1671309,1672507,1673626,1674706,1675761,1676851,1677874,1678864,1679871,1680783,1681665,1682526,1683326,1684106,1684930,1685697,1686466,1687158,1687828,1688478,1689179,1689790,1690374,1690976,1691562,1692147,1692679,1693203,1693781,1694276,1694781,1695258,1695730,1696225,1696646,1697098,1697538,1697989,1698373,1698742,1699131,1699497,1699885,1700248,1700593,1700953,1701284,1701640,1701941,
6996,91372,225173,356151,472247,572342,658485,732290,796633,852875,902374,946403,985352,1019740,1051075,1079164,1104828,1128288,1149704,1169548,1187542,1204186,1219761,1234257,1247756,1260245,1271874,1282804,1292953,1302583,1311634,1320178,1328040,1335684,1342934,1349698,1356212,1362195,1367909,1373400,1378616,1383445,1388005,1392571,1396833,1400839,1404704,1408546,1412095,1415514,1418851,1422038,1425039,1427897,1430712,1433316,1435887,1438420,1440765,1443041,1445226,1447370,1449402,1451384,1453257,1455091,1456952,1458627,1460239,1461864,1463454,1464977,1466434,1467863,1469182,1470470,1471732,1472934,1474162,1475318,1476499,1477599,1478597,1479589,1480590,1481573,1482477,1483359,1484220,1485059,1485853,1486674,1487440,1488198,1488924,1489623,1490369,1491071,1491704,1492385,1493015,1493605,1494238,1494808,1495397,1495922,1496431,1496954,1497460,1497973,1498472,1498911,1499376,1499806,1500256,1500688,1501116,1501506,1501939,1502330,
1700,43376,132703,234501,332343,421338,501051,570969,633051,688460,737557,781109,820565,856137,888232,917063,943655,968190,990452,1011349,1030491,1048100,1064362,1079649,1093916,1107477,1119899,1131450,1142438,1152832,1162450,1171626,1180168,1188399,1196011,1203257,1210368,1216999,1223219,1229127,1234899,1240136,1245327,1250177,1254877,1259287,1263493,1267662,1271536,1275179,1278843,1282298,1285584,1288852,1291909,1294872,1297686,1300362,1302999,1305479,1307898,1310195,1312434,1314583,1316687,1318698,1320673,1322508,1324365,1326054,1327822,1329470,1331117,1332614,1334139,1335542,1336946,1338325,1339630,1340864,1342113,1343336,1344461,1345552,1346652,1347669,1348651,1349650,1350662,1351623,1352519,1353429,1354327,1355160,1355934,1356737,1357463,1358232,1358931,1359604,1360320,1360938,1361607,1362268,1362898,1363518,1364120,1364660,1365232,1365783,1366295,1366817,1367323,1367830,1368290,1368805,1369259,1369693,1370111,1370550,
249,15014,62989,130593,203354,274965,342265,403893,459912,511040,557461,599222,637290,671994,704006,732800,759203,783976,806693,827543,847176,865429,882199,898196,912841,926898,939894,952060,963700,974511,984600,994301,1003430,1012062,1020186,1027993,1035388,1042505,1049132,1055686,1061854,1067615,1073100,1078341,1083366,1088065,1092656,1097087,1101213,1105172,1108982,1112733,1116453,1119891,1123220,1126464,1129571,1132581,1135423,1138225,1140911,1143490,1145997,1148381,1150724,1152959,1154989,1157029,1159057,1160962,1162814,1164704,1166441,1168142,1169710,1171287,1172821,1174275,1175708,1177126,1178423,1179719,1181019,1182214,1183435,1184590,1185698,1186788,1187830,1188952,1189986,1190931,1191859,1192870,1193725,1194642,1195513,1196330,1197165,1197946,1198706,1199413,1200132,1200828,1201535,1202164,1202819,1203452,1204077,1204694,1205281,1205855,1206401,1206933,1207451,1208002,1208473,1208974,1209475,1209943,
11,3302,21736,56326,101437,150692,199995,248042,293646,336277,376371,413360,447860,479891,509613,537041,562248,585777,607913,628374,647571,665367,682377,698044,712847,726862,740081,752408,764230,775134,785727,795674,805213,814224,822714,830799,838470,845903,852911,859582,866012,872036,877844,883414,888710,893809,898697,903320,907933,912116,916326,920271,924155,927766,931383,934815,938123,941267,944289,947289,950066,952721,955320,957889,960361,962718,964999,967222,969310,971349,973380,975305,977212,979024,980809,982492,984166,985757,987287,988788,990284,991639,993070,994452,995789,997005,998235,999471,1000654,1001815,1002912,1004012,1005066,1006052,1007044,1007999,1008941,1009849,1010717,1011591,1012440,1013294,1014070,1014806,1015534,1016285,1016985,1017675,1018376,1019066,1019706,1020282,1020891,1021460,1022025,1022569,1023121,1023665,1024187,1024679,
1,1224,10627,32214,63441,100510,139476,178924,217827,255031,290432,323860,354836,384128,411914,437666,461546,483852,505119,524815,543296,560823,577333,592573,607055,620780,633557,645939,657608,668522,679044,688904,698379,707368,715839,723902,731502,738936,745836,752497,758955,765068,770872,776550,781957,787107,791940,796721,801133,805483,809735,813800,817838,821493,825009,828513,831878,835108,838290,841256,844197,847039,849665,852278,854849,857319,859679,861997,864192,866353,868411,870358,872288,874187,876027,877809,879535,881238,882883,884399,885870,887322,888748,890105,891478,892724,893980,895277,896425,897572,898738,899870,900980,902061,903080,904096,905014,905981,906890,907776,908624,909543,910378,911158,911914,912687,913465,914180,914873,915547,916212,916887,917538,918138,918763,919322,919894,920426,920967,921515,
0,352,4446,16267,35761,61353,90402,120823,151927,182541,212473,241183,268498,294382,319006,342107,363955,384932,404476,422811,440309,456672,472183,486970,500783,514149,526420,538293,549634,560536,570709,580271,589381,598032,606416,614363,622124,629470,636318,642973,649527,655572,661490,666963,672372,677661,682576,687404,691992,696398,700673,704841,708667,712404,715946,719477,722889,726159,729335,732397,735283,738098,740912,743514,746054,748534,751052,753363,755645,757840,759898,761940,763930,765879,767791,769609,771248,772982,774636,776251,777755,779191,780652,782113,783529,784827,786133,787407,788644,789916,791079,792229,793297,794333,795353,796427,797344,798298,799197,800092,800974,801825,802686,803554,804374,805160,805917,806632,807354,808056,808712,809391,810066,810755,811428,812013,812602,813150,813740,814300,
0,74,1454,6931,17592,33119,52480,74332,97381,121011,144596,167679,190227,211954,232978,253072,272336,290702,308183,324917,340897,355945,370209,383802,396936,409174,420646,431873,442502,452613,462262,471473,480379,488775,496814,504558,512008,519055,525741,532086,538370,544329,550017,555395,560613,565754,570571,575215,579744,584143,588303,592365,596118,599866,603539,606929,610328,613605,616681,619771,622803,625701,628541,631181,633746,636215,638627,640996,643290,645515,647640,649663,651630,653584,655473,657289,659080,660744,662341,663939,665444,666949,668441,669904,671313,672733,674037,675357,676623,677836,678993,680165,681257,682333,683386,684382,685467,686420,687359,688330,689230,690058,690973,691822,692674,693417,694241,694980,695723,696422,697149,697800,698510,699184,699769,700390,700982,701599,702220,702794,
0,17,398,2365,7316,15639,26903,40846,56306,72896,90602,108263,125624,142827,159558,176146,191925,207312,221956,236053,249812,262832,275282,287033,298519,309797,320161,330309,340042,349201,358173,366862,374914,382789,390354,397568,404478,411146,417358,423521,429422,435129,440651,445796,450925,455726,460274,464722,468908,473076,477165,481073,484858,488471,491833,495156,498374,501615,504750,507754,510612,513401,516054,518593,521230,523739,526099,528370,530487,532665,534718,536754,538730,540602,542492,544352,546141,547815,549466,551098,552676,554175,555686,557149,558586,559938,561298,562646,563873,565100,566228,567391,568491,569588,570647,571699,572785,573725,574664,575619,576529,577409,578267,579111,579933,580777,581576,582373,583128,583805,584556,585263,585944,586625,587269,587920,588579,589166,589727,590298,
0,5,124,1076,3902,9015,16529,26172,37548,50108,63761,77807,92305,106769,120995,134951,148668,162179,175231,187877,200011,211683,223230,234046,244675,254774,264452,273942,282987,291460,299814,307634,315235,322476,329443,336302,342803,349227,355279,361167,366760,372042,377258,382245,387042,391682,396167,400582,404799,408888,412767,416494,420079,423597,426991,430151,433365,436456,439468,442346,445062,447792,450381,453007,455440,457833,460151,462360,464421,466560,468613,470578,472479,474328,476181,477906,479601,481353,483032,484670,486161,487641,489074,490419,491778,493124,494428,495739,496943,498138,499366,500437,501531,502603,503669,504662,505601,506552,507527,508415,509319,510209,511075,511875,512701,513505,514271,514998,515744,516476,517177,517867,518564,519246,519812,520426,521014,521614,522180,522759,
0,1,43,427,1872,4742,9252,15717,23613,32803,43032,53823,64848,76485,88051,99656,110894,122211,133263,143996,154470,164786,174829,184325,193684,202628,211263,219629,227727,235478,242980,250331,257408,264177,270604,276978,283105,288950,294555,299912,305137,310138,314859,319526,324111,328562,332778,336802,340787,344747,348452,352094,355538,358808,362096,365227,368296,371242,374025,376781,379424,382025,384552,387065,389474,391786,394033,396172,398232,400230,402254,404143,406110,407939,409715,411449,413120,414776,416318,417841,419430,420876,422318,423650,425002,426283,427548,428747,429992,431142,432338,433478,434555,435613,436673,437661,438629,439574,440523,441466,442313,443216,444054,444862,445646,446457,447253,447982,448686,449396,450077,450727,451361,451985,452603,453216,453816,454394,454967,455523,
0,0,15,159,737,2147,4725,8606,13567,19628,26709,34451,42721,51295,60061,69021,78219,87289,96262,105153,113965,122644,131049,139194,147142,154937,162631,170085,177195,184090,190822,197333,203574,209699,215522,221107,226661,231836,237018,241992,246630,251328,255850,260226,264348,268377,272377,276220,279901,283528,286984,290324,293530,296602,299561,302577,305423,308225,310812,313404,315899,318375,320734,323143,325400,327644,329869,331925,333916,335810,337702,339589,341387,343075,344752,346388,348016,349589,351121,352581,354000,355437,356851,358172,359491,360804,362038,363222,364345,365503,366630,367789,368849,369859,370896,371888,372819,373776,374691,375553,376369,377187,377997,378823,379628,380390,381123,381792,382484,383154,383847,384486,385088,385745,386364,386988,387621,388174,388749,389330,
0,0,2,51,254,864,2082,4141,7002,10486,14881,20144,25804,31819,38219,44803,51620,58549,65643,72723,79760,86593,93314,100054,106721,113346,119652,125974,131969,138017,143601,149048,154389,159631,164760,169812,174599,179219,183777,188175,192422,196530,200621,204508,208256,211925,215585,218998,222292,225615,228691,231769,234676,237616,240536,243309,245937,248519,250944,253418,255715,258008,260238,262425,264526,266595,268605,270518,272414,274199,275922,277683,279344,280951,282532,284080,285554,287010,288555,289939,291288,292623,293926,295173,296383,297574,298716,299846,300981,302091,303121,304144,305181,306150,307118,308026,308960,309780,310659,311530,312384,313228,314039,314780,315521,316228,316917,317619,318278,318965,319631,320248,320851,321485,322069,322646,323216,323741,324302,324811,
0,0,0,4,65,258,780,1689,3063,4974,7493,10535,14077,17976,22059,26603,31218,36199,41162,46216,51386,56605,61892,66990,72059,77183,82270,87239,92178,96905,101638,106251,110676,115018,119351,123667,127590,131636,135501,139263,142952,146507,150057,153432,156691,159854,162994,166076,168942,171897,174591,177196,179861,182433,184893,187347,189658,191934,194174,196271,198383,200467,202505,204448,206371,208242,210042,211789,213560,215147,216748,218263,219739,221229,222737,224180,225574,226875,228217,229471,230757,231993,233219,234388,235503,236559,237656,238701,239692,240711,241696,242638,243569,244518,245402,246280,247112,247983,248796,249584,250393,251135,251830,252544,253239,253943,254659,255326,255923,256542,257165,257783,258419,258980,259535,260066,260614,261100,261586,262095,
0,0,0,0,15,88,283,679,1285,2290,3684,5434,7446,9765,12395,15418,18620,22036,25588,29242,32944,36779,40620,44564,48517,52384,56212,59986,63726,67561,71359,75017,78565,82089,85596,89073,92625,95894,99170,102407,105487,108420,111314,114173,117024,119774,122516,125124,127661,130132,132591,135022,137391,139674,141892,143959,146054,148047,150019,151895,153799,155648,157444,159151,160912,162521,164105,165722,167187,168676,170089,171530,172911,174328,175737,177081,178293,179543,180772,181927,183040,184133,185209,186278,187343,188355,189392,190360,191333,192272,193185,194070,194970,195828,196686,197454,198228,199017,199796,200530,201258,201983,202702,203374,204022,204669,205279,205907,206537,207090,207692,208243,208779,209303,209801,210323,210822,211279,211732,212214,
0,0,0,0,3,18,62,191,448,853,1489,2286,3279,4472,6011,7643,9553,11612,13865,16148,18548,21139,23809,26541,29308,32103,34872,37734,40604,43337,46145,48880,51719,54399,57095,59735,62383,65002,67576,70025,72446,74825,77268,79536,81753,84007,86245,88329,90504,92562,94581,96554,98411,100268,102075,103865,105593,107320,109016,110735,112380,113926,115404,116936,118430,119842,121246,122642,124024,125342,126689,127890,129066,130297,131409,132551,133693,134812,135880,136911,137972,138950,139863,140795,141708,142533,143431,144359,145213,146007,146849,147613,148366,149133,149851,150619,151279,151952,152625,153263,153902,154549,155171,155801,156396,156987,157533,158093,158603,159152,159702,160172,160668,161155,161643,162122,162568,163007,163474,163892,
0,0,0,0,0,2,12,40,96,188,370,648,1039,1560,2206,3030,3959,4964,6112,7393,8715,10144,11692,13219,14797,16459,18175,19933,21742,23563,25386,27287,29178,31069,32972,34816,36628,38460,40198,41919,43784,45514,47232,48978,50638,52303,53902,55603,57174,58729,60279,61772,63246,64667,66072,67522,68847,70233,71556,72855,74121,75293,76476,77666,78823,79997,81150,82244,83303,84354,85435,86515,87470,88468,89431,90331,91200,92069,92957,93815,94631,95415,96245,97033,97819,98566,99322,100063,100812,101483,102169,102830,103478,104102,104752,105363,105971,106577,107191,107715,108285,108815,109385,109901,110417,110914,111410,111878,112362,112832,113277,113713,114120,114527,114959,115350,115756,116164,116507,116873,
0,0,0,0,0,1,2,2,5,28,54,111,198,313,468,679,941,1317,1682,2129,2662,3264,3883,4569,5295,6085,6924,7807,8741,9691,10644,11616,12652,13713,14736,15764,16850,17874,18933,20036,21139,22204,23282,24332,25407,26440,27518,28535,29533,30555,31530,32574,33532,34560,35487,36405,37352,38265,39172,40123,40977,41890,42765,43614,44465,45254,46042,46810,47617,48396,49161,49856,50590,51308,51978,52657,53336,53990,54619,55259,55899,56531,57108,57704,58282,58822,59424,59998,60548,61114,61626,62112,62640,63158,63662,64123,64597,65038,65499,65963,66420,66831,67300,67704,68111,68481,68854,69234,69620,69952,70335,70733,71080,71430,71771,72069,72385,72702,73012,73292,
64524,288800,494043,653340,777428,876050,956239,1022267,1078694,1126338,1167508,1203398,1234679,1262604,1287540,1309770,1329902,1347932,1364534,1379919,1393991,1406938,1418898,1430082,1440400,1450087,1459080,1467458,1475174,1482268,1489100,1495603,1501662,1507424,1512874,1518038,1522966,1527559,1531888,1536092,1540092,1543854,1547423,1550855,1554128,1557172,1560130,1562937,1565591,1568156,1570783,1573155,1575429,1577634,1579772,1581790,1583792,1585712,1587632,1589345,1590944,1592574,1594178,1595705,1597151,1598554,1599898,1601236,1602512,1603749,1604935,1606056,1607158,1608234,1609218,1610242,1611255,1612191,1613128,1614021,1614900,1615690,1616465,1617252,1618024,1618725,1619420,1620116,1620756,1621424,1622025,1622680,1623270,1623856,1624423,1624962,1625550,1626078,1626592,1627108,1627614,1628102,1628571,1629069,1629535,1630007,1630400,1630814,1631184,1631605,1631978,1632347,1632704,1633019,1633347,1633674,1633993,1634301,1634620,1634893,
16541,134897,285759,421069,534671,629564,709363,777313,835668,885929,929962,968649,1003218,1034083,1061286,1085701,1108171,1128793,1147453,1164605,1180214,1194831,1208368,1221046,1232756,1243793,1253876,1263538,1272532,1280740,1288585,1296054,1302961,1309591,1315891,1321797,1327403,1332748,1337779,1342420,1347029,1351414,1355484,1359443,1363225,1366914,1370509,1373851,1377038,1380040,1382928,1385707,1388392,1390986,1393503,1395959,1398254,1400480,1402580,1404640,1406543,1408506,1410286,1412017,1413655,1415326,1416917,1418493,1419949,1421333,1422810,1424203,1425505,1426731,1427974,1429167,1430291,1431348,1432401,1433415,1434412,1435386,1436366,1437260,1438202,1439118,1439952,1440780,1441598,1442367,1443129,1443851,1444579,1445241,1445938,1446580,1447220,1447860,1448456,1449017,1449593,1450196,1450742,1451272,1451787,1452273,1452752,1453216,1453657,1454103,1454565,1455004,1455397,1455758,1456171,1456572,1456956,1457317,1457695,1458051,
5798,75930,189545,302737,403559,491331,567487,633770,691284,741687,785873,825012,860093,891485,920042,945730,969120,990726,1010352,1028214,1044815,1060154,1074272,1087672,1100214,1111821,1122667,1132830,1142486,1151340,1159906,1167661,1175198,1182237,1188849,1195291,1201412,1207288,1212721,1217800,1222752,1227485,1231916,1236166,1240422,1244331,1248021,1251563,1255068,1258322,1261456,1264571,1267545,1270344,1273012,1275607,1278202,1280636,1282905,1285112,1287284,1289317,1291295,1293172,1295020,1296810,1298548,1300174,1301806,1303358,1304855,1306287,1307632,1309001,1310384,1311629,1312867,1314120,1315325,1316479,1317595,1318693,1319756,1320765,1321719,1322607,1323517,1324481,1325381,1326220,1327050,1327825,1328633,1329403,1330157,1330849,1331579,1332279,1332977,1333614,1334212,1334844,1335494,1336038,1336591,1337178,1337729,1338214,1338725,1339224,1339702,1340192,1340637,1341052,1341496,1341903,1342293,1342688,1343056,1343433,
1316,34220,107257,192747,275866,352412,420937,482012,536068,584282,627497,666551,701456,733184,761786,787752,811472,833398,853500,872140,889522,905406,920517,934390,947414,959477,970978,981635,991740,1001305,1010253,1018665,1026573,1034097,1041195,1048163,1054646,1060903,1066667,1072309,1077503,1082614,1087314,1091981,1096402,1100626,1104542,1108334,1112057,1115637,1119089,1122385,1125470,1128505,1131490,1134294,1137037,1139629,1142142,1144500,1146827,1149072,1151235,1153347,1155334,1157302,1159105,1160898,1162654,1164304,1165957,1167568,1169069,1170576,1172025,1173502,1174807,1176168,1177408,1178629,1179793,1180959,1182128,1183238,1184291,1185300,1186276,1187267,1188205,1189127,1190018,1190831,1191658,1192489,1193310,1194098,1194824,1195538,1196273,1196937,1197663,1198358,1199053,1199720,1200300,1200838,1201452,1202028,1202582,1203152,1203677,1204205,1204721,1205215,1205687,1206132,1206599,1207047,1207486,1207928,
188,11019,48115,101881,161562,220947,277381,329628,377603,420867,460440,496281,529226,559663,587405,612784,636301,658013,678222,697146,714672,731078,746040,760305,773555,785895,797609,808502,818857,828525,837826,846700,855130,863138,870581,877647,884430,890860,897109,902953,908448,913836,919028,923939,928617,933180,937510,941652,945644,949425,953116,956666,960003,963141,966221,969187,972083,974847,977566,980181,982571,985006,987324,989587,991800,993868,995815,997832,999637,1001438,1003194,1004901,1006501,1008168,1009714,1011287,1012831,1014230,1015663,1016958,1018285,1019463,1020700,1021896,1022992,1024118,1025176,1026241,1027275,1028271,1029254,1030148,1031134,1032019,1032896,1033755,1034548,1035354,1036092,1036852,1037605,1038264,1038941,1039643,1040310,1040955,1041583,1042203,1042827,1043421,1043991,1044540,1045094,1045653,1046164,1046661,1047130,1047587,1048072,1048542,
34,5290,28210,66806,113505,163076,211453,257339,300563,340430,376994,410716,441912,470810,497410,522388,545379,566507,586313,604593,621953,638080,653143,667187,680300,692815,704654,715657,726168,736041,745425,754383,762678,770823,778326,785585,792359,798975,805324,811277,817076,822516,827779,832746,837552,842112,846497,850698,854743,858559,862292,865916,869333,872674,875913,878977,881884,884747,887534,890132,892719,895244,897595,899888,902155,904299,906304,908260,910220,912171,913963,915713,917349,919032,920627,922206,923773,925242,926640,927985,929277,930646,931930,933148,934324,935471,936596,937756,938797,939834,940827,941782,942749,943673,944534,945431,946269,947094,947859,948597,949394,950152,950884,951550,952277,952964,953596,954218,954856,955492,956089,956700,957261,957783,958327,958828,959334,959821,960312,960791,
8,2143,14661,39891,73717,111774,151115,189572,226471,261792,294702,325615,354307,380914,405900,429297,450962,471214,490083,507530,524344,539962,554647,568483,581429,593806,605426,616313,626622,636256,645539,654288,662564,670629,678076,685343,692371,698857,705087,711140,716965,722565,727866,732837,737593,742305,746797,751107,755251,759225,763074,766816,770283,773654,776802,779869,782842,785742,788494,791191,793848,796388,798738,801048,803440,805677,807865,809927,811888,813847,815728,817423,819131,820910,822513,824116,825710,827290,828831,830266,831664,833117,834392,835668,836896,838099,839200,840329,841437,842527,843608,844622,845602,846583,847563,848489,849379,850265,851063,851871,852668,853434,854184,854888,855617,856326,857014,857646,858283,858860,859471,860081,860662,861259,861832,862373,862920,863444,863918,864445,
0,593,6438,20785,42937,70041,99700,130167,160230,189777,218105,245094,270319,294362,317165,338235,358574,377443,395095,411777,427477,442119,456029,469221,481843,493568,504676,515226,525292,534882,543920,552612,560842,568641,576189,583310,590185,596887,603013,608921,614602,620139,625428,630394,635221,639882,644284,648552,652689,656693,660415,664122,667632,671046,674299,677428,680477,683447,686288,689093,691732,694278,696777,699090,701412,703701,705885,707979,710123,712023,713918,715731,717488,719171,720902,722551,724074,725656,727088,728602,730015,731349,732707,733963,735247,736491,737688,738874,740006,741124,742146,743239,744236,745229,746216,747168,748042,748875,749763,750600,751415,752234,753000,753759,754502,755227,755949,756616,757289,757930,758587,759191,759807,760388,760960,761518,762073,762638,763186,763670,
0,167,2251,9221,21722,38747,59075,80975,103659,126703,149624,171571,192827,213034,232658,251165,268616,285336,301079,316264,330712,344405,357280,369519,381068,392094,402488,412642,422136,431361,440296,448482,456357,463893,471256,478038,484724,491065,497100,502802,508451,513795,518944,523859,528575,533077,537427,541658,545697,549547,553299,556918,560406,563856,567180,570294,573274,576293,579055,581828,584526,587141,589645,591968,594280,596448,598580,600712,602731,604778,606790,608685,610447,612180,613845,615513,617085,618617,620120,621602,622987,624313,625674,626964,628193,629460,630680,631834,632982,634098,635155,636170,637141,638193,639203,640154,641093,641947,642857,643703,644495,645287,646083,646845,647620,648326,649042,649716,650377,651034,651690,652305,652917,653491,654062,654579,655119,655636,656197,656709,
0,55,1044,5058,13228,25254,40195,57194,75338,94195,113623,132380,150940,168817,186118,202788,218863,234236,248718,262572,275903,288595,300620,312035,322972,333421,343367,352849,361965,370598,378893,386711,394212,401581,408672,415274,421687,427880,433706,439377,444661,449987,454985,459820,464335,468718,472933,477148,481164,484950,488562,492136,495590,498911,502123,505103,508049,510876,513700,516436,519056,521574,524022,526420,528735,530949,533116,535135,537266,539210,541120,542994,544831,546591,548307,549958,551545,553073,554597,556007,557432,558812,560104,561379,562634,563859,565110,566360,567522,568560,569594,570653,571704,572702,573638,574577,575484,576373,577257,578110,578879,579700,580468,581225,582017,582737,583464,584145,584845,585501,586161,586769,587400,587987,588576,589165,589733,590258,590796,591336,
0,17,468,2464,7343,15136,25728,38275,52296,67146,82663,98256,113521,128941,143425,157963,172096,185594,198506,211134,223030,234428,245379,255826,265965,275701,284998,293865,302559,310674,318334,325701,332768,339464,346009,352300,358394,364209,369833,375213,380516,385612,390479,395060,399542,403901,407944,411822,415662,419429,423052,426404,429829,433058,436183,439155,441867,444546,447292,449872,452408,454965,457391,459741,461902,464084,466104,468151,470173,472112,473946,475773,477528,479218,480824,482443,484011,485576,487085,488547,489915,491253,492573,493909,495162,496352,497530,498669,499785,500874,501942,502948,503982,504972,505974,506920,507844,508712,509542,510389,511155,511918,512701,513483,514215,514923,515624,516332,517017,517757,518411,519004,519607,520171,520742,521353,521924,522449,523015,523533,
0,1,158,1081,3599,8262,14837,23331,33220,44282,56002,68259,80441,92796,104842,116741,128466,140019,151245,162146,172674,182894,192585,202028,211116,219957,228337,236362,244276,251793,258915,265819,272569,278889,284979,290960,296683,302193,307347,312395,317253,321885,326365,330719,334840,338803,342740,346547,350233,353773,357183,360586,363889,366974,369938,372770,375583,378327,380964,383522,385931,388270,390547,392773,395012,397157,399194,401156,403066,404859,406611,408411,410214,411869,413406,415022,416496,418017,419501,420933,422255,423642,424864,426181,427405,428696,429815,430954,432085,433187,434206,435264,436231,437207,438172,439055,439917,440840,441694,442528,443303,444062,444842,445627,446332,447062,447765,448390,449039,449689,450354,450975,451566,452178,452790,453368,453902,454385,454907,455408,
0,0,35,353,1472,3845,7647,12797,19438,26790,34972,43753,52895,62458,71938,81448,91017,100348,109625,118737,127679,136243,144474,152590,160409,168053,175345,182385,189248,195936,202377,208581,214547,220356,226009,231415,236510,241451,246329,250883,255345,259754,263872,267957,271821,275674,279387,282849,286354,289737,292921,295957,298983,301893,304709,307346,310001,312614,315047,317371,319659,321893,324072,326256,328312,330332,332279,334147,335996,337663,339448,341146,342817,344395,346001,347543,349012,350476,351939,353346,354641,355921,357213,358461,359666,360783,361959,362965,364004,365084,366112,367075,368048,368977,369870,370725,371569,372383,373218,374058,374869,375613,376326,377044,377749,378410,379112,379747,380362,381030,381626,382251,382859,383393,383983,384543,385084,385606,386141,386638,
0,0,9,102,483,1477,3345,5992,9670,14184,19407,25144,31398,37884,44655,51721,58863,65972,73163,80269,87359,94449,101188,107918,114417,120646,126794,132648,138454,144103,149731,155009,160086,165014,169788,174438,179008,183438,187779,191799,195719,199571,203435,207046,210505,214004,217339,220697,223768,226728,229641,232493,235247,237905,240538,243043,245407,247729,249955,252168,254313,256504,258529,260552,262516,264432,266200,267954,269641,271299,272891,274471,276037,277522,278997,280446,281822,283289,284572,285831,287050,288227,289369,290536,291630,292736,293855,294888,295880,296833,297802,298744,299721,300595,301474,302306,303123,303925,304717,305519,306291,307024,307754,308422,309126,309832,310528,311156,311729,312335,312991,313560,314102,314675,315241,315806,316326,316830,317337,317849,
0,0,0,18,146,523,1343,2671,4702,7314,10549,14244,18272,22699,27381,32305,37368,42669,48107,53640,58956,64288,69679,75000,80183,85573,90669,95556,100324,105038,109492,113992,118357,122587,126771,130854,134829,138743,142356,146027,149438,152796,156058,159327,162370,165423,168354,171323,174101,176656,179262,181825,184325,186753,189091,191344,193614,195742,197865,199882,201840,203796,205598,207524,209322,211079,212745,214406,215996,217512,219035,220500,221927,223334,224632,225938,227230,228523,229703,230842,231944,233058,234240,235349,236419,237451,238476,239464,240383,241304,242149,243018,243856,244679,245516,246334,247124,247910,248633,249369,250077,250807,251507,252167,252809,253438,254021,254660,255240,255834,256425,257013,257509,258080,258578,259068,259601,260065,260531,260990,
0,0,0,2,27,121,437,947,1788,3014,4608,6610,8887,11516,14421,17465,20833,24322,27890,31515,35266,39010,42910,46836,50669,54656,58541,62320,66128,69805,73392,76946,80341,83753,87080,90298,93547,96595,99679,102715,105704,108590,111227,113918,116620,119272,121753,124128,126508,128779,131004,133125,135273,137333,139348,141356,143331,145130,146935,148726,150469,152180,153814,155405,156983,158516,160014,161451,162835,164237,165625,166939,168271,169525,170779,171958,173154,174289,175435,176539,177572,178633,179615,180683,181677,182584,183511,184390,185219,186067,186922,187744,188546,189297,190097,190805,191523,192265,192993,193673,194327,194967,195579,196182,196773,197357,197963,198500,199029,199556,200066,200578,201100,201603,202080,202551,203013,203482,203946,204375,
0,0,0,0,4,19,68,213,445,895,1488,2288,3298,4545,5998,7572,9333,11324,13340,15492,17801,20232,22692,25153,27689,30252,32734,35368,37817,40368,42868,45464,47904,50319,52801,55173,57582,59890,62193,64511,66742,68958,71129,73172,75251,77271,79237,81123,83126,85002,86760,88511,90154,91862,93505,95063,96606,98173,99653,101113,102536,103937,105282,106616,107909,109256,110484,111769,112970,114091,115277,116389,117495,118590,119641,120677,121707,122622,123587,124541,125449,126356,127298,128183,129048,129858,130609,131378,132121,132898,133610,134357,135052,135758,136396,137035,137673,138349,138943,139482,140059,140623,141211,141759,142283,142804,143300,143811,144294,144713,145203,145674,146134,146548,146956,147344,147734,148137,148543,148978,
0,0,0,0,0,0,2,19,56,135,293,501,754,1123,1605,2223,2848,3629,4540,5499,6472,7580,8739,9898,11169,12458,13801,15183,16675,18168,19547,21071,22547,23919,25381,26880,28351,29795,31231,32645,34025,35448,36785,38136,39517,40860,42243,43557,44792,46104,47295,48625,49800,50962,52130,53240,54377,55432,56486,57514,58530,59507,60558,61598,62532,63474,64444,65386,66230,67085,67930,68770,69577,70406,71221,71979,72728,73472,74181,74877,75530,76245,76931,77608,78260,78912,79532,80134,80747,81309,81878,82489,83047,83578,84145,84680,85240,85805,86271,86759,87271,87714,88159,88594,89043,89464,89894,90318,90690,91098,91481,91853,92227,92600,92972,93330,93645,93989,94307,94597,
87648,328680,531370,683671,800321,891840,966252,1027571,1078908,1122132,1159624,1192558,1221265,1246969,1269435,1289834,1308443,1325310,1340675,1354566,1367425,1379493,1390329,1400678,1410170,1418988,1427183,1434829,1442008,1448778,1455167,1461273,1466805,1472068,1477155,1481950,1486435,1490858,1494911,1498811,1502593,1506021,1509372,1512586,1515635,1518550,1521308,1523996,1526607,1528990,1531306,1533527,1535744,1537804,1539795,1541695,1543521,1545254,1547007,1548700,1550291,1551818,1553278,1554737,1556142,1557436,1558742,1559959,1561199,1562307,1563483,1564565,1565541,1566557,1567570,1568562,1569439,1570249,1571118,1572019,1572840,1573602,1574348,1575098,1575846,1576518,1577181,1577814,1578502,1579144,1579735,1580354,1580933,1581513,1582036,1582544,1583003,1583524,1584037,1584522,1584989,1585476,1585936,1586365,1586763,1587179,1587573,1587973,1588314,1588697,1589054,1589400,1589765,1590067,1590376,1590699,1590995,1591293,1591619,1591889,
27800,171999,332592,466756,576244,666705,741639,803982,858102,904505,944557,979896,1011246,1039202,1064547,1087178,1107571,1126180,1143207,1158749,1172945,1186192,1198464,1209898,1220487,1230435,1239828,1248557,1256686,1264386,1271445,1278212,1284696,1290728,1296329,1301842,1306966,1311883,1316653,1321133,1325365,1329436,1333251,1336887,1340411,1343749,1346836,1350006,1352940,1355682,1358353,1360880,1363394,1365824,1368138,1370454,1372558,1374576,1376566,1378438,1380257,1382047,1383768,1385350,1387010,1388552,1390025,1391404,1392766,1394098,1395366,1396559,1397772,1398927,1400081,1401185,1402309,1403364,1404385,1405335,1406296,1407217,1408084,1408929,1409751,1410588,1411370,1412107,1412891,1413605,1414345,1415051,1415710,1416356,1417006,1417637,1418218,1418834,1419427,1420002,1420564,1421083,1421608,1422104,1422573,1423084,1423559,1424021,1424468,1424913,1425322,1425706,1426092,1426458,1426825,1427181,1427545,1427896,1428230,1428567,
11829,107302,235823,353784,454766,540170,613036,675455,728998,775863,817010,853176,885251,914137,940032,963682,984989,1004556,1022360,1038678,1053711,1067901,1080550,1092690,1104282,1114808,1124675,1133914,1142589,1150749,1158471,1165572,1172514,1178875,1184892,1190740,1196269,1201468,1206474,1211159,1215618,1219862,1223962,1227852,1231672,1235166,1238598,1241915,1245020,1248047,1250897,1253762,1256387,1258917,1261351,1263782,1266161,1268361,1270477,1272505,1274532,1276494,1278315,1280054,1281715,1283323,1284907,1286426,1287845,1289253,1290688,1292053,1293365,1294578,1295863,1297121,1298243,1299396,1300462,1301547,1302607,1303611,1304577,1305460,1306400,1307269,1308103,1308902,1309694,1310487,1311234,1311927,1312665,1313389,1314106,1314771,1315395,1315993,1316592,1317222,1317773,1318353,1318919,1319485,1320011,1320495,1321023,1321505,1321970,1322441,1322916,1323385,1323832,1324251,1324656,1325011,1325389,1325756,1326107,1326489,
3602,56050,147845,243289,330878,408358,475910,535346,587363,633194,673862,709684,742285,771377,797585,821315,843072,863361,881853,898988,914418,928902,942490,954929,966783,977819,988141,997607,1006822,1015556,1023670,1031338,1038556,1045448,1051953,1058110,1063935,1069667,1074959,1080111,1084881,1089532,1093903,1098136,1102145,1106004,1109803,1113367,1116766,1120082,1123184,1126092,1128979,1131615,1134308,1136958,1139418,1141814,1144099,1146281,1148351,1150361,1152292,1154152,1156026,1157777,1159477,1161184,1162788,1164336,1165821,1167238,1168694,1170020,1171419,1172705,1174013,1175275,1176386,1177498,1178626,1179669,1180691,1181734,1182681,1183586,1184490,1185377,1186234,1187059,1187927,1188718,1189468,1190212,1190986,1191721,1192428,1193085,1193737,1194429,1195114,1195743,1196324,1196956,1197490,1198029,1198552,1199115,1199596,1200097,1200586,1201072,1201521,1201967,1202379,1202803,1203243,1203621,1204044,1204444,
666,22407,76625,143798,211902,276280,335007,388050,436014,478543,517148,551760,583534,612233,638139,662110,683808,704184,722726,740025,756209,771022,785050,797962,810062,821498,832265,842165,851707,860704,869323,877080,884795,892072,898875,905390,911590,917501,923260,928625,933597,938527,943193,947619,951886,956002,959951,963624,967230,970751,974107,977295,980312,983251,986075,988805,991421,994062,996498,998940,1001182,1003392,1005497,1007509,1009445,1011307,1013133,1014993,1016688,1018364,1020026,1021581,1023111,1024626,1025982,1027378,1028694,1030009,1031255,1032455,1033678,1034826,1035956,1037046,1038097,1039164,1040186,1041161,1042105,1043027,1043891,1044757,1045609,1046412,1047220,1048009,1048763,1049467,1050200,1050912,1051565,1052186,1052788,1053467,1054135,1054721,1055239,1055841,1056383,1056947,1057501,1058010,1058510,1058992,1059468,1059933,1060361,1060815,1061249,1061681,
191,12312,50012,102698,159758,215195,267597,315993,360365,400312,436487,469708,499996,527758,553236,576819,598289,618353,637104,654459,670536,685338,699417,712378,724480,736068,746907,757055,766581,775672,784228,792314,799838,807310,814191,820802,827013,833034,838741,844309,849555,854547,859287,863770,868173,872409,876356,880342,884157,887728,891157,894464,897689,900733,903573,906372,908976,911526,914067,916532,918841,921122,923309,925373,927409,929424,931367,933259,935066,936759,938435,940066,941644,943195,944665,946093,947508,948837,950108,951406,952659,953839,954998,956090,957182,958276,959319,960338,961352,962353,963246,964172,965061,965886,966736,967523,968307,969093,969830,970536,971255,971926,972589,973254,973878,974511,975074,975659,976245,976810,977364,977884,978410,978904,979401,979897,980401,980852,981313,981732,
51,5862,29365,66898,111396,157673,202665,245068,284970,321842,355625,386664,415404,441834,466334,489068,509856,529230,547291,564000,579799,594408,608315,621026,633051,644517,655260,665375,674866,683900,692790,701152,708857,716303,723343,729974,736347,742287,748201,753750,758958,764199,769059,773633,778070,782352,786454,790377,794161,797756,801261,804680,807867,810997,813945,816887,819714,822379,824858,827327,829750,832041,834295,836509,838619,840675,842677,844603,846438,848210,849908,851508,853143,854678,856191,857654,859142,860494,861899,863210,864504,865790,866982,868108,869230,870327,871412,872463,873486,874445,875367,876294,877226,878143,879017,879838,880675,881394,882222,882931,883629,884356,885023,885720,886371,887000,887639,888271,888845,889412,889960,890526,891056,891574,892093,892601,893109,893585,894060,894524,
8,2343,15097,39352,71096,106767,142973,178531,212264,244462,274422,302692,328814,353414,376083,397452,417006,435455,452775,469132,484280,498510,511904,524508,536414,547736,558148,568389,577928,587030,595499,603520,611301,618630,625637,632283,638603,644631,650510,655981,661377,666496,671383,675967,680401,684661,688864,692896,696789,700385,703854,707303,710589,713794,716840,719767,722631,725291,727927,730492,732931,735274,737521,739641,741807,743869,745898,747846,749762,751691,753400,754988,756739,758401,759949,761475,762954,764404,765765,767137,768495,769738,770992,772197,773310,774440,775539,776646,777656,778680,779627,780577,781540,782454,783315,784185,785026,785834,786626,787422,788162,788863,789537,790202,790913,791536,792202,792850,793512,794110,794683,795248,795828,796333,796835,797328,797829,798340,798841,799367,
1,660,6330,20095,40674,65546,92477,120121,147410,174061,199754,223877,247026,268715,289330,308532,326708,343716,359672,374793,389222,402767,415318,427310,438737,449566,459879,469669,479094,487911,496403,504196,511774,519153,526026,532643,538879,544881,550629,556085,561381,566423,571321,575974,580315,584462,588636,592579,596371,599968,603501,606953,610199,613381,616483,619510,622317,625108,627816,630457,632899,635225,637559,639850,641993,644058,646126,648058,650029,651839,653631,655378,657073,658687,660340,661831,663298,664770,666131,667503,668854,670103,671386,672581,673657,674868,675984,677071,678172,679135,680156,681116,682096,683037,683916,684786,685595,686437,687224,688010,688836,689580,690308,690981,691710,692364,692984,693666,694259,694871,695469,696101,696667,697229,697723,698263,698776,699287,699807,700288,
0,279,3401,12299,26785,45625,67057,89776,112804,135782,158511,180130,200897,220373,239183,256732,273574,289417,304454,318702,332193,345104,357418,368782,379583,389968,399822,409116,417941,426420,434461,442146,449471,456612,463398,469789,475851,481623,487210,492507,497881,502845,507555,512171,516685,520786,524867,528743,532492,536247,539774,543138,546331,549561,552628,555465,558264,561034,563755,566335,568844,571244,573510,575694,577837,579910,581913,583922,585909,587678,589507,591259,592947,594576,596226,597708,599216,600691,602077,603447,604784,606055,607258,608459,609659,610837,611946,612970,613981,615001,616024,617029,617963,618931,619842,620689,621540,622346,623201,624026,624767,625533,626232,626944,627685,628360,628959,629609,630229,630791,631380,631980,632622,633169,633724,634238,634785,635296,635794,636325,
0,101,1565,6664,16354,29823,45945,63593,82367,101155,120013,138671,156805,174079,190584,206479,221581,236139,249849,263223,275683,287373,298631,309366,319551,329333,338610,347605,356169,364269,371908,379371,386462,393328,399919,406134,412092,417661,423122,428394,433585,438468,443134,447693,451979,456118,459961,463766,467427,470999,474430,477715,480869,484027,486991,489859,492469,495184,497774,500315,502813,505210,507499,509733,511876,513959,516002,517957,519836,521727,523566,525299,526939,528584,530125,531713,533223,534660,536062,537435,538745,540085,541318,542546,543746,544904,546042,547174,548265,549307,550316,551340,552333,553265,554230,555099,555946,556745,557554,558375,559170,559933,560623,561331,562004,562752,563410,564081,564688,565299,565875,566477,567052,567616,568164,568733,569243,569746,570263,570745,
0,26,688,3293,8968,17638,28910,42006,56265,71190,86469,101831,116786,131597,145808,159503,172740,185585,197684,209663,220902,231671,242022,251959,261405,270296,278985,287302,295285,302663,309796,316810,323326,329951,336163,342037,347698,353193,358351,363268,368096,372788,377307,381622,385771,389742,393577,397153,400671,404075,407580,410820,413869,416922,419850,422721,425340,427946,430588,433086,435452,437716,439885,442106,444133,446212,448219,450118,452028,453743,455546,457285,458897,460488,462042,463517,464976,466409,467782,469146,470463,471677,472948,474206,475395,476556,477663,478766,479868,480942,481912,482915,483866,484806,485708,486529,487397,488250,489040,489751,490546,491278,491972,492704,493370,494068,494740,495346,495985,496578,497153,497745,498314,498873,499420,499957,500481,500969,501481,501972,
0,8,207,1299,4249,9145,16125,24753,34789,45702,57311,69156,81181,93123,104982,116341,127576,138476,148978,159234,169117,178640,187710,196322,204777,212820,220463,228016,235458,242309,249007,255260,261379,267306,272989,278530,283896,288934,293721,298305,302774,307145,311278,315290,319189,323008,326610,330165,333534,336756,339998,343144,346068,348849,351593,354287,356954,359477,361921,364161,366515,368774,370996,373067,375136,377097,379068,380867,382656,384390,386159,387758,389373,390920,392467,393929,395369,396731,398093,399386,400687,401862,403119,404273,405419,406563,407692,408784,409815,410804,411770,412785,413732,414666,415531,416366,417175,417969,418746,419541,420321,421061,421745,422454,423166,423863,424513,425089,425724,426306,426902,427506,428078,428632,429197,429716,430270,430772,431252,431756,
0,2,50,399,1578,4035,7779,12816,19203,26455,34396,42868,51544,60323,69142,77999,86835,95533,104006,112395,120501,128486,136212,143707,150939,157976,164725,171285,177664,183746,189583,195231,200751,206146,211239,216094,220679,225321,229786,234026,238139,242156,246131,249982,253567,257081,260412,263671,266815,269902,272862,275638,278362,281013,283687,286238,288613,291001,293319,295586,297773,299774,301832,303750,305641,307528,309335,311125,312886,314553,316180,317741,319244,320725,322182,323624,325049,326346,327662,328973,330194,331435,332587,333730,334800,335872,336945,337961,338946,339988,340908,341834,342737,343622,344516,345341,346118,346914,347717,348483,349240,349937,350592,351256,351883,352531,353158,353784,354400,354989,355582,356142,356656,357159,357673,358201,358722,359209,359676,360149,
0,0,9,120,552,1559,3449,6300,9996,14549,19595,25280,31363,37684,44157,50751,57531,64318,71084,77708,84199,90642,97027,103171,109121,114947,120762,126432,131855,137063,142107,146992,151758,156266,160736,165182,169344,173498,177464,181241,184783,188442,191967,195272,198669,201894,205050,208002,210937,213747,216478,219093,221647,224102,226519,228890,231090,233261,235384,237439,239414,241396,243295,245094,246914,248631,250324,251950,253535,255101,256641,258176,259676,261078,262502,263832,265079,266406,267610,268720,269818,270956,272063,273136,274205,275212,276180,277169,278134,279025,279906,280821,281695,282517,283339,284125,284891,285689,286451,287133,287755,288519,289186,289821,290425,291048,291649,292267,292868,293454,294027,294612,295124,295620,296134,296638,297140,297616,298075,298538,
0,0,1,30,149,516,1278,2566,4368,6740,9643,13123,16872,20822,25111,29649,34367,39066,43886,48850,53770,58596,63408,68258,72900,77498,82077,86504,90829,95072,99158,103236,107213,111130,114957,118565,122133,125636,129010,132168,135341,138444,141521,144357,147199,149990,152638,155169,157797,160172,162597,164822,167097,169306,171421,173439,175517,177482,179433,181230,183006,184781,186481,188197,189771,191359,192922,194442,195925,197397,198784,200128,201474,202766,204032,205256,206379,207550,208678,209732,210796,211863,212866,213875,214835,215790,216690,217593,218524,219431,220254,221044,221886,222706,223473,224222,224950,225665,226347,227028,227696,228397,229045,229660,230271,230853,231465,232014,232541,233051,233567,234083,234533,235003,235446,235929,236394,236863,237287,237727,
0,0,0,2,18,81,278,658,1237,2217,3541,5120,6938,9027,11389,13939,16577,19440,22348,25315,28460,31745,34937,38109,41349,44636,47828,50979,54188,57285,60304,63173,66081,69053,71913,74733,77492,80209,82834,85546,87993,90455,92891,95185,97448,99644,101806,103952,106065,108066,110074,111967,113755,115562,117337,119082,120756,122444,124015,125628,127142,128646,130084,131511,132913,134230,135533,136806,138087,139302,140499,141665,142833,143959,145010,146036,147065,148123,149115,150125,151106,152002,152907,153812,154643,155428,156246,157063,157878,158580,159346,160046,160722,161425,162157,162880,163535,164222,164857,165432,166015,166581,167129,167671,168185,168770,169270,169788,170275,170740,171226,171713,172155,172627,173040,173465,173887,174263,174650,175041,
0,0,0,0,1,7,25,79,206,402,721,1161,1753,2501,3377,4402,5536,6785,8077,9516,11095,12719,14364,16013,17732,19519,21355,23160,25004,26923,28772,30583,32345,34231,36010,37852,39615,41451,43115,44820,46688,48334,49969,51595,53136,54726,56318,57788,59237,60699,62098,63516,64846,66164,67494,68763,70046,71293,72459,73677,74822,75993,77077,78207,79256,80301,81320,82307,83260,84256,85175,86169,87074,87944,88803,89649,90465,91285,92050,92823,93589,94367,95101,95769,96468,97129,97790,98447,99063,99725,100326,100931,101482,102081,102644,103173,103758,104277,104797,105285,105790,106249,106727,107191,107666,108123,108549,108996,109419,109842,110199,110591,110981,111337,111700,112051,112403,112737,113092,113419,
108759,360927,559551,705817,816286,902811,972246,1029390,1077690,1117839,1152814,1183687,1210660,1234351,1255409,1274445,1291635,1307376,1321775,1334811,1346833,1357981,1368298,1377740,1386721,1395244,1402858,1410122,1416991,1423334,1429400,1435075,1440198,1445203,1450020,1454603,1458857,1462908,1466750,1470421,1473910,1477157,1480360,1483368,1486322,1489095,1491707,1494147,1496523,1498813,1501059,1503226,1505251,1507293,1509131,1511008,1512814,1514539,1516129,1517756,1519221,1520650,1522129,1523463,1524805,1526110,1527326,1528560,1529725,1530861,1531905,1532910,1533920,1534905,1535891,1536804,1537682,1538561,1539348,1540150,1540934,1541720,1542445,1543147,1543845,1544545,1545184,1545870,1546528,1547169,1547747,1548279,1548832,1549418,1549972,1550466,1550971,1551443,1551940,1552413,1552883,1553320,1553749,1554170,1554586,1554985,1555362,1555742,1556065,1556406,1556738,1557085,1557422,1557724,1558035,1558334,1558635,1558937,1559238,1559513,
40874,205210,369955,503045,608852,694965,765375,824351,875070,918349,955576,988464,1017766,1043680,1067039,1087882,1106932,1124465,1140300,1154940,1168279,1180520,1191945,1202483,1212303,1221546,1230224,1238348,1246047,1253224,1259965,1266235,1272232,1277885,1283220,1288338,1293191,1297661,1301922,1306139,1310122,1313894,1317454,1320963,1324286,1327383,1330392,1333227,1336016,1338634,1341132,1343486,1345907,1348114,1350288,1352446,1354513,1356383,1358183,1359998,1361782,1363524,1365082,1366590,1368103,1369584,1371006,1372353,1373653,1374885,1376114,1377319,1378458,1379534,1380640,1381697,1382716,1383726,1384668,1385588,1386494,1387384,1388215,1389030,1389827,1390587,1391292,1392020,1392746,1393445,1394214,1394799,1395415,1396042,1396694,1397297,1397874,1398414,1398979,1399554,1400072,1400612,1401110,1401610,1402053,1402542,1402971,1403383,1403769,1404183,1404594,1404991,1405401,1405750,1406117,1406487,1406808,1407145,1407468,1407774,
19611,136285,273803,394016,493496,576948,646497,705527,755839,799777,837903,871708,901573,928460,952421,974179,994161,1012132,1028773,1043771,1057789,1070768,1082872,1093926,1104498,1114491,1123833,1132374,1140629,1148091,1155333,1162081,1168358,1174455,1180045,1185516,1190810,1195705,1200353,1204800,1208939,1213003,1216778,1220460,1224019,1227382,1230623,1233631,1236557,1239349,1242064,1244624,1247118,1249589,1252011,1254254,1256462,1258464,1260497,1262452,1264339,1266044,1267769,1269406,1270957,1272515,1273933,1275444,1276867,1278168,1279513,1280820,1282096,1283182,1284392,1285565,1286609,1287688,1288703,1289712,1290667,1291605,1292552,1293441,1294278,1295075,1295889,1296660,1297383,1298147,1298861,1299553,1300194,1300884,1301497,1302133,1302708,1303281,1303918,1304486,1305046,1305547,1306106,1306635,1307103,1307595,1308082,1308574,1308984,1309436,1309867,1310306,1310705,1311120,1311507,1311889,1312260,1312613,1312971,1313302,
7455,78164,182773,284193,373400,450079,515839,572386,622005,665545,704168,738198,768940,796239,820826,843086,863447,882255,899643,915615,930119,943675,956394,968195,979264,989477,999060,1008082,1016558,1024601,1032220,1039296,1046199,1052426,1058448,1064182,1069712,1075075,1080019,1084775,1089199,1093582,1097614,1101586,1105353,1108898,1112398,1115667,1118800,1121892,1124920,1127702,1130373,1132852,1135359,1137714,1139989,1142147,1144236,1146272,1148227,1150051,1151941,1153737,1155499,1157155,1158799,1160305,1161748,1163247,1164623,1166028,1167343,1168666,1169895,1171114,1172265,1173434,1174541,1175641,1176639,1177627,1178619,1179590,1180513,1181360,1182216,1183140,1183921,1184683,1185448,1186219,1186975,1187691,1188423,1189096,1189744,1190396,1190970,1191581,1192210,1192764,1193340,1193938,1194497,1194972,1195461,1195947,1196434,1196919,1197349,1197813,1198234,1198653,1199087,1199517,1199918,1200291,1200663,1201005,
1784,36156,104870,181608,255255,321568,381122,433621,480411,521906,559142,592572,622659,649771,674522,696955,717553,736509,754264,770489,785474,799575,812668,824712,836027,846680,856710,866120,874967,883360,891222,898548,905737,912537,918746,924807,930668,936177,941448,946368,951060,955626,959937,964014,968013,971730,975364,978854,982244,985504,988670,991616,994550,997279,999936,1002419,1004793,1007145,1009472,1011782,1013852,1015940,1017885,1019774,1021636,1023411,1025107,1026725,1028406,1029913,1031380,1032932,1034380,1035724,1037030,1038344,1039613,1040854,1042062,1043152,1044265,1045359,1046407,1047379,1048347,1049308,1050187,1051095,1051990,1052871,1053702,1054525,1055334,1056138,1056884,1057610,1058309,1059010,1059678,1060362,1061016,1061632,1062254,1062849,1063441,1063984,1064491,1065042,1065536,1066056,1066587,1067024,1067518,1067984,1068407,1068858,1069271,1069690,1070104,1070466,
702,21288,71954,135086,198657,258145,312428,361478,405394,444954,480764,513238,542686,569446,593906,616213,636470,655409,673124,689375,704657,718519,731809,743987,755389,766133,776328,785836,794756,803343,811516,819099,826346,833148,839531,845612,851519,857188,862577,867773,872639,877296,881667,885963,890010,893968,897721,901332,904864,908147,911304,914361,917320,920166,922932,925521,927955,930425,932737,935016,937269,939376,941442,943421,945344,947209,948997,950719,952425,954103,955687,957198,958662,960160,961544,962895,964239,965498,966734,967909,968974,970136,971216,972273,973299,974325,975256,976235,977100,978024,978889,979721,980544,981317,982097,982810,983565,984235,984934,985594,986320,986953,987546,988199,988803,989374,989892,990468,990982,991505,992009,992472,992943,993428,993892,994340,994793,995238,995640,996061,
216,11602,46030,93913,146105,197347,245522,289699,330144,367430,401715,431963,459842,486012,509733,531593,551670,570275,587618,603943,618771,632692,645852,658048,669513,680207,690237,699790,708850,717544,725924,733855,741084,748045,754515,760652,766653,772416,778003,783137,788153,792864,797338,801647,805842,809902,813671,817324,821005,824305,827669,830812,833823,836684,839468,842151,844702,847254,849661,851967,854216,856347,858523,860502,862470,864390,866254,868035,869764,871445,873028,874595,876133,877640,879002,880365,881709,883031,884241,885487,886645,887833,888906,890016,891092,892136,893122,894131,895120,896078,896979,897852,898744,899594,900368,901169,901930,902660,903407,904056,904725,905364,906019,906703,907313,907874,908452,909035,909592,910152,910695,911216,911735,912211,912694,913166,913635,914080,914508,914963,
53,5360,26162,59692,100054,141509,182424,221106,257060,290270,321471,349884,376234,400678,423500,444465,463989,481991,498769,514381,529098,542704,555844,567883,579377,590183,600286,609939,618915,627398,635557,643156,650499,657407,663888,669995,675895,681568,686949,692039,697138,702135,706680,711138,715367,719468,723473,727349,730865,734282,737594,740823,743869,746788,749765,752588,755235,757790,760230,762656,764914,767115,769274,771307,773273,775275,777126,778918,780722,782475,784117,785736,787304,788855,790318,791748,793067,794367,795606,796866,798085,799257,800466,801583,802697,803774,804793,805762,806710,807666,808625,809521,810396,811233,812073,812914,813733,814463,815228,815991,816697,817425,818113,818766,819367,820009,820656,821240,821782,822346,822893,823395,823921,824447,824898,825366,825835,826283,826741,827196,
3,1847,12742,33684,61669,92819,124934,156493,187063,215631,242906,268356,292064,314296,335135,354366,372635,389575,405430,420389,434470,447645,460207,471774,482694,493142,502947,512331,521218,529621,537708,545266,552537,559456,566018,572191,578078,583793,589250,594476,599524,604455,609114,613588,617688,621805,625695,629461,633151,636652,639986,643262,646342,649336,652226,654984,657690,660287,662808,665296,667631,669732,671833,673906,675922,677852,679740,681648,683426,685134,686824,688510,690130,691718,693228,694725,696126,697491,698813,700131,701410,702608,703790,704937,706100,707195,708327,709366,710372,711276,712227,713125,714021,714901,715727,716548,717348,718110,718881,719658,720365,721046,721750,722387,723026,723669,724299,724905,725476,726077,726605,727208,727782,728279,728808,729270,729735,730246,730757,731228,
1,816,7248,21609,42533,67566,94222,120992,147434,173034,197459,220659,242736,263267,282406,300631,317691,333878,349043,363462,377016,389708,401766,413020,423616,433937,443617,452596,461366,469624,477466,484869,492062,498755,505305,511540,517590,523213,528667,533763,538717,543495,548003,552369,556515,560568,564455,568167,571831,575117,578421,581742,584864,587995,590897,593642,596290,598892,601425,603869,606204,608390,610641,612746,614793,616720,618747,620616,622484,624202,625982,627677,629283,630794,632280,633777,635223,636610,637838,639199,640523,641724,642867,644026,645198,646265,647314,648355,649375,650364,651362,652272,653159,654014,654864,655698,656499,657236,657999,658760,659475,660185,660831,661493,662147,662783,663413,664027,664613,665181,665755,666291,666845,667382,667899,668412,668912,669379,669872,670317,
0,360,3787,13045,27789,46397,67217,89080,111593,133606,155282,175723,195219,213574,231167,247879,263448,278538,292691,306018,318658,330651,341877,352547,362612,372615,381883,390718,398959,407068,414709,421922,428793,435417,441841,448077,453786,459290,464573,469536,474494,479159,483746,488137,492239,496188,499985,503718,507346,510732,513939,517131,520221,523191,526044,528743,531339,533947,536559,539082,541376,543722,545917,548101,550180,552073,554012,555813,557587,559291,561012,562647,564269,565757,567238,568752,570170,571541,572890,574234,575440,576724,577880,579043,580181,581320,582370,583371,584370,585353,586279,587277,588159,589012,589906,590741,591584,592368,593124,593856,594616,595354,596032,596752,597469,598132,598761,599349,600017,600559,601129,601642,602161,602671,603187,603701,604211,604719,605194,605686,
0,128,1754,6765,16260,29288,44831,61897,80019,97800,115602,133199,150139,166286,181681,196603,210607,224156,237028,249205,261032,272108,282633,292775,302385,311620,320137,328482,336528,344109,351425,358413,364856,371092,377170,382919,388483,393797,398837,403791,408498,413084,417511,421639,425630,429478,433172,436778,440322,443657,446884,450019,452995,455958,458661,461388,463961,466533,469045,471392,473713,475845,477927,480046,482071,484111,486005,487888,489663,491433,493150,494835,496423,497941,499467,500981,502441,503825,505169,506474,507738,508939,510038,511257,512365,513492,514563,515589,516607,517536,518478,519427,520362,521303,522192,523049,523841,524606,525394,526120,526844,527516,528193,528878,529531,530209,530880,531539,532181,532779,533349,533945,534496,535007,535550,536095,536620,537075,537584,538099,
0,26,649,3133,8448,16628,27047,39094,52056,65935,80032,94261,108293,121899,135128,147693,159868,171827,183094,193987,204378,214360,223998,232991,241521,249929,258060,265731,273053,280305,287099,293649,299817,305814,311450,317006,322320,327345,332152,336826,341377,345701,349927,354014,357843,361590,365221,368632,371979,375174,378302,381265,384127,386955,389764,392433,394890,397398,399724,402075,404316,406487,408621,410651,412688,414596,416463,418197,419988,421595,423259,424888,426428,427931,429429,430866,432318,433652,435042,436397,437564,438725,439893,441049,442148,443226,444342,445367,446372,447347,448258,449189,450125,450954,451767,452589,453417,454184,454951,455709,456431,457101,457797,458494,459131,459729,460375,461011,461597,462152,462723,463270,463777,464273,464846,465373,465884,466381,466843,467298,
0,9,199,1088,3587,7999,13966,21614,30396,40194,50349,60809,71253,82006,92382,102718,112637,122321,131878,141011,149996,158722,166961,175099,182964,190167,197262,204133,210893,217118,223280,229216,234956,240389,245572,250666,255556,260209,264695,268962,272989,277041,280946,284681,288253,291769,295099,298383,301602,304571,307448,310433,313107,315800,318386,320803,323178,325507,327759,330024,332133,334208,336227,338157,340030,341893,343731,345529,347184,348851,350404,351897,353315,354734,356161,357559,358927,360243,361549,362802,364029,365239,366372,367442,368506,369601,370662,371625,372624,373579,374513,375437,376332,377156,378004,378802,379619,380357,381154,381906,382618,383296,383929,384555,385226,385847,386458,387075,387653,388246,388814,389370,389902,390449,390968,391484,391992,392466,392905,393349,
0,1,50,386,1409,3456,6901,11426,17079,23501,30589,38093,46019,54059,62212,70301,78205,86127,93698,101163,108892,116220,123308,130080,136679,143154,149294,155254,161086,166576,171931,177165,182199,186957,191631,196116,200492,204773,208946,212842,216602,220292,223896,227294,230668,233957,237105,240132,243100,245910,248692,251329,253826,256286,258798,261141,263363,265566,267730,269795,271800,273791,275687,277562,279309,281055,282785,284453,286074,287565,288990,290427,291876,293208,294603,295936,297191,298433,299652,300785,301928,303075,304175,305278,306324,307324,308326,309324,310243,311087,312002,312850,313721,314614,315420,316198,316907,317623,318383,319059,319736,320389,321052,321705,322315,322962,323534,324113,324704,325276,325810,326390,326927,327414,327916,328413,328875,329321,329775,330208,
0,0,8,87,424,1207,2632,4865,7904,11557,15886,20626,25739,31175,36641,42465,48289,54106,60002,65787,71508,77115,82680,88097,93491,98686,103899,108850,113691,118295,122742,127239,131507,135750,139591,143519,147299,150991,154517,157896,161244,164526,167601,170582,173490,176422,179253,181965,184550,187047,189492,191907,194148,196347,198547,200631,202647,204651,206542,208448,210277,212078,213878,215558,217153,218692,220323,221854,223385,224824,226269,227604,228939,230171,231423,232685,233855,234969,236124,237274,238335,239385,240443,241473,242452,243385,244300,245210,246127,246988,247829,248632,249460,250250,251012,251750,252430,253160,253852,254534,255181,255824,256463,257087,257696,258286,258845,259391,259914,260415,260929,261452,261971,262452,262937,263413,263867,264299,264736,265156,
0,0,1,10,66,266,731,1510,2727,4300,6363,8714,11449,14449,17701,21004,24591,28306,32048,35853,39730,43565,47419,51217,55153,58976,62756,66429,70022,73525,76950,80283,83587,86848,89966,93034,96009,98912,101783,104533,107203,109816,112394,114795,117299,119603,121988,124215,126509,128612,130711,132700,134627,136546,138415,140167,141944,143661,145323,146916,148605,150107,151623,153166,154595,156085,157422,158741,160023,161303,162553,163782,164966,166163,167274,168324,169372,170408,171416,172352,173297,174190,175115,175994,176822,177671,178486,179301,180154,180912,181644,182354,183057,183769,184456,185125,185800,186472,187114,187708,188327,188919,189448,190001,190542,191070,191595,192121,192630,193126,193592,194073,194519,194965,195399,195803,196201,196632,197052,197455,
0,0,0,0,2,17,82,221,443,822,1429,2231,3184,4325,5619,7124,8806,10513,12372,14241,16260,18249,20351,22471,24689,26947,29093,31391,33669,35850,37988,40165,42328,44498,46634,48744,50768,52783,54787,56796,58693,60540,62471,64333,66068,67841,69466,71138,72677,74352,75933,77449,78882,80313,81733,83062,84422,85729,87048,88331,89619,90779,91906,93067,94159,95273,96422,97519,98538,99497,100457,101431,102364,103320,104278,105186,106012,106893,107706,108580,109405,110160,110917,111666,112387,113087,113764,114411,115072,115723,116380,116951,117573,118169,118748,119328,119889,120417,120920,121419,121934,122422,122887,123350,123839,124312,124769,125227,125668,126130,126549,126944,127344,127747,128109,128467,128811,129193,129548,129869,
128774,387656,583204,723604,828797,910577,976538,1030447,1076040,1114499,1147549,1176436,1201827,1224261,1244120,1262108,1278453,1293191,1306748,1319081,1330540,1341075,1350787,1359902,1368477,1376359,1383788,1390735,1397324,1403406,1409181,1414481,1419609,1424329,1428794,1433064,1437266,1441215,1444843,1448446,1451782,1454892,1457939,1460771,1463572,1466247,1468781,1471241,1473597,1475875,1478039,1480071,1481983,1483941,1485790,1487573,1489267,1490858,1492439,1494004,1495470,1496932,1498263,1499615,1500901,1502115,1503313,1504464,1505583,1506739,1507801,1508797,1509774,1510667,1511580,1512506,1513363,1514251,1515042,1515830,1516647,1517396,1518098,1518766,1519418,1520036,1520664,1521330,1521965,1522562,1523162,1523716,1524245,1524776,1525289,1525773,1526234,1526709,1527212,1527663,1528134,1528580,1528982,1529404,1529785,1530192,1530553,1530936,1531283,1531619,1531950,1532302,1532638,1532943,1533257,1533559,1533865,1534135,1534401,1534699,
53982,234301,400378,531141,633756,716076,783363,839469,887088,927841,963022,994199,1021941,1046279,1067958,1087767,1105533,1121823,1136893,1150556,1163133,1174862,1185686,1195730,1204969,1213730,1221878,1229553,1236917,1243748,1249998,1255957,1261614,1267009,1271965,1276881,1281507,1285785,1290053,1294120,1297820,1301362,1304677,1308049,1311165,1314232,1317173,1319914,1322519,1325145,1327561,1329837,1332126,1334289,1336374,1338322,1340326,1342148,1343933,1345714,1347387,1348914,1350451,1351903,1353330,1354743,1356067,1357353,1358579,1359781,1360984,1362099,1363182,1364231,1365309,1366335,1367311,1368275,1369173,1370060,1370916,1371765,1372582,1373363,1374124,1374819,1375518,1376230,1376936,1377580,1378270,1378890,1379480,1380086,1380703,1381288,1381879,1382353,1382899,1383477,1384014,1384521,1384995,1385461,1385885,1386324,1386739,1387165,1387574,1387978,1388370,1388766,1389147,1389497,1389843,1390173,1390492,1390810,1391119,1391404,
28595,162260,306453,426860,524341,604407,670881,727130,775201,816521,852641,884622,912683,937528,960275,980589,999384,1016629,1032140,1046568,1059664,1072055,1083366,1094073,1103997,1113254,1121988,1130026,1137623,1144866,1151518,1157917,1163990,1169696,1175003,1180125,1185098,1189790,1194151,1198315,1202231,1206133,1209827,1213314,1216702,1219931,1223026,1226002,1228889,1231612,1234173,1236735,1239090,1241340,1243654,1245768,1247795,1249814,1251731,1253617,1255425,1257083,1258701,1260264,1261812,1263229,1264715,1266044,1267424,1268719,1269993,1271216,1272427,1273575,1274659,1275786,1276783,1277850,1278817,1279767,1280704,1281608,1282544,1283385,1284181,1284968,1285739,1286513,1287262,1287964,1288615,1289284,1289915,1290536,1291243,1291859,1292454,1293005,1293551,1294086,1294629,1295125,1295643,1296143,1296621,1297085,1297508,1297952,1298384,1298815,1299213,1299621,1299981,1300370,1300737,1301102,1301485,1301831,1302180,1302523,
11945,99935,214920,319321,408662,483943,548020,602883,650236,691999,728721,761000,789939,815729,839052,860161,879419,897108,913421,928344,942127,955038,966816,977680,987982,997711,1006683,1015109,1023077,1030626,1037878,1044565,1050902,1056896,1062672,1068175,1073423,1078354,1083194,1087646,1091874,1095847,1099682,1103408,1107025,1110442,1113583,1116691,1119726,1122608,1125394,1127985,1130450,1132945,1135260,1137525,1139655,1141827,1143806,1145751,1147650,1149441,1151284,1152973,1154748,1156285,1157849,1159335,1160775,1162203,1163554,1164873,1166148,1167340,1168511,1169659,1170747,1171829,1172873,1173890,1174860,1175802,1176778,1177710,1178543,1179373,1180214,1181063,1181813,1182583,1183325,1184044,1184746,1185441,1186128,1186781,1187386,1187963,1188580,1189143,1189713,1190307,1190847,1191384,1191892,1192399,1192858,1193334,1193802,1194255,1194685,1195094,1195504,1195888,1196257,1196631,1197027,1197406,1197764,1198076,
3487,50293,131094,214441,290401,358005,417029,468932,514826,554978,590693,622773,651563,677708,701261,722661,742223,760251,776967,792452,806625,819952,832228,843747,854391,864510,874068,882900,891311,899230,906682,913617,920316,926750,932812,938497,943862,949117,954100,958757,963270,967575,971480,975397,979240,982931,986303,989553,992738,995834,998685,1001498,1004176,1006863,1009457,1011900,1014163,1016408,1018595,1020691,1022702,1024672,1026519,1028334,1030142,1031788,1033427,1034981,1036600,1038069,1039532,1040936,1042281,1043612,1044863,1046094,1047253,1048382,1049567,1050619,1051661,1052665,1053691,1054633,1055501,1056421,1057344,1058202,1059063,1059910,1060724,1061552,1062309,1063112,1063843,1064516,1065182,1065837,1066495,1067082,1067685,1068343,1068919,1069509,1070042,1070583,1071052,1071579,1072076,1072541,1073000,1073469,1073957,1074356,1074772,1075166,1075561,1075940,1076331,1076722,
1590,32594,94214,164511,231983,293559,348814,397822,441531,480684,515468,547089,575424,601234,624425,645626,665147,683118,699799,715289,729810,742989,755432,767074,778049,788212,797766,806765,815374,823345,830924,838199,844959,851488,857475,863281,868858,874263,879315,884199,888812,893174,897371,901353,905170,908884,912456,915800,919056,922278,925355,928329,931174,933799,936359,938820,941198,943510,945691,947879,950039,952020,953969,955804,957674,959489,961168,962852,964432,965954,967451,968856,970275,971679,972999,974286,975554,976807,977938,979090,980172,981262,982284,983299,984196,985156,986056,986939,987852,988735,989572,990406,991214,991943,992718,993424,994117,994806,995487,996132,996764,997378,997965,998547,999111,999636,1000158,1000710,1001198,1001705,1002195,1002678,1003138,1003614,1004068,1004478,1004883,1005293,1005698,1006115,
579,18548,63642,119633,176994,231478,281539,326731,367566,404293,437804,467871,495095,520245,543036,564286,583648,601642,618171,633474,647984,661308,673739,685433,696336,706695,716173,725284,733826,742092,749841,757070,763939,770472,776715,782547,788185,793625,798703,803564,808322,812857,817054,821182,825104,828849,832419,835946,839369,842620,845782,848666,851580,854305,856921,859498,861956,864295,866539,868737,870830,872915,875025,876999,878874,880686,882454,884211,885860,887517,889036,890546,892000,893399,894841,896144,897406,898652,899860,901035,902131,903232,904256,905255,906296,907313,908287,909176,910091,910993,911846,912699,913537,914344,915115,915853,916564,917258,917894,918571,919227,919918,920530,921152,921752,922287,922848,923404,923939,924489,924971,925477,925953,926447,926904,927355,927799,928197,928585,928986,
194,9281,38292,80069,126007,172278,215920,256174,293254,327071,358019,386353,412653,436721,458985,479624,498725,516238,532605,547845,562033,575238,587693,599298,610174,620421,629957,639139,647714,655921,663717,670975,677912,684606,690968,696870,702642,708127,713298,718369,723194,727852,732243,736478,740562,744431,748206,751807,755217,758546,761649,764671,767495,770206,772946,775608,778148,780602,782907,785156,787315,789448,791494,793481,795314,797138,798905,800736,802414,804005,805551,807068,808670,810172,811554,812891,814241,815539,816768,817976,819124,820279,821415,822486,823495,824490,825442,826363,827292,828236,829131,829968,830810,831684,832493,833286,834066,834808,835543,836199,836855,837526,838166,838815,839437,839993,840557,841138,841665,842177,842717,843231,843760,844216,844694,845138,845603,846023,846471,846887,
39,3811,20422,48070,81974,117771,153551,187131,219172,249223,277401,303368,327519,349816,370338,389585,407686,424482,440122,454933,468506,481259,493344,504771,515473,525608,535075,544236,552610,560759,568410,575901,583006,589619,595763,601783,607352,612837,618102,623077,627926,632614,637021,641204,645193,649036,652847,656488,659933,663256,666434,669514,672484,675346,678167,680879,683457,685956,688365,690696,692935,694949,696959,698892,700877,702782,704656,706491,708291,709975,711606,713199,714670,716180,717664,719014,720352,721679,722928,724164,725352,726524,727650,728683,729707,730737,731716,732760,733672,734623,735556,736484,737353,738200,739024,739832,740606,741365,742138,742876,743558,744226,744899,745507,746120,746722,747305,747911,748454,748997,749518,750033,750577,751090,751554,752008,752483,752951,753407,753882,
9,1849,12488,32796,59325,88957,119152,149014,177946,205191,230762,254620,277117,297959,317647,335990,353154,369326,384438,398568,411881,424420,436089,447262,457757,467672,476889,485626,494093,502062,509711,516989,523810,530488,536619,542632,548390,553807,559027,564074,568933,573584,578046,582172,586170,589979,593701,597248,600650,603937,607080,610131,613102,615977,618811,621501,624056,626589,629020,631419,633615,635791,637837,639877,641745,643627,645506,647318,649083,650725,652382,653996,655474,657021,658459,659872,661231,662573,663754,664947,666207,667394,668584,669630,670673,671707,672744,673735,674719,675728,676688,677550,678455,679247,680085,680903,681650,682429,683189,683917,684611,685270,685966,686647,687321,687915,688521,689106,689670,690222,690764,691289,691829,692375,692855,693328,693814,694304,694765,695208,
1,916,6955,20701,40356,63690,88496,113892,138609,162557,185252,207075,227488,246662,264907,282023,297824,313031,327217,340501,353158,365047,376320,386881,396930,406645,415705,424366,432535,440314,447820,454920,461768,468286,474417,480340,486034,491528,496743,501551,506216,510770,515290,519481,523458,527278,530928,534445,537802,541134,544229,547415,550340,553262,555966,558635,561141,563736,566146,568444,570636,572869,575044,577012,578945,580814,582756,584550,586279,587954,589628,591229,592788,594283,595737,597148,598516,599823,601065,602383,603587,604731,605838,606989,608150,609194,610233,611213,612141,613061,613988,614853,615709,616572,617414,618252,619036,619784,620567,621321,622043,622669,623306,623992,624650,625256,625875,626515,627125,627700,628303,628812,629328,629830,630331,630811,631293,631757,632207,632673,
1,332,3393,11817,25213,42324,61809,82019,102331,122580,142421,161297,179312,196506,212871,228360,243001,256893,270035,282520,294356,305553,316148,326345,335989,345156,353814,362074,369846,377261,384426,391265,397805,404000,410093,415649,421274,426407,431369,436073,440791,445143,449434,453468,457418,461192,464773,468300,471713,474851,477980,480982,483919,486780,489464,492046,494601,497063,499492,501802,504084,506238,508351,510418,512343,514264,516116,517944,519651,521347,522997,524580,526062,527568,529072,530482,531832,533144,534462,535672,536873,538063,539174,540288,541322,542395,543455,544454,545420,546404,547277,548222,549110,549964,550853,551635,552405,553176,553916,554606,555368,556050,556724,557405,558116,558763,559347,559947,560555,561133,561697,562241,562768,563263,563781,564273,564732,565232,565680,566153,
0,80,1405,5867,14105,25469,39099,54173,69976,86108,102086,118054,133410,148236,162537,176107,189210,201566,213364,224637,235487,245612,255294,264727,273580,281994,290069,297948,305411,312446,319123,325545,331760,337794,343440,348925,354194,359078,363928,368509,372911,377118,381308,385285,389012,392664,396226,399553,402832,406079,409159,412115,414913,417731,420420,423015,425458,427813,430131,432403,434588,436668,438737,440789,442733,444606,446376,448162,449926,451539,453147,454743,456160,457574,459003,460449,461771,463050,464336,465541,466753,467920,469025,470175,471201,472215,473240,474247,475274,476207,477099,478040,478944,479784,480614,481409,482223,482968,483710,484439,485190,485889,486559,487193,487821,488425,489048,489620,490222,490780,491353,491892,492403,492909,493405,493913,494405,494873,495335,495790,
0,21,446,2276,6534,12963,21473,31577,42783,54662,66960,79260,91353,103364,114944,126284,137332,147981,158178,167997,177392,186543,195134,203332,211357,218963,226369,233468,240244,246774,253011,258907,264648,270135,275417,280478,285412,290059,294534,298867,302939,306973,310834,314432,318099,321632,324884,328142,331274,334233,337148,339997,342727,345356,348008,350408,352878,355245,357493,359637,361727,363762,365748,367686,369565,371366,373142,374851,376474,378063,379655,381096,382564,383993,385441,386778,388146,389418,390647,391850,393054,394234,395284,396356,397435,398465,399485,400492,401443,402335,403201,404098,404916,405722,406511,407312,408087,408858,409608,410373,411132,411811,412465,413020,413663,414282,414884,415462,416023,416596,417153,417689,418183,418675,419224,419701,420193,420654,421102,421580,
0,4,111,807,2762,6310,11320,17779,25240,33483,42348,51506,60803,70234,79333,88488,97419,106240,114729,122968,131131,138998,146654,153775,160928,167694,174311,180498,186539,192324,197951,203419,208596,213581,218378,223038,227443,231735,235926,239909,243837,247530,251120,254579,257880,261161,264241,267322,270217,273099,275870,278446,280917,283384,285815,288177,290418,292633,294759,296886,298966,300883,302782,304610,306296,308055,309721,311331,313007,314532,315961,317422,318775,320132,321422,322752,324037,325290,326488,327589,328748,329815,330903,331902,332917,333948,334994,335931,336875,337786,338688,339536,340392,341180,341990,342745,343498,344205,344917,345617,346301,346957,347602,348244,348856,349427,350009,350565,351122,351664,352224,352773,353284,353805,354277,354763,355257,355696,356164,356569,
0,0,27,243,925,2414,4799,8452,12675,17706,23171,29174,35675,42259,48885,55536,62216,68864,75486,81989,88406,94676,100732,106740,112421,118003,123457,128629,133713,138797,143636,148163,152556,156986,161195,165302,169280,173133,176748,180314,183710,187037,190360,193465,196492,199396,202205,205011,207723,210327,212777,215226,217647,219919,222168,224311,226427,228416,230416,232349,234182,236006,237792,239466,241121,242715,244323,245857,247309,248784,250239,251570,252919,254197,255474,256661,257796,258985,260067,261124,262222,263293,264278,265210,266198,267083,268081,268978,269843,270741,271570,272356,273154,273879,274584,275293,276037,276692,277364,278057,278710,279368,279971,280587,281194,281755,282341,282901,283434,283955,284440,284943,285457,285924,286370,286814,287263,287685,288149,288590,
0,0,3,40,191,620,1460,2723,4586,6921,9862,13124,16744,20650,24648,28868,33174,37581,42122,46640,51249,55704,60162,64550,68845,73062,77216,81179,85086,89011,92657,96431,100064,103496,106854,110042,113254,116384,119394,122377,125134,127875,130582,133300,135921,138357,140812,143137,145415,147703,149828,151951,154000,156005,157923,159785,161643,163487,165216,166938,168523,170126,171650,173151,174557,176009,177383,178764,180059,181317,182544,183749,184988,186180,187323,188413,189465,190500,191508,192476,193431,194400,195304,196206,197087,197963,198811,199659,200485,201232,201994,202814,203597,204282,204976,205664,206324,207004,207633,208230,208837,209444,210017,210539,211116,211659,212158,212651,213132,213634,214135,214616,215054,215514,215963,216381,216769,217179,217586,217983,
0,0,0,0,11,53,216,467,895,1593,2523,3668,5132,6717,8460,10406,12491,14735,17003,19341,21853,24361,26881,29454,31969,34520,37132,39741,42327,44894,47315,49710,52109,54458,56791,59059,61330,63503,65737,67964,70030,72062,74038,75954,77855,79771,81566,83294,85034,86737,88429,90056,91614,93168,94621,96131,97574,98953,100261,101604,102948,104174,105405,106662,107818,108982,110126,111239,112342,113325,114368,115361,116260,117193,118111,118971,119859,120692,121555,122379,123239,124080,124868,125645,126416,127133,127811,128481,129156,129818,130492,131118,131733,132396,132997,133552,134108,134657,135194,135706,136254,136755,137276,137765,138235,138683,139127,139583,140016,140465,140894,141309,141699,142071,142455,142844,143191,143513,143844,144183,
147827,410935,601988,737533,838465,917003,979697,1030906,1074485,1111052,1142498,1170101,1194100,1215578,1234679,1251758,1267380,1281537,1294387,1306244,1317183,1327256,1336730,1345562,1353634,1361238,1368484,1375040,1381321,1387178,1392756,1397889,1402893,1407500,1411772,1415955,1419937,1423716,1427233,1430717,1433939,1436933,1439923,1442788,1445544,1448194,1450664,1452970,1455247,1457528,1459593,1461560,1463426,1465324,1467097,1468803,1470473,1472071,1473657,1475156,1476583,1477996,1479297,1480537,1481693,1482933,1484056,1485144,1486211,1487243,1488258,1489252,1490209,1491094,1491991,1492852,1493651,1494552,1495354,1496103,1496881,1497684,1498370,1499069,1499650,1500267,1500858,1501447,1502057,1502633,1503203,1503782,1504297,1504819,1505361,1505820,1506292,1506730,1507186,1507658,1508110,1508538,1508975,1509411,1509772,1510131,1510497,1510842,1511170,1511522,1511847,1512165,1512478,1512760,1513049,1513354,1513653,1513947,1514226,1514510,
67182,258804,426740,554546,653886,732703,796925,850677,896288,935236,968764,998350,1024554,1047830,1068674,1087374,1104606,1120116,1134384,1147489,1159522,1170672,1181059,1190648,1199581,1207961,1215900,1223131,1230052,1236597,1242727,1248528,1253958,1259158,1263981,1268589,1272987,1277168,1281168,1284961,1288518,1291879,1295040,1298295,1301387,1304213,1307022,1309720,1312282,1314746,1317032,1319267,1321384,1323458,1325496,1327424,1329305,1331049,1332701,1334400,1335986,1337556,1339015,1340410,1341794,1343192,1344498,1345732,1346960,1348114,1349286,1350304,1351389,1352321,1353311,1354270,1355189,1356160,1357034,1357906,1358740,1359565,1360359,1361136,1361881,1362613,1363302,1363977,1364632,1365288,1365902,1366523,1367113,1367689,1368263,1368829,1369404,1369963,1370495,1371003,1371486,1371957,1372398,1372848,1373293,1373707,1374109,1374525,1374906,1375287,1375657,1376033,1376354,1376695,1377053,1377377,1377688,1377954,1378260,1378538,
38426,186588,333919,453595,549553,626717,691018,744920,790834,830802,865411,895949,922995,947004,968583,988125,1005865,1022185,1036923,1050516,1063089,1074917,1085769,1095962,1105241,1113959,1122127,1129835,1137105,1144096,1150487,1156512,1162256,1167743,1172958,1177737,1182326,1186760,1191064,1195031,1198844,1202492,1205967,1209260,1212470,1215509,1218495,1221321,1224040,1226654,1229088,1231464,1233707,1235987,1238183,1240184,1242134,1244010,1245869,1247671,1249389,1250981,1252580,1254179,1255653,1256996,1258407,1259744,1261050,1262293,1263481,1264725,1265919,1267017,1268050,1269087,1270065,1271047,1271968,1272893,1273785,1274670,1275533,1276378,1277130,1277890,1278635,1279349,1280028,1280746,1281425,1282061,1282720,1283342,1283948,1284543,1285129,1285707,1286278,1286809,1287285,1287746,1288259,1288707,1289147,1289572,1290033,1290452,1290880,1291302,1291680,1292068,1292442,1292787,1293138,1293510,1293853,1294193,1294508,1294819,
17654,120029,241484,347654,436557,511201,573729,626614,672043,712235,747574,778558,806220,830752,853060,873194,891551,908452,923930,938252,951253,963317,974541,984942,994853,1004049,1012595,1020790,1028644,1035921,1042702,1049125,1055225,1060953,1066267,1071483,1076419,1081184,1085759,1089848,1093846,1097760,1101523,1105075,1108547,1111824,1114917,1117867,1120648,1123496,1126168,1128691,1131010,1133338,1135632,1137848,1139929,1141940,1143816,1145752,1147484,1149165,1150868,1152485,1154024,1155503,1156981,1158391,1159788,1161127,1162468,1163750,1164966,1166165,1167292,1168350,1169402,1170432,1171496,1172460,1173397,1174296,1175211,1176083,1176894,1177702,1178511,1179314,1180060,1180797,1181483,1182188,1182839,1183507,1184155,1184814,1185376,1185938,1186502,1187056,1187608,1188157,1188677,1189216,1189693,1190139,1190600,1191046,1191482,1191966,1192370,1192756,1193142,1193530,1193904,1194280,1194630,1195006,1195335,1195669,
6021,65577,155114,242351,320320,388002,446928,497841,542314,581280,615867,646701,674586,699754,722095,742351,761161,778281,794312,809021,822475,835006,846668,857408,867656,877367,886351,894848,902867,910386,917532,924135,930498,936604,942383,947687,952893,957817,962648,967010,971144,975339,979148,982883,986575,990023,993334,996512,999512,1002537,1005307,1008012,1010647,1013126,1015553,1017812,1020046,1022162,1024181,1026103,1028031,1029936,1031745,1033482,1035156,1036746,1038349,1039895,1041417,1042896,1044181,1045529,1046829,1048069,1049228,1050451,1051600,1052752,1053848,1054917,1055909,1056913,1057854,1058818,1059755,1060590,1061441,1062245,1063029,1063831,1064610,1065322,1066083,1066816,1067505,1068178,1068846,1069466,1070050,1070617,1071204,1071791,1072332,1072903,1073412,1073920,1074383,1074881,1075335,1075824,1076249,1076697,1077125,1077540,1077950,1078325,1078687,1079079,1079457,1079826,
2925,43548,115118,190768,260687,323692,379205,427664,470547,508769,542664,573061,600445,625482,648032,668463,687242,704585,720544,735233,749087,761842,773697,784797,795131,804876,814012,822582,830700,838337,845704,852519,858986,865192,870946,876570,881823,886954,891875,896603,901077,905267,909155,913006,916696,920308,923723,926946,930077,933127,936082,938825,941484,944058,946577,948997,951334,953544,955674,957679,959699,961526,963383,965210,966967,968678,970338,971912,973415,974880,976273,977588,978996,980297,981529,982758,983998,985195,986325,987378,988361,989432,990434,991406,992325,993262,994142,994965,995801,996630,997413,998205,998934,999659,1000373,1001088,1001754,1002430,1003091,1003714,1004340,1004951,1005570,1006103,1006673,1007160,1007660,1008187,1008674,1009139,1009633,1010098,1010564,1011005,1011395,1011798,1012230,1012614,1013004,1013391,
1218,27072,81206,144025,205322,261644,313066,358347,399113,435632,468040,497664,524421,548917,570958,591253,609864,627389,643442,658687,672512,685320,697377,708585,718938,728673,737861,746586,754830,762590,769924,776844,783446,789747,795641,801257,806645,811941,816829,821568,826053,830334,834409,838369,842133,845599,849030,852405,855710,858860,861950,864805,867605,870278,872755,875251,877617,879978,882151,884279,886238,888198,890050,891902,893688,895424,897083,898688,900271,901747,903145,904533,905969,907314,908619,909844,911036,912251,913430,914570,915617,916715,917730,918714,919710,920618,921504,922360,923199,924046,924854,925646,926432,927201,927940,928696,929403,930064,930708,931402,932058,932683,933295,933864,934414,934986,935514,936042,936533,937030,937484,937989,938491,938927,939356,939765,940170,940600,941004,941410,
385,14443,51802,100221,150605,199698,244968,286083,323797,358018,388954,417166,442574,466306,487828,507958,526497,543515,559419,573961,587667,600449,612435,623744,634235,644111,653402,662297,670504,678328,685909,693049,699767,706192,712155,717788,723221,728368,733308,738106,742746,747135,751259,755320,759120,762821,766401,769836,773151,776284,779370,782289,785015,787704,790290,792707,795168,797431,799666,801865,803880,805837,807854,809791,811660,813476,815241,816927,818551,820146,821660,823094,824583,825902,827291,828563,829772,830985,832243,833413,834512,835577,836634,837681,838704,839661,840586,841493,842393,843252,844082,844874,845709,846544,847341,848041,848767,849486,850191,850814,851504,852139,852772,853378,853933,854514,855094,855642,856143,856658,857140,857630,858127,858565,859029,859490,859889,860334,860747,861168,
92,6491,29288,62992,102064,142015,180271,215887,249291,280198,308520,334450,358662,380823,401432,420628,438355,454627,470009,484523,497835,510382,522118,533112,543651,553474,562675,571374,579747,587576,594837,601867,608726,615160,621137,627013,632488,637740,642739,647560,652111,656563,660860,665027,668817,672453,676092,679576,682870,686037,689090,692097,694977,697780,700404,702958,705408,707843,710166,712400,714571,716618,718594,720561,722404,724220,725991,727650,729320,730870,732430,733869,735301,736698,738105,739473,740742,742072,743237,744453,745574,746679,747769,748831,749823,750813,751771,752728,753655,754603,755460,756347,757162,758013,758765,759514,760251,760963,761666,762361,763009,763659,764348,764970,765538,766167,766742,767319,767835,768356,768855,769368,769901,770378,770823,771324,771776,772207,772625,773071,
29,3448,18707,44691,76247,110024,143632,175585,206078,234352,260795,285310,307952,329281,348948,367042,384010,399878,414919,428849,441903,454165,465579,476522,486760,496335,505406,514061,522365,529971,537367,544274,550923,557297,563239,568980,574434,579722,584775,589615,594237,598715,602995,607068,611005,614613,618256,621643,624879,627982,631069,634036,636835,639715,642524,645055,647497,649948,652323,654531,656667,658785,660857,662770,664683,666494,668255,669937,671582,673144,674764,676235,677757,679164,680587,681917,683275,684542,685721,686913,688076,689184,690268,691313,692318,693334,694332,695298,696224,697126,697987,698821,699630,700461,701259,702061,702825,703587,704307,705010,705663,706292,706980,707583,708181,708767,709317,709895,710464,710983,711505,712006,712518,713044,713518,713989,714471,714917,715357,715800,
7,1683,11246,29598,53995,81590,109678,137288,163884,189467,213651,236288,257386,277071,295460,312652,328573,343800,358028,371286,383919,395830,406873,417338,427084,436452,445268,453671,461602,469137,476313,483186,489726,496072,502041,507807,513226,518321,523389,528130,532682,537105,541343,545303,549148,552765,556371,559767,563045,566199,569258,572203,575118,577926,580601,583187,585620,588020,590361,592636,594817,596876,598924,600859,602702,604531,606306,608036,609707,611403,612953,614506,615982,617463,618856,620139,621475,622769,623980,625144,626355,627455,628524,629637,630725,631706,632694,633674,634685,635606,636470,637323,638141,638916,639754,640524,641275,642003,642734,643522,644182,644822,645455,646110,646713,647264,647861,648460,649004,649563,650104,650622,651129,651635,652140,652617,653107,653563,653998,654418,
2,704,5925,17895,35422,56295,78871,101721,124016,146123,167229,187231,206127,223880,240662,256499,271294,285428,298765,311390,323473,334743,345467,355570,365090,374159,382613,390672,398373,405840,412846,419464,425828,431944,437746,443304,448761,453797,458757,463428,467882,472240,476426,480445,484284,487907,491495,494965,498261,501439,504413,507497,510299,513106,515724,518330,520850,523197,525538,527805,529845,531906,534029,536016,537917,539740,541479,543301,545018,546601,548181,549783,551267,552672,554073,555381,556734,557957,559178,560447,561655,562759,563871,564915,565964,567030,568002,568957,569959,570891,571744,572661,573464,574334,575156,575922,576709,577406,578138,578867,579579,580271,580909,581534,582157,582802,583410,584008,584581,585110,585671,586175,586684,587167,587696,588179,588591,589065,589524,589986,
0,229,2673,9433,20608,35182,51908,69690,87441,105523,123216,140343,156824,172482,187401,201800,215101,227930,239956,251434,262449,273044,282869,292449,301271,309762,317980,325687,333019,339980,346766,353162,359250,365171,370739,376151,381387,386243,390998,395553,399915,404147,408203,412086,415790,419302,422851,426116,429348,432392,435465,438298,441098,443835,446560,449087,451480,453680,455950,458153,460380,462411,464396,466343,468268,470111,471852,473505,475147,476782,478350,479893,481409,482796,484172,485559,486896,488127,489414,490618,491781,492897,494043,495115,496163,497188,498129,499035,499969,500852,501731,502545,503397,504270,505046,505887,506681,507416,508196,508867,509568,510221,510820,511462,512094,512691,513314,513895,514470,515034,515577,516090,516617,517138,517656,518129,518597,519060,519522,519984,
0,54,905,4030,10111,18951,29982,42348,55494,69153,82963,96727,110105,122948,135367,147296,158995,170011,180700,190854,200781,209931,218889,227380,235485,243310,250641,257913,264852,271408,277654,283598,289336,294756,299831,304901,309773,314613,319131,323426,327523,331448,335354,339090,342721,346146,349541,352845,355981,358926,361742,364590,367248,369886,372384,374811,377214,379549,381687,383934,386114,388081,389969,391902,393750,395567,397383,399109,400777,402295,403814,405287,406813,408175,409509,410914,412299,413539,414768,415926,417015,418108,419207,420269,421259,422264,423244,424233,425161,426131,426996,427893,428695,429530,430293,431081,431840,432562,433232,433911,434569,435206,435821,436479,437077,437737,438334,438915,439495,440032,440568,441078,441536,442029,442517,442971,443416,443837,444302,444715,
0,14,302,1589,4774,9842,16472,24677,33914,43947,54347,64888,75457,85935,96294,106168,115824,125248,134327,143262,151740,159857,167821,175398,182730,189656,196323,202845,209167,215136,220811,226167,231405,236585,241403,246029,250595,254959,259048,263102,266932,270599,274314,277831,281212,284464,287665,290784,293741,296567,299214,301863,304371,306831,309143,311522,313746,315958,318077,320215,322237,324089,325935,327729,329523,331288,333005,334639,336232,337722,339222,340658,342059,343382,344649,345983,347263,348527,349639,350771,351912,353016,354039,355094,356115,357068,358055,358990,359910,360761,361659,362562,363449,364223,364925,365697,366377,367095,367777,368458,369117,369775,370437,371041,371629,372196,372731,373279,373835,374417,374931,375420,375918,376416,376894,377385,377811,378186,378595,379019,
0,0,64,474,1673,4031,7519,12141,17758,24119,31016,38283,45840,53456,61165,68797,76254,83617,90743,97804,104722,111469,117934,124295,130405,136423,142213,147640,152851,157988,162992,167760,172380,176916,181221,185400,189478,193430,197255,200804,204204,207601,210822,213881,217018,220074,222917,225729,228388,230982,233475,235837,238261,240629,242887,245027,247135,249148,251126,252990,254849,256653,258394,260092,261707,263353,264863,266424,267934,269367,270697,272042,273397,274660,275890,277071,278273,279440,280591,281674,282726,283724,284748,285710,286646,287568,288473,289404,290275,291100,291940,292769,293571,294340,295055,295767,296487,297164,297883,298564,299203,299809,300399,300991,301545,302073,302565,303105,303669,304191,304686,305200,305704,306192,306663,307108,307560,307997,308415,308833,
0,0,4,68,350,1026,2315,4263,6852,10010,13772,18061,22645,27360,32130,37074,42221,47414,52605,57724,62751,67630,72486,77277,81966,86507,90898,95232,99556,103586,107650,111624,115348,119007,122517,125903,129280,132674,135823,138803,141766,144594,147308,150003,152712,155325,157792,160148,162408,164714,167013,169060,171199,173214,175186,177067,178970,180756,182455,184132,185775,187348,188890,190356,191922,193377,194819,196192,197531,198860,200115,201346,202547,203747,204888,205984,207054,208064,209110,210118,211101,212082,213025,213998,214901,215734,216593,217417,218237,219011,219783,220476,221210,221913,222599,223292,223963,224654,225262,225884,226511,227080,227656,228213,228757,229313,229816,230352,230819,231295,231774,232257,232687,233114,233558,234013,234431,234868,235245,235660,
0,0,0,6,26,138,400,847,1531,2598,3929,5539,7387,9430,11704,14154,16788,19425,22245,25068,27944,30858,33787,36800,39647,42521,45327,48159,50976,53834,56532,59247,61790,64395,66989,69435,71909,74271,76572,78831,81122,83326,85431,87427,89319,91278,93187,95092,96904,98651,100349,101972,103669,105262,106791,108265,109679,111102,112524,113914,115271,116592,117874,119137,120335,121519,122686,123843,124961,125989,127030,128042,129029,129988,130952,131832,132769,133704,134583,135444,136291,137107,137859,138623,139395,140115,140799,141477,142185,142869,143517,144177,144790,145412,146048,146642,147202,147806,148343,148909,149386,149899,150404,150900,151375,151858,152298,152727,153193,153631,154037,154473,154888,155294,155695,156050,156436,156796,157152,157498,
15998,153961,340230,508531,650287,768766,867558,950892,1021905,1082728,1135052,1180766,1221001,1256642,1288257,1316678,1342192,1365070,1385848,1404756,1422057,1438164,1452644,1466339,1478756,1490143,1500671,1510510,1519588,1527956,1535947,1543432,1550270,1556785,1562713,1568369,1573789,1578745,1583556,1588064,1592279,1596278,1600064,1603549,1606879,1610131,1613187,1616105,1618875,1621440,1623896,1626196,1628494,1630664,1632708,1634739,1636650,1638460,1640226,1641843,1643447,1644972,1646394,1647771,1649138,1650468,1651694,1652880,1654015,1655126,1656151,1657243,1658181,1659139,1660022,1660852,1661694,1662515,1663279,1664017,1664711,1665380,1666035,1666648,1667269,1667835,1668412,1668967,1669511,1670066,1670571,1671076,1671589,1672042,1672511,1672939,1673352,1673788,1674187,1674554,1674948,1675298,1675662,1676024,1676349,1676660,1676993,1677303,1677580,1677845,1678132,1678379,1678626,1678865,1679100,1679275,1679495,1679754,1679949,1680151,
1031,36618,125055,231743,337891,435509,523233,600197,668776,729547,783394,831367,874370,912718,947141,978368,1007061,1033053,1056443,1077813,1097810,1115828,1132713,1148145,1162611,1175895,1188178,1199793,1210597,1220686,1229915,1238703,1246834,1254694,1262099,1269088,1275593,1281781,1287519,1293078,1298263,1303127,1307785,1312319,1316532,1320458,1324245,1327879,1331375,1334542,1337548,1340420,1343278,1345913,1348451,1350912,1353271,1355565,1357662,1359789,1361780,1363725,1365587,1367311,1368990,1370578,1372135,1373621,1375033,1376386,1377696,1378972,1380232,1381398,1382565,1383673,1384710,1385734,1386743,1387714,1388616,1389479,1390323,1391170,1391960,1392759,1393476,1394211,1394933,1395596,1396234,1396886,1397508,1398087,1398684,1399209,1399744,1400263,1400755,1401227,1401703,1402157,1402603,1403041,1403485,1403892,1404283,1404685,1405063,1405421,1405747,1406041,1406363,1406670,1406962,1407267,1407556,1407830,1408090,1408372,
113,11499,55931,123282,199756,275982,348688,415928,476817,532417,582941,628542,669453,706614,740948,772025,800388,826404,850588,872699,892870,911955,929513,945718,960810,974782,988019,1000311,1011750,1022440,1032488,1041837,1050687,1059085,1066888,1074367,1081181,1087801,1094119,1099967,1105639,1111010,1116077,1120974,1125522,1129860,1134013,1138025,1141758,1145295,1148734,1152038,1155106,1158019,1160850,1163665,1166237,1168731,1171142,1173389,1175504,1177556,1179604,1181473,1183337,1185114,1186897,1188576,1190174,1191661,1193121,1194529,1195820,1197134,1198410,1199650,1200845,1202031,1203075,1204092,1205110,1206030,1207007,1207943,1208825,1209742,1210588,1211365,1212133,1212854,1213525,1214222,1214887,1215563,1216223,1216824,1217417,1217956,1218495,1219051,1219585,1220117,1220598,1221075,1221554,1222017,1222433,1222865,1223299,1223703,1224114,1224466,1224830,1225196,1225523,1225832,1226183,1226492,1226810,1227097,
3,2291,18118,51253,96096,146781,198672,249677,298795,344964,387855,427492,464293,498341,529632,558346,585411,610444,633427,654939,674892,693381,710462,726500,741520,755596,768895,781115,792848,803821,813797,823578,832546,841202,849395,857161,864413,871284,877723,883928,889891,895429,900854,905970,910917,915475,919912,924106,928089,931820,935379,938773,942030,945142,948227,951076,953820,956490,959091,961590,964014,966263,968509,970547,972530,974434,976249,978031,979699,981358,982959,984483,985902,987383,988720,990087,991398,992653,993806,994935,996051,997088,998139,999169,1000122,1000997,1001909,1002878,1003714,1004564,1005408,1006200,1006926,1007637,1008364,1009022,1009662,1010289,1010954,1011519,1012059,1012583,1013118,1013643,1014170,1014624,1015089,1015523,1015963,1016426,1016868,1017267,1017652,1018037,1018444,1018784,1019156,1019486,1019828,1020147,
0,275,3892,14998,34794,61112,91470,123770,156847,189634,221739,252153,281520,308948,334890,359373,382328,403852,424167,443286,461249,478105,493753,508685,522863,536167,548567,560246,571446,581871,591841,601222,610196,618813,626681,634210,641436,648296,654803,660953,666778,672454,677677,682688,687512,692134,696484,700692,704823,708728,712485,715983,719353,722541,725681,728628,731511,734289,736962,739421,741824,744046,746310,748465,750537,752541,754520,756419,758260,759937,761652,763266,764789,766255,767713,769123,770487,771817,773087,774302,775414,776502,777541,778604,779623,780615,781566,782498,783338,784176,785062,785874,786665,787398,788188,788871,789575,790223,790880,791537,792099,792720,793304,793860,794385,794908,795395,795906,796375,796853,797324,797755,798204,798650,799044,799427,799800,800202,800544,800900,
0,58,1417,7047,18538,35405,56349,79836,105042,130885,156679,181896,206210,229521,252094,273534,293870,313065,331069,348572,365019,380605,395302,408980,422182,434590,446320,457448,468066,477933,487304,496164,504449,512470,520210,527336,534401,541045,547436,553282,558892,564361,569478,574534,579249,583762,588081,592201,596233,600113,603730,607197,610574,613801,616908,619920,622714,625490,628167,630647,633026,635357,637631,639799,641916,643909,645924,647782,649566,651280,652903,654495,656002,657535,658972,660366,661720,662983,664219,665439,666664,667795,668882,669938,670969,671980,672923,673820,674696,675548,676458,677300,678042,678861,679649,680382,681131,681814,682429,683051,683674,684295,684860,685394,685964,686506,687035,687545,688039,688546,689008,689450,689885,690288,690683,691113,691474,691834,692202,692584,
0,10,450,2882,8759,18441,31716,47823,65391,84289,103813,123515,143099,162238,180725,198739,215998,232617,248511,263544,278018,291785,304884,317426,329217,340438,351243,361370,371089,380306,388875,396957,404775,412395,419755,426709,433197,439316,445201,450795,456264,461587,466508,471258,475782,480126,484363,488443,492373,496031,499573,503021,506224,509396,512431,515324,518201,520859,523368,525792,528197,530518,532823,534976,537053,538982,540857,542718,544516,546231,547862,549467,550952,552403,553825,555237,556528,557818,559095,560348,561488,562598,563679,564734,565734,566736,567673,568607,569494,570359,571158,571968,572699,573513,574248,574997,575728,576442,577070,577745,578417,579006,579581,580191,580746,581271,581814,582326,582801,583294,583779,584251,584692,585132,585532,585950,586340,586689,587044,587404,
0,1,106,938,3605,8540,16090,25846,37616,50379,64192,78609,93402,108240,122856,137372,151444,165026,178140,190742,202913,214595,225723,236640,246874,256669,265919,274947,283600,291868,299851,307457,314944,321800,328453,334802,340708,346461,352047,357380,362382,367173,371860,376294,380639,384875,388794,392621,396175,399697,403065,406322,409411,412429,415219,418018,420644,423274,425690,428014,430329,432520,434663,436640,438541,440421,442380,444225,445871,447464,449106,450644,452123,453539,454957,456267,457606,458811,460045,461262,462387,463504,464601,465644,466683,467667,468625,469625,470511,471348,472120,472929,473685,474399,475144,475826,476520,477166,477826,478488,479136,479750,480318,480856,481380,481892,482401,482889,483397,483864,484320,484744,485162,485569,485968,486367,486731,487109,487468,487821,
0,0,20,270,1228,3451,7161,12515,19418,27582,36608,46349,56751,67260,77964,88733,99259,109873,120342,130553,140441,149767,158970,167760,176516,185011,192922,200645,208254,215446,222242,228851,235092,241115,246977,252604,257997,263210,268252,272934,277481,281971,286195,290252,294158,297913,301330,304749,308213,311409,314468,317420,320309,323054,325745,328380,330912,333220,335514,337665,339853,341945,343907,345827,347724,349443,351162,352834,354463,355958,357402,358872,360296,361626,362946,364189,365460,366699,367852,368991,370104,371181,372223,373188,374154,375127,376040,376890,377738,378563,379347,380136,380849,381652,382404,383098,383731,384399,385022,385667,386285,386924,387457,388006,388527,389053,389563,390058,390569,391101,391557,391969,392405,392796,393193,393543,393904,394278,394622,395002,
0,1,11,114,636,1870,4290,7846,12524,18275,24870,32240,40114,48510,57121,65820,74523,83281,92158,100619,109081,117381,125368,133274,140995,148455,155537,162598,169116,175560,181690,187521,193276,198793,204008,209184,214140,218914,223545,227932,232077,236241,240187,243972,247647,251115,254457,257687,260770,263727,266666,269521,272161,274701,277157,279596,281981,284211,286379,288456,290503,292464,294347,296243,297989,299721,301393,303020,304593,306085,307494,308858,310235,311532,312800,313986,315161,316280,317408,318474,319558,320573,321509,322514,323442,324359,325224,326073,326901,327691,328479,329244,329912,330635,331305,331948,332562,333192,333841,334420,334981,335588,336141,336697,337198,337667,338153,338660,339108,339518,339945,340383,340838,341225,341578,342001,342353,342751,343092,343434,
0,0,2,46,246,914,2169,4268,7297,11146,15813,21116,27134,33547,40114,46847,53857,60896,68038,75191,82186,89024,95790,102454,108999,115352,121609,127695,133481,139032,144486,149931,155067,159883,164524,169166,173528,177795,181924,185797,189656,193347,196869,200436,203706,206959,210066,213099,216046,218896,221543,224141,226712,229149,231480,233750,235938,238040,240081,242044,244019,245911,247626,249299,250882,252521,254047,255585,257011,258468,259812,261094,262395,263660,264830,266050,267189,268324,269399,270452,271459,272384,273297,274205,275088,275916,276747,277594,278353,279112,279831,280576,281321,281997,282632,283278,283917,284511,285059,285692,286263,286805,287333,287865,288326,288822,289296,289756,290194,290613,291021,291427,291853,292265,292671,293030,293386,293738,294060,294381,
0,0,1,12,79,384,1068,2295,4109,6509,9619,13343,17530,22126,26910,31999,37221,42708,48390,54136,59763,65246,70832,76262,81720,86963,92252,97313,102252,107093,111836,116400,120835,125153,129345,133305,137160,141000,144656,148198,151528,154757,157913,161082,164112,167027,169865,172569,175253,177883,180273,182684,184996,187246,189349,191415,193439,195320,197189,198976,200750,202529,204133,205753,207348,208831,210231,211603,212985,214287,215581,216861,218034,219177,220271,221350,222404,223526,224566,225530,226440,227416,228322,229162,229961,230808,231579,232341,233080,233827,234476,235107,235763,236398,236998,237622,238215,238773,239305,239857,240416,240952,241467,241949,242427,242855,243307,243772,244185,244609,244993,245405,245762,246123,246463,246803,247158,247526,247852,248175,
0,0,0,0,24,133,430,1009,1961,3445,5259,7541,10205,13150,16580,20271,24141,28136,32387,36566,40983,45324,49736,54013,58342,62597,66785,70919,75014,78959,82775,86589,90339,94054,97544,101010,104273,107518,110738,113824,116775,119653,122398,125150,127795,130296,132762,135176,137523,139774,141969,144044,146037,148038,149965,151793,153657,155377,157068,158687,160186,161761,163292,164731,166120,167535,168899,170199,171446,172666,173866,174963,176070,177085,178152,179206,180165,181108,181998,182932,183780,184584,185395,186164,186895,187644,188352,189044,189738,190390,191043,191671,192326,192899,193457,194000,194555,195082,195572,196097,196578,197040,197527,197978,198434,198894,199362,199790,200192,200582,200935,201332,201702,202057,202427,202753,203060,203378,203692,203982,
0,0,0,0,11,43,155,420,910,1621,2648,3933,5541,7472,9686,12134,14643,17448,20307,23515,26561,29837,33103,36364,39687,42908,46222,49477,52707,55877,58926,61966,64892,67795,70677,73535,76335,79035,81660,84189,86631,89064,91344,93620,95872,98111,100254,102363,104431,106427,108261,110088,111860,113643,115229,116860,118496,119953,121486,122970,124347,125729,127081,128353,129526,130795,132040,133154,134249,135357,136419,137514,138524,139445,140331,141181,142055,142911,143752,144608,145406,146135,146872,147590,148316,148998,149698,150371,151027,151641,152233,152792,153350,153866,154399,154938,155470,155966,156459,156979,157436,157888,158325,158747,159148,159562,159949,160339,160684,161007,161376,161709,162008,162312,162622,162904,163228,163557,163857,164129,
0,0,0,0,2,15,57,178,370,703,1234,1918,2841,3888,5201,6736,8399,10217,12218,14323,16658,18996,21371,23762,26213,28720,31116,33610,36090,38587,41099,43502,45947,48316,50576,52823,55040,57209,59319,61453,63587,65641,67567,69487,71425,73303,75052,76696,78487,80167,81793,83340,84929,86423,87879,89283,90637,91933,93172,94373,95619,96812,98004,99175,100259,101324,102316,103372,104392,105349,106199,107082,107963,108827,109631,110448,111244,111988,112769,113533,114229,114913,115582,116219,116860,117514,118100,118671,119241,119797,120292,120831,121350,121857,122377,122860,123279,123720,124157,124592,125001,125398,125799,126188,126567,126922,127268,127617,127954,128272,128610,128937,129238,129505,129810,130104,130367,130661,130915,131183,
0,0,0,0,0,2,14,49,144,279,498,844,1304,1890,2633,3521,4591,5732,6961,8367,9813,11339,12934,14542,16233,17953,19650,21350,23174,24932,26636,28350,30207,32054,33850,35570,37307,38985,40692,42333,43953,45589,47143,48712,50176,51644,53154,54581,55979,57374,58729,60068,61345,62593,63803,64973,66139,67242,68327,69388,70344,71379,72363,73340,74243,75123,76000,76830,77704,78460,79321,80090,80804,81513,82296,82999,83680,84351,84998,85648,86255,86847,87439,88018,88581,89127,89652,90160,90619,91112,91574,92020,92449,92909,93367,93748,94169,94544,94908,95263,95626,95980,96308,96600,96935,97278,97599,97893,98169,98470,98768,99042,99316,99564,99802,100045,100286,100526,100759,101003,
0,0,0,0,0,0,5,11,30,65,147,272,449,682,1020,1406,1898,2457,3122,3835,4630,5489,6375,7353,8374,9384,10490,11658,12814,14006,15164,16373,17583,18819,20080,21272,22512,23705,24857,26067,27242,28409,29545,30642,31766,32809,33856,34923,35941,36916,37884,38846,39749,40633,41577,42449,43301,44193,45087,45913,46758,47539,48322,49101,49820,50503,51203,51910,52604,53237,53916,54555,55227,55792,56346,56924,57432,58028,58542,59071,59567,60029,60496,60982,61445,61948,62372,62795,63205,63625,64034,64442,64835,65192,65543,65861,66222,66559,66887,67208,67510,67831,68129,68414,68697,68984,69266,69534,69762,70005,70247,70503,70719,70938,71159,71395,71622,71825,72061,72266,
0,0,0,0,0,0,0,1,2,11,29,53,89,146,232,373,521,753,996,1313,1603,1965,2330,2759,3235,3706,4306,4885,5434,6011,6610,7279,7896,8586,9194,9897,10588,11293,11971,12659,13380,14095,14808,15498,16210,16895,17525,18213,18885,19564,20258,20915,21555,22206,22781,23360,23942,24548,25100,25683,26283,26835,27383,27928,28453,28961,29447,29967,30471,30963,31426,31883,32319,32754,33174,33582,33956,34368,34753,35139,35499,35868,36216,36556,36940,37258,37608,37932,38257,38549,38860,39126,39418,39682,39936,40220,40495,40755,41017,41301,41535,41806,42010,42217,42444,42670,42867,43081,43279,43488,43681,43869,44032,44187,44360,44546,44716,44873,45051,45194,
40347,231790,430624,591015,719034,821905,905819,975261,1033866,1083626,1126722,1164129,1196767,1225190,1250491,1273349,1293796,1311978,1328627,1343755,1357707,1370695,1382514,1393239,1403284,1412602,1421297,1429319,1436734,1443759,1450190,1456360,1461987,1467331,1472304,1476935,1481333,1485562,1489433,1493105,1496651,1499979,1503100,1506120,1509049,1511728,1514341,1516864,1519209,1521455,1523624,1525630,1527505,1529403,1531222,1532872,1534484,1536023,1537485,1538878,1540253,1541584,1542841,1544039,1545241,1546344,1547452,1548439,1549466,1550488,1551459,1552343,1553214,1553984,1554762,1555519,1556240,1556975,1557656,1558296,1558917,1559578,1560153,1560735,1561255,1561798,1562297,1562824,1563327,1563787,1564290,1564707,1565102,1565513,1565912,1566295,1566672,1567041,1567382,1567742,1568070,1568395,1568694,1569002,1569303,1569590,1569863,1570119,1570380,1570614,1570860,1571081,1571321,1571560,1571806,1572026,1572236,1572433,1572586,1572780,
7161,90612,219646,345793,456227,550832,631445,700473,759611,811452,856406,895942,930914,962012,990042,1015034,1037683,1058264,1076861,1094001,1109609,1123787,1136936,1149312,1160691,1171235,1180973,1190170,1198781,1206779,1214128,1221152,1227793,1234054,1239918,1245455,1250592,1255406,1260001,1264462,1268472,1272342,1275986,1279529,1282888,1286003,1289005,1291930,1294716,1297385,1299941,1302361,1304676,1306796,1308812,1310887,1312846,1314669,1316422,1318152,1319770,1321261,1322822,1324259,1325659,1326927,1328192,1329468,1330652,1331795,1332830,1333859,1334927,1335962,1336905,1337804,1338671,1339537,1340340,1341076,1341876,1342583,1343268,1343936,1344578,1345179,1345795,1346409,1346977,1347510,1348050,1348567,1349126,1349638,1350105,1350585,1351040,1351442,1351908,1352287,1352683,1353034,1353416,1353769,1354079,1354406,1354753,1355082,1355425,1355734,1356023,1356306,1356561,1356821,1357061,1357307,1357574,1357804,1358018,1358257,
1977,44343,132120,230676,323694,408014,481918,546992,603762,653816,698208,737787,772798,804104,832530,858066,881143,902445,921631,939256,955496,970420,984373,997165,1009161,1020339,1030793,1040375,1049473,1057891,1065901,1073467,1080371,1086951,1093070,1098844,1104421,1109773,1114752,1119500,1124023,1128170,1132135,1135868,1139584,1142963,1146184,1149336,1152422,1155290,1158000,1160601,1163045,1165389,1167649,1169891,1172024,1173988,1175922,1177771,1179552,1181253,1182814,1184466,1186002,1187443,1188822,1190187,1191451,1192702,1193896,1195022,1196134,1197199,1198223,1199236,1200218,1201139,1202049,1202895,1203701,1204509,1205303,1206057,1206754,1207459,1208147,1208815,1209423,1210043,1210628,1211183,1211754,1212310,1212809,1213318,1213842,1214309,1214775,1215185,1215592,1216012,1216420,1216768,1217151,1217493,1217827,1218148,1218470,1218794,1219096,1219398,1219694,1220017,1220304,1220545,1220815,1221035,1221274,1221522,
282,16714,66199,133216,204096,271909,335068,391883,443651,490182,531632,569327,603161,633901,661915,686877,710143,731721,751151,769070,785603,801038,815336,828568,840897,852301,862721,872714,882030,890921,899270,907063,914305,921393,927851,934053,939985,945506,950779,955791,960387,964730,968922,972966,976878,980559,984010,987391,990503,993644,996621,999379,1002042,1004575,1006981,1009351,1011563,1013619,1015717,1017686,1019577,1021336,1023107,1024807,1026465,1028005,1029558,1031048,1032469,1033762,1034981,1036191,1037380,1038528,1039631,1040691,1041750,1042750,1043652,1044565,1045473,1046388,1047165,1047984,1048729,1049484,1050226,1050857,1051540,1052219,1052849,1053461,1054086,1054705,1055228,1055804,1056357,1056883,1057399,1057841,1058304,1058760,1059193,1059645,1060074,1060481,1060909,1061305,1061636,1062013,1062333,1062671,1062997,1063329,1063639,1063939,1064255,1064543,1064827,1065086,
23,4443,25584,62251,107816,155882,203599,249091,291854,331351,367909,401205,431823,459937,485769,509554,531622,551845,570520,588159,604415,619660,633753,646734,659103,670509,681359,691400,700846,709737,718185,726174,733580,740564,747303,753665,759749,765302,770677,775735,780565,785332,789663,793833,797762,801568,805310,808753,811988,815222,818272,821124,823932,826496,829075,831568,833937,836152,838282,840330,842314,844228,846114,847877,849610,851221,852818,854267,855774,857213,858549,859893,861130,862403,863587,864741,865830,866881,867878,868917,869877,870797,871693,872536,873344,874184,874979,875696,876408,877128,877812,878520,879160,879775,880364,880927,881486,882020,882546,883069,883598,884074,884513,884991,885450,885894,886319,886713,887103,887496,887885,888252,888605,888949,889251,889597,889942,890287,890600,890874,
4,1760,13673,37877,71163,108837,147544,185688,222590,257523,290089,320415,348605,374691,398670,421430,442165,461167,479305,496093,511991,526347,539851,552681,564668,575793,586409,596453,605835,614580,622779,630674,638204,645211,651956,658234,664158,669793,675070,680123,685023,689723,694146,698386,702524,706288,709866,713408,716788,719930,722952,725859,728645,731377,733994,736502,738967,741308,743448,745620,747599,749523,751377,753231,754871,756627,758227,759858,761377,762820,764232,765587,766842,768091,769279,770503,771660,772688,773762,774744,775722,776707,777598,778458,779287,780155,780967,781742,782454,783243,783942,784642,785344,785994,786591,787147,787749,788334,788880,789368,789884,790402,790853,791333,791824,792258,792686,793105,793495,793907,794320,794688,795041,795379,795732,796066,796387,796715,796997,797287,
0,590,6462,21169,43732,71266,101040,132019,162728,192083,220100,246934,271945,295566,317483,337760,357068,375192,391763,407673,422506,436224,449198,461392,473045,483854,493899,503381,512396,520999,529046,536611,543980,550880,557410,563441,569367,574877,580295,585315,590075,594762,599210,603378,607304,611004,614657,618072,621355,624654,627605,630508,633367,636061,638604,641009,643299,645528,647774,649919,652000,653942,655772,657599,659413,661138,662749,664355,665868,667321,668712,670105,671427,672616,673817,674988,676170,677291,678367,679415,680398,681365,682297,683197,684069,684973,685769,686555,687348,688071,688799,689490,690129,690796,691433,692047,692612,693207,693760,694283,694798,695304,695789,696251,696694,697122,697581,698017,698439,698842,699262,699643,700016,700396,700767,701088,701399,701744,702049,702347,
0,188,2603,10363,23962,42433,63896,86829,110515,134192,157417,179599,200992,221255,240567,258513,275735,291721,306990,321515,334971,347624,359752,371044,381919,392125,401680,410761,419341,427528,435209,442422,449383,456063,462527,468410,474232,479622,484815,489747,494447,498920,503215,507263,511162,514853,518358,521767,525066,528175,531128,533899,536616,539314,541817,544215,546545,548748,550966,553108,555139,557092,558967,560759,562422,564113,565756,567205,568706,570151,571654,573005,574299,575579,576835,578007,579122,580196,581273,582342,583360,584393,585273,586195,587065,587930,588762,589536,590285,591084,591829,592510,593190,593855,594504,595112,595685,596242,596819,597401,597949,598464,598993,599491,599946,600385,600838,601269,601713,602134,602527,602895,603267,603611,603958,604327,604642,604987,605298,605591,
0,31,880,4293,11679,22637,36395,52334,69469,86951,104682,122141,139144,155853,171875,187139,201771,215838,229202,241771,253812,265182,276140,285961,295652,304916,313719,322081,330060,337648,344813,351708,358275,364502,370373,376105,381453,386654,391433,396067,400607,404849,408903,412799,416569,420119,423558,426858,429991,433060,435966,438779,441483,444099,446592,449006,451256,453459,455495,457510,459436,461397,463225,465005,466632,468356,469930,471529,473002,474401,475753,477097,478367,479582,480814,482044,483208,484288,485370,486413,487368,488305,489207,490110,491005,491879,492720,493502,494299,495067,495818,496474,497184,497818,498410,499032,499623,500193,500746,501309,501847,502355,502877,503372,503849,504279,504746,505168,505598,506003,506389,506785,507207,507580,507956,508278,508591,508888,509210,509476,
0,10,415,2295,6835,14214,23978,35959,49054,63173,77600,92294,107093,121158,135104,148482,161443,173878,185933,197395,208302,218499,228478,237920,246860,255426,263742,271569,279104,286292,292992,299321,305491,311402,317108,322377,327499,332368,337051,341552,345766,349786,353697,357370,361043,364405,367685,370914,373993,376848,379609,382397,385003,387435,389836,392156,394319,396411,398460,400402,402274,404184,405975,407775,409425,411056,412648,414195,415553,416935,418226,419553,420795,422035,423146,424338,425469,426536,427613,428617,429617,430533,431413,432338,433152,433985,434769,435538,436307,437068,437784,438491,439146,439760,440377,440985,441528,442112,442669,443210,443733,444267,444753,445244,445690,446145,446594,446986,447389,447808,448194,448601,448996,449385,449734,450112,450446,450749,451053,451345,
0,4,153,1148,3654,8324,15130,23810,33858,44720,56279,68198,80184,92020,103677,115194,126297,137195,147590,157381,167005,176372,185108,193642,201903,209744,217228,224422,231413,237944,244209,250223,255960,261427,266555,271590,276286,280905,285316,289507,293562,297428,301119,304680,308030,311400,314528,317534,320489,323310,325999,328576,331068,333477,335722,337992,340089,342096,344192,346093,347936,349725,351455,353130,354692,356311,357833,359325,360731,362078,363369,364606,365860,367104,368257,369377,370461,371562,372641,373582,374487,375352,376280,377163,377972,378824,379633,380406,381135,381851,382575,383253,383908,384521,385163,385773,386401,386961,387504,388025,388567,389034,389510,389972,390443,390863,391299,391719,392109,392498,392888,393251,393674,394050,394407,394738,395060,395393,395698,395992,
0,0,59,455,1830,4517,8714,14305,21264,29336,37855,46889,56336,65841,75245,84703,93999,103020,111962,120527,128954,137124,144851,152257,159552,166575,173326,179809,186059,191916,197446,202950,208158,213098,217826,222498,226921,231231,235329,239328,243010,246549,250059,253415,256659,259835,262786,265632,268358,270974,273425,275861,278184,280454,282623,284735,286828,288757,290669,292438,294313,296033,297630,299210,300777,302259,303704,305012,306405,307708,308961,310179,311337,312487,313618,314617,315639,316673,317655,318608,319507,320393,321265,322052,322864,323667,324470,325207,325928,326619,327327,328006,328626,329277,329834,330403,330981,331503,332033,332583,333061,333563,334051,334489,334933,335379,335794,336211,336622,337002,337392,337707,338099,338466,338836,339131,339447,339754,340090,340394,
0,0,13,171,747,2120,4592,8029,12460,17772,23707,30186,36912,44029,51353,58824,66183,73662,80927,87977,95084,101760,108343,114674,120829,126825,132644,138224,143718,148961,154030,158832,163494,167857,172036,176182,180137,183933,187656,191158,194554,197877,201110,204124,207036,209889,212485,215072,217629,220075,222344,224637,226825,228915,230919,232915,234924,236745,238488,240190,241765,243302,244872,246392,247824,249217,250556,251887,253142,254373,255531,256693,257845,258900,259911,260925,261932,262939,263868,264727,265609,266457,267316,268142,268913,269645,270330,271025,271710,272410,273074,273699,274291,274890,275468,275997,276550,277071,277564,278075,278565,279037,279495,279983,280357,280766,281150,281506,281915,282263,282610,282962,283302,283632,283976,284297,284588,284914,285191,285453,
0,0,1,35,244,785,1916,3731,6337,9553,13388,17708,22530,27486,32718,38115,43581,49113,54777,60366,65868,71282,76631,81859,86920,91907,96652,101134,105719,110216,114356,118587,122515,126319,130004,133590,137065,140403,143615,146786,149771,152756,155474,158081,160730,163335,165721,168048,170320,172595,174693,176749,178682,180531,182547,184366,186066,187754,189372,190970,192489,193956,195452,196833,198098,199325,200602,201841,203042,204213,205304,206366,207398,208361,209316,210232,211142,212053,212940,213775,214538,215300,216093,216816,217543,218207,218902,219529,220211,220780,221392,221965,222513,223054,223604,224113,224623,225111,225579,226048,226549,227009,227451,227879,228271,228656,229039,229410,229753,230108,230514,230848,231172,231471,231803,232113,232427,232691,232969,233227,
0,0,0,9,84,331,836,1739,3159,4963,7360,10174,13311,16697,20324,24156,28164,32304,36515,40804,45043,49310,53499,57608,61586,65606,69487,73291,77104,80668,84229,87643,90978,94248,97368,100410,103365,106208,108977,111729,114385,116856,119357,121745,124099,126277,128397,130510,132592,134577,136495,138310,140071,141784,143456,145018,146550,148075,149538,150995,152372,153641,154926,156187,157401,158578,159758,160871,162004,163054,164112,165056,166067,167019,167874,168715,169575,170359,171102,171864,172605,173370,174100,174754,175455,176139,176732,177370,177953,178530,179097,179641,180182,180729,181246,181734,182224,182641,183110,183531,183952,184369,184786,185190,185573,185952,186334,186653,186982,187302,187624,187916,188246,188551,188832,189116,189398,189682,189962,190200,
0,0,0,1,22,90,280,655,1294,2266,3480,5013,6866,8970,11361,13804,16460,19284,22156,25028,28014,31028,34127,37179,40160,43200,46177,49144,52051,54907,57788,60567,63186,65841,68333,70864,73251,75651,77914,80164,82269,84399,86456,88428,90378,92239,94122,95851,97634,99277,100904,102456,103952,105460,106849,108237,109580,110891,112142,113405,114613,115748,116905,117998,119015,120043,121117,122156,123092,124056,124941,125802,126642,127483,128261,129073,129845,130574,131314,131987,132696,133356,134095,134728,135335,135909,136549,137157,137705,138262,138780,139285,139758,140236,140666,141126,141561,142011,142381,142792,143171,143523,143873,144272,144623,144956,145288,145644,145953,146252,146561,146863,147141,147432,147697,147946,148217,148468,148706,148946,
0,0,0,0,3,17,63,179,398,759,1264,1998,2843,3925,5109,6515,7982,9537,11266,13103,14992,16950,18903,20958,22996,25043,27093,29144,31164,33239,35237,37127,39112,41024,42893,44792,46582,48418,50120,51758,53497,55145,56749,58343,59854,61327,62785,64185,65539,66841,68184,69427,70612,71786,73004,74146,75273,76371,77376,78436,79414,80405,81329,82215,83132,83970,84833,85665,86487,87249,88017,88748,89436,90156,90855,91520,92142,92761,93403,94021,94588,95156,95725,96269,96789,97324,97842,98319,98778,99234,99678,100136,100542,100911,101306,101690,102046,102407,102810,103130,103469,103844,104169,104470,104785,105077,105347,105649,105923,106199,106477,106707,106979,107213,107435,107681,107887,108084,108313,108540,
0,0,0,0,0,2,7,25,54,129,255,462,724,1088,1547,2117,2733,3457,4220,5035,5912,6922,7969,9001,10086,11139,12274,13461,14688,15879,17063,18260,19463,20728,21998,23113,24262,25483,26624,27784,28889,30001,31028,32105,33142,34227,35168,36148,37094,37958,38925,39815,40628,41529,42372,43154,43934,44704,45480,46235,46992,47754,48441,49110,49783,50428,51074,51679,52295,52871,53457,54032,54557,55129,55691,56171,56649,57117,57597,58070,58499,58932,59378,59811,60224,60632,61008,61401,61754,62138,62504,62835,63186,63523,63817,64134,64411,64695,65003,65289,65550,65834,66102,66337,66553,66795,67057,67264,67496,67697,67931,68116,68341,68554,68752,68932,69098,69297,69483,69656,
66700,288254,488586,641342,759602,852390,927662,989593,1041851,1085317,1123452,1156426,1184783,1209956,1232296,1252336,1270398,1286582,1301150,1314671,1326769,1338085,1348413,1358019,1366878,1375148,1382658,1389719,1396246,1402596,1408282,1413649,1418717,1423468,1428028,1432280,1436267,1440054,1443450,1446705,1449815,1452903,1455817,1458549,1461168,1463611,1466013,1468208,1470311,1472376,1474300,1476144,1477897,1479643,1481266,1482798,1484276,1485694,1487012,1488335,1489568,1490819,1492007,1493122,1494188,1495197,1496129,1497051,1497946,1498804,1499651,1500472,1501297,1502048,1502796,1503499,1504177,1504772,1505418,1506027,1506591,1507166,1507697,1508223,1508735,1509263,1509733,1510180,1510642,1511100,1511509,1511910,1512295,1512693,1513087,1513456,1513813,1514146,1514455,1514771,1515102,1515376,1515675,1515938,1516210,1516481,1516760,1517005,1517277,1517500,1517706,1517951,1518150,1518372,1518591,1518771,1518981,1519186,1519366,1519536,
18090,139283,287293,418337,526203,615048,689266,752296,805583,851408,891041,925936,956923,984515,1008917,1030957,1050624,1068569,1084816,1099476,1112958,1125445,1137053,1147770,1157784,1167003,1175599,1183418,1190900,1197843,1204301,1210460,1216276,1221727,1226674,1231486,1235952,1240289,1244361,1248245,1251874,1255291,1258604,1261764,1264752,1267650,1270327,1272890,1275345,1277707,1279971,1282116,1284253,1286161,1288061,1289783,1291542,1293172,1294695,1296173,1297695,1299085,1300371,1301691,1302954,1304190,1305279,1306429,1307470,1308470,1309457,1310396,1311375,1312271,1313105,1313892,1314715,1315505,1316251,1316996,1317657,1318348,1319002,1319547,1320157,1320727,1321278,1321790,1322304,1322800,1323246,1323717,1324182,1324635,1325051,1325448,1325870,1326295,1326685,1327024,1327378,1327709,1328091,1328394,1328702,1329021,1329320,1329618,1329891,1330150,1330417,1330652,1330925,1331180,1331426,1331660,1331881,1332087,1332301,1332485,
6839,80615,193955,304117,400965,484247,554899,615988,668422,714245,754221,789280,820569,848687,873897,896700,917159,935806,952674,968269,982666,995895,1007957,1019316,1029733,1039517,1048505,1056926,1064893,1072433,1079260,1085754,1091891,1097683,1103055,1108224,1113130,1117771,1122111,1126268,1130220,1133825,1137299,1140617,1143830,1146709,1149615,1152368,1154992,1157511,1159929,1162231,1164521,1166565,1168508,1170339,1172201,1173979,1175622,1177226,1178767,1180274,1181762,1183154,1184527,1185787,1187006,1188189,1189335,1190483,1191483,1192503,1193437,1194419,1195342,1196264,1197124,1197948,1198780,1199485,1200209,1200941,1201631,1202304,1202947,1203549,1204088,1204671,1205199,1205788,1206298,1206816,1207292,1207738,1208216,1208680,1209124,1209559,1209938,1210354,1210723,1211091,1211466,1211833,1212160,1212483,1212812,1213119,1213422,1213709,1214017,1214305,1214568,1214856,1215114,1215370,1215620,1215850,1216066,1216276,
1808,39091,115065,199738,280203,353005,416945,473501,523456,567508,606735,641432,672492,700412,725603,748517,769302,788158,805683,821548,836193,849862,862529,874243,885118,895280,904605,913259,921305,929005,936246,943088,949457,955493,961274,966746,972017,976827,981425,985762,989955,993804,997521,1001032,1004433,1007744,1010799,1013729,1016551,1019290,1021906,1024314,1026681,1028848,1030918,1032980,1034891,1036768,1038561,1040336,1041959,1043611,1045167,1046634,1048008,1049348,1050657,1052010,1053197,1054328,1055500,1056550,1057662,1058656,1059625,1060556,1061500,1062442,1063254,1064065,1064838,1065634,1066349,1067098,1067815,1068494,1069126,1069742,1070376,1070951,1071486,1072013,1072576,1073111,1073594,1074068,1074580,1075021,1075513,1075946,1076388,1076816,1077194,1077569,1077940,1078314,1078668,1079013,1079363,1079693,1080009,1080329,1080595,1080880,1081123,1081382,1081668,1081934,1082162,1082418,
261,14009,55833,112330,172207,230158,283535,332317,376716,416212,452208,485002,514467,541541,565638,587689,608021,626577,643995,659733,674750,688529,701275,713147,724069,734228,743765,752717,761232,769187,776641,783516,790022,796278,802093,807796,813228,818305,823077,827568,831925,836034,839934,843618,847131,850503,853666,856722,859670,862417,865186,867804,870312,872614,874904,877128,879228,881211,883081,884948,886736,888393,890083,891660,893188,894676,896080,897417,898744,899960,901196,902314,903393,904458,905444,906431,907494,908366,909306,910183,911002,911853,912675,913441,914185,914859,915587,916281,916970,917623,918225,918793,919362,919902,920429,920925,921417,921960,922462,922926,923410,923868,924261,924671,925105,925486,925849,926193,926555,926914,927238,927565,927865,928194,928494,928791,929097,929355,929617,929873,
89,7395,34972,77293,125266,174340,221342,264835,305043,342065,375745,406211,434025,459630,483133,504880,524808,542936,559796,575687,590226,603663,616320,627999,638921,649202,658812,668040,676407,684273,691743,698849,705546,711697,717670,723256,728481,733580,738477,742960,747442,751564,755543,759329,762903,766373,769642,772647,775761,778575,781364,784030,786519,788928,791232,793446,795625,797728,799673,801557,803388,805089,806750,808312,809844,811365,812852,814199,815556,816895,818138,819346,820528,821631,822723,823750,824738,825715,826659,827610,828466,829345,830117,830876,831654,832394,833113,833792,834461,835080,835712,836299,836877,837458,838042,838539,839072,839578,840079,840552,841024,841477,841927,842385,842792,843164,843569,843952,844293,844673,844983,845308,845620,845945,846287,846595,846860,847147,847406,847636,
17,3303,19715,49042,86062,125327,164356,201669,237172,270338,301133,329417,355272,379053,401210,421691,440739,457977,474484,489552,503699,516632,528599,540129,550910,560844,570277,579094,587446,595351,602940,610068,616600,622816,628849,634500,639784,644837,649698,654328,658660,662866,666875,670613,674349,677751,680953,684090,687104,690056,692759,695490,698060,700538,702891,705168,707216,709265,711238,713193,715088,716828,718463,720120,721681,723159,724633,725972,727380,728638,729896,731127,732327,733445,734529,735633,736628,737624,738590,739569,740484,741425,742247,743038,743838,744584,745285,746009,746698,747412,748055,748688,749253,749824,750392,750933,751463,751966,752443,752949,753420,753843,754311,754762,755191,755581,755994,756409,756783,757118,757475,757832,758182,758503,758848,759188,759474,759775,760045,760306,
5,1212,9820,28112,53774,83421,114376,144764,174622,202915,229792,254672,278272,299985,320345,339207,356598,372822,388131,402464,415790,428360,440194,451168,461520,471287,480514,489198,497450,505153,512352,519319,525878,532215,538112,543698,548900,553971,558823,563272,567583,571710,575708,579440,583039,586425,589749,592871,595857,598652,601420,604067,606574,609004,611329,613583,615736,617690,619789,621704,623547,625319,627027,628678,630294,631810,633264,634663,635997,637321,638634,639917,641122,642275,643419,644581,645576,646619,647598,648522,649451,650345,651197,651978,652769,653549,654299,655053,655698,656414,657068,657716,658332,658942,659506,660083,660638,661188,661694,662217,662677,663140,663603,664055,664473,664843,665251,665644,666021,666387,666749,667119,667457,667779,668097,668423,668709,668991,669294,669554,
0,391,4155,14262,30247,50451,73086,96552,119965,143255,165758,187056,207092,226186,244088,260730,276437,291431,305326,318414,330689,342394,353344,363574,373385,382707,391347,399629,407347,414707,421605,428196,434414,440360,446066,451462,456713,461652,466339,470790,474975,479031,482956,486619,490090,493454,496666,499784,502774,505520,508171,510743,513161,515686,518015,520205,522300,524360,526387,528274,530200,532017,533720,535425,537003,538544,540020,541472,542872,544168,545423,546677,547945,549015,550097,551205,552221,553182,554149,555124,556066,556964,557821,558666,559456,560235,561012,561712,562414,563116,563764,564423,565027,565622,566195,566782,567327,567877,568381,568859,569295,569762,570213,570647,571090,571493,571874,572251,572615,573012,573386,573730,574087,574404,574716,575075,575392,575688,576005,576301,
0,152,2220,8574,19617,34973,52782,71982,91635,111058,130326,149036,166872,183821,200304,215757,230179,244048,256930,269113,280734,291563,301944,311617,320930,329709,337940,345791,353291,360440,367113,373480,379533,385252,390656,395803,400655,405366,409860,414196,418386,422383,426191,429823,433340,436545,439679,442633,445510,448288,450962,453475,455891,458199,460440,462594,464669,466695,468694,470652,472443,474189,475881,477474,479025,480558,482073,483479,484822,486087,487341,488579,489789,490923,492010,493048,494139,495115,496081,497018,497964,498883,499690,500546,501363,502132,502870,503600,504282,504964,505655,506273,506884,507511,508125,508699,509255,509765,510257,510748,511230,511734,512183,512615,513048,513447,513844,514215,514650,515023,515370,515756,516098,516445,516786,517100,517419,517726,518015,518298,
0,65,1009,4777,12082,22634,35881,50657,66396,82332,98481,114510,129978,144651,158810,172458,185515,197631,209357,220616,231239,241306,250797,259832,268591,276515,284297,291649,298926,305555,311929,318009,323699,329234,334398,339436,344197,348750,353120,357304,361267,365051,368678,372266,375633,378840,381934,384897,387762,390399,392975,395457,397855,400176,402462,404604,406747,408765,410665,412552,414329,416003,417573,419158,420698,422194,423604,425019,426295,427582,428788,429981,431117,432226,433295,434369,435410,436409,437359,438270,439201,440034,440851,441687,442502,443281,444092,444840,445509,446230,446892,447562,448134,448720,449329,449883,450440,450986,451453,451929,452432,452904,453360,453799,454219,454630,455032,455443,455820,456213,456587,456946,457263,457587,457915,458262,458574,458886,459163,459401,
0,13,435,2283,6700,13544,22685,33372,45224,57839,70890,83871,96653,109184,121261,132956,144343,155156,165492,175532,185205,194383,203231,211709,219708,227123,234382,241202,247807,254164,259985,265561,271016,276136,281037,285743,290187,294411,298539,302436,306128,309752,313162,316518,319676,322740,325584,328392,331157,333740,336269,338676,340972,343134,345300,347351,349330,351262,353085,354870,356569,358222,359827,361414,362895,364391,365781,367116,368395,369653,370902,372026,373152,374291,375369,376375,377358,378396,379365,380252,381088,381954,382783,383589,384406,385169,385923,386644,387296,387955,388594,389205,389787,390356,390931,391448,391944,392452,392975,393470,393975,394468,394914,395349,395740,396147,396557,396939,397293,397671,398041,398407,398732,399090,399417,399716,399992,400287,400606,400876,
0,1,141,1014,3279,7345,13040,20347,28846,38048,47848,57703,67923,78132,87911,97751,107384,116443,125402,133892,142342,150255,157894,165122,172183,178933,185383,191526,197467,203175,208596,213737,218653,223301,227793,232103,236226,240232,243980,247613,251124,254589,257827,260950,263869,266734,269489,272201,274752,277209,279579,281877,284044,286170,288135,290116,291978,293844,295641,297367,299072,300694,302231,303721,305176,306573,307908,309196,310483,311668,312829,313960,315036,316067,317085,318097,319083,319972,320852,321706,322586,323442,324249,324998,325708,326451,327183,327906,328573,329198,329847,330455,331062,331615,332194,332731,333240,333743,334249,334736,335184,335656,336092,336583,336984,337388,337750,338101,338464,338800,339141,339471,339821,340168,340446,340757,341087,341363,341650,341951,
0,0,38,344,1314,3307,6514,10877,16332,22599,29357,36581,44048,51579,59042,66570,74187,81716,88852,95831,102596,109214,115679,121902,127871,133695,139305,144622,149839,154814,159536,163953,168322,172578,176577,180526,184146,187832,191428,194731,197883,200972,203937,206813,209491,212143,214673,217149,219479,221831,224009,226077,228126,230078,231912,233657,235455,237108,238724,240353,241830,243298,244770,246157,247411,248724,249982,251216,252399,253554,254625,255744,256799,257788,258761,259680,260633,261509,262331,263161,263975,264726,265492,266254,266957,267650,268362,268978,269650,270275,270854,271425,271967,272532,273065,273578,274089,274582,275066,275526,275947,276400,276837,277217,277621,277983,278291,278660,279004,279338,279695,280021,280349,280647,280948,281229,281481,281737,282007,282247,
0,0,13,100,507,1461,3166,5674,8917,12827,17367,22409,27739,33158,38989,44714,50510,56264,61945,67684,73300,78690,83930,89100,94035,98870,103610,108189,112568,116853,120959,125064,128908,132615,136032,139536,142912,146056,149159,152054,154784,157563,160171,162775,165249,167670,169988,172329,174422,176487,178479,180434,182325,184085,185838,187507,189139,190720,192254,193695,195105,196492,197854,199119,200433,201676,202887,204000,205090,206094,207108,208123,209088,209977,210948,211819,212696,213545,214337,215089,215876,216589,217316,218021,218687,219329,219965,220579,221162,221763,222330,222882,223386,223872,224375,224877,225313,225764,226266,226724,227138,227538,227894,228270,228672,229041,229388,229748,230096,230409,230761,231055,231368,231650,231948,232201,232506,232782,233018,233292,
0,0,3,22,131,483,1213,2411,4149,6397,9017,12130,15568,19136,23078,27085,31129,35408,39569,43799,47915,52034,56089,60259,64107,68040,71779,75482,78971,82467,85740,88899,92036,95119,98174,101042,103929,106650,109196,111797,114239,116691,118961,121150,123355,125443,127506,129465,131258,133086,134836,136491,138147,139659,141169,142699,144160,145616,146998,148287,149556,150803,152005,153164,154334,155456,156483,157526,158574,159525,160522,161458,162315,163144,163939,164709,165495,166260,167008,167719,168382,169094,169701,170378,170969,171612,172160,172715,173235,173734,174288,174794,175275,175724,176186,176636,177088,177532,177966,178390,178792,179201,179583,179970,180318,180673,181023,181358,181668,181976,182299,182612,182882,183160,183440,183728,183988,184250,184497,184731,
0,0,0,3,21,113,345,767,1399,2345,3639,5165,6981,9039,11267,13645,16060,18619,21259,24063,26882,29697,32503,35323,38110,40843,43499,46083,48721,51289,53830,56325,58762,61174,63509,65758,67951,70092,72267,74320,76305,78210,80056,81851,83567,85239,86912,88502,90111,91631,93158,94523,95941,97227,98536,99761,100976,102179,103347,104486,105554,106532,107571,108570,109578,110498,111421,112297,113137,113912,114705,115503,116251,117034,117753,118416,119122,119810,120406,121036,121689,122289,122840,123416,123973,124503,125003,125539,126041,126513,126945,127381,127852,128328,128742,129142,129533,129921,130282,130654,131053,131394,131712,132038,132351,132667,132971,133280,133554,133853,134131,134413,134673,134917,135190,135419,135647,135862,136056,136260,
0,0,0,0,3,7,42,120,263,551,891,1371,2021,2774,3696,4776,5928,7162,8432,9828,11331,12819,14385,15957,17593,19179,20820,22457,24095,25717,27287,28912,30477,32013,33609,35151,36604,38030,39412,40789,42145,43519,44851,46181,47367,48592,49890,51050,52168,53249,54304,55400,56458,57457,58418,59335,60291,61173,62078,62937,63771,64555,65362,66136,66897,67620,68274,68975,69644,70318,70930,71542,72127,72703,73264,73844,74370,74895,75366,75857,76342,76842,77310,77764,78205,78660,79108,79506,79889,80294,80678,81060,81420,81754,82099,82465,82803,83127,83431,83729,84019,84301,84575,84846,85127,85363,85595,85828,86040,86293,86528,86761,86991,87216,87397,87596,87804,87988,88183,88374,
92270,332523,529237,674803,785371,871667,941043,997672,1045220,1085358,1119864,1149646,1175923,1198685,1219168,1237276,1253675,1268475,1281787,1294163,1305441,1315719,1325222,1334029,1342081,1349742,1356648,1363170,1369275,1375041,1380398,1385268,1389845,1394283,1398460,1402362,1406052,1409608,1412844,1415835,1418782,1421532,1424175,1426801,1429214,1431491,1433672,1435778,1437796,1439778,1441654,1443393,1445005,1446597,1448134,1449574,1450949,1452247,1453529,1454761,1455925,1457032,1458138,1459123,1460103,1461042,1461960,1462859,1463760,1464587,1465356,1466162,1466933,1467650,1468357,1469045,1469677,1470305,1470904,1471453,1472010,1472536,1473043,1473534,1474011,1474448,1474900,1475342,1475723,1476166,1476568,1476970,1477370,1477731,1478113,1478453,1478774,1479099,1479386,1479697,1479973,1480248,1480510,1480764,1481027,1481285,1481548,1481800,1482043,1482262,1482484,1482703,1482911,1483098,1483293,1483466,1483632,1483813,1483995,1484178,
31529,180898,337755,468004,571945,655853,725840,783646,832969,875228,911736,943433,971745,996610,1018671,1038818,1056733,1072999,1087654,1101120,1113627,1124965,1135510,1145252,1154251,1162807,1170580,1177682,1184454,1190845,1196907,1202447,1207752,1212775,1217399,1221718,1225958,1229976,1233725,1237225,1240597,1243811,1246692,1249565,1252281,1254879,1257283,1259609,1261934,1264159,1266270,1268264,1270123,1271874,1273597,1275264,1276902,1278406,1279891,1281326,1282709,1283993,1285174,1286327,1287442,1288520,1289513,1290529,1291573,1292557,1293429,1294323,1295192,1296037,1296858,1297614,1298400,1299099,1299792,1300497,1301123,1301744,1302323,1302917,1303474,1304016,1304527,1305010,1305484,1305954,1306387,1306817,1307250,1307662,1308040,1308431,1308827,1309191,1309565,1309912,1310235,1310587,1310920,1311220,1311521,1311790,1312054,1312360,1312636,1312907,1313168,1313431,1313667,1313895,1314133,1314369,1314590,1314794,1314987,1315157,
14324,115883,244513,359757,455807,536310,603892,661194,710042,752477,789719,822069,850862,876383,899354,919919,938640,955466,970918,985027,997921,1009978,1020847,1031053,1040556,1049397,1057644,1065149,1072308,1079093,1085469,1091432,1096872,1102135,1106992,1111663,1116074,1120312,1124282,1128052,1131609,1135063,1138285,1141443,1144456,1147133,1149818,1152325,1154705,1157021,1159315,1161499,1163460,1165331,1167142,1168895,1170626,1172215,1173745,1175281,1176719,1178144,1179504,1180808,1181950,1183113,1184203,1185309,1186393,1187428,1188421,1189332,1190273,1191169,1191993,1192794,1193570,1194354,1195090,1195755,1196424,1197093,1197695,1198301,1198885,1199436,1199994,1200582,1201082,1201564,1202013,1202492,1202920,1203375,1203808,1204250,1204673,1205067,1205435,1205778,1206131,1206478,1206806,1207142,1207454,1207788,1208098,1208391,1208673,1208947,1209240,1209511,1209785,1210027,1210263,1210477,1210734,1210959,1211151,1211336,
4942,64214,158779,253441,338344,411522,474573,529821,577362,618803,655103,687353,716227,741820,765034,785984,804921,822368,838409,853148,866509,878905,890183,900976,910847,919990,928575,936453,943991,950999,957579,963768,969604,975234,980351,985276,989833,994268,998480,1002530,1006323,1010040,1013487,1016712,1019858,1022762,1025571,1028298,1030922,1033452,1035837,1037975,1040157,1042197,1044142,1046017,1047860,1049616,1051307,1052871,1054438,1055827,1057224,1058609,1059865,1061143,1062334,1063559,1064715,1065824,1066856,1067854,1068828,1069786,1070708,1071546,1072397,1073201,1073931,1074690,1075423,1076123,1076774,1077439,1078058,1078669,1079255,1079846,1080384,1080938,1081495,1082025,1082569,1083075,1083539,1083989,1084426,1084861,1085270,1085658,1086081,1086435,1086784,1087140,1087492,1087845,1088129,1088459,1088789,1089112,1089406,1089713,1089974,1090239,1090503,1090771,1091004,1091238,1091453,1091675,
1157,28242,87726,157137,225010,287302,343606,393123,437184,476075,510669,541875,569999,595491,618260,638906,657851,675450,691465,706093,720013,732630,744444,755251,765348,774782,783574,791750,799516,806804,813681,820170,826288,832077,837498,842539,847407,851914,856209,860514,864576,868325,871882,875220,878359,881420,884368,887201,889907,892460,895058,897471,899752,901901,903996,905942,907798,909650,911444,913101,914678,916247,917681,919212,920612,921922,923193,924484,925634,926836,927965,929048,930091,931083,932067,933020,933936,934824,935713,936511,937285,938026,938774,939483,940119,940800,941452,942061,942660,943222,943783,944352,944889,945400,945930,946402,946864,947303,947720,948156,948612,948976,949355,949712,950096,950507,950843,951162,951485,951787,952120,952423,952703,953033,953305,953553,953822,954080,954331,954608,
462,16597,59971,116184,173778,228858,279168,324766,365702,402475,435831,465858,492865,517532,539828,560397,579164,596330,612429,627164,640791,653504,665267,676103,686308,695664,704471,712798,720511,727860,734916,741530,747751,753605,759054,764236,769053,773795,778306,782421,786588,790457,794077,797658,801007,804114,807213,810060,812805,815391,817913,820348,822637,824833,827036,829013,831017,832905,834697,836361,838027,839585,841174,842630,844076,845447,846749,848009,849254,850396,851574,852712,853766,854835,855806,856835,857774,858705,859633,860477,861275,862014,862825,863538,864280,865017,865689,866327,866942,867502,868055,868599,869184,869716,870215,870720,871212,871703,872136,872555,873035,873428,873831,874206,874603,874982,875341,875697,876020,876338,876651,876933,877236,877541,877841,878097,878371,878631,878902,879136,
146,8732,37502,79481,125694,172562,216724,257670,294824,328938,359876,388202,413898,437246,458921,478767,496964,513881,529394,543709,557289,569722,581362,592124,602204,611647,620584,628864,636555,643910,650822,657389,663720,669566,674987,680227,685262,689969,694466,698675,702733,706631,710258,713798,717156,720332,723449,726345,729127,731846,734431,736873,739230,741417,743576,745696,747611,749606,751447,753157,754858,756528,758110,759646,761083,762462,763800,765071,766365,767558,768757,769882,770979,771984,772989,774033,775002,775929,776833,777652,778550,779373,780173,780907,781605,782359,783081,783730,784353,784961,785557,786147,786703,787232,787746,788233,788727,789209,789680,790145,790591,790999,791384,791751,792132,792545,792944,793320,793626,793939,794302,794619,794948,795260,795594,795894,796192,796453,796736,796983,
39,3886,21109,50364,85714,123102,160087,195037,228157,258850,287064,312926,336882,358659,379073,397793,414845,431039,446088,459942,472868,484967,496319,506905,516752,526067,534627,542851,550722,558076,564922,571373,577581,583458,589014,594251,599250,604026,608591,612887,616868,620747,624357,627819,631154,634332,637413,640418,643223,645951,648497,650929,653303,655688,657812,659869,661859,663863,665743,667516,669240,670856,672472,674026,675437,676817,678148,679463,680742,681930,683147,684271,685390,686437,687459,688453,689436,690357,691288,692170,693012,693820,694596,695348,696052,696800,697481,698199,698844,699456,700101,700689,701269,701820,702359,702889,703394,703904,704391,704886,705342,705766,706165,706551,706947,707306,707702,708055,708422,708734,709079,709393,709730,710061,710345,710655,710947,711214,711484,711779,
7,1383,10330,28199,52697,80654,109405,137711,165182,191236,215821,238578,260096,279986,298750,315744,331749,346677,360732,373832,386165,397567,408269,418351,428020,437163,445459,453328,460728,467868,474613,480796,486832,492542,498014,503093,508059,512713,517127,521471,525466,529304,532941,536412,539756,542974,546093,549067,551826,554473,557061,559465,561835,564076,566268,568323,570384,572260,574142,575967,577727,579390,581105,582608,584124,585632,586969,588371,589637,590890,592152,593342,594474,595506,596558,597571,598537,599481,600389,601265,602169,602962,603793,604565,605309,606013,606772,607470,608138,608751,609339,609929,610514,611100,611624,612140,612655,613155,613609,614107,614540,614998,615465,615856,616275,616669,617061,617424,617779,618156,618538,618853,619165,619446,619753,620065,620367,620638,620913,621159,
0,661,5944,18366,36813,58755,82653,106432,130066,153081,175050,195813,215290,233650,251001,267095,282168,296419,309681,322093,333856,344727,355153,364707,373909,382561,390542,398320,405642,412604,419104,425278,431138,436707,442032,447084,451892,456547,461035,465141,469146,472874,476498,480025,483405,486544,489607,492467,495241,497867,500492,503022,505338,507619,509868,511830,513724,515726,517532,519335,521019,522698,524294,525806,527335,528729,530110,531465,532795,534060,535248,536360,537507,538570,539643,540667,541631,542573,543507,544411,545298,546131,546928,547766,548534,549281,549988,550647,551318,551931,552524,553109,553715,554266,554777,555307,555856,556367,556837,557345,557835,558268,558637,559031,559445,559841,560202,560562,560941,561295,561647,561983,562284,562576,562870,563173,563483,563761,564045,564327,
0,295,3252,11054,24144,40570,59436,79056,98996,118710,137845,156230,173627,190277,205825,220344,234236,247406,259753,271261,282090,292392,302146,311258,319890,328105,335749,343133,350099,356658,362974,368848,374486,379815,384917,389722,394326,398787,403087,407099,411009,414621,418067,421418,424710,427808,430841,433639,436330,438911,441386,443865,446159,448414,450594,452615,454640,456588,458472,460280,462028,463670,465255,466795,468255,469689,471057,472350,473605,474813,476023,477215,478321,479390,480414,481458,482445,483334,484313,485175,486041,486839,487610,488378,489137,489877,490655,491336,492026,492649,493222,493808,494405,494934,495517,496053,496570,497084,497557,498000,498493,498908,499342,499730,500144,500528,500932,501312,501683,502001,502332,502682,503005,503310,503590,503888,504205,504488,504763,505027,
0,87,1415,6109,14449,26081,39883,55301,71213,87248,103269,118916,133872,148141,162044,175038,187486,199282,210364,220906,230965,240448,249350,257910,265994,273686,281042,287949,294657,300962,307054,312786,318113,323333,328213,332851,337354,341556,345697,349527,353290,356839,360299,363534,366708,369660,372521,375326,377936,380343,382728,385066,387331,389507,391605,393641,395569,397406,399154,400870,402590,404155,405692,407208,408671,410060,411386,412728,413938,415095,416286,417410,418467,419542,420535,421550,422532,423398,424327,425221,426092,426861,427666,428466,429236,429963,430656,431343,431944,432613,433249,433881,434443,434996,435506,436038,436559,437069,437562,438005,438474,438908,439350,439802,440217,440591,440943,441310,441661,442009,442331,442670,442971,443282,443581,443859,444148,444434,444724,444974,
0,25,573,2830,7839,15326,24759,35880,47781,60233,72842,85578,97918,109831,121443,132647,143543,153750,163703,173125,182217,190824,198898,206650,214147,221282,227942,234425,240424,246338,251873,257203,262234,267100,271700,276078,280189,284235,288150,291800,295177,298434,301631,304745,307795,310615,313293,315933,318463,320925,323206,325431,327544,329647,331657,333629,335516,337279,339002,340615,342249,343740,345243,346730,348129,349488,350856,352194,353393,354594,355697,356800,357855,358899,359915,360897,361874,362775,363625,364491,365311,366125,366888,367622,368384,369084,369793,370498,371162,371808,372421,372977,373557,374095,374624,375135,375677,376191,376647,377086,377571,377980,378374,378755,379149,379549,379881,380237,380578,380947,381290,381617,381918,382207,382513,382786,383070,383361,383617,383897,
0,5,209,1091,3569,7657,13489,20803,29040,37960,47334,56829,66300,75738,85148,94320,103246,111769,120042,128119,135796,143251,150317,157198,163691,169928,175981,181711,187098,192455,197388,202087,206806,211219,215402,219416,223240,226863,230337,233716,236935,240068,243010,245807,248667,251391,253985,256490,258869,261156,263396,265458,267491,269490,271339,273133,274851,276541,278198,279757,281263,282811,284252,285664,287063,288399,289617,290806,292006,293093,294190,295265,296330,297352,298257,299176,300080,300897,301720,302555,303318,304119,304853,305580,306299,306954,307636,308300,308927,309533,310117,310672,311225,311756,312263,312772,313234,313686,314163,314647,315074,315509,315938,316332,316714,317068,317419,317756,318090,318420,318739,319046,319358,319645,319953,320262,320546,320827,321083,321365,
0,0,41,384,1467,3676,7136,11629,16927,23072,29803,36727,43971,51117,58369,65623,72771,79694,86388,93024,99575,105765,111703,117380,123031,128453,133633,138786,143565,148066,152498,156706,160788,164669,168429,172198,175614,179110,182322,185452,188245,191100,193847,196397,198930,201412,203769,206051,208300,210347,212384,214348,216322,218164,219862,221562,223223,224743,226287,227727,229122,230528,231847,233128,234353,235577,236717,237842,238938,240002,241040,242080,243045,244030,244996,245908,246780,247593,248403,249141,249886,250637,251337,251981,252673,253282,253916,254554,255189,255782,256341,256871,257398,257907,258378,258862,259343,259790,260249,260704,261128,261543,261937,262323,262694,263025,263371,263721,264043,264332,264659,264968,265263,265563,265849,266105,266372,266646,266916,267186,
0,0,6,103,495,1412,2990,5333,8490,12138,16376,21016,25885,30693,35946,41224,46513,51913,57121,62093,67153,72058,76746,81367,85889,90383,94652,98892,102856,106594,110326,113915,117463,120832,124078,127271,130255,133132,136014,138684,141385,143876,146319,148606,150859,153074,155194,157198,159104,161005,162860,164652,166404,168066,169691,171249,172718,174179,175600,176884,178197,179455,180673,181903,183028,184162,185340,186352,187342,188327,189237,190183,191053,191961,192763,193540,194326,195138,195872,196577,197321,198019,198637,199265,199878,200488,201052,201644,202214,202784,203281,203779,204282,204759,205236,205712,206169,206570,206994,207385,207810,208172,208558,208929,209276,209603,209941,210315,210630,210905,211221,211505,211772,212044,212324,212585,212829,213056,213281,213484,
0,0,0,12,100,387,922,1856,3221,4911,6996,9479,12275,15371,18428,21733,25146,28662,32317,35854,39310,42788,46237,49657,53030,56258,59452,62520,65606,68581,71506,74307,77082,79754,82463,84908,87474,89800,92106,94388,96619,98752,100813,102715,104544,106387,108125,109886,111602,113208,114760,116222,117666,119120,120501,121783,123043,124375,125554,126662,127812,128869,129939,130971,131976,132945,133873,134787,135688,136484,137387,138188,139018,139872,140628,141340,142031,142725,143404,144062,144669,145276,145878,146419,146988,147521,148062,148564,149091,149605,150133,150568,151050,151471,151881,152317,152716,153114,153504,153859,154207,154545,154876,155218,155555,155840,156133,156431,156711,156978,157249,157553,157784,158039,158262,158519,158752,158969,159231,159461,
0,0,0,1,13,44,141,349,687,1266,2045,3021,4151,5383,6777,8291,10047,11754,13638,15566,17582,19613,21658,23598,25699,27782,29822,31837,33849,35797,37634,39599,41509,43326,45148,46928,48613,50312,51983,53562,55139,56706,58216,59587,61006,62410,63741,65045,66335,67516,68742,69930,71023,72093,73096,74102,75102,76131,77120,78063,78913,79756,80556,81340,82150,82954,83692,84396,85081,85779,86460,87136,87842,88445,89047,89690,90268,90810,91361,91897,92429,92947,93506,94000,94497,94949,95350,95783,96184,96564,96980,97366,97739,98122,98504,98849,99152,99488,99777,100080,100390,100646,100965,101249,101538,101791,102039,102305,102547,102777,102989,103216,103460,103688,103909,104109,104335,104518,104710,104912,
116881,367611,561115,699934,804350,884957,949920,1002556,1046890,1084513,1116574,1144250,1168284,1189537,1208486,1225380,1240701,1254709,1267196,1278590,1288993,1298546,1307548,1315811,1323446,1330688,1337216,1343301,1349054,1354389,1359385,1364060,1368482,1372698,1376664,1380301,1383772,1387101,1390279,1393205,1395921,1398518,1401033,1403432,1405812,1407954,1410092,1412085,1414003,1415803,1417612,1419278,1420808,1422300,1423769,1425129,1426481,1427787,1428956,1430139,1431240,1432350,1433348,1434348,1435327,1436266,1437151,1438003,1438788,1439595,1440331,1441047,1441751,1442441,1443119,1443752,1444372,1444971,1445554,1446131,1446697,1447211,1447711,1448193,1448644,1449099,1449525,1449962,1450353,1450749,1451150,1451520,1451858,1452238,1452563,1452874,1453189,1453494,1453779,1454061,1454339,1454635,1454899,1455138,1455398,1455625,1455884,1456119,1456331,1456546,1456747,1456929,1457143,1457341,1457538,1457703,1457869,1458056,1458220,1458416,
46495,216692,379120,506551,606998,687636,753421,807832,853768,893213,926956,956559,982602,1005867,1026407,1044708,1061563,1076674,1090440,1102983,1114454,1124966,1134685,1143841,1152231,1160065,1167269,1173953,1180376,1186415,1192040,1197267,1202221,1206885,1211153,1215284,1219129,1222850,1226389,1229696,1232751,1235725,1238492,1241212,1243819,1246312,1248611,1250896,1253059,1255077,1257026,1258853,1260711,1262440,1263994,1265587,1267098,1268464,1269806,1271129,1272333,1273557,1274696,1275756,1276817,1277857,1278886,1279821,1280812,1281703,1282580,1283442,1284306,1285142,1285884,1286590,1287311,1287968,1288627,1289273,1289885,1290491,1291027,1291549,1292085,1292578,1293092,1293540,1294004,1294440,1294898,1295349,1295784,1296227,1296620,1296982,1297310,1297642,1297987,1298305,1298626,1298938,1299238,1299546,1299829,1300080,1300345,1300610,1300848,1301070,1301309,1301563,1301786,1302022,1302240,1302442,1302648,1302846,1303041,1303218,
23822,147744,285643,402703,497822,576039,640150,694454,740892,780553,815265,845605,872301,896029,917398,936634,953599,969401,983691,996918,1008974,1020045,1030181,1039656,1048447,1056693,1064332,1071344,1077986,1084420,1090329,1095802,1100941,1105820,1110393,1114695,1118726,1122678,1126431,1129999,1133283,1136351,1139384,1142223,1145002,1147557,1150087,1152465,1154723,1156949,1159111,1161054,1162829,1164577,1166329,1167988,1169564,1171071,1172555,1173953,1175287,1176617,1177816,1178997,1180114,1181188,1182245,1183336,1184363,1185302,1186241,1187089,1187983,1188832,1189591,1190393,1191133,1191889,1192596,1193236,1193905,1194547,1195145,1195743,1196278,1196828,1197362,1197896,1198373,1198855,1199323,1199761,1200194,1200644,1201065,1201451,1201829,1202193,1202564,1202933,1203300,1203635,1203943,1204254,1204541,1204858,1205126,1205379,1205663,1205943,1206207,1206449,1206684,1206929,1207130,1207350,1207559,1207772,1207967,1208152,
9934,89727,197348,297684,383688,456108,517447,570219,615465,655053,689424,719833,747075,771433,792858,812469,830211,846466,861301,875069,887500,899109,909796,919468,928782,937367,945428,952851,959783,966321,972507,978283,983692,989002,993875,998396,1002698,1006886,1010888,1014703,1018245,1021585,1024647,1027624,1030612,1033312,1035930,1038365,1040764,1043031,1045186,1047296,1049261,1051221,1053094,1054928,1056686,1058347,1059860,1061356,1062838,1064181,1065481,1066747,1067962,1069112,1070247,1071393,1072515,1073609,1074553,1075460,1076384,1077253,1078109,1078956,1079778,1080577,1081282,1081931,1082630,1083312,1083963,1084608,1085205,1085817,1086382,1086907,1087403,1087909,1088426,1088913,1089361,1089853,1090306,1090707,1091120,1091527,1091910,1092282,1092670,1093027,1093397,1093750,1094045,1094344,1094637,1094937,1095242,1095525,1095819,1096108,1096368,1096612,1096865,1097120,1097362,1097600,1097824,1098033,
2820,44302,118501,196364,268523,332996,389309,438226,481291,519088,552692,582593,609326,633438,654847,674404,692348,709053,724205,737930,750792,762616,773528,783630,793001,801838,810065,817832,825027,831848,838241,844250,849848,855159,860275,865060,869622,874001,877981,881894,885577,889138,892546,895668,898648,901617,904478,907112,909713,912156,914453,916744,918850,920919,922838,924698,926511,928292,929922,931520,933043,934522,935936,937327,938603,939892,941135,942312,943378,944460,945487,946467,947424,948348,949289,950188,951049,951927,952673,953413,954177,954876,955585,956264,956919,957520,958069,958679,959249,959811,960315,960815,961364,961831,962307,962793,963266,963675,964117,964505,964929,965308,965663,966008,966329,966690,967018,967335,967670,967964,968272,968527,968812,969101,969375,969625,969873,970120,970342,970548,
1249,28147,85238,150427,214146,272203,324425,370375,411167,447481,479932,508921,534909,558751,579961,599433,617268,633509,648454,662495,675316,687164,698317,708622,718197,727103,735465,743339,750597,757552,764120,770290,775940,781350,786463,791399,796015,800446,804578,808419,812203,815711,819106,822406,825505,828475,831333,834006,836515,839034,841409,843760,845940,848020,849994,851812,853596,855409,857053,858658,860237,861703,863204,864630,865942,867236,868500,869698,870820,871959,873023,874049,875030,876005,876910,877848,878765,879589,880463,881258,882049,882751,883507,884224,884890,885594,886198,886792,887379,887952,888513,889050,889549,890041,890474,890920,891348,891821,892222,892633,893050,893421,893816,894211,894564,894957,895284,895622,895973,896271,896562,896848,897126,897422,897718,898013,898254,898506,898760,898988,
499,16153,56876,109178,162673,213416,260171,302357,340506,374811,405699,433288,458760,481833,502754,521767,539348,555406,570235,584092,596986,608885,620033,630386,639898,648877,657233,665219,672497,679411,686021,692282,698117,703585,708819,713795,718475,722858,727127,731117,734873,738484,741945,745301,748385,751253,754160,756899,759507,762022,764404,766697,768943,771111,773158,775116,776900,778703,780498,782099,783722,785237,786808,788288,789603,790928,792243,793424,794685,795854,796981,798069,799070,800072,801041,801991,802884,803700,804567,805377,806162,806891,807667,808432,809115,809790,810411,811013,811657,812263,812838,813378,813948,814444,814903,815373,815829,816311,816733,817157,817570,817991,818369,818749,819117,819491,819832,820161,820486,820813,821122,821426,821721,822011,822298,822558,822848,823107,823358,823582,
145,8212,34963,73333,116099,159037,199872,237089,271286,303014,331721,357675,381586,403097,422975,441422,458549,474248,488847,502437,515053,526648,537400,547570,557114,565924,574008,581917,589225,596233,602822,608962,614894,620388,625669,630700,635408,639875,644035,647945,651835,655502,658996,662370,665559,668563,671448,674214,676944,679398,681847,684179,686454,688654,690752,692670,694555,696382,698164,699842,701451,702899,704427,705928,707320,708606,709871,711167,712399,713597,714783,715913,716877,717864,718852,719811,720752,721646,722499,723326,724151,724914,725666,726373,727046,727736,728371,728993,729595,730234,730833,731362,731926,732454,732976,733452,733928,734385,734831,735267,735700,736111,736515,736903,737258,737642,737967,738291,738628,738961,739300,739608,739897,740185,740456,740733,741029,741273,741511,741773,
26,3530,18527,44462,76171,109693,142762,174389,203966,231813,257308,281089,302765,322862,341721,358964,374850,389834,403694,416612,428709,439952,450362,460180,469356,478073,486205,493738,501025,507830,514218,520076,525733,531269,536388,541317,546010,550402,554636,558636,562518,566176,569649,572995,576163,579150,582086,584793,587455,590008,592450,594847,597149,599301,601466,603453,605400,607169,608940,610728,612404,613978,615525,617038,618440,619743,621054,622360,623649,624855,626050,627188,628276,629321,630349,631248,632153,633044,633957,634791,635601,636413,637168,637928,638603,639304,640003,640636,641250,641887,642490,643052,643591,644105,644635,645129,645592,646096,646572,647043,647470,647844,648232,648635,649035,649379,649718,650090,650421,650788,651092,651446,651732,652011,652323,652595,652888,653158,653425,653672,
10,1854,11816,30785,55709,83168,111381,139062,165562,190641,214279,236227,256587,275540,293071,309167,324292,338357,351591,364049,375481,386184,396362,405882,414844,423442,431432,438913,446111,452891,459259,465281,470872,476203,481309,486149,490789,495255,499431,503435,507157,510724,514128,517385,520640,523690,526529,529324,531921,534427,536950,539233,541486,543667,545646,547606,549501,551357,553090,554832,556444,558022,559556,561056,562488,563889,565158,566470,567704,568900,570077,571136,572262,573288,574260,575218,576169,577132,578055,578943,579766,580580,581374,582101,582786,583472,584123,584796,585448,586039,586621,587182,587753,588242,588743,589299,589811,590302,590747,591174,591609,592008,592401,592790,593186,593557,593904,594285,594630,594991,595318,595638,595961,596267,596568,596859,597137,597418,597691,597936,
1,810,6701,19704,37936,59533,82659,105988,128802,150744,171555,191337,209695,227083,243239,258492,272797,286287,298773,310641,321619,331759,341206,350475,359157,367256,374912,382383,389305,395768,401894,407641,413103,418523,423702,428377,432989,437284,441362,445354,449055,452692,456133,459530,462633,465585,468444,471264,473920,476448,478874,481228,483406,485609,487687,489676,491504,493347,495077,496800,498467,500048,501605,503106,504524,505933,507246,508503,509714,510885,512061,513203,514252,515282,516306,517258,518224,519113,520005,520843,521669,522451,523198,523928,524690,525417,526068,526683,527321,527946,528586,529161,529705,530235,530756,531279,531741,532217,532670,533111,533531,533969,534345,534714,535090,535469,535860,536191,536519,536860,537189,537523,537823,538151,538448,538742,539026,539308,539586,539863,
1,352,3484,11553,24426,40707,58920,77772,96743,115452,133276,150790,167349,183066,197876,211485,224485,236649,248176,259367,269661,279253,288437,296970,305195,312874,320264,327100,333674,339710,345661,351375,356670,361831,366653,371341,375780,379842,383899,387672,391331,394815,398261,401495,404602,407513,410389,413143,415714,418175,420495,422749,424843,427022,429083,430945,432863,434618,436322,438032,439606,441169,442662,444030,445428,446725,448011,449283,450488,451597,452713,453811,454874,455887,456892,457787,458733,459605,460455,461290,462126,462900,463680,464449,465175,465874,466566,467173,467794,468369,469000,469589,470137,470697,471213,471693,472181,472639,473107,473550,474037,474471,474869,475256,475663,476015,476386,476753,477095,477413,477763,478061,478379,478666,478956,479234,479536,479809,480073,480327,
0,95,1439,5871,13895,24840,37898,52365,67176,82237,97122,111739,125539,138807,151436,163650,175078,185768,196276,206206,215618,224653,233079,241087,248686,255849,262743,269283,275494,281331,286885,292023,297156,301995,306670,311041,315181,319166,322999,326610,330069,333281,336514,339593,342610,345491,348215,350846,353323,355706,357956,360106,362110,364201,366200,368105,369978,371755,373393,374951,376497,377965,379470,380920,382288,383613,384908,386195,387391,388520,389636,390674,391738,392710,393643,394609,395551,396407,397297,398139,398948,399737,400486,401194,401876,402551,403225,403863,404474,405065,405653,406228,406790,407306,407800,408303,408789,409280,409731,410192,410631,411064,411499,411906,412319,412657,412974,413325,413671,414001,414328,414622,414937,415235,415548,415828,416100,416370,416606,416892,
0,30,532,2534,6982,13527,22059,32008,42913,54063,65460,76902,88045,98866,109331,119568,129404,138674,147808,156558,164716,172657,180106,187304,194231,200870,206993,212951,218587,223986,229143,233952,238748,243330,247531,251541,255488,259263,262690,266123,269350,272434,275471,278394,281108,283749,286327,288774,291192,293459,295566,297624,299641,301600,303452,305263,307024,308720,310317,311938,313423,314888,316357,317783,319030,320310,321546,322774,323885,325003,326046,327080,328045,328987,329984,330863,331675,332497,333357,334135,334936,335710,336404,337099,337755,338451,339075,339699,340315,340953,341517,342067,342597,343126,343681,344183,344668,345090,345556,345973,346395,346836,347242,347622,347975,348342,348672,349018,349344,349654,349960,350281,350573,350885,351174,351452,351723,351967,352244,352508,
0,4,175,1017,3317,7014,12284,18872,26347,34559,42972,51807,60574,69112,77581,85762,93926,101564,109207,116526,123568,130326,136776,143057,149086,154814,160331,165668,170709,175610,180178,184526,188696,192795,196590,200270,203763,207345,210624,213779,216704,219606,222277,224998,227590,230159,232589,234990,237174,239376,241521,243433,245334,247176,248993,250640,252290,253877,255460,256914,258323,259768,261119,262372,263623,264861,266061,267184,268328,269404,270391,271337,272315,273224,274086,274963,275753,276563,277370,278153,278900,279624,280321,280968,281610,282244,282876,283479,284044,284593,285129,285683,286211,286696,287180,287678,288118,288608,289086,289504,289920,290287,290670,291063,291411,291764,292134,292476,292796,293115,293421,293741,294045,294347,294646,294909,295168,295426,295671,295917,
0,0,36,303,1157,2841,5581,9331,13771,18869,24586,30547,36738,42907,49227,55405,61466,67581,73579,79401,85069,90649,95974,101082,106015,110962,115681,120066,124332,128603,132613,136526,140153,143773,147100,150406,153586,156601,159578,162458,165250,167812,170277,172671,175049,177308,179455,181556,183588,185487,187376,189213,190907,192579,194166,195769,197259,198746,200225,201595,202917,204207,205484,206709,207892,208993,210079,211179,212191,213202,214116,215066,215938,216823,217680,218499,219285,220039,220769,221484,222187,222852,223489,224146,224783,225355,225980,226548,227079,227660,228113,228647,229142,229608,230056,230496,230914,231329,231746,232157,232524,232919,233275,233630,233982,234312,234615,234952,235282,235595,235883,236181,236477,236745,237004,237267,237518,237769,238025,238269,
0,0,5,58,273,861,1964,3549,5669,8329,11544,15011,18677,22674,26724,30855,35118,39405,43683,47916,52191,56263,60183,64111,67983,71724,75337,78870,82194,85454,88723,91806,94722,97558,100427,103123,105663,108166,110614,112941,115253,117403,119505,121599,123684,125586,127440,129200,130934,132561,134192,135725,137273,138684,140148,141521,142887,144185,145383,146603,147818,148918,149967,151061,152059,153040,154065,155023,155931,156797,157632,158504,159303,160100,160894,161597,162294,162996,163619,164232,164914,165509,166097,166649,167173,167709,168248,168803,169331,169814,170279,170727,171195,171640,172074,172507,172899,173321,173708,174069,174450,174837,175188,175506,175830,176163,176469,176778,177073,177370,177637,177906,178169,178443,178674,178891,179132,179368,179573,179797,
0,0,0,1,22,106,349,777,1415,2337,3490,4874,6455,8204,10160,12347,14627,16860,19189,21618,24128,26646,29130,31594,34032,36414,38747,41039,43232,45444,47547,49723,51753,53834,55868,57894,59728,61552,63343,65135,66891,68520,70164,71685,73213,74694,76123,77552,78874,80224,81491,82762,83956,85048,86199,87263,88327,89362,90337,91351,92344,93285,94133,95009,95825,96675,97507,98290,99042,99758,100436,101145,101801,102468,103092,103655,104241,104805,105366,105904,106447,106961,107450,107906,108415,108894,109351,109788,110192,110635,111057,111496,111876,112258,112614,113016,113346,113693,114016,114327,114639,114917,115231,115505,115779,116053,116325,116589,116847,117090,117354,117597,117828,118065,118258,118470,118685,118876,119066,119265,
139271,397952,587438,720410,819678,896049,957477,1007175,1048793,1083787,1113756,1140095,1162841,1183008,1200835,1216977,1231227,1244331,1256269,1267065,1277039,1286108,1294603,1302384,1309552,1316210,1322506,1328198,1333644,1338918,1343661,1348158,1352317,1356316,1360125,1363733,1367112,1370261,1373295,1376079,1378678,1381197,1383584,1385894,1388130,1390253,1392302,1394246,1396046,1397787,1399466,1401027,1402531,1403983,1405427,1406801,1408080,1409347,1410493,1411590,1412661,1413741,1414721,1415722,1416685,1417543,1418386,1419199,1419981,1420727,1421492,1422161,1422873,1423568,1424164,1424757,1425390,1426009,1426578,1427120,1427627,1428162,1428614,1429086,1429553,1429951,1430360,1430796,1431170,1431552,1431942,1432288,1432655,1432989,1433306,1433637,1433936,1434243,1434528,1434810,1435090,1435365,1435654,1435902,1436106,1436328,1436557,1436796,1436995,1437216,1437432,1437636,1437843,1438012,1438188,1438347,1438528,1438687,1438851,1439029,
61784,247267,410957,536461,633444,710133,772551,824180,867826,904951,937132,965200,989710,1011319,1030568,1047894,1063718,1077955,1090798,1102520,1113559,1123479,1132728,1141435,1149142,1156600,1163429,1169800,1175775,1181381,1186676,1191683,1196307,1200932,1205014,1208829,1212500,1216045,1219425,1222570,1225469,1228353,1231041,1233557,1235998,1238259,1240457,1242578,1244666,1246620,1248433,1250116,1251833,1253448,1254953,1256397,1257887,1259258,1260536,1261795,1262945,1264078,1265180,1266302,1267323,1268330,1269345,1270291,1271195,1272059,1272916,1273699,1274478,1275285,1276007,1276678,1277324,1277997,1278678,1279275,1279900,1280469,1280961,1281435,1281936,1282402,1282898,1283358,1283764,1284205,1284621,1285034,1285446,1285816,1286182,1286531,1286897,1287242,1287568,1287868,1288196,1288500,1288802,1289070,1289338,1289627,1289871,1290129,1290358,1290596,1290817,1291057,1291301,1291503,1291706,1291907,1292097,1292278,1292466,1292665,
34611,176356,319250,435593,528697,603773,665781,717539,761323,799269,832070,860599,885835,908108,928070,945885,962185,976948,990580,1002993,1014246,1024581,1034189,1043060,1051347,1059115,1066238,1072999,1079356,1085294,1090949,1096097,1100997,1105550,1109911,1113887,1117789,1121565,1125086,1128447,1131496,1134570,1137462,1140240,1142921,1145380,1147680,1149960,1152011,1154013,1156078,1157967,1159696,1161363,1163040,1164553,1166027,1167551,1168902,1170292,1171631,1172867,1174007,1175170,1176258,1177332,1178343,1179375,1180330,1181211,1182097,1182935,1183753,1184614,1185372,1186097,1186765,1187439,1188113,1188776,1189438,1190050,1190613,1191156,1191704,1192203,1192666,1193130,1193629,1194082,1194506,1194912,1195355,1195774,1196173,1196550,1196910,1197274,1197647,1198002,1198322,1198650,1198959,1199254,1199558,1199861,1200147,1200403,1200661,1200913,1201164,1201409,1201639,1201879,1202087,1202331,1202531,1202742,1202936,1203114,
16127,113541,230375,333024,418988,490196,550041,600913,644704,682353,715196,744182,770017,793187,813742,832224,849064,864355,878586,891410,902967,913824,923860,933116,941807,949894,957460,964495,971033,977149,982896,988350,993530,998414,1002946,1007290,1011273,1015310,1018986,1022574,1025906,1029075,1032022,1034873,1037564,1040173,1042570,1044914,1047236,1049502,1051599,1053656,1055575,1057403,1059153,1060845,1062457,1064028,1065482,1066854,1068225,1069540,1070776,1072010,1073169,1074262,1075357,1076392,1077422,1078392,1079284,1080178,1081090,1081904,1082750,1083551,1084285,1084979,1085685,1086359,1087028,1087693,1088295,1088891,1089496,1090061,1090557,1091080,1091552,1092034,1092515,1092970,1093380,1093822,1094250,1094654,1095070,1095459,1095828,1096183,1096557,1096880,1097187,1097556,1097842,1098158,1098445,1098720,1099012,1099268,1099534,1099809,1100043,1100314,1100555,1100790,1101001,1101206,1101423,1101609,
5543,61707,147356,230563,304985,369740,425368,473222,515153,551672,584548,613225,638849,661849,682629,701076,718348,734121,748652,761734,774001,785231,795687,805404,814332,822653,830423,837824,844596,850932,856972,862732,868165,873247,877970,882529,886840,890858,894679,898312,901873,905202,908424,911436,914210,916930,919607,922109,924509,926785,928948,931027,933062,935019,936853,938592,940336,942008,943527,945060,946476,947869,949193,950469,951664,952844,953963,955078,956110,957151,958183,959171,960057,960993,961866,962689,963542,964288,965072,965778,966414,967116,967804,968446,969074,969674,970219,970796,971301,971811,972309,972822,973307,973763,974187,974621,975045,975447,975816,976213,976603,976988,977332,977664,978000,978307,978649,978911,979225,979503,979772,980030,980288,980549,980818,981064,981295,981498,981739,981960,
2704,41350,109839,181790,248847,308774,361238,407225,447321,482906,514639,542828,567795,590510,610817,629603,646655,662384,676700,689948,702351,713534,723977,733493,742436,751028,758979,766394,773338,779787,785937,791818,797202,802322,807179,811825,816151,820240,824227,828081,831735,835165,838335,841462,844405,847162,849853,852370,854805,857239,859452,861669,863748,865726,867608,869458,871174,872858,874477,875990,877508,878892,880338,881684,882880,884158,885350,886434,887580,888613,889640,890623,891565,892492,893413,894225,895069,895895,896688,897385,898117,898848,899527,900176,900777,901396,901998,902559,903081,903634,904109,904615,905129,905622,906054,906495,906901,907311,907701,908120,908533,908914,909293,909655,909997,910325,910632,910947,911233,911552,911823,912093,912375,912661,912935,913175,913440,913660,913886,914122,
1111,25242,77129,136928,195210,248727,296603,339398,377472,411262,441741,468766,493303,515391,535533,553945,570915,586489,600690,613676,626078,637392,648090,657892,667052,675595,683546,691185,698126,704785,711034,717000,722526,727739,732720,737491,741894,746153,750184,754121,757746,761049,764385,767503,770487,773266,776049,778726,781209,783702,785991,788163,790259,792342,794197,796098,797852,799546,801163,802725,804197,805681,807135,808477,809764,811008,812286,813471,814613,815694,816716,817735,818675,819633,820559,821434,822332,823204,824034,824823,825558,826289,826996,827634,828267,828865,829480,830056,830669,831259,831786,832300,832843,833321,833767,834226,834672,835077,835508,835881,836317,836705,837037,837407,837759,838117,838447,838785,839095,839389,839703,839973,840259,840510,840787,841063,841326,841561,841806,842050,
389,13801,49518,96286,144464,190828,233709,272712,307806,339365,367945,393692,417220,438537,458074,475993,492401,507513,521506,534487,546590,557853,568292,578121,587317,595860,603721,611415,618455,625181,631433,637504,643273,648469,653443,658188,662679,666937,670971,674804,678464,682016,685382,688598,691687,694448,697186,699813,702350,704804,707092,709374,711558,713591,715589,717514,719340,721160,722805,724398,725870,727357,728832,730194,731513,732770,733970,735245,736408,737553,738630,739694,740677,741569,742511,743442,744298,745153,745983,746823,747587,748326,749046,749730,750397,751001,751613,752189,752798,753393,753994,754553,755029,755538,756042,756474,756894,757319,757741,758124,758535,758899,759270,759642,759984,760321,760672,761025,761304,761601,761911,762195,762491,762767,763053,763321,763597,763835,764096,764342,
86,6460,28682,61384,98573,136552,172696,206245,237188,265926,292063,315823,337741,357924,376491,393417,409159,423996,437565,450288,461892,472824,483064,492802,501753,510305,518065,525367,532399,539086,545384,551250,556683,561977,566943,571780,576280,580501,584457,588355,591992,595489,598927,602049,605110,607975,610739,613437,615935,618303,620689,622923,625127,627203,629231,631164,633005,634823,636579,638265,639833,641352,642829,644287,645669,646977,648146,649380,650566,651731,652806,653902,654882,655831,656727,657623,658534,659395,660270,661076,661862,662596,663322,664049,664725,665409,666041,666623,667182,667799,668343,668905,669412,669932,670453,670919,671372,671840,672256,672690,673095,673488,673840,674223,674599,674942,675253,675590,675924,676271,676568,676873,677173,677432,677714,677966,678265,678506,678748,679007,
37,3686,19024,44403,74761,106875,138366,168179,196349,222710,247044,269735,290131,309402,327256,343561,358677,372681,385580,397748,409289,420126,430216,439580,448354,456703,464428,471643,478580,485046,491144,496949,502461,507692,512678,517329,521800,525946,529911,533726,537342,540790,544199,547382,550444,553335,556105,558786,561293,563625,566012,568304,570457,572631,574626,576535,578347,580065,581787,583430,585060,586562,588079,589585,590983,592302,593530,594776,595985,597098,598235,599329,600388,601380,602383,603278,604159,605008,605848,606706,607467,608249,608988,609704,610360,611049,611696,612297,612910,613565,614156,614729,615258,615733,616177,616666,617085,617552,618001,618464,618843,619240,619640,620051,620405,620756,621106,621451,621792,622106,622406,622708,623015,623300,623576,623843,624139,624404,624633,624899,
14,1827,11608,29729,53244,79203,106046,132069,156820,180356,202330,222943,241918,259687,276222,291518,305653,318918,331417,343287,354246,364631,374376,383544,392068,400280,407815,414913,421738,428109,434020,439811,445193,450236,455205,459659,464081,468271,472197,475986,479591,483001,486243,489351,492418,495298,498057,500741,503250,505684,508036,510345,512529,514625,516537,518416,520228,522064,523747,525425,527016,528520,530025,531471,532835,534171,535400,536664,537891,539031,540099,541190,542202,543197,544265,545167,546034,546885,547752,548584,549402,550132,550914,551642,552338,553002,553694,554312,554892,555476,556032,556579,557111,557636,558156,558643,559128,559586,560020,560436,560862,561313,561726,562064,562429,562818,563155,563517,563837,564151,564476,564787,565076,565374,565648,565911,566171,566451,566716,566943,
1,787,6314,18417,35593,55651,77153,98973,120255,140586,160259,178561,195901,212169,227313,241587,255068,267666,279277,290400,300792,310420,319440,327994,336152,343859,351048,357874,364376,370309,376206,381910,387175,392155,396898,401344,405634,409671,413510,417212,420877,424268,427472,430603,433646,436511,439261,441853,444336,446711,448925,451122,453167,455167,457201,459085,460900,462625,464336,465976,467555,469006,470491,471884,473298,474584,475928,477156,478344,479523,480627,481698,482712,483725,484679,485617,486527,487387,488258,489067,489902,490686,491419,492133,492819,493488,494135,494791,495460,496062,496663,497201,497766,498294,498785,499284,499746,500246,500667,501113,501588,501970,502361,502725,503093,503461,503806,504169,504475,504800,505096,505416,505729,506011,506311,506586,506884,507180,507427,507671,
0,304,2992,10106,21303,35670,51815,69098,86294,103441,120053,135937,150913,165282,178696,191484,203427,214739,225524,235876,245509,254311,262828,270981,278736,285775,292587,299050,305247,310985,316442,321618,326690,331526,336049,340298,344426,348428,352141,355729,359140,362489,365591,368686,371666,374402,377001,379601,381986,384368,386568,388763,390819,392831,394814,396576,398285,399960,401641,403206,404752,406243,407666,409025,410388,411680,412931,414141,415303,416404,417455,418504,419544,420520,421522,422444,423387,424240,425084,425921,426723,427446,428192,428912,429601,430275,430926,431517,432097,432719,433312,433886,434420,434909,435455,435902,436376,436822,437257,437685,438122,438551,438970,439373,439742,440087,440425,440775,441085,441404,441728,442004,442299,442603,442895,443159,443436,443714,443954,444228,
0,73,1118,4688,11243,20438,31429,43782,56935,70118,83237,96203,108490,120428,131878,142703,153097,162946,172502,181484,190209,198236,206062,213429,220457,227030,233237,239325,245045,250450,255613,260484,265069,269604,273772,277845,281720,285445,289004,292388,295650,298775,301720,304535,307256,309926,312551,315038,317426,319705,321819,323886,325859,327806,329645,331388,333137,334809,336435,337977,339416,340887,342280,343700,345069,346275,347510,348734,349826,350886,351943,353001,353976,354927,355806,356684,357542,358376,359181,359954,360760,361488,362202,362875,363548,364200,364846,365433,366047,366638,367210,367761,368295,368771,369251,369764,370243,370686,371120,371567,371942,372367,372783,373135,373528,373849,374149,374491,374831,375145,375451,375739,376048,376338,376623,376901,377159,377433,377691,377968,
0,24,414,2031,5593,11137,18264,27041,36304,46302,56139,66282,76209,85875,95414,104450,113373,121809,130005,137722,145289,152415,159277,165760,172069,178192,183954,189257,194495,199376,204185,208460,212758,216838,220824,224520,228139,231612,234847,238040,241129,244154,247062,249721,252288,254785,257193,259566,261729,263893,265876,267858,269734,271556,273353,275055,276683,278251,279816,281204,282673,284070,285391,286702,287924,289141,290294,291412,292521,293597,294565,295525,296527,297510,298387,299242,300119,300925,301651,302375,303086,303815,304545,305229,305862,306443,307058,307684,308297,308877,309404,309931,310470,310935,311403,311872,312358,312792,313201,313654,314067,314467,314833,315200,315570,315903,316211,316541,316859,317155,317481,317783,318080,318364,318651,318924,319196,319458,319694,319923,
0,2,100,693,2253,5008,9149,14345,20314,26897,33914,41122,48405,55734,62764,69938,76688,83468,90063,96401,102488,108507,114140,119623,124883,129874,134788,139522,143973,148263,152415,156311,160236,163865,167340,170779,174113,177240,180301,183155,185969,188622,191144,193591,195898,198150,200329,202452,204556,206533,208429,210270,211993,213649,215235,216858,218359,219887,221294,222664,224011,225328,226602,227810,228991,230090,231166,232203,233225,234168,235138,236087,237042,237953,238776,239549,240306,241108,241895,242574,243246,243907,244581,245246,245881,246485,247081,247654,248221,248755,249279,249803,250302,250769,251242,251658,252130,252582,252993,253409,253802,254173,254541,254885,255214,255553,255901,256188,256485,256787,257098,257392,257659,257933,258224,258463,258687,258941,259179,259436,
0,0,11,128,566,1631,3393,5799,8857,12536,16754,21166,25785,30531,35385,40208,45094,50040,54887,59639,64347,68821,73140,77464,81675,85719,89592,93309,96900,100384,103784,107052,110143,113117,115942,118668,121410,124081,126740,129123,131447,133722,135938,138161,140180,142215,144114,145983,147682,149393,151117,152687,154174,155716,157145,158537,159877,161159,162495,163664,164834,165965,167086,168182,169251,170245,171218,172179,173125,174026,174900,175698,176479,177279,178025,178791,179530,180248,180921,181573,182218,182876,183503,184090,184688,185242,185795,186311,186841,187332,187796,188285,188748,189187,189611,190039,190423,190831,191246,191640,192022,192379,192742,193071,193385,193706,194007,194288,194582,194857,195092,195368,195628,195897,196128,196350,196579,196821,197062,197277,
0,0,0,17,74,277,670,1354,2343,3674,5310,7289,9544,11945,14436,17110,19807,22606,25511,28376,31272,34205,36977,39774,42402,45114,47807,50362,52976,55419,57789,60159,62386,64602,66758,68883,70978,72924,74832,76701,78535,80298,82035,83625,85227,86808,88296,89879,91272,92642,94030,95379,96645,97876,99058,100253,101373,102436,103439,104444,105431,106392,107312,108175,109062,109895,110718,111508,112276,113046,113734,114470,115140,115822,116450,117100,117718,118331,118893,119458,119971,120458,120973,121451,121924,122394,122829,123302,123770,124226,124606,125015,125434,125812,126179,126539,126879,127212,127532,127878,128188,128475,128773,129048,129315,129606,129877,130145,130388,130635,130874,131128,131345,131568,131779,131964,132153,132384,132589,132780,
159250,421323,606260,735342,830565,903521,961991,1009231,1048872,1082061,1110397,1135330,1157002,1176060,1192986,1208451,1222340,1234853,1246191,1256516,1266012,1274688,1282677,1290252,1297240,1303640,1309470,1315050,1320289,1325303,1329849,1334251,1338338,1342147,1345745,1349274,1352468,1355513,1358426,1361213,1363760,1366264,1368521,1370791,1372896,1374977,1376917,1378798,1380609,1382277,1383945,1385433,1386911,1388296,1389676,1390967,1392211,1393393,1394537,1395617,1396651,1397635,1398584,1399548,1400475,1401305,1402147,1402954,1403735,1404474,1405200,1405886,1406602,1407233,1407835,1408410,1409026,1409612,1410114,1410646,1411153,1411664,1412119,1412562,1412987,1413404,1413813,1414208,1414590,1414967,1415320,1415671,1416013,1416340,1416656,1416985,1417307,1417582,1417852,1418133,1418412,1418675,1418938,1419189,1419424,1419639,1419861,1420073,1420291,1420500,1420691,1420901,1421096,1421288,1421463,1421617,1421775,1421944,1422094,1422267,
77453,273803,436890,559234,652850,726435,786179,835816,877357,912926,943371,970001,993078,1013869,1032490,1048798,1063802,1077297,1089618,1100956,1111380,1120985,1129794,1137961,1145595,1152617,1159203,1165430,1171194,1176586,1181492,1186251,1190758,1195052,1198870,1202588,1206143,1209490,1212804,1215838,1218665,1221273,1223909,1226407,1228679,1230941,1233057,1235022,1236969,1238788,1240600,1242311,1243923,1245412,1246900,1248300,1249722,1251083,1252346,1253543,1254731,1255870,1256930,1257993,1258970,1259908,1260832,1261721,1262641,1263499,1264324,1265090,1265845,1266591,1267306,1267946,1268601,1269218,1269837,1270404,1270951,1271488,1272009,1272533,1273026,1273527,1274025,1274472,1274887,1275304,1275731,1276140,1276523,1276853,1277233,1277588,1277923,1278240,1278580,1278890,1279167,1279446,1279756,1280039,1280303,1280559,1280804,1281071,1281292,1281529,1281754,1281972,1282211,1282426,1282600,1282793,1282993,1283173,1283347,1283525,
46160,201755,347800,463309,554060,626950,686395,736331,778100,814259,845461,873057,896989,918260,937244,954397,969787,983903,996843,1008662,1019475,1029396,1038705,1047110,1055014,1062312,1069069,1075461,1081475,1087101,1092472,1097426,1102073,1106408,1110568,1114544,1118221,1121761,1125099,1128309,1131305,1134234,1136974,1139622,1142149,1144562,1146868,1149031,1151059,1153034,1155005,1156790,1158505,1160141,1161769,1163246,1164747,1166165,1167545,1168823,1170070,1171201,1172312,1173429,1174452,1175445,1176382,1177378,1178311,1179257,1180095,1180884,1181642,1182438,1183168,1183879,1184561,1185212,1185870,1186486,1187103,1187696,1188228,1188756,1189316,1189824,1190317,1190773,1191212,1191627,1192052,1192449,1192844,1193256,1193655,1193992,1194343,1194696,1194987,1195364,1195673,1195975,1196262,1196553,1196812,1197091,1197365,1197619,1197870,1198131,1198361,1198588,1198809,1199060,1199284,1199490,1199683,1199868,1200075,1200262,
23220,135823,259047,363644,448401,518412,576499,625325,667174,703252,734590,762390,787292,809485,829144,846715,862601,877237,890616,902916,914185,924457,933965,942892,951165,958939,966183,972793,979010,985010,990539,995643,1000596,1005191,1009561,1013679,1017530,1021154,1024690,1028087,1031272,1034259,1037159,1039973,1042596,1045044,1047431,1049656,1051831,1053950,1055921,1057854,1059678,1061442,1063187,1064813,1066357,1067781,1069212,1070554,1071799,1073085,1074224,1075411,1076507,1077568,1078614,1079609,1080593,1081507,1082369,1083208,1084050,1084853,1085692,1086456,1087237,1087969,1088697,1089389,1090016,1090641,1091201,1091753,1092298,1092810,1093347,1093869,1094330,1094791,1095227,1095676,1096104,1096505,1096896,1097273,1097666,1098009,1098392,1098726,1099085,1099386,1099703,1100026,1100334,1100638,1100915,1101167,1101444,1101700,1101958,1102192,1102438,1102665,1102905,1103135,1103327,1103526,1103724,1103911,
9042,78681,172426,260078,335627,400276,454952,502025,542777,578304,609495,637366,661851,684136,703833,721513,737933,752947,766750,779492,791269,801997,811879,821315,829929,837932,845469,852402,858785,864907,870633,876034,881188,886036,890698,895105,899198,903092,906757,910301,913651,916787,919897,922828,925486,928069,930561,932939,935303,937498,939620,941708,943596,945420,947183,948892,950549,952129,953631,955039,956376,957700,958955,960184,961411,962548,963639,964680,965701,966705,967662,968549,969403,970257,971100,971938,972712,973479,974222,974910,975585,976266,976879,977488,978037,978657,979223,979759,980285,980763,981243,981683,982091,982547,982960,983358,983757,984145,984508,984870,985260,985606,985952,986269,986597,986909,987197,987506,987772,988052,988310,988562,988813,989058,989298,989567,989798,989988,990208,990424,
4936,55109,133077,210081,279524,339939,392018,437281,476899,511804,542579,570030,594351,616233,636015,653880,670212,685302,699051,711628,723518,734380,744390,753630,762383,770620,778270,785286,791843,798145,804111,809657,814950,819884,824549,828915,833038,837080,840852,844453,847879,851123,854274,857276,860100,862675,865270,867712,870042,872221,874366,876420,878374,880203,882003,883783,885464,887024,888619,890048,891458,892860,894163,895390,896581,897751,898882,899946,900985,901982,902955,903924,904806,905658,906503,907356,908116,908887,909657,910391,911097,911787,912476,913133,913703,914301,914849,915396,915948,916463,916951,917439,917931,918415,918851,919289,919729,920124,920510,920896,921283,921641,921970,922325,922647,922938,923246,923523,923801,924100,924362,924636,924911,925175,925440,925661,925924,926169,926376,926584,
2233,35676,96895,162337,223816,278650,327694,370596,408431,441652,471449,498100,521826,543463,563162,581145,597493,612528,626361,639285,650939,661647,671721,681087,689873,698111,705849,712880,719570,725976,732056,737717,743221,748362,752991,757487,761696,765738,769552,773160,776687,780092,783246,786315,789165,791810,794439,796959,799341,801605,803752,805858,807800,809811,811686,813540,815237,816923,818448,819953,821387,822737,824146,825437,826656,827837,828956,830079,831163,832177,833212,834181,835084,836013,836889,837743,838543,839315,840141,840883,841589,842278,842979,843588,844222,844843,845440,845998,846546,847083,847573,848051,848539,849043,849502,849936,850368,850798,851182,851565,851933,852304,852661,853010,853338,853663,853990,854310,854599,854901,855194,855471,855740,856009,856273,856537,856788,857009,857236,857449,
855,20758,65255,117820,170228,218679,262627,302119,337714,369072,397384,423032,445786,466852,485950,503402,519196,534204,547925,560755,572735,583435,593438,602825,611463,619609,627408,634746,641644,648090,654185,659995,665406,670473,675192,679816,684097,688193,692137,695767,699259,702603,705891,708964,711905,714666,717265,719827,722347,724608,726806,728928,730978,732925,734818,736697,738399,740036,741654,743152,744688,746097,747535,748923,750164,751427,752545,753754,754855,755918,756919,757985,758942,759816,760714,761582,762406,763206,764036,764788,765545,766233,766925,767598,768269,768870,769495,770064,770584,771121,771648,772157,772668,773180,773665,774101,774567,774958,775359,775767,776178,776534,776896,777234,777555,777893,778221,778543,778829,779153,779453,779693,779978,780256,780546,780809,781047,781282,781505,781741,
263,10505,39354,78653,120496,161287,199542,234518,266569,295696,322426,346603,368239,388201,406454,423309,438759,452981,466312,478603,490097,500733,510636,519899,528531,536765,544224,551436,558359,564645,570641,576262,581434,586544,591384,596017,600192,604353,608293,612101,615646,619112,622441,625592,628434,631286,633910,636504,638920,641243,643514,645776,647902,649896,651815,653646,655385,657107,658772,660390,661882,663298,664751,666106,667412,668665,669882,671095,672256,673362,674456,675502,676452,677344,678293,679161,680023,680838,681611,682398,683192,683913,684622,685281,685886,686554,687176,687775,688346,688903,689435,689948,690448,690967,691451,691927,692361,692815,693238,693693,694105,694506,694867,695234,695568,695907,696231,696555,696863,697158,697466,697757,698058,698343,698595,698865,699152,699403,699624,699841,
91,6129,27171,58338,93683,129030,163081,194661,223939,251036,275876,298667,319462,338708,356188,372383,387641,401310,414470,426363,437613,448036,457523,466617,475151,483109,490632,497643,504315,510687,516798,522460,527808,532897,537741,542309,546560,550591,554559,558297,561733,565141,568363,571579,574540,577397,580076,582688,585071,587361,589610,591768,593891,595961,597837,599667,601416,603104,604804,606349,607870,609284,610725,612153,613507,614790,615992,617160,618334,619420,620518,621558,622556,623531,624449,625286,626135,626959,627719,628515,629337,630088,630791,631475,632171,632791,633445,634069,634663,635205,635751,636286,636797,637300,637751,638216,638616,639064,639470,639892,640312,640698,641081,641436,641771,642097,642445,642766,643097,643415,643728,644035,644322,644571,644842,645110,645357,645586,645819,646063,
38,3365,17551,40827,68857,98491,127700,155728,182489,207086,229901,250900,270443,288478,305256,320722,335033,348329,360702,372324,383259,393403,402918,411806,420074,428033,435479,442418,448997,455240,461050,466600,471870,476923,481726,486124,490494,494549,498325,502063,505522,508867,512093,515192,518162,520865,523675,526306,528765,531100,533435,535653,537721,539724,541601,543407,545210,546970,548618,550238,551794,553236,554663,556019,557350,558621,559849,561065,562226,563316,564432,565493,566564,567518,568461,569368,570196,571040,571880,572697,573456,574201,574955,575654,576265,576930,577584,578164,578695,579292,579843,580398,580917,581405,581873,582362,582831,583282,583709,584148,584566,584978,585355,585722,586096,586408,586755,587084,587392,587719,588013,588306,588615,588912,589199,589481,589747,589984,590233,590481,
6,1585,10275,26282,47316,70856,95340,119242,142315,164178,184784,203916,221677,238410,253831,268488,281964,294562,306214,317347,327569,337225,346371,354885,362990,370553,377680,384473,390871,396858,402525,407943,413094,417974,422760,427135,431362,435383,439168,442764,446184,449544,452772,455811,458698,461439,464128,466671,469094,471385,473578,475741,477772,479820,481796,483579,485327,487028,488731,490364,491887,493338,494735,496202,497454,498655,499844,501043,502245,503385,504466,505542,506563,507535,508513,509417,510285,511142,511987,512777,513573,514280,515006,515683,516335,517011,517694,518313,518931,519504,519992,520583,521089,521570,522097,522561,523033,523472,523920,524373,524800,525197,525541,525904,526250,526597,526940,527286,527591,527900,528199,528482,528756,529041,529323,529614,529886,530161,530408,530665,
1,657,5124,15222,29952,47687,66611,86017,105025,123565,141378,158337,174000,189123,203317,216628,229069,240582,251574,261867,271578,280725,289074,297187,304737,311890,318522,325048,331237,337094,342409,347706,352590,357320,361843,366082,370268,374158,377890,381293,384660,387810,390894,393888,396716,399436,402044,404502,406930,409253,411404,413515,415523,417522,419471,421350,423089,424752,426359,427964,429460,430937,432335,433712,435017,436316,437614,438828,439928,441017,442028,443076,444040,445009,445949,446822,447713,448523,449312,450099,450848,451585,452263,452981,453604,454298,454959,455588,456183,456762,457333,457897,458394,458881,459415,459864,460273,460711,461121,461550,461969,462392,462728,463080,463447,463768,464104,464431,464771,465059,465397,465701,465980,466257,466563,466828,467098,467382,467630,467859,
1,185,2060,7370,16382,27995,41448,55994,70839,85519,100054,114088,127289,140199,152342,163845,174841,185330,195124,204510,213401,221671,229460,236964,244073,250705,257110,263134,268874,274426,279468,284393,289053,293440,297736,301849,305710,309381,312946,316290,319534,322622,325532,328425,331214,333910,336418,338881,341181,343424,345576,347657,349635,351497,353348,355106,356793,358456,360005,361529,362988,364396,365791,367166,368440,369692,370857,372076,373178,374310,375348,376317,377230,378192,379097,379916,380790,381642,382362,383092,383845,384589,385297,385997,386656,387299,387929,388548,389131,389676,390269,390791,391331,391820,392310,392785,393240,393662,394061,394474,394854,395240,395632,396025,396364,396723,397065,397415,397721,398044,398350,398623,398922,399215,399514,399799,400048,400309,400552,400776,
0,47,854,3581,8764,16115,25268,35636,46628,57958,69463,80701,91664,102548,112854,122762,131948,140923,149436,157603,165295,172627,179787,186526,192937,198965,204750,210348,215628,220816,225668,230138,234487,238570,242532,246340,249991,253512,256778,259916,263067,265904,268669,271293,273866,276405,278738,281103,283246,285379,287311,289265,291171,292966,294742,296485,298175,299722,301290,302720,304108,305477,306849,308118,309339,310598,311748,312829,313885,314835,315853,316792,317727,318658,319494,320316,321142,321926,322676,323434,324132,324848,325551,326240,326902,327509,328147,328781,329403,329943,330474,331002,331503,332004,332504,333000,333436,333918,334345,334749,335106,335494,335889,336245,336572,336916,337228,337566,337866,338189,338481,338776,339076,339352,339634,339914,340191,340451,340712,340937,
0,4,236,1185,3592,7658,13017,19682,27089,35129,43268,51489,59858,68131,76092,83912,91482,98862,105973,112619,119188,125607,131622,137363,142870,148213,153302,158273,163070,167448,171638,175790,179672,183449,186937,190360,193675,196828,199831,202689,205555,208239,210877,213364,215759,218001,220235,222403,224419,226335,228181,230076,231843,233511,235108,236710,238272,239789,241224,242571,243916,245257,246467,247649,248828,250018,251127,252148,253201,254215,255163,255999,256889,257730,258549,259360,260150,260923,261679,262377,263057,263737,264417,265031,265632,266187,266784,267344,267890,268421,268907,269443,269914,270402,270865,271315,271732,272151,272597,273000,273414,273796,274157,274513,274841,275160,275496,275829,276138,276427,276736,277045,277312,277601,277843,278076,278321,278557,278805,279047,
0,2,35,286,1073,2628,5185,8371,12470,17036,21985,27127,32566,37989,43557,49048,54541,60086,65526,70885,75949,80734,85520,90067,94470,98563,102691,106668,110419,114203,117770,121254,124375,127574,130570,133486,136356,139064,141666,144247,146626,149011,151363,153551,155637,157688,159663,161507,163340,165010,166725,168383,169975,171487,172932,174311,175679,176971,178246,179534,180700,181813,182983,184102,185226,186232,187243,188188,189142,189988,190823,191656,192464,193266,194006,194785,195495,196203,196888,197489,198174,198800,199386,199979,200511,201065,201580,202106,202635,203133,203644,204102,204537,204966,205398,205799,206206,206583,206949,207323,207740,208053,208390,208707,209020,209336,209607,209929,210218,210507,210756,211020,211296,211567,211795,212039,212271,212484,212722,212925,
0,0,1,24,155,504,1130,2173,3600,5433,7543,10047,12743,15593,18703,21871,25030,28246,31651,34884,38107,41365,44535,47561,50643,53536,56441,59295,62093,64712,67277,69815,72242,74578,76915,79137,81242,83399,85414,87415,89332,91179,93022,94736,96375,98063,99634,101184,102610,104012,105359,106699,107974,109151,110320,111530,112677,113787,114817,115900,116888,117838,118775,119696,120584,121500,122341,123125,123918,124664,125366,126056,126797,127505,128173,128755,129391,129985,130546,131106,131670,132209,132738,133244,133767,134237,134690,135146,135602,136037,136419,136849,137224,137606,137970,138350,138698,139044,139378,139737,140055,140355,140668,140962,141244,141551,141797,142074,142335,142547,142793,143012,143230,143445,143676,143930,144136,144344,144560,144746,
13083,138099,312096,471520,606486,718375,811943,890874,957113,1013928,1062186,1104462,1140868,1173019,1201515,1227325,1250079,1270550,1288827,1305505,1320507,1334305,1346840,1358433,1369071,1378649,1387481,1395626,1403366,1410592,1417216,1423414,1429256,1434519,1439574,1444083,1448425,1452448,1456248,1459755,1463119,1466372,1469456,1472364,1475122,1477720,1480096,1482385,1484535,1486558,1488459,1490273,1491974,1493653,1495177,1496632,1497996,1499383,1500690,1501891,1503026,1504096,1505109,1506118,1507089,1508024,1508977,1509800,1510593,1511325,1512068,1512784,1513454,1514136,1514731,1515322,1515890,1516400,1516920,1517403,1517887,1518332,1518763,1519176,1519586,1519987,1520365,1520730,1521061,1521391,1521721,1522010,1522328,1522619,1522897,1523167,1523433,1523685,1523937,1524163,1524384,1524596,1524829,1525004,1525206,1525389,1525561,1525753,1525917,1526074,1526213,1526369,1526544,1526705,1526840,1526958,1527075,1527202,1527314,1527447,
863,32939,113375,212075,309868,399492,479375,549686,611839,667034,715234,758415,796473,830342,860690,888093,912772,935140,955317,973847,990766,1006171,1020473,1033590,1045622,1056597,1066961,1076332,1085250,1093427,1101140,1108340,1115053,1121276,1127184,1132697,1137844,1142626,1147239,1151497,1155478,1159220,1162731,1166089,1169342,1172404,1175176,1177881,1180412,1182865,1185157,1187334,1189429,1191464,1193394,1195175,1196841,1198436,1199925,1201481,1202939,1204244,1205503,1206774,1207943,1208982,1209996,1211045,1212019,1212955,1213844,1214703,1215519,1216332,1217050,1217767,1218488,1219171,1219788,1220413,1221019,1221526,1222105,1222636,1223160,1223629,1224078,1224535,1224960,1225385,1225799,1226217,1226622,1226997,1227354,1227714,1228014,1228335,1228609,1228887,1229153,1229416,1229688,1229932,1230156,1230381,1230613,1230848,1231098,1231317,1231516,1231738,1231908,1232094,1232268,1232429,1232590,1232746,1232904,1233042,
104,11171,52934,116271,186826,256847,322799,382976,437593,487260,532010,572004,608345,641118,670427,697401,721734,743890,764232,782614,799607,815153,829685,843026,855379,866881,877444,887244,896395,905058,912800,920242,926967,933540,939635,945383,950699,955767,960641,965241,969460,973497,977251,980832,984225,987454,990598,993527,996260,998960,1001463,1003840,1005992,1008125,1010083,1011963,1013748,1015543,1017215,1018823,1020397,1021799,1023229,1024538,1025857,1027049,1028227,1029362,1030408,1031451,1032421,1033408,1034295,1035209,1036052,1036838,1037636,1038350,1039078,1039753,1040372,1041002,1041606,1042162,1042737,1043277,1043806,1044289,1044744,1045210,1045676,1046096,1046504,1046881,1047279,1047645,1048028,1048377,1048707,1049028,1049314,1049604,1049927,1050168,1050435,1050696,1050929,1051178,1051404,1051618,1051833,1052066,1052279,1052463,1052657,1052817,1052994,1053168,1053306,1053468,
9,2588,18774,51237,94321,141893,190094,236557,280887,322199,360179,395110,427010,456493,483376,508240,531080,551986,571391,589402,605734,621045,635134,648141,660355,671674,682232,692173,701398,709893,717902,725564,732497,739102,745388,751289,756763,761963,766749,771344,775604,779733,783662,787374,790944,794273,797498,800513,803290,806064,808629,811122,813455,815689,817785,819820,821739,823566,825301,826995,828660,830169,831656,833076,834384,835647,836874,838104,839235,840344,841405,842447,843416,844296,845218,846073,846877,847630,848370,849088,849740,850442,851063,851686,852303,852918,853468,853989,854488,854997,855503,855943,856389,856822,857229,857632,858036,858405,858735,859077,859423,859758,860096,860373,860658,860920,861210,861456,861725,861950,862198,862412,862646,862861,863065,863270,863460,863649,863810,864011,
0,396,5000,17890,39130,65686,95787,126811,158099,188497,217503,245019,270787,294963,317694,338672,358384,376892,393903,409946,424664,438429,451233,463249,474614,484953,494704,504103,512799,520815,528488,535749,542601,548984,555017,560697,566041,571203,576005,580678,584993,589062,592969,596536,600002,603293,606506,609541,612310,615064,617626,620128,622444,624658,626821,628938,630787,632644,634453,636183,637895,639381,640892,642372,643727,645002,646250,647490,648643,649720,650760,651783,652752,653710,654540,655398,656277,657064,657861,658585,659259,659965,660642,661261,661865,662490,663034,663567,664132,664641,665092,665615,666053,666468,666865,667268,667614,667980,668338,668709,669073,669430,669741,670057,670364,670649,670946,671205,671457,671723,671967,672197,672421,672648,672856,673066,673289,673488,673667,673854,
0,121,2167,9276,22617,41189,63058,86958,111705,136081,160073,183263,205408,226544,246494,265127,282441,298764,314117,328528,342103,354999,366885,378085,388760,398790,407944,416610,424897,432759,440049,446961,453459,459554,465417,470931,476106,480924,485528,489959,494165,498087,501829,505408,508848,512071,515220,518032,520897,523537,526089,528536,530840,533008,535058,537068,538962,540819,542629,544331,545861,547494,549030,550421,551791,553093,554338,555532,556725,557836,558939,559964,560959,561903,562848,563731,564551,565358,566112,566868,567581,568289,568966,569612,570231,570851,571427,571995,572528,573036,573532,574015,574496,574902,575321,575733,576115,576510,576882,577234,577586,577899,578217,578540,578836,579131,579386,579647,579915,580148,580394,580639,580868,581084,581281,581506,581701,581886,582062,582262,
0,29,846,4362,12207,23948,38939,55886,74313,93395,112484,131492,149723,167302,184158,200231,215406,229857,243772,256778,269233,280664,291307,301593,311372,320572,329273,337355,345080,352382,359213,365716,371857,377541,383154,388384,393307,397987,402381,406544,410520,414271,417844,421193,424533,427727,430650,433473,436217,438685,441176,443538,445802,447918,449903,451886,453779,455618,457310,458856,460456,461942,463392,464740,466055,467394,468646,469812,470911,472040,473072,474059,475065,475994,476852,477681,478509,479313,480044,480768,481476,482133,482802,483421,484058,484658,485201,485719,486279,486778,487266,487747,488241,488658,489072,489524,489913,490255,490627,490971,491339,491692,491992,492300,492586,492883,493167,493440,493688,493947,494205,494443,494686,494909,495121,495352,495526,495719,495903,496074,
0,8,271,1842,5947,12897,22491,34132,47185,61098,75689,90293,104750,118862,132627,145822,158654,170835,182572,193739,204308,214558,223874,232881,241413,249538,257321,264686,271670,278323,284496,290337,295990,301378,306528,311377,315856,320278,324493,328367,332270,335777,339135,342347,345537,348555,351487,354108,356606,359107,361440,363624,365767,367838,369804,371677,373500,375239,376925,378498,380044,381456,382832,384169,385475,386769,387976,389183,390288,391330,392346,393309,394216,395069,395938,396787,397592,398396,399100,399819,400502,401191,401822,402485,403096,403680,404237,404787,405315,405826,406321,406763,407182,407644,408052,408455,408862,409236,409618,409941,410270,410606,410922,411236,411531,411803,412102,412369,412626,412854,413100,413327,413578,413810,414022,414216,414380,414600,414793,414988,
0,1,68,677,2468,6141,11644,18844,27378,37157,47400,57852,68623,79492,90242,100731,111077,121113,130669,139930,149030,157671,165898,173642,181039,188211,195002,201232,207408,213173,218676,224005,229095,233781,238391,242670,246793,250825,254588,258128,261446,264701,267867,270834,273729,276465,278996,281472,283761,286148,288271,290312,292350,294267,296084,297845,299514,301103,302579,304060,305520,306892,308254,309536,310761,311981,313108,314199,315241,316236,317159,318044,318911,319722,320521,321282,322023,322739,323468,324149,324829,325463,326085,326677,327241,327796,328328,328832,329328,329856,330340,330785,331227,331639,332053,332471,332835,333209,333576,333928,334258,334584,334913,335246,335560,335802,336054,336320,336568,336807,337019,337236,337443,337655,337858,338067,338275,338451,338628,338798,
0,0,40,326,1342,3562,7226,12278,18679,25973,33938,42413,51155,60207,69142,78159,86938,95506,103885,111968,119836,127417,134647,141740,148265,154619,160614,166626,172117,177484,182532,187421,192082,196460,200554,204427,208319,212033,215562,218930,222218,225283,228327,231251,233986,236474,238911,241367,243590,245697,247736,249732,251645,253425,255121,256759,258417,259978,261437,262836,264191,265571,266806,268067,269276,270388,271473,272509,273595,274550,275495,276393,277248,278078,278878,279643,280399,281128,281826,282472,283099,283671,284280,284876,285441,285958,286484,287001,287480,287917,288353,288774,289168,289601,289998,290342,290737,291118,291430,291764,292084,292400,292707,293016,293331,293601,293890,294135,294366,294609,294825,295037,295247,295458,295669,295832,296014,296206,296379,296534,
0,0,11,125,680,1915,4233,7639,12151,17483,23457,29956,37041,44183,51403,58768,66009,73212,80428,87243,94001,100426,106699,112805,118659,124207,129811,135105,140207,144922,149479,153854,158103,162143,165882,169482,173042,176334,179549,182591,185530,188322,191122,193773,196362,198757,201132,203334,205482,207461,209328,211174,212903,214643,216334,217933,219363,220796,222175,223573,224875,226062,227236,228351,229489,230521,231534,232524,233456,234356,235224,236059,236832,237586,238358,239091,239796,240472,241104,241733,242319,242883,243454,244006,244522,245017,245526,245996,246477,246945,247406,247827,248228,248663,249068,249426,249778,250134,250465,250771,251074,251378,251690,251952,252218,252471,252745,253011,253233,253473,253686,253901,254093,254304,254499,254700,254885,255048,255207,255383,
0,0,5,57,306,1010,2343,4528,7535,11202,15627,20411,25658,31122,36840,42675,48568,54317,60020,65932,71560,76945,82198,87382,92389,97365,102030,106653,110990,115210,119249,123179,126906,130512,133993,137256,140456,143554,146490,149280,151945,154432,156956,159416,161634,163835,165995,168064,169920,171854,173651,175397,177011,178593,180097,181549,182983,184326,185633,186874,188033,189170,190231,191273,192296,193279,194250,195139,196023,196920,197792,198610,199389,200116,200847,201529,202237,202875,203511,204079,204648,205181,205724,206270,206731,207202,207634,208068,208527,208965,209390,209759,210136,210513,210870,211217,211546,211854,212176,212485,212802,213081,213338,213605,213851,214099,214333,214561,214788,215004,215213,215425,215633,215829,215998,216186,216361,216556,216742,216902,
0,0,0,23,136,467,1207,2460,4217,6561,9538,12935,16743,20865,25054,29409,33956,38625,43316,47914,52445,56923,61198,65543,69842,73950,77866,81685,85384,88949,92414,95656,98816,101965,105017,107873,110651,113385,116055,118510,120854,123153,125381,127521,129591,131515,133430,135258,137009,138708,140301,141931,143474,144871,146255,147614,148892,150044,151252,152426,153511,154533,155557,156536,157521,158460,159343,160163,160963,161772,162546,163265,164003,164673,165333,166006,166600,167153,167708,168274,168832,169352,169865,170373,170843,171289,171764,172213,172616,173034,173438,173826,174170,174518,174846,175174,175527,175805,176077,176385,176668,176961,177210,177458,177691,177922,178128,178326,178536,178743,178948,179149,179339,179499,179694,179856,180027,180183,180313,180473,
0,0,0,3,40,174,538,1177,2197,3575,5399,7461,9887,12592,15548,18693,22001,25330,28900,32367,35781,39316,42733,46210,49571,52885,56126,59244,62335,65276,68176,71058,73832,76408,78901,81332,83723,85978,88181,90372,92512,94461,96385,98243,100058,101721,103401,105042,106540,108014,109414,110772,112053,113348,114576,115787,116898,118031,119153,120200,121174,122119,123022,123924,124867,125715,126486,127265,128004,128709,129372,130060,130714,131343,131966,132525,133093,133613,134183,134705,135170,135657,136144,136594,137043,137458,137905,138291,138646,138992,139362,139698,140040,140377,140706,141028,141328,141588,141879,142151,142411,142644,142881,143091,143312,143505,143732,143923,144103,144291,144473,144662,144847,145018,145149,145299,145463,145624,145762,145921,
0,0,0,4,16,71,244,592,1097,1940,3031,4336,5911,7761,9756,11961,14231,16692,19270,21974,24521,27143,29731,32501,35140,37826,40372,42942,45267,47763,50118,52413,54646,56835,58900,60957,63029,64965,66875,68760,70545,72363,74045,75626,77219,78757,80204,81579,82926,84201,85501,86713,87843,88958,90040,91079,92048,93030,93998,94927,95817,96672,97489,98256,99019,99833,100538,101261,101908,102584,103246,103839,104399,104991,105577,106162,106685,107207,107699,108178,108623,109064,109526,109911,110278,110641,111056,111442,111817,112120,112462,112801,113082,113392,113632,113901,114161,114402,114644,114871,115090,115338,115575,115840,116051,116248,116445,116636,116824,116976,117146,117296,117447,117590,117725,117865,118022,118164,118282,118411,
0,0,0,0,5,21,92,224,476,827,1404,2144,3047,4105,5366,6752,8237,9815,11514,13357,15219,17161,18996,20866,22764,24743,26709,28625,30563,32442,34305,36097,37853,39579,41294,42936,44603,46185,47784,49276,50785,52200,53591,54917,56188,57404,58625,59719,60778,61901,62982,64020,64990,65946,66916,67825,68644,69477,70311,71091,71839,72578,73353,74049,74708,75348,75991,76596,77207,77725,78317,78871,79373,79848,80320,80798,81259,81710,82113,82493,82872,83263,83654,84025,84368,84732,85050,85370,85700,85968,86292,86590,86851,87102,87369,87633,87838,88058,88263,88478,88668,88890,89088,89280,89468,89645,89809,89956,90118,90293,90457,90607,90740,90903,91047,91178,91304,91444,91555,91668,
0,0,0,0,0,2,11,44,107,261,510,826,1233,1791,2419,3200,4077,4983,6016,7117,8276,9417,10688,11964,13239,14513,15829,17206,18462,19794,21148,22385,23598,24880,26132,27392,28657,29842,30976,32074,33206,34329,35374,36350,37374,38335,39281,40184,41101,41981,42759,43606,44393,45116,45855,46542,47240,47892,48539,49187,49779,50398,51035,51561,52109,52666,53209,53718,54221,54691,55194,55625,56070,56462,56856,57260,57633,57991,58320,58653,59022,59321,59606,59925,60200,60506,60812,61103,61359,61637,61881,62147,62398,62637,62864,63086,63277,63449,63673,63853,64033,64219,64404,64575,64740,64901,65057,65211,65353,65491,65627,65741,65862,65989,66098,66202,66285,66403,66489,66596,
0,0,0,0,0,0,2,10,31,63,128,230,366,524,759,1058,1433,1846,2323,2852,3433,4047,4684,5369,6071,6771,7486,8257,9033,9854,10612,11394,12177,12970,13733,14501,15265,16021,16753,17517,18241,18982,19666,20337,20992,21685,22350,22969,23584,24185,24793,25377,25948,26481,27087,27629,28126,28624,29102,29586,30039,30471,30917,31353,31780,32179,32568,32943,33278,33642,33978,34327,34640,34960,35271,35566,35839,36121,36388,36636,36888,37127,37390,37616,37818,38036,38257,38461,38667,38878,39073,39270,39464,39644,39825,40014,40193,40357,40530,40707,40855,40989,41123,41276,41391,41509,41619,41731,41848,41980,42082,42197,42295,42403,42503,42615,42699,42783,42855,42930,
39861,226168,417893,571842,694140,791136,869778,934574,988554,1034342,1073653,1107314,1136584,1162440,1185307,1205262,1223291,1239506,1254138,1267408,1279483,1290426,1300411,1309605,1318188,1326089,1333486,1340058,1346189,1351985,1357387,1362238,1366901,1371277,1375367,1379059,1382569,1385832,1388983,1391897,1394704,1397271,1399690,1402048,1404318,1406429,1408402,1410279,1412014,1413775,1415404,1416923,1418356,1419756,1421034,1422224,1423393,1424584,1425720,1426779,1427811,1428693,1429508,1430357,1431189,1431948,1432661,1433360,1434090,1434793,1435460,1436032,1436632,1437211,1437774,1438281,1438767,1439268,1439729,1440176,1440592,1441011,1441377,1441745,1442140,1442507,1442836,1443138,1443439,1443741,1444022,1444294,1444564,1444813,1445065,1445292,1445519,1445741,1445956,1446166,1446366,1446539,1446727,1446887,1447046,1447217,1447383,1447523,1447679,1447819,1447952,1448084,1448217,1448350,1448482,1448596,1448715,1448826,1448933,1449042,
7550,91042,217036,337513,441796,529752,605126,668082,722614,769339,809804,845188,876370,903712,928020,949847,969503,987327,1003535,1018249,1031571,1043772,1054890,1065166,1074594,1083279,1091414,1098709,1105623,1112114,1118172,1123837,1129070,1134075,1138730,1143205,1147410,1151298,1154813,1158156,1161350,1164292,1167204,1169830,1172479,1174933,1177230,1179406,1181378,1183329,1185245,1187036,1188786,1190448,1192004,1193407,1194710,1196101,1197365,1198535,1199716,1200829,1201853,1202874,1203890,1204776,1205653,1206484,1207262,1208022,1208760,1209475,1210117,1210786,1211422,1212045,1212624,1213165,1213703,1214208,1214712,1215185,1215642,1216077,1216501,1216909,1217302,1217666,1217987,1218341,1218679,1219028,1219357,1219662,1219928,1220216,1220473,1220709,1220958,1221198,1221400,1221623,1221863,1222064,1222295,1222481,1222651,1222843,1223033,1223196,1223354,1223526,1223686,1223835,1223989,1224122,1224255,1224411,1224557,1224673,
2204,46820,134192,229899,318209,396911,465661,525148,576905,622113,661309,696140,727409,755080,780101,802011,822193,840340,857024,872075,885918,898472,910041,920686,930624,939721,948248,956153,963389,970166,976358,982210,987840,993028,997892,1002407,1006845,1010926,1014826,1018442,1021851,1024988,1028016,1030981,1033675,1036161,1038637,1040933,1043136,1045212,1047185,1049073,1050894,1052568,1054159,1055815,1057358,1058824,1060186,1061522,1062730,1063896,1065046,1066104,1067107,1068074,1068952,1069822,1070662,1071510,1072338,1073136,1073834,1074608,1075294,1075927,1076533,1077139,1077721,1078314,1078830,1079304,1079784,1080250,1080715,1081166,1081573,1081990,1082380,1082752,1083099,1083425,1083743,1084067,1084362,1084640,1084934,1085247,1085529,1085768,1086035,1086275,1086532,1086755,1086978,1087188,1087393,1087598,1087805,1088012,1088198,1088375,1088530,1088701,1088870,1089012,1089148,1089303,1089444,1089574,
457,19417,71020,137777,206376,270754,329922,382570,429345,471358,508552,541811,571801,598703,623277,645117,665129,682873,699201,714376,728158,740868,752777,763622,773798,783034,791853,800050,807576,814581,821161,827321,832987,838351,843387,848167,852709,856865,860849,864622,868207,871555,874705,877715,880525,883189,885712,888256,890548,892768,894944,896939,898810,900657,902375,903999,905482,906968,908421,909779,911117,912362,913630,914750,915784,916769,917722,918630,919536,920403,921327,922136,922909,923668,924433,925121,925801,926421,927026,927590,928169,928701,929264,929841,930326,930809,931239,931675,932107,932504,932891,933285,933648,934027,934342,934702,935000,935291,935609,935896,936185,936430,936684,936923,937166,937378,937600,937809,937990,938192,938377,938576,938736,938905,939102,939275,939435,939596,939738,939874,
41,5831,30167,69580,115801,163425,209234,252043,291658,327442,360478,390299,417056,441909,464609,485093,504204,521415,537367,551925,565519,577969,589537,600193,610060,619471,628154,636206,643673,650822,657376,663551,669442,674980,680067,684922,689497,693812,697818,701560,705278,708768,712048,715191,718037,720849,723534,726064,728390,730675,732811,734825,736783,738748,740558,742245,743813,745384,746861,748224,749602,750884,752125,753335,754450,755514,756556,757532,758598,759524,760373,761251,762071,762855,763594,764356,765061,765717,766373,766985,767579,768169,768757,769283,769811,770311,770802,771260,771694,772155,772552,772948,773285,773638,773979,774315,774668,774984,775302,775562,775827,776131,776399,776649,776898,777123,777358,777574,777794,778024,778227,778441,778629,778790,778980,779146,779323,779455,779611,779752,
7,2738,17772,45252,80854,119009,157453,194019,228608,261112,291252,318511,343733,366745,387893,407068,424757,441257,456488,470571,483650,495702,506848,517246,526922,535969,544570,552479,560040,566953,573245,579387,585186,590699,595833,600591,605145,609339,613353,617163,620770,624263,627599,630725,633735,636461,639107,641693,644053,646423,648671,650726,652726,654629,656469,658198,659813,661430,662904,664357,665700,667006,668261,669473,670620,671713,672761,673823,674822,675757,676698,677578,678412,679208,679972,680731,681432,682157,682847,683464,684076,684657,685222,685752,686267,686774,687247,687708,688178,688611,689033,689424,689811,690157,690534,690874,691241,691536,691810,692097,692407,692669,692943,693192,693462,693712,693971,694175,694390,694597,694814,695022,695192,695388,695560,695748,695915,696091,696243,696400,
2,1116,9430,27520,52628,81375,111886,142468,171884,199885,226230,250561,273082,294127,313614,331588,347994,363401,377856,391192,403554,415001,425658,435946,445408,454173,462350,470052,477294,484075,490481,496481,501879,507202,512300,517149,521731,526022,530070,533798,537327,540638,543881,546906,549879,552670,555261,557756,560157,562428,564691,566758,568723,570624,572383,574060,575665,577204,578733,580157,581529,582844,584127,585376,586555,587659,588786,589839,590832,591810,592729,593580,594448,595281,596040,596812,597529,598202,598861,599512,600104,600711,601291,601842,602365,602903,603399,603852,604312,604766,605192,605566,605952,606331,606694,607025,607378,607703,608030,608327,608636,608944,609200,609452,609698,609934,610157,610380,610592,610812,611039,611254,611468,611676,611865,612025,612221,612401,612561,612708,
0,366,4364,14948,31587,52290,75389,99382,123027,146324,168554,189550,209152,227624,244862,260867,275983,290164,303296,315415,327230,338127,348114,357558,366390,374593,382479,389877,396782,403243,409246,414963,420238,425393,430262,434724,439109,443247,447189,450937,454342,457582,460791,463713,466525,469250,471913,474423,476704,478930,481012,483020,484931,486787,488565,490256,491870,493436,494894,496386,497749,499017,500292,501472,502613,503716,504739,505789,506746,507676,508553,509447,510288,511145,511925,512684,513397,514087,514757,515397,516047,516668,517224,517743,518283,518817,519351,519806,520284,520708,521137,521593,521992,522388,522752,523131,523447,523811,524136,524467,524777,525069,525310,525589,525817,526071,526293,526538,526770,526967,527158,527358,527562,527766,527950,528122,528291,528467,528637,528785,
0,112,1703,7008,16807,30603,46569,64041,82063,100002,117857,135116,151293,166810,181690,195834,209224,221350,233063,244205,254468,264208,273426,282027,290199,297842,304826,311506,317883,324091,329744,334983,339968,344809,349498,353735,357701,361693,365536,369069,372288,375362,378393,381310,384044,386630,389117,391609,393902,396121,398250,400215,402098,403849,405553,407199,408708,410187,411622,413076,414347,415585,416813,418012,419119,420203,421237,422286,423203,424186,425089,425937,426763,427554,428344,429048,429740,430459,431092,431714,432309,432895,433454,433971,434499,434972,435454,435933,436356,436836,437258,437651,438033,438443,438829,439209,439525,439868,440159,440464,440738,441052,441332,441586,441842,442078,442317,442552,442776,442977,443187,443385,443598,443789,443989,444157,444340,444525,444692,444849,
0,43,879,4090,10756,20439,32495,46520,61354,76326,91406,106165,120617,134335,147653,160056,171953,183165,193745,203764,213261,222352,231027,239084,246754,253924,260686,267068,273282,279021,284341,289495,294368,299087,303452,307621,311577,315337,318915,322192,325359,328446,331356,334178,336807,339372,341821,344105,346297,348382,350404,352367,354219,356014,357682,359291,360851,362327,363752,365085,366363,367595,368763,369895,371036,372077,373110,374070,375054,375931,376827,377647,378478,379249,379999,380718,381406,382097,382685,383289,383846,384459,385006,385498,386006,386577,387073,387558,387986,388421,388841,389243,389618,389996,390337,390684,391036,391376,391744,392063,392355,392639,392912,393177,393437,393693,393919,394153,394356,394565,394764,394975,395175,395369,395564,395747,395903,396081,396241,396393,
0,7,394,2236,6594,13152,22189,32930,44546,56612,68978,81481,93586,105586,116868,127897,138507,148457,157924,166984,175735,184105,191910,199438,206545,213090,219396,225284,231011,236299,241367,246141,250763,255113,259105,262928,266623,270087,273401,276536,279535,282405,285166,287762,290312,292712,295010,297144,299270,301316,303258,305134,306920,308620,310139,311680,313108,314626,315922,317218,318493,319722,320854,321936,323034,324041,325010,325975,326854,327706,328507,329344,330075,330870,331584,332251,332933,333613,334220,334817,335396,335994,336553,337097,337594,338093,338538,339024,339491,339918,340353,340768,341188,341573,341937,342303,342617,342947,343265,343559,343855,344147,344422,344697,344960,345221,345437,345636,345876,346065,346281,346492,346663,346872,347056,347224,347419,347583,347730,347902,
0,4,182,1085,3589,7874,14043,21677,30418,39851,49519,59457,69528,79403,88912,98287,107343,115969,124400,132447,139974,147223,154038,160701,166884,172802,178471,183922,189178,194099,198709,203104,207340,211321,215041,218623,222049,225395,228478,231530,234337,237075,239642,242179,244530,246789,248950,251040,253046,254977,256867,258665,260355,262053,263590,265087,266491,267820,269128,270428,271645,272770,273859,274910,275913,276930,277896,278858,279813,280651,281536,282373,283137,283882,284549,285225,285801,286444,287074,287684,288248,288786,289305,289782,290271,290746,291176,291609,292049,292484,292908,293311,293680,294011,294345,294676,294984,295304,295621,295899,296178,296430,296689,296951,297197,297419,297637,297863,298095,298322,298526,298728,298920,299136,299289,299465,299633,299801,299970,300145,
0,2,54,452,1765,4322,8176,13214,19318,26064,33236,40946,48722,56482,64181,71837,79418,86774,93789,100573,107072,113466,119507,125209,130776,136068,141148,145937,150625,154957,158968,162968,166848,170522,174040,177270,180440,183487,186364,189107,191664,194136,196613,198903,201126,203275,205321,207287,209085,210830,212580,214187,215756,217209,218688,220059,221372,222653,223866,225032,226168,227223,228270,229253,230270,231224,232121,233025,233899,234708,235504,236229,236961,237640,238345,239075,239674,240265,240840,241389,241932,242444,242941,243429,243924,244376,244826,245265,245635,246021,246409,246790,247128,247448,247750,248087,248411,248703,249000,249270,249523,249773,250038,250283,250515,250727,250942,251151,251358,251586,251788,251971,252163,252348,252511,252683,252838,252988,253138,253301,
0,0,14,176,706,1891,4054,7063,10914,15346,20334,25719,31503,37246,43138,49142,54914,60729,66339,71935,77343,82570,87451,92240,96932,101367,105628,109719,113606,117446,121125,124611,127957,131159,134229,137166,139968,142596,145144,147706,150089,152350,154540,156597,158628,160565,162437,164226,165914,167647,169199,170717,172101,173509,174847,176087,177344,178536,179627,180724,181814,182782,183712,184673,185548,186412,187280,188078,188877,189628,190312,191060,191720,192362,192965,193564,194126,194662,195176,195706,196223,196757,197224,197659,198121,198516,198934,199295,199679,200043,200375,200714,201018,201322,201642,201937,202247,202518,202804,203073,203327,203577,203812,204059,204300,204516,204718,204910,205123,205328,205511,205677,205842,206013,206192,206343,206498,206644,206796,206923,
0,0,3,53,277,840,1954,3776,6134,9130,12550,16347,20444,24773,29215,33640,38231,42846,47320,51608,55944,60085,64213,68287,72281,76076,79744,83268,86674,89979,93113,96160,99048,101824,104639,107175,109609,112055,114471,116733,118928,120929,122862,124734,126534,128349,129998,131573,133124,134601,135989,137326,138654,139943,141143,142271,143378,144457,145481,146432,147428,148382,149221,150011,150825,151620,152388,153139,153904,154593,155269,155914,156542,157173,157724,158312,158861,159384,159871,160375,160879,161324,161751,162175,162552,162917,163327,163686,164054,164404,164747,165062,165389,165720,166034,166325,166596,166866,167124,167381,167637,167852,168088,168282,168510,168705,168920,169128,169302,169497,169673,169852,170015,170178,170346,170498,170625,170780,170920,171042,
0,0,1,10,98,324,829,1659,2910,4565,6611,8943,11591,14602,17577,20778,23959,27200,30582,34009,37172,40413,43634,46860,49924,52962,55845,58737,61374,64038,66523,69025,71422,73789,76054,78207,80280,82344,84236,86117,87898,89653,91335,92898,94428,95959,97446,98882,100206,101434,102699,103901,105006,106123,107256,108248,109219,110167,111062,111961,112874,113710,114490,115261,116000,116692,117389,118130,118757,119360,119955,120559,121099,121664,122184,122695,123197,123669,124067,124539,124968,125393,125822,126205,126578,126946,127323,127673,127974,128300,128616,128924,129214,129506,129781,130012,130255,130475,130724,130948,131174,131391,131591,131789,131955,132136,132322,132474,132636,132826,132970,133158,133308,133446,133576,133730,133866,133987,134104,134227,
0,0,0,1,17,86,251,529,1059,1843,2860,4089,5490,7089,8894,10864,12850,14892,17006,19259,21578,23711,25945,28088,30247,32438,34513,36665,38748,40798,42740,44651,46527,48320,50080,51770,53389,54913,56448,57929,59381,60839,62203,63510,64725,65965,67111,68245,69345,70380,71458,72453,73446,74414,75285,76158,76999,77812,78591,79370,80083,80825,81499,82175,82802,83387,83949,84549,85114,85625,86160,86624,87102,87576,88032,88486,88909,89312,89698,90065,90466,90828,91170,91500,91811,92159,92487,92805,93121,93443,93722,94008,94253,94510,94731,94938,95163,95393,95613,95820,96013,96194,96380,96558,96723,96890,97047,97173,97327,97470,97615,97759,97893,98007,98122,98272,98388,98527,98653,98752,
0,0,0,0,4,11,38,114,247,493,829,1299,1872,2565,3368,4215,5252,6256,7422,8660,9868,11105,12351,13677,14918,16202,17538,18848,20136,21395,22676,23964,25245,26418,27599,28740,29890,30995,32062,33149,34205,35177,36062,36949,37865,38752,39634,40448,41264,42066,42790,43567,44311,44998,45639,46233,46887,47506,48115,48641,49243,49774,50310,50831,51330,51821,52290,52729,53157,53605,54020,54398,54745,55102,55462,55765,56122,56442,56752,57090,57402,57664,57951,58232,58492,58756,59016,59263,59520,59737,59947,60167,60370,60541,60738,60937,61151,61379,61554,61714,61875,62017,62183,62322,62468,62608,62733,62867,62990,63113,63247,63368,63463,63590,63703,63824,63911,64021,64128,64217,
68735,288640,482903,629118,741125,828760,898930,956012,1003910,1044166,1078448,1107813,1133498,1156038,1175928,1193460,1209302,1223562,1236072,1247764,1258298,1268057,1276861,1284922,1292267,1299116,1305487,1311311,1316752,1321931,1326653,1331086,1335311,1339221,1342787,1346125,1349344,1352338,1355059,1357667,1360142,1362490,1364651,1366845,1368823,1370624,1372326,1373995,1375563,1377128,1378594,1379969,1381306,1382560,1383730,1384879,1385956,1387017,1388023,1389019,1389892,1390733,1391541,1392346,1393096,1393790,1394502,1395191,1395826,1396438,1397044,1397602,1398133,1398668,1399213,1399677,1400132,1400556,1400970,1401353,1401740,1402099,1402499,1402874,1403225,1403543,1403850,1404182,1404456,1404719,1404949,1405200,1405435,1405672,1405910,1406126,1406346,1406557,1406761,1406946,1407133,1407296,1407478,1407664,1407847,1407990,1408132,1408259,1408387,1408521,1408644,1408773,1408903,1409010,1409122,1409232,1409337,1409432,1409519,1409617,
20298,144427,289788,415229,517380,601158,670148,727852,776376,818125,853923,884910,912323,936609,957858,976888,993881,1009497,1023541,1036384,1047975,1058665,1068432,1077317,1085724,1093424,1100586,1107051,1113100,1118810,1124038,1128953,1133673,1138026,1142017,1145711,1149295,1152767,1155996,1158989,1161916,1164607,1167109,1169558,1171757,1173957,1175930,1177860,1179643,1181313,1182971,1184493,1186039,1187486,1188829,1190135,1191324,1192502,1193616,1194733,1195770,1196718,1197651,1198560,1199482,1200302,1201112,1201864,1202602,1203297,1204004,1204634,1205276,1205856,1206446,1206977,1207494,1208000,1208508,1208939,1209425,1209864,1210241,1210641,1211030,1211410,1211736,1212066,1212389,1212719,1213011,1213296,1213579,1213822,1214082,1214311,1214554,1214793,1215020,1215241,1215455,1215636,1215820,1216024,1216216,1216410,1216577,1216765,1216923,1217092,1217234,1217386,1217535,1217694,1217828,1217957,1218065,1218209,1218346,1218463,
8172,86894,200672,308152,400266,478327,544333,600191,648068,689472,725062,756478,784023,808782,830733,850526,868162,884154,898586,911762,924034,934865,944969,954277,962880,970861,978337,985200,991606,997533,1003023,1008304,1013192,1017845,1022070,1026051,1029852,1033382,1036825,1040086,1043034,1045893,1048514,1051093,1053458,1055758,1057827,1059778,1061750,1063499,1065235,1066905,1068574,1070142,1071579,1072978,1074262,1075565,1076766,1077930,1078991,1080041,1081037,1081989,1082920,1083763,1084618,1085430,1086196,1086980,1087722,1088417,1089027,1089666,1090287,1090866,1091440,1091968,1092508,1093039,1093542,1094009,1094452,1094837,1095246,1095628,1096017,1096390,1096718,1097038,1097349,1097694,1097983,1098268,1098567,1098847,1099109,1099380,1099610,1099838,1100074,1100290,1100502,1100686,1100905,1101097,1101301,1101491,1101673,1101851,1102023,1102188,1102347,1102511,1102675,1102820,1102942,1103068,1103181,1103319,
2539,44761,124060,208263,286402,354933,415183,467131,512111,551505,586605,617390,644944,669211,691041,710997,728827,745155,760033,773381,785759,797048,807587,817155,826072,834347,842128,849283,855907,861973,867937,873410,878535,883347,887889,892022,895963,899750,903209,906458,909588,912591,915398,918074,920603,923017,925382,927529,929544,931507,933468,935246,936879,938457,939954,941370,942778,944163,945501,946670,947789,948882,949964,950998,951998,952895,953752,954656,955436,956190,956983,957683,958327,959006,959676,960319,960896,961482,962050,962574,963086,963545,964011,964459,964888,965355,965787,966165,966553,966942,967262,967613,967928,968258,968601,968894,969185,969447,969706,969952,970182,970410,970635,970856,971060,971247,971447,971631,971813,971989,972158,972336,972501,972661,972816,972958,973128,973279,973406,973544,
523,18147,64212,122950,182959,239050,289975,335670,376670,412984,445230,474122,499943,523691,544782,564157,581702,597783,612308,626051,638706,649967,660536,670201,679159,687548,695375,702617,709361,715719,721669,727289,732565,737534,741949,746364,750393,754176,757786,761091,764259,767388,770308,773077,775706,778138,780535,782748,784862,786855,788791,790665,792325,794032,795617,797181,798616,799988,801318,802620,803862,805009,806163,807279,808273,809223,810118,811008,811916,812719,813478,814283,814986,815673,816335,816987,817593,818179,818774,819323,819887,820391,820895,821356,821836,822281,822703,823111,823534,823909,824297,824645,824993,825322,825641,825959,826265,826591,826851,827101,827369,827665,827900,828111,828320,828548,828723,828911,829134,829337,829520,829678,829829,830009,830154,830314,830460,830602,830762,830893,
193,10296,42671,88133,137636,185954,231280,272531,310046,343872,374526,402237,427045,449549,469988,488794,505954,521559,536018,549279,561677,572739,583090,592740,601754,610100,617870,625047,631928,638314,644281,649862,655237,660060,664725,668996,673169,677088,680774,684248,687481,690533,693494,696387,699094,701573,703843,706133,708265,710239,712158,713971,715723,717387,718953,720450,721949,723315,724654,725940,727189,728355,729453,730543,731661,732609,733582,734531,735392,736232,737026,737791,738554,739278,739968,740626,741254,741877,742447,743018,743570,744069,744580,745075,745531,745966,746419,746900,747314,747718,748116,748500,748879,749189,749495,749836,750133,750417,750740,751015,751279,751548,751791,752039,752282,752480,752683,752877,753084,753278,753463,753644,753817,754002,754160,754314,754487,754647,754774,754911,
50,5171,25857,59254,98435,138960,177330,213145,246623,277400,305225,330656,353884,375247,394525,412365,429022,444089,457958,470662,482382,493223,503300,512814,521451,529655,537213,544423,551167,557490,563512,568899,574140,579110,583740,588091,592236,596119,599721,603258,606419,609615,612628,615462,618150,620738,623108,625438,627583,629583,631584,633429,635290,637055,638689,640286,641805,643220,644604,645908,647156,648375,649529,650635,651710,652673,653647,654587,655436,656330,657209,657963,658741,659451,660160,660826,661440,662040,662642,663237,663757,664291,664813,665360,665850,666294,666727,667172,667590,668005,668378,668704,669079,669416,669755,670091,670409,670711,670989,671251,671534,671796,672016,672243,672448,672669,672879,673111,673316,673516,673699,673856,674052,674238,674398,674562,674720,674868,675019,675145,
14,2255,14351,36823,65533,96629,128069,158767,187644,214740,239626,262753,283850,303479,321409,337835,352993,367103,380129,392355,403984,414522,424303,433576,442089,450089,457468,464334,470855,476925,482720,488158,493348,498275,502855,507200,511170,514880,518535,521854,525074,528200,531054,533870,536537,539091,541471,543783,545995,548020,549928,551877,553678,555433,557050,558588,560054,561396,562762,564138,565445,566608,567740,568877,569945,570940,571937,572891,573773,574633,575465,576284,577076,577838,578570,579257,579900,580531,581121,581708,582275,582861,583381,583887,584372,584821,585262,585726,586163,586570,586952,587321,587702,588049,588362,588669,588975,589306,589614,589882,590176,590462,590684,590905,591146,591357,591570,591789,591974,592168,592390,592574,592757,592926,593076,593240,593405,593544,593704,593848,
2,815,6716,20053,39517,62021,86155,110517,134262,156786,178218,198235,216701,233939,249877,264845,278805,291965,304002,315141,325602,335382,344766,353395,361493,368921,376073,382878,389013,394900,400534,405587,410528,415139,419592,423699,427625,431290,434792,438155,441440,444519,447368,450055,452738,455190,457547,459821,461944,463996,465883,467725,469429,471053,472696,474271,475722,477119,478452,479736,480967,482188,483305,484386,485433,486384,487377,488319,489222,490053,490891,491706,492496,493233,493954,494560,495221,495874,496452,497023,497557,498068,498575,499078,499560,500046,500512,500950,501386,501789,502210,502586,502983,503324,503633,503997,504342,504635,504935,505214,505486,505729,505984,506219,506463,506694,506930,507134,507318,507504,507699,507887,508089,508273,508464,508627,508782,508958,509112,509263,
0,378,3918,13036,27635,45558,65129,85407,105876,125216,144276,162064,179006,194888,209884,223823,236723,248798,259967,270657,280665,289899,298589,306641,314323,321467,328004,334369,340315,346058,351463,356505,361389,365891,370180,374225,378119,381761,385241,388484,391597,394533,397300,400016,402571,405020,407257,409521,411707,413640,415542,417285,419084,420696,422307,423760,425221,426587,427955,429240,430423,431662,432737,433809,434872,435900,436848,437749,438668,439557,440446,441238,441985,442711,443420,444079,444695,445381,445928,446520,447086,447636,448166,448655,449117,449588,450011,450456,450900,451318,451724,452102,452500,452866,453173,453498,453781,454075,454365,454637,454907,455165,455432,455683,455911,456160,456370,456584,456823,457026,457202,457398,457591,457771,457939,458117,458267,458406,458575,458728,
0,173,2083,8036,18088,31471,46858,63375,80318,96810,113240,129028,143920,157986,171220,183718,195443,206720,217328,227151,236507,245226,253474,261152,268349,275163,281550,287519,293376,298742,303813,308695,313324,317599,321611,325505,329155,332721,336015,339163,342105,344946,347684,350225,352680,355078,357325,359521,361592,363621,365422,367234,368936,370600,372141,373676,375069,376458,377772,379041,380219,381339,382441,383528,384558,385527,386479,387406,388297,389160,389975,390775,391565,392263,392915,393580,394257,394875,395437,396027,396597,397141,397636,398158,398617,399048,399451,399884,400316,400677,401065,401489,401834,402206,402557,402850,403131,403458,403745,404043,404286,404538,404786,405028,405247,405454,405682,405898,406134,406333,406513,406676,406843,407006,407200,407365,407529,407666,407815,407973,
0,51,959,4219,10706,20034,31485,44247,57667,71118,84656,97865,110646,122797,134578,145785,156427,166281,175731,184523,192882,200806,208403,215491,222208,228397,234307,239972,245340,250381,255139,259538,263813,267876,271680,275352,278897,282141,285221,288208,290992,293609,296171,298692,301090,303342,305495,307604,309605,311444,313243,314945,316596,318226,319781,321218,322636,324034,325320,326514,327626,328794,329871,330935,331909,332808,333652,334557,335406,336164,336994,337803,338578,339304,339967,340606,341220,341858,342385,342947,343504,344030,344534,345006,345480,345923,346331,346755,347160,347549,347929,348284,348629,349002,349329,349630,349926,350227,350537,350813,351073,351338,351571,351835,352065,352293,352506,352710,352924,353107,353273,353459,353622,353795,353959,354137,354288,354450,354596,354728,
0,20,393,2078,5894,11857,19653,28898,39019,49426,60026,70778,81239,91534,101445,110863,119948,128524,136724,144673,152051,159009,165591,171905,177968,183660,189024,194296,199243,203991,208332,212558,216604,220534,224081,227524,230858,233950,236830,239654,242363,244858,247395,249827,252127,254279,256375,258298,260146,261925,263649,265256,266741,268240,269733,271075,272418,273659,274865,276079,277257,278349,279334,280367,281291,282200,283072,283941,284739,285550,286314,287031,287757,288436,289103,289701,290329,290918,291486,292038,292562,293059,293531,294014,294500,294956,295373,295796,296169,296581,296961,297300,297660,298012,298333,298626,298942,299212,299489,299777,300013,300294,300534,300735,300982,301194,301403,301622,301829,302032,302237,302389,302566,302729,302891,303065,303216,303372,303535,303677,
0,2,119,866,2816,6264,11242,17283,24282,31853,39855,48045,56329,64331,72304,79916,87552,94624,101583,108131,114540,120500,126385,131838,137143,142158,147018,151610,155835,160015,163905,167673,171258,174635,177928,181026,184044,186957,189607,192137,194544,196906,199109,201273,203325,205317,207288,209072,210815,212520,214133,215631,217062,218486,219810,221102,222388,223626,224792,225896,227047,228070,228994,229900,230850,231732,232577,233370,234152,234873,235616,236245,236902,237587,238226,238771,239339,239882,240432,240930,241425,241891,242339,242768,243211,243659,244058,244441,244862,245226,245598,245964,246269,246537,246817,247115,247415,247704,247973,248225,248465,248699,248925,249150,249376,249584,249802,250010,250177,250366,250566,250734,250905,251074,251234,251370,251502,251633,251765,251894,
0,0,34,332,1319,3129,6144,10009,14636,19830,25564,31437,37734,43923,50114,56205,62107,68017,73817,79361,84765,90045,94959,99626,104278,108583,112831,116794,120480,124033,127497,131014,134285,137358,140331,143084,145756,148312,150802,153106,155364,157565,159672,161655,163558,165345,167087,168684,170308,171870,173299,174687,176083,177413,178671,179892,181084,182188,183282,184282,185294,186214,187080,187965,188823,189586,190380,191175,191952,192674,193376,194042,194735,195360,195935,196519,197085,197586,198097,198568,199002,199481,199936,200359,200767,201125,201493,201829,202150,202499,202834,203128,203457,203762,204064,204347,204605,204875,205118,205371,205623,205844,206058,206264,206493,206674,206866,207058,207244,207423,207595,207732,207889,208025,208175,208328,208486,208634,208766,208900,
0,1,6,98,452,1297,2744,4835,7566,10889,14662,18694,22974,27443,31893,36414,40926,45446,49832,54255,58488,62461,66511,70449,74143,77772,81280,84632,87894,90991,94053,96856,99611,102235,104821,107298,109608,111822,113951,115991,117988,119906,121737,123528,125184,126836,128453,129875,131295,132626,133855,135079,136253,137462,138553,139624,140764,141763,142764,143669,144537,145401,146250,147050,147837,148528,149239,149902,150561,151247,151899,152524,153090,153654,154185,154721,155238,155725,156194,156674,157094,157464,157836,158196,158579,158964,159316,159679,160016,160339,160646,160937,161244,161534,161825,162105,162381,162609,162844,163062,163298,163500,163702,163931,164131,164305,164492,164683,164834,164989,165167,165339,165497,165658,165812,165956,166099,166238,166367,166502,
0,0,0,20,106,383,938,1829,3058,4778,6722,8930,11494,14168,17013,20006,23049,26139,29269,32353,35384,38375,41305,44238,47035,49776,52413,54926,57368,59857,62293,64505,66634,68715,70757,72721,74624,76488,78209,79904,81570,83174,84726,86175,87601,88976,90252,91527,92670,93874,95029,96121,97172,98183,99202,100084,101047,101897,102706,103481,104252,104999,105721,106398,107088,107744,108366,108875,109451,109988,110579,111076,111585,112106,112597,113046,113488,113918,114318,114698,115112,115485,115865,116235,116589,116931,117245,117570,117879,118159,118460,118741,118992,119262,119458,119699,119959,120160,120381,120595,120802,121000,121210,121421,121587,121764,121920,122082,122248,122399,122546,122690,122842,122987,123091,123212,123344,123480,123595,123723,
0,0,0,1,11,56,174,392,814,1358,2079,3027,4158,5379,6720,8218,9815,11413,13076,14764,16539,18280,20122,21900,23705,25454,27178,28896,30513,32195,33790,35433,36980,38504,40000,41406,42761,44121,45400,46665,47872,49051,50116,51267,52304,53308,54289,55254,56187,57095,57908,58727,59608,60356,61121,61826,62516,63190,63830,64466,65047,65664,66260,66796,67371,67918,68423,68907,69405,69864,70291,70726,71130,71544,71945,72308,72683,73021,73345,73693,74022,74336,74605,74923,75202,75494,75754,76014,76286,76518,76739,76956,77177,77395,77611,77798,77971,78158,78350,78548,78709,78869,79017,79175,79333,79481,79623,79760,79911,80053,80185,80302,80435,80553,80664,80764,80855,80955,81052,81155,
97961,337862,528355,667238,772080,852716,916875,969293,1012649,1049057,1079979,1106625,1130066,1150777,1168765,1184775,1199280,1212251,1223881,1234590,1244389,1253008,1260964,1268397,1275176,1281421,1287222,1292700,1297728,1302475,1306881,1311007,1314817,1318352,1321674,1324811,1327778,1330502,1333170,1335603,1337823,1339983,1342018,1344041,1345929,1347724,1349396,1350951,1352465,1353947,1355334,1356594,1357910,1359129,1360264,1361289,1362263,1363226,1364155,1365001,1365826,1366617,1367384,1368113,1368840,1369545,1370222,1370829,1371415,1371989,1372528,1373052,1373507,1373970,1374478,1374895,1375327,1375748,1376145,1376524,1376885,1377265,1377581,1377925,1378246,1378569,1378854,1379143,1379403,1379615,1379884,1380139,1380392,1380618,1380844,1381066,1381242,1381431,1381607,1381763,1381938,1382110,1382269,1382425,1382587,1382750,1382888,1383033,1383168,1383291,1383412,1383523,1383644,1383756,1383869,1383973,1384073,1384206,1384294,1384387,
35799,189131,343842,468532,566887,645592,709873,763312,807961,846641,879504,907952,932595,954651,974113,991524,1007051,1021079,1033622,1045270,1055844,1065495,1074303,1082385,1089836,1096850,1103242,1109188,1114802,1119977,1124893,1129368,1133619,1137709,1141355,1144948,1148143,1151271,1154264,1157013,1159686,1162099,1164384,1166671,1168759,1170759,1172648,1174393,1176049,1177685,1179244,1180679,1182111,1183436,1184709,1185914,1187081,1188174,1189202,1190253,1191185,1192093,1192998,1193813,1194613,1195352,1196066,1196748,1197421,1198057,1198705,1199294,1199849,1200388,1200936,1201441,1201889,1202353,1202818,1203258,1203691,1204058,1204486,1204833,1205190,1205562,1205880,1206210,1206483,1206763,1207032,1207303,1207560,1207803,1208049,1208296,1208534,1208739,1208940,1209160,1209359,1209543,1209716,1209868,1210037,1210224,1210377,1210538,1210694,1210856,1211016,1211146,1211270,1211407,1211526,1211653,1211757,1211861,1211969,1212077,
17363,125450,253898,365462,456945,532127,594568,647136,691822,730394,763546,792393,817737,840200,860339,878281,894368,908989,922190,934287,945271,955349,964485,972972,980932,988209,994986,1001202,1007086,1012506,1017572,1022240,1026665,1030885,1034837,1038559,1042052,1045193,1048322,1051241,1053977,1056512,1059008,1061308,1063533,1065682,1067692,1069528,1071298,1072979,1074666,1076228,1077714,1079183,1080451,1081704,1082896,1084048,1085203,1086220,1087248,1088182,1089101,1089957,1090737,1091548,1092318,1093068,1093787,1094479,1095129,1095780,1096358,1096915,1097462,1098040,1098564,1099073,1099574,1100033,1100469,1100917,1101372,1101830,1102203,1102560,1102918,1103255,1103583,1103864,1104160,1104462,1104747,1105050,1105309,1105558,1105785,1106043,1106260,1106484,1106689,1106928,1107127,1107308,1107485,1107684,1107863,1108028,1108174,1108338,1108511,1108654,1108794,1108923,1109065,1109169,1109275,1109409,1109534,1109646,
6619,72756,169907,262757,344291,414022,472997,523104,566262,603903,636592,665576,691018,713702,733765,751871,768462,783200,796760,809108,820559,830888,840364,849159,857062,864645,871774,878229,884336,889955,895353,900323,905046,909421,913509,917449,921037,924407,927718,930726,933643,936367,938976,941387,943757,945957,948029,949939,951818,953579,955252,956970,958608,960098,961560,962841,964150,965402,966567,967706,968795,969797,970792,971751,972634,973471,974226,975007,975776,976503,977225,977865,978462,979056,979665,980233,980765,981285,981831,982338,982771,983220,983643,984046,984456,984829,985189,985538,985896,986240,986533,986847,987163,987433,987726,988011,988248,988513,988749,988968,989202,989412,989615,989821,990007,990204,990399,990601,990775,990939,991090,991250,991383,991527,991679,991814,991932,992044,992179,992310,
1789,34755,99226,169819,236321,295905,348283,394271,434624,470154,501322,529254,554235,576359,596418,614622,631015,646015,659859,672419,683819,694291,703982,712866,721231,728922,736246,742832,749107,754989,760504,765632,770486,775104,779302,783347,787181,790713,794096,797289,800285,803117,805860,808320,810770,813031,815215,817281,819303,821205,823090,824818,826377,827956,829435,830844,832183,833477,834671,835842,836928,837985,838995,840049,840938,841881,842749,843555,844371,845148,845863,846514,847208,847876,848490,849080,849646,850197,850707,851225,851776,852251,852713,853130,853570,853965,854360,854725,855128,855483,855859,856194,856537,856826,857083,857338,857614,857854,858130,858374,858611,858838,859064,859273,859458,859657,859843,860039,860254,860426,860577,860750,860915,861078,861244,861387,861527,861680,861798,861916,
815,21732,70729,129005,187317,240506,288867,331636,369547,403112,432999,459848,483988,505672,525099,543019,559444,574313,588033,600386,611860,622356,632083,640927,649165,657011,664138,670804,677290,683129,688670,693911,698750,703362,707710,711794,715618,719309,722658,725864,728876,731807,734453,736974,739455,741797,744018,746165,748129,749976,751805,753579,755255,756857,758345,759728,761160,762533,763775,765059,766180,767314,768350,769367,770349,771279,772106,772915,773741,774508,775243,775996,776687,777329,777979,778607,779165,779762,780308,780852,781377,781840,782296,782789,783200,783599,784017,784418,784780,785142,785502,785842,786162,786470,786769,787059,787346,787621,787893,788145,788384,788644,788876,789108,789305,789481,789677,789868,790076,790274,790438,790622,790768,790917,791062,791196,791346,791478,791628,791783,
260,12417,46882,92590,140573,186909,229799,268416,303336,334724,363050,388937,411789,432585,451496,468700,484306,498769,512293,524201,535556,546013,555529,564456,572700,580412,587606,594206,600541,606378,611962,617095,622029,626625,630844,634898,638795,642466,645816,649131,652137,655031,657808,660367,662937,665310,667527,669630,671629,673536,675298,677044,678764,680358,681893,683329,684702,686050,687319,688567,689812,690953,692046,693058,694050,694989,695878,696775,697589,698379,699174,699878,700569,701238,701940,702588,703173,703725,704295,704793,705321,705823,706347,706832,707256,707643,708056,708440,708832,709206,709547,709917,710283,710644,710963,711261,711523,711791,712065,712324,712594,712851,713081,713292,713510,713713,713890,714094,714300,714490,714680,714858,715042,715214,715352,715497,715651,715811,715960,716086,
82,6091,28203,61503,99543,137679,174603,208497,239666,268288,294357,317838,339332,358976,376623,392967,408021,421814,434374,446519,457590,467611,476998,485736,494061,501597,508644,515203,521335,527027,532444,537529,542281,546912,551149,555079,558901,562480,565872,569071,572147,575044,577829,580471,582964,585419,587698,589974,591956,593877,595689,597446,599179,600857,602419,603907,605274,606619,607895,609120,610339,611546,612605,613632,614664,615608,616480,617398,618254,619045,619803,620570,621313,622004,622657,623313,623945,624540,625124,625648,626152,626667,627165,627644,628109,628561,628998,629422,629828,630190,630565,630908,631266,631608,631947,632266,632563,632857,633119,633392,633642,633889,634089,634311,634522,634711,634931,635146,635329,635518,635684,635868,636048,636221,636376,636539,636692,636838,636974,637093,
14,2527,15172,37082,64628,94313,124119,152767,179661,204681,227896,249171,268666,286805,303462,318617,332524,345495,357645,368929,379411,389082,398037,406448,414301,421637,428303,434814,440930,446594,451933,457031,461582,465973,470251,474213,477902,481401,484651,487858,490816,493669,496401,498989,501512,503778,506000,508113,510149,512002,513771,515604,517287,518912,520504,521971,523345,524663,525856,527092,528261,529374,530470,531515,532507,533463,534390,535317,536191,536992,537802,538549,539318,540026,540691,541340,541953,542560,543129,543691,544234,544754,545271,545770,546236,546707,547101,547533,547953,548314,548680,549046,549396,549735,550039,550324,550635,550911,551176,551449,551727,551989,552217,552468,552697,552904,553107,553306,553495,553685,553882,554072,554231,554416,554574,554723,554860,555000,555146,555292,
4,1375,9603,25874,47569,71956,96821,121306,145018,167774,188924,208363,226683,243557,259083,273255,286662,299187,310777,321411,331315,340575,349110,357172,364857,371922,378418,384788,390752,396317,401458,406268,410916,415252,419488,423335,427091,430506,433783,436932,439989,442839,445554,448066,450390,452710,454939,457102,459089,460921,462698,464448,466156,467737,469256,470691,472076,473378,474604,475854,477010,478143,479175,480166,481195,482118,482994,483874,484703,485537,486326,487057,487750,488448,489118,489734,490357,490934,491504,492033,492580,493066,493560,494059,494500,494971,495393,495832,496260,496643,497021,497374,497706,498088,498414,498732,499028,499338,499622,499878,500140,500362,500597,500795,501007,501228,501450,501654,501869,502051,502241,502426,502597,502757,502933,503068,503208,503340,503477,503616,
2,600,5454,16459,32860,52005,72595,93227,113503,133036,151536,169179,185554,201119,215407,228808,241178,252720,263273,273232,282749,291489,299687,307293,314492,321327,327768,333791,339476,344811,349822,354524,359024,363249,367123,370883,374475,377795,381099,384071,386934,389703,392376,394900,397326,399537,401780,403884,405997,407853,409623,411348,413033,414599,416079,417483,418847,420176,421416,422576,423696,424851,425864,426891,427906,428840,429792,430637,431444,432258,433050,433811,434544,435249,435908,436550,437214,437811,438351,438947,439464,439975,440498,440931,441445,441905,442333,442751,443210,443610,443987,444328,444720,445049,445345,445668,445941,446240,446524,446776,447050,447280,447523,447729,447956,448188,448395,448610,448796,448990,449177,449365,449541,449691,449854,450026,450171,450305,450460,450599,
0,271,2837,9932,20990,35377,51514,68733,85791,102133,118170,133363,147889,161407,174306,186383,197632,208157,218255,227665,236333,244389,251991,259233,266031,272416,278444,284245,289631,294847,299651,304194,308437,312544,316508,320216,323634,326993,330059,332918,335737,338364,340884,343332,345725,347966,350141,352098,354028,355862,357553,359202,360748,362301,363767,365114,366485,367789,369034,370272,371342,372432,373483,374478,375430,376348,377251,378075,378875,379655,380428,381078,381810,382502,383102,383800,384470,385067,385623,386156,386703,387197,387691,388110,388566,389000,389396,389817,390222,390616,390951,391278,391579,391893,392210,392498,392789,393062,393316,393571,393835,394130,394373,394601,394807,395018,395212,395413,395615,395803,395962,396146,396316,396475,396638,396807,396944,397080,397221,397374,
0,72,1268,5258,12325,22282,33925,46721,60009,73491,86862,99583,111701,123535,134692,145129,155051,164379,173436,181888,189864,197325,204398,211057,217452,223392,229023,234483,239522,244250,248727,252917,256942,260811,264350,267829,271087,274202,277166,280002,282649,285114,287530,289900,292057,294215,296216,298191,300115,301850,303440,304994,306526,307989,309406,310703,311991,313268,314501,315639,316691,317742,318806,319784,320719,321628,322484,323323,324144,324886,325633,326355,327009,327673,328272,328857,329350,329924,330456,331005,331507,332007,332484,332896,333373,333753,334175,334551,334980,335383,335719,336066,336441,336751,337055,337350,337645,337933,338208,338471,338731,338987,339240,339487,339730,339950,340131,340326,340526,340701,340860,341037,341190,341380,341543,341672,341803,341943,342085,342215,
0,17,492,2353,6484,12523,20281,29267,39114,49216,59454,69684,79456,88930,98087,106985,115519,123570,131229,138503,145509,152221,158639,164550,170240,175608,180597,185453,189995,194330,198346,202150,205797,209365,212635,215807,218816,221627,224399,227031,229400,231761,233951,236168,238194,240237,242139,243948,245714,247468,249123,250588,252043,253444,254826,256052,257277,258397,259574,260618,261616,262620,263625,264578,265424,266320,267163,267955,268719,269463,270152,270868,271522,272203,272777,273324,273903,274422,274948,275453,275910,276383,276834,277269,277703,278135,278542,278907,279292,279655,280014,280344,280669,280979,281273,281560,281847,282107,282390,282643,282868,283108,283377,283610,283830,284049,284236,284428,284618,284824,285006,285181,285352,285519,285644,285793,285931,286086,286218,286368,
0,4,176,1012,3105,6717,11686,17848,24758,32214,39961,47668,55730,63194,70876,78097,85149,91941,98471,104809,110790,116395,121692,126927,132037,136900,141277,145511,149653,153571,157276,160838,164256,167357,170422,173390,176088,178732,181333,183710,185900,188106,190213,192211,194152,195973,197704,199420,201085,202691,204176,205551,206847,208127,209398,210626,211798,212892,214046,215085,216030,216961,217831,218736,219590,220408,221193,221949,222703,223374,224048,224691,225335,225986,226535,227070,227596,228109,228619,229151,229645,230102,230537,230967,231378,231752,232139,232476,232813,233152,233500,233832,234106,234410,234673,234944,235217,235496,235751,235980,236222,236449,236676,236895,237113,237300,237510,237702,237897,238078,238245,238419,238584,238763,238923,239066,239207,239339,239465,239611,
0,2,26,353,1279,3032,5807,9339,13692,18664,24076,29561,35214,40943,46689,52218,57741,63171,68426,73585,78492,83217,87776,92063,96373,100361,104171,107845,111335,114678,117909,121029,123923,126730,129342,131855,134395,136788,139066,141216,143383,145325,147226,149040,150743,152403,153969,155510,157025,158345,159713,160955,162165,163352,164491,165611,166684,167725,168690,169657,170567,171417,172229,173034,173814,174590,175372,176107,176773,177473,178119,178722,179283,179882,180439,180959,181445,181926,182383,182818,183237,183667,184088,184479,184877,185266,185591,185933,186265,186591,186884,187151,187459,187729,187997,188272,188522,188741,189018,189262,189472,189665,189867,190074,190278,190466,190648,190794,190972,191166,191339,191483,191637,191767,191902,192044,192189,192314,192445,192580,
0,0,5,67,339,988,2132,3748,5978,8632,11757,15146,18678,22451,26216,30067,33848,37722,41678,45375,48990,52525,55961,59377,62654,65739,68731,71639,74490,77239,79851,82374,84784,87129,89368,91521,93567,95507,97399,99203,100957,102626,104240,105774,107288,108793,110130,111469,112714,113878,115010,116158,117208,118218,119182,120137,121081,122050,122896,123788,124656,125439,126186,126891,127591,128242,128914,129592,130175,130755,131320,131930,132439,132943,133430,133872,134319,134782,135170,135564,136004,136348,136740,137089,137443,137780,138081,138412,138735,139043,139309,139590,139855,140112,140363,140606,140835,141071,141290,141518,141737,141939,142138,142318,142497,142672,142821,143000,143157,143312,143453,143612,143762,143891,144029,144147,144271,144387,144515,144637,
0,0,0,5,38,165,466,987,1696,2745,4002,5496,7225,9119,11045,13126,15283,17493,19746,22048,24276,26475,28686,30857,32960,35051,37110,39165,41065,42933,44774,46643,48431,50140,51815,53379,54948,56368,57844,59219,60578,61890,63139,64357,65430,66564,67624,68662,69681,70663,71583,72535,73389,74200,75001,75774,76527,77240,77897,78581,79228,79874,80502,81129,81728,82281,82800,83293,83805,84286,84796,85224,85655,86116,86518,86902,87306,87658,88016,88340,88688,89012,89331,89649,89912,90204,90473,90766,91021,91273,91527,91758,91991,92227,92413,92625,92786,92994,93226,93400,93578,93740,93909,94049,94221,94360,94482,94623,94778,94909,95046,95164,95285,95402,95504,95602,95717,95829,95928,96027,
124474,374848,561058,693870,791947,867237,927367,976143,1016351,1050363,1079061,1104362,1126260,1145276,1162392,1177439,1190856,1202894,1213768,1223737,1232719,1240938,1248552,1255384,1261797,1267615,1273075,1278137,1282986,1287410,1291547,1295339,1298792,1302239,1305218,1308159,1310972,1313591,1316095,1318380,1320551,1322556,1324530,1326448,1328153,1329804,1331417,1332872,1334321,1335681,1337028,1338208,1339387,1340534,1341644,1342645,1343613,1344557,1345414,1346261,1347034,1347804,1348548,1349239,1349928,1350611,1351221,1351808,1352367,1352919,1353469,1353977,1354436,1354915,1355413,1355857,1356247,1356636,1357039,1357402,1357780,1358133,1358486,1358786,1359071,1359368,1359614,1359918,1360179,1360418,1360656,1360893,1361097,1361308,1361531,1361728,1361924,1362118,1362311,1362479,1362627,1362791,1362943,1363065,1363208,1363367,1363509,1363642,1363766,1363910,1364038,1364164,1364280,1364409,1364525,1364614,1364717,1364832,1364925,1365017,
53326,226702,385395,507747,602750,677515,738040,787675,829314,865533,896009,922699,945702,966330,984336,1000509,1015041,1028308,1040193,1051001,1061039,1069950,1078193,1085757,1092763,1099228,1105205,1110760,1115952,1120721,1125353,1129608,1133491,1137177,1140656,1143919,1146938,1149865,1152566,1155146,1157564,1159874,1162051,1164172,1166159,1168001,1169740,1171367,1172947,1174476,1175959,1177284,1178574,1179888,1181105,1182236,1183302,1184365,1185343,1186285,1187202,1188014,1188825,1189603,1190387,1191081,1191763,1192427,1193070,1193697,1194291,1194861,1195396,1195928,1196433,1196912,1197398,1197853,1198302,1198729,1199132,1199512,1199888,1200231,1200548,1200910,1201219,1201524,1201817,1202083,1202343,1202609,1202861,1203105,1203314,1203560,1203786,1204012,1204245,1204441,1204619,1204783,1204962,1205122,1205270,1205432,1205589,1205727,1205861,1206008,1206126,1206239,1206362,1206485,1206631,1206761,1206866,1206966,1207068,1207165,
28819,159017,295902,408021,497819,570690,630633,680525,722233,758133,789166,816241,840039,860961,879633,896471,911693,925460,937703,949065,959178,968401,976892,984750,991951,998765,1004985,1010879,1016256,1021322,1026264,1030655,1034901,1038734,1042473,1045915,1049071,1052155,1055027,1057776,1060336,1062743,1065082,1067249,1069265,1071207,1073045,1074759,1076441,1078070,1079600,1081054,1082448,1083789,1084991,1086161,1087254,1088357,1089419,1090415,1091348,1092252,1093153,1093993,1094775,1095511,1096223,1096917,1097612,1098270,1098898,1099485,1100039,1100592,1101112,1101638,1102110,1102574,1103040,1103483,1103942,1104366,1104768,1105145,1105514,1105833,1106181,1106499,1106780,1107077,1107348,1107634,1107916,1108177,1108422,1108652,1108870,1109095,1109314,1109530,1109739,1109948,1110114,1110298,1110477,1110643,1110818,1110968,1111110,1111265,1111412,1111560,1111693,1111807,1111934,1112056,1112181,1112322,1112453,1112555,
12945,100422,209768,307464,389925,458287,515320,563693,604692,640947,671931,699211,723180,744644,763560,780861,796191,810225,823014,834649,845256,854863,863968,872351,879773,886930,893502,899547,905123,910388,915372,919899,924227,928298,932198,935748,939217,942371,945338,948147,950874,953543,955931,958172,960368,962390,964309,966190,967972,969680,971282,972893,974366,975799,977159,978378,979584,980752,981856,982887,983852,984785,985707,986582,987414,988216,989006,989679,990399,991059,991666,992297,992890,993449,993992,994514,995017,995544,996030,996502,996967,997401,997796,998213,998586,998947,999305,999651,999968,1000283,1000564,1000865,1001137,1001402,1001660,1001918,1002133,1002356,1002583,1002809,1003035,1003239,1003453,1003644,1003827,1003998,1004166,1004357,1004540,1004685,1004856,1005000,1005136,1005288,1005440,1005575,1005696,1005833,1005946,1006060,
4323,53493,132135,210659,281211,342326,394943,440317,479564,513448,543735,570470,594110,615136,634087,651196,666705,680861,693911,705682,716489,726451,735634,744004,751852,759128,765791,772107,777973,783425,788567,793549,798079,802364,806357,810173,813647,816996,820182,823114,825864,828510,831063,833514,835745,837884,839942,841823,843659,845347,847108,848801,850330,851796,853150,854427,855747,856940,858115,859233,860263,861221,862154,863108,863985,864830,865672,866450,867226,867919,868600,869274,869928,870553,871133,871678,872257,872787,873266,873774,874262,874735,875148,875556,875951,876335,876705,877062,877403,877724,878061,878364,878662,878949,879212,879468,879708,879978,880227,880467,880691,880913,881146,881374,881576,881766,881947,882125,882279,882436,882621,882753,882910,883046,883205,883353,883495,883637,883758,883884,
2071,35546,98715,166475,229253,284964,334493,377228,414729,447696,476882,502596,526048,547003,565637,582769,598252,612475,625426,637235,648187,658216,667458,675939,683769,691183,697752,704041,709967,715411,720710,725618,730117,734562,738573,742304,745878,749267,752488,755469,758369,761014,763648,766091,768497,770655,772724,774649,776554,778346,780085,781664,783145,784616,786006,787395,788697,789930,791119,792224,793333,794356,795358,796309,797223,798113,798902,799681,800472,801211,801965,802603,803236,803853,804464,805047,805597,806157,806699,807197,807716,808192,808612,809057,809454,809865,810268,810647,810991,811351,811656,811983,812282,812564,812837,813091,813334,813561,813823,814076,814328,814566,814797,814999,815179,815382,815549,815751,815925,816073,816260,816413,816568,816732,816861,817009,817150,817304,817438,817563,
900,21967,68932,123936,178048,227770,272609,312500,348196,379837,407692,432681,455135,475311,493412,510244,525130,539154,551987,563634,574485,584370,593478,602064,610035,617410,624237,630655,636779,642299,647490,652249,656851,661212,665237,668990,672642,676073,679246,682339,685167,687817,690438,692909,695312,697548,699628,701646,703563,705398,707170,708820,710377,711859,713264,714629,715953,717164,718314,719508,720606,721714,722700,723663,724591,725538,726363,727205,727999,728772,729490,730175,730883,731512,732143,732741,733311,733856,734339,734842,735325,735792,736243,736692,737127,737519,737945,738335,738683,739045,739392,739710,740049,740348,740652,740914,741177,741451,741715,741975,742221,742460,742691,742912,743100,743295,743478,743657,743834,744012,744175,744351,744506,744653,744791,744940,745070,745237,745373,745493,
308,12235,44434,87082,131507,174048,213622,249597,281884,311176,337419,361261,382605,401878,419391,435332,450190,463655,476172,487584,498124,507820,516907,525383,533251,540452,547279,553554,559610,565193,570505,575290,579943,584298,588380,592190,595945,599506,602829,605913,608826,611602,614263,616792,619132,621338,623405,625494,627356,629129,630860,632504,634174,635738,637239,638533,639872,641183,642411,643615,644678,645740,646792,647808,648739,649673,650500,651342,652142,652877,653629,654355,655085,655758,656384,656991,657571,658149,658660,659180,659668,660155,660603,661029,661449,661897,662280,662652,663035,663381,663742,664093,664425,664714,665020,665322,665608,665858,666141,666402,666664,666871,667092,667304,667529,667730,667913,668096,668287,668454,668622,668776,668946,669106,669263,669406,669545,669701,669841,669955,
84,5610,25695,55598,89860,124578,157943,188735,217340,243467,267301,289260,309133,327186,343776,358965,372822,385743,397599,408590,418881,428328,437047,445325,452961,460141,466833,472919,478749,484095,489283,494096,498603,502795,506919,510796,514311,517769,520942,524063,526881,529516,532099,534592,536988,539212,541372,543414,545396,547276,549046,550758,552335,553847,555244,556594,557950,559268,560430,561583,562706,563757,564747,565788,566775,567672,568614,569471,570257,571021,571752,572452,573180,573858,574499,575080,575701,576270,576797,577349,577862,578366,578846,579288,579754,580205,580601,581015,581390,581757,582098,582417,582770,583059,583368,583666,583934,584230,584499,584731,584972,585242,585487,585683,585900,586080,586291,586501,586684,586873,587039,587198,587349,587512,587673,587827,587982,588119,588259,588397,
22,3211,17164,40173,68252,97687,126723,154337,180059,204103,226015,246499,265224,282353,298206,312402,325627,338035,349476,360213,370003,379278,387747,395882,403135,410028,416517,422560,428258,433652,438721,443401,447872,452187,456249,459982,463508,466845,470059,473047,475871,478603,481163,483675,486103,488365,490517,492659,494567,496407,498088,499744,501313,502785,504250,505654,506945,508206,509402,510586,511701,512801,513805,514820,515761,516646,517520,518437,519260,520033,520797,521521,522240,522930,523581,524199,524805,525411,525965,526525,527037,527521,528015,528501,528948,529348,529781,530187,530575,530954,531285,531628,531942,532282,532589,532876,533152,533411,533669,533912,534143,534379,534627,534871,535081,535276,535466,535651,535825,536005,536164,536328,536497,536644,536791,536940,537072,537201,537359,537483,
2,1657,10632,27710,49375,73628,98210,122462,145311,166740,186786,205388,222597,238538,253361,266907,279608,291348,302058,312050,321466,330272,338550,346142,353422,360021,366209,372227,377793,382930,387892,392426,396802,400907,404747,408424,411895,415187,418314,421284,424091,426761,429376,431728,434098,436315,438420,440434,442259,444077,445849,447535,449123,450580,452007,453378,454712,455957,457175,458340,459411,460488,461511,462478,463399,464335,465213,466039,466874,467704,468483,469189,469858,470533,471165,471759,472381,472962,473486,473990,474466,475004,475440,475958,476387,476830,477270,477664,478054,478417,478730,479076,479404,479709,480023,480335,480636,480890,481146,481408,481655,481874,482094,482333,482562,482762,482972,483172,483334,483491,483668,483846,484011,484177,484325,484450,484580,484725,484861,484993,
2,716,5958,17176,33093,51983,72013,92031,111540,130175,147829,164411,179827,194433,207989,220672,232359,243233,253325,262721,271740,280307,288044,295360,302151,308369,314278,319973,325363,330422,335189,339738,343907,347936,351855,355494,358898,362092,365089,367996,370661,373220,375745,378070,380336,382499,384495,386497,388333,390168,391886,393465,395056,396555,397948,399299,400536,401816,403010,404128,405242,406307,407336,408290,409274,410139,410993,411822,412606,413347,414133,414868,415535,416220,416844,417482,418049,418602,419126,419664,420191,420682,421143,421559,421973,422380,422798,423197,423588,424000,424353,424699,425029,425348,425635,425937,426195,426449,426713,426962,427230,427479,427687,427880,428095,428287,428504,428727,428912,429095,429256,429438,429598,429735,429895,430077,430206,430345,430475,430617,
0,279,2917,9913,20710,34367,49572,65604,81405,96963,111953,126337,139841,152574,164609,175947,186709,196430,205627,214391,222622,230369,237632,244461,250742,256598,262395,267755,272870,277612,282078,286225,290220,293987,297637,301072,304337,307395,310288,313027,315607,318067,320452,322704,324898,326993,328952,330860,332662,334411,336074,337624,339131,340505,341874,343180,344410,345666,346861,348018,349094,350145,351149,352091,353056,353937,354750,355541,356336,357122,357805,358495,359129,359789,360383,360984,361543,362085,362621,363155,363671,364162,364645,365098,365515,365926,366325,366672,367057,367404,367750,368095,368458,368740,369042,369318,369608,369876,370112,370376,370635,370883,371124,371316,371514,371711,371886,372087,372300,372499,372667,372842,373004,373170,373308,373474,373616,373741,373881,374001,
0,84,1200,4781,11323,20165,30667,42366,54459,66618,78534,90059,101360,112145,122349,131930,141140,149798,158096,165946,173145,179906,186398,192578,198524,203965,209049,214008,218694,223154,227349,231205,234940,238437,241776,244938,247987,250906,253667,256292,258784,261127,263427,265624,267744,269741,271620,273401,275123,276765,278375,279930,281353,282756,284026,285264,286504,287648,288777,289854,290893,291875,292827,293777,294650,295581,296372,297149,297900,298636,299317,299973,300591,301198,301790,302385,302915,303474,303983,304463,304924,305382,305825,306262,306686,307086,307453,307827,308204,308593,308936,309277,309611,309930,310230,310490,310754,311023,311295,311548,311790,312001,312225,312432,312637,312825,313014,313202,313394,313573,313776,313946,314119,314272,314419,314564,314687,314832,314958,315073,
1,33,480,2255,5917,11454,18667,26942,35905,45159,54532,63849,72960,81907,90392,98501,106315,113759,120843,127545,134043,140139,145828,151289,156446,161419,166181,170692,174824,178850,182596,186135,189550,192845,195931,198881,201717,204410,206969,209389,211654,213903,216054,218156,220122,222002,223834,225544,227092,228675,230155,231545,232870,234150,235404,236657,237751,238854,240038,241060,242033,242983,243916,244823,245662,246504,247263,247996,248737,249406,250090,250749,251386,252042,252626,253174,253659,254141,254664,255125,255614,256070,256495,256896,257291,257707,258084,258429,258815,259165,259473,259809,260115,260417,260694,260983,261263,261531,261788,262028,262283,262514,262726,262939,263146,263342,263538,263727,263928,264099,264282,264454,264611,264785,264927,265063,265201,265321,265468,265611,
0,5,115,775,2530,5570,9710,15087,20954,27342,33964,40637,47446,54170,60841,67408,73625,79711,85588,91200,96570,101817,106640,111272,115782,120070,124109,127935,131584,135151,138528,141775,144826,147796,150617,153237,155845,158253,160664,162881,165030,167115,169054,171002,172806,174542,176102,177651,179149,180599,182011,183388,184611,185823,186993,188102,189242,190340,191335,192294,193246,194108,194933,195718,196515,197273,197978,198716,199382,200030,200662,201288,201842,202429,203001,203523,203997,204487,204946,205385,205805,206223,206619,207014,207398,207741,208088,208408,208752,209083,209401,209701,209993,210274,210545,210816,211095,211352,211599,211829,212060,212272,212483,212697,212881,213054,213243,213406,213564,213738,213911,214080,214238,214382,214529,214677,214801,214925,215030,215139,
0,1,24,215,804,1954,3894,6536,9669,13399,17586,22053,26536,31184,35824,40396,44963,49439,53762,58016,62142,65988,69890,73580,77122,80581,83892,87019,90056,93008,95898,98591,101178,103652,106024,108185,110401,112451,114502,116349,118168,119947,121653,123384,124909,126394,127765,129122,130440,131674,132917,134045,135213,136258,137293,138301,139249,140218,141082,141940,142811,143620,144371,145114,145789,146502,147164,147782,148347,148951,149494,150027,150546,151039,151544,152012,152491,152924,153345,153770,154143,154512,154891,155229,155595,155929,156241,156550,156856,157157,157445,157742,158012,158271,158522,158784,159021,159269,159511,159731,159946,160133,160327,160514,160683,160849,161000,161161,161320,161483,161646,161793,161924,162077,162200,162329,162463,162595,162712,162831,
0,0,1,15,97,390,902,1775,3001,4571,6387,8495,10779,13136,15702,18325,20917,23589,26280,29051,31720,34330,36920,39414,41916,44344,46542,48775,51002,53122,55122,57004,58892,60716,62512,64207,65782,67436,69022,70485,71900,73284,74589,75854,77090,78285,79397,80512,81551,82587,83531,84435,85326,86162,86985,87812,88606,89358,90087,90807,91508,92190,92840,93483,94109,94688,95223,95764,96267,96747,97191,97663,98103,98524,98971,99370,99734,100103,100447,100787,101144,101451,101787,102112,102410,102711,103038,103294,103570,103826,104096,104351,104598,104836,105051,105247,105441,105629,105814,106005,106183,106376,106552,106704,106848,107003,107151,107292,107436,107570,107708,107856,107972,108095,108198,108307,108410,108515,108617,108726,
148800,405879,587504,714348,807440,878700,935314,981208,1019299,1051318,1078568,1102239,1122767,1140658,1156600,1170731,1183441,1195097,1205282,1214730,1223272,1231017,1238044,1244692,1250706,1256270,1261509,1266380,1270802,1275052,1278965,1282664,1286081,1289264,1292157,1294963,1297676,1300178,1302541,1304839,1306934,1308986,1310846,1312636,1314325,1315901,1317406,1318867,1320293,1321577,1322829,1324009,1325131,1326182,1327183,1328129,1329044,1329941,1330743,1331550,1332309,1333068,1333796,1334484,1335090,1335769,1336366,1336942,1337476,1337986,1338521,1339029,1339496,1339941,1340384,1340793,1341192,1341574,1341924,1342297,1342655,1342984,1343305,1343599,1343908,1344195,1344454,1344717,1344968,1345225,1345454,1345684,1345901,1346091,1346297,1346482,1346673,1346861,1347034,1347198,1347364,1347514,1347649,1347800,1347940,1348073,1348206,1348348,1348465,1348594,1348719,1348829,1348952,1349063,1349193,1349288,1349388,1349502,1349577,1349682,
70384,259021,418793,537992,629099,700757,758601,805846,845591,879298,908147,932917,954613,973788,990905,1006105,1019889,1032250,1043360,1053666,1062983,1071460,1079272,1086348,1092906,1099054,1104803,1110126,1114935,1119541,1123812,1127835,1131611,1135124,1138325,1141445,1144350,1147122,1149685,1152130,1154391,1156610,1158701,1160708,1162595,1164367,1165993,1167565,1169100,1170538,1171975,1173259,1174539,1175775,1176887,1177992,1179014,1180002,1180959,1181900,1182768,1183560,1184359,1185091,1185797,1186484,1187158,1187808,1188391,1189003,1189567,1190156,1190670,1191165,1191647,1192116,1192534,1192953,1193371,1193774,1194177,1194523,1194882,1195220,1195564,1195888,1196202,1196500,1196781,1197033,1197284,1197523,1197773,1197987,1198199,1198413,1198622,1198841,1199039,1199216,1199389,1199562,1199731,1199886,1200048,1200188,1200345,1200462,1200586,1200713,1200849,1200979,1201123,1201245,1201368,1201474,1201588,1201698,1201807,1201901,
41446,189737,331006,442896,530487,600824,657951,705063,744779,779207,808603,834107,856340,876097,893708,909250,923359,936290,948106,958721,968193,977006,985138,992596,999324,1005913,1012122,1017633,1022708,1027552,1032197,1036428,1040320,1044029,1047478,1050826,1053823,1056705,1059468,1062090,1064483,1066787,1069010,1071116,1073082,1074989,1076735,1078388,1080012,1081579,1083022,1084364,1085744,1087008,1088178,1089280,1090389,1091424,1092462,1093433,1094299,1095150,1095975,1096744,1097493,1098187,1098873,1099574,1100217,1100835,1101459,1102099,1102677,1103204,1103733,1104223,1104692,1105119,1105545,1105950,1106374,1106825,1107218,1107578,1107913,1108244,1108522,1108817,1109091,1109417,1109677,1109908,1110172,1110402,1110660,1110899,1111094,1111290,1111513,1111711,1111915,1112093,1112286,1112453,1112631,1112805,1112953,1113107,1113251,1113409,1113546,1113676,1113807,1113941,1114063,1114186,1114290,1114410,1114504,1114591,
20570,126146,244045,343973,426120,493121,548672,595120,634235,668511,698083,723972,746710,767062,784825,801038,815745,828904,840966,851976,862031,871176,879550,887331,894424,901078,907403,913175,918458,923347,928077,932602,936800,940633,944312,947817,951042,954079,956908,959575,962100,964551,966813,968972,971050,972975,974742,976514,978207,979810,981314,982823,984285,985624,986846,988044,989224,990314,991331,992323,993222,994123,995018,995866,996634,997437,998202,998890,999610,1000238,1000878,1001424,1002009,1002526,1003035,1003590,1004090,1004584,1005056,1005520,1005942,1006355,1006748,1007122,1007495,1007848,1008187,1008542,1008860,1009167,1009457,1009756,1010030,1010275,1010495,1010742,1010962,1011173,1011386,1011571,1011775,1011955,1012151,1012348,1012521,1012691,1012839,1013011,1013179,1013328,1013459,1013614,1013765,1013903,1014027,1014137,1014253,1014379,1014502,1014619,
8017,72454,161635,244866,316611,378006,429908,474460,512708,545653,574629,600397,623090,643424,661602,677903,692700,706145,718392,729556,739845,749261,757938,765826,773285,780290,786656,792591,798167,803470,808335,812948,817238,821183,824966,828596,831925,835072,838165,840993,843588,846078,848549,850873,853083,855085,856983,858753,860538,862151,863783,865329,866753,868170,869532,870813,872020,873129,874213,875302,876310,877240,878161,879118,879943,880749,881495,882228,882942,883581,884254,884887,885527,886103,886637,887184,887678,888158,888627,889108,889556,890009,890460,890862,891214,891555,891913,892276,892607,892918,893229,893553,893850,894102,894339,894588,894835,895079,895303,895519,895748,895966,896153,896366,896559,896732,896898,897062,897235,897394,897548,897687,897847,897991,898138,898271,898398,898559,898679,898789,
4271,50649,124388,198116,264167,321251,370816,413096,450281,482838,511326,536650,558941,578746,596778,613162,628014,641431,653804,664876,675186,684655,693424,701482,708986,715900,722327,728352,734009,739339,744404,749057,753413,757503,761361,765006,768461,771714,774820,777676,780274,782770,785245,787560,789736,791720,793724,795516,797290,798934,800574,802105,803567,804992,806342,807598,808822,809960,811133,812168,813255,814255,815182,816086,816985,817765,818530,819279,820022,820697,821389,822015,822665,823259,823865,824445,825007,825521,825996,826462,826924,827390,827834,828245,828636,828999,829382,829745,830092,830404,830761,831081,831386,831645,831891,832135,832364,832613,832840,833051,833286,833475,833694,833878,834072,834252,834433,834613,834774,834946,835103,835273,835430,835571,835697,835827,835955,836070,836197,836308,
1982,33084,90862,153100,211038,262938,308813,348887,384422,415514,442937,467200,489072,508788,526442,542333,556988,570458,582660,594004,604293,614016,622672,630796,638369,645342,651711,657702,663497,668865,673784,678397,682814,687049,690947,694554,698059,701322,704391,707297,710098,712733,715222,717603,719910,722032,723979,725873,727691,729488,731130,732737,734222,735602,736989,738279,739521,740681,741765,742856,743922,744918,745850,746798,747717,748525,749320,750125,750869,751564,752245,752927,753593,754217,754801,755326,755871,756400,756929,757402,757896,758373,758836,759241,759666,760036,760427,760800,761132,761447,761742,762077,762382,762709,762989,763258,763507,763761,764022,764247,764471,764710,764900,765108,765303,765507,765689,765864,766055,766213,766368,766522,766687,766827,766956,767107,767235,767372,767493,767603,
767,19750,61677,111143,160857,206733,248201,285214,317982,347412,373451,397136,418003,436801,453970,469793,484091,497165,509205,519978,530316,539819,548444,556560,563988,570878,577348,583408,589076,594355,599437,604061,608378,612659,616649,620237,623776,627092,630186,633112,635863,638371,640884,643345,645659,647804,649811,651784,653589,655297,656906,658511,660024,661480,662910,664165,665460,666655,667814,668971,670048,671066,672068,672956,673914,674793,675589,676415,677229,677939,678702,679383,680047,680635,681227,681786,682335,682862,683401,683888,684320,684796,685248,685686,686092,686491,686872,687268,687636,688007,688317,688642,688952,689247,689549,689815,690065,690313,690555,690797,691016,691239,691453,691663,691875,692079,692264,692448,692628,692796,692979,693155,693321,693478,693606,693776,693901,694045,694169,694300,
239,10064,37795,74826,114459,152972,188780,221084,250403,277100,301155,323095,342944,361079,377583,392545,406116,418993,430588,441405,451258,460565,469086,477090,484493,491442,497898,503919,509583,514815,519680,524334,528687,532841,536821,540451,543965,547305,550417,553290,555941,558487,560975,563386,565704,567860,569912,571788,573680,575492,577163,578795,580373,581874,583271,584577,585782,587054,588205,589342,590412,591488,592480,593485,594395,595268,596075,596883,597719,598493,599189,599902,600593,601216,601821,602411,602994,603526,604050,604552,605031,605533,605973,606422,606867,607281,607655,608058,608434,608782,609130,609487,609802,610105,610370,610659,610925,611170,611420,611667,611902,612150,612367,612565,612768,612941,613131,613320,613501,613670,613845,614018,614176,614320,614486,614619,614739,614879,615024,615139,
113,6177,26407,55886,89176,122169,154192,183758,211205,235989,258695,279563,298418,315574,331198,345761,358958,371288,382474,392931,402801,411642,420071,428007,435390,442053,448369,454320,459906,465192,470140,474751,479081,483157,487193,490784,494366,497653,500658,503559,506250,508867,511337,513695,516021,518107,520195,522162,523999,525741,527416,529007,530511,532026,533471,534718,535907,537106,538259,539460,540538,541544,542503,543492,544384,545242,546076,546897,547719,548468,549219,549925,550620,551298,551931,552510,553109,553652,554174,554707,555201,555687,556144,556593,556997,557399,557831,558255,558647,559006,559365,559682,560006,560311,560601,560864,561155,561420,561681,561921,562153,562382,562609,562844,563025,563225,563393,563567,563757,563903,564061,564234,564379,564531,564695,564847,565006,565137,565273,565398,
45,3473,17270,39734,66475,94678,121888,148271,172770,195605,216513,235611,253059,269162,284251,297810,310275,322027,332712,342751,352081,360795,368786,376357,383519,390036,396226,402052,407559,412571,417273,421814,426058,430168,433931,437495,440970,444231,447247,450115,452830,455432,457994,460301,462580,464724,466778,468791,470651,472393,473974,475571,477081,478567,480031,481365,482563,483738,484939,486064,487156,488168,489204,490155,491055,491928,492760,493535,494363,495118,495868,496547,497186,497813,498416,498999,499593,500171,500708,501244,501748,502203,502648,503104,503557,503987,504400,504808,505170,505544,505882,506226,506573,506871,507135,507430,507706,507973,508236,508479,508691,508902,509139,509366,509575,509746,509942,510141,510327,510502,510677,510839,510990,511149,511310,511476,511630,511766,511880,512018,
5,1624,10299,26121,46638,69191,92049,114396,135824,156027,174541,191883,207938,222913,236663,249509,261341,272689,282758,292278,301180,309563,317341,324675,331517,337870,343711,349299,354603,359631,364184,368527,372706,376566,380324,383883,387166,390317,393313,396113,398740,401280,403738,406052,408354,410377,412396,414392,416247,417975,419595,421150,422691,424144,425485,426820,428109,429364,430516,431555,432656,433705,434692,435613,436467,437317,438180,438981,439759,440514,441279,442011,442674,443328,443902,444470,445066,445654,446194,446716,447228,447708,448160,448589,449025,449431,449827,450225,450612,450989,451338,451699,452030,452350,452634,452941,453170,453442,453698,453938,454182,454402,454619,454844,455063,455289,455507,455680,455878,456068,456237,456395,456551,456718,456892,457035,457173,457300,457429,457547,
1,699,5382,15469,30265,47230,65169,83576,101487,118772,135397,150774,165051,178211,190699,202395,213360,223645,233133,242005,250419,258301,265468,272363,278895,285040,290550,295917,301035,305815,310280,314454,318462,322231,325745,329175,332383,335398,338153,340815,343357,345855,348278,350494,352705,354756,356685,358571,360402,362123,363687,365201,366705,368124,369470,370793,371969,373210,374334,375478,376515,377521,378489,379420,380310,381155,381981,382786,383610,384365,385066,385754,386408,387051,387608,388155,388748,389260,389782,390303,390798,391283,391692,392100,392521,392894,393264,393657,394025,394379,394724,395065,395379,395695,395995,396295,396538,396808,397067,397323,397554,397787,398005,398210,398417,398601,398789,398967,399158,399337,399496,399641,399803,399966,400110,400274,400425,400552,400699,400828,
0,244,2282,8065,17197,28955,42110,56015,70057,83869,97474,110188,122307,133753,144482,154800,164534,173590,181913,189816,197393,204534,211342,217595,223503,229042,234241,239199,243846,248281,252417,256286,260057,263578,266916,270188,273229,276121,278809,281344,283824,286329,288650,290734,292835,294726,296650,298498,300194,301893,303398,304851,306277,307685,308950,310133,311401,312628,313771,314825,315836,316811,317727,318633,319533,320387,321148,321938,322712,323431,324144,324746,325387,325983,326593,327154,327668,328181,328701,329206,329684,330119,330514,330952,331380,331781,332155,332521,332919,333276,333627,333953,334293,334599,334920,335208,335487,335787,336034,336282,336522,336732,336932,337149,337378,337580,337757,337919,338113,338277,338459,338599,338756,338922,339063,339220,339363,339489,339613,339735,
0,62,966,4027,9704,17264,26506,36812,47586,58519,69224,79811,90042,99658,108894,117637,126073,133920,141479,148513,155195,161530,167504,173156,178490,183611,188487,193079,197438,201487,205476,209068,212602,215900,218978,221935,224867,227672,230223,232624,234891,237111,239225,241384,243324,245221,247064,248749,250360,251924,253454,254853,256244,257562,258773,259952,261150,262254,263332,264373,265358,266296,267182,268032,268885,269680,270430,271175,271893,272518,273210,273836,274480,275037,275612,276127,276643,277142,277623,278073,278482,278951,279350,279736,280152,280555,280907,281293,281592,281966,282325,282660,282964,283266,283551,283790,284048,284307,284532,284803,285017,285261,285491,285695,285883,286088,286274,286444,286631,286817,286983,287136,287300,287458,287607,287750,287888,288020,288154,288287,
0,12,341,1643,4461,8875,14545,21311,28684,36527,44353,52209,60175,67589,74989,82141,88911,95416,101508,107430,113076,118458,123630,128475,133221,137678,141990,146093,150013,153635,157147,160462,163600,166625,169425,172124,174811,177334,179668,181849,183943,186052,187998,189885,191701,193415,195031,196658,198157,199566,200961,202284,203547,204705,205866,206970,208054,209108,210082,211003,211977,212872,213772,214584,215399,216139,216892,217605,218282,218913,219531,220162,220734,221335,221898,222420,222919,223407,223856,224322,224771,225234,225620,226038,226429,226802,227167,227506,227860,228218,228547,228830,229090,229358,229614,229890,230150,230386,230608,230831,231063,231252,231441,231657,231882,232050,232218,232410,232581,232752,232928,233090,233223,233361,233514,233649,233785,233929,234068,234182,
0,1,63,446,1467,3329,6138,9781,14047,18807,23910,29191,34634,39988,45390,50613,55736,60658,65519,70301,74862,79077,83200,87183,90952,94617,98145,101430,104591,107543,110523,113334,116013,118599,121133,123547,125817,127912,130018,131989,133805,135581,137398,139035,140583,142099,143474,144863,146190,147476,148730,149892,151001,152163,153182,154206,155217,156141,157014,157906,158759,159499,160236,160998,161715,162406,163084,163766,164358,164977,165562,166087,166615,167132,167632,168121,168555,169015,169451,169853,170269,170644,171015,171354,171710,172074,172411,172722,172989,173303,173619,173909,174141,174418,174671,174923,175142,175387,175610,175822,176025,176220,176422,176611,176826,176989,177143,177321,177507,177656,177809,177954,178090,178242,178373,178503,178615,178728,178853,178957,
0,0,2,47,243,711,1611,2883,4646,6724,9201,11860,14707,17681,20748,23810,26950,30004,33159,36221,39202,42150,45016,47820,50536,53197,55687,58036,60368,62590,64771,66846,68925,70880,72758,74506,76230,77960,79581,81163,82658,84056,85429,86653,87908,89147,90292,91503,92601,93654,94677,95705,96643,97516,98414,99262,100136,100909,101649,102436,103132,103756,104460,105047,105655,106236,106780,107346,107868,108364,108881,109362,109807,110289,110717,111081,111485,111870,112229,112591,112925,113315,113616,113929,114244,114564,114884,115170,115492,115730,116000,116251,116506,116747,116998,117209,117421,117622,117827,118014,118190,118356,118525,118684,118825,118971,119098,119229,119366,119493,119637,119780,119893,120026,120151,120263,120357,120466,120583,120678,
171750,432083,609018,730728,820141,888212,942099,985780,1022068,1052243,1078090,1100550,1119919,1137090,1152308,1165735,1177828,1188788,1198656,1207754,1215862,1223105,1230046,1236345,1242091,1247411,1252366,1256993,1261248,1265368,1269191,1272702,1275923,1279021,1281861,1284615,1287176,1289617,1291828,1294055,1296085,1297946,1299760,1301545,1303230,1304750,1306195,1307585,1308908,1310170,1311388,1312522,1313622,1314711,1315698,1316629,1317564,1318440,1319242,1320011,1320741,1321435,1322116,1322796,1323439,1324081,1324623,1325174,1325707,1326194,1326708,1327209,1327663,1328123,1328526,1328942,1329322,1329710,1330069,1330424,1330775,1331106,1331413,1331729,1331996,1332266,1332540,1332801,1333030,1333251,1333469,1333691,1333905,1334080,1334277,1334463,1334644,1334833,1335007,1335153,1335306,1335475,1335616,1335756,1335906,1336034,1336154,1336278,1336388,1336521,1336652,1336750,1336861,1336966,1337074,1337171,1337259,1337369,1337449,1337525,
88169,287771,447123,563541,652104,720544,776004,821355,858967,891219,918477,942334,962942,981258,997223,1011701,1024906,1036625,1047436,1057227,1066230,1074290,1081734,1088529,1094787,1100795,1106339,1111335,1116042,1120368,1124433,1128279,1131919,1135233,1138409,1141362,1144096,1146722,1149189,1151573,1153834,1155900,1157920,1159854,1161646,1163316,1164899,1166399,1167803,1169194,1170474,1171739,1173039,1174239,1175332,1176325,1177402,1178340,1179291,1180163,1180999,1181764,1182532,1183245,1183921,1184595,1185191,1185803,1186372,1186929,1187526,1188041,1188532,1189011,1189460,1189900,1190336,1190711,1191146,1191491,1191872,1192219,1192580,1192911,1193228,1193515,1193817,1194117,1194388,1194647,1194897,1195141,1195391,1195584,1195779,1195985,1196173,1196369,1196557,1196715,1196890,1197073,1197226,1197391,1197547,1197685,1197846,1197984,1198110,1198241,1198385,1198511,1198623,1198736,1198853,1198968,1199064,1199181,1199284,1199368,
54808,216202,360115,470631,556136,623887,678871,724322,762746,795245,823497,848124,869390,888281,905007,919985,933582,945904,956942,967080,976343,984796,992624,999686,1006190,1012410,1018162,1023484,1028260,1032729,1037110,1041188,1045026,1048521,1051890,1055070,1057988,1060689,1063244,1065715,1068081,1070328,1072412,1074422,1076276,1078046,1079707,1081272,1082817,1084307,1085691,1087002,1088321,1089594,1090727,1091824,1092856,1093868,1094878,1095762,1096597,1097421,1098214,1098957,1099661,1100359,1101032,1101670,1102265,1102848,1103394,1103941,1104468,1104922,1105410,1105865,1106314,1106755,1107180,1107574,1107982,1108341,1108742,1109115,1109422,1109734,1110036,1110329,1110603,1110838,1111090,1111338,1111575,1111811,1112043,1112275,1112493,1112707,1112917,1113104,1113289,1113494,1113656,1113840,1114002,1114126,1114282,1114427,1114570,1114706,1114850,1114964,1115078,1115212,1115338,1115440,1115539,1115650,1115753,1115845,
29310,150294,273347,374315,455630,521189,574494,619331,657319,690097,718304,742966,764758,783973,801061,816385,830333,842757,854456,864743,874253,883168,891190,898659,905536,911899,917892,923546,928814,933577,937972,942154,946144,949842,953398,956694,959847,962767,965461,968030,970430,972802,974976,977048,979064,980873,982650,984345,985957,987517,988990,990373,991674,992993,994288,995438,996506,997582,998566,999525,1000436,1001327,1002180,1003001,1003781,1004539,1005186,1005885,1006507,1007111,1007733,1008340,1008852,1009405,1009909,1010387,1010855,1011310,1011787,1012215,1012638,1013069,1013471,1013842,1014184,1014527,1014867,1015185,1015486,1015737,1016044,1016306,1016563,1016792,1016991,1017240,1017446,1017673,1017904,1018081,1018286,1018469,1018641,1018844,1019020,1019162,1019304,1019459,1019616,1019751,1019899,1020031,1020175,1020315,1020465,1020576,1020700,1020824,1020932,1021040,
12730,91847,189197,275587,349061,409918,461282,504530,541581,573406,601319,626051,648137,667478,684854,700515,714600,727443,739140,749786,759609,768559,776745,784323,791378,797998,804068,809749,815028,819965,824708,829092,833399,837229,840807,844223,847475,850469,853298,856024,858569,860958,863251,865373,867496,869410,871308,873083,874764,876333,877871,879369,880686,882013,883348,884539,885713,886833,887887,888877,889842,890806,891667,892531,893328,894147,894858,895577,896254,896898,897530,898159,898730,899263,899795,900292,900774,901251,901666,902150,902609,903059,903479,903903,904276,904632,904989,905353,905677,905976,906266,906574,906868,907139,907393,907647,907869,908086,908311,908494,908701,908925,909099,909280,909449,909620,909781,909915,910074,910199,910354,910510,910647,910768,910897,911043,911156,911288,911391,911503,
7273,66341,148600,225945,293259,351053,400289,441862,478417,510012,537528,561875,583501,602653,619923,635727,650057,663022,674701,685668,695389,704406,712845,720571,727701,734454,740680,746501,751953,756935,761674,766166,770393,774317,777952,781368,784657,787754,790750,793443,795971,798473,800806,803047,805167,807192,809053,810815,812464,814047,815646,817129,818546,819905,821176,822421,823666,824755,825894,826923,827892,828781,829717,830595,831469,832242,833042,833788,834510,835169,835807,836422,837041,837579,838145,838675,839188,839673,840153,840643,841113,841520,841918,842321,842727,843067,843433,843786,844126,844445,844750,845068,845363,845614,845831,846078,846312,846549,846776,846969,847191,847408,847574,847776,847961,848118,848264,848416,848599,848773,848917,849071,849223,849354,849483,849641,849752,849888,850017,850143,
3605,45097,112013,179367,240285,293151,339689,379744,414456,445152,471829,495522,517041,536014,553245,568627,582866,595794,607534,618483,628517,637680,646131,653939,661193,667936,674169,680052,685536,690804,695572,700112,704302,708238,712002,715460,718792,721963,724847,727637,730305,732840,735296,737598,739835,741835,743803,745656,747373,748983,750589,752038,753486,754900,756194,757438,758649,759779,760866,761943,762927,763864,764720,765603,766433,767212,768010,768817,769545,770252,770967,771609,772242,772827,773428,773969,774485,774964,775436,775900,776361,776810,777267,777680,778063,778443,778813,779139,779467,779788,780095,780373,780653,780968,781234,781462,781708,781957,782207,782444,782680,782887,783089,783271,783455,783634,783813,783966,784134,784289,784438,784589,784740,784865,784990,785126,785258,785371,785500,785613,
1633,28292,78632,134615,187454,235296,277584,314835,347542,376557,402183,425097,445730,464226,481022,496327,510236,523077,534742,545433,555342,564528,573047,580912,588340,595007,601226,607210,612672,617730,622650,627077,631244,635331,639033,642668,646013,649245,652201,655051,657696,660205,662611,664939,667174,669203,671181,673007,674813,676500,678041,679514,680942,682410,683744,685042,686335,687489,688598,689637,690703,691687,692615,693569,694445,695266,696062,696820,697514,698202,698868,699519,700148,700731,701330,701898,702452,702936,703432,703875,704323,704756,705226,705642,706041,706434,706804,707164,707508,707868,708167,708497,708795,709078,709333,709603,709836,710086,710322,710538,710768,710977,711175,711351,711532,711730,711884,712057,712211,712383,712566,712742,712912,713058,713188,713338,713458,713604,713735,713850,
565,15328,50543,93377,137054,178103,215449,248969,279134,306152,330424,352134,371844,389753,405952,420604,434246,446644,457918,468514,478043,487018,495372,503113,510209,516801,523135,528962,534412,539508,544270,548694,552896,556684,560434,563991,567310,570538,573439,576368,579026,581495,583882,586185,588403,590494,592512,594423,596246,597870,599553,601168,602625,604060,605399,606681,607916,609130,610248,611373,612389,613374,614360,615262,616186,617023,617821,618615,619398,620130,620820,621526,622122,622742,623356,623913,624476,625012,625545,626029,626453,626938,627357,627800,628199,628569,628966,629348,629708,630058,630402,630699,631009,631313,631601,631881,632149,632396,632630,632862,633090,633334,633540,633708,633894,634079,634266,634430,634600,634767,634941,635090,635230,635395,635540,635693,635809,635933,636044,636163,
261,9782,36310,71444,108889,145360,179109,209674,237826,263383,286271,307234,326080,343163,359026,373443,386383,398494,409583,419886,429511,438316,446582,454303,461326,468017,474171,479935,485298,490328,495095,499561,503754,507773,511559,515053,518454,521650,524629,527465,530164,532653,535120,537433,539646,541716,543733,545666,547437,549095,550694,552262,553757,555214,556613,557896,559093,560317,561404,562470,563484,564460,565400,566359,567257,568123,568972,569767,570547,571261,571970,572635,573297,573948,574561,575143,575664,576210,576681,577186,577669,578153,578564,579020,579455,579869,580277,580637,581009,581374,581710,582018,582292,582607,582869,583115,583386,583621,583890,584150,584368,584573,584802,584978,585172,585348,585521,585711,585874,586013,586181,586357,586512,586682,586848,586990,587121,587247,587372,587497,
92,5926,24830,52510,83797,115023,144992,172618,198286,221732,243029,262277,280142,296630,311503,325196,337722,349325,360086,370089,379344,387814,395806,403274,410176,416462,422530,428198,433569,438597,443232,447607,451723,455623,459369,462761,466171,469299,472238,475024,477704,480311,482703,484987,487240,489388,491408,493322,495140,496862,498458,500003,501449,502901,504286,505601,506731,507871,509069,510188,511280,512309,513196,514116,514954,515845,516673,517471,518208,518932,519617,520306,520958,521617,522200,522755,523309,523877,524344,524876,525364,525797,526240,526660,527113,527512,527917,528318,528683,529040,529370,529686,530029,530319,530596,530885,531132,531381,531621,531881,532116,532333,532534,532766,532954,533117,533301,533469,533647,533800,533959,534132,534293,534450,534602,534725,534876,534996,535126,535234,
32,2931,15381,35688,60120,86057,111215,135442,157985,179331,198954,217058,233506,248858,263105,276017,287701,298855,309100,318563,327423,335572,343188,350225,356915,363222,369125,374613,379873,384726,389269,393646,397672,401529,405173,408659,411826,414954,417954,420709,423333,425864,428211,430480,432689,434701,436702,438588,440378,442053,443715,445247,446742,448116,449450,450710,451950,453096,454257,455317,456412,457433,458389,459321,460218,461023,461861,462653,463385,464091,464838,465557,466188,466803,467360,467925,468446,469000,469547,470026,470452,470919,471373,471808,472219,472622,473045,473412,473764,474119,474456,474809,475119,475415,475698,475990,476266,476521,476795,477009,477253,477448,477675,477894,478097,478297,478501,478656,478829,479002,479147,479309,479472,479615,479788,479939,480088,480202,480322,480458,
2,1304,8499,22104,40080,60189,80825,101080,120511,138851,156065,172214,187117,200707,213687,225673,236725,246797,256313,265316,273641,281457,288658,295470,301907,307847,313542,318811,323947,328665,333169,337333,341388,345129,348710,352184,355371,358360,361126,363809,366409,368810,371204,373444,375607,377668,379592,381440,383213,384840,386398,387881,389348,390769,392136,393404,394605,395742,396794,397885,398947,399898,400868,401775,402659,403474,404259,405038,405774,406509,407215,407906,408541,409169,409779,410351,410895,411454,411970,412432,412887,413350,413767,414172,414586,414977,415351,415764,416117,416472,416786,417111,417410,417712,417991,418280,418539,418831,419085,419334,419573,419786,420006,420206,420408,420604,420810,420978,421151,421337,421510,421682,421809,421961,422130,422300,422446,422580,422699,422843,
1,497,4008,12069,23968,38371,53766,69725,85623,100625,115193,128932,141953,154003,165295,175936,186025,195252,203912,212042,219692,226995,233807,240094,246080,251457,256816,261795,266649,270992,275112,278949,282575,286228,289561,292792,295786,298711,301367,304016,306426,308645,310918,313038,315114,317138,319020,320826,322484,324096,325662,327124,328597,329960,331271,332460,333702,334863,335977,337047,338048,339082,340035,340943,341814,342631,343429,344211,344944,345638,346316,346943,347552,348168,348731,349314,349812,350345,350870,351385,351830,352290,352730,353173,353571,353942,354276,354660,355050,355410,355720,356038,356374,356648,356926,357204,357469,357724,357962,358221,358454,358664,358894,359084,359282,359478,359635,359813,360002,360186,360369,360533,360683,360852,360993,361147,361296,361426,361552,361681,
0,164,1774,6367,13911,23833,35027,47201,59449,71706,83609,94943,105698,116210,126008,135261,144081,152214,159862,167216,174106,180545,186749,192608,198118,203081,207905,212697,217099,221193,225134,228775,232247,235606,238783,241693,244619,247296,249897,252278,254580,256877,259035,261019,262941,264830,266555,268262,269924,271551,273017,274376,275730,277018,278232,279422,280586,281705,282813,283861,284825,285787,286683,287534,288366,289200,289987,290693,291434,292079,292744,293398,293982,294567,295128,295644,296150,296660,297184,297663,298131,298542,298937,299316,299702,300101,300463,300830,301179,301525,301874,302206,302508,302814,303052,303302,303565,303800,304037,304293,304526,304759,304987,305202,305387,305570,305757,305938,306125,306300,306470,306615,306755,306912,307072,307201,307329,307447,307590,307711,
1,40,618,2683,6545,12285,19544,27716,36470,45255,54378,63125,71785,80078,88050,95667,102981,109935,116623,122863,128809,134419,139812,144830,149553,154097,158515,162573,166474,170015,173642,176879,180117,183221,186033,188855,191515,194023,196450,198708,200811,202892,204899,206827,208712,210484,212128,213728,215231,216709,218130,219457,220704,221968,223123,224274,225351,226391,227351,228318,229242,230068,230913,231722,232473,233246,233935,234626,235361,235978,236651,237260,237822,238437,238949,239454,239940,240426,240895,241314,241755,242188,242563,242975,243338,243733,244091,244423,244777,245102,245398,245679,245979,246273,246551,246807,247063,247307,247575,247792,248004,248206,248405,248611,248809,249013,249188,249340,249515,249680,249846,250014,250156,250311,250452,250575,250719,250869,250976,251096,
0,3,133,801,2379,5079,8786,13354,18590,24289,30176,36190,42407,48311,54233,60002,65638,71199,76268,81268,86095,90749,95099,99367,103299,107152,110904,114227,117542,120645,123671,126530,129289,131960,134493,136923,139276,141534,143655,145660,147590,149392,151227,152942,154515,156101,157553,159025,160314,161637,162930,164144,165243,166303,167342,168338,169317,170287,171228,172112,172933,173796,174605,175335,176041,176755,177443,178088,178727,179362,179928,180483,181031,181574,182094,182569,183014,183459,183883,184275,184639,185038,185419,185780,186157,186493,186821,187129,187440,187790,188050,188357,188624,188879,189112,189356,189574,189786,190026,190235,190456,190653,190849,191035,191220,191396,191555,191703,191863,192018,192165,192313,192456,192589,192714,192832,192964,193086,193188,193293,
0,0,11,110,447,1207,2443,4210,6426,9137,12201,15442,18890,22337,25790,29338,32839,36246,39687,43090,46447,49582,52676,55700,58523,61304,64000,66601,69112,71535,73849,76046,78227,80273,82240,84145,85891,87702,89319,90970,92604,94094,95599,96950,98323,99585,100765,101954,103055,104133,105183,106196,107141,108039,108882,109772,110635,111391,112146,112928,113645,114335,114956,115611,116295,116883,117487,118052,118590,119082,119624,120090,120540,120983,121418,121846,122281,122700,123077,123445,123791,124132,124453,124774,125067,125354,125634,125954,126233,126504,126737,126991,127263,127508,127725,127925,128151,128360,128557,128763,128951,129122,129278,129474,129635,129763,129896,130019,130162,130298,130424,130568,130697,130817,130930,131048,131154,131273,131375,131490,
40281,250499,477770,666146,818750,943860,1048691,1137715,1213361,1279383,1336285,1387923,1433688,1474873,1512595,1547035,1578878,1607702,1634371,1658992,1682039,1703507,1723708,1742885,1760635,1777402,1793003,1807767,1821826,1835344,1848157,1860319,1872085,1883203,1893962,1904244,1914066,1923474,1932520,1941300,1949722,1957676,1965504,1973060,1980454,1987583,1994369,2000950,2007416,2013556,2019640,2025348,2031097,2036718,2042045,2047241,2052295,2057316,2062021,2066658,2071234,2075763,2080020,2084344,2088511,2092480,2096386,2100238,2103787,2107305,2110841,2114381,2117834,2121094,2124370,2127528,2130570,2133644,2136642,2139636,2142513,2145319,2148074,2150833,2153455,2156062,2158706,2161252,2163713,2166122,2168541,2170840,2173154,2175415,2177613,2179869,2182050,2184176,2186282,2188365,2190412,2192444,2194453,2196393,2198280,2200177,2201913,2203754,2205520,2207268,2208961,2210704,2212384,2214008,2215631,2217240,2218937,2220541,2222117,2223716,
5873,91637,239374,390174,527068,647230,752151,844956,926512,998617,1062673,1120701,1172739,1220172,1263724,1303678,1340594,1374838,1406404,1436019,1463878,1489812,1514148,1537422,1559057,1579585,1599075,1617465,1634927,1651692,1667712,1682971,1697395,1711291,1724644,1737393,1749708,1761541,1772802,1783522,1793994,1804074,1813791,1823280,1832335,1841324,1849966,1858223,1866319,1874053,1881889,1889090,1896258,1903338,1910057,1916898,1923167,1929410,1935349,1941267,1946942,1952592,1958094,1963560,1968760,1973907,1978775,1983528,1988253,1992808,1997445,2001875,2006188,2010372,2014608,2018706,2022617,2026418,2030330,2034108,2037847,2041479,2045033,2048530,2051984,2055427,2058666,2061883,2065130,2068249,2071350,2074442,2077432,2080300,2083160,2086004,2088757,2091396,2094106,2096726,2099311,2101921,2104470,2107022,2109395,2111838,2114182,2116417,2118686,2121006,2123259,2125469,2127611,2129719,2131877,2133977,2136023,2138151,2140202,2142154,
1114,38988,134032,249743,366000,474806,573773,663621,744326,817045,883160,943422,998119,1048413,1094522,1137583,1177453,1214598,1249385,1281682,1312358,1340954,1368084,1393505,1417441,1440071,1461905,1482508,1502020,1520760,1538526,1555681,1572074,1587759,1602917,1617331,1631054,1644314,1657342,1669470,1681542,1692771,1703863,1714763,1725027,1735107,1744832,1754186,1763325,1772263,1780967,1789338,1797639,1805690,1813361,1820869,1828219,1835325,1842296,1849044,1855549,1862018,1868416,1874655,1880688,1886553,1892299,1897769,1903214,1908613,1913843,1918861,1923977,1928726,1933561,1938255,1942846,1947450,1951979,1956259,1960554,1964846,1968900,1972931,1976912,1980768,1984644,1988363,1992123,1995709,1999332,2002881,2006331,2009717,2012868,2016097,2019415,2022490,2025565,2028662,2031575,2034508,2037466,2040377,2043132,2045857,2048594,2051288,2053860,2056497,2059016,2061617,2064153,2066718,2069230,2071679,2074010,2076425,2078852,2081184,
87,10521,55396,127333,211141,297503,381573,461722,536989,606379,670929,730707,786569,838077,886106,930972,972704,1012077,1049033,1084018,1116935,1148230,1177481,1205459,1231977,1257255,1281391,1304417,1326057,1347057,1366987,1386083,1404288,1422067,1439140,1455583,1471511,1486838,1501509,1515671,1529386,1542774,1555304,1567810,1579695,1591490,1602842,1613751,1624487,1634651,1644558,1654224,1663700,1672892,1681945,1690639,1699185,1707591,1715601,1723603,1731204,1738651,1745946,1753118,1760174,1767044,1773785,1780360,1786823,1793057,1799201,1805251,1811080,1816771,1822374,1827909,1833290,1838566,1843826,1848893,1853888,1858882,1863793,1868475,1873082,1877665,1882211,1886711,1891145,1895329,1899508,1903702,1907696,1911676,1915601,1919435,1923213,1926967,1930639,1934332,1937793,1941223,1944779,1948150,1951551,1954828,1958096,1961316,1964424,1967446,1970513,1973671,1976665,1979715,1982649,1985528,1988401,1991161,1993932,1996709,
1,1172,12619,41710,85343,138660,197047,256672,316415,374694,430565,484382,535575,584887,631389,675098,716970,756484,794167,830210,864369,897115,928414,958170,986932,1014181,1040431,1065437,1089275,1112439,1134779,1156140,1176556,1196683,1215780,1234301,1252203,1269366,1286346,1302236,1317879,1333065,1347640,1361877,1375778,1389210,1402183,1415062,1427525,1439385,1450972,1462395,1473518,1484502,1495097,1505371,1515498,1525383,1534957,1544286,1553259,1562169,1570735,1579105,1587538,1595676,1603612,1611445,1619155,1626676,1634121,1641220,1648255,1655136,1661854,1668408,1675047,1681427,1687733,1693809,1699924,1705780,1711573,1717200,1722808,1728439,1733947,1739254,1744552,1749785,1754867,1759910,1764679,1769465,1774296,1778993,1783590,1788125,1792606,1797005,1801452,1805643,1809792,1813900,1817916,1821785,1825845,1829754,1833575,1837472,1841126,1844777,1848455,1852004,1855582,1859078,1862542,1865877,1869325,1872792,
0,212,3922,17024,41868,75969,116939,162405,209803,257771,306166,353176,398990,443839,486916,528451,567996,606133,642747,677774,711816,744253,775699,805752,834416,862463,889136,915225,940201,964245,987547,1009801,1031366,1052173,1072086,1091620,1110556,1128722,1146406,1163651,1180225,1196503,1212385,1227805,1242613,1257140,1271387,1285104,1298181,1310974,1323634,1335901,1347837,1359504,1370829,1381738,1392672,1403389,1413894,1424044,1433961,1443616,1452874,1462235,1471418,1480415,1489065,1497596,1505883,1514236,1522479,1530298,1538024,1545618,1553072,1560404,1567407,1574446,1581483,1588150,1594791,1601118,1607523,1613845,1619989,1626212,1632198,1638058,1644024,1649690,1655285,1660825,1666395,1671779,1677029,1682255,1687421,1692519,1697546,1702413,1707232,1712103,1716593,1721237,1726029,1730539,1734963,1739429,1743880,1748099,1752228,1756384,1760432,1764374,1768285,1772194,1776058,1779848,1783581,1787387,
0,13,800,5095,15783,33040,57031,86018,118657,153685,190715,227967,265484,303255,340179,376615,412316,447200,481076,514134,545785,576702,606957,635849,663973,691463,717809,743337,768597,792626,815914,838497,860548,882083,902890,922934,942485,961376,979516,997616,1015039,1032104,1048689,1064609,1080225,1095623,1110746,1125153,1139318,1153130,1166476,1179775,1192560,1205170,1217476,1229522,1241282,1252857,1264155,1275265,1285969,1296565,1306751,1316907,1326860,1336721,1346422,1355765,1364899,1373970,1382838,1391713,1400191,1408489,1416662,1424722,1432666,1440431,1448012,1455484,1462925,1470316,1477403,1484422,1491124,1497884,1504451,1510936,1517593,1523845,1530143,1536303,1542461,1548369,1554307,1560140,1565837,1571531,1577006,1582684,1588177,1593497,1598795,1603827,1608929,1614027,1618900,1623894,1628818,1633564,1638182,1642983,1647581,1652114,1656467,1660883,1665301,1669566,1673793,1677981,
0,1,78,795,3535,9561,19633,33719,51283,72043,95031,120077,146309,173725,201709,229897,258383,286845,315228,343269,370761,398044,424506,450772,476162,501330,525863,550155,573596,596447,618780,640887,662255,682734,703396,723290,742712,761619,780256,798081,816027,833439,850405,866631,882781,898549,913945,929272,944203,958749,972876,986919,1000249,1013662,1026936,1039670,1052105,1064470,1076613,1088612,1100137,1111456,1122517,1133635,1144168,1154653,1165127,1175400,1185317,1195159,1204810,1214454,1223564,1232805,1241737,1250669,1259271,1267924,1276245,1284324,1292402,1300406,1308444,1316194,1323591,1330849,1338381,1345779,1352969,1360185,1367010,1373949,1380788,1387465,1394136,1400589,1406982,1413374,1419691,1425877,1431963,1437984,1443980,1449904,1455609,1461300,1466911,1472476,1477910,1483431,1488744,1493984,1499181,1504381,1509404,1514409,1519374,1524289,1529224,1534007,
0,0,1,43,322,1299,3557,7569,13441,21338,31509,43416,56975,71968,88529,105929,124202,142936,162619,182391,202304,222816,243227,263758,284018,304533,324736,345051,365031,384861,404481,423765,442783,461451,480007,498118,515980,533860,551350,568564,585435,601752,618086,634159,649819,665129,680319,695381,709968,724352,738612,752488,766054,779508,792749,805897,818781,831541,843782,856031,867971,879743,891305,902672,913977,925030,935928,946664,957304,967829,977967,988229,998078,1007825,1017432,1027044,1036408,1045601,1054678,1063603,1072449,1081218,1089741,1098246,1106595,1115010,1123005,1131037,1138946,1146883,1154490,1161872,1169277,1176706,1183857,1191054,1198144,1205108,1211951,1218814,1225585,1232227,1238658,1245062,1251340,1257795,1264194,1270521,1276776,1282786,1288698,1294726,1300695,1306457,1312146,1317823,1323400,1328912,1334419,1339759,
0,0,0,2,37,188,704,1876,3970,7131,11519,17231,24210,32323,41848,52283,63940,76273,89280,103123,117293,132218,147268,162829,178443,194603,210755,226943,243294,259397,275763,291912,307914,324093,340161,356304,372253,388008,403646,419246,434421,449662,464497,479368,493840,508333,522628,536767,550617,564356,577866,591190,604154,617113,629915,642648,655301,667810,679997,691820,703738,715477,726991,738309,749524,760474,771198,781888,792701,803262,813452,823502,833452,843446,853237,862888,872403,881831,891128,900164,909144,918092,926942,935761,944358,952908,961218,969402,977653,985754,993746,1001694,1009462,1017186,1024845,1032364,1039833,1047078,1054311,1061632,1068717,1075739,1082623,1089414,1096214,1102859,1109491,1116026,1122352,1128796,1135241,1141522,1147806,1153963,1160078,1166130,1172037,1177853,1183750,1189538,
0,0,0,0,2,11,64,234,677,1451,2645,4489,7046,10353,14326,19113,24512,30986,37771,45429,53687,62622,72021,81828,92181,102812,113835,125094,136803,148637,160519,172734,184954,197324,209922,222379,234850,247353,259788,272491,285031,297549,310031,322543,334977,347457,359872,372225,384341,396503,408235,420178,432178,443857,455424,467025,478380,489611,500911,511958,522861,533656,544562,555329,565966,576675,587127,597274,607534,617601,627617,637557,647198,656896,666383,675802,685170,694370,703381,712362,721257,730193,738951,747676,756222,764844,773384,781656,789852,797950,806045,814074,822115,829979,837699,845378,852831,860213,867635,875092,882275,889476,896641,903778,910605,917573,924492,931249,937978,944597,951202,957730,964111,970564,976938,983126,989348,995577,1001604,1007677,
0,0,0,0,0,1,3,13,41,121,293,590,1097,1801,2826,4155,5879,7849,10346,13256,16488,20244,24351,28960,33883,39333,44994,51064,57337,63933,70904,78199,85604,93278,101195,109294,117422,126079,134743,143380,152138,161036,169914,178840,187910,197019,206172,215336,224673,233978,243294,252722,262070,271518,280812,290238,299605,308969,318452,327736,336948,345999,355221,364429,373520,382500,391505,400395,409205,418086,426897,435635,444440,453178,461948,470627,479061,487393,495737,503921,512156,520469,528610,536689,544638,552397,560414,568121,575848,583464,591091,598630,606079,613590,620917,628271,635581,642855,650119,657135,664155,671204,678048,684922,691899,698661,705324,711989,718653,725165,731711,738158,744512,750926,757191,763515,769745,775905,782015,788130,
0,0,0,0,0,0,0,0,1,2,8,24,48,117,212,372,572,889,1309,1839,2539,3366,4339,5484,6839,8395,10115,12051,14202,16596,19200,21980,25122,28316,31737,35409,39224,43022,46973,51311,55833,60361,65154,70127,75060,80152,85467,90872,96308,101860,107626,113329,119200,125107,130998,137007,143180,149457,155626,161846,168144,174572,180891,187297,193682,200110,206524,213006,219448,226012,232556,239163,245711,252257,258678,265207,271781,278423,285043,291720,298322,304809,311380,317905,324423,330876,337425,343981,350406,356829,363204,369661,375914,382264,388415,394718,400974,407282,413498,419613,425875,431987,438219,444387,450431,456403,462310,468359,474353,480207,486031,491864,497721,503570,509403,515117,520862,526575,532291,537754,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,8,10,22,34,57,90,138,209,305,416,569,786,1016,1271,1629,2046,2515,3060,3660,4358,5089,5901,6842,7881,8984,10169,11470,12823,14276,15766,17312,18909,20752,22596,24537,26506,28669,30856,33081,35469,37799,40317,42924,45601,48355,51213,54046,56942,59823,62974,66134,69419,72659,76073,79337,82699,86080,89627,93255,96758,100399,104004,107705,111429,115210,119025,122738,126555,130461,134403,138329,142213,146265,150339,154338,158405,162504,166459,170457,174672,178847,183066,187304,191555,195842,199971,204227,208361,212424,216735,220992,225161,229345,233585,237843,242139,246429,250596,254847,259148,263363,267649,271845,276193,280383,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,5,6,6,9,17,30,52,65,85,116,148,194,254,315,429,513,619,744,909,1074,1292,1509,1756,2014,2325,2633,2984,3371,3790,4216,4710,5234,5746,6371,6967,7658,8351,9115,9848,10677,11527,12372,13254,14222,15177,16144,17229,18318,19523,20666,21890,23105,24336,25605,27025,28419,29804,31289,32800,34336,35885,37530,39147,40831,42510,44192,45972,47774,49547,51404,53292,55153,57057,59032,60965,62909,64877,66938,69052,71081,73127,75303,77460,79635,81991,84177,86411,88716,91035,93261,95649,97971,100321,102750,105149,107565,109962,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,5,7,11,13,25,33,46,54,68,76,91,113,140,175,192,216,243,278,317,359,412,483,563,642,718,798,893,983,1093,1197,1340,1464,1597,1727,1896,2049,2248,2437,2635,2849,3065,3301,3526,3777,4060,4334,4635,4920,5233,5540,5887,6254,6604,6935,7324,7733,8177,8578,9023,9508,9983,10496,10966,11504,12023,12550,13114,13695,14248,14799,15412,16071,16705,17349,18004,18657,19344,20061,20789,21517,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,6,7,9,11,14,16,17,20,25,34,39,43,52,57,63,68,76,83,89,100,119,132,147,164,182,202,219,240,257,281,306,326,355,383,414,440,480,520,547,586,628,682,735,783,826,877,946,999,1054,1123,1194,1259,1337,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,3,3,4,4,5,6,6,6,7,7,7,8,9,
43996,259951,487095,673544,823930,946549,1048910,1135410,1210010,1273845,1329873,1379790,1424682,1464923,1501546,1534765,1565488,1593763,1619542,1643442,1666243,1687006,1706752,1725210,1742452,1758861,1774180,1788616,1802440,1815333,1827818,1839559,1850899,1861834,1872165,1881885,1891428,1900540,1909419,1917897,1926028,1933811,1941181,1948487,1955521,1962452,1969096,1975491,1981573,1987738,1993664,1999293,2004754,2010107,2015320,2020419,2025264,2029950,2034501,2039059,2043371,2047741,2051968,2056147,2060111,2063879,2067670,2071462,2075111,2078616,2082052,2085401,2088758,2091897,2095071,2098245,2101192,2104164,2107021,2109954,2112792,2115482,2118172,2120788,2123386,2125891,2128383,2130872,2133321,2135682,2138066,2140341,2142610,2144758,2146960,2149151,2151211,2153276,2155289,2157338,2159238,2161201,2163192,2165085,2166908,2168728,2170535,2172297,2173990,2175707,2177426,2179143,2180777,2182350,2183922,2185505,2187012,2188551,2190046,2191557,
6960,99494,251132,402164,538328,657017,760144,850443,930160,1000467,1062985,1119359,1169840,1215793,1257886,1296723,1332784,1365701,1396005,1424636,1451366,1476384,1500041,1522188,1543131,1562895,1581431,1599223,1615942,1632154,1647327,1661952,1676023,1689339,1702377,1714846,1726774,1738056,1748998,1759251,1769322,1779010,1788571,1797862,1806536,1814984,1823243,1831118,1838882,1846326,1853662,1860784,1867624,1874118,1880631,1886814,1892968,1898829,1904730,1910404,1916004,1921440,1926708,1931841,1936790,1941658,1946420,1951038,1955671,1960257,1964550,1968782,1973026,1977082,1980961,1984952,1988789,1992527,1996205,1999766,2003338,2006816,2010272,2013672,2017016,2020227,2023436,2026506,2029593,2032551,2035497,2038320,2041230,2044038,2046797,2049498,2052115,2054755,2057297,2059864,2062325,2064736,2067246,2069633,2072087,2074366,2076603,2078827,2081056,2083277,2085466,2087582,2089646,2091782,2093786,2095769,2097792,2099693,2101685,2103565,
1576,44314,144756,263682,379873,488257,586153,674379,753574,824876,889167,947752,1000784,1049357,1094232,1135758,1173911,1209670,1243011,1274487,1303675,1331365,1357103,1381462,1404611,1426639,1447424,1467118,1485722,1503410,1520602,1536916,1552471,1567496,1582034,1595882,1609110,1621972,1634336,1645927,1657468,1668482,1679263,1689718,1699746,1709485,1718815,1727779,1736444,1745016,1753034,1760959,1768853,1776509,1783997,1791069,1797997,1804897,1811398,1817751,1824088,1830288,1836293,1842207,1847975,1853541,1858948,1864277,1869548,1874692,1879737,1884512,1889304,1893940,1898577,1903094,1907340,1911634,1915820,1920075,1924208,1928229,1932089,1935976,1939754,1943475,1947043,1950640,1954168,1957590,1961077,1964391,1967731,1970996,1974115,1977240,1980360,1983395,1986344,1989161,1992057,1994934,1997746,2000512,2003186,2005817,2008373,2010997,2013570,2016097,2018593,2021006,2023393,2025746,2028120,2030453,2032764,2035037,2037316,2039496,
139,13222,63666,140910,227568,315492,399827,479408,553478,621849,684880,743056,796956,847023,893328,936638,977086,1014945,1050530,1084114,1115507,1145735,1173933,1200728,1225973,1249945,1273055,1294824,1315536,1335613,1354475,1372680,1390213,1407007,1423126,1438624,1453729,1468271,1482333,1495671,1508656,1521397,1533408,1545227,1556630,1567644,1578405,1588908,1598825,1608785,1618256,1627451,1636538,1645133,1653608,1661868,1670011,1677927,1685543,1692989,1700399,1707649,1714527,1721272,1728010,1734487,1740796,1747002,1753141,1759069,1764720,1770306,1775847,1781261,1786600,1791857,1797020,1802021,1806937,1811755,1816538,1821274,1825884,1830412,1834921,1839253,1843454,1847673,1851802,1855844,1859748,1863642,1867510,1871191,1874911,1878643,1882253,1885789,1889222,1892786,1896118,1899563,1902791,1906118,1909340,1912500,1915552,1918619,1921687,1924628,1927570,1930389,1933227,1935995,1938718,1941365,1944028,1946670,1949366,1951885,
3,1812,16444,49910,98107,154941,215940,277121,337490,395976,451494,504616,554815,602780,647975,690815,731418,769792,806335,840789,873751,905169,935040,963588,990768,1017157,1042196,1066215,1089225,1111297,1132259,1152821,1172111,1191083,1209215,1226834,1243824,1260216,1276066,1291280,1305841,1319947,1333658,1347148,1360231,1372949,1385048,1397117,1408460,1419898,1430829,1441400,1451876,1462082,1471825,1481553,1490976,1500108,1509083,1517810,1526424,1534765,1542799,1550797,1558600,1566445,1573984,1581237,1588359,1595365,1602266,1609090,1615651,1622169,1628521,1634751,1640766,1646759,1652722,1658566,1664294,1669883,1675393,1680825,1686151,1691330,1696295,1701219,1706194,1711054,1715741,1720449,1724917,1729491,1733971,1738187,1742552,1746906,1751069,1755123,1759092,1762981,1766928,1770798,1774644,1778363,1782009,1785773,1789359,1792830,1796308,1799649,1803067,1806489,1809832,1813025,1816256,1819373,1822599,1825735,
0,371,5778,22552,51827,90315,135115,183168,232414,282357,330784,378429,424531,468680,511365,552000,590907,628230,663740,697798,730614,761799,791877,820490,848277,874938,900446,925227,948891,971721,993516,1014479,1034947,1054640,1073591,1091742,1109667,1126872,1143617,1159963,1175618,1190769,1205324,1219577,1233609,1247068,1260031,1272965,1285513,1297608,1309344,1320677,1331925,1342893,1353719,1364140,1374500,1384556,1394239,1403737,1412893,1421865,1430753,1439518,1447994,1456270,1464363,1472318,1480217,1487755,1495107,1502380,1509564,1516549,1523304,1530106,1536610,1543168,1549700,1556018,1562256,1568424,1574375,1580190,1586029,1591641,1597208,1602605,1607968,1613293,1618404,1623503,1628578,1633532,1638483,1643320,1647982,1652518,1657096,1661617,1666112,1670478,1674898,1679340,1683722,1687965,1692174,1696280,1700322,1704371,1708156,1712039,1715765,1719405,1722962,1726701,1730267,1733834,1737240,1740651,
0,53,1332,7525,21406,42974,70936,103786,139387,176845,215775,254802,293657,331724,368979,405558,441262,475588,508768,541134,572165,602267,631428,659669,686727,713214,738822,763293,786842,810023,832239,853710,874608,894688,914297,933368,951687,969257,986406,1003349,1019829,1035831,1051113,1066264,1080919,1095204,1109317,1122655,1135821,1148902,1161588,1173885,1186035,1197615,1208952,1220073,1231036,1241798,1252136,1262315,1272183,1282016,1291425,1300805,1309993,1318876,1327825,1336591,1345113,1353370,1361548,1369429,1377178,1384909,1392394,1399901,1407190,1414351,1421486,1428334,1435013,1441885,1448488,1455005,1461208,1467412,1473588,1479684,1485769,1491544,1497351,1503110,1508805,1514341,1519725,1525005,1530283,1535409,1540533,1545609,1550498,1555444,1560333,1565084,1569707,1574227,1578904,1583376,1587778,1592199,1596472,1600710,1604860,1609015,1613008,1617051,1621021,1625027,1628888,1632795,
0,1,171,1496,5874,14686,27970,45564,66711,90928,117066,144664,173580,202789,232186,261605,291028,320273,349421,377903,405599,432521,458777,484628,509968,534441,558734,581715,604344,626646,648091,669447,689872,709715,729217,748266,766919,785056,802566,819750,836366,852475,868502,883924,899231,914036,928457,942521,956423,969975,983266,996184,1008704,1021239,1033243,1045140,1056728,1067961,1079105,1089800,1100371,1110830,1121128,1131143,1141028,1150776,1160281,1169489,1178692,1187696,1196683,1205323,1213806,1222185,1230451,1238609,1246566,1254427,1262070,1269589,1277162,1284367,1291615,1298591,1305610,1312343,1319092,1325756,1332339,1338866,1345178,1351503,1357730,1363877,1369733,1375469,1381275,1386957,1392658,1398235,1403740,1409251,1414567,1419868,1425106,1430159,1435182,1440270,1445184,1450003,1454862,1459579,1464375,1469082,1473572,1478124,1482669,1487065,1491519,1495721,
0,0,4,156,786,2674,6489,12828,21479,32487,45592,60781,77290,95213,114466,134341,154933,176099,197374,218876,240424,261975,283121,304410,325572,346331,366909,387377,407246,427262,446682,465841,484564,503014,520835,538223,555699,572948,589780,606389,622536,638485,653831,669055,683885,698499,712973,727109,740887,754426,767617,780649,793386,806161,818568,830614,842622,854440,865719,876947,888060,898795,909686,920103,930655,940772,950900,960812,970571,980112,989490,998855,1007844,1016876,1025694,1034445,1042913,1051294,1059576,1067747,1075876,1083637,1091481,1099317,1106793,1114279,1121652,1128665,1135862,1142926,1149756,1156648,1163319,1169864,1176449,1182891,1189143,1195409,1201726,1207872,1213890,1219972,1225793,1231687,1237369,1243131,1248812,1254274,1259835,1265165,1270635,1276044,1281276,1286550,1291640,1296661,1301611,1306489,1311277,1316043,
0,0,2,22,139,618,1863,4244,7954,13276,20149,28535,38419,49557,61860,75319,89688,104664,120359,136495,152953,169643,186467,203522,220511,237877,255193,272203,289358,306449,323233,340133,356722,373148,389217,405288,421192,436865,452253,467306,482209,496913,511448,525983,540214,554079,567879,581376,594752,607722,620497,633186,645771,658071,670185,682152,693866,705483,716672,727854,739025,750006,760749,771214,781616,791882,802014,811930,821854,831613,841121,850497,859736,868616,877678,886633,895348,903859,912249,920726,928879,937111,945192,952988,960577,968233,975845,983360,990698,998071,1005511,1012682,1019762,1026659,1033610,1040496,1047158,1053811,1060332,1066634,1072919,1079225,1085403,1091405,1097425,1103385,1109301,1115183,1120866,1126487,1132206,1137990,1143593,1149139,1154566,1159996,1165366,1170598,1175724,1180840,
0,0,0,1,12,66,278,855,2024,3759,6442,9973,14448,19997,26370,33620,41788,50824,60360,70577,81429,92881,104591,116502,129058,141790,154769,167871,181265,194328,207620,221038,234512,247926,261192,274457,287766,301121,314268,327247,340530,353353,366278,379063,391571,404187,416407,428902,441100,453091,464851,476524,488196,499738,511160,522386,533353,544204,554929,565613,576300,586635,597014,607084,617267,627312,637059,646778,656444,665892,675342,684586,693676,702556,711445,720114,728783,737272,745705,753990,762027,770088,778350,786149,794103,801909,809629,817234,824654,832163,839586,846860,854094,861030,868170,874941,881778,888509,895167,901732,908285,914691,921057,927448,933624,939755,945884,951945,957910,963740,969735,975417,981146,986972,992684,998319,1003830,1009280,1014677,1020088,
0,0,0,0,0,4,16,82,270,611,1172,2147,3458,5256,7611,10488,13838,17763,22231,27382,32990,39039,45537,52383,59804,67479,75476,83775,92425,101339,110387,119651,129064,138649,148316,158079,168061,177908,187740,197729,207790,218000,228136,238063,248083,258310,268381,278581,288645,298656,308629,318499,328337,338258,347966,357651,367255,376823,386377,395774,404959,414234,423439,432302,441527,450503,459421,468205,476925,485692,494365,502903,511412,520014,528345,536523,544622,552809,560503,568331,576154,583891,591548,599155,606611,614140,621646,628900,636182,643568,650554,657490,664315,671150,678004,684755,691547,698191,704731,711438,718000,724634,731009,737226,743498,749763,755857,762001,767968,774039,779924,785792,791766,797564,803146,808785,814310,819758,825269,830670,
0,0,0,0,0,0,0,1,11,49,100,202,426,738,1169,1821,2643,3677,4980,6545,8357,10529,13012,15774,18748,21942,25489,29316,33428,37845,42443,47278,52273,57411,62822,68477,74340,80320,86434,92615,99028,105489,112069,118610,125394,132304,139245,146076,152936,159952,167012,174086,181380,188580,195892,203234,210628,217853,225152,232635,239931,247227,254543,261821,269046,276195,283417,290548,297639,304736,311899,318944,326009,332936,339868,346934,353970,360857,367684,374529,381297,387976,394662,401204,407930,414602,421213,427613,434137,440621,446996,453431,459668,465857,472070,478163,484283,490515,496621,502701,508667,514650,520442,526324,532093,537986,543727,549350,554962,560563,566195,571678,577157,582542,587880,593290,598595,604034,609224,614453,
0,0,0,0,0,0,0,0,0,1,1,8,17,25,55,94,178,298,433,655,910,1255,1699,2221,2861,3655,4495,5522,6625,7911,9312,10865,12613,14382,16347,18388,20570,22809,25314,27845,30529,33314,36294,39376,42555,45912,49283,52792,56353,59906,63657,67479,71445,75433,79507,83660,87784,92023,96398,100668,105105,109386,113878,118370,122987,127583,132155,136846,141572,146246,150951,155666,160383,165105,169911,174793,179751,184605,189498,194363,199199,204064,208858,213738,218585,223369,228249,233204,238064,242902,247777,252631,257527,262374,267134,271937,276711,281529,286311,291109,295884,300586,305286,309919,314576,319258,323938,328655,333433,337968,342639,347155,351785,356365,360954,365542,370118,374612,379085,383713,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,5,17,26,43,65,109,170,238,314,405,540,717,944,1177,1445,1779,2134,2560,3018,3513,4097,4764,5453,6244,7086,7947,8862,9902,10963,12108,13316,14636,16034,17443,18828,20351,21905,23515,25223,26934,28733,30659,32572,34597,36607,38668,40775,42966,45170,47507,49773,52140,54537,57018,59576,62087,64570,67223,69826,72549,75395,78234,80957,83771,86550,89404,92269,95176,98089,100994,103962,106953,109950,112880,115848,118854,121924,124986,128087,131120,134230,137378,140451,143634,146829,149931,153055,156365,159588,162821,166105,169357,172568,175773,179045,182322,185515,188761,191938,195120,198455,201705,204965,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,8,14,22,30,40,54,71,101,130,168,215,271,335,435,510,627,743,879,1033,1200,1392,1593,1816,2083,2345,2605,2872,3204,3549,3925,4285,4694,5127,5613,6098,6619,7169,7773,8367,9007,9646,10297,11029,11787,12540,13307,14111,14942,15782,16660,17553,18511,19493,20485,21525,22572,23623,24649,25731,26929,28068,29249,30406,31659,32906,34181,35459,36745,37994,39377,40791,42131,43450,44838,46274,47727,49272,50730,52252,53792,55323,56924,58573,60179,61820,63374,65011,66616,68293,69999,71639,73380,75065,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,4,6,6,7,7,10,14,21,24,30,33,42,50,63,75,88,102,124,144,177,203,230,256,300,344,386,435,485,543,612,689,753,848,939,1032,1120,1209,1313,1408,1549,1670,1828,1999,2159,2318,2509,2674,2859,3050,3267,3467,3692,3913,4119,4340,4587,4856,5128,5394,5681,5957,6233,6500,6812,7119,7452,7780,8118,8486,8855,9259,9654,10055,10463,10881,11314,11730,12192,12629,13069,13539,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,4,4,5,6,8,8,11,12,17,19,22,23,25,26,32,32,36,42,49,51,57,61,65,76,82,88,102,108,118,127,141,156,164,181,198,219,235,252,271,296,313,331,354,375,401,435,463,501,538,574,
47657,268826,496058,680055,828217,949254,1049259,1134391,1207074,1269696,1324330,1373098,1416423,1455815,1491527,1523929,1553833,1581071,1606136,1629535,1651491,1671778,1690664,1708627,1725534,1741364,1756219,1770285,1783573,1796324,1808657,1820132,1831293,1841869,1852207,1861764,1871118,1880073,1888511,1896667,1904509,1912063,1919425,1926598,1933344,1939868,1946302,1952530,1958542,1964414,1970082,1975467,1980750,1986030,1991140,1996036,2000774,2005323,2009861,2014246,2018525,2022791,2026990,2031029,2034906,2038668,2042353,2045898,2049464,2052966,2056375,2059732,2062902,2066061,2069118,2072124,2075144,2078089,2080941,2083695,2086428,2089146,2091806,2094362,2096939,2099407,2101795,2104201,2106557,2108809,2111168,2113413,2115627,2117736,2119782,2121899,2123908,2125899,2127879,2129784,2131651,2133515,2135383,2137293,2139073,2140888,2142666,2144326,2146055,2147708,2149276,2150930,2152541,2154087,2155626,2157199,2158711,2160174,2161670,2163135,
8479,106880,261422,413777,548885,665743,767582,856238,934402,1002985,1063924,1118779,1167953,1212814,1253403,1290896,1325851,1357789,1387276,1415338,1441218,1465385,1487985,1509560,1529677,1548863,1566921,1583855,1599958,1615555,1630197,1644223,1657612,1670429,1682608,1694631,1706129,1717207,1727806,1737670,1747541,1756878,1766183,1774864,1783438,1791882,1799835,1807360,1815000,1822185,1829059,1835892,1842476,1849113,1855293,1861465,1867399,1873173,1878707,1884085,1889349,1894638,1899751,1904623,1909563,1914238,1918893,1923343,1927722,1932090,1936306,1940391,1944354,1948362,1952178,1955946,1959538,1963268,1966821,1970268,1973786,1977240,1980499,1983766,1986968,1990044,1993112,1996083,1999075,2001990,2004800,2007657,2010420,2013122,2015889,2018532,2021148,2023754,2026308,2028820,2031273,2033659,2035982,2038274,2040541,2042765,2045014,2047179,2049364,2051440,2053527,2055511,2057594,2059573,2061482,2063347,2065277,2067143,2069066,2070920,
1934,50149,155528,277013,393829,501502,598185,684593,762755,832322,895266,952031,1003736,1051123,1094256,1134198,1171659,1206523,1238577,1268271,1296335,1323265,1348375,1371744,1394038,1414979,1435117,1454218,1472201,1489389,1506046,1521715,1536585,1551075,1564739,1578038,1590954,1603344,1615153,1626520,1637374,1648063,1658299,1668191,1677851,1687114,1695958,1704544,1713006,1721225,1729140,1736887,1744506,1751743,1758656,1765574,1772102,1778611,1785066,1791326,1797469,1803508,1809314,1815052,1820477,1825821,1831071,1836271,1841367,1846285,1850962,1855651,1860163,1864672,1869036,1873399,1877614,1881744,1885901,1890020,1893964,1897837,1901594,1905245,1908852,1912396,1915830,1919228,1922623,1925886,1929109,1932325,1935495,1938531,1941542,1944515,1947479,1950433,1953292,1956178,1958918,1961584,1964365,1967118,1969758,1972198,1974781,1977270,1979783,1982172,1984576,1986927,1989256,1991447,1993714,1995949,1998161,2000366,2002495,2004612,
202,16103,71906,152867,242099,330898,415715,494463,567714,635065,696963,753847,806555,855215,900343,942133,981154,1017247,1051685,1084216,1114455,1143370,1170611,1196459,1220866,1244027,1266046,1287350,1307622,1326610,1344761,1362098,1378861,1394831,1410307,1425205,1439598,1453296,1466537,1479349,1491773,1503803,1515393,1526726,1537676,1548218,1558440,1568483,1577931,1587359,1596329,1605041,1613657,1621875,1630073,1638182,1645788,1653246,1660662,1667733,1674795,1681478,1688119,1694691,1701176,1707380,1713402,1719266,1725043,1730711,1736266,1741725,1747011,1752192,1757274,1762241,1767065,1771959,1776720,1781261,1785763,1790312,1794618,1799016,1803222,1807263,1811399,1815372,1819274,1823132,1826922,1830667,1834165,1837777,1841416,1844916,1848280,1851640,1855007,1858290,1861538,1864792,1867918,1871026,1874082,1877006,1880064,1882989,1885816,1888675,1891315,1894086,1896808,1899480,1902193,1904858,1907462,1909964,1912446,1914889,
9,2578,20262,58276,110845,170583,233369,295823,357186,415897,471287,523946,573870,620908,665147,706466,745483,782770,817943,851655,883587,913931,942476,970050,995915,1020688,1044753,1067636,1089712,1110710,1130937,1150332,1168928,1187014,1204309,1220701,1236822,1252580,1267449,1282035,1296214,1309772,1322848,1335600,1347899,1359990,1371671,1383280,1394266,1404816,1415215,1425185,1435034,1444736,1454078,1463253,1472243,1480985,1489549,1497820,1505862,1513852,1521590,1529138,1536533,1543927,1551043,1557973,1564683,1571232,1577716,1584023,1590261,1596426,1602504,1608422,1614162,1619596,1625084,1630556,1635881,1641076,1646345,1651318,1656369,1661390,1666217,1671020,1675633,1680189,1684689,1689076,1693460,1697700,1701850,1706036,1710016,1714104,1718085,1721897,1725705,1729488,1733151,1736914,1740515,1744056,1747551,1751032,1754468,1757759,1761140,1764328,1767515,1770808,1773859,1776987,1779992,1783004,1786041,1788931,
0,620,7815,28502,61689,103971,151866,201992,252714,302953,352584,400087,446306,490143,532189,572199,610626,646945,681730,714940,746731,776966,805957,833835,860266,885990,910351,934039,956435,977981,998862,1019093,1038703,1057296,1075350,1092907,1109869,1126331,1141924,1157179,1172103,1186511,1200456,1213836,1226936,1239603,1252127,1264163,1275735,1287198,1298412,1309038,1319609,1330030,1340197,1350304,1359972,1369336,1378493,1387412,1396174,1404646,1413152,1421373,1429337,1437024,1444769,1452286,1459621,1466724,1473670,1480655,1487351,1494204,1500553,1506964,1513152,1519196,1525323,1531266,1536960,1542655,1548310,1553844,1559346,1564773,1569733,1574923,1579932,1584953,1589930,1594788,1599537,1604092,1608805,1613318,1617785,1622164,1626488,1630766,1634941,1639100,1643178,1647196,1651195,1655069,1658882,1662668,1666411,1670197,1673819,1677424,1680975,1684404,1687846,1691326,1694707,1698010,1701355,1704640,
0,102,2170,10670,27674,52768,84625,120196,158448,198369,238557,278868,318232,356485,394074,430624,466435,500411,533036,564778,594947,624078,652237,679396,705566,730812,755594,779174,802155,824172,845391,865780,885781,905143,923956,942279,959590,976338,992743,1008902,1024456,1039516,1054110,1068417,1082297,1095779,1108915,1121717,1134061,1146298,1158182,1169778,1181087,1192287,1203154,1213645,1224073,1234188,1243957,1253546,1262801,1271900,1280846,1289622,1298088,1306550,1314814,1322915,1330996,1338892,1346570,1354113,1361397,1368490,1375539,1382497,1389418,1396051,1402669,1409151,1415594,1421708,1427942,1434139,1440097,1445931,1451577,1457099,1462781,1468292,1473588,1478886,1484141,1489228,1494206,1499171,1504010,1508877,1513677,1518378,1522936,1527470,1531975,1536337,1540835,1545081,1549408,1553746,1557854,1561980,1566101,1570224,1574205,1578045,1581886,1585581,1589139,1592807,1596431,1600036,
0,6,303,2572,8749,20246,36558,57626,81763,108957,137740,167046,197443,228027,258792,288955,318950,348522,377345,405728,433407,460108,486182,511774,536533,560563,583850,606494,628732,650114,670787,691085,710782,730037,748520,766847,784680,801900,818633,835052,851155,866575,881471,896099,910375,924336,938013,951419,964398,977366,990073,1002248,1014341,1025971,1037376,1048451,1059504,1070462,1080909,1090913,1100936,1110722,1120311,1129744,1138861,1147803,1156661,1165354,1173835,1182249,1190419,1198380,1206394,1214328,1222000,1229651,1237063,1244287,1251550,1258513,1265507,1272345,1278927,1285665,1292066,1298445,1304608,1310695,1316882,1322954,1328880,1334761,1340594,1346181,1351731,1357196,1362597,1367895,1373218,1378527,1383477,1388445,1393382,1398346,1403125,1407786,1412467,1417220,1421819,1426359,1430831,1435272,1439591,1443900,1448152,1452355,1456535,1460545,1464642,1468600,
0,0,19,313,1554,4705,10448,19034,30477,44407,60416,78198,97613,117887,139031,160803,182954,205532,228027,250432,272713,294820,316853,338330,359794,380721,401450,421476,441338,461085,480375,499212,517443,535468,552900,570040,586820,603282,619616,635489,651103,666173,681172,695911,710230,724028,737576,751218,764564,777489,790279,802742,814974,826838,838707,850035,861212,872402,883012,893587,903982,914093,924112,934051,943582,953277,962663,971928,980882,989887,998620,1007247,1015601,1023969,1032156,1040249,1048065,1055794,1063527,1071237,1078605,1086066,1093105,1100231,1107139,1114045,1120722,1127374,1134047,1140609,1147068,1153390,1159615,1165878,1171941,1177991,1183783,1189616,1195353,1201019,1206579,1212123,1217561,1222901,1228077,1233224,1238328,1243463,1248582,1253563,1258540,1263441,1268240,1273026,1277688,1282310,1286939,1291432,1295828,1300284,
0,0,0,52,342,1327,3491,7311,12875,20351,29766,40542,52896,66652,81430,97173,113704,130639,148263,165863,183802,201754,219791,238251,256365,274216,292027,309654,326925,344147,361143,378119,394858,411477,427688,443715,459321,474909,490261,505273,519705,534274,548213,562533,576333,589788,603169,616272,628994,641807,654202,666363,678210,690083,701664,713113,724318,735125,745920,756445,766875,777103,787185,797020,806909,816500,826050,835328,844440,853492,862396,870983,879501,888013,896403,904825,912909,920937,928611,936274,943811,951297,958902,966209,973451,980557,987727,994672,1001448,1008116,1014855,1021637,1028075,1034513,1040640,1046928,1053156,1059115,1065096,1071009,1076874,1082778,1088513,1094004,1099504,1105038,1110519,1115927,1121193,1126489,1131619,1136823,1141884,1146919,1151946,1156863,1161739,1166640,1171401,1176053,
0,0,0,3,38,230,756,1947,4038,7091,11430,16695,23226,30853,39649,49343,59951,71041,82715,94967,107892,121069,134635,148344,162265,176606,190620,204838,218972,233310,247570,261925,275988,290247,304292,318187,331526,345134,358512,371678,385141,398134,410948,423671,436281,448717,461057,473172,485096,496705,508270,519779,530926,542078,553127,564064,574792,585226,595819,605977,616058,626062,635909,645553,655152,664697,674104,683377,692452,701285,710008,718694,727221,735713,743901,752240,760128,768082,776140,783974,791674,799257,806949,814459,822012,829181,836244,843365,850329,857284,864111,870903,877599,884023,890457,896798,903129,909419,915565,921627,927659,933555,939465,945331,951090,956681,962391,967836,973455,978849,984288,989605,994926,1000030,1005143,1010155,1015278,1020289,1025244,1030193,
0,0,0,0,1,15,88,299,774,1611,2901,4761,7297,10450,14336,18867,23998,29977,36495,43579,51184,59342,67758,76472,85455,94894,104772,114750,124969,135310,145871,156497,167282,177909,188617,199553,210393,221250,232193,242994,253771,264582,275317,286044,296578,307174,317621,327876,338265,348525,358875,369054,379142,388870,398588,408213,417646,427143,436603,446191,455573,464714,473675,482847,491643,500343,509008,517560,525901,534194,542561,550835,559020,567055,575015,582972,590729,598347,605988,613450,620806,628304,635592,642898,650134,657150,664183,671222,678156,685028,691783,698536,705096,711450,717952,724416,730820,737190,743522,749572,755596,761430,767482,773480,779358,785079,790666,796216,801667,807046,812455,817869,823244,828743,833862,839060,844201,849288,854388,859360,
0,0,0,0,0,2,8,17,60,166,363,732,1273,2077,3151,4607,6360,8431,10840,13804,17035,20654,24558,28937,33552,38435,43823,49291,55147,61150,67464,74009,80443,87357,94299,101392,108616,115982,123358,130959,138630,146372,154244,161824,169794,177655,185490,193377,201383,209331,217391,225247,233158,241029,248929,256706,264573,272372,280127,287763,295585,303339,310880,318416,326004,333623,341172,348757,356082,363484,370481,377768,384866,391944,398896,406059,412999,419920,426800,433635,440346,447006,453560,460093,466755,473354,479689,486126,492518,498798,505041,511269,517436,523420,529204,535100,540903,546825,552639,558538,564286,569877,575542,581050,586532,592056,597555,602958,608392,613726,618989,624281,629448,634601,639629,644669,649740,654658,659635,664514,
0,0,0,0,0,0,0,1,2,6,24,57,92,197,344,540,809,1202,1680,2308,3067,3994,5045,6351,7798,9392,11276,13266,15483,17826,20454,23155,26123,29180,32363,35889,39481,43103,46886,50971,54948,59055,63402,67883,72342,76885,81489,86391,91167,96106,101094,106074,111088,116059,121345,126558,131697,136949,142188,147540,152941,158367,163684,169078,174597,179972,185270,190674,196166,201540,206935,212326,217759,223103,228536,233920,239205,244642,250017,255398,260842,266229,271649,276949,282194,287489,292753,298080,303203,308339,313473,318596,323764,328909,333905,339053,343995,348883,353787,358721,363686,368651,373477,378270,383043,387792,392553,397327,402169,406960,411608,416323,420802,425350,429877,434302,438893,443376,447800,452199,
0,0,0,0,0,0,0,0,0,0,0,0,3,4,14,32,59,86,149,231,329,462,660,892,1177,1563,1957,2421,2976,3603,4323,5121,5998,6962,8060,9194,10443,11830,13295,14811,16422,18135,19958,21916,23834,25912,28073,30359,32663,35083,37585,40082,42585,45217,47861,50575,53348,56214,59127,62155,65181,68281,71338,74588,77893,81112,84318,87646,91091,94558,98069,101531,105016,108482,111989,115595,119114,122636,126144,129840,133511,137111,140776,144487,148194,151830,155494,159190,162896,166634,170278,173840,177542,181299,184985,188660,192383,196090,199896,203677,207355,211071,214818,218459,222169,225934,229668,233378,237008,240788,244440,248191,251837,255536,259187,262798,266452,270035,273587,277170,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,9,16,30,51,77,99,147,208,257,346,434,564,695,883,1106,1328,1556,1841,2125,2436,2817,3201,3658,4098,4602,5133,5724,6360,7007,7700,8451,9273,10070,10912,11793,12778,13766,14752,15824,16852,18000,19179,20419,21707,23027,24321,25637,27031,28400,29862,31391,32889,34479,36045,37661,39326,40975,42691,44481,46221,47997,49858,51676,53584,55501,57398,59381,61388,63389,65395,67457,69464,71473,73449,75515,77607,79779,81924,84020,86153,88399,90564,92784,95048,97332,99524,101805,104061,106316,108572,110796,113098,115443,117766,120023,122340,124800,127021,129347,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,7,8,14,21,30,44,59,72,99,121,147,183,223,267,307,359,414,494,556,653,739,829,921,1038,1167,1288,1433,1614,1782,1964,2179,2385,2615,2842,3097,3363,3666,3964,4262,4582,4923,5274,5634,6015,6399,6802,7218,7647,8099,8546,9022,9530,10040,10531,11054,11584,12158,12793,13388,13984,14603,15239,15858,16532,17219,17859,18542,19274,20042,20809,21570,22396,23181,23999,24865,25648,26485,27316,28192,29074,30011,30931,31861,32754,33728,34669,35599,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,4,6,9,13,17,17,21,23,27,33,36,42,46,54,67,73,83,97,112,129,145,162,180,201,224,246,268,300,323,361,386,422,463,501,543,586,616,654,694,750,811,870,931,991,1052,1119,1201,1283,1366,1453,1557,1648,1747,1842,1943,2042,2143,2262,2371,2505,2628,2764,2896,3025,3170,
51126,276752,503852,686771,832688,951705,1050175,1133168,1203796,1265359,1318849,1366635,1409048,1447238,1481887,1513587,1542746,1569622,1594248,1617081,1638539,1658256,1676783,1694133,1710483,1725963,1740685,1754347,1767239,1779489,1791267,1802635,1813445,1823776,1833822,1843267,1852228,1861110,1869551,1877456,1885229,1892602,1899657,1906696,1913270,1919809,1926088,1932041,1937850,1943448,1949070,1954393,1959754,1964770,1969682,1974515,1979167,1983669,1988136,1992459,1996611,2000749,2004726,2008566,2012429,2016171,2019748,2023216,2026717,2030179,2033507,2036754,2039976,2042999,2045922,2048901,2051777,2054586,2057270,2060078,2062756,2065321,2067909,2070440,2072934,2075437,2077745,2080158,2082499,2084797,2087087,2089239,2091308,2093429,2095593,2097696,2099677,2101630,2103642,2105646,2107543,2109414,2111231,2113105,2114769,2116460,2118181,2119887,2121573,2123237,2124846,2126436,2127949,2129445,2130982,2132467,2133977,2135405,2136902,2138346,
9698,113539,272012,424175,558042,674074,773911,860913,937224,1003896,1063544,1116938,1164799,1208364,1248066,1284482,1318345,1349760,1378718,1405697,1430917,1454406,1476448,1497408,1516817,1535365,1552901,1569616,1585507,1600549,1615047,1628640,1641700,1654320,1666311,1677830,1688935,1699521,1709637,1719261,1728643,1737903,1746795,1755361,1763667,1771704,1779287,1786748,1794021,1801042,1807903,1814614,1820993,1827169,1833292,1839106,1844880,1850539,1855964,1861218,1866351,1871502,1876434,1881289,1886016,1890588,1895014,1899364,1903716,1907965,1911972,1915919,1919770,1923713,1927437,1931111,1934678,1938187,1941683,1945164,1948498,1951778,1955004,1958151,1961286,1964271,1967214,1970132,1973066,1975888,1978693,1981346,1984044,1986646,1989262,1991859,1994483,1996867,1999308,2001774,2004203,2006464,2008717,2010986,2013140,2015307,2017474,2019542,2021623,2023700,2025706,2027714,2029686,2031624,2033545,2035439,2037348,2039210,2040994,2042812,
2440,55290,165750,288792,406385,513608,609587,695063,771258,839054,900407,955613,1006088,1052076,1094475,1133228,1169559,1203286,1234373,1263373,1290755,1316592,1340625,1363292,1384648,1405028,1424380,1442688,1460044,1476757,1492695,1507982,1522349,1536216,1549527,1562280,1574765,1586403,1597833,1608767,1619272,1629528,1639447,1649028,1658242,1667172,1675859,1684302,1692327,1700155,1707802,1715217,1722689,1729757,1736637,1743212,1749640,1756029,1762229,1768201,1773991,1779707,1785267,1790761,1796175,1801353,1806448,1811441,1816319,1821127,1825714,1830208,1834596,1838875,1843171,1847322,1851415,1855438,1859341,1863192,1867032,1870818,1874496,1878137,1881633,1885064,1888465,1891890,1895202,1898441,1901600,1904721,1907721,1910599,1913547,1916488,1919445,1922300,1925090,1927878,1930552,1933130,1935712,1938333,1940965,1943418,1945830,1948280,1950685,1952997,1955256,1957582,1959887,1962071,1964223,1966408,1968497,1970612,1972688,1974759,
305,18933,79507,164144,255164,345034,429715,508310,580616,646593,707137,762799,813986,861232,904962,945954,983808,1019142,1052300,1083509,1112810,1140668,1166925,1191570,1214968,1237657,1258925,1279275,1298612,1317177,1334889,1351892,1367916,1383332,1398288,1412761,1426592,1439876,1452765,1465136,1477154,1488539,1499574,1510219,1520685,1530840,1540798,1550296,1559546,1568620,1577186,1585668,1593932,1601780,1609652,1617332,1624652,1631879,1639091,1645986,1652763,1659319,1665677,1672005,1678080,1684176,1689905,1695597,1701223,1706568,1711882,1717067,1722220,1727146,1731918,1736729,1741523,1746097,1750681,1755011,1759365,1763782,1767964,1772154,1776115,1780147,1784062,1787864,1791540,1795258,1798923,1802535,1806116,1809590,1813038,1816383,1819631,1822811,1825991,1829153,1832271,1835310,1838310,1841255,1844225,1847074,1849927,1852831,1855624,1858305,1860995,1863699,1866265,1868871,1871386,1873891,1876410,1878837,1881291,1883685,
12,3463,24526,66962,123004,185424,250059,313051,374285,432619,487676,539705,588429,634826,678377,718903,757476,793869,828538,860936,891626,920814,948477,974959,1000062,1023635,1046661,1068736,1089943,1110170,1129539,1148107,1166010,1183299,1199659,1215496,1230771,1245772,1260106,1273973,1287632,1300760,1313147,1325377,1337151,1348805,1360064,1370974,1381577,1391839,1401656,1411249,1420608,1429922,1438702,1447573,1456228,1464663,1472780,1480679,1488440,1496019,1503292,1510487,1517460,1524277,1531013,1537674,1544232,1550572,1556847,1562742,1568602,1574568,1580297,1585923,1591349,1596788,1602083,1607269,1612368,1617379,1622347,1627168,1631838,1636502,1641046,1645517,1649874,1654235,1658404,1662687,1666811,1670912,1674984,1678953,1682818,1686571,1690390,1694158,1697818,1701508,1704969,1708602,1712077,1715474,1718824,1722160,1725433,1728623,1731827,1734910,1738071,1741171,1744077,1746930,1749853,1752825,1755600,1758482,
0,964,10189,34167,71500,117267,167666,219862,271771,322910,372676,420637,466401,509787,551440,590642,628196,663356,697347,729456,760241,789462,817564,844319,870172,894798,918319,940973,962830,983548,1003534,1023011,1041540,1059364,1076722,1093376,1109569,1125280,1140240,1154889,1168987,1182898,1196376,1209254,1221831,1233983,1245736,1257174,1268698,1279432,1289995,1300341,1310430,1320174,1329839,1339196,1348301,1357134,1365801,1374085,1382408,1390505,1398382,1406265,1413839,1421172,1428349,1435574,1442791,1449642,1456412,1463047,1469528,1475834,1481862,1487877,1493898,1499757,1505466,1511139,1516717,1522161,1527536,1532786,1537828,1542716,1547558,1552406,1557188,1561915,1566653,1571269,1575761,1580192,1584506,1588836,1593077,1597223,1601166,1605117,1609077,1613036,1617009,1620879,1624674,1628389,1631989,1635554,1639096,1642683,1646117,1649467,1652817,1656330,1659597,1662801,1666009,1669176,1672242,1675368,
0,172,3151,14016,34511,63117,98114,136572,176994,218466,259661,300477,340219,379261,416986,453770,488848,522279,554870,585831,615442,643849,671451,697733,723185,747622,771612,794561,816506,837626,858133,877557,896802,915288,933230,950652,967347,983503,998946,1014243,1029080,1043518,1057528,1071246,1084561,1097457,1109973,1122101,1134031,1145737,1157088,1168034,1178641,1189290,1199540,1209287,1218985,1228425,1237596,1246745,1255611,1264212,1272769,1280974,1289153,1297199,1305033,1312520,1319974,1327305,1334416,1341599,1348628,1355571,1362384,1368909,1375417,1381618,1387832,1394047,1399986,1405795,1411470,1417241,1422805,1428268,1433709,1439074,1444340,1449564,1454681,1459696,1464663,1469554,1474337,1479041,1483783,1488409,1492992,1497365,1501699,1505908,1510242,1514391,1518419,1522540,1526643,1530680,1534500,1538425,1542131,1545853,1549649,1553278,1557027,1560599,1564099,1567456,1570851,1574272,
0,11,568,3869,12283,26463,46133,70178,97061,126338,157149,188420,220378,252022,283070,314050,344644,374501,403577,431793,459081,485506,511468,536398,560779,584096,606698,628805,650396,670932,690923,710641,729605,748094,766157,783581,800653,817227,833334,848990,864340,879202,893477,907639,921419,934677,947764,960383,972685,984815,996668,1008123,1019502,1030646,1041540,1052084,1062549,1072862,1082613,1092366,1101740,1110983,1119876,1128792,1137468,1146114,1154624,1162831,1170701,1178617,1186264,1193884,1201331,1208733,1215988,1223147,1230089,1236924,1243653,1250212,1256834,1263318,1269687,1275933,1281986,1287932,1293732,1299622,1305386,1311026,1316539,1322122,1327535,1332698,1338027,1343260,1348310,1353291,1358161,1363013,1367866,1372593,1377163,1381757,1386287,1390836,1395250,1399647,1403983,1408314,1412480,1416683,1420804,1424859,1428889,1432756,1436653,1440503,1444189,1448093,
0,0,38,555,2570,7201,14974,25869,39852,56261,74895,94841,116433,138800,161518,184791,208191,231730,255082,278193,301134,323798,346024,367986,389345,410440,431010,451309,470768,490148,509040,527346,545129,562691,579899,596790,612950,629026,644961,660247,675242,689872,704184,718296,731844,745172,758195,771055,783656,795983,808042,819778,831517,842904,854165,864999,875569,885764,896024,905988,915787,925394,935008,944304,953522,962593,971454,979994,988422,996769,1004976,1013270,1021179,1029032,1036696,1044284,1051701,1059023,1066260,1073319,1080321,1087280,1094174,1101030,1107555,1114049,1120467,1126778,1132964,1139017,1145063,1150942,1156755,1162521,1168199,1173790,1179342,1184771,1190174,1195523,1200748,1205906,1210940,1215982,1220874,1225744,1230525,1235262,1240137,1244775,1249377,1253971,1258570,1262903,1267309,1271686,1275899,1280198,1284370,1288509,
0,0,4,113,684,2430,5731,11176,18897,28610,40437,53651,68116,83807,100766,118345,136289,154754,173420,192146,211357,230452,249226,268268,287074,305543,323726,341797,359351,376539,393650,410703,427306,443645,459706,475563,490871,506066,520991,535720,550210,564210,577974,591566,604951,617937,630834,643475,655652,667794,679831,691453,702810,714170,725282,736380,747019,757478,767762,777878,787819,797742,807297,816539,825859,834904,843997,852855,861582,870066,878365,886570,894648,902734,910450,918354,925962,933496,940881,948070,955256,962349,969397,976285,983050,989693,996396,1002912,1009324,1015469,1021843,1027969,1033987,1040022,1045920,1051795,1057548,1063320,1068774,1074436,1079939,1085301,1090656,1096001,1101193,1106215,1111275,1116361,1121382,1126340,1131260,1136029,1140804,1145502,1150150,1154734,1159199,1163690,1168123,1172480,
0,0,0,8,105,485,1556,3612,6795,11402,17216,24679,33223,42931,53630,65265,77711,90660,104166,118336,132796,147432,162306,177124,192207,207351,222554,237454,252371,267068,281836,296283,310822,325297,339512,353550,367661,381077,394424,407606,420511,433680,446551,459052,471812,484066,495989,507727,519569,531123,542537,553625,564553,575380,586130,596707,606941,617128,627322,636978,646684,656255,665760,675252,684401,693423,702226,711059,719814,728416,736940,745108,753218,761239,769116,777046,784779,792331,799824,807183,814565,821751,828822,835823,842733,849808,856533,863152,869692,876150,882583,888802,895032,901068,907171,913157,919127,924814,930556,936268,941836,947338,952978,958539,963792,969179,974460,979807,985007,990005,995028,999923,1004836,1009706,1014616,1019408,1024141,1028844,1033342,1037844,
0,0,0,0,14,59,240,751,1631,3149,5373,8414,12212,16832,22364,28497,35476,43003,51164,60082,69506,79089,89116,99507,110157,121029,131905,143010,154488,165936,177593,189267,200849,212415,223984,235428,246822,258028,269457,280794,292053,302992,314097,325034,335789,346505,357265,367976,378679,389046,399353,409463,419225,429168,438974,448578,458204,467753,476973,486186,495265,504253,513067,522023,530824,539499,547897,556056,564293,572415,580399,588499,596199,604055,611687,619222,626776,634407,641729,648894,655980,663098,670077,677164,684052,690792,697641,704270,710731,717106,723313,729794,736050,742111,748141,754217,760132,765949,771770,777507,783201,788950,794645,800120,805530,810975,816266,821532,826754,831974,837032,842070,847151,852206,857030,861936,866685,871481,876233,880874,
0,0,0,0,0,4,15,74,203,482,960,1724,2856,4374,6354,8816,11587,14815,18506,22717,27308,32288,37719,43386,49416,55926,62590,69411,76660,84056,91622,99336,107333,115124,123184,131490,139892,148368,156645,165060,173716,182366,190878,199542,208199,216717,225133,233742,242156,250650,259149,267616,276047,284294,292336,300692,308729,316831,324826,332826,340623,348432,356252,363966,371464,379143,386643,394035,401591,408806,416046,423341,430510,437567,444638,451567,458303,465129,471925,478642,485295,491828,498433,504863,511348,517683,523818,529968,536071,542060,548101,554062,560089,565993,571880,577693,583293,588892,594472,600156,605701,611205,616558,621958,627324,632596,637907,642989,648054,653137,658268,663280,668324,673217,678117,682917,687688,692397,697029,701761,
0,0,0,0,0,0,0,0,3,33,76,179,332,574,945,1481,2130,2958,3964,5173,6675,8405,10358,12502,14870,17592,20462,23616,26929,30416,34158,38137,42164,46490,50900,55405,60074,64951,69949,74894,79993,85292,90594,95999,101567,107202,112831,118559,124317,130034,135792,141566,147457,153428,159373,165243,171147,176966,182815,188703,194492,200495,206546,212463,218404,224422,230512,236389,242342,248120,254029,259737,265523,271240,276947,282573,288507,294210,299914,305476,311145,316755,322162,327736,333203,338528,343804,349246,354654,360025,365360,370649,375824,380916,385957,391012,396174,401399,406286,411269,416161,421012,425889,430602,435518,440352,445143,449816,454476,459120,463780,468285,472799,477254,481892,486449,490789,495214,499500,503793,
0,0,0,0,0,0,0,0,0,0,1,7,19,42,75,138,226,377,548,786,1086,1447,1908,2489,3168,3940,4842,5837,6971,8234,9563,11009,12590,14337,16178,18194,20339,22541,24841,27228,29752,32343,35039,37794,40697,43731,46782,49862,53129,56447,59706,63113,66542,69954,73598,77299,80996,84795,88671,92491,96368,100196,104145,108169,112036,115971,120105,124124,128311,132384,136475,140612,144648,148733,152923,157104,161242,165562,169720,173811,178036,182192,186406,190573,194683,198826,202890,206916,211109,215254,219347,223319,227399,231457,235488,239600,243610,247646,251677,255681,259662,263696,267723,271835,275682,279498,283380,287332,291267,295102,298992,302821,306733,310539,314421,318199,321927,325699,329531,333258,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,6,13,23,38,58,85,126,180,257,343,471,627,774,971,1248,1561,1904,2268,2668,3140,3681,4293,4920,5601,6344,7164,7976,8816,9744,10708,11786,12970,14154,15389,16689,18033,19363,20828,22356,23857,25476,27084,28767,30392,32169,33959,35810,37697,39658,41638,43654,45715,47830,49880,52048,54196,56424,58650,60899,63127,65306,67607,69948,72285,74772,77158,79705,82158,84685,87213,89735,92202,94742,97273,99841,102471,105101,107677,110258,112900,115526,118140,120767,123256,125955,128590,131184,133848,136413,139040,141733,144438,147197,149796,152459,155176,157892,160577,163356,166087,168882,171632,174322,176976,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,4,8,10,23,32,43,54,71,101,124,149,194,231,282,347,425,490,579,665,782,921,1090,1246,1436,1646,1884,2128,2362,2620,2890,3184,3478,3834,4207,4606,4997,5409,5817,6279,6798,7321,7813,8366,8948,9531,10130,10770,11475,12176,12871,13634,14390,15138,15957,16797,17627,18465,19314,20172,21074,21988,22893,23826,24780,25762,26736,27814,28846,29937,30962,31998,33144,34212,35343,36486,37669,38846,40071,41332,42552,43769,45025,46287,47554,48843,50156,51468,52778,54102,55402,56807,58130,59558,60954,62328,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,4,4,9,9,11,13,15,18,21,27,36,41,50,63,79,91,106,122,143,160,180,203,232,259,292,321,343,390,443,481,535,587,639,700,774,850,919,992,1082,1165,1249,1348,1446,1539,1656,1755,1890,1996,2124,2277,2423,2579,2734,2880,3052,3233,3401,3594,3774,3960,4157,4364,4575,4786,5014,5222,5470,5713,5966,6246,6518,6790,7081,7350,7673,7990,8286,8631,
55022,284223,511322,692294,836445,953118,1049641,1131140,1200532,1260833,1313578,1360401,1401905,1439146,1473216,1504162,1532873,1558835,1582852,1605147,1625914,1645358,1663315,1680346,1696375,1711476,1725702,1739142,1751933,1764113,1775781,1786718,1797233,1807377,1817070,1826447,1835293,1843818,1852059,1859798,1867318,1874677,1881751,1888451,1895096,1901410,1907548,1913518,1919226,1924784,1930207,1935594,1940742,1945625,1950587,1955284,1959919,1964351,1968753,1972990,1977088,1981143,1985031,1988865,1992529,1996148,1999581,2003003,2006428,2009739,2012918,2016156,2019232,2022279,2025190,2028046,2030876,2033633,2036363,2039100,2041710,2044339,2046879,2049527,2051928,2054333,2056773,2059101,2061362,2063522,2065711,2067840,2069877,2071910,2073991,2076004,2077969,2079835,2081806,2083796,2085691,2087498,2089223,2090998,2092710,2094449,2096184,2097898,2099508,2101122,2102698,2104204,2105797,2107300,2108761,2110225,2111637,2113088,2114498,2115865,
11067,121241,282181,434959,567567,681983,780230,865814,940386,1005744,1063588,1115612,1162877,1205378,1244009,1279430,1312251,1342568,1370676,1397020,1421536,1444767,1466169,1486430,1505552,1523476,1540656,1556913,1572268,1586688,1600634,1614008,1626715,1638771,1650539,1661664,1672671,1683040,1693108,1702678,1711719,1720540,1729112,1737359,1745376,1753192,1760671,1768027,1774900,1781796,1788404,1794918,1801213,1807359,1813254,1819077,1824604,1830073,1835404,1840572,1845626,1850566,1855246,1860030,1864589,1868936,1873302,1877563,1881774,1885872,1889847,1893718,1897505,1901210,1904850,1908464,1911885,1915482,1918872,1922181,1925545,1928792,1931942,1935119,1938215,1941159,1944012,1946783,1949607,1952417,1955111,1957862,1960480,1963019,1965603,1968102,1970597,1973009,1975330,1977652,1979988,1982290,1984508,1986735,1988885,1991094,1993231,1995294,1997375,1999359,2001346,2003326,2005286,2007160,2009056,2010886,2012705,2014526,2016312,2018037,
3098,60854,175353,299494,417564,524340,618678,703011,778072,844752,904731,958803,1007911,1052838,1093590,1131583,1166558,1199484,1229779,1258100,1284679,1309643,1333026,1354921,1375753,1395165,1414228,1431980,1448972,1465158,1480427,1495301,1509185,1522649,1535635,1548239,1560103,1571556,1582704,1593430,1603543,1613525,1623092,1632470,1641489,1650127,1658560,1666729,1674497,1682063,1689496,1696643,1703770,1710599,1717123,1723602,1729820,1735944,1741946,1747734,1753472,1758970,1764328,1769624,1774954,1779939,1784934,1789676,1794380,1798972,1803426,1807871,1812235,1816397,1820541,1824612,1828583,1832533,1836388,1840042,1843750,1847369,1850950,1854494,1857848,1861255,1864667,1867873,1871154,1874337,1877311,1880301,1883267,1886157,1888902,1891684,1894391,1897135,1899850,1902653,1905310,1907989,1910527,1913074,1915571,1917960,1920387,1922685,1925052,1927284,1929517,1931794,1934008,1936130,1938222,1940341,1942444,1944523,1946631,1948661,
435,21981,86888,175184,268480,359136,443218,521110,592875,658185,717336,771766,821897,868279,911409,951138,987854,1022284,1054595,1084666,1112976,1139838,1165139,1189392,1212117,1234055,1254362,1274083,1292533,1310498,1327564,1343893,1359174,1374235,1388639,1402634,1415966,1428860,1441380,1453355,1464852,1476004,1486726,1496960,1507140,1516974,1526498,1535738,1544558,1553213,1561605,1569913,1577866,1585589,1593173,1600728,1607932,1614809,1621753,1628401,1634794,1641087,1647185,1653141,1659116,1664773,1670279,1675666,1681007,1686278,1691466,1696420,1701452,1706270,1711018,1715700,1720375,1724783,1729127,1733340,1737627,1741818,1745816,1749736,1753715,1757557,1761456,1765198,1768806,1772386,1775907,1779306,1782688,1785924,1789148,1792386,1795586,1798734,1801950,1804996,1807949,1810928,1813903,1816735,1819478,1822387,1825182,1827832,1830573,1833181,1835746,1838308,1840827,1843371,1845832,1848324,1850797,1853154,1855495,1857781,
12,4383,29157,75594,134980,199496,265022,329282,390932,449336,504109,555512,603405,648690,691522,731314,768692,803908,837336,868744,898489,926711,953548,979294,1003629,1026747,1049063,1070214,1090505,1109817,1128551,1146550,1163881,1180596,1196519,1212118,1226908,1241151,1254996,1268284,1281210,1293562,1305559,1317333,1328674,1339701,1350331,1360705,1371035,1380846,1390303,1399721,1408693,1417445,1426108,1434580,1442837,1450793,1458545,1466102,1473559,1480904,1487939,1494927,1501666,1508295,1514766,1520962,1527325,1533364,1539172,1544993,1550630,1556216,1561638,1567051,1572284,1577443,1582465,1587210,1592147,1596961,1601795,1606426,1610952,1615349,1619774,1624185,1628383,1632493,1636652,1640682,1644646,1648546,1652406,1656333,1660133,1663830,1667558,1671093,1674483,1677965,1681340,1684726,1687922,1691163,1694462,1697752,1700719,1703805,1706837,1709743,1712752,1715700,1718625,1721413,1724277,1727057,1729864,1732526,
2,1337,12926,40526,81154,129586,182204,236125,289262,340928,390744,438347,483642,526711,567750,606551,643038,677810,710620,742097,771798,800404,827839,854055,878657,902311,925220,947173,968199,988266,1007413,1026067,1044169,1061351,1078034,1094205,1109956,1124808,1139130,1153264,1166858,1180201,1193002,1205359,1217462,1229201,1240455,1251526,1262296,1272720,1282919,1292862,1302553,1311863,1320866,1329954,1338689,1347303,1355468,1363533,1371487,1379237,1386822,1394300,1401541,1408521,1415359,1422184,1428832,1435449,1441832,1448166,1454259,1460179,1466091,1471864,1477555,1483129,1488559,1493932,1499189,1504475,1509410,1514549,1519408,1524215,1528996,1533632,1538126,1542608,1547138,1551559,1555916,1560064,1564207,1568441,1572569,1576561,1580451,1584280,1588015,1591723,1595477,1599185,1602813,1606397,1609860,1613343,1616691,1620082,1623492,1626798,1630095,1633307,1636387,1639341,1642427,1645388,1648427,1651363,
0,283,4423,17670,41312,73195,110859,151718,193542,236097,278858,320171,360183,399009,436949,472850,507829,540996,572585,603008,632395,660454,687343,712935,737617,761266,784155,806195,827388,847795,867725,886676,905341,922980,940082,956649,972829,988383,1003534,1018104,1032382,1046217,1059730,1072839,1085566,1097785,1109864,1121557,1132917,1143970,1154712,1165237,1175360,1185422,1195153,1204572,1214004,1222986,1231876,1240540,1248933,1257114,1265217,1273238,1281019,1288557,1296010,1303231,1310429,1317380,1324263,1331027,1337755,1344275,1350763,1357118,1363150,1369266,1375202,1381202,1386951,1392516,1398038,1403523,1408778,1413983,1419155,1424258,1429317,1434209,1439118,1443921,1448621,1453226,1457798,1462327,1466759,1471104,1475366,1479560,1483697,1487804,1491755,1495808,1499623,1503547,1507414,1511188,1514911,1518576,1522168,1525753,1529282,1532790,1536206,1539631,1543022,1546489,1549676,1552939,
0,27,946,5393,15935,32779,54916,81563,110891,142256,174491,207390,240392,273078,304983,336337,367058,396964,425810,453802,480814,506619,532079,556809,580468,603602,625865,647357,668219,688370,708048,727121,745673,763488,780891,797903,814557,830435,845994,860849,875531,889672,903537,917031,930092,942770,955462,967587,979402,991050,1002381,1013492,1024374,1034846,1045056,1055039,1064839,1074402,1083770,1093186,1102200,1111201,1119848,1128355,1136703,1144936,1152922,1160602,1168355,1175842,1183151,1190443,1197571,1204543,1211414,1218256,1224751,1231243,1237743,1243963,1250212,1256374,1262324,1268179,1274121,1279863,1285390,1290860,1296248,1301637,1306907,1312035,1317163,1322137,1327122,1332026,1336899,1341646,1346318,1350986,1355594,1360106,1364534,1368817,1373078,1377327,1381533,1385690,1389811,1393821,1397730,1401608,1405609,1409413,1413170,1416851,1420631,1424312,1427906,1431543,
0,2,86,963,3969,10179,20127,33579,49984,68905,89604,111651,134807,158509,182713,206991,231672,255879,279837,303533,326967,349728,372027,393729,415215,435927,456327,476509,496010,515060,533466,551470,569106,586412,603121,619482,635627,651143,666389,681217,695714,709537,723489,736950,750316,763120,775696,788083,800115,812067,823690,835173,846226,857213,867920,878334,888319,898284,907967,917539,926876,936133,945169,954226,962920,971663,980170,988455,996540,1004415,1012279,1020068,1027675,1035109,1042331,1049493,1056636,1063524,1070280,1077129,1083752,1090291,1096623,1102931,1109274,1115504,1121544,1127448,1133150,1139001,1144729,1150252,1155864,1161272,1166647,1171962,1177205,1182383,1187375,1192395,1197257,1202132,1206943,1211460,1216190,1220765,1225292,1229796,1234211,1238559,1243036,1247348,1251655,1255821,1259876,1264112,1268173,1272063,1276068,1280016,
0,0,18,227,1142,3758,8481,15624,25132,37058,50591,66168,83034,100548,119061,138188,157317,177182,197084,216997,236787,256832,276261,295398,314373,333342,351693,369719,387531,405045,422164,438920,455413,471554,487354,503033,518565,533632,548334,562672,576468,590185,603796,617117,630039,642769,655224,667456,679338,690941,702355,713546,724407,735244,745898,756382,766669,776683,786511,796056,805652,815322,824516,833535,842401,851035,859513,867861,876069,884254,892133,899992,907673,915335,922747,930066,937548,944501,951667,958576,965394,972076,978779,985384,991858,998384,1004622,1010740,1016789,1022712,1028796,1034596,1040332,1045982,1051505,1057078,1062538,1068060,1073273,1078414,1083698,1088733,1093795,1098763,1103615,1108305,1113111,1117798,1122465,1127130,1131735,1136282,1140739,1145301,1149624,1153945,1158248,1162424,1166599,1170715,
0,0,0,36,249,968,2682,5742,10366,16533,24251,33396,43578,55091,67797,81269,95257,109672,124603,139937,155492,171034,186815,202539,218348,234181,249868,265433,280771,295878,310928,325926,340531,354981,369180,383297,397311,411035,424445,437798,450859,463910,476633,488960,501453,513603,525311,536982,548425,559559,570666,581625,592332,602896,613291,623497,633583,643425,653094,662632,671909,681151,690201,699240,707917,716614,725217,733824,741852,750062,758232,766045,773903,781583,789129,796653,803972,811164,818296,825219,832046,838915,845720,852304,858901,865451,872016,878262,884649,890935,897046,903105,908947,914792,920609,926396,932007,937466,942880,948336,953649,958883,964278,969418,974450,979451,984391,989382,994277,999125,1003845,1008522,1013131,1017694,1022122,1026695,1031110,1035440,1039748,1044124,
0,0,0,1,23,139,561,1420,2939,5331,8622,12810,17960,24075,31136,38972,47576,56681,66272,76615,87407,98471,109889,121448,133303,145368,157247,169357,181647,193873,205986,218257,230449,242564,254829,266803,278597,290395,302045,313621,325032,336421,347567,358483,369552,380378,391128,401800,412247,422665,432781,442795,452714,462699,472407,481868,491326,500744,509873,519115,527967,536708,545429,554156,562732,571286,579618,587703,595789,603667,611549,619229,626771,634275,641878,649243,656384,663561,670588,677430,684276,691048,697828,704374,710940,717297,723790,730099,736545,742676,748608,754575,760523,766408,772145,777856,783527,789220,794845,800317,805637,811073,816329,821399,826589,831687,836690,841702,846614,851529,856293,861137,865920,870765,875289,879834,884407,888981,893503,897889,
0,0,0,0,1,11,62,207,531,1067,1978,3312,5161,7562,10508,14002,17989,22597,27784,33207,38996,45432,52130,59187,66438,74225,82427,90551,98809,107263,115784,124564,133311,142269,151233,160215,169208,178210,187289,196238,205372,214652,223641,232627,241672,250642,259395,268177,277121,286059,294686,303227,311688,320208,328577,337152,345400,353652,361721,369838,377788,385465,393261,401132,408681,416098,423602,431047,438345,445749,452881,460089,467274,474386,481349,488131,494798,501423,508137,514781,521202,527476,533858,540191,546495,552676,558848,564906,570877,576836,582778,588589,594310,600021,605495,611047,616626,622211,627503,632859,638134,643440,648847,653935,659091,664040,669023,673957,678878,683777,688577,693292,698055,702822,707385,712071,716625,721147,725515,729942,
0,0,0,0,0,0,2,6,30,96,211,416,782,1248,1953,2895,4131,5531,7281,9302,11672,14329,17193,20383,23805,27547,31421,35537,40055,44700,49469,54438,59487,64763,70309,75872,81448,87252,93147,99107,105112,111088,117245,123515,129861,136218,142726,149040,155526,161869,168196,174700,181110,187811,194155,200476,206674,212911,219359,225652,232047,238461,244687,250926,257249,263340,269567,275718,281695,287869,294009,299931,305893,311818,317790,323687,329608,335386,341141,346833,352570,358203,363700,369205,374564,380074,385575,390904,396208,401647,406997,412244,417393,422498,427476,432456,437467,442390,447394,452231,457118,461927,466683,471539,476285,481015,485712,490227,494904,499531,504120,508570,513073,517536,521979,526409,530699,534965,539239,543427,
0,0,0,0,0,0,0,0,1,3,8,27,51,109,216,379,608,927,1323,1838,2448,3149,4012,5059,6234,7548,9063,10644,12371,14416,16556,18803,21188,23675,26290,29086,32026,35092,38234,41434,44701,48172,51831,55434,59139,62947,66750,70681,74562,78566,82691,86903,91103,95323,99650,103957,108332,112711,117018,121548,125998,130386,134734,139225,143754,148314,152831,157374,161904,166375,170886,175405,179885,184444,188956,193539,198099,202634,207163,211688,216179,220697,225232,229668,234072,238439,242826,247219,251634,255956,260173,264325,268720,273005,277315,281497,285810,290055,294194,298457,302556,306759,310820,314837,319000,323041,326987,331033,335044,339008,343035,346933,350757,354667,358530,362397,366283,370124,373959,377756,
0,0,0,0,0,0,0,0,0,0,0,0,2,6,10,20,29,56,103,165,239,342,485,660,862,1101,1391,1713,2106,2535,3041,3654,4267,4976,5771,6679,7579,8571,9650,10768,12002,13322,14693,16161,17650,19161,20790,22521,24276,26099,27945,29891,31843,33887,35961,38109,40234,42441,44689,47051,49288,51665,54085,56507,59033,61660,64267,66958,69590,72249,74981,77720,80458,83215,86062,88898,91822,94757,97530,100361,103300,106152,109019,111997,114920,117817,120832,123860,126883,129865,132845,135772,138649,141508,144491,147548,150551,153537,156451,159452,162384,165293,168230,171229,174209,177204,180232,183236,186266,189156,192016,195023,198034,200967,203901,206923,209850,212830,215724,218715,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,3,7,9,16,24,44,62,86,118,151,184,251,325,401,511,624,731,876,1038,1212,1434,1651,1899,2170,2474,2802,3154,3573,3954,4397,4848,5342,5900,6452,7012,7630,8243,8861,9563,10296,11091,11838,12636,13496,14292,15152,16051,17050,17987,18920,19956,20955,22048,23134,24251,25312,26447,27600,28771,30020,31266,32517,33824,35161,36422,37743,39118,40441,41771,43230,44672,46094,47532,48960,50452,51953,53414,54866,56431,57973,59514,61126,62703,64279,65937,67509,69092,70676,72276,73986,75639,77285,78900,80606,82276,83989,85627,87343,89016,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,5,7,11,15,18,22,26,31,41,49,63,71,91,110,136,163,186,214,237,261,292,341,380,426,468,525,586,660,742,823,919,1014,1121,1229,1348,1474,1593,1725,1880,2026,2176,2333,2514,2693,2879,3077,3273,3485,3716,3963,4190,4408,4659,4918,5229,5499,5762,6059,6377,6691,6988,7310,7668,8023,8369,8719,9091,9484,9868,10267,10663,11078,11476,11897,12374,12818,13289,13738,14142,14586,15050,15512,16023,16533,
58451,292236,518488,698120,840336,955144,1050381,1130535,1198775,1257572,1308938,1354738,1395255,1431880,1465042,1495353,1523481,1548885,1572181,1594189,1614516,1633536,1651243,1667985,1683766,1698693,1712420,1725581,1738177,1750068,1761367,1772127,1782471,1792315,1801814,1811014,1819817,1828130,1836133,1843766,1851102,1858280,1865138,1871940,1878481,1884613,1890664,1896481,1902002,1907411,1912658,1918031,1923055,1928003,1932792,1937338,1941872,1946234,1950334,1954685,1958679,1962737,1966455,1970123,1973759,1977364,1980866,1984264,1987567,1990796,1994021,1997186,2000137,2003116,2005966,2008766,2011613,2014345,2016961,2019600,2022222,2024757,2027295,2029797,2032210,2034611,2036957,2039218,2041320,2043550,2045707,2047792,2049867,2051899,2053894,2055839,2057805,2059718,2061598,2063438,2065234,2067077,2068887,2070691,2072373,2074094,2075782,2077387,2079002,2080636,2082203,2083756,2085308,2086834,2088265,2089741,2091162,2092663,2094072,2095461,
12504,128724,291423,444550,576600,689694,786595,870282,943587,1007540,1064199,1115243,1161216,1202665,1240573,1275322,1307375,1337282,1364580,1390095,1413955,1436306,1457266,1476922,1495289,1513041,1529812,1545369,1560078,1574380,1587997,1600861,1613324,1625230,1636704,1647712,1658369,1668387,1678244,1687494,1696415,1705161,1713369,1721559,1729281,1736957,1744182,1751186,1758079,1764715,1771197,1777496,1783626,1789585,1795378,1801024,1806537,1811762,1816953,1822002,1826855,1831616,1836344,1841039,1845562,1849971,1854286,1858518,1862571,1866514,1870439,1874214,1877844,1881439,1885049,1888566,1891974,1895337,1898697,1901824,1905005,1908129,1911261,1914354,1917382,1920258,1923154,1925909,1928600,1931240,1934013,1936581,1939097,1941637,1944110,1946472,1948913,1951313,1953659,1956035,1958358,1960607,1962809,1964997,1967193,1969267,1971288,1973302,1975308,1977246,1979174,1981161,1983055,1984942,1986773,1988586,1990426,1992184,1993930,1995723,
3589,66117,184805,311088,428942,535229,628608,710769,784428,850121,908647,961497,1009704,1053244,1093574,1130636,1164782,1196484,1225783,1253497,1279317,1303681,1326532,1347937,1368313,1387544,1405857,1423184,1439719,1455228,1470078,1484405,1498015,1511210,1523730,1535840,1547551,1558768,1569647,1579923,1589854,1599448,1608877,1617814,1626576,1635116,1643329,1651339,1658965,1666304,1673500,1680501,1687316,1694026,1700567,1706827,1712888,1718920,1724609,1730373,1735941,1741366,1746634,1751922,1756951,1761855,1766575,1771397,1776050,1780364,1784778,1789132,1793352,1797426,1801530,1805391,1809232,1812992,1816783,1820518,1824031,1827521,1830960,1834334,1837758,1840993,1844337,1847559,1850748,1853744,1856668,1859610,1862535,1865328,1868121,1870866,1873643,1876304,1878895,1881502,1884024,1886535,1889021,1891415,1893815,1896102,1898458,1900707,1902993,1905222,1907404,1909681,1911808,1913887,1916015,1918054,1920085,1922074,1923994,1925958,
548,24962,94193,185576,280081,371107,455255,532433,602912,667447,725678,779051,828189,873494,915551,954192,989988,1023564,1055430,1085156,1112501,1138587,1163098,1186435,1208645,1229530,1249620,1268604,1286526,1303801,1320251,1336054,1351291,1365732,1379794,1393145,1406019,1418550,1430507,1442125,1453319,1464232,1474564,1484640,1494248,1503769,1512937,1521855,1530544,1538852,1547020,1554777,1562562,1570158,1577481,1584775,1591616,1598290,1604914,1611307,1617394,1623628,1629516,1635456,1641333,1646780,1652295,1657534,1662835,1667931,1672926,1677766,1682583,1687346,1691983,1696483,1700886,1705300,1709637,1713858,1717887,1721933,1725904,1729809,1733542,1737289,1740978,1744676,1748236,1751768,1755230,1758650,1761871,1764975,1768172,1771285,1774385,1777438,1780405,1783458,1786383,1789245,1792130,1794936,1797652,1800401,1803048,1805699,1808230,1810795,1813381,1815898,1818271,1820693,1823073,1825414,1827741,1830074,1832324,1834579,
34,5594,33513,83787,146138,212932,280136,344604,406106,464124,518120,569054,616493,660886,702604,741574,778273,812725,845055,875809,904828,932473,958588,983674,1007500,1030109,1051683,1072238,1091968,1110746,1128751,1145989,1162824,1178742,1194064,1209136,1223339,1237222,1250386,1263204,1275764,1287785,1299317,1310739,1321700,1332288,1342484,1352472,1362244,1371664,1380935,1389870,1398706,1407133,1415472,1423641,1431556,1439184,1446707,1453923,1461034,1467995,1474878,1481546,1488194,1494483,1500691,1506830,1512739,1518520,1524282,1529910,1535351,1540608,1545832,1551067,1556281,1561155,1565977,1570832,1575590,1580269,1584774,1589239,1593611,1597903,1602196,1606384,1610441,1614552,1618486,1622401,1626276,1630067,1633810,1637374,1640938,1644477,1647931,1651411,1654813,1658134,1661474,1664759,1667894,1671115,1674255,1677374,1680409,1683402,1686320,1689145,1692048,1694939,1697795,1700450,1703315,1705953,1708549,1711072,
5,1885,15664,46957,90848,142467,197393,251842,305442,357368,407133,454485,499649,542304,582629,620780,656554,690429,722535,753064,782251,809973,836496,861998,886242,909449,931652,952908,973225,992451,1011153,1029233,1046613,1063187,1079333,1094958,1109926,1124367,1138295,1151890,1165082,1177826,1190381,1202249,1213761,1225096,1236029,1246920,1257115,1267078,1276871,1286301,1295449,1304318,1313070,1321672,1330145,1338413,1346332,1354178,1361829,1369072,1376408,1383489,1390330,1397291,1404030,1410535,1417099,1423381,1429556,1435564,1441498,1447344,1453025,1458559,1464087,1469480,1474711,1479740,1484776,1489759,1494637,1499484,1504309,1509008,1513639,1518063,1522441,1526867,1531254,1535522,1539736,1543812,1547806,1551753,1555779,1559580,1563322,1566969,1570549,1574173,1577825,1581282,1584666,1588059,1591499,1594840,1598131,1601330,1604495,1607600,1610633,1613746,1616764,1619673,1622717,1625579,1628450,1631252,
0,413,5734,21582,48370,83027,123071,165669,209534,253371,296254,338165,378477,417160,454497,490332,524644,557295,588513,618468,647287,674677,701114,726095,750109,773310,795569,816706,837510,857476,876628,895170,913265,930496,946953,963023,978688,993815,1008326,1022514,1036117,1049464,1062365,1075006,1087243,1098956,1110511,1121629,1132441,1143232,1153579,1163635,1173582,1183079,1192525,1201711,1210782,1219404,1227837,1236141,1244345,1252367,1260083,1267720,1275324,1282591,1289744,1296807,1303634,1310495,1316990,1323498,1329823,1335914,1342025,1348123,1353980,1359800,1365488,1370961,1376459,1381850,1387048,1392295,1397520,1402462,1407407,1412236,1417037,1421736,1426485,1431115,1435606,1440012,1444383,1448773,1452934,1457032,1460968,1464981,1468943,1472816,1476720,1480532,1484299,1487955,1491660,1495341,1498852,1502360,1505843,1509315,1512678,1516082,1519366,1522613,1525779,1528970,1532069,1535173,
0,63,1460,7230,20031,39544,64455,93839,125210,158064,191760,225701,259536,292811,325012,356586,387584,417179,446082,473778,500368,526179,550973,575300,598753,621230,642837,663827,684445,704079,723100,741445,759401,776739,793717,810055,826093,841567,856346,870721,885063,898882,912278,925279,937982,950302,962224,974162,985489,996685,1007606,1018291,1028670,1038867,1048629,1058267,1067876,1077231,1086258,1095076,1103588,1112132,1120286,1128432,1136399,1144263,1152041,1159441,1166774,1173930,1181000,1187963,1194824,1201477,1208034,1214593,1220913,1227215,1233242,1239306,1245208,1251029,1256775,1262424,1267870,1273231,1278629,1283772,1289026,1294169,1299125,1304086,1309078,1313898,1318686,1323346,1327961,1332447,1336759,1341290,1345707,1349980,1354255,1358307,1362397,1366461,1370505,1374423,1378260,1382028,1385888,1389738,1393474,1397050,1400633,1404246,1407678,1411182,1414612,1417915,
0,3,157,1520,5653,13665,25711,41267,59827,80737,103196,127184,151868,177089,202538,227906,252930,277787,302048,326227,349663,372377,394695,416491,437781,458646,479008,498906,518120,536856,555143,572948,590295,607046,623429,639418,655103,670165,685049,699522,713522,727183,740436,753535,766123,778431,790562,802644,814318,825782,836809,847642,858274,868925,879185,889166,898891,908473,917897,927080,936260,945057,953689,962044,970423,978629,986623,994601,1002241,1009987,1017484,1024863,1032137,1039469,1046362,1053177,1059882,1066557,1073074,1079535,1085872,1092171,1098411,1104409,1110352,1116120,1121865,1127627,1133158,1138734,1144166,1149454,1154673,1159888,1164938,1170062,1175128,1179991,1184881,1189623,1194337,1199007,1203531,1208017,1212345,1216697,1220951,1225215,1229498,1233772,1237937,1242141,1246225,1250285,1254191,1258125,1261834,1265749,1269544,1273222,
0,0,26,426,1915,5568,11763,20655,32162,46283,62065,79284,97570,116773,136674,157010,177473,198094,218816,239417,259853,280191,300164,319579,338848,357581,376076,394339,412196,429452,446190,463082,479504,495515,511298,526669,541649,556292,570844,584900,598662,611922,625085,638024,650783,663150,675209,687010,698580,709915,720924,731850,742660,753075,763522,773501,783307,792902,802578,811939,821015,830065,838782,847487,856026,864270,872426,880402,888409,896193,903819,911360,918633,926046,933061,940006,946842,953635,960353,967109,973696,980144,986562,992879,999102,1005219,1011122,1017059,1022902,1028635,1034337,1039822,1045268,1050561,1055816,1060951,1066268,1071444,1076489,1081407,1086280,1091040,1095858,1100538,1105219,1109797,1114393,1118901,1123251,1127617,1132084,1136242,1140422,1144711,1148825,1152957,1157035,1161193,1165143,1169044,
0,0,4,68,459,1704,4228,8366,14318,22026,31474,42253,54471,67640,81947,97004,112129,127951,144097,160312,177039,193590,210344,226752,243091,259485,275671,291691,307341,322695,337794,352802,367791,382492,396607,410604,424550,438261,451853,465021,477991,490633,503042,515103,527412,539222,550703,562217,573486,584479,595280,605835,616213,626319,636281,646246,655938,665602,675008,684261,693381,702322,710982,719612,728112,736486,744664,752975,760909,768663,776478,784044,791535,798948,806354,813511,820537,827377,834120,840873,847384,853952,860421,866817,873169,879388,885631,891614,897684,903600,909389,915081,920757,926181,931736,937247,942598,947885,953081,958250,963324,968346,973269,978232,983159,988000,992674,997344,1001946,1006516,1011028,1015452,1019710,1024019,1028439,1032786,1036971,1041257,1045264,1049312,
0,0,0,3,49,302,1001,2404,4690,8005,12465,18097,24728,32289,40826,49963,59896,70619,81612,93305,105500,117711,130269,142957,155494,168259,181051,193922,206847,219589,232279,245087,257890,270380,282904,295025,307115,319134,330880,342576,354012,365389,376697,387763,398742,409578,420210,430726,441071,451407,461707,471586,481248,490846,500435,509695,519124,528299,537441,546359,555123,563925,572412,580803,589140,597343,605455,613493,621278,628975,636575,644022,651257,658566,665838,673031,679981,686853,693576,700323,706916,713541,719980,726422,732719,738831,744904,750983,757034,762798,768695,774412,780120,785709,791279,796738,802219,807642,813079,818174,823236,828470,833559,838530,843515,848284,853173,857997,862643,867370,871903,876414,880925,885420,889812,894174,898590,902822,907066,911229,
0,0,0,1,2,29,136,398,971,1979,3467,5390,8080,11374,15247,19847,25041,30789,37100,43868,51068,58589,66546,74688,83170,91938,100926,109933,119074,128504,137854,147462,157031,166572,176110,185803,195493,205043,214665,224407,233994,243494,252860,262347,271615,280818,290001,299216,308278,317267,326103,334781,343307,351955,360401,368991,377180,385430,393522,401579,409620,417526,425342,433044,440684,448014,455378,462774,470139,477530,484735,492029,498849,505769,512679,519453,526329,532954,539501,546001,552364,558445,564632,570767,576904,582821,588727,594543,600440,606172,611844,617333,622900,628410,633819,639078,644330,649639,654802,659996,664994,670081,675221,680087,685028,690028,694893,699703,704420,709144,713638,718132,722658,727105,731557,736087,740428,744675,748845,753044,
0,0,0,0,0,1,6,34,91,213,465,891,1498,2354,3581,5042,6890,8978,11429,14324,17492,20834,24635,28633,33005,37642,42603,47753,53163,58801,64550,70397,76366,82563,88942,95277,101713,108253,114850,121531,128170,135023,141869,148636,155479,162491,169342,176081,182880,189568,196582,203525,210435,217320,224219,230928,237618,244376,251057,257632,264257,270597,277127,283494,289831,296215,302520,308914,315203,321385,327514,333635,339658,345623,351570,357542,363441,369211,375037,380783,386483,392317,397903,403319,408799,414264,419769,424951,430283,435503,440642,445917,451010,456013,461047,466061,471145,475980,480942,485820,490527,495338,500010,504682,509266,513937,518690,523209,527666,532081,536491,540833,545121,549446,553708,557953,562171,566320,570452,574487,
0,0,0,0,0,0,0,3,7,18,52,99,197,330,529,854,1296,1876,2600,3485,4494,5680,7100,8632,10377,12280,14455,16709,19266,21924,24716,27657,30809,34173,37610,41184,44834,48565,52490,56579,60641,64972,69281,73543,77844,82256,86821,91327,96056,100723,105329,110096,114850,119642,124369,129314,134121,138906,143760,148723,153615,158636,163387,168335,173246,178114,183020,187950,192836,197771,202607,207629,212552,217389,222203,227085,231862,236610,241325,246092,250811,255463,260088,264821,269348,273838,278453,282970,287524,291990,296416,300763,305129,309468,313727,318076,322359,326621,330771,335066,339202,343300,347498,351611,355802,359942,363920,367966,372076,376101,380079,384068,388005,391830,395677,399442,403152,406854,410600,414358,
0,0,0,0,0,0,0,0,0,0,0,2,8,18,30,53,91,152,239,369,553,766,1037,1353,1751,2247,2755,3354,4027,4811,5653,6579,7608,8733,9996,11310,12675,14181,15799,17511,19259,21129,23058,24951,26960,29039,31241,33544,35854,38278,40675,43138,45594,48175,50806,53548,56245,59014,61891,64706,67632,70614,73515,76551,79473,82422,85489,88556,91688,94747,97914,101078,104268,107475,110735,113882,117150,120438,123729,126919,130191,133396,136683,139967,143131,146280,149619,152985,156330,159560,162738,165935,169154,172582,175838,179196,182325,185625,188878,192161,195403,198611,201868,205032,208249,211410,214458,217672,220775,223901,227069,230221,233386,236604,239744,242901,245951,248946,251986,254978,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,5,10,24,36,51,71,100,139,209,293,374,466,571,725,874,1024,1256,1496,1787,2071,2413,2758,3170,3605,4075,4549,5088,5647,6219,6876,7577,8245,8979,9711,10562,11417,12288,13198,14103,15022,16078,17121,18184,19315,20400,21565,22747,23949,25212,26488,27803,29122,30515,31948,33313,34789,36312,37785,39290,40804,42328,43898,45468,47098,48752,50401,51991,53648,55371,57089,58801,60567,62293,64054,65880,67779,69604,71413,73242,75046,76830,78726,80604,82423,84307,86223,88062,90012,91867,93743,95665,97560,99519,101537,103583,105452,107450,109382,111346,113255,115140,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,8,9,14,18,23,29,33,38,44,60,77,89,106,125,153,189,232,268,328,376,415,480,535,617,713,799,899,1001,1133,1236,1346,1469,1593,1758,1909,2081,2246,2439,2632,2821,3047,3284,3531,3812,4063,4336,4601,4927,5238,5548,5892,6227,6582,6961,7339,7722,8096,8468,8871,9312,9759,10191,10657,11088,11553,12030,12540,13087,13571,14085,14628,15209,15767,16341,16923,17514,18147,18732,19359,19975,20615,21290,21976,22632,23324,23989,24649,25349,26027,
62282,299775,526031,703422,843835,956986,1050236,1129133,1196074,1254061,1304518,1349455,1389250,1425160,1457664,1487289,1514874,1539754,1562857,1584392,1604208,1622902,1640305,1656721,1672354,1686785,1700381,1713243,1725446,1736972,1748034,1758736,1768848,1778532,1787721,1796677,1805261,1813541,1821484,1829021,1836280,1843188,1849972,1856492,1862853,1868993,1874965,1880861,1886256,1891587,1896833,1901870,1906882,1911478,1916228,1920691,1925142,1929386,1933519,1937637,1941591,1945489,1949264,1952968,1956596,1960060,1963468,1966782,1970071,1973270,1976270,1979401,1982393,1985336,1988248,1990993,1993733,1996507,1999158,2001645,2004174,2006677,2009195,2011604,2013947,2016340,2018701,2020982,2023160,2025305,2027545,2029606,2031666,2033686,2035717,2037686,2039582,2041473,2043364,2045271,2047087,2048870,2050688,2052384,2054075,2055753,2057379,2058996,2060626,2062213,2063775,2065362,2066925,2068437,2069876,2071375,2072842,2074247,2075657,2076986,
14078,134813,300773,453620,584371,695565,791199,874158,946082,1008985,1064346,1114554,1159386,1200193,1236923,1271048,1302364,1331545,1358552,1383396,1406732,1428794,1449080,1468388,1486624,1503746,1520110,1535474,1549812,1563607,1577125,1589862,1601735,1613222,1624507,1635297,1645509,1655242,1664830,1673846,1682539,1690933,1699194,1707070,1714813,1722350,1729381,1736405,1743080,1749619,1755784,1761804,1767727,1773675,1779286,1784811,1790012,1795117,1800127,1805007,1809805,1814459,1819120,1823653,1828083,1832389,1836514,1840616,1844582,1848424,1852154,1855837,1859464,1863104,1866628,1870032,1873490,1876853,1880180,1883275,1886424,1889461,1892565,1895507,1898453,1901386,1904160,1906905,1909640,1912269,1914837,1917449,1920073,1922481,1924864,1927241,1929628,1931998,1934298,1936479,1938707,1940883,1943070,1945191,1947279,1949405,1951373,1953342,1955295,1957233,1959228,1961080,1963048,1964910,1966746,1968569,1970333,1972011,1973767,1975522,
4330,71947,193582,321383,439519,544375,636870,718318,790980,855466,913000,964660,1011612,1054621,1093775,1129978,1162994,1194002,1222956,1249759,1274787,1298512,1321019,1342071,1361704,1380581,1398235,1415099,1431129,1446311,1460966,1474928,1488110,1500850,1513099,1524829,1536132,1546893,1557325,1567488,1577289,1586672,1595762,1604515,1613125,1621395,1629404,1637080,1644678,1652020,1659036,1665757,1672446,1678940,1685360,1691523,1697401,1703241,1708981,1714429,1719750,1724960,1730100,1734986,1739979,1744963,1749663,1754215,1758603,1762958,1767230,1771428,1775501,1779484,1783470,1787329,1791037,1794821,1798460,1802015,1805419,1808852,1812283,1815687,1818958,1822097,1825202,1828399,1831386,1834358,1837320,1840246,1843044,1845838,1848499,1851145,1853827,1856535,1859075,1861651,1864122,1866584,1869079,1871500,1873865,1876156,1878459,1880743,1882992,1885193,1887338,1889523,1891663,1893752,1895817,1897794,1899770,1901726,1903694,1905574,
749,28390,101911,196382,292111,383453,467507,544072,614078,677613,734872,787079,835162,879712,920621,958476,993321,1026113,1056764,1085478,1112286,1137950,1161827,1184691,1206236,1226500,1245897,1264450,1281974,1298888,1315151,1330539,1345174,1359260,1372913,1385953,1398433,1410720,1422233,1433528,1444526,1454806,1464902,1474927,1484271,1493641,1502507,1511084,1519557,1527639,1535573,1543126,1550559,1557807,1564815,1571846,1578561,1585070,1591473,1597716,1603679,1609542,1615362,1621144,1626642,1631897,1637253,1642453,1647675,1652554,1657401,1662159,1666809,1671317,1675805,1680141,1684467,1688614,1692728,1696729,1700703,1704573,1708382,1712185,1715861,1719391,1722896,1726513,1729924,1733297,1736736,1740096,1743286,1746458,1749430,1752503,1755588,1758567,1761576,1764421,1767236,1770065,1772810,1775494,1778117,1780808,1783421,1785955,1788480,1790954,1793435,1795838,1798255,1800635,1802969,1805271,1807525,1809743,1811978,1814197,
48,6854,38149,91610,156139,224610,292531,357481,419249,477469,531360,581654,628480,671985,712938,751271,787007,820493,852421,882400,910704,937521,962966,987252,1010403,1032192,1053009,1072935,1091960,1110224,1127630,1144479,1160670,1176204,1191094,1205648,1219527,1232783,1245592,1258109,1270196,1281974,1293208,1304093,1314616,1324926,1335057,1344735,1354188,1363293,1372323,1381092,1389458,1397718,1405749,1413546,1421085,1428610,1435811,1442878,1449820,1456620,1463164,1469673,1475873,1482056,1488078,1493896,1499791,1505443,1510907,1516347,1521698,1526943,1532135,1537080,1541986,1546842,1551536,1556248,1560781,1565142,1569581,1573921,1578211,1582387,1586532,1590639,1594697,1598650,1602576,1606267,1610105,1613811,1617360,1620930,1624377,1627800,1631167,1634530,1637879,1641128,1644331,1647491,1650632,1653631,1656626,1659516,1662467,1665341,1668066,1670918,1673727,1676506,1679279,1681929,1684607,1687169,1689697,1692288,
3,2503,18870,53292,100377,154076,210454,266203,320433,372363,421855,469102,513846,555642,595600,633042,668585,702290,733780,763859,792406,819516,845039,869863,893512,916086,937442,958081,977963,996714,1014755,1031972,1048850,1065117,1080754,1095874,1110434,1124560,1137955,1151002,1163667,1175971,1188014,1199447,1210529,1221444,1231921,1242269,1252337,1262032,1271506,1280514,1289520,1298321,1306849,1315030,1323243,1331257,1339021,1346581,1354008,1361169,1368150,1375103,1381787,1388278,1394690,1400988,1407127,1413310,1419190,1424913,1430663,1436234,1441752,1447178,1452415,1457662,1462760,1467816,1472753,1477538,1482309,1487027,1491550,1496162,1500511,1504869,1509204,1513402,1517578,1521667,1525641,1529546,1533339,1537201,1540977,1544647,1548369,1552001,1555543,1558982,1562367,1565717,1569108,1572392,1575675,1578914,1582047,1585172,1588254,1591374,1594354,1597311,1600248,1603083,1605961,1608702,1611559,1614285,
1,588,7281,25648,55258,92866,135012,179381,224297,268706,312278,354304,394919,433719,470841,506226,540254,572573,603073,632456,660314,687362,713186,737337,760993,783698,805443,826308,846284,865670,884323,902293,919815,936564,952699,968267,983418,997913,1011985,1025687,1038820,1051730,1064308,1076544,1088417,1099737,1110935,1121747,1132242,1142631,1152736,1162498,1172018,1181420,1190437,1199103,1207682,1216109,1224423,1232365,1240208,1247996,1255388,1262617,1269623,1276577,1283408,1290178,1296876,1303281,1309607,1315866,1322101,1328123,1334078,1339915,1345555,1351216,1356786,1362106,1367405,1372501,1377547,1382481,1387351,1392243,1396958,1401675,1406192,1410737,1415165,1419678,1423937,1428263,1432501,1436583,1440723,1444748,1448627,1452641,1456486,1460353,1464115,1467783,1471381,1474907,1478336,1481864,1485284,1488601,1492065,1495304,1498626,1501854,1505027,1508108,1511160,1514249,1517309,1520320,
0,87,1925,9307,24342,46483,73706,104805,138047,172341,207288,242145,276727,309993,342911,374655,405526,435145,463663,491185,517698,542979,567688,591684,614650,636554,657843,678334,698643,717805,736494,754443,772044,788982,805324,821440,836834,851596,866227,880297,894023,907239,920219,932938,945126,957119,968634,979920,990799,1001652,1012203,1022596,1032671,1042414,1052066,1061180,1070180,1079254,1087841,1096251,1104623,1112905,1120713,1128477,1136107,1143723,1151110,1158310,1165202,1171979,1178714,1185384,1192103,1198634,1204858,1211050,1217107,1223164,1229093,1234776,1240432,1246075,1251634,1257065,1262396,1267661,1272740,1277702,1282661,1287596,1292481,1297175,1301837,1306549,1311053,1315539,1319911,1324305,1328484,1332688,1336950,1340940,1345046,1349119,1353156,1357063,1360905,1364704,1368505,1372102,1375693,1379325,1382828,1386314,1389810,1393256,1396559,1399909,1403191,1406569,
0,4,278,2220,7510,17213,31144,48951,69772,92743,117274,142460,168261,194435,220580,246314,271825,297136,322082,346220,369773,392501,414803,436576,457557,478386,498372,517871,536842,555273,573142,590621,607366,623811,639884,655554,670667,685495,699915,713977,727690,740724,753803,766721,779061,791272,803094,814627,825948,837222,848040,858578,868928,878834,888873,898441,907909,917246,926323,935133,943704,952279,960677,968814,976910,985018,992682,1000342,1007722,1015110,1022420,1029439,1036310,1043229,1049997,1056578,1062952,1069461,1075795,1081870,1087946,1093872,1099890,1105767,1111489,1117088,1122588,1128039,1133499,1138715,1143953,1149004,1154038,1159035,1163824,1168692,1173608,1178280,1182896,1187443,1191959,1196401,1200656,1205001,1209163,1213398,1217535,1221617,1225727,1229757,1233823,1237786,1241634,1245475,1249362,1253113,1256904,1260591,1264187,1267759,
0,0,53,619,2844,7674,15356,26098,39570,55392,72927,91854,111729,132346,153483,174390,195889,217000,238301,259418,280332,301157,321277,341063,360553,379519,397986,416407,434165,451363,468104,484836,500890,516866,532318,547485,562180,576814,590898,604476,617849,630864,643733,656281,668608,680686,692544,704168,715282,726274,737150,747712,758227,768321,778230,787928,797563,806821,816224,825107,834016,842612,851193,859519,867887,875873,883758,891438,899114,906581,913739,921017,928208,935246,942091,948735,955391,961908,968505,974871,981156,987410,993550,999591,1005478,1011286,1017060,1022715,1028202,1033604,1039032,1044308,1049509,1054668,1059806,1064774,1069760,1074692,1079456,1084182,1088941,1093524,1098127,1102704,1107191,1111651,1115915,1120179,1124481,1128630,1132880,1136814,1140935,1144828,1148745,1152656,1156496,1160333,1164251,1167949,
0,0,6,147,786,2570,5917,11342,18853,28163,39187,51615,65229,80014,95309,111495,128069,144901,162104,179039,196302,213644,230756,247757,264510,281087,297529,313812,329689,345382,360905,375941,390896,405528,420031,434104,447947,461600,474856,487713,500468,512869,525233,537328,549273,560726,572255,583230,594291,605066,615553,625862,635934,645769,655460,665112,674625,684012,693358,702406,711239,719837,728499,736853,745045,753267,761270,769010,776829,784536,791941,799309,806547,813669,820693,827555,834364,840982,847547,854007,860277,866620,872984,879148,885282,891292,897229,902991,908731,914311,919931,925405,930721,936035,941267,946417,951439,956507,961486,966295,971168,975878,980829,985603,990267,994951,999429,1003768,1008115,1012458,1016779,1021009,1025165,1029290,1033376,1037518,1041543,1045580,1049503,1053365,
0,0,0,16,135,574,1655,3681,6840,11183,16865,23839,31774,40863,50911,61430,72916,84682,97175,109920,123011,136435,149697,163073,176533,190022,203415,216706,229912,243148,256369,269323,282144,294926,307536,319962,332264,344344,356427,368102,379692,391242,402505,413573,424440,435422,446052,456333,466658,476746,486778,496612,506209,515742,525034,534324,543513,552396,561143,570013,578610,587106,595294,603505,611606,619493,627329,635017,642651,650106,657460,664681,671817,678835,685811,692724,699531,706238,712855,719206,725582,731927,738230,744507,750643,756555,762504,768302,774180,779793,785449,790840,796450,801989,807222,812470,817670,822780,827857,832804,837699,842595,847548,852283,857023,861797,866425,871135,875719,880108,884600,888924,893270,897612,901856,906095,910386,914481,918623,922665,
0,0,0,0,10,71,249,697,1595,3053,5143,7991,11582,15885,20980,26706,33044,39793,47315,55125,63412,72263,81219,90413,99827,109310,119275,129023,139185,149337,159435,169603,179772,189745,199890,210099,220102,229946,239705,249585,259372,269027,278762,288366,297743,307403,316677,326033,335214,344219,353044,361765,370573,379346,387814,396202,404496,412732,420897,428925,436897,444676,452441,459804,467310,474827,482162,489349,496522,503681,510648,517531,524379,531276,537749,544299,551027,557431,563896,570266,576416,582611,588672,594656,600666,606578,612401,618031,623821,629395,634992,640376,645788,651110,656415,661617,666744,671858,676768,681896,686997,692038,696877,701642,706384,711162,715933,720585,725157,729669,734173,738685,743004,747288,751664,755911,760054,764129,768193,772210,
0,0,0,0,0,5,19,67,194,440,869,1556,2573,3916,5637,7728,10152,13061,16319,20083,24030,28365,32948,38172,43543,49090,54958,61047,67273,73604,80002,86691,93523,100508,107491,114565,121635,128845,135919,143131,150384,157583,164962,172180,179316,186618,193871,201077,208292,215363,222584,229761,236794,243963,251100,258062,265072,271955,278726,285511,292337,299090,305670,312259,318651,325084,331588,337964,344234,350539,356686,362821,368914,374868,380801,386787,392691,398539,404449,410188,415864,421471,426988,432495,438017,443461,448747,454164,459472,464751,469864,474986,480120,485169,490180,495047,500058,504959,509809,514463,519161,523778,528438,533042,537564,542219,546756,551148,555466,559850,564066,568321,572518,576709,580930,585032,589192,593304,597353,601322,
0,0,0,0,0,0,0,5,17,50,116,229,413,708,1110,1701,2405,3343,4470,5798,7364,9139,11084,13307,15703,18312,21102,24085,27236,30588,34193,37987,41872,45825,49967,54257,58717,63102,67705,72368,77177,81995,86826,91751,96759,101849,106896,112145,117180,122294,127580,132768,137870,143110,148379,153714,158951,164251,169505,174750,179920,185287,190438,195498,200653,205886,211136,216252,221303,226391,231310,236405,241324,246420,251321,256270,261191,266111,271037,276013,280731,285663,290452,295198,299812,304576,309278,313953,318610,323203,327739,332287,336775,341195,345591,350076,354514,358808,363090,367375,371620,375790,379947,383977,388100,392293,396397,400369,404381,408361,412437,416349,420228,424146,428006,431703,435467,439081,442740,446474,
0,0,0,0,0,0,0,0,0,0,2,6,16,36,75,134,230,352,531,791,1090,1514,1969,2554,3168,3859,4687,5622,6676,7811,9060,10385,11844,13423,15059,16911,18770,20781,22853,25073,27374,29683,32111,34528,37101,39697,42437,45227,48162,51035,54099,57066,60115,63230,66331,69429,72516,75791,79198,82400,85787,89163,92522,96040,99517,102912,106247,109766,113359,116931,120444,123994,127508,130995,134599,138066,141529,145051,148513,152037,155576,159141,162603,166029,169582,173075,176598,180119,183641,187078,190558,194000,197411,200909,204316,207794,211115,214470,217912,221388,224866,228187,231505,234781,238104,241467,244745,248074,251408,254743,258091,261325,264537,267696,270923,274136,277367,280470,283722,286904,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,6,12,27,43,70,104,156,211,286,380,477,622,770,965,1199,1443,1729,2059,2423,2838,3321,3770,4326,4888,5513,6184,6914,7624,8413,9246,10123,11048,12005,12991,14080,15135,16336,17504,18687,19920,21187,22462,23836,25243,26728,28208,29698,31194,32732,34289,35916,37540,39198,40881,42600,44250,46000,47772,49642,51429,53258,55138,57057,58939,60876,62712,64641,66621,68554,70545,72629,74689,76636,78736,80790,82851,84916,86947,89093,91112,93198,95272,97395,99526,101640,103722,105891,108027,110218,112346,114467,116657,118871,121006,123205,125432,127601,129806,131953,134141,136357,138479,140642,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,13,25,30,34,49,61,79,102,123,154,184,213,257,312,361,429,481,555,638,727,827,933,1047,1172,1332,1497,1647,1820,2025,2242,2459,2675,2928,3206,3442,3706,3985,4272,4586,4898,5258,5588,5978,6337,6706,7116,7576,7972,8423,8879,9342,9835,10310,10784,11318,11857,12399,12927,13480,14036,14678,15263,15894,16561,17203,17855,18512,19178,19882,20588,21281,22037,22760,23492,24277,25020,25818,26612,27399,28198,29012,29864,30707,31557,32431,33342,34196,34999,35841,36699,
31402,225567,450137,640988,798561,928694,1037950,1130983,1210713,1279625,1340011,1394065,1442228,1485524,1525011,1560978,1593916,1623642,1651528,1677623,1701734,1724219,1745137,1764798,1783230,1800529,1816653,1831957,1846428,1860305,1873395,1886184,1898165,1909639,1920587,1930836,1940821,1950260,1959436,1968336,1976713,1984840,1992634,2000108,2007565,2014593,2021376,2027880,2034124,2040282,2046261,2051847,2057491,2062983,2068236,2073305,2078203,2082861,2087531,2092146,2096564,2100951,2105068,2109123,2113069,2116862,2120583,2124286,2127736,2131080,2134477,2137705,2140879,2143962,2146924,2149954,2152849,2155660,2158464,2161194,2163888,2166536,2169152,2171639,2174097,2176521,2178920,2181188,2183507,2185710,2187872,2190004,2192116,2194181,2196197,2198205,2200319,2202201,2204096,2205941,2207848,2209554,2211370,2213108,2214804,2216563,2218183,2219768,2221317,2222830,2224333,2225818,2227314,2228758,2230131,2231541,2232975,2234312,2235675,2237014,
3552,71636,206575,352154,489080,611510,719724,816047,901299,976858,1044563,1105648,1160347,1210576,1256497,1298949,1338278,1374550,1407751,1439012,1468453,1495678,1521462,1545737,1568547,1589988,1610242,1629781,1647920,1665334,1682002,1697700,1712749,1727009,1740736,1753994,1766581,1778676,1790160,1801402,1812163,1822598,1832748,1842505,1851747,1860749,1869560,1877889,1885972,1893933,1901600,1909055,1916097,1923103,1929898,1936469,1942682,1948927,1954815,1960665,1966321,1971909,1977334,1982754,1987681,1992608,1997371,2002165,2006799,2011246,2015669,2020026,2024197,2028326,2032302,2036134,2039949,2043734,2047411,2050957,2054482,2058011,2061467,2064749,2068003,2071094,2074188,2077211,2080221,2083058,2085917,2088802,2091610,2094348,2096956,2099520,2102084,2104586,2107065,2109455,2111821,2114110,2116390,2118579,2120783,2122885,2125033,2127216,2129273,2131324,2133414,2135334,2137257,2139091,2140991,2142791,2144583,2146354,2148130,2149873,
505,26802,106462,211781,322520,429658,529228,620782,704234,779785,848783,912000,969802,1022349,1071085,1116412,1158558,1198071,1234808,1268903,1301330,1331877,1360249,1386827,1412210,1436576,1459468,1481110,1501645,1521435,1540109,1557801,1574616,1591116,1606733,1621728,1636079,1650086,1663419,1676377,1688712,1700648,1712238,1723362,1733919,1744285,1754198,1763949,1773104,1782228,1791088,1799847,1808224,1816303,1824097,1831700,1839136,1846250,1853215,1860038,1866676,1873198,1879390,1885664,1891710,1897584,1903256,1908776,1914089,1919237,1924411,1929384,1934244,1938934,1943535,1948016,1952434,1956798,1961163,1965369,1969606,1973569,1977468,1981300,1985106,1988781,1992521,1996052,1999553,2003056,2006488,2009754,2013023,2016164,2019225,2022332,2025345,2028279,2031178,2034060,2036762,2039571,2042206,2044894,2047550,2050084,2052623,2055102,2057588,2059984,2062378,2064679,2066980,2069210,2071396,2073612,2075767,2077858,2079975,2082033,
14,5602,36977,95264,168617,248807,329647,407662,482073,552037,617378,679273,736678,790284,839957,886731,931203,972798,1011850,1048794,1083503,1116660,1147911,1177816,1205988,1232553,1258110,1282389,1305794,1327792,1348923,1369281,1388658,1407302,1425105,1442164,1458682,1474729,1490229,1504871,1519136,1533014,1546440,1559271,1571648,1583797,1595504,1606914,1617970,1628752,1639005,1649008,1658826,1668160,1677412,1686440,1695250,1703702,1711878,1719903,1727622,1735297,1742654,1749923,1757102,1763938,1770631,1777183,1783650,1789940,1796097,1802094,1807850,1813460,1819059,1824451,1829669,1834969,1840263,1845144,1850147,1854926,1859616,1864228,1868699,1873044,1877402,1881721,1885981,1890053,1894102,1898083,1902022,1905796,1909561,1913200,1916824,1920321,1923889,1927331,1930680,1934012,1937228,1940496,1943663,1946786,1949701,1952672,1955684,1958665,1961567,1964333,1967145,1969889,1972583,1975239,1977786,1980334,1982833,1985351,
1,394,5994,24038,55790,98211,147508,200355,255056,309399,363255,415876,466478,515238,561832,606480,649355,690321,729348,766530,801949,836231,868954,900316,930141,958727,986402,1012881,1038068,1062385,1085426,1108087,1129795,1150883,1170941,1190419,1209282,1227336,1244864,1262044,1278463,1294329,1309783,1324738,1339260,1353207,1366916,1380137,1392884,1405480,1417635,1429386,1440875,1451878,1462781,1473564,1483973,1493897,1503833,1513353,1522732,1531900,1540871,1549491,1557786,1566021,1574188,1582155,1589955,1597660,1605046,1612322,1619241,1626117,1632896,1639500,1646022,1652371,1658576,1664637,1670686,1676647,1682435,1688096,1693676,1698984,1704345,1709615,1714807,1719908,1724828,1729763,1734480,1739135,1743762,1748295,1752766,1757248,1761671,1765893,1770074,1774201,1778403,1782351,1786281,1790200,1793979,1797837,1801603,1805106,1808553,1812014,1815436,1818793,1822114,1825332,1828538,1831765,1834844,1837983,
0,40,1366,8108,23245,47159,78246,114391,153957,196031,239139,282909,326102,368235,409691,450392,489781,527696,564258,599674,634067,667360,699181,729866,759511,788485,816096,842652,868355,893271,917158,940346,962833,984478,1005563,1025680,1045115,1064386,1082887,1100996,1118465,1135294,1151682,1167849,1183304,1198557,1213331,1227548,1241444,1255041,1268222,1280948,1293424,1305255,1317253,1328888,1340003,1351029,1361828,1372164,1382313,1392199,1401891,1411296,1420662,1429748,1438595,1447410,1456189,1464588,1472835,1480614,1488345,1496080,1503488,1510806,1517958,1525061,1531999,1538772,1545444,1552027,1558475,1564717,1570839,1576912,1582894,1588743,1594462,1600224,1605690,1611208,1616532,1621802,1626962,1631965,1636937,1641762,1646620,1651415,1656107,1660714,1665232,1669630,1674064,1678315,1682716,1686932,1691087,1695098,1699036,1703027,1706881,1710720,1714450,1718048,1721745,1725319,1728893,1732373,
0,4,183,1632,6537,16319,31147,51320,75275,102187,131579,162827,195349,228374,261800,294906,327847,360430,392678,424100,454780,484868,514549,542807,570767,598106,624501,650579,675622,699667,723448,746593,769113,790866,811982,832712,852830,871900,890611,908847,926676,944078,961064,977560,993671,1009310,1024602,1039494,1054265,1068596,1082626,1096317,1109646,1122806,1135534,1147892,1160044,1171734,1183274,1194612,1205653,1216372,1226948,1237117,1247234,1256974,1266901,1276212,1285343,1294365,1303341,1312352,1320863,1329217,1337595,1345748,1353789,1361571,1369118,1376618,1384113,1391394,1398525,1405426,1412242,1419033,1425589,1432025,1438518,1444893,1451140,1457165,1463170,1469181,1474994,1480645,1486100,1491519,1496988,1502271,1507579,1512789,1517914,1522865,1527843,1532586,1537335,1542177,1546983,1551634,1556222,1560700,1565136,1569405,1573631,1577832,1581927,1585914,1589846,1593810,
0,0,10,143,972,3264,7753,14955,25155,38297,53491,71052,90447,111312,133307,156234,179641,203746,228000,252379,277035,301520,325716,349789,373542,396953,420081,443158,465423,487252,508782,530108,550712,571002,590895,610308,629338,648014,666426,684337,701856,718875,735689,752180,768274,783929,799434,814566,829480,844126,858467,872253,885951,899184,912298,924905,937181,949576,961762,973890,985323,996730,1007933,1018847,1029529,1039906,1050102,1060268,1069976,1079899,1089528,1098952,1108216,1117354,1126349,1135132,1143698,1152244,1160528,1168684,1176923,1184899,1192636,1200292,1207854,1215289,1222507,1229783,1236937,1243834,1250653,1257478,1264018,1270407,1276806,1282980,1289173,1295243,1301293,1307157,1313059,1318852,1324505,1330140,1335670,1341185,1346625,1351949,1357274,1362544,1367690,1372712,1377648,1382480,1387377,1392100,1396700,1401322,1405827,1410309,
0,0,0,2,32,242,843,2113,4477,7946,12856,19100,26824,35678,46103,57366,69891,83024,96866,111666,126796,142637,158799,174959,191552,208085,225013,242031,259207,275912,292598,309335,326130,342804,359100,375299,391452,407503,423216,438941,454025,469062,484262,499160,513740,528182,542584,556608,570421,583949,597334,610495,623125,636045,648680,660951,673184,685277,697040,708643,720083,731333,742448,753373,764065,774558,784810,795030,804988,815165,824959,834472,843907,853263,862405,871468,880378,889030,897644,906102,914712,922997,931097,939154,947193,954900,962673,970401,977819,985129,992245,999623,1006790,1013773,1020771,1027545,1034279,1040783,1047306,1053612,1060008,1066250,1072600,1078601,1084662,1090596,1096449,1102188,1107819,1113301,1118850,1124334,1129848,1135346,1140750,1145975,1151109,1156135,1161169,1166104,
0,0,0,1,4,27,110,356,904,1962,3559,5870,8964,12957,17714,23232,29760,37036,45088,53731,62927,72747,83194,94051,105336,116848,128854,141055,153519,166111,178808,191636,204528,217698,230686,243601,256682,269529,282298,295305,308109,321063,334041,346451,358961,371575,383898,396098,408220,420314,432221,444009,455829,467323,478754,490128,501319,512378,523416,534368,545026,555465,565801,576116,586230,596215,606052,615923,625472,634963,644441,653593,662758,671938,680891,689661,698495,707170,715586,723965,732189,740258,748397,756453,764445,772221,779970,787516,794920,802222,809398,816593,823784,830674,837477,844048,850826,857401,863935,870482,876962,883151,889349,895647,901863,907961,913968,919860,925683,931320,936961,942538,948110,953459,959027,964518,969923,975227,980466,985617,
0,0,0,0,0,1,7,39,113,304,629,1144,1957,3113,4706,6753,9255,12203,15822,19735,24142,29127,34495,40357,46742,53409,60453,67799,75400,83209,91363,99691,108285,117014,126029,135042,144341,153766,163086,172295,181916,191561,201234,210705,220308,229961,239660,249370,258979,268800,278510,288174,297720,307269,316596,326072,335428,344836,353925,363092,372266,381485,390476,399353,408108,416934,425589,434275,442632,451314,459628,467977,476309,484311,492226,500298,508275,516212,524004,531705,539147,546538,554094,561477,568596,575710,582869,590025,597006,603958,610810,617655,624373,630934,637530,644075,650572,656835,663334,669645,675819,681937,688136,694132,699981,705952,711877,717731,723451,729115,734731,740439,746041,751478,756934,762216,767426,772729,777795,782803,
0,0,0,0,0,0,0,1,4,12,35,88,217,432,707,1150,1780,2579,3557,4738,6208,7918,9930,12230,14729,17625,20746,24048,27607,31368,35467,39910,44436,49134,54060,59024,64360,69833,75413,81275,87147,93094,99147,105451,111689,118205,124723,131231,137792,144343,151111,157629,164333,171258,178020,184936,191734,198425,205562,212474,219192,226166,233030,239799,246750,253632,260390,267118,273916,280746,287552,294311,301170,307937,314470,321040,327579,334016,340526,346971,353354,359597,365722,372050,378138,384439,390573,396711,402690,408654,414537,420508,426280,432153,437998,443749,449414,455057,460690,466206,471727,477184,482700,488017,493405,498587,503911,509189,514253,519440,524500,529547,534570,539528,544370,549367,554317,559226,563985,568571,
0,0,0,0,0,0,0,0,0,0,1,2,13,26,51,106,179,292,437,655,937,1306,1751,2322,2984,3767,4682,5729,6813,8151,9663,11250,12948,14706,16723,18886,21114,23485,25940,28547,31455,34298,37230,40334,43573,46885,50312,53857,57464,61165,64888,68649,72490,76259,80213,84307,88380,92613,96981,101327,105699,110038,114444,118918,123338,127838,132258,136802,141433,146113,150640,155243,159735,164323,168893,173496,178162,182777,187379,192006,196702,201352,205997,210723,215241,219986,224537,229056,233700,238257,242769,247166,251656,256276,260800,265225,269745,274210,278617,283084,287477,291890,296250,300575,304891,309176,313446,317624,321873,326072,330236,334293,338425,342538,346583,350693,354810,358782,362731,366602,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,14,28,43,65,107,158,249,343,461,598,777,989,1250,1530,1887,2261,2692,3195,3779,4394,5112,5850,6658,7553,8476,9456,10511,11632,12854,14111,15454,16818,18212,19757,21336,22926,24630,26426,28286,30081,32028,34078,36190,38232,40331,42421,44676,47010,49347,51717,54157,56556,58995,61484,63971,66508,69056,71594,74254,76930,79559,82314,85011,87768,90579,93307,96046,98914,101679,104481,107362,110303,113215,116132,118966,121785,124593,127460,130365,133231,136163,139045,141905,144768,147804,150828,153718,156677,159628,162601,165705,168635,171510,174487,177285,180218,183036,185984,188896,191864,194785,197549,200373,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,5,6,9,15,28,45,69,92,120,149,204,256,323,397,504,620,731,918,1115,1294,1513,1771,2037,2325,2676,3037,3458,3877,4326,4850,5421,5940,6558,7173,7809,8495,9199,9943,10743,11568,12409,13311,14214,15157,16179,17241,18289,19386,20528,21700,22813,23982,25214,26458,27786,29090,30407,31787,33268,34702,36147,37556,38952,40357,41963,43493,45073,46626,48237,49800,51439,53049,54717,56429,58167,59784,61603,63333,65121,66826,68570,70388,72161,73920,75726,77569,79392,81166,83001,84816,86739,88597,90517,92350,94187,96099,97968,99871,101847,103756,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,3,4,6,10,17,22,36,52,65,79,99,132,157,196,240,301,365,419,489,572,647,751,851,989,1110,1267,1433,1595,1781,1960,2160,2378,2619,2882,3132,3420,3725,4021,4331,4700,5058,5455,5844,6215,6639,7102,7612,8093,8602,9123,9676,10213,10792,11367,11962,12558,13155,13786,14414,15108,15811,16514,17207,17933,18670,19451,20219,20952,21770,22651,23480,24278,25139,25959,26846,27722,28635,29574,30475,31413,32339,33265,34252,35151,36113,37094,38027,39027,40079,41119,42155,43206,44252,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,3,4,8,8,9,9,11,15,19,23,28,38,49,56,66,78,94,111,131,159,180,207,238,272,304,354,394,442,490,545,612,685,753,848,934,1036,1119,1230,1336,1459,1568,1681,1824,1971,2121,2309,2484,2682,2858,3035,3220,3401,3605,3813,4049,4264,4507,4757,5018,5250,5520,5783,6047,6300,6596,6924,7210,7539,7854,8200,8521,8843,9166,9542,9918,10301,10705,11101,11516,11911,12359,12759,13186,13606,14070,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,3,3,4,6,7,9,9,11,12,15,18,21,25,33,38,43,49,52,63,76,87,99,114,122,136,147,167,180,210,235,252,278,300,319,349,372,411,444,470,502,546,583,618,652,703,759,813,865,917,971,1018,1081,1142,1215,1274,1355,1431,1507,1589,1668,1745,1817,1903,1996,2083,2174,2283,2368,2484,2564,
38445,245253,470574,657543,809989,934376,1038633,1126803,1202179,1267466,1324575,1375535,1420838,1461497,1498434,1532074,1563332,1591833,1617846,1641919,1664437,1685348,1704773,1723062,1740369,1756468,1771637,1786030,1799490,1812164,1824602,1836293,1847430,1858249,1868382,1878035,1887213,1896066,1904574,1912921,1920820,1928351,1935703,1942798,1949474,1956074,1962398,1968572,1974427,1980106,1985561,1990927,1996141,2001230,2006130,2010847,2015361,2019799,2024078,2028289,2032386,2036446,2040288,2044233,2047917,2051433,2054928,2058198,2061544,2064832,2068110,2071118,2074141,2077043,2079908,2082723,2085524,2088269,2090901,2093440,2096041,2098398,2100770,2103104,2105447,2107653,2109873,2112094,2114190,2116321,2118326,2120288,2122295,2124205,2126067,2128002,2129912,2131687,2133460,2135176,2136932,2138585,2140225,2141881,2143496,2145073,2146606,2148202,2149753,2151173,2152546,2154043,2155476,2156821,2158190,2159552,2160863,2162094,2163320,2164545,
5458,87802,232246,380358,515289,635122,739592,831286,911913,983387,1046565,1103687,1154941,1201703,1244283,1283590,1319827,1353226,1383984,1412566,1439340,1464679,1487973,1510242,1531043,1550630,1569150,1586743,1603379,1619396,1634405,1648874,1662549,1675932,1688638,1700800,1712475,1723490,1734213,1744405,1754274,1763685,1772812,1781732,1790150,1798310,1806267,1813915,1821405,1828444,1835578,1842395,1848840,1855134,1861296,1867229,1873124,1878778,1884325,1889647,1894839,1899857,1904777,1909585,1914226,1918700,1923212,1927501,1931744,1935860,1939858,1943775,1947607,1951402,1955053,1958596,1961969,1965474,1968903,1972179,1975406,1978641,1981826,1984860,1987747,1990658,1993529,1996227,1998954,2001677,2004228,2006793,2009292,2011793,2014332,2016726,2019144,2021412,2023705,2025941,2028110,2030216,2032377,2034417,2036460,2038446,2040386,2042284,2044239,2046119,2048053,2049877,2051730,2053494,2055202,2056900,2058692,2060317,2061991,2063621,
1049,37273,128363,242332,355874,463107,560493,649014,728933,800447,865747,924608,978043,1027165,1072310,1114424,1152913,1189372,1223106,1254629,1283889,1311607,1337458,1361885,1384937,1406959,1427730,1447443,1466057,1483730,1500614,1516839,1532005,1546778,1561009,1574512,1587640,1600212,1612126,1623664,1634544,1645306,1655619,1665598,1675336,1684703,1693739,1702359,1710701,1718824,1726780,1734461,1741970,1749159,1756076,1762851,1769536,1776007,1782337,1788340,1794204,1799978,1805591,1811148,1816596,1821891,1826939,1831967,1836813,1841600,1846193,1850672,1855072,1859447,1863642,1867780,1871732,1875708,1879630,1883422,1887166,1890869,1894368,1897813,1901226,1904522,1907835,1911079,1914246,1917365,1920390,1923437,1926363,1929164,1931985,1934849,1937605,1940322,1943040,1945727,1948186,1950650,1953156,1955546,1957900,1960175,1962460,1964679,1966874,1969132,1971326,1973523,1975584,1977607,1979570,1981505,1983467,1985386,1987223,1989119,
83,9981,52888,122791,204168,287875,370378,448190,521679,589922,652658,710755,764934,815131,861512,905139,945732,983674,1019239,1052672,1084133,1114198,1142615,1169257,1194585,1218726,1241395,1263222,1283503,1303600,1322664,1340695,1357967,1374415,1390284,1405539,1420278,1434411,1448106,1461144,1473800,1486067,1497742,1509179,1520282,1530946,1541381,1551323,1561192,1570588,1579601,1588463,1597048,1605420,1613587,1621580,1629312,1636883,1644230,1651291,1658228,1664829,1671462,1677768,1683998,1690120,1696015,1701702,1707297,1712754,1718118,1723283,1728476,1733539,1738481,1743417,1748126,1752791,1757338,1761727,1766041,1770262,1774466,1778598,1782695,1786625,1790482,1794339,1798015,1801697,1805300,1808802,1812293,1815654,1818985,1822348,1825594,1828774,1831796,1834921,1837909,1840834,1843788,1846582,1849327,1852077,1854733,1857462,1860137,1862718,1865226,1867671,1870112,1872503,1874894,1877288,1879652,1881918,1884159,1886390,
0,1171,12054,39850,82092,133460,189868,247741,305273,361308,415601,467234,516786,563803,608644,651044,690998,728953,764727,799261,831893,862928,892344,920882,947556,973457,997907,1021438,1044217,1065798,1086469,1106593,1125599,1144080,1161865,1179307,1195890,1211829,1227294,1242192,1256551,1270353,1283721,1296918,1309513,1321851,1333693,1345087,1356283,1367102,1377746,1387881,1397842,1407511,1416819,1426010,1434911,1443583,1452112,1460342,1468456,1476225,1483826,1491202,1498420,1505703,1512679,1519501,1526086,1532551,1538917,1545167,1551253,1557188,1562969,1568759,1574318,1579752,1585129,1590271,1595450,1600552,1605554,1610272,1614908,1619547,1624016,1628620,1633082,1637358,1641594,1645791,1649818,1653962,1657932,1661887,1665689,1669357,1673112,1676702,1680210,1683729,1687148,1690467,1693839,1697141,1700351,1703593,1706782,1709867,1712813,1715830,1718873,1721790,1724595,1727438,1730150,1732860,1735605,1738352,
0,227,3915,17023,41474,74757,114669,158429,203926,250447,296886,342070,386171,429118,470539,510056,547885,584426,619125,652560,684564,715305,744575,772746,799822,825957,850713,874453,897744,919657,940837,961426,981286,1000518,1018976,1036715,1053887,1070789,1086824,1102483,1117429,1132202,1146404,1160175,1173516,1186246,1198782,1210948,1222879,1234334,1245496,1256210,1266782,1277127,1287195,1296992,1306638,1316009,1325085,1333887,1342585,1351022,1359323,1367348,1375173,1382839,1390331,1397760,1404929,1411949,1418920,1425722,1432430,1438918,1445196,1451477,1457532,1463492,1469303,1475108,1480707,1486164,1491532,1496795,1502086,1507074,1512080,1517084,1521977,1526701,1531463,1536113,1540666,1545066,1549500,1553826,1557994,1562094,1566167,1570256,1574164,1578020,1581934,1585633,1589215,1592802,1596533,1600036,1603499,1606938,1610342,1613701,1616995,1620297,1623456,1626585,1629707,1632744,1635750,1638719,
0,24,834,5305,16017,33558,57283,85949,117885,151855,186904,223131,259250,295004,330197,364984,398742,431623,463637,494656,524655,553519,581412,608378,634292,659725,684182,707903,730551,752664,774127,794862,814887,834128,852955,871103,888505,905411,922119,937996,953714,968934,983797,998158,1012012,1025746,1038872,1051428,1063777,1075972,1087774,1099454,1110863,1121737,1132441,1142839,1152961,1162813,1172412,1181974,1191323,1200319,1209228,1217828,1226195,1234469,1242440,1250320,1258126,1265689,1273093,1280327,1287484,1294497,1301467,1308132,1314838,1321346,1327747,1334012,1340109,1346061,1351974,1357770,1363585,1369317,1374752,1380021,1385408,1390739,1395829,1400809,1405846,1410691,1415321,1420006,1424660,1429326,1433877,1438298,1442693,1447060,1451290,1455408,1459408,1463548,1467570,1471375,1475226,1479089,1482838,1486504,1490237,1493837,1497368,1500871,1504337,1507655,1511005,1514288,
0,0,77,935,4143,10919,21384,35801,53794,74773,97811,122369,148213,174767,201992,229001,256015,283006,309468,335975,361670,387037,412144,436478,460005,483156,505924,527913,549096,569981,590269,609984,629205,647760,665929,683576,700951,717645,734012,750032,765724,780928,795941,810581,824707,838283,851595,864781,877740,890160,902449,914393,926030,937384,948567,959545,970217,980537,990611,1000561,1010153,1019696,1029053,1038063,1047097,1055704,1064424,1072816,1081101,1089164,1097174,1104893,1112546,1119934,1127360,1134629,1141848,1148921,1155862,1162593,1169142,1175734,1181968,1188273,1194371,1200516,1206531,1212424,1218078,1223698,1229242,1234724,1240202,1245504,1250741,1255837,1260856,1265935,1270881,1275675,1280473,1285071,1289579,1294117,1298535,1302995,1307357,1311569,1315745,1319938,1324062,1328160,1332191,1336151,1340125,1344077,1347795,1351423,1355011,1358610,
0,0,2,76,518,1886,4815,9647,16547,25585,36767,49711,64044,79717,96251,113884,131920,150439,169463,188516,207991,227289,246536,265915,284983,303816,322599,341171,359344,377254,394736,411949,428866,445709,462297,478781,494495,509919,524961,539879,554733,568976,582976,596875,610327,623735,636801,649402,661865,674028,686119,697809,709268,720652,731605,742613,753286,763718,774016,783866,793723,803486,813023,822285,831568,840335,849279,857892,866464,874897,883211,891258,899314,907039,914507,922111,929648,936954,944144,951221,958337,965151,971976,978634,985204,991555,997813,1004183,1010279,1016308,1022341,1028161,1033713,1039399,1045195,1050822,1056239,1061494,1066676,1071933,1077058,1082081,1087006,1092013,1096934,1101689,1106300,1111005,1115665,1120154,1124589,1129064,1133264,1137583,1141776,1146033,1150144,1154217,1158334,1162321,
0,0,0,7,89,417,1314,3140,6138,10367,15982,23093,31356,40921,51692,63206,75699,88695,102364,116360,130784,145818,161033,176238,191660,207021,222470,237613,252907,268008,283067,298161,312643,327245,341816,356120,370167,383917,397805,411269,424814,438174,451201,463946,476560,488977,501011,513002,524681,536213,547420,558653,569660,580614,591237,601704,611894,622074,632073,641829,651352,660801,670087,679304,688343,697177,705855,714402,722920,731365,739724,747824,755648,763310,770781,778492,786077,793386,800665,807745,814671,821527,828230,834939,841515,848110,854680,860907,867189,873388,879497,885483,891286,896933,902650,908371,913899,919474,925056,930467,935730,940918,945970,950929,955944,960823,965682,970463,975215,979889,984514,989154,993482,997878,1002171,1006522,1010741,1014958,1019229,1023416,
0,0,0,0,10,52,243,693,1631,3168,5418,8502,12339,17046,22695,29017,36069,44015,52471,61662,71266,81411,91987,102808,113866,125078,136436,147881,159664,171458,183234,195146,206995,218840,230664,242298,253771,265484,276951,288506,300008,311245,322609,333551,344351,355108,365961,376530,387013,397350,407465,417568,427672,437664,447357,457037,466508,475758,484902,494139,503348,511978,520570,529266,537849,546347,554604,562933,570804,578764,586641,594352,601840,609286,616780,624119,631284,638239,645271,652189,658818,665560,672172,678717,685183,691523,698049,704233,710318,716342,722346,728203,734020,739720,745370,751035,756633,762208,767658,772972,778159,783289,788155,793298,798433,803244,808191,813109,817874,822586,827244,831824,836352,840834,845233,849612,853975,858202,862308,866539,
0,0,0,0,0,2,23,94,259,603,1179,2122,3405,5159,7353,10135,13393,17009,21150,25868,31073,36536,42445,48863,55596,62671,70016,77619,85448,93444,101602,110037,118338,126861,135456,144220,152917,161668,170481,179217,188034,196630,205336,214145,223002,231789,240640,249347,258012,266539,275033,283426,291854,300097,308420,316777,325073,333033,341042,348909,356651,364489,372174,379746,387131,394510,401752,409021,416354,423651,430665,437681,444664,451430,458245,465127,471629,478108,484681,491076,497456,503693,509761,515888,521899,527882,533795,539653,545530,551313,557095,562703,568212,573794,579102,584320,589721,594915,600019,605150,610153,615171,620152,625041,629806,634538,639281,643957,648642,653192,657757,662214,666669,671044,675528,679802,684080,688415,692651,696783,
0,0,0,0,0,0,2,10,25,70,166,343,621,1009,1626,2458,3469,4722,6237,8053,10187,12468,15113,18120,21356,24929,28597,32670,36868,41194,45805,50540,55448,60682,66028,71418,76916,82538,88424,94241,100114,106182,112181,118364,124337,130639,137007,143194,149402,155623,161896,168135,174603,180975,187360,193593,199814,205973,212177,218361,224557,230874,237039,243122,249135,255191,261182,267281,273236,279026,284833,290722,296501,302318,307945,313706,319356,324990,330507,336058,341560,346981,352312,357559,362681,367859,373077,378258,383343,388251,393222,398310,403218,408082,412861,417647,422509,427197,431932,436512,440934,445431,449956,454449,458911,463281,467587,471910,476164,480375,484544,488739,492945,497020,501104,505174,509120,513093,516961,520798,
0,0,0,0,0,0,0,1,1,1,6,24,59,104,186,299,492,774,1109,1534,2065,2731,3481,4422,5527,6723,8046,9499,11129,12877,14828,16954,19145,21488,24031,26667,29436,32296,35225,38218,41288,44477,47907,51471,54975,58527,62188,66061,69834,73628,77445,81410,85442,89401,93411,97520,101500,105618,109925,114167,118342,122421,126676,130929,135211,139517,143683,147944,152285,156564,160790,165068,169389,173570,177731,181983,186302,190492,194653,198921,203119,207247,211364,215574,219630,223731,227759,231689,235782,239772,243721,247630,251573,255526,259428,263256,267222,271027,274888,278758,282540,286226,290026,293742,297362,301060,304692,308186,311759,315303,318887,322417,325883,329215,332550,335949,339408,342748,346179,349504,
0,0,0,0,0,0,0,0,0,0,0,0,0,2,12,25,65,101,169,250,368,534,712,923,1220,1578,1984,2437,2939,3561,4209,4967,5818,6721,7729,8761,9894,11075,12336,13721,15117,16608,18249,19875,21639,23462,25302,27154,29080,31096,33252,35413,37585,39855,42052,44412,46864,49249,51777,54212,56786,59370,61904,64610,67259,69916,72782,75499,78331,81076,83940,86702,89515,92428,95339,98160,101049,103994,106910,109775,112741,115532,118418,121404,124292,127167,130068,133009,135970,138947,141987,144835,147742,150626,153476,156334,159290,162185,165094,167854,170691,173488,176307,179267,182120,184854,187667,190432,193229,195997,198810,201598,204333,207043,209656,212397,215177,217859,220519,223171,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,10,19,32,50,69,106,137,184,251,341,442,559,700,856,1034,1259,1500,1788,2105,2456,2841,3266,3752,4241,4804,5313,5910,6568,7233,7945,8709,9496,10337,11297,12179,13069,14065,15058,16137,17203,18336,19448,20661,21865,23118,24461,25785,27140,28470,29806,31255,32745,34267,35791,37283,38828,40406,41960,43451,45106,46723,48372,49972,51675,53392,55203,56945,58725,60447,62248,64036,65872,67693,69479,71272,73064,75013,76861,78682,80479,82256,84074,85984,87842,89738,91633,93529,95453,97331,99213,101131,103034,104964,106898,108782,110673,112603,114424,116305,118183,120048,121924,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,10,19,27,35,45,67,96,116,139,172,212,265,325,389,469,552,661,764,908,1048,1199,1371,1559,1765,1963,2157,2377,2623,2878,3189,3475,3810,4153,4537,4899,5297,5681,6106,6583,7043,7489,7976,8488,9002,9543,10111,10702,11308,11925,12544,13219,13917,14581,15272,15989,16687,17405,18096,18805,19568,20307,21162,21949,22800,23624,24418,25243,26145,27067,27982,28868,29760,30708,31679,32630,33601,34617,35561,36561,37561,38567,39576,40546,41611,42602,43631,44622,45674,46720,47746,48811,49864,50969,52041,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,5,5,9,11,16,19,25,31,37,49,60,71,85,108,128,151,184,206,231,255,290,332,375,422,490,550,615,681,750,838,919,1009,1092,1180,1285,1388,1504,1619,1747,1884,2017,2148,2325,2477,2642,2828,2989,3171,3369,3551,3736,3936,4167,4410,4641,4866,5126,5339,5590,5872,6135,6393,6699,6958,7280,7592,7877,8203,8511,8835,9154,9473,9823,10118,10490,10864,11235,11593,11958,12344,12744,13105,13504,13918,
45821,263002,488436,672056,820162,940515,1040191,1124698,1196441,1258419,1312483,1360553,1403319,1441958,1476930,1509357,1538637,1565390,1589938,1612659,1633724,1653504,1671924,1689261,1705740,1721251,1735661,1749133,1761940,1774121,1785803,1796791,1807244,1817371,1827057,1836358,1844989,1853341,1861279,1869057,1876522,1883585,1890551,1897234,1903765,1910064,1916056,1921776,1927318,1932679,1938002,1943016,1948032,1952812,1957445,1962057,1966502,1970779,1974943,1978981,1982908,1986743,1990333,1993990,1997481,2000910,2004277,2007484,2010637,2013809,2016808,2019804,2022667,2025527,2028293,2031038,2033690,2036216,2038746,2041269,2043656,2046050,2048337,2050592,2052828,2055014,2057134,2059220,2061280,2063347,2065304,2067224,2069131,2070929,2072818,2074639,2076361,2078057,2079781,2081492,2083155,2084790,2086343,2087882,2089389,2090887,2092364,2093870,2095311,2096716,2098132,2099588,2100945,2102320,2103565,2104932,2106203,2107430,2108684,2109891,
7829,102639,254651,404933,538330,654269,755270,842764,919887,987736,1047900,1101746,1150243,1194465,1234349,1270967,1305192,1336593,1365464,1392485,1417648,1441365,1463470,1484279,1503849,1521990,1539426,1555777,1571333,1586203,1600343,1613819,1626510,1638769,1650607,1661991,1672865,1683331,1693182,1702695,1711897,1720739,1729100,1737184,1745195,1752907,1760300,1767378,1774207,1780937,1787397,1793628,1799898,1805872,1811601,1817189,1822574,1827838,1833027,1837983,1842905,1847730,1852399,1856864,1861304,1865729,1869871,1873915,1877840,1881629,1885422,1889000,1892546,1896103,1899494,1902969,1906224,1909524,1912683,1915797,1918960,1922003,1924921,1927746,1930627,1933389,1936038,1938613,1941237,1943746,1946170,1948660,1951083,1953353,1955561,1957808,1960004,1962218,1964320,1966496,1968561,1970525,1972554,1974528,1976480,1978333,1980179,1982076,1983930,1985705,1987496,1989236,1990914,1992581,1994259,1995916,1997531,1999133,2000658,2002186,
1781,47657,150490,269753,385294,491082,586859,671725,748340,816925,878151,934123,984982,1031207,1074000,1113294,1149587,1182998,1214045,1243415,1270732,1296319,1320724,1343342,1364811,1384910,1404220,1422361,1439684,1455829,1471530,1486577,1500802,1514513,1527726,1540073,1552104,1563649,1574784,1585488,1595768,1605538,1615024,1624459,1633326,1642002,1650278,1658423,1666202,1673603,1680921,1688088,1694901,1701692,1708132,1714487,1720628,1726578,1732375,1738090,1743552,1748945,1754110,1759302,1764291,1769186,1773951,1778585,1783109,1787446,1791730,1795958,1799917,1803931,1807803,1811633,1815464,1819151,1822798,1826309,1829729,1833120,1836330,1839589,1842853,1846061,1849082,1852148,1855055,1857980,1860809,1863610,1866309,1868893,1871552,1874125,1876661,1879137,1881648,1884049,1886410,1888817,1891112,1893325,1895505,1897688,1899855,1901985,1904035,1906114,1908147,1910187,1912083,1913988,1915895,1917830,1919648,1921447,1923252,1925010,
191,15043,68695,147254,234399,321468,404255,481774,553491,619487,679984,735239,786486,833989,877879,918496,956416,992226,1025536,1056622,1085796,1113727,1139481,1164040,1187284,1209466,1230564,1250611,1269695,1287837,1305296,1321917,1337599,1352784,1367358,1381574,1395091,1408140,1420642,1432797,1444424,1455609,1466487,1476792,1486929,1496600,1506092,1515369,1524147,1532681,1540834,1548880,1556823,1564400,1571816,1579059,1586011,1592827,1599435,1605815,1612047,1618226,1624165,1629923,1635653,1641193,1646702,1652039,1657310,1662359,1667380,1672154,1676960,1681580,1686045,1690419,1694791,1699018,1703227,1707258,1711200,1715112,1719056,1722743,1726374,1729907,1733449,1737016,1740466,1743805,1747230,1750471,1753560,1756688,1759716,1762651,1765582,1768412,1771134,1773930,1776665,1779444,1782087,1784719,1787270,1789803,1792287,1794773,1797170,1799572,1801957,1804327,1806653,1808906,1811079,1813302,1815414,1817460,1819534,1821581,
6,2487,19734,56799,107947,165970,226866,287832,347151,403718,457677,508580,556729,602311,644770,684812,722891,758702,792338,824437,854929,883692,911203,937415,962361,985977,1008663,1030373,1050922,1070213,1089201,1107480,1124650,1141606,1157696,1173226,1188271,1202596,1216457,1229921,1243004,1255583,1267694,1279496,1290850,1301757,1312464,1323019,1333032,1342768,1352345,1361395,1370489,1379204,1387589,1395793,1403833,1411853,1419356,1426692,1434055,1440996,1447760,1454407,1460957,1467362,1473607,1479707,1485659,1491503,1497410,1503102,1508592,1513897,1519105,1524157,1529282,1534218,1539004,1543730,1548390,1552891,1557280,1561653,1565925,1570068,1574128,1578195,1582225,1586082,1590127,1593836,1597558,1601218,1604775,1608367,1611839,1615204,1618524,1621854,1625085,1628240,1631347,1634462,1637440,1640433,1643375,1646292,1649153,1652014,1654766,1657465,1660160,1662799,1665335,1667903,1670405,1672913,1675431,1677851,
0,611,7635,27808,60421,101858,148261,197307,247155,295831,343276,389404,433491,475662,516064,554506,590965,625814,658750,690174,720107,749156,776663,802897,827641,851710,874541,896663,917830,937965,957377,976159,994567,1012145,1028972,1045119,1060901,1076107,1090604,1104545,1118221,1131247,1143940,1156444,1168261,1179836,1191148,1202062,1212743,1223228,1233292,1243036,1252331,1261413,1270463,1279359,1288024,1296223,1304299,1312255,1320030,1327665,1334938,1342156,1349066,1355917,1362515,1369218,1375676,1382017,1388056,1394073,1399950,1405696,1411321,1416765,1422056,1427476,1432601,1437831,1443025,1448089,1452898,1457680,1462360,1466868,1471374,1475771,1480195,1484431,1488624,1492698,1496717,1500536,1504503,1508366,1512157,1515813,1519375,1522984,1526505,1530017,1533368,1536715,1539988,1543274,1546392,1549580,1552589,1555666,1558656,1561690,1564643,1567556,1570399,1573220,1576022,1578786,1581484,1584116,
0,77,2265,10693,27908,52868,83889,118549,155558,193906,232766,271482,309491,346355,382124,417123,450937,483297,514365,544219,573258,600554,627094,652623,677098,700794,724056,745777,766875,787146,806907,826159,844632,862516,879653,896307,912370,927939,942907,957328,971366,984875,998234,1011224,1023817,1035895,1047858,1059402,1070486,1081393,1091974,1102423,1112502,1122305,1131950,1141504,1150536,1159341,1168046,1176454,1184838,1192987,1200742,1208378,1215887,1223115,1230239,1237326,1244216,1250989,1257659,1264254,1270442,1276701,1282775,1288824,1294642,1300376,1305863,1311398,1316820,1322154,1327502,1332722,1337744,1342653,1347502,1352227,1356922,1361419,1365927,1370363,1374722,1378992,1383226,1387420,1391543,1395565,1399436,1403338,1407136,1411007,1414685,1418368,1421861,1425508,1428953,1432447,1435911,1439305,1442649,1445895,1449114,1452269,1455335,1458417,1461455,1464537,1467598,1470347,
0,7,372,2881,9514,21372,37986,58961,83320,109571,137610,166654,196031,225848,255427,284290,312964,341074,368538,395257,421033,446105,470519,494637,517377,539762,561614,582680,602827,622573,641630,660224,678104,695554,712500,728809,745017,760645,775651,790305,804574,818315,831830,845104,857764,870141,882172,894094,905468,916685,927800,938601,949213,959438,969484,979320,988925,998273,1007317,1016206,1024905,1033553,1041812,1049873,1057795,1065613,1073265,1080629,1088017,1095138,1102197,1109028,1115713,1122370,1128886,1135407,1141639,1147717,1153828,1159755,1165532,1171171,1176806,1182121,1187621,1193095,1198359,1203611,1208639,1213529,1218467,1223292,1228027,1232758,1237430,1241862,1246314,1250729,1255011,1259235,1263424,1267503,1271530,1275494,1279367,1283235,1287054,1290739,1294480,1298168,1301807,1305433,1308984,1312485,1315926,1319327,1322574,1325931,1329108,1332278,
0,1,26,417,1933,5657,11988,21298,33158,47605,64295,82312,101270,121447,142353,163537,184812,206445,227957,249189,270298,291396,311826,332338,352230,371684,390966,409761,428063,445832,463131,479969,496446,512834,528692,544347,559466,574229,588870,603180,616880,630650,644040,657189,669740,682010,694056,705827,717317,728506,739515,750347,760869,771202,781474,791258,800781,810191,819394,828474,837548,846155,854706,863182,871549,879572,887448,895137,902854,910279,917522,924703,931783,938717,945328,951949,958523,964946,971243,977489,983681,989752,995782,1001605,1007377,1012984,1018625,1024121,1029389,1034702,1039936,1045198,1050198,1055128,1059939,1064843,1069546,1074195,1078722,1083322,1087846,1092151,1096611,1100970,1105135,1109242,1113304,1117394,1121342,1125232,1129075,1132926,1136678,1140378,1144165,1147864,1151559,1155198,1158656,1162111,
0,0,2,77,490,1799,4541,9165,15708,24069,34329,46111,59218,73205,88197,103997,120591,137346,154412,171571,188988,206383,223500,240925,257999,274946,291540,308076,324413,340381,356100,371636,386895,401996,416590,430964,444988,458763,472309,485566,498470,511220,523796,536110,548253,560201,571864,583213,594198,605047,615764,626231,636231,646373,656272,665969,675655,684870,694018,703084,712012,720655,729280,737485,745856,753813,761791,769665,777296,784865,792322,799469,806553,813726,820507,827324,834026,840659,846939,853419,859569,865771,871813,877874,883764,889366,895177,900802,906317,911734,917078,922443,927586,932638,937683,942618,947525,952389,957138,961768,966335,970927,975353,979746,984142,988445,992693,996826,1000965,1004960,1009000,1012842,1016815,1020683,1024509,1028368,1032122,1035721,1039390,1043009,
0,0,0,8,113,486,1368,3037,5878,9860,15050,21526,29175,37823,47589,58226,69674,81344,93484,106116,119247,132401,145923,159339,172882,186637,200412,213912,227352,240774,253990,267092,280183,293214,306129,318963,331332,343642,355671,367737,379478,391001,402682,413900,424878,435974,446719,457295,467573,477893,487876,497782,507446,516995,526465,535710,544669,553525,562350,571170,579701,588046,596274,604405,612344,620261,628075,635607,642987,650363,657774,664953,671961,678911,685703,692369,698904,705316,711808,718086,724115,730292,736386,742417,748393,754050,759838,765480,771073,776523,781788,787126,792397,797502,802589,807552,812424,817302,822039,826716,831384,835937,840354,844981,849467,853931,858334,862639,866757,870921,874907,878941,882884,886942,890873,894700,898536,902386,906141,909883,
0,0,0,1,6,57,232,689,1540,2983,5098,8012,11620,15919,20926,26608,33082,40123,47677,55691,64160,73125,82276,91625,101209,110976,120991,131076,141385,151764,162115,172476,182938,193331,203617,214026,224202,234312,244555,254602,264413,274179,284066,293871,303456,312955,322337,331787,340974,350213,359185,368075,376726,385468,393844,402388,410545,418649,426745,434691,442576,450252,457804,465245,472702,480059,487289,494382,501352,508363,515101,521899,528648,535326,541714,548180,554572,560941,567127,573156,579066,585056,590845,596525,602167,607698,613323,618775,624140,629338,634656,639742,644862,649970,654955,659863,664609,669324,674052,678729,683441,688027,692711,697173,701528,705874,710365,714598,718783,722953,727064,731150,735094,738953,742943,746864,750706,754477,758157,761836,
0,0,0,0,0,2,22,102,255,559,1105,1971,3118,4722,6795,9160,12103,15429,19151,23397,27853,32583,37819,43563,49404,55495,61867,68486,75344,82214,89321,96528,103960,111302,118657,126190,133861,141403,148992,156605,164211,171960,179625,187172,194784,202196,209810,217234,224541,231990,239325,246580,253774,261136,268255,275412,282353,289136,296034,302821,309590,316455,323157,329795,336311,342798,349052,355239,361252,367457,373529,379481,385500,391386,397217,403210,408978,414639,420347,425900,431290,436669,441806,447062,452222,457398,462539,467654,472690,477677,482647,487544,492353,497110,501880,506358,510954,515444,519876,524367,528718,533004,537265,541546,545699,549947,554157,558162,562173,566171,570108,574067,577938,581757,585623,589350,593085,596735,600356,603823,
0,0,0,0,0,0,1,4,21,61,143,292,511,852,1359,2079,2985,4075,5320,6836,8632,10564,12844,15303,18037,21008,24186,27547,31067,34692,38595,42719,46954,51185,55666,60250,64955,69648,74430,79453,84376,89524,94729,99832,104966,110174,115448,120889,126136,131472,136738,142117,147440,152912,158156,163617,168826,174042,179336,184652,189883,195142,200348,205541,210549,215629,220659,225681,230697,235786,240758,245678,250636,255574,260368,265221,269938,274748,279338,283867,288538,293076,297737,302212,306659,311150,315577,320035,324291,328571,332772,336933,341271,345412,349525,353502,357534,361527,365374,369429,373222,377004,380822,384619,388330,392092,395839,399480,403143,406773,410337,413893,417383,420782,424144,427601,431083,434419,437718,441001,
0,0,0,0,0,0,0,0,0,2,13,31,65,124,218,362,581,859,1212,1641,2156,2819,3576,4448,5480,6638,7938,9404,10916,12628,14502,16429,18487,20686,22909,25391,27849,30500,33203,36005,38930,41871,44958,48086,51317,54527,57851,61113,64561,68053,71491,74998,78599,82169,85739,89394,93204,96770,100510,104176,107897,111610,115386,119199,122901,126618,130381,134140,137778,141511,145212,148954,152700,156408,160004,163665,167398,171065,174644,178344,181888,185440,189012,192563,196172,199895,203443,206971,210393,213885,217238,220626,224127,227611,231052,234496,237864,241105,244432,247666,251016,254201,257418,260692,263921,267054,270270,273346,276564,279659,282715,285681,288709,291738,294584,297483,300412,303353,306209,309117,
0,0,0,0,0,0,0,0,0,0,0,1,1,5,12,33,56,89,146,214,325,457,631,849,1088,1388,1729,2124,2605,3089,3684,4339,5075,5874,6747,7703,8741,9894,10953,12193,13462,14734,16130,17534,18994,20521,22150,23777,25556,27260,29020,30860,32743,34656,36640,38635,40579,42626,44742,46914,49107,51268,53503,55726,58004,60257,62575,64894,67172,69560,71993,74462,76795,79263,81731,84127,86549,89080,91535,93986,96447,98941,101461,103856,106267,108698,111233,113736,116256,118793,121281,123769,126257,128702,131067,133536,135859,138343,140760,143177,145632,148027,150364,152813,155171,157549,159940,162295,164564,166894,169343,171680,174012,176284,178498,180781,183137,185443,187755,190083,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,11,17,19,32,51,79,118,167,222,303,374,465,589,716,867,1063,1265,1496,1729,1984,2271,2633,2987,3372,3781,4239,4738,5236,5782,6346,6962,7591,8222,8905,9628,10356,11125,11916,12758,13588,14459,15356,16324,17286,18205,19192,20162,21221,22307,23455,24549,25674,26805,27986,29140,30264,31392,32597,33805,35097,36278,37548,38891,40179,41479,42844,44227,45588,46981,48324,49697,51066,52503,53950,55380,56822,58289,59762,61251,62768,64223,65705,67167,68687,70201,71623,73055,74508,76009,77437,78936,80451,81984,83387,84847,86406,87875,89320,90770,92281,93805,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,4,4,5,7,12,19,26,33,42,50,62,71,92,122,142,168,204,256,311,377,445,501,573,651,736,837,956,1063,1177,1277,1445,1600,1759,1922,2114,2299,2512,2738,2966,3221,3465,3718,3978,4265,4557,4858,5191,5508,5829,6172,6511,6884,7264,7660,8017,8413,8842,9266,9710,10192,10612,11109,11588,12049,12556,13034,13561,14046,14586,15115,15639,16217,16792,17351,17930,18517,19093,19677,20284,20867,21463,22099,22739,23352,23964,24610,25256,25984,26670,27332,27996,28679,29356,30089,30762,
52807,279137,504460,685032,828430,944921,1040977,1122554,1191859,1251334,1302614,1348699,1390040,1426720,1460150,1490330,1518428,1543820,1567431,1589242,1609381,1628475,1646053,1662620,1678288,1692851,1706320,1719386,1731476,1743170,1754277,1764819,1774952,1784717,1793853,1802677,1811306,1819265,1827067,1834352,1841440,1848314,1855078,1861575,1867686,1873680,1879507,1884875,1890281,1895415,1900441,1905202,1910016,1914724,1919170,1923399,1927634,1931700,1935645,1939456,1943246,1946924,1950552,1954021,1957336,1960595,1963869,1967006,1970065,1972979,1975900,1978737,1981491,1984156,1986900,1989466,1991959,1994469,1996905,1999289,2001633,2003957,2006193,2008386,2010550,2012683,2014784,2016884,2018824,2020753,2022674,2024602,2026486,2028294,2030085,2031834,2033497,2035196,2036849,2038445,2040049,2041642,2043195,2044675,2046162,2047616,2049070,2050501,2051879,2053271,2054646,2055976,2057302,2058605,2059865,2061188,2062438,2063663,2064880,2066105,
10321,117236,275742,426249,558284,671570,769190,854072,928181,993239,1050229,1101458,1147615,1189262,1227212,1261988,1294122,1323526,1350985,1376583,1400362,1422565,1443462,1463061,1481327,1498743,1515329,1531211,1546010,1559874,1573245,1585932,1597913,1609363,1620554,1631118,1641254,1651180,1660570,1669630,1678240,1686598,1694610,1702492,1709944,1717493,1724419,1731201,1737684,1744001,1750228,1756087,1761771,1767541,1773087,1778344,1783417,1788299,1793124,1797820,1802368,1806836,1811200,1815580,1819827,1823842,1827718,1831553,1835305,1838879,1842481,1845959,1849456,1852729,1855997,1859262,1862391,1865502,1868651,1871562,1874453,1877371,1880137,1882885,1885630,1888291,1890915,1893433,1895830,1898186,1900561,1903006,1905278,1907424,1909651,1911847,1914010,1916139,1918162,1920139,1922150,1924131,1926111,1928056,1929903,1931810,1933650,1935391,1937167,1938900,1940557,1942201,1943920,1945566,1947153,1948729,1950256,1951796,1953279,1954800,
2785,58344,170030,293344,409618,514380,607221,690162,764645,830539,889772,943093,991382,1035557,1075419,1112460,1146343,1177921,1207486,1234948,1260795,1284998,1307818,1329040,1348860,1367945,1386295,1403298,1419675,1435067,1449812,1463690,1476981,1489639,1501919,1513678,1524834,1535682,1546395,1556446,1565923,1575230,1584221,1592880,1601100,1609320,1617127,1624773,1632069,1639200,1645923,1652581,1659038,1665322,1671426,1677336,1683220,1688815,1694304,1699540,1704728,1709733,1714688,1719471,1724249,1728798,1733216,1737529,1741811,1745984,1750022,1753982,1757837,1761516,1765365,1768978,1772485,1775999,1779349,1782719,1785933,1789034,1792324,1795324,1798311,1801266,1804204,1807057,1809933,1812668,1815374,1817995,1820555,1823094,1825551,1827974,1830307,1832669,1835079,1837381,1839711,1841916,1844079,1846221,1848340,1850338,1852418,1854497,1856515,1858467,1860346,1862183,1864048,1865934,1867725,1869589,1871343,1873029,1874791,1876466,
360,21059,84118,170673,261572,350719,433496,509654,580173,643832,701720,755116,804104,849258,890686,929257,965422,998804,1029697,1058862,1086559,1112618,1137031,1160217,1182018,1202670,1222206,1241167,1258953,1275855,1292099,1307721,1322444,1336540,1350333,1363292,1375794,1387879,1399495,1410641,1421564,1432090,1442134,1451934,1461261,1470399,1479408,1487871,1496083,1503883,1511674,1519100,1526400,1533459,1540313,1547030,1553636,1559945,1566193,1572265,1578122,1583900,1589420,1594888,1600227,1605375,1610463,1615377,1620360,1625082,1629729,1634201,1638525,1642897,1647017,1651165,1655217,1659098,1663004,1666742,1670480,1674184,1677696,1681111,1684513,1687791,1691103,1694310,1697495,1700517,1703631,1706646,1709639,1712516,1715330,1718134,1720998,1723760,1726435,1729039,1731609,1734057,1736528,1739028,1741448,1743965,1746346,1748688,1751019,1753191,1755432,1757651,1759798,1761912,1764043,1766110,1768089,1770081,1772081,1774032,
18,4299,28291,73455,131206,194416,258622,321177,381106,437918,491406,541182,587863,631675,672738,711002,747090,781078,813190,843485,872238,899250,925373,949818,973108,995228,1016321,1036370,1055698,1074145,1091722,1108627,1124871,1140535,1155546,1169923,1183682,1197074,1209825,1222161,1234177,1245853,1257245,1267903,1278337,1288460,1298512,1308176,1317491,1326474,1335067,1343600,1351787,1359719,1367468,1374950,1382407,1389709,1396853,1403689,1410442,1416829,1423023,1429297,1435338,1441250,1446957,1452592,1458087,1463552,1468821,1474041,1479155,1484062,1488926,1493612,1498294,1502971,1507385,1511775,1515937,1520188,1524298,1528477,1532433,1536298,1540155,1543925,1547624,1551225,1554709,1558168,1561663,1564981,1568287,1571501,1574727,1577873,1580926,1584017,1587073,1590064,1592965,1595798,1598600,1601332,1604064,1606762,1609405,1611971,1614485,1617147,1619731,1622177,1624546,1626897,1629336,1631697,1633959,1636171,
2,1344,12931,39804,79497,127330,178323,230196,281933,332075,380405,426843,470442,511559,550987,588277,623707,657189,688819,718857,747453,774687,800657,825130,848561,871080,892682,913228,932970,951848,969823,987248,1004099,1020228,1035886,1050890,1065430,1079291,1092495,1105351,1117914,1130229,1141929,1153356,1164483,1175221,1185436,1195505,1205403,1215041,1224393,1233217,1241964,1250480,1258847,1266946,1274845,1282499,1289969,1297309,1304489,1311466,1318092,1324622,1330918,1337133,1343218,1349396,1355378,1361216,1367013,1372556,1377967,1383259,1388367,1393510,1398487,1403490,1408329,1413108,1417676,1422195,1426612,1430979,1435378,1439478,1443610,1447625,1451588,1455497,1459355,1463230,1466922,1470587,1474193,1477652,1481177,1484444,1487707,1491055,1494322,1497519,1500568,1503665,1506752,1509768,1512712,1515630,1518488,1521379,1524224,1526986,1529636,1532367,1534997,1537530,1540168,1542730,1545148,1547602,
0,269,4340,17460,40815,72280,108955,148535,189324,230592,271465,311726,350649,387927,423992,458671,491893,523398,553420,582345,610105,636569,661864,686444,709816,731992,753661,774273,794277,813405,831811,849721,866774,883411,899311,914911,930045,944548,958372,971745,984898,997431,1009702,1021701,1033268,1044535,1055531,1066112,1076480,1086421,1096357,1105826,1114866,1123895,1132584,1141160,1149507,1157736,1165678,1173313,1180886,1188206,1195355,1202499,1209369,1215996,1222742,1229278,1235556,1241691,1247836,1253792,1259484,1265216,1270758,1276230,1281415,1286641,1291794,1296841,1301841,1306613,1311393,1316027,1320741,1325231,1329607,1333945,1338222,1342329,1346437,1350482,1354539,1358450,1362235,1366081,1369705,1373349,1376967,1380461,1384090,1387535,1390940,1394249,1397550,1400835,1404087,1407349,1410530,1413595,1416656,1419621,1422595,1425451,1428325,1431166,1433824,1436626,1439274,1441867,
0,36,1010,5803,16490,33533,55669,82119,111108,141634,173212,204991,236884,268343,299065,328843,358160,386677,413971,440786,466405,491216,515167,538075,560452,582137,602996,622968,642363,661138,679293,697034,714175,730600,746772,762416,777619,792243,806363,819941,833096,846020,858715,870821,882612,894012,905191,916063,926683,937228,947434,957303,967038,976469,985697,994555,1003242,1011784,1019972,1028208,1036184,1044059,1051544,1058827,1066159,1073211,1080135,1087005,1093642,1100076,1106608,1112749,1118760,1124850,1130789,1136618,1142448,1148097,1153487,1158728,1163974,1169113,1174352,1179407,1184296,1189250,1193976,1198804,1203407,1207868,1212222,1216496,1220865,1225101,1229276,1233385,1237459,1241431,1245338,1249266,1252957,1256728,1260447,1264020,1267537,1271032,1274405,1277785,1281105,1284447,1287755,1290968,1294182,1297405,1300498,1303589,1306618,1309578,1312436,1315329,
0,2,112,1127,4422,11069,21270,34795,51545,70351,90952,112818,135546,158645,182177,205691,229060,252362,275330,297874,319730,341167,362506,383160,403359,422878,442098,460708,478664,496112,513197,529672,545806,561617,577076,591937,606379,620504,634434,647709,660875,673460,685863,697844,709581,721352,732634,743539,754306,764882,775011,785012,794774,804375,813745,822906,831850,840667,849204,857699,865926,873879,881598,889372,896973,904320,911629,918603,925577,932343,939025,945643,952107,958457,964731,970846,976805,982598,988414,994135,999755,1005245,1010662,1016069,1021350,1026554,1031577,1036517,1041388,1046090,1050816,1055487,1059962,1064365,1068889,1073248,1077598,1081888,1086052,1090143,1094200,1098051,1101997,1105869,1109674,1113462,1117181,1120815,1124477,1128096,1131622,1135053,1138472,1141786,1145201,1148514,1151884,1155124,1158337,1161475,
0,0,26,286,1491,4547,10041,17846,28018,40349,54492,70345,87280,104653,123204,141766,160854,180173,199150,218139,237003,255806,273989,292085,309990,327672,344958,361940,378686,394736,410722,426110,441342,456184,470526,484682,498494,512159,525191,537974,550435,562643,574728,586673,598419,609670,620820,631688,642076,652379,662550,672489,682134,691499,700700,709874,718889,727624,736243,744793,753021,761110,769044,776720,784272,791727,798958,806128,813220,820178,827038,833638,840107,846533,852796,859200,865254,871197,877089,882870,888484,894098,899688,905093,910510,915758,920968,926107,931080,935967,940902,945626,950243,954915,959474,964040,968566,972918,977279,981520,985706,989773,993806,997860,1001756,1005620,1009483,1013386,1017124,1020735,1024432,1028004,1031464,1034998,1038337,1041752,1045112,1048459,1051821,1055002,
0,0,0,56,401,1438,3585,7315,12601,19747,28108,37907,49089,61500,74264,87885,101950,116397,131284,146486,161885,177165,192129,207447,222591,237639,252418,267042,281376,295561,309546,323456,336870,350323,363257,376342,388969,401467,413617,425564,437381,449141,460356,471332,482446,493136,503556,513833,523802,533702,543306,552660,561876,571135,580150,589052,597735,606252,614715,622999,631158,639002,646793,654457,661818,669088,676404,683564,690625,697413,704131,710789,717322,723754,730024,736053,742047,748178,754117,759962,765553,771185,776736,782351,787589,792929,798174,803393,808526,813562,818490,823358,828139,832863,837472,842067,846628,851017,855360,859681,864048,868140,872338,876523,880639,884785,888761,892734,896661,900442,903947,907623,911236,914830,918339,921820,925236,928616,932014,935392,
0,0,0,4,61,308,966,2216,4317,7450,11532,16853,22948,29937,38043,46680,55931,65778,76152,86818,97701,108963,120327,132070,143725,155406,167024,178721,190520,202103,213622,225340,236747,248088,259410,270490,281279,292045,302812,313327,323650,334012,344116,354116,363920,373558,383140,392534,401777,410981,419826,428750,437255,445807,454324,462496,470672,478725,486555,494294,501867,509428,516872,524149,531485,538329,545354,552255,559120,565791,572346,578828,585302,591556,597721,603778,609635,615544,621308,627107,632725,638335,643903,649251,654610,659903,665158,670290,675393,680295,685192,689928,694673,699289,703963,708506,713019,717613,721896,726327,730582,734831,738917,743108,747185,751192,755182,759095,763022,766916,770665,774461,777988,781582,785184,788770,792346,795790,799278,802767,
0,0,0,1,6,33,149,429,994,2012,3535,5558,8148,11466,15309,19723,24743,30196,36215,42604,49420,56487,63936,71818,79766,87966,96391,104852,113511,122135,130801,139686,148371,157230,165969,174668,183445,192084,200539,209000,217588,226223,234547,242971,251359,259565,267756,275720,283710,291544,299332,306977,314501,322039,329293,336711,344084,351398,358602,365641,372487,379299,385903,392494,398993,405450,411818,418181,424480,430650,436771,442928,448743,454663,460428,466148,471819,477442,482923,488296,493563,498759,503937,509025,514095,519134,524052,528987,533802,538622,543386,548065,552565,557060,561556,565973,570395,574798,579071,583305,587421,591494,595633,599614,603593,607574,611472,615361,619166,622916,626493,630232,633878,637490,641030,644495,647905,651316,654838,658182,
0,0,0,0,0,1,7,50,141,337,643,1155,1875,2834,4208,5870,7904,10122,12822,15815,19004,22561,26502,30503,34990,39668,44591,49495,54640,59950,65455,71256,76906,82788,88728,94748,100983,107220,113348,119524,125748,132085,138369,144579,150840,157025,163308,169565,175578,181630,187671,193718,199887,206008,211998,218003,223785,229642,235376,241021,246631,252333,258001,263598,269090,274569,279833,285196,290470,295808,301017,306246,311537,316674,321634,326665,331625,336565,341474,346262,351077,355764,360565,365135,369618,374160,378595,383128,387422,391715,395940,400174,404358,408461,412569,416788,420979,424903,428876,432861,436618,440414,444136,447896,451522,455113,458786,462391,466020,469657,473253,476771,480116,483489,486811,490101,493475,496772,500021,503217,
0,0,0,0,0,0,0,5,11,43,100,188,342,604,937,1420,2051,2792,3816,4980,6284,7825,9548,11528,13671,15830,18275,20931,23889,26824,29966,33135,36592,40013,43577,47207,50970,54897,58931,62997,67165,71344,75572,79834,84046,88406,92712,97089,101511,106031,110422,114896,119345,123759,128300,132794,137179,141627,146095,150607,154939,159456,163978,168265,172579,176934,181152,185554,189913,194220,198557,202780,206931,211025,215234,219435,223470,227573,231544,235497,239499,243464,247480,251286,255207,259029,262796,266588,270247,274078,277667,281356,285048,288688,292279,295836,299348,302807,306172,309604,312937,316341,319693,322966,326327,329518,332702,335913,339108,342289,345499,348571,351656,354698,357602,360661,363640,366587,369483,372381,
0,0,0,0,0,0,0,0,0,0,4,10,30,58,112,202,298,449,682,996,1342,1779,2307,2855,3482,4289,5142,6069,7167,8322,9597,10906,12429,14027,15758,17467,19256,21093,23024,25164,27313,29544,31797,34117,36461,38833,41269,43790,46384,48969,51610,54268,56941,59699,62487,65286,68150,71030,73984,76844,79851,82675,85590,88627,91551,94586,97603,100584,103547,106536,109554,112541,115550,118544,121577,124495,127513,130457,133434,136390,139386,142373,145256,148267,151227,154103,157023,159866,162667,165549,168367,171225,174065,176934,179734,182572,185293,188043,190846,193628,196391,199085,201793,204508,207134,209838,212451,215029,217662,220332,222949,225494,228110,230726,233171,235641,238104,240485,242990,245458,
0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,5,10,28,56,83,124,173,240,329,423,542,714,915,1133,1369,1674,2014,2402,2799,3284,3803,4368,4999,5647,6343,7117,7854,8638,9490,10396,11366,12324,13375,14412,15513,16655,17829,19043,20274,21528,22843,24186,25598,26977,28395,29835,31272,32706,34258,35803,37334,38994,40628,42258,43868,45570,47214,48947,50603,52353,54070,55818,57557,59281,61070,62756,64535,66350,68181,69987,71775,73562,75365,77143,79052,80799,82644,84418,86233,88136,90032,91915,93749,95580,97415,99285,101129,102922,104739,106635,108470,110249,112006,113883,115678,117479,119244,121067,122876,124729,126493,128225,130000,131873,133602,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,6,10,11,23,27,42,57,86,113,150,190,229,301,366,453,540,616,715,834,967,1090,1254,1422,1625,1832,2040,2273,2521,2794,3070,3322,3610,3924,4267,4637,5027,5440,5854,6257,6727,7177,7647,8133,8674,9229,9740,10259,10824,11383,11984,12587,13229,13824,14472,15128,15766,16461,17179,17894,18592,19351,20131,20880,21651,22368,23105,23897,24701,25472,26238,27077,27894,28734,29577,30421,31241,32072,32957,33796,34685,35567,36459,37342,38268,39181,40081,40989,42019,42875,43757,44655,45578,46506,47455,48335,49260,50185,
60232,293952,518014,695563,835313,948166,1041396,1119635,1186166,1243555,1293349,1337378,1377122,1412483,1444768,1473837,1500731,1525229,1547827,1568795,1588299,1606298,1623005,1638885,1653667,1667806,1680979,1693437,1705183,1716260,1726823,1736843,1746599,1755918,1764831,1773362,1781666,1789501,1797145,1804215,1810949,1817567,1823809,1829928,1835985,1841782,1847361,1852784,1858005,1863048,1867886,1872702,1877150,1881527,1885920,1890046,1894075,1898052,1901883,1905484,1909158,1912698,1916158,1919594,1922858,1925987,1929184,1932231,1935263,1938123,1940998,1943733,1946388,1948981,1951492,1954041,1956525,1958922,1961366,1963687,1965939,1968191,1970365,1972513,1974624,1976670,1978673,1980786,1982706,1984628,1986479,1988335,1990131,1991907,1993687,1995351,1997058,1998722,2000322,2001945,2003570,2005161,2006734,2008186,2009691,2011116,2012521,2013913,2015297,2016677,2018028,2019364,2020654,2021954,2023224,2024521,2025795,2027008,2028176,2029347,
13386,131314,294844,445787,575656,686177,781180,863022,933884,996286,1050824,1100214,1144411,1184346,1220790,1253914,1284709,1313028,1339141,1363531,1386273,1407660,1427434,1446010,1463352,1479901,1495432,1510387,1524503,1537908,1550605,1562733,1574210,1585112,1595710,1605952,1615617,1624982,1633980,1642652,1650833,1658761,1666439,1673804,1681014,1687984,1694734,1701286,1707630,1713565,1719426,1725143,1730591,1736167,1741325,1746564,1751568,1756323,1760993,1765439,1769836,1774053,1778205,1782427,1786405,1790133,1793974,1797738,1801342,1804941,1808420,1811751,1815043,1818334,1821500,1824715,1827690,1830720,1833686,1836502,1839263,1841982,1844640,1847268,1849719,1852201,1854711,1857183,1859595,1861908,1864274,1866480,1868777,1871017,1873126,1875230,1877323,1879385,1881408,1883256,1885203,1886981,1888886,1890696,1892543,1894297,1896058,1897770,1899512,1901163,1902810,1904472,1906133,1907663,1909186,1910712,1912250,1913756,1915253,1916664,
4082,69270,188413,314457,430908,534260,625664,706267,777842,841277,898008,948951,995108,1037028,1075466,1110679,1143419,1173574,1201677,1227594,1252245,1275259,1297021,1317203,1336428,1354385,1371596,1387804,1403168,1417753,1431729,1444827,1457343,1469535,1481116,1492251,1502911,1513214,1523135,1532780,1542004,1550751,1559205,1567319,1575249,1583071,1590614,1597860,1604811,1611505,1618075,1624352,1630560,1636616,1642340,1647994,1653483,1658827,1664037,1669055,1673913,1678679,1683442,1688095,1692585,1696945,1701245,1705323,1709395,1713346,1717174,1720965,1724667,1728275,1731768,1735112,1738499,1741848,1745163,1748421,1751507,1754596,1757543,1760534,1763393,1766211,1768945,1771697,1774381,1777086,1779612,1782183,1784710,1787101,1789521,1791776,1794125,1796359,1798622,1800818,1802981,1805104,1807223,1809276,1811268,1813264,1815248,1817206,1819047,1820920,1822779,1824585,1826403,1828238,1830022,1831708,1833460,1835185,1836885,1838542,
728,27450,99003,191452,285283,374619,456986,532612,601371,663631,719838,771118,818237,861572,901665,938564,972514,1004193,1033948,1061938,1088146,1112574,1135538,1157407,1178192,1197853,1216428,1234116,1251042,1267012,1282471,1297225,1311149,1324613,1337389,1349684,1361725,1372966,1383809,1394433,1404586,1414397,1423785,1432974,1441851,1450424,1458711,1466817,1474720,1482215,1489597,1496769,1503541,1510223,1516605,1522961,1529088,1535051,1540923,1546723,1552310,1557657,1562807,1568001,1573011,1578028,1582688,1587317,1591887,1596302,1600670,1605024,1609134,1613209,1617103,1620980,16