/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.mimetype.TurbineMimeTypes;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.CookieParser;
import org.apache.turbine.util.FormMessages;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.SystemError;
import org.apache.turbine.util.pool.Recyclable;
import org.apache.turbine.util.pool.RecyclableSupport;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.template.TemplateInfo;

public class DefaultTurbineRunData
extends RecyclableSupport
implements TurbineRunData,
Recyclable {
    private static Locale defaultLocale;
    private static boolean defaultLocaleChecked;
    private static String defaultCharSet;
    private static boolean defaultCharSetChecked;
    private ParameterParser parameters;
    public CookieParser cookies;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private HttpSession session;
    private ServletConfig config;
    private ServletContext servletContext;
    private AccessControlList acl;
    private boolean pageSet;
    private Document page;
    private String action;
    private String layout;
    private String screen;
    private String templateEncoding;
    private TemplateInfo templateInfo;
    private StringElement message;
    private FormMessages messages;
    private User user;
    private String title;
    private boolean outSet;
    private PrintWriter out;
    private Locale locale;
    private String charSet;
    private String contentType = "text/html";
    private String redirectURI;
    private int statusCode = 200;
    private Vector errors = new Vector();
    private Hashtable jndiContexts;
    private ServerData serverData;
    private String remoteAddr;
    private String remoteHost;
    private String userAgent;
    private String stackTrace;
    private Throwable stackTraceException;
    private Hashtable varDebug = new Hashtable();

    public static User getUserFromSession(HttpSession session) {
        try {
            return (User)session.getValue("turbine.user");
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean removeUserFromSession(HttpSession session) {
        try {
            session.removeValue("turbine.user");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static Locale getDefaultLocale() {
        if (!defaultLocaleChecked) {
            String lang = TurbineResources.getString("locale.default.language");
            String country = TurbineResources.getString("locale.default.country");
            defaultLocale = lang != null ? (country != null ? new Locale(lang, country) : new Locale(lang, "")) : (country != null ? new Locale("", country) : null);
            defaultLocaleChecked = true;
        }
        return defaultLocale;
    }

    protected String getDefaultCharSet() {
        String charset;
        if (!defaultCharSetChecked) {
            defaultCharSet = TurbineResources.getString("locale.default.charset");
            defaultCharSetChecked = true;
        }
        if ((charset = defaultCharSet) == null) {
            Locale locale = this.locale;
            if (locale == null) {
                locale = DefaultTurbineRunData.getDefaultLocale();
            }
            if (locale != null && !locale.equals(Locale.US)) {
                charset = TurbineMimeTypes.getCharSet(locale);
            }
        }
        return charset;
    }

    public void recycle() {
        super.recycle();
    }

    public void dispose() {
        this.parameters = null;
        this.cookies = null;
        this.req = null;
        this.res = null;
        this.session = null;
        this.config = null;
        this.servletContext = null;
        this.acl = null;
        this.pageSet = false;
        this.page = null;
        this.action = null;
        this.layout = null;
        this.screen = null;
        this.templateEncoding = null;
        this.templateInfo = null;
        this.message = null;
        this.messages = null;
        this.user = null;
        this.title = null;
        this.outSet = false;
        this.out = null;
        this.locale = null;
        this.charSet = null;
        this.contentType = "text/html";
        this.redirectURI = null;
        this.statusCode = 200;
        this.errors.clear();
        this.jndiContexts = null;
        this.serverData = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.userAgent = null;
        this.stackTrace = null;
        this.stackTraceException = null;
        this.varDebug.clear();
        super.dispose();
    }

    public ParameterParser getParameters() {
        if (this.parameters != null && this.parameters.getRequest() != this.req) {
            this.parameters.setRequest(this.req);
        }
        return this.parameters;
    }

    public CookieParser getCookies() {
        if (this.cookies != null && this.cookies.getRunData() != this) {
            this.cookies.setRunData(this);
        }
        return this.cookies;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AccessControlList getACL() {
        return this.acl;
    }

    public void setACL(AccessControlList acl) {
        this.acl = acl;
    }

    public boolean isPageSet() {
        return this.pageSet;
    }

    public Document getPage() {
        this.pageSet = true;
        if (this.page == null) {
            this.page = new Document();
        }
        return this.page;
    }

    public boolean hasAction() {
        return this.action != null && this.action.length() > 0 && !this.action.equalsIgnoreCase("null");
    }

    public String getAction() {
        return this.hasAction() ? this.action : "";
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getLayout() {
        if (this.layout == null) {
            this.layout = TurbineTemplate.getDefaultLayoutName(this);
            if (this.layout == null) {
                this.layout = "DefaultLayout";
            }
        }
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayoutTemplate() {
        return this.getTemplateInfo().getLayoutTemplate();
    }

    public void setLayoutTemplate(String layout) {
        this.getTemplateInfo().setLayoutTemplate(layout);
    }

    public boolean hasScreen() {
        return this.screen != null && this.screen.length() > 0;
    }

    public String getScreen() {
        return this.hasScreen() ? this.screen : "";
    }

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public String getScreenTemplate() {
        return this.getTemplateInfo().getScreenTemplate();
    }

    public void setScreenTemplate(String screen) {
        this.getTemplateInfo().setScreenTemplate(screen);
    }

    public String getTemplateEncoding() {
        return this.templateEncoding;
    }

    public void setTemplateEncoding(String encoding) {
        this.templateEncoding = encoding;
    }

    public TemplateInfo getTemplateInfo() {
        if (this.templateInfo == null) {
            this.templateInfo = new TemplateInfo(this);
        }
        return this.templateInfo;
    }

    public boolean hasMessage() {
        return this.message != null && this.message.toString().length() > 0;
    }

    public String getMessage() {
        return this.message == null ? null : this.message.toString();
    }

    public void setMessage(String msg) {
        this.message = new StringElement(msg);
    }

    public void addMessage(String msg) {
        this.addMessage((Element)new StringElement(msg));
    }

    public StringElement getMessageAsHTML() {
        return this.message;
    }

    public void setMessage(Element msg) {
        this.message = new StringElement(msg);
    }

    public void addMessage(Element msg) {
        if (msg != null) {
            if (this.message != null) {
                this.message.addElement(msg);
            } else {
                this.message = new StringElement(msg);
            }
        }
    }

    public void unsetMessage() {
        this.message = null;
    }

    public FormMessages getMessages() {
        if (this.messages == null) {
            this.messages = new FormMessages();
        }
        return this.messages;
    }

    public void setMessages(FormMessages msgs) {
        this.messages = msgs;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean userExists() {
        this.user = this.getUserFromSession();
        return this.user != null;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUserFromSession() {
        return DefaultTurbineRunData.getUserFromSession(this.session);
    }

    public boolean removeUserFromSession() {
        return DefaultTurbineRunData.removeUserFromSession(this.session);
    }

    public boolean isOutSet() {
        return this.outSet;
    }

    public PrintWriter getOut() throws IOException {
        if (this.out == null) {
            this.setOut(this.res.getWriter());
        }
        this.pageSet = false;
        this.outSet = true;
        return this.out;
    }

    public void declareDirectResponse() {
        this.outSet = true;
        this.pageSet = false;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale == null && (locale = DefaultTurbineRunData.getDefaultLocale()) == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getCharSet() {
        String charset = this.charSet;
        if (charset == null) {
            charset = this.getDefaultCharSet();
        }
        return charset;
    }

    public void setCharSet(String charset) {
        this.charSet = charset;
    }

    public String getContentType() {
        String ct = this.contentType;
        if (ct != null) {
            String charset = this.charSet;
            if (charset == null) {
                if (ct.startsWith("text/") && (charset = this.getDefaultCharSet()) != null) {
                    ct = ct + "; charset=" + charset;
                }
            } else {
                ct = ct + "; charset=" + charset;
            }
        } else {
            ct = "";
        }
        return ct;
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }

    public String getRedirectURI() {
        return this.redirectURI == null ? "" : this.redirectURI;
    }

    public void setRedirectURI(String ruri) {
        this.redirectURI = ruri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int sc) {
        this.statusCode = sc;
    }

    public SystemError[] getSystemErrors() {
        Object[] result = new SystemError[this.errors.size()];
        this.errors.copyInto(result);
        return result;
    }

    public void setSystemError(SystemError err) {
        this.errors.addElement(err);
    }

    public Hashtable getJNDIContexts() {
        if (this.jndiContexts == null) {
            this.jndiContexts = new Hashtable();
        }
        return this.jndiContexts;
    }

    public void setJNDIContexts(Hashtable contexts) {
        this.jndiContexts = contexts;
    }

    public String getServerScheme() {
        return this.getServerData().getServerScheme();
    }

    public String getServerName() {
        return this.getServerData().getServerName();
    }

    public int getServerPort() {
        return this.getServerData().getServerPort();
    }

    public String getContextPath() {
        return this.getServerData().getContextPath();
    }

    public String getScriptName() {
        return this.getServerData().getScriptName();
    }

    public ServerData getServerData() {
        return this.serverData;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.getRequest().getRemoteAddr();
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.getRequest().getRemoteHost();
        }
        return this.remoteHost;
    }

    public String getUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = this.getRequest().getHeader("User-Agent");
        }
        return this.userAgent;
    }

    public void populate() {
        this.user = this.getUserFromSession();
        if (this.user != null) {
            this.user.setLastAccessDate();
            this.user.incrementAccessCounter();
            this.user.incrementAccessCounterForSession();
        }
    }

    public void save() {
        this.session.putValue("turbine.user", (Object)this.user);
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Throwable getStackTraceException() {
        return this.stackTraceException;
    }

    public void setStackTrace(String trace, Throwable exp) {
        this.stackTrace = trace;
        this.stackTraceException = exp;
    }

    public Hashtable getVarDebug() {
        return this.varDebug;
    }

    public ParameterParser getParameterParser() {
        return this.parameters;
    }

    public void setParameterParser(ParameterParser parser) {
        this.parameters = parser;
    }

    public CookieParser getCookieParser() {
        return this.cookies;
    }

    public void setCookieParser(CookieParser parser) {
        this.cookies = parser;
    }

    public void setRequest(HttpServletRequest req) {
        this.req = req;
    }

    public void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    public void setSession(HttpSession sess) {
        this.session = sess;
    }

    public void setServletConfig(ServletConfig config) {
        this.config = config;
        this.servletContext = config == null ? null : config.getServletContext();
    }

    public void setServerData(ServerData serverData) {
        this.serverData = serverData;
    }

    protected void setOut(PrintWriter out) {
        this.out = out;
    }

    protected void setServerScheme(String ss) {
        this.getServerData().setServerScheme(ss);
    }

    protected void setServerName(String sn) {
        this.getServerData().setServerName(sn);
    }

    protected void setServerPort(int port) {
        this.getServerData().setServerPort(port);
    }

    protected void setContextPath(String cp) {
        this.getServerData().setContextPath(cp);
    }

    protected void setScriptName(String sn) {
        this.getServerData().setScriptName(sn);
    }
}

