#!/usr/bin/env python3

# Written by Patrick Avery - 2017
# Description: Searches through Open Babel's space-groups.txt file for a list
# of hall symbols and prints out the transforms of each hall symbol (in order)
# in a C++-friendly format. You can then run clang-format on it to fix lines
# longer than 80 characters.

# To use: copy the Open Babel space-groups.txt to the current directory and
# run this script. You can also uncomment out the block-commented section
# if you also wish to look up hall symbols from Avogadro2's spacegroupdata.h
# file.

# Uncomment this next section to generate hall symbols from 'spacegroupdata.h'
# located in avogadro/core if the current ones need updating
"""
import sys

with open('spacegroupdata.h', 'r') as rf:
  spgData = rf.read().split('\n')

hallSymbols = []
for i, line in enumerate(spgData):
  if 'space_group_hall_symbol' in line:
    while spgData[i].strip():
      hallSymbols.append(spgData[i].split('"')[1].replace('=', '"'))
      i += 1
    break

for hallSymbol in hallSymbols:
  print("  '" + hallSymbol + "',")

sys.exit()
"""

# These are cached hall symbols we use for Avogadro2
hallSymbols = [ \
  '',
  'P 1',
  '-P 1',
  'P 2y',
  'P 2',
  'P 2x',
  'P 2yb',
  'P 2c',
  'P 2xa',
  'C 2y',
  'A 2y',
  'I 2y',
  'A 2',
  'B 2',
  'I 2',
  'B 2x',
  'C 2x',
  'I 2x',
  'P -2y',
  'P -2',
  'P -2x',
  'P -2yc',
  'P -2yac',
  'P -2ya',
  'P -2a',
  'P -2ab',
  'P -2b',
  'P -2xb',
  'P -2xbc',
  'P -2xc',
  'C -2y',
  'A -2y',
  'I -2y',
  'A -2',
  'B -2',
  'I -2',
  'B -2x',
  'C -2x',
  'I -2x',
  'C -2yc',
  'A -2yac',
  'I -2ya',
  'A -2ya',
  'C -2ybc',
  'I -2yc',
  'A -2a',
  'B -2bc',
  'I -2b',
  'B -2b',
  'A -2ac',
  'I -2a',
  'B -2xb',
  'C -2xbc',
  'I -2xc',
  'C -2xc',
  'B -2xbc',
  'I -2xb',
  '-P 2y',
  '-P 2',
  '-P 2x',
  '-P 2yb',
  '-P 2c',
  '-P 2xa',
  '-C 2y',
  '-A 2y',
  '-I 2y',
  '-A 2',
  '-B 2',
  '-I 2',
  '-B 2x',
  '-C 2x',
  '-I 2x',
  '-P 2yc',
  '-P 2yac',
  '-P 2ya',
  '-P 2a',
  '-P 2ab',
  '-P 2b',
  '-P 2xb',
  '-P 2xbc',
  '-P 2xc',
  '-P 2ybc',
  '-P 2yn',
  '-P 2yab',
  '-P 2ac',
  '-P 2n',
  '-P 2bc',
  '-P 2xab',
  '-P 2xn',
  '-P 2xac',
  '-C 2yc',
  '-A 2yac',
  '-I 2ya',
  '-A 2ya',
  '-C 2ybc',
  '-I 2yc',
  '-A 2a',
  '-B 2bc',
  '-I 2b',
  '-B 2b',
  '-A 2ac',
  '-I 2a',
  '-B 2xb',
  '-C 2xbc',
  '-I 2xc',
  '-C 2xc',
  '-B 2xbc',
  '-I 2xb',
  'P 2 2',
  'P 2c 2',
  'P 2a 2a',
  'P 2 2b',
  'P 2 2ab',
  'P 2bc 2',
  'P 2ac 2ac',
  'P 2ac 2ab',
  'C 2c 2',
  'A 2a 2a',
  'B 2 2b',
  'C 2 2',
  'A 2 2',
  'B 2 2',
  'F 2 2',
  'I 2 2',
  'I 2b 2c',
  'P 2 -2',
  'P -2 2',
  'P -2 -2',
  'P 2c -2',
  'P 2c -2c',
  'P -2a 2a',
  'P -2 2a',
  'P -2 -2b',
  'P -2b -2',
  'P 2 -2c',
  'P -2a 2',
  'P -2b -2b',
  'P 2 -2a',
  'P 2 -2b',
  'P -2b 2',
  'P -2c 2',
  'P -2c -2c',
  'P -2a -2a',
  'P 2c -2ac',
  'P 2c -2b',
  'P -2b 2a',
  'P -2ac 2a',
  'P -2bc -2c',
  'P -2a -2ab',
  'P 2 -2bc',
  'P 2 -2ac',
  'P -2ac 2',
  'P -2ab 2',
  'P -2ab -2ab',
  'P -2bc -2bc',
  'P 2ac -2',
  'P 2bc -2bc',
  'P -2ab 2ab',
  'P -2 2ac',
  'P -2 -2bc',
  'P -2ab -2',
  'P 2 -2ab',
  'P -2bc 2',
  'P -2ac -2ac',
  'P 2c -2n',
  'P 2c -2ab',
  'P -2bc 2a',
  'P -2n 2a',
  'P -2n -2ac',
  'P -2ac -2n',
  'P 2 -2n',
  'P -2n 2',
  'P -2n -2n',
  'C 2 -2',
  'A -2 2',
  'B -2 -2',
  'C 2c -2',
  'C 2c -2c',
  'A -2a 2a',
  'A -2 2a',
  'B -2 -2b',
  'B -2b -2',
  'C 2 -2c',
  'A -2a 2',
  'B -2b -2b',
  'A 2 -2',
  'B 2 -2',
  'B -2 2',
  'C -2 2',
  'C -2 -2',
  'A -2 -2',
  'A 2 -2c',
  'B 2 -2c',
  'B -2c 2',
  'C -2b 2',
  'C -2b -2b',
  'A -2c -2c',
  'A 2 -2a',
  'B 2 -2b',
  'B -2b 2',
  'C -2c 2',
  'C -2c -2c',
  'A -2a -2a',
  'A 2 -2ac',
  'B 2 -2bc',
  'B -2bc 2',
  'C -2bc 2',
  'C -2bc -2bc',
  'A -2ac -2ac',
  'F 2 -2',
  'F -2 2',
  'F -2 -2',
  'F 2 -2d',
  'F -2d 2',
  'F -2d -2d',
  'I 2 -2',
  'I -2 2',
  'I -2 -2',
  'I 2 -2c',
  'I -2a 2',
  'I -2b -2b',
  'I 2 -2a',
  'I 2 -2b',
  'I -2b 2',
  'I -2c 2',
  'I -2c -2c',
  'I -2a -2a',
  '-P 2 2',
  'P 2 2 -1n',
  '-P 2ab 2bc',
  '-P 2 2c',
  '-P 2a 2',
  '-P 2b 2b',
  'P 2 2 -1ab',
  '-P 2ab 2b',
  'P 2 2 -1bc',
  '-P 2b 2bc',
  'P 2 2 -1ac',
  '-P 2a 2c',
  '-P 2a 2a',
  '-P 2b 2',
  '-P 2 2b',
  '-P 2c 2c',
  '-P 2c 2',
  '-P 2 2a',
  '-P 2a 2bc',
  '-P 2b 2n',
  '-P 2n 2b',
  '-P 2ab 2c',
  '-P 2ab 2n',
  '-P 2n 2bc',
  '-P 2ac 2',
  '-P 2bc 2bc',
  '-P 2ab 2ab',
  '-P 2 2ac',
  '-P 2 2bc',
  '-P 2ab 2',
  '-P 2a 2ac',
  '-P 2b 2c',
  '-P 2a 2b',
  '-P 2ac 2c',
  '-P 2bc 2b',
  '-P 2b 2ab',
  '-P 2 2ab',
  '-P 2bc 2',
  '-P 2ac 2ac',
  '-P 2ab 2ac',
  '-P 2ac 2bc',
  '-P 2bc 2ab',
  '-P 2c 2b',
  '-P 2c 2ac',
  '-P 2ac 2a',
  '-P 2b 2a',
  '-P 2a 2ab',
  '-P 2bc 2c',
  '-P 2 2n',
  '-P 2n 2',
  '-P 2n 2n',
  'P 2 2ab -1ab',
  '-P 2ab 2a',
  'P 2bc 2 -1bc',
  '-P 2c 2bc',
  'P 2ac 2ac -1ac',
  '-P 2c 2a',
  '-P 2n 2ab',
  '-P 2n 2c',
  '-P 2a 2n',
  '-P 2bc 2n',
  '-P 2ac 2b',
  '-P 2b 2ac',
  '-P 2ac 2ab',
  '-P 2bc 2ac',
  '-P 2ac 2n',
  '-P 2bc 2a',
  '-P 2c 2ab',
  '-P 2n 2ac',
  '-P 2n 2a',
  '-P 2c 2n',
  '-C 2c 2',
  '-C 2c 2c',
  '-A 2a 2a',
  '-A 2 2a',
  '-B 2 2b',
  '-B 2b 2',
  '-C 2bc 2',
  '-C 2bc 2bc',
  '-A 2ac 2ac',
  '-A 2 2ac',
  '-B 2 2bc',
  '-B 2bc 2',
  '-C 2 2',
  '-A 2 2',
  '-B 2 2',
  '-C 2 2c',
  '-A 2a 2',
  '-B 2b 2b',
  '-C 2b 2',
  '-C 2b 2b',
  '-A 2c 2c',
  '-A 2 2c',
  '-B 2 2c',
  '-B 2c 2',
  'C 2 2 -1bc',
  '-C 2b 2bc',
  'C 2 2 -1bc',
  '-C 2b 2c',
  'A 2 2 -1ac',
  '-A 2a 2c',
  'A 2 2 -1ac',
  '-A 2ac 2c',
  'B 2 2 -1bc',
  '-B 2bc 2b',
  'B 2 2 -1bc',
  '-B 2b 2bc',
  '-F 2 2',
  'F 2 2 -1d',
  '-F 2uv 2vw',
  '-I 2 2',
  '-I 2 2c',
  '-I 2a 2',
  '-I 2b 2b',
  '-I 2b 2c',
  '-I 2a 2b',
  '-I 2b 2',
  '-I 2a 2a',
  '-I 2c 2c',
  '-I 2 2b',
  '-I 2 2a',
  '-I 2c 2',
  'P 4',
  'P 4w',
  'P 4c',
  'P 4cw',
  'I 4',
  'I 4bw',
  'P -4',
  'I -4',
  '-P 4',
  '-P 4c',
  'P 4ab -1ab',
  '-P 4a',
  'P 4n -1n',
  '-P 4bc',
  '-I 4',
  'I 4bw -1bw',
  '-I 4ad',
  'P 4 2',
  'P 4ab 2ab',
  'P 4w 2c',
  'P 4abw 2nw',
  'P 4c 2',
  'P 4n 2n',
  'P 4cw 2c',
  'P 4nw 2abw',
  'I 4 2',
  'I 4bw 2bw',
  'P 4 -2',
  'P 4 -2ab',
  'P 4c -2c',
  'P 4n -2n',
  'P 4 -2c',
  'P 4 -2n',
  'P 4c -2',
  'P 4c -2ab',
  'I 4 -2',
  'I 4 -2c',
  'I 4bw -2',
  'I 4bw -2c',
  'P -4 2',
  'P -4 2c',
  'P -4 2ab',
  'P -4 2n',
  'P -4 -2',
  'P -4 -2c',
  'P -4 -2ab',
  'P -4 -2n',
  'I -4 -2',
  'I -4 -2c',
  'I -4 2',
  'I -4 2bw',
  '-P 4 2',
  '-P 4 2c',
  'P 4 2 -1ab',
  '-P 4a 2b',
  'P 4 2 -1n',
  '-P 4a 2bc',
  '-P 4 2ab',
  '-P 4 2n',
  'P 4ab 2ab -1ab',
  '-P 4a 2a',
  'P 4ab 2n -1ab',
  '-P 4a 2ac',
  '-P 4c 2',
  '-P 4c 2c',
  'P 4n 2c -1n',
  '-P 4ac 2b',
  'P 4n 2 -1n',
  '-P 4ac 2bc',
  '-P 4c 2ab',
  '-P 4n 2n',
  'P 4n 2n -1n',
  '-P 4ac 2a',
  'P 4n 2ab -1n',
  '-P 4ac 2ac',
  '-I 4 2',
  '-I 4 2c',
  'I 4bw 2bw -1bw',
  '-I 4bd 2',
  'I 4bw 2aw -1bw',
  '-I 4bd 2c',
  'P 3',
  'P 31',
  'P 32',
  'R 3',
  'P 3*',
  '-P 3',
  '-R 3',
  '-P 3*',
  'P 3 2',
  'P 3 2"',
  'P 31 2c (0 0 1)',
  'P 31 2"',
  'P 32 2c (0 0 -1)',
  'P 32 2"',
  'R 3 2"',
  'P 3* 2',
  'P 3 -2"',
  'P 3 -2',
  'P 3 -2"c',
  'P 3 -2c',
  'R 3 -2"',
  'P 3* -2',
  'R 3 -2"c',
  'P 3* -2n',
  '-P 3 2',
  '-P 3 2c',
  '-P 3 2"',
  '-P 3 2"c',
  '-R 3 2"',
  '-P 3* 2',
  '-R 3 2"c',
  '-P 3* 2n',
  'P 6',
  'P 61',
  'P 65',
  'P 62',
  'P 64',
  'P 6c',
  'P -6',
  '-P 6',
  '-P 6c',
  'P 6 2',
  'P 61 2 (0 0 -1)',
  'P 65 2 (0 0 1)',
  'P 62 2c (0 0 1)',
  'P 64 2c (0 0 -1)',
  'P 6c 2c',
  'P 6 -2',
  'P 6 -2c',
  'P 6c -2',
  'P 6c -2c',
  'P -6 2',
  'P -6c 2',
  'P -6 -2',
  'P -6c -2c',
  '-P 6 2',
  '-P 6 2c',
  '-P 6c 2',
  '-P 6c 2c',
  'P 2 2 3',
  'F 2 2 3',
  'I 2 2 3',
  'P 2ac 2ab 3',
  'I 2b 2c 3',
  '-P 2 2 3',
  'P 2 2 3 -1n',
  '-P 2ab 2bc 3',
  '-F 2 2 3',
  'F 2 2 3 -1d',
  '-F 2uv 2vw 3',
  '-I 2 2 3',
  '-P 2ac 2ab 3',
  '-I 2b 2c 3',
  'P 4 2 3',
  'P 4n 2 3',
  'F 4 2 3',
  'F 4d 2 3',
  'I 4 2 3',
  'P 4acd 2ab 3',
  'P 4bd 2ab 3',
  'I 4bd 2c 3',
  'P -4 2 3',
  'F -4 2 3',
  'I -4 2 3',
  'P -4n 2 3',
  'F -4c 2 3',
  'I -4bd 2c 3',
  '-P 4 2 3',
  'P 4 2 3 -1n',
  '-P 4a 2bc 3',
  '-P 4n 2 3',
  'P 4n 2 3 -1n',
  '-P 4bc 2bc 3',
  '-F 4 2 3',
  '-F 4c 2 3',
  'F 4d 2 3 -1d',
  '-F 4vw 2vw 3',
  'F 4d 2 3 -1cd',
  '-F 4cvw 2vw 3',
  '-I 4 2 3',
  '-I 4bd 2c 3'
]

# Open the space groups file from Open Babel
with open('space-groups.txt', 'r') as rf:
  obSpgData = rf.read().split('\n')

# Loop through the hall symbols and find each of them in the Open Babel data
transforms = []
for i, symbol in enumerate(hallSymbols):
  transforms.append('not found')
  if i == 0:
    transforms[i] = ''
    continue
  for j, line in enumerate(obSpgData):
    if symbol.strip() == line.strip():
      while 'x,y,z' not in obSpgData[j]:
        j += 1
      string = ''
      while obSpgData[j]:
        string += (obSpgData[j] + ' ')
        j += 1
      string = string[:-1]
      transforms[i] = string
      break
    if j == len(obSpgData) - 1:
      print("not found:", symbol)

# Print them out
for transform in transforms:
  string = '  "' + transform + '"'
  if transform is not transforms[-1]:
    string += ','
  print(string)
