// Copyright (c) 2009, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

class DebianPackageVersionUnitTest extends haxe.unit.TestCase
{
	public function testVersion()
	{
		var v = new DebianPackageVersion( "svn.20090212" );
        assertEquals( v.epoch, null );
        assertEquals( v.upstream, "svn.20090212" );
        assertEquals( v.debianRevision, null );
    }
	public function testEpochVersion()
	{
		var v = new DebianPackageVersion( "0:1.2+3" );
        assertEquals( v.epoch, "0" );
        assertEquals( v.upstream, "1.2+3" );
        assertEquals( v.debianRevision, null );
    }
	public function testVersionDebian()
	{
		var v = new DebianPackageVersion( "2008may-3.2~bpo5+1" );
        assertEquals( v.epoch, null );
        assertEquals( v.upstream, "2008may" );
        assertEquals( v.debianRevision, "3.2~bpo5+1" );
    }
	public function testEpochVersionDebian()
	{
		var v = new DebianPackageVersion( "2:1.2:3-23-1" );
        assertEquals( v.epoch, "2" );
        assertEquals( v.upstream, "1.2:3-23" );
        assertEquals( v.debianRevision, "1" );
    }
}
