#include <gtk/gtk.h>
#include "casilda-compositor.h"

/* Do not listen on any socket by default */
gchar *socket = NULL;
gchar *dirname;


static void
activate (GtkApplication *app, G_GNUC_UNUSED gpointer  user_data)
{
  CasildaCompositor *compositor;
  GtkWidget *window;

  window = gtk_application_window_new (app);
  gtk_window_set_title (GTK_WINDOW (window), "Nested Casilda Compositor");
  gtk_window_set_default_size (GTK_WINDOW (window), 1024, 768);

  if (socket)
    g_message ("Listening on %s", socket);
  else
    g_message ("Not listening in any socket, you can pass a socket path as parameter");

  compositor = casilda_compositor_new (socket);
  gtk_window_set_child (GTK_WINDOW (window), GTK_WIDGET (compositor));
  gtk_window_present (GTK_WINDOW (window));

  gchar *argv[2] = {
     g_build_path ("/", dirname, "compositor", NULL),
     NULL
  };

  g_message("Running %s", argv[0]);
  casilda_compositor_spawn_async (compositor, NULL, argv, NULL, G_SPAWN_DEFAULT, NULL, NULL, NULL, NULL);
}

int
main (int argc, char **argv)
{
  g_autoptr(GtkApplication) app = NULL;

  dirname = g_path_get_dirname (argv[0]);

  app = gtk_application_new ("ar.xjuan.casilda.NestedExample", G_APPLICATION_DEFAULT_FLAGS);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);

  if (argc >= 2)
    socket = argv[1];

  return g_application_run (G_APPLICATION (app), 0, NULL);
}
